/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.IOperationLog;

public class DataSourceCatalogEditPlugin
extends AbstractBasePlugIn
implements IOperationLog {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DataSourceCatalogEditPlugin.class);
    private static final String MODEL = "model";
    private static final String PARENT = "parent";
    private static final String SEQUENCE = "sequence";

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return null;
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model == null) {
            return;
        }
        long modelId = model.getLong("id");
        if (modelId == 0L) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get(MODEL);
        Object objParent = map.get(PARENT);
        this.getModel().setValue(MODEL, objModel);
        if (!"0".equals(objParent)) {
            this.getModel().setValue(PARENT, objParent);
            if (objParent == null) {
                return;
            }
            int seq = this.getCurNodeSequence(map.get(MODEL).toString(), map.get(PARENT).toString());
            this.getModel().setValue(SEQUENCE, (Object)seq);
            DynamicObject parent = (DynamicObject)this.getModel().getValue(PARENT);
            this.getModel().setValue("parenttext", (Object)parent.getString("name"));
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject parent = (DynamicObject)this.getModel().getValue(PARENT);
        this.getModel().setValue("parenttext", (Object)parent.getString("name"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.getModel().setValue("level", (Object)"1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "AdjustParamSettingPlugin_9", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f", "SchemeCatalogEditPlugin_0", "fi-bcm-formplugin", new String[]{(String)this.getModel().getValue("number")}));
        }
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter(MODEL, "=", (Object)Long.valueOf(modelId));
        QFilter parent = new QFilter(PARENT, "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_datasourcecatalog", (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && !dcs.isEmpty()) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }
}

