/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DataSourceEditPlugin
extends AbstractBasePlugIn
implements HyperLinkClickListener,
CellClickListener,
IOperationLog {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractBaseListPlugin.class);
    private static final String ctl_entryentity = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid eg = (EntryGrid)this.getView().getControl(ctl_entryentity);
        eg.addHyperClickListener((HyperLinkClickListener)this);
        eg.addCellClickListener((CellClickListener)this);
    }

    public void initialize() {
        super.initialize();
        EntryGrid grid = (EntryGrid)this.getControl(ctl_entryentity);
        grid.addPackageDataListener(this::packageData);
    }

    private void packageData(PackageDataEvent event) {
        DynamicObject model = this.getView().getModel().getDataEntity();
        if (model.getDynamicObject("parent") != null && model.getDynamicObject("parent").getLong("id") > 0L) {
            event.getNoLinkKey().add("subitem");
        }
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object iscschemeIdParam = customParams.get("iscschemeId");
        if (iscschemeIdParam == null) {
            return;
        }
        Long iscschemeId = Long.parseLong(iscschemeIdParam.toString());
        DynamicObject iscSchema = BusinessDataServiceHelper.loadSingle((Object)iscschemeId, (String)"isc_metadata_schema");
        Long catelogId = Long.parseLong(customParams.get("catelogId").toString());
        Long modelId = Long.parseLong(customParams.get("modelId").toString());
        Long parentId = Long.parseLong(customParams.get("parentId").toString());
        IDataModel model = this.getView().getModel();
        model.setValue("type", (Object)("ENTITY".equals(iscSchema.getString("type")) ? "1" : "2"));
        model.setValue("catalog", (Object)catelogId);
        model.setValue("number", (Object)iscSchema.getString("number"));
        model.setValue("name", (Object)iscSchema.getString("full_name"));
        model.setValue("tablename", (Object)iscSchema.getString("table_name"));
        model.setValue("cusname", (Object)iscSchema.getString("name"));
        model.setValue("model", (Object)modelId);
        model.setValue("iscschema", (Object)iscSchema.getLong("id"));
        model.setValue("parent", (Object)parentId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"type", "catalog", "number", "name", "tablename", "synstatus"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_sync": {
                this.syncField();
                break;
            }
        }
    }

    private void syncField() {
        try {
            IDataModel model = this.getView().getModel();
            DynamicObject iscschema = (DynamicObject)model.getValue("iscschema");
            DynamicObject iscSchema = BusinessDataServiceHelper.loadSingle((Object)iscschema.getLong("id"), (String)"isc_metadata_schema");
            DynamicObjectCollection properties = iscSchema.getDynamicObjectCollection("prop_entryentity");
            EntryGrid eg = (EntryGrid)this.getView().getControl(ctl_entryentity);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ctl_entryentity);
            if (dynamicObjectCollection.size() < properties.size()) {
                this.getModel().batchCreateNewEntryRow(ctl_entryentity, properties.size() - dynamicObjectCollection.size());
            } else if (dynamicObjectCollection.size() > properties.size()) {
                int size = dynamicObjectCollection.size() - properties.size();
                for (int i = 0; i < size; ++i) {
                    this.getModel().deleteEntryRow(ctl_entryentity, dynamicObjectCollection.size() - (i + 1));
                }
            }
            for (int i = 0; i < properties.size(); ++i) {
                this.getModel().setValue("field", (Object)((DynamicObject)properties.get(i)).getString("prop_name"), i);
                this.getModel().setValue("simpcode", (Object)((DynamicObject)properties.get(i)).getString("prop_name"), i);
                this.getModel().setValue("itemname", (Object)((DynamicObject)properties.get(i)).getString("prop_label"), i);
                this.getModel().setValue("datatype", (Object)((DynamicObject)properties.get(i)).getString("data_type"), i);
                this.getModel().setValue("basedata", (Object)"0", i);
                this.getModel().setValue("subitem", null, i);
                if ("REF".equals(((DynamicObject)properties.get(i)).getString("data_type"))) {
                    String str_schema = ((DynamicObject)properties.get(i)).getString("data_schema");
                    DynamicObject data_schema = QueryServiceHelper.queryOne((String)"isc_metadata_schema", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)str_schema)});
                    this.getModel().setValue("subitemtype", (Object)"isc_metadata_schema", i);
                    this.getModel().setValue("subitem", (Object)data_schema.getLong("id"), i);
                    this.getModel().setValue("preset", (Object)"1", i);
                } else {
                    this.getModel().setValue("subitemtype", null, i);
                    this.getModel().setValue("subitem", null, i);
                }
                this.getModel().setValue("measure", (Object)"0", i);
            }
            this.getModel().setValue("synstatus", (Object)"2");
        }
        catch (Throwable e) {
            this.getModel().setValue("synstatus", (Object)"3");
            log.error("syncField error:", e);
        }
        this.getView().updateView();
    }

    public void afterBindData(EventObject e) {
        String enable;
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"type", "catalog", "number", "name", "tablename", "synstatus"});
        if ("view".equals(this.getView().getFormShowParameter().getCustomParam("OpStatus"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_sync"});
        }
        if ("1".equals(enable = this.getModel().getDataEntity().getString("enable"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_sync"});
        }
    }

    private void initItemBind(CellClickEvent e) {
        if (!"joinfield".equals(e.getFieldKey())) {
            return;
        }
        int rowIndex = e.getRow();
        if (rowIndex < 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection objs = dataEntity.getDynamicObjectCollection(ctl_entryentity);
        DynamicObject dyn = (DynamicObject)objs.get(rowIndex);
        String subitemtype = dyn.getString("subitemtype");
        DynamicObject subitem = dyn.getDynamicObject("subitem");
        String preset = dyn.getString("preset");
        if (subitemtype == null || subitem == null || "1".equals(preset)) {
            return;
        }
        String entityNumber = "isc_metadata_schema";
        if ("bcm_bdconfig".equals(subitemtype)) {
            entityNumber = subitem.getString("number");
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String idByNumber = MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Form);
        FormMetadata taskMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
        List items = taskMeta.getItems();
        ArrayList<String> comList = new ArrayList<String>(16);
        for (ControlAp controlAp : items) {
            if (!(controlAp instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)controlAp;
            String comStr = fieldAp.getKey() + ";" + fieldAp.getName().getLocaleValue();
            comList.add(comStr);
        }
        FormShowParameter bs = new FormShowParameter();
        bs.setFormId("bcm_isdatasourcejion");
        bs.setCustomParam("comboItems", comList);
        bs.setCustomParam("rowIndex", (Object)rowIndex);
        bs.getOpenStyle().setShowType(ShowType.Modal);
        bs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addJoin"));
        this.getView().showForm(bs);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "addJoin": {
                this.addJoin(evt);
                break;
            }
        }
    }

    private void addJoin(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        this.getModel().setValue("joinfield", map.get("joinfield"));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long dataId = dataEntity.getLong("id");
        if (dataId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"DataSourceListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject dynamicObject = (DynamicObject)dataEntity.getDynamicObjectCollection(ctl_entryentity).get(rowIndex);
        String subitemtype = dynamicObject.getString("subitemtype");
        if ("isc_metadata_schema".equals(subitemtype)) {
            Long modelId = dataEntity.getDynamicObject("model").getLong("id");
            long id = dynamicObject.getDynamicObject("subitem").getLong("id");
            Long catelogId = dataEntity.getDynamicObject("catalog").getLong("id");
            this.openDataSource(id, modelId, catelogId, dataId);
        }
    }

    private void openDataSource(long id, long modelId, Long catelogId, Long dataId) {
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId("bcm_isdatasource");
        bs.setCustomParam("iscschemeId", (Object)id);
        bs.setCustomParam("modelId", (Object)modelId);
        bs.setCustomParam("catelogId", (Object)catelogId);
        bs.setCustomParam("parentId", (Object)dataId);
        bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter iscschemaQf = new QFilter("iscschema", "=", (Object)id);
        DynamicObject datasource = QueryServiceHelper.queryOne((String)"bcm_isdatasource", (String)"id", (QFilter[])new QFilter[]{modelQf, iscschemaQf});
        if (datasource != null) {
            bs.setStatus(OperationStatus.EDIT);
            bs.setPkId((Object)datasource.getLong("id"));
        } else {
            bs.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm((FormShowParameter)bs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "subitemtype": {
                this.setBasedata(e);
                break;
            }
            case "subitem": {
                this.clearJoin(e);
                break;
            }
        }
    }

    private void clearJoin(PropertyChangedArgs e) {
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        ChangeData changeData = Arrays.stream(e.getChangeSet()).findFirst().get();
        int rowIndex = changeData.getRowIndex();
        this.getModel().setValue("joinfield", null, rowIndex);
    }

    private void setBasedata(PropertyChangedArgs e) {
        if (e.getChangeSet() != null) {
            ChangeData changeData = Arrays.stream(e.getChangeSet()).findFirst().get();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(ctl_entryentity);
            if ("bcm_bdconfig".equals(changeData.getNewValue())) {
                ((DynamicObject)dys.get(changeData.getRowIndex())).set("basedata", (Object)"1");
            } else {
                ((DynamicObject)dys.get(changeData.getRowIndex())).set("basedata", (Object)"0");
            }
            this.getView().updateView(ctl_entryentity);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.checkData(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof Save) {
            OperationResult operationResult = e.getOperationResult();
            if (operationResult.isSuccess()) {
                List successPkIds = operationResult.getSuccessPkIds();
                DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_isdatasource", (String)"number, cusname", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)});
                String name = data.getString("number") + " " + data.getString("cusname");
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "AdjustParamSettingPlugin_9", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f", "SchemeCatalogEditPlugin_0", "fi-bcm-formplugin", new String[]{name}));
            } else {
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "AdjustParamSettingPlugin_9", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u5931\u8d25", "SchemeCatalogEditPlugin_0", "fi-bcm-formplugin", new String[]{""}));
            }
        }
    }

    private void checkData(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtil.isEmptyString((String)dataEntity.getString("cusname"))) {
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(ctl_entryentity);
        for (int i = 0; i < dys.size(); ++i) {
            DynamicObject dy = (DynamicObject)dys.get(i);
            if ((!StringUtil.isEmptyString((String)dy.getString("subitemtype")) || StringUtil.isEmptyString((String)dy.getString("subitem"))) && (StringUtil.isEmptyString((String)dy.getString("subitemtype")) || !StringUtil.isEmptyString((String)dy.getString("subitem")))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u6570\u636e\u6a21\u578b\u8bbe\u7f6e\u5b8c\u6574\u3002", (String)"DataSourceListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void cellClick(CellClickEvent e) {
        super.click((EventObject)e);
        this.initItemBind(e);
    }

    public void cellDoubleClick(CellClickEvent e) {
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            return;
        }
        long modelId = model.getLong("id");
        if (modelId == 0L) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }
}

