/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SearchResult;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DataSourceListPlugin
extends AbstractBaseListPlugin {
    private static final String ctl_schemecatalog = "catalog";
    private static final String ctl_billlistap = "billlistap";
    private static final String deletescheme_confirm = "deletescheme_confirm";
    private static final String deletecatalog_confirm = "deletecatalog_confirm";
    private static final String btn_addgroup = "btn_addgroup";
    private static final String btn_editgroup = "btn_editgroup";
    private static final String btn_delgroup = "btn_delgroup";
    private static final String ctl_checkbox_tree = "treecheckbox";
    private static final String SEARCH_LIST_DATA = "datalist";
    private static final String TREEFOCUS_DATA = "datafocus";
    private static final String CACHE_INIT = "CACHE_INIT";
    private static final String treeview_template = "treeviewap";
    private static final String ctl_model = "model";
    private static final String ROOT_NODE = "headnodeid";
    private static final String ROOT_NODE_ID = "rootNodeid";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String focus_node_id = "focusnodeid";

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPageCache().get(CACHE_INIT) == null) {
            FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
            fc.setBillFormId("bcm_isdatasource");
            fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u5217\u8868", (String)"DataSourceListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            this.getPageCache().put(CACHE_INIT, "false");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_addgroup, btn_editgroup, btn_delgroup);
        TreeView treeView = (TreeView)this.getControl(ctl_schemecatalog);
        final BillList billList = (BillList)this.getControl(ctl_billlistap);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addSearchClickListener(evt -> this.refreshBillList());
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                DataSourceListPlugin.this.getPageCache().put(DataSourceListPlugin.focus_node_id, evt.getNodeId().toString());
                billList.clearSelection();
                DataSourceListPlugin.this.refreshBillList();
            }
        });
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(SEARCH_LIST_DATA, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        BasedataEdit ict = (BasedataEdit)this.getControl("iscscheme");
        ict.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_add": {
                this.addDataSource();
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_usable": 
            case "btn_unusable": {
                this.setUsable(key);
                break;
            }
        }
    }

    private void setUsable(String key) {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection dy = billList.getSelectedRows();
        if (dy == null || dy.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u6570\u636e\u6e90\u518d\u64cd\u4f5c\u3002", (String)"DataSourceListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        if (StringUtil.equals((String)"btn_usable", (String)key)) {
            String errorInfo = this.getErrorInfo(LongUtil.toLong((Object)dy.get(0).getPrimaryKeyValue()));
            if (errorInfo != null) {
                this.getView().showTipNotification(errorInfo);
                return;
            }
            if (!this.isHaveMes(LongUtil.toLong((Object)dy.get(0).getPrimaryKeyValue()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u7684\u6570\u636e\u6e90\u6ca1\u6709\u6807\u8bb0\u6570\u636e\u7c7b\u578b\u7684\u5ea6\u91cf\u503c\uff0c\u8bf7\u6807\u8bb0\u5ea6\u91cf\u503c\u540e\u518d\u542f\u7528\u3002", (String)"DataSourceListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            this.updateDataSourceStatus(true, dy.get(0).getPrimaryKeyValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ISSchemeListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (StringUtil.equals((String)"btn_unusable", (String)key)) {
            this.updateDataSourceStatus(false, dy.get(0).getPrimaryKeyValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ISSchemeListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.refreshBillList();
    }

    private String getErrorInfo(Long id) {
        int synStatus = this.checkSynStatus(id);
        if (1 == synStatus) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u672a\u540c\u6b65\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"DataSourceListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (3 == synStatus) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"DataSourceListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private int checkSynStatus(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_isdatasource", (String)"id,synstatus", (QFilter[])new QFilter[]{filter});
        if (query != null) {
            return query.getInt("synstatus");
        }
        return 1;
    }

    private boolean updateDataSourceStatus(boolean isUsable, Object primaryKeyValue) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", primaryKeyValue);
        DynamicObject dos = BusinessDataServiceHelper.loadSingle((String)"bcm_isdatasource", (String)"id, enable,number,name", (QFilter[])qfBuilder.toArray());
        dos.set("enable", (Object)(isUsable ? "1" : "0"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dos});
        if (isUsable) {
            this.writeOperationLog(DataSourceListPlugin.getOperationEnable(), dos.getString("number"), dos.getString("name"), DataSourceListPlugin.getOperationStstusSuccess());
        } else {
            this.writeOperationLog(DataSourceListPlugin.getOperationDisable(), dos.getString("number"), dos.getString("name"), DataSourceListPlugin.getOperationStstusSuccess());
        }
        return true;
    }

    public static String getOperationDisable() {
        return ResManager.loadKDString((String)"\u7981\u7528", (String)"ISSchemeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationEnable() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)"ISSchemeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private boolean isHaveMes(Long id) {
        DynamicObject[] load;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isdatasource");
        boolean isHave = this.checkHaveMes(dynamicObject);
        if (isHave) {
            return true;
        }
        for (DynamicObject obj : load = BusinessDataServiceHelper.load((String)"bcm_isdatasource", (String)"entryentity.measure", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)id)})) {
            isHave = this.checkHaveMes(obj);
            if (!isHave) continue;
            return true;
        }
        return false;
    }

    private boolean checkHaveMes(DynamicObject dynamicObject) {
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryentity) {
            if (!"1".equals(obj.getString("measure"))) continue;
            return true;
        }
        return false;
    }

    public void actionDelete() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u6570\u636e\u6e90\u518d\u64cd\u4f5c\u3002", (String)"DataSourceListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ISSchemeListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(deletescheme_confirm, (IFormPlugin)this));
    }

    private void addDataSource() {
        BasedataEdit be = (BasedataEdit)this.getView().getControl("iscscheme");
        be.click();
    }

    public void refreshBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.refresh();
        billList.clearSelection();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        Long nodeId = Long.valueOf(this.getPageCache().get(focus_node_id));
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addgroup": {
                this.newTemplateCatalog(nodeId, true);
                break;
            }
            case "btn_delgroup": {
                this.delTemplateCatalog(nodeId);
                break;
            }
            case "btn_editgroup": {
                this.newTemplateCatalog(nodeId, false);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        log.info("DataSourceListPlugin__ afterCreateNewData");
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.setMulti(false);
        this.createHand();
        this.refreshTree();
        this.refreshBillList();
    }

    public void createHand() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String modelId = (String)formShowParameter.getCustomParam("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), ctl_model);
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
            billList.getFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            this.getView().getModel().setValue(ctl_model, (Object)modelId);
            this.modelChange(modelId);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    public QFilter getFilter() {
        String nodeid = this.getPageCache().get(focus_node_id);
        if (nodeid == null) {
            return new QFilter("1", "=", (Object)0);
        }
        boolean isallchild = Boolean.parseBoolean(this.getView().getModel().getValue(ctl_checkbox_tree).toString());
        QFilter qFilter = new QFilter(ctl_schemecatalog, "=", (Object)ConvertUtil.convertStrToLong((String)nodeid));
        if (isallchild) {
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            ArrayList<String> list = new ArrayList<String>(10);
            this.queryAllChildNodeList(nodeid, treeList, list);
            if (list.size() > 0) {
                qFilter.or(new QFilter(ctl_schemecatalog, "in", (Object)ConvertUtil.convertListToLong(list)));
            }
        }
        qFilter.and("parent", "=", (Object)0);
        return qFilter;
    }

    private List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parentid").equals(nodeid)) continue;
            allnodelist.add(m.get("id"));
            this.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    private void refreshTree() {
        log.info("DataSourceListPlugin__ refreshTree");
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        tree.deleteAllNodes();
        this.initTree();
    }

    private String getModelIdNotNull() {
        log.info("DataSourceListPlugin__ getModelIdNotNull");
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        log.info("DataSourceListPlugin__ getModelIdNotNull modelId\uff1a" + modelId);
        if (modelId != null && !"0".equals(modelId)) {
            return modelId;
        }
        if (this.getModel().getValue(ctl_model) != null && ((DynamicObject)this.getModel().getValue(ctl_model)).getLong("id") != 0L) {
            modelId = ((DynamicObject)this.getModel().getValue(ctl_model)).getLong("id") + "";
            log.info("DataSourceListPlugin__ getModelIdNotNull modelId1\uff1a" + modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
        }
        log.info("DataSourceListPlugin__ getModelIdNotNull modelId2\uff1a" + modelId);
        return modelId;
    }

    private void initTree() {
        log.info("DataSourceListPlugin__ initTree");
        TreeNode schemecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        String modelID = this.getModelIdNotNull();
        String entityName = "bcm_datasourcecatalog";
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter(ctl_model, "=", (Object)ConvertUtil.convertStrToLong((String)modelID));
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "id";
        Long rootid = null;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(10);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                rootid = task.getLong("id");
                this.getPageCache().put(focus_node_id, rootid.toString());
                this.getPageCache().put(ROOT_NODE_ID, rootid.toString());
            }
        } else {
            rootid = GlobalIdUtil.genGlobalLongId();
            DataSourceListPlugin.setDefaultRootNode(modelID, rootid);
            this.getPageCache().put(focus_node_id, rootid.toString());
            this.getPageCache().put(ROOT_NODE_ID, rootid.toString());
        }
        schemecatalog.setId(rootid != null ? rootid.toString() : "");
        schemecatalog.setParentid("");
        schemecatalog.setText(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u5206\u7c7b", (String)"DataSourceListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)schemecatalog, treeList, (String)(rootid != null ? rootid.toString() : ""));
        BCMTreeUtils.spreadAllNode((TreeNode)schemecatalog);
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        tree.addNode(schemecatalog);
        tree.focusNode(schemecatalog);
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)schemecatalog));
        this.getPageCache().put(ROOT_NODE_ID, schemecatalog.getId());
    }

    private void searchMember(String text) {
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>();
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<String> path = new ArrayList<String>();
            this.getTreeNodeListByText(root, hitNode, text, 999, paths, path);
            SearchResult result = null;
            if (hitNode.size() > 0) {
                result = new SearchResult(hitNode);
                result.setPath(paths);
                TreeNode next = result.next(1);
                tree.focusNode(next);
                IPageCache pageCache = this.getPageCache();
                pageCache.put(focus_node_id, next.getId());
                this.refreshBillList();
                for (String pathId : result.getPath()) {
                    tree.expand(pathId);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u5e76\u91cd\u65b0\u641c\u7d22\u3002", (String)"ISSchemeDataCollectPlugin2_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"BeginYearCarryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text, int maxLevel, List<String> paths, List<String> path) {
        ArrayList<String> temp = new ArrayList<String>(path);
        temp.add(node.getId());
        if (node.getText().contains(text)) {
            treeNodes.add(node);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            nodes.add(node);
            paths.add(String.join((CharSequence)",", temp));
        }
        if (maxLevel > 0 && node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text, maxLevel - 1, paths, temp);
            }
        }
    }

    private static void setDefaultRootNode(String modelid, Long rootid) {
        DynamicObject catalogTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datasourcecatalog");
        catalogTree.set("id", (Object)rootid);
        catalogTree.set("number", (Object)"root");
        catalogTree.set(ctl_model, (Object)ConvertUtil.convertStrToLong((String)modelid));
        catalogTree.set("name", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6e90\u5206\u7c7b", (String)"DataSourceListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        catalogTree.set("parent", (Object)0);
        catalogTree.set("longnumber", (Object)"root");
        catalogTree.set("status", (Object)"C");
        catalogTree.set("enable", (Object)1);
        catalogTree.set("modifier", (Object)RequestContext.get().getUserId());
        catalogTree.set("creator", (Object)RequestContext.get().getUserId());
        catalogTree.set("modifytime", (Object)TimeServiceHelper.now());
        catalogTree.set("createtime", (Object)TimeServiceHelper.now());
        BusinessDataWriter.save((IDataEntityType)catalogTree.getDynamicObjectType(), (Object[])new Object[]{catalogTree});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "bcm_isdatasource": {
                this.refreshBillList();
                break;
            }
            case "bcm_datasourcecatalog": {
                this.closeAddCatalog(evt);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refreshBillList();
                break;
            }
            case "model": {
                this.propertyChangedModel();
                break;
            }
            case "iscscheme": {
                this.gotoAddPage();
                break;
            }
        }
    }

    private void gotoAddPage() {
        DynamicObject iscscheme = this.getModel().getDataEntity().getDynamicObject("iscscheme");
        if (iscscheme == null) {
            return;
        }
        QFilter modelQf = new QFilter(ctl_model, "=", (Object)this.getModelId());
        QFilter iscschemaQf = new QFilter("iscschema", "=", (Object)iscscheme.getLong("id"));
        boolean isExist = QueryServiceHelper.exists((String)"bcm_isdatasource", (QFilter[])new QFilter[]{modelQf, iscschemaQf});
        if (isExist) {
            this.getPageCache().put("iscschemeId", iscscheme.getLong("id") + "");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e2d\u5df2\u5305\u542b\u6b64\u96c6\u6210\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u6dfb\u52a0\uff1f", (String)"DataSourceListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("goToPage", (IFormPlugin)this));
        } else {
            this.openDataSource(iscscheme.getLong("id"));
        }
    }

    public void propertyChangedModel() {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), ctl_model);
        if (modelId == null) {
            this.getView().getModel().setValue(ctl_model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            this.modelChange(modelId);
        }
    }

    private void openDataSource(long id) {
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId("bcm_isdatasource");
        bs.setCustomParam("iscschemeId", (Object)id);
        bs.setCustomParam("parentId", (Object)0L);
        bs.setCustomParam("modelId", (Object)this.getModelId());
        bs.setCustomParam("catelogId", (Object)this.getPageCache().get(focus_node_id));
        bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        bs.setStatus(OperationStatus.ADDNEW);
        this.getModel().setValue("iscscheme", null);
        this.getView().showForm((FormShowParameter)bs);
    }

    private void modelChange(String modelid) {
        log.info("DataSourceListPlugin__ modelChange,model:" + modelid);
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(ctl_model, "=", (Object)Long.parseLong(modelid));
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.setMulti(false);
        billList.setFilterParameter(fp);
        this.refreshTree();
        this.refreshBillList();
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "deletecatalog_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                String catalogStr = this.deletecatalog();
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "RptAdjustdListPlugin_53", "fi-bcm-formplugin", "Delete"), new OPDescMultiLangEnumBridge("%s\u5220\u9664\u6210\u529f\u3002", "ISSchemeListPlugin_56", "fi-bcm-formplugin", new String[]{catalogStr}));
                break;
            }
            case "goToPage": {
                if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                    String iscschemeId = this.getPageCache().get("iscschemeId");
                    this.openDataSource(Long.parseLong(iscschemeId));
                    break;
                }
                this.getModel().setValue("iscscheme", null);
                break;
            }
            case "deletescheme_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                this.deleteConfirm();
                break;
            }
        }
    }

    private void checkDeleteStatus(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdatasource", (String)"id,enable", (QFilter[])new QFilter[]{filter});
        DynamicObject dynamicObject = null;
        int status = 0;
        for (int i = 0; i < load.length; ++i) {
            dynamicObject = load[i];
            status = dynamicObject.getInt("enable");
            if (1 != status) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DataSourceListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void deleteConfirm() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        Object[] ids = rows.getPrimaryKeyValues();
        this.checkDeleteStatus(ids);
        ArrayList<Long> idlist = new ArrayList<Long>(10);
        for (Object id : ids) {
            idlist.add(Long.valueOf(id.toString()));
        }
        try (TXHandle tx = TX.required();){
            try {
                this.doDelete(idlist);
                this.writeOperationLog(rows, DataSourceListPlugin.getOperationStstusSuccess());
            }
            catch (Exception e) {
                this.writeOperationLog(rows, DataSourceListPlugin.getOperationStstusFail());
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void doDelete(List<Long> idlist) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                QFilter filter = new QFilter("id", "in", idlist);
                DeleteServiceHelper.delete((String)"bcm_isdatasource", (QFilter[])new QFilter[]{filter});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    private void writeOperationLog(ListSelectedRowCollection rows, String status) {
        for (int i = 0; i < rows.size(); ++i) {
            this.writeOperationLog(DataSourceListPlugin.getOperationDel(), rows.get(i).getNumber(), rows.get(i).getName(), status);
        }
    }

    public static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ISSchemeListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"ISSchemeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void writeLog(String opName, String opDescriotion, String bizEntityNumber) {
    }

    public String deletecatalog() {
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        Map map = tree.getTreeState().getFocusNode();
        Long nodeId = LongUtil.toLong(map.get("id"));
        QFilter filter = new QFilter("id", "in", this.getTempIds(nodeId));
        String catalogStr = this.getCatalogStr(filter);
        try (TXHandle tx = TX.required();){
            try {
                BusinessDataWriter.delete((String)"bcm_datasourcecatalog", (QFilter[])new QFilter[]{filter});
                filter = new QFilter(ctl_schemecatalog, "=", (Object)nodeId);
                DynamicObjectCollection dyn_ids = QueryServiceHelper.query((String)"bcm_isdatasource", (String)"id", (QFilter[])new QFilter[]{filter});
                if (dyn_ids != null && dyn_ids.size() > 0) {
                    ArrayList ids = new ArrayList(10);
                    dyn_ids.forEach(dyn -> ids.add(dyn.getLong("id")));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
        this.refreshTree();
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return catalogStr;
    }

    private List<Long> getTempIds(Long nodeId) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        QFilter filter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection schemecatalogs = QueryServiceHelper.query((String)"bcm_datasourcecatalog", (String)"id,parent", (QFilter[])new QFilter[]{filter});
        Map<Long, DynamicObject> idDys = schemecatalogs.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        schemecatalogs.forEach(e -> {
            if (this.isParent((DynamicObject)e, nodeId, idDys)) {
                ids.add(e.getLong("id"));
            }
        });
        return ids;
    }

    private boolean isParent(DynamicObject e, Long nodeId, Map<Long, DynamicObject> idDys) {
        while (e != null) {
            if (e.getLong("id") == nodeId.longValue()) {
                return true;
            }
            e = idDys.get(e.getLong("parent"));
        }
        return false;
    }

    private String getCatalogStr(QFilter filter) {
        DynamicObject[] load;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bcm_datasourcecatalog", (String)"name", (QFilter[])new QFilter[]{filter})) {
            sb.append(dynamicObject.getString("name"));
        }
        return sb.toString();
    }

    public void closeAddCatalog(ClosedCallBackEvent evt) {
        JSONArray ids;
        JSONArray jSONArray = ids = evt.getReturnData() == null ? null : new JSONArray((List)evt.getReturnData());
        if (ids != null && ids.size() > 0) {
            this.refreshTree();
            String nodeid = ids.get(0).toString();
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            for (Map m : treeList) {
                if (!nodeid.equals(m.get("id"))) continue;
                TreeNode node = new TreeNode((String)m.get("parentid"), (String)m.get("id"), (String)m.get("name"));
                ((TreeView)this.getControl(ctl_schemecatalog)).focusNode(node);
                this.getPageCache().put(focus_node_id, nodeid);
            }
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ISSchemeListPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void newTemplateCatalog(Long nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(ctl_model, this.getModelIdNotNull());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_datasourcecatalog");
        if (isAddNew) {
            Long id = nodeId;
            if (!nodeId.toString().equals(this.getPageCache().get(ROOT_NODE_ID))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5728\u6839\u8282\u70b9\u4e0a\u65b0\u589e\u5206\u7c7b\u3002", (String)"DataSourceListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                params.put("parent", id);
                this.showForm("bcm_datasourcecatalog", params, closeCallBack, ShowType.Modal, 0L);
            }
        } else if (nodeId.toString().equals(this.getPageCache().get(ROOT_NODE_ID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ISSchemeListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.showForm("bcm_datasourcecatalog", params, closeCallBack, ShowType.Modal, nodeId);
        }
    }

    private boolean checkIsHasDataSource(Long nodeId) {
        List<Long> ids = this.getTempIds(nodeId);
        QFilter filter = new QFilter(ctl_schemecatalog, "in", ids);
        DynamicObject dyn_ids = QueryServiceHelper.queryOne((String)"bcm_isdatasource", (String)"id", (QFilter[])new QFilter[]{filter});
        return dyn_ids != null;
    }

    public void delTemplateCatalog(Long nodeId) {
        if (nodeId.toString().equals(this.getPageCache().get(ROOT_NODE_ID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ISSchemeListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkIsHasDataSource(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u4e0b\u5b58\u5728\u96c6\u6210\u6570\u636e\u6e90\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DataSourceListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u8be5\u6570\u636e\u6e90\u5206\u7c7b\uff1f", (String)"DataSourceListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(deletecatalog_confirm, (IFormPlugin)this));
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, Long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        Long selectRowId = (Long)currentRow.getPrimaryKeyValue();
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId("bcm_isdatasource");
        bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long modelId = this.getModelId();
        if (!MemberPermHelper.isModelManager((Long)modelId)) {
            int is = BcmBasePluginUtil.checkPermission(this.getUserId(), modelId, AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "bcm_schemedatasource", "47156aff000000ac");
            if (is == 0) {
                bs.setCustomParam("OpStatus", (Object)"view");
                bs.setStatus(OperationStatus.VIEW);
            } else {
                bs.setStatus(OperationStatus.EDIT);
            }
        } else {
            bs.setStatus(OperationStatus.EDIT);
        }
        bs.setPkId((Object)selectRowId);
        this.getView().showForm((FormShowParameter)bs);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "iscscheme": {
                ArrayList<QFilter> qfList = new ArrayList<QFilter>();
                qfList.add(new QFilter("type", "in", (Object)new String[]{"ENTITY", "TABLE"}));
                evt.setCustomQFilters(qfList);
                break;
            }
        }
    }
}

