/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ArrayListMultimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.intergration.scheme.BCMImportDataHandle;

final class DimComImportDataHandle
extends BCMImportDataHandle {
    private List<Map<?, ?>> srcDimObjectList = null;
    private List<Map<?, ?>> targetDimObjectList = null;
    private Map<String, String> srcTagIndexMapping = null;
    private Map<String, Map<?, ?>> srcDimObjectNameMap = null;
    private ArrayListMultimap<String, String> srcNumberEntitys = null;
    private ArrayListMultimap<String, String> targetNumberEntitys = null;
    private JSONArray title = null;
    private TreeMap<String, DynamicObject> accountCache = null;

    public DimComImportDataHandle(IFormView formView, IDataModel dataModel, JSONArray excelData, Map<String, Object> custom) {
        super(formView, dataModel, excelData, custom);
        this.srcDimObjectList = (List)custom.get("source");
        this.targetDimObjectList = (List)custom.get("target");
        this.srcTagIndexMapping = (Map)custom.get("sourceTargetIndex");
        this.srcNumberEntitys = ArrayListMultimap.create();
        this.targetNumberEntitys = ArrayListMultimap.create();
        if (excelData.size() > 2) {
            this.title = excelData.getJSONArray(2);
        }
        this.accountCache = new TreeMap();
        this.srcDimObjectNameMap = this.srcDimObjectList.stream().collect(Collectors.toMap(v -> (String)v.get("name"), v -> v));
    }

    @Override
    protected boolean validate() {
        if (this.excelData.size() < 3) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u540e\u91cd\u8bd5\u3002", (String)"DimCombMappingWelkinPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.title.size() != 3 + this.srcDimObjectList.size() * 2 + this.targetDimObjectList.size() * 2 + 3) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u540e\u91cd\u8bd5\u3002", (String)"DimCombMappingWelkinPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected void fillData() {
        DynamicObjectCollection entryRow = this.dataModel.getEntryEntity("entryentity");
        int rowCount = entryRow.size();
        this.dataModel.batchCreateNewEntryRow("entryentity", this.excelData.size() - 3);
        int s = 5;
        for (int rowIndex = 3; rowIndex < this.excelData.size(); ++rowIndex) {
            JSONArray rowData = this.excelData.getJSONArray(rowIndex);
            this.handlePreColumn(rowCount, rowData);
            this.handleAccount(rowData, rowCount);
            this.handleMappingColumn(s, rowData, rowCount);
            this.handleFloatItem(rowData, rowCount);
            ++rowCount;
        }
        this.formView.updateView("entryentity");
        this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6210\u529f", (String)"DimCombMappingWelkinPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void handleAccount(JSONArray rowData, int rowIndex) {
        String titleName = null;
        String number = null;
        String colField = null;
        if (3 < rowData.size()) {
            titleName = this.title.getString(3);
            StringBuilder idStr = new StringBuilder();
            StringBuilder numberStr = new StringBuilder();
            StringBuilder nameStr = new StringBuilder();
            number = rowData.getString(3);
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                String plusminusStr;
                switch (plusminusStr = rowData.getString(2)) {
                    case "\u7b49\u4e8e": {
                        DynamicObject temp = this.accountCache.get(number.trim());
                        if (temp == null) break;
                        idStr.append(temp.getString("id"));
                        numberStr.append(temp.getString("number"));
                        nameStr.append(temp.getString("name"));
                        break;
                    }
                    case "\u533a\u95f4": {
                        String[] split = number.split(";");
                        DynamicObject tempF2 = this.accountCache.get(split[0].trim());
                        DynamicObject tempS2 = this.accountCache.get(split[1].trim());
                        if (tempF2 == null || tempS2 == null) break;
                        idStr.append(tempF2.get("id")).append(';').append(tempS2.get("id"));
                        numberStr.append(tempF2.get("number")).append(';').append(tempS2.get("number"));
                        nameStr.append(tempF2.get("name")).append('-').append(tempS2.get("name"));
                        break;
                    }
                    case "\u76f8\u4f3c": {
                        String numberTemp = number;
                        DynamicObject[] tempLike = new DynamicObject[1];
                        this.accountCache.forEach((k, v) -> {
                            if (k.contains(numberTemp.trim())) {
                                tempLike[0] = v;
                                return;
                            }
                        });
                        if (tempLike[0] == null) break;
                        idStr.append(tempLike[0].getString("id"));
                        numberStr.append(tempLike[0].getString("number")).append('*');
                        nameStr.append(tempLike[0].getString("name")).append('*');
                        break;
                    }
                    case "\u5305\u542b": {
                        String[] contains;
                        for (String con : contains = number.split(",")) {
                            DynamicObject tempCon = this.accountCache.get(con);
                            if (tempCon == null) continue;
                            idStr.append(tempCon.getString("id")).append(';');
                            numberStr.append(tempCon.getString("number")).append(';');
                            nameStr.append(tempCon.getString("name")).append(';');
                        }
                        if (idStr.length() <= 0) break;
                        idStr.replace(idStr.lastIndexOf(";"), idStr.lastIndexOf(";") + 1, "");
                        numberStr.replace(numberStr.lastIndexOf(";"), numberStr.lastIndexOf(";") + 1, "");
                        nameStr.replace(nameStr.lastIndexOf(";"), nameStr.lastIndexOf(";") + 1, "");
                    }
                }
                if (idStr.length() > 0) {
                    colField = titleName;
                    String sub = colField.substring(6);
                    this.dataModel.setValue("srcdimid" + sub, (Object)idStr.toString(), rowIndex);
                    this.dataModel.setValue("srcdimnumber" + sub, (Object)numberStr.toString(), rowIndex);
                    this.dataModel.setValue(colField, (Object)nameStr.toString(), rowIndex);
                }
            }
        }
    }

    private void handleFloatItem(JSONArray jsonArray2, int rowIndex) {
        String text;
        Object value;
        String floatItem;
        int floatIndex = this.title.size() - 3;
        int size = jsonArray2.size();
        if (size > floatIndex) {
            boolean isFloat = ResManager.loadKDString((String)"\u662f", (String)"DimCombMappingWelkinPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(jsonArray2.getString(floatIndex));
            this.dataModel.setValue("isfloat", (Object)isFloat, rowIndex);
            if (!isFloat) {
                return;
            }
        }
        if (size > ++floatIndex && StringUtils.isNotEmpty((CharSequence)(floatItem = jsonArray2.getString(floatIndex)))) {
            Optional<Map<?, ?>> ofNullable = Optional.ofNullable(this.srcDimObjectNameMap.get(floatItem));
            value = ofNullable.isPresent() ? ofNullable.get().get("id") : null;
            this.dataModel.setValue("floatitem", value, rowIndex);
        }
        if (size > ++floatIndex && StringUtils.isNotEmpty((CharSequence)(text = jsonArray2.getString(floatIndex)))) {
            Optional<Map<?, ?>> findFirst = Optional.ofNullable(this.srcDimObjectNameMap.get(text));
            value = findFirst.isPresent() ? findFirst.get().get("id") : null;
            this.dataModel.setValue("textspread", value, rowIndex);
        }
    }

    private void handleMappingColumn(int s, JSONArray rowData, int rowIndex) {
        DynamicObject tempObj;
        String sub;
        int i;
        Map<?, ?> dimObject = null;
        String titleName = null;
        String number = null;
        Map tempCache = null;
        String colField = null;
        boolean hasValue = false;
        for (i = 1; i < this.srcDimObjectList.size(); ++i) {
            dimObject = this.srcDimObjectList.get(i);
            if (s < rowData.size()) {
                titleName = this.title.getString(s);
                number = rowData.getString(s);
                if (StringUtils.isNotEmpty((CharSequence)number)) {
                    tempCache = (Map)this.dataCache.get(dimObject.get("membermodel"));
                    colField = titleName;
                    sub = colField.substring(6);
                    if (tempCache != null && (tempObj = (DynamicObject)tempCache.get(number)) != null) {
                        hasValue = true;
                        this.dataModel.setValue("srcdimid" + sub, tempObj.get("id"), rowIndex);
                        this.dataModel.setValue("srcdimnumber" + sub, tempObj.get("number"), rowIndex);
                        this.dataModel.setValue(colField, (Object)tempObj.getString("name"), rowIndex);
                    }
                    if (!hasValue && number.contains("DefaultAll")) {
                        this.dataModel.setValue("srcdimid" + sub, (Object)GlobalIdUtil.genGlobalLongId(), rowIndex);
                        this.dataModel.setValue("srcdimnumber" + sub, (Object)(dimObject.get("number") + "DefaultAll"), rowIndex);
                        this.dataModel.setValue(colField, dimObject.get("name"), rowIndex);
                    }
                }
            }
            hasValue = false;
            s += 2;
        }
        for (i = 0; i < this.targetDimObjectList.size(); ++i) {
            dimObject = this.targetDimObjectList.get(i);
            if (s < rowData.size()) {
                titleName = this.title.getString(s);
                number = rowData.getString(s);
                if (StringUtils.isNotEmpty((CharSequence)number)) {
                    tempCache = (Map)this.dataCache.get(dimObject.get("entitynumber"));
                    colField = titleName;
                    sub = colField.substring(6);
                    if (tempCache != null && (tempObj = (DynamicObject)tempCache.get(number)) != null) {
                        hasValue = true;
                        this.dataModel.setValue("tagdimid" + sub, tempObj.get("id"), rowIndex);
                        this.dataModel.setValue("tagdimnumber" + sub, tempObj.get("number"), rowIndex);
                        this.dataModel.setValue(colField, tempObj.get("name"), rowIndex);
                    }
                    if (!hasValue && number.contains("DefaultAll")) {
                        this.dataModel.setValue("tagdimid" + sub, (Object)GlobalIdUtil.genGlobalLongId(), rowIndex);
                        Map<?, ?> map = this.srcDimObjectList.get(Integer.parseInt(this.srcTagIndexMapping.get("" + (i + 1))) - 1);
                        this.dataModel.setValue("tagdimnumber" + sub, (Object)(dimObject.get("number") + "DefaultAll"), rowIndex);
                        String name = String.format(ResManager.loadKDString((String)"%1$s%2$s\u6620\u5c04", (String)"DimCombMappingWelkinPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[]{map.get("name"), dimObject.get("name")}), new Object[0]);
                        this.dataModel.setValue(colField, (Object)name, rowIndex);
                    }
                }
            }
            hasValue = false;
            s += 2;
        }
    }

    private void handlePreColumn(int rowCount, JSONArray rowData) {
        String plusminusStr;
        this.dataModel.setValue("group", rowData.get(0), rowCount);
        this.dataModel.setValue("plusminus", (Object)("+".equals(rowData.getString(1)) ? "0" : "1"), rowCount);
        switch (plusminusStr = rowData.getString(2)) {
            case "\u7b49\u4e8e": {
                plusminusStr = "1";
                break;
            }
            case "\u533a\u95f4": {
                plusminusStr = "2";
                break;
            }
            case "\u76f8\u4f3c": {
                plusminusStr = "3";
                break;
            }
            case "\u5305\u542b": {
                plusminusStr = "4";
                break;
            }
            default: {
                plusminusStr = "1";
            }
        }
        this.dataModel.setValue("relation", (Object)plusminusStr, rowCount);
    }

    @Override
    protected void preData() {
        String number = "";
        ArrayListMultimap filterBuildMap = ArrayListMultimap.create();
        Map<?, ?> dimInfo = null;
        JSONArray rowData = null;
        String plusminusStr = null;
        int s = 5;
        for (int rowIndex = 3; rowIndex < this.excelData.size(); ++rowIndex) {
            List list;
            int i;
            rowData = this.excelData.getJSONArray(rowIndex);
            plusminusStr = rowData.get(2).toString();
            number = rowData.getString(3);
            if (!StringUtils.isEmpty((CharSequence)number)) {
                filterBuildMap.put((Object)plusminusStr, (Object)rowData.getString(3));
            }
            for (i = 1; i < this.srcDimObjectList.size(); ++i) {
                if (s < rowData.size()) {
                    String memberModel;
                    dimInfo = this.srcDimObjectList.get(i);
                    number = rowData.getString(s);
                    if (!(StringUtils.isEmpty((CharSequence)number) || (list = this.srcNumberEntitys.get((Object)(memberModel = (String)dimInfo.get("membermodel")))) != null && list.contains(number))) {
                        this.srcNumberEntitys.put((Object)memberModel, (Object)number);
                    }
                }
                s += 2;
            }
            for (i = 0; i < this.targetDimObjectList.size(); ++i) {
                dimInfo = this.targetDimObjectList.get(i);
                String entityNumber = (String)dimInfo.get("entitynumber");
                if (!(s >= rowData.size() || StringUtils.isEmpty((CharSequence)(number = rowData.getString(s))) || (list = this.targetNumberEntitys.get((Object)entityNumber)) != null && list.contains(number))) {
                    this.targetNumberEntitys.put((Object)entityNumber, (Object)number);
                }
                s += 2;
            }
            s = 5;
        }
        Long model = (Long)this.custom.get("model");
        this.queryAccount((ArrayListMultimap<String, String>)filterBuildMap, model);
        this.srcNumberEntitys.keys().forEach(k -> {
            QFilter[] qfilter = new QFilter[]{new QFilter("number", "in", (Object)this.srcNumberEntitys.get(k)), new QFilter("model", "=", (Object)model)};
            DynamicObjectCollection srcobjs = QueryServiceHelper.query((String)k, (String)"id, number, name", (QFilter[])qfilter);
            HashMap map = new HashMap();
            srcobjs.forEach(v -> map.put(v.getString("number"), v));
            this.dataCache.put(k, map);
        });
        Long srcSysId = (Long)this.custom.get("srcSysId");
        String typeId = "";
        this.targetNumberEntitys.keySet().forEach(k -> {
            QFilter[] qfilter = null;
            qfilter = "ds_asstact".equals(k) ? new QFilter[]{new QFilter("ssid", "=", (Object)srcSysId), new QFilter("groupnumber", "=", (Object)typeId), new QFilter("number", "in", (Object)this.targetNumberEntitys.get(k))} : ("ds_account".equals(k) ? new QFilter[]{new QFilter("ssid", "=", (Object)srcSysId), new QFilter("accounttable", "=", (Object)typeId), new QFilter("number", "in", (Object)this.targetNumberEntitys.get(k))} : new QFilter[]{new QFilter("ssid", "=", (Object)srcSysId), new QFilter("number", "in", (Object)this.targetNumberEntitys.get(k))});
            DynamicObjectCollection dimObjs = QueryServiceHelper.query((String)k, (String)"id, number, name", (QFilter[])qfilter);
            HashMap map = new HashMap();
            dimObjs.forEach(v -> map.put(v.getString("number"), v));
            this.dataCache.put(k, map);
        });
    }

    private void queryAccount(ArrayListMultimap<String, String> filterBuildMap, Long model) {
        QFilter filter = null;
        Set keySet = filterBuildMap.keySet();
        block12: for (String plusminusStr : keySet) {
            List list = filterBuildMap.get((Object)plusminusStr);
            switch (plusminusStr) {
                case "\u7b49\u4e8e": {
                    if (filter == null) {
                        filter = new QFilter("number", "in", (Object)list);
                        break;
                    }
                    filter.or(new QFilter("number", "in", (Object)list));
                    break;
                }
                case "\u533a\u95f4": {
                    String v2;
                    int i;
                    for (i = 0; i < list.size(); ++i) {
                        v2 = (String)list.get(i);
                        if (filter == null) {
                            filter = QFilter.of((String)"number in (?, ?)", (Object[])new Object[]{v2.split(";")[0], v2.split(";")[1]});
                            continue;
                        }
                        filter.or(QFilter.of((String)"number in (?, ?)", (Object[])new Object[]{v2.split(";")[0], v2.split(";")[1]}));
                    }
                    continue block12;
                }
                case "\u76f8\u4f3c": {
                    String v2;
                    int i;
                    for (i = 0; i < list.size(); ++i) {
                        v2 = (String)list.get(i);
                        if (filter == null) {
                            filter = new QFilter("number", "like", (Object)("%" + v2 + "%"));
                            continue;
                        }
                        filter.or(new QFilter("number", "like", (Object)("%" + v2 + "%")));
                    }
                    continue block12;
                }
                case "\u5305\u542b": {
                    String v2;
                    int i;
                    for (i = 0; i < list.size(); ++i) {
                        v2 = (String)list.get(i);
                        if (filter == null) {
                            filter = new QFilter("number", "in", Arrays.asList(v2.split(",")));
                            continue;
                        }
                        filter.or(new QFilter("number", "in", Arrays.asList(v2.split(","))));
                    }
                    break;
                }
            }
        }
        if (filter != null) {
            QFilter[] qfilter = new QFilter[]{filter, new QFilter("model", "=", (Object)model)};
            DynamicObjectCollection srcobjs = QueryServiceHelper.query((String)((String)this.srcDimObjectList.get(0).get("membermodel")), (String)"id, number, name", (QFilter[])qfilter);
            srcobjs.forEach(v -> this.accountCache.put(v.getString("number"), (DynamicObject)v));
        }
    }
}

