/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.bcmdimmap.SchemeUtil;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ExtTargFieldSettingPlugin
extends AbstractBaseFormPlugin {
    public static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_cancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        int rowIndex;
        super.afterCreateNewData(e);
        Long schemeId = (Long)this.getFormCustomParam("scheme");
        DynamicObject scheme = this.getScheme(schemeId);
        QFilter modelQf = new QFilter("model", "=", (Object)scheme.getLong("model_id"));
        QFilter extQf = new QFilter("id", "in", this.getExtendsModelId(scheme.getLong("extendsmodel_id")));
        QFilter dimQf = new QFilter("id", "in", this.getModelDimIds(scheme.getLong("extendsmodel_id"), scheme.getLong("model_id"), schemeId));
        DynamicObject[] dims = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"number,id,name", (QFilter[])new QFilter[]{dimQf});
        DynamicObject[] extFields = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"number,id,name,datatype", (QFilter[])new QFilter[]{modelQf, extQf});
        for (DynamicObject dim : dims) {
            rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("id", (Object)dim.getLong("id"), rowIndex);
            this.getModel().setValue("number", (Object)dim.getString("number"), rowIndex);
            this.getModel().setValue("name", (Object)dim.getString("name"), rowIndex);
            this.getModel().setValue("type", (Object)FieldTypeEnum.DIM_FIELD.getName(), rowIndex);
            this.getModel().setValue("typecode", (Object)FieldTypeEnum.DIM_FIELD.getType(), rowIndex);
        }
        for (DynamicObject ext : extFields) {
            rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("id", (Object)ext.getLong("id"), rowIndex);
            this.getModel().setValue("number", (Object)ext.getString("number"), rowIndex);
            this.getModel().setValue("name", (Object)ext.getString("name"), rowIndex);
            this.getModel().setValue("type", (Object)FieldTypeEnum.EXT_FIELD.getName(), rowIndex);
            this.getModel().setValue("typecode", (Object)FieldTypeEnum.EXT_FIELD.getType(), rowIndex);
            this.getModel().setValue("datatype", (Object)ext.getString("datatype"), rowIndex);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRYENTITY});
    }

    private DynamicObject getScheme(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isscheme");
    }

    private Set<Long> getExtendsModelId(Long id) {
        QFilter modelQf = new QFilter("extmodelid", "=", (Object)id);
        DynamicObjectCollection dynamic = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extfield", (QFilter[])new QFilter[]{modelQf});
        HashSet<Long> ids = new HashSet<Long>();
        dynamic.forEach(k -> ids.add(k.getLong("extfield")));
        return ids;
    }

    private Set<Long> getModelDimIds(Long id, Long modelId, Long schemeId) {
        DynamicObject[] dims;
        DynamicObject[] extModelDim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)id)}, (String)"sequence");
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject object : extModelDim) {
            ids.add(object.getLong("dimension_id"));
        }
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        List<String> fixedDimension = this.isDIExtProduct(schemeId) != false ? Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail") : Arrays.asList("Entity", "Year", "Period", "Currency");
        QFilter fixedQF = new QFilter("number", "in", fixedDimension);
        for (DynamicObject dim : dims = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, fixedQF})) {
            ids.add(dim.getLong("id"));
        }
        return ids;
    }

    private Boolean isDIExtProduct(Long schemeId) {
        QFilter filter = new QFilter("issrc.number", "in", (Object)SchemeUtil.getDIExtProduct());
        filter.and("id", "=", (Object)schemeId);
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])filter.toArray());
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confirm": {
                EntryGrid entity = (EntryGrid)this.getControl(ENTRYENTITY);
                if (entity.getSelectRows().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e", (String)"ExtModelFieldSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                    return;
                }
                List<DynamicObject> entrySeleteDatas = this.getEntrySeleteDatas(ENTRYENTITY);
                this.returnDataToParent(entrySeleteDatas.get(0));
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }
}

