/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class ISBasedataBatchListPlugin
extends AbstractBaseListPlugin {
    public static String operationAdd() {
        return ResManager.loadKDString((String)"\u65b0\u589e", (String)"ISBasedataBatchListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISBasedataBatchListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStatusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ISBasedataBatchListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("ensure");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Object schemeID = this.getView().getFormShowParameter().getCustomParam("schemeId");
        Object entryName = this.getView().getFormShowParameter().getCustomParam("entryName");
        QFilter filter = new QFilter("scheme", "=", schemeID);
        DynamicObject[] bcmIsbaseentlist = BusinessDataServiceHelper.load((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter[]{filter});
        List<DynamicObject> dataList = Arrays.asList(bcmIsbaseentlist);
        TableValueSetter ts = null;
        if (entryName.equals("NGACC")) {
            ts = this.getNGACCTableValueSetter(schemeID, dataList);
        } else if (entryName.equals("MIDLIB")) {
            ts = this.getMidTableValueSetter(schemeID, dataList);
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        int rowCount = model.getEntryRowCount("entryentity");
        this.setEntryGridEnable(rowCount);
    }

    private void setEntryGridEnable(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"number", "name", "entitynumber"});
        }
    }

    private TableValueSetter getNGACCTableValueSetter(Object schemeID, List<DynamicObject> dataList) {
        DynamicObject[] schemeData = BusinessDataServiceHelper.load((String)"bd_asstacttype", (String)"name,number,valuesource.number", null);
        ArrayList filterList = new ArrayList(10);
        HashSet set = new HashSet(16);
        dataList.forEach(dynamicObject -> set.add(dynamicObject.getString("number")));
        Stream.of(schemeData).filter(dynamicObject -> set.contains(dynamicObject.getString("number"))).forEach(dynamicObject -> {
            String entityForm = dynamicObject.getString("valuesource.number");
            filterList.add(entityForm);
        });
        DynamicObject[] entryFrom = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", filterList)});
        Map<String, String> map = Stream.of(entryFrom).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("id")));
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (DynamicObject schemeDatum : schemeData) {
            String number = schemeDatum.getString("number");
            if (set.contains(number)) continue;
            String name = schemeDatum.getString("name");
            String entitynumber = schemeDatum.getString("valuesource.number");
            ts.set("number", (Object)number, i);
            ts.set("name", (Object)name, i);
            ts.set("scheme", schemeID, i);
            ts.set("entitynumber", (Object)entitynumber, i);
            ts.set("entityform", (Object)map.get(entitynumber), i);
            ++i;
        }
        return ts;
    }

    private TableValueSetter getMidTableValueSetter(Object schemeID, List<DynamicObject> dataList) {
        QFilter schemeFilter = new QFilter("id", "=", schemeID);
        DynamicObject schemeData = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id,middlelib", (QFilter[])schemeFilter.toArray());
        DynamicObject metadata = schemeData.getDynamicObject("middlelib");
        String middle = metadata.getString("number");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        Map as = EntityMetadataCache.getDataEntityType((String)middle).getAllFields();
        for (Map.Entry entry : as.entrySet()) {
            DynamicObject dynamicObject;
            String number;
            String key = (String)entry.getKey();
            String value = ((IDataEntityProperty)entry.getValue()).getDisplayName().toString();
            Iterator<DynamicObject> iterator = dataList.iterator();
            while (iterator.hasNext() && !(number = (String)(dynamicObject = iterator.next()).get("number")).equals(key)) {
                if (number.equals(key) || dataList.size() - 1 != dataList.indexOf(dynamicObject)) continue;
                ts.set("number", (Object)key, i);
                ts.set("name", (Object)value, i);
                ts.set("scheme", schemeID, i);
                ts.set("entitynumber", (Object)middle, i);
                ts.set("entityform", (Object)metadata, i);
                ++i;
            }
            if (dataList.size() != 0) continue;
            ts.set("number", (Object)key, i);
            ts.set("name", (Object)value, i);
            ts.set("scheme", schemeID, i);
            ts.set("entitynumber", (Object)middle, i);
            ts.set("entityform", (Object)metadata, i);
            ++i;
        }
        return ts;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("ensure".equals(itemKey)) {
            EntryGrid teg = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = teg.getSelectRows();
            if (selectedRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u540e\u91cd\u8bd5\u3002", (String)"ISBasedataBatchListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dyncol = this.getModel().getEntryEntity("entryentity");
            ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(16);
            StringBuilder number = new StringBuilder();
            for (int row : selectedRows) {
                DynamicObject obj = (DynamicObject)dyncol.get(row);
                DynamicObject bcmBaseMapParams = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
                bcmBaseMapParams.set("number", obj.get("number"));
                bcmBaseMapParams.set("name", obj.get("name"));
                bcmBaseMapParams.set("scheme", obj.get("scheme"));
                bcmBaseMapParams.set("entityform", obj.get("entityform"));
                bcmBaseMapParams.set("entitynumber", obj.get("entitynumber"));
                dyList.add(bcmBaseMapParams);
                number.append(obj.get("number"));
                number.append(", ");
            }
            SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
            Object schemeid = ((DynamicObject)dyncol.get(0)).get("scheme.id");
            if (Objects.nonNull(schemeid)) {
                DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"model.number,model.name,name", (QFilter[])new QFilter[]{new QFilter("id", "=", schemeid)});
                String modelName = scheme.getString("model.name");
                String schemeNumber = scheme.getString("number");
                StringBuilder result = new StringBuilder("model: ").append(modelName).append(", scheme: ").append(schemeNumber).append(", number: ").append((CharSequence)number);
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u65b0\u589e", "ISBasedataBatchListPlugin_0", "fi-bcm-formplugin", "Add"), new OPDescMultiLangEnumBridge("%s\u589e\u52a0\u6210\u529f\u3002", "ISBasedataBatchListPlugin_4", "fi-bcm-formplugin", new String[]{result.toString()}));
            }
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }
}

