/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.IOperationLog;

public class ISBasedataPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
IOperationLog {
    private static final String SAVE = "save";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ISBasedataPlugin.class);

    public static String getOperationMaintainBasicData() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ISBasedataPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISBasedataPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ISBasedataPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("entityform");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String srcNum = ((DynamicObject)this.getModel().getValue("scheme")).getString("issrc.number");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter filter = IntegrateProductEnum.NGACCProduct.getNumber().equals(srcNum) ? new QFilter("number", "like", (Object)"bd_%") : (IntegrateProductEnum.NGBGMODELProduct.getNumber().equals(srcNum) ? new QFilter("number", "in", this.getNGACCNumber()) : (IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(srcNum) || IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(srcNum) ? new QFilter("number", "in", this.NGCMAndFRMODELNumber()) : new QFilter("number", "like", (Object)"ds_%")));
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private Set<String> getNGACCNumber() {
        HashSet<String> dims = new HashSet<String>(16);
        Long ngModelId = ((DynamicObject)this.getModel().getValue("scheme")).getLong("issrcmodel.id");
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)ngModelId).toArray());
        Long modelSourceId = model.getLong("modelsource");
        QFilter modelId = new QFilter("id", "=", (Object)modelSourceId);
        QFilter[] filterModel = new QFilter[]{modelId};
        DynamicObjectCollection dimDyns = QueryServiceHelper.query((String)"eb_dataset", (String)"model,entryentity.datasetdim.number,entryentity.datasetdim.name,entryentity.datasetdim.membermodel", (QFilter[])filterModel);
        long srcModelId = ((DynamicObject)dimDyns.get(0)).getLong("model");
        DynamicObject AccountDyn = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"membermodel", (QFilter[])new QFilter("model", "=", (Object)srcModelId).and(new QFilter("number", "=", (Object)"Account")).toArray());
        dims.add(AccountDyn.getString("membermodel"));
        for (DynamicObject obj : dimDyns) {
            String memberModel = obj.getString("entryentity.datasetdim.membermodel");
            dims.add(memberModel);
        }
        return dims;
    }

    private Set<String> NGCMAndFRMODELNumber() {
        HashSet<String> dims = new HashSet<String>(16);
        Long ngModelId = ((DynamicObject)this.getModel().getValue("scheme")).getLong("issrcmodel.id");
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)ngModelId).toArray());
        Long modelSourceId = model.getLong("modelsource");
        QFilter modelId = new QFilter("model", "=", (Object)modelSourceId);
        DynamicObjectCollection dimDyns = QueryServiceHelper.query((String)"bcm_dimension", (String)"membermodel", (QFilter[])modelId.toArray());
        for (DynamicObject obj : dimDyns) {
            String memberModel = obj.getString("membermodel");
            dims.add(memberModel);
        }
        return dims;
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        Object customParam = parentView.getFormShowParameter().getCustomParam("scheme");
        if (customParam != null) {
            Long ngModelId;
            DynamicObject model;
            this.getModel().setValue("scheme", customParam);
            String srcNum = ((DynamicObject)this.getModel().getValue("scheme")).getDynamicObject("issrc").getString("number");
            if (!"NGACC".equals(srcNum)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"asstacttype"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "entityform"});
            }
            if ("MIDLIB".equals(srcNum)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entityform", "filter"});
                this.initMiddlelibField(customParam);
            }
            if (IntegrateProductEnum.XExtendProduct.getNumber().equalsIgnoreCase(srcNum)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entityform", "filter"});
                this.initXExtendField(customParam);
            }
            if (!(!IntegrateProductEnum.NGCMMODELProduct.getNumber().equalsIgnoreCase(srcNum) && !IntegrateProductEnum.NGFRMODELProduct.getNumber().equalsIgnoreCase(srcNum) && !IntegrateProductEnum.NGBGMODELProduct.getNumber().equalsIgnoreCase(srcNum) || (model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,usertype,datasource,number,apptype,phonenumber,userurl,password,modelsourcenum,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)(ngModelId = Long.valueOf(((DynamicObject)this.getModel().getValue("scheme")).getLong("issrcmodel.id")))).toArray())) == null || "1".equalsIgnoreCase(model.getString("usertype")) && RequestContext.get().getAccountId().equalsIgnoreCase(model.getString("datasource")))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entityform", "filter"});
                this.initCrossTenantAndDataCenter(model, srcNum);
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter"});
    }

    private void initCrossTenantAndDataCenter(DynamicObject model, String srcNum) {
        String phoneNumber = model.getString("phonenumber");
        KAESEncrypter ken = new KAESEncrypter();
        String password = ken.decode(model.getString("password"));
        Long tdpdatacenterId = null;
        Object tdpdatacenterObj = model.get("tdpdatacenterid");
        if (tdpdatacenterObj instanceof DynamicObject) {
            tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
        } else if (tdpdatacenterObj instanceof Long) {
            tdpdatacenterId = (Long)tdpdatacenterObj;
        }
        DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
        String userUrl = tdpdatacenter.getString("address");
        String loginToken = DimMappingHelper.getLoginTokenWithPass((String)phoneNumber, (String)password, (DynamicObject)tdpdatacenter);
        HashMap<String, String> requestHeader = new HashMap<String, String>(4);
        requestHeader.put("accessToken", loginToken);
        HashMap<String, String> params = new HashMap<String, String>();
        if (IntegrateProductEnum.NGCMMODELProduct.getNumber().equalsIgnoreCase(srcNum)) {
            params.put("number", model.getString("number"));
            params.put("reportType", ApplicationTypeEnum.CM.index);
        } else if (IntegrateProductEnum.NGFRMODELProduct.getNumber().equalsIgnoreCase(srcNum)) {
            params.put("number", model.getString("number"));
            params.put("reportType", ApplicationTypeEnum.RPT.index);
        } else if (IntegrateProductEnum.NGBGMODELProduct.getNumber().equalsIgnoreCase(srcNum)) {
            params.put("modelNumber", model.getString("modelsourcenum"));
            params.put("dataSetNumber", model.getString("number"));
        }
        try {
            String fullUrl = IntegrateProductEnum.NGBGMODELProduct.getNumber().equalsIgnoreCase(srcNum) ? userUrl + "/kapi/app/bgm/modelMemberQuery" : userUrl + "/kapi/app/cm/dimensionInfo";
            String paramStr = JSONObject.toJSONString(params);
            String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)1000, (int)1800000);
            ApiResult res = (ApiResult)JSONObject.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                log.error(String.format("errorCode=%s,errorMessage=%s", res.getErrorCode(), res.getMessage()));
                String error = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5fae\u670d\u52a1\u63a5\u53e3%1$s\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:%2$s,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ISBasedataPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fullUrl, res.getMessage());
                this.getView().showErrorNotification(error);
                return;
            }
            List data = (List)res.getData();
            HashMap<String, String> itemMapCache = new HashMap<String, String>();
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>();
            HashMap<String, String> mapData = new HashMap<String, String>();
            if (data != null && !data.isEmpty()) {
                for (Map datum : data) {
                    mapData.put(datum.get("number").toString(), datum.get("membermodel").toString());
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(datum.get("name").toString()));
                    item.setValue(datum.get("number").toString());
                    itemMapCache.put(datum.get("number").toString(), datum.get("name").toString());
                    itemList.add(item);
                }
            }
            ComboEdit combo = (ComboEdit)this.getControl("middlelibfield");
            combo.setComboItems(itemList);
            itemMapCache.put("entityform4Model", JSONObject.toJSONString(mapData));
            this.getPageCache().put(itemMapCache);
        }
        catch (Exception e) {
            log.error("get dimensionInfo error", (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[]{"get dimensionInfo error"});
        }
    }

    private void initXExtendField(Object schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"extendstable", (QFilter[])new QFilter[]{new QFilter("id", "=", schemeId)});
        String tableName = scheme.getString("extendstable");
        if (kd.bos.util.StringUtils.isEmpty((String)tableName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848\u672a\u8bbe\u7f6e\u62d3\u5c55\u8868\uff0c\u8bf7\u7ef4\u62a4\u540e\u91cd\u8bd5\u3002", (String)"ISBasedataPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getTableFiled(tableName);
        ArrayList itemlist = new ArrayList();
        HashMap<String, String> itemMapCache = new HashMap<String, String>();
        this.getTableFiled(tableName).forEach(k -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(k));
            item.setValue(k);
            itemlist.add(item);
        });
        ComboEdit combo = (ComboEdit)this.getControl("middlelibfield");
        combo.setComboItems(itemlist);
        DynamicObject form = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{"bcm_structofextend"}).toArray());
        itemMapCache.put("entityform4Middle", form.getString("id"));
        itemMapCache.put("entitynumber4Middle", tableName);
        itemMapCache.put("XExtendField", IntegrateProductEnum.XExtendProduct.getNumber());
        this.getPageCache().put(itemMapCache);
    }

    private List<String> getTableFiled(String tableName) {
        ArrayList<String> tableFiled = new ArrayList<String>(16);
        String sql = "select COLUMN_NAME from information_schema.COLUMNS where table_name ='" + tableName.toLowerCase() + "';";
        DataSet dataSet = DB.queryDataSet((String)"getTableFiled", (DBRoute)BCMConstant.DBROUTE, (String)sql);
        while (dataSet.hasNext()) {
            String name = dataSet.next().getString("COLUMN_NAME");
            tableFiled.add(name);
        }
        return tableFiled;
    }

    private void initMiddlelibField(Object schemeid) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"middlelib", (QFilter[])new QFilter[]{new QFilter("id", "=", schemeid)});
        DynamicObject metadata = scheme.getDynamicObject("middlelib");
        if (metadata == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848\u6ca1\u6709\u9009\u62e9\u4e2d\u95f4\u8868\uff0c\u8bf7\u7ef4\u62a4\u540e\u91cd\u8bd5\u3002", (String)"ISBasedataPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String middle = metadata.getString("number");
        HashMap<String, String> itemMapCache = new HashMap<String, String>();
        ArrayList itemlist = new ArrayList();
        EntityMetadataCache.getDataEntityType((String)middle).getAllFields().forEach((k, v) -> {
            ComboItem item = new ComboItem();
            item.setCaption(v.getDisplayName());
            item.setValue(k);
            itemMapCache.put((String)k, v.getDisplayName().toString());
            itemlist.add(item);
        });
        ComboEdit combo = (ComboEdit)this.getControl("middlelibfield");
        combo.setComboItems(itemlist);
        itemMapCache.put("entityform4Middle", metadata.getString("id"));
        itemMapCache.put("entitynumber4Middle", metadata.getString("number"));
        this.getPageCache().put(itemMapCache);
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        Object isSys = model.getValue("issys");
        String srcNum = ((DynamicObject)this.getModel().getValue("scheme")).getString("issrc.number");
        if (!((Boolean)isSys).booleanValue()) {
            String entityNumber = (String)model.getValue("entitynumber");
            DynamicObject form = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{entityNumber}).toArray());
            if (form != null) {
                model.setValue("entityform", (Object)form.getString("id"));
                model.setDataChanged(false);
            }
            if ("XEXTEND".equals(srcNum)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"entityform", "number", "name"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"middlelibfield", SAVE});
            } else {
                boolean isRefrence = BaseDataRefrenceHelper.isRefrenced((BasedataEntityType)((BasedataEntityType)model.getDataEntityType()), (Object)model.getValue("id"));
                this.getView().setEnable(Boolean.valueOf(!isRefrence), new String[]{"entityform", "number", "name"});
                this.getView().setVisible(Boolean.valueOf(!isRefrence), new String[]{SAVE});
            }
            if ("MIDLIB".equals(srcNum)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"middlelibfield"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"entityform"});
            }
        }
        if ("NGACC".equals(srcNum)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "entityform"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"asstacttype"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            IDataModel model = this.getModel();
            String filter = (String)model.getValue("filter");
            String number = (String)model.getValue("number");
            String name = ((OrmLocaleValue)model.getValue("name")).getLocaleValue();
            String entityNumber = (String)model.getValue("entitynumber");
            StringBuilder errMsg = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u586b\u5199", (String)"ISBasedataPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if (number == null || number.isEmpty()) {
                errMsg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001", (String)"ISBasedataPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (name == null || name.isEmpty()) {
                errMsg.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u3001", (String)"ISBasedataPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (entityNumber == null || entityNumber.isEmpty()) {
                errMsg.append(ResManager.loadKDString((String)"\u201c\u5b9e\u4f53\u6807\u8bc6\u201d\u3001", (String)"ISBasedataPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (args.isCancel()) {
                errMsg.replace(errMsg.length() - 1, errMsg.length(), "\u3002");
                this.getView().showTipNotification(errMsg.toString());
                return;
            }
            if (!this.doNumberCheck(number).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\uff0c\u4e2d\u5212\u7ebf\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ISBasedataPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)filter) && !StringUtils.isEmpty((CharSequence)entityNumber)) {
                try {
                    QueryServiceHelper.queryOne((String)entityNumber, (String)"id, number", (QFilter[])QFilter.of((String)filter, (Object[])new Object[0]).toArray());
                }
                catch (Exception e) {
                    args.setCancel(true);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u7f6e\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ISBasedataPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
    }

    private Boolean doNumberCheck(String number) {
        String regEx = "^[\\w-]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals(SAVE)) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            String entityNumber = (String)this.getModel().getValue("number");
            String result = "model: " + scheme.getString("model.shownumber") + ", scheme: " + scheme.getString("number") + ", number: " + entityNumber;
            this.getPageCache().put("modelid", String.valueOf(scheme.getLong("model.id")));
            if (operationResult.isSuccess()) {
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISBasedataPlugin_0", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f\u3002", "ISBasedataPlugin_13", "fi-bcm-formplugin", new String[]{result}));
            } else {
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISBasedataPlugin_0", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u5931\u8d25\u3002", "ISBasedataPlugin_14", "fi-bcm-formplugin", new String[]{result}));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "asstacttype": {
                Object newValue = this.getModel().getValue("asstacttype");
                if (newValue == null) {
                    this.getModel().setValue("name", null);
                    this.getModel().setValue("number", null);
                    this.getModel().setValue("entityform", null);
                    break;
                }
                this.getModel().setValue("name", (Object)((DynamicObject)newValue).getString("name"));
                this.getModel().setValue("number", (Object)((DynamicObject)newValue).getString("number"));
                String entityForm = ((DynamicObject)newValue).getString("valuesource.number");
                QFilter filter = new QFilter("number", "=", (Object)entityForm);
                DynamicObject entity = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{filter});
                if (entity == null) break;
                this.getModel().setValue("entityform", entity.get("id"));
                break;
            }
            case "middlelibfield": {
                Object fieldValue = this.getModel().getValue("middlelibfield");
                if (fieldValue == null) {
                    this.getModel().setValue("name", null);
                    this.getModel().setValue("number", null);
                    this.getModel().setValue("entitynumber", null);
                    this.getModel().setValue("entityform", null);
                    break;
                }
                this.getModel().setValue("name", (Object)this.getPageCache().get((String)fieldValue));
                this.getModel().setValue("number", fieldValue);
                if (this.getPageCache().get("entityform4Middle") == null) {
                    this.getModel().setValue("entitynumber", ((HashMap)JSON.parseObject((String)this.getPageCache().get("entityform4Model"), HashMap.class)).get(fieldValue));
                    DynamicObject form = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{"bcm_model"}).toArray());
                    this.getModel().beginInit();
                    this.getModel().setValue("entityform", (Object)form.getString("id"));
                    this.getModel().endInit();
                    break;
                }
                this.getModel().setValue("entitynumber", (Object)this.getPageCache().get("entitynumber4Middle"));
                this.getModel().setValue("entityform", (Object)this.getPageCache().get("entityform4Middle"));
                break;
            }
            case "number": {
                if (this.getPageCache().get("XExtendField") == null || !this.getPageCache().get("XExtendField").equals(IntegrateProductEnum.XExtendProduct.getNumber())) break;
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                break;
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        String modelIdStr = this.getPageCache().get("modelid");
        if (modelIdStr == null) {
            return;
        }
        long modelId = Long.parseLong(modelIdStr);
        if (modelId == 0L) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }
}

