/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ISDimMappingPlugin
extends AbstractBaseFormPlugin {
    private static final String SCHEME = "scheme";
    private static final String MODEL = "model";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CACHE_FLAGE = "CACHE_FLAGE";
    private static final String ADD_NEW_CALLBACK = "ADD_NEW_CALLBACK";
    private static final String MODIFY_CALLBACK = "MODIFY_CALLBACK";
    private static final String action_delete = "action_delete";

    public static String operationEnable() {
        return ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ISDimMappingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String operationDisable() {
        return ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"ISDimMappingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISDimMappingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String operationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"ISDimMappingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners("toolbarap");
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        entry.addRowClickListener(new RowClickEventListener(){

            public void entryRowDoubleClick(RowClickEvent evt) {
                if (ISDimMappingPlugin.this.checkEnableStatus(ResManager.loadKDString((String)"\u4fee\u6539", (String)"ISDimMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) {
                    ISDimMappingPlugin.this.openModifyWindow(evt.getRow());
                }
            }
        });
        BasedataEdit edit = (BasedataEdit)this.getControl("inheritancescheme");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit edit2 = (BasedataEdit)this.getControl("datafiltercondition");
        edit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().toString()) {
            case "datafiltercondition": {
                this.dataFilter(event);
                break;
            }
            case "inheritancescheme": {
                this.schemeFilter(event);
                break;
            }
        }
    }

    private void schemeFilter(BeforeF7SelectEvent event) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", this.getSchemeIds(model.getLong("id"), scheme.getLong("id"))));
    }

    private String getDimMapNumberById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"number", (QFilter[])filter.toArray()).getString("number");
    }

    private List<Long> getSchemeIds(Long modelId, Long schemeId) {
        List<Long> schemeIds = new ArrayList<Long>(8);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                Long dimMapId = (Long)((DynamicObject)entity.get(selectRow)).get("dimmappingid");
                String dimMapNumber = this.getDimMapNumberById(dimMapId);
                schemeIds = this.getDimMapSchemeIds(this.findSchemeIds(modelId, schemeId), dimMapNumber);
            }
        }
        schemeIds.removeAll(DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId));
        return schemeIds;
    }

    private List<Long> getDimMapSchemeIds(List<Long> schemeIds, String dimMapNumber) {
        QFilter filter = new QFilter(SCHEME, "in", schemeIds);
        QFilter filterNumber = new QFilter("number", "=", (Object)dimMapNumber);
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)"bcm_isdimmap", (String)SCHEME, (QFilter[])new QFilter[]{filter, filterNumber});
        List<Long> ids = dyn.stream().map(k -> k.getLong(SCHEME)).collect(Collectors.toList());
        return ids;
    }

    private List<Long> findSchemeIds(Long modelId, Long schemeId) {
        QFilter filter = new QFilter(MODEL, "in", (Object)modelId).and("id", "!=", (Object)schemeId).and("status", "=", (Object)"1").and("issrc", "=", (Object)this.getExtendsProductId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])filter.toArray());
        List<Long> schemeIds = dynamicObjects.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        return schemeIds;
    }

    private void dataFilter(BeforeF7SelectEvent event) {
        Long fid;
        IDataModel model = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entry.getSelectRows();
        if (selectRows != null && selectRows.length > 0 && this.IsNumericField(fid = model.getValue("tagdimdefvalue", selectRows[0]) != null && StringUtils.isNotEmpty((String)((String)model.getValue("tagdimdefvalue", selectRows[0]))) ? this.getDimMapIdFromTarg((Long)model.getValue("dimmappingid", selectRows[0])) : (Long)model.getValue("dimmappingid", selectRows[0])).booleanValue()) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            param.getListFilterParameter().getQFilters().add(new QFilter("number", "not in", (Object)new Object[]{"5", "6"}));
        }
    }

    private Boolean IsNumericField(Long mappingId) {
        QFilter filter = new QFilter("id", "=", (Object)mappingId);
        DynamicObject dimMap = QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"datatype", (QFilter[])filter.toArray());
        if (StringUtils.isNotEmpty((String)dimMap.getString("datatype")) && "2".equalsIgnoreCase(dimMap.getString("datatype"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Long getExtendsProductId() {
        DynamicObject productSrc = QueryServiceHelper.queryOne((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)IntegrateProductEnum.XExtendProduct.getNumber())});
        return productSrc.getLong("id");
    }

    private void saveExtendsSetting() {
        DynamicObject[] dimMap;
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        for (DynamicObject dim : dimMap = entry.getEntryData().getDataEntitys()) {
            Long fid = dim.getString("tagdimdefvalue") != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dim.getString("tagdimdefvalue")) ? this.getDimMapIdFromTarg(Long.parseLong(dim.getString("dimmappingid"))) : Long.valueOf(Long.parseLong(dim.getString("dimmappingid")));
            DynamicObject saveDim = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"bcm_isdimmap");
            if ((Long)dim.get("inheritancescheme_id") == 0L) {
                saveDim.set("inheritancescheme_id", null);
            } else {
                saveDim.set("inheritancescheme_id", dim.get("inheritancescheme_id"));
            }
            if ((Long)dim.get("datafiltercondition_id") == 0L) {
                saveDim.set("datafiltercondition_id", null);
            } else {
                saveDim.set("datafiltercondition_id", dim.get("datafiltercondition_id"));
            }
            saveDim.set("filtervalue", (Object)dim.getString("filtervalue"));
            saveDim.set("reservedfield", (Object)dim.getString("reservedfield"));
            SaveServiceHelper.update((DynamicObject)saveDim);
        }
    }

    private Long getDimMapIdFromTarg(Long tagdimmappingid) {
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isdimmap", (QFilter[])new QFilter("isdimmaptargentry.id", "in", (Object)tagdimmappingid).toArray(), null, (int)-1);
        return (Long)queryPrimaryKeys.get(0);
    }

    private boolean isXExtendProduct(int row) {
        Object rowId;
        DynamicObject mappedtype;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        return scheme != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number")) && "1".equals((mappedtype = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isdimmap", (String)"mappedtype", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{rowId = this.getModel().getValue("dimmappingid", row)}).or(QFilter.of((String)"isdimmaptargentry.id = ?", (Object[])new Object[]{rowId})).toArray())).getString("mappedtype"));
    }

    protected void openModifyWindow(int row) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("bcm_isdimmap");
        Object rowId = this.getModel().getValue("dimmappingid", row);
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isdimmap", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{rowId}).or(QFilter.of((String)"isdimmaptargentry.id = ?", (Object[])new Object[]{rowId})).or(QFilter.of((String)"isdimmapsrcentry.id = ?", (Object[])new Object[]{rowId})).toArray(), null, (int)-1);
        formShowParameter.setPkId(queryPrimaryKeys.get(0));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848", (String)"ISDimMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        formShowParameter.setCustomParam(SCHEME, (Object)scheme.getLong("id"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MODIFY_CALLBACK));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u4fee\u6539", (String)"ISDimMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("addnew".equals(itemKey)) {
            if (this.checkEnableStatus(ResManager.loadKDString((String)"\u65b0\u589e", (String)"ISDimMappingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) {
                this.openAddNewWindow();
            }
        } else if ("enable".equals(itemKey)) {
            this.checkDimCompletion();
            this.refreshEntity();
        } else if ("refresh".endsWith(itemKey)) {
            this.refreshEntity();
        } else if ("disable".equals(itemKey)) {
            this.disableDim();
            this.refreshEntity();
        } else if ("delete".equals(itemKey)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"ISDimMappingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkEnableStatus(ResManager.loadKDString((String)"\u5220\u9664", (String)"ISDimMappingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u7ef4\u5ea6\u6620\u5c04\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"ISDimMappingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(action_delete, (IFormPlugin)this));
            }
        }
    }

    private void disableDim() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848", (String)"ISDimMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (scheme.getBoolean("status")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u65b9\u6848\uff0c\u7ef4\u5ea6\u6620\u5c04\u624d\u80fd\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"ISDimMappingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isExtendstable = IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number"));
        scheme.set("enable", (Object)false);
        scheme = BusinessDataServiceHelper.loadSingle((Object)scheme.get("id"), (String)"bcm_isscheme", (String)"id, enable, status,model.name,number");
        scheme.set("enable", (Object)false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        String modelName = scheme.getString("model.name");
        String schemeNumber = scheme.getString("number");
        String result = String.format(ResManager.loadKDString((String)"model:%1$s, scheme:%2$s,\u53cd\u786e\u8ba4\u6210\u529f\u3002", (String)"ISDimMappingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelName, schemeNumber);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u53cd\u786e\u8ba4", "ISDimMappingPlugin_15", "fi-bcm-formplugin", "Counter confirmation"), new OPDescMultiLangEnumBridge("model:%1$s, scheme:%2$s,\u53cd\u786e\u8ba4\u6210\u529f\u3002", "ISDimMappingPlugin_8", "fi-bcm-formplugin", new String[]{modelName, schemeNumber}));
        if (!isExtendstable) {
            ISImportModeUtil.updateImportMode((Tuple)Tuple.create((Object)scheme.getLong("id"), (Object)scheme.getString("number"), (Object)scheme.getString("name")), (ISImpModeEnum)ISImpModeEnum.MERGEIMPORT);
        }
        DeleteServiceHelper.delete((String)"bcm_iscleardataconfig", (QFilter[])new QFilter[]{new QFilter("isscheme", "=", (Object)scheme.getLong("id"))});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u6210\u529f\u3002\u4fee\u6539\u96c6\u6210\u65b9\u6848\u7ef4\u5ea6\u6620\u5c04\u53ef\u80fd\u4f1a\u5f71\u54cd\u96c6\u6210\u6a21\u5f0f\uff0c\u8bf7\u52a1\u5fc5\u68c0\u67e5\u3002", (String)"ISDimMappingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void refreshEntity() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        this.schemeChanged(scheme);
    }

    private boolean checkEnableStatus(String operate) {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        IFormView view = this.getView();
        if (scheme == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848", (String)"ISDimMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (scheme.getBoolean("enable")) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u64cd\u4f5c\u3002", (String)"ISDimMappingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operate), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    protected void checkDimCompletion() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848", (String)"ISDimMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (scheme.getBoolean("status")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u65b9\u6848\uff0c\u7ef4\u5ea6\u6620\u5c04\u624d\u80fd\u8fdb\u884c\u786e\u8ba4\u3002", (String)"ISDimMappingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                boolean isExtendsTable = IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number"));
                if (isExtendsTable) {
                    this.saveExtendsSetting();
                }
                this.savePubSetting();
                MappingService service = new MappingService(scheme);
                List error = service.checkDim();
                if (error.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (String s : error) {
                        sb.append(s).append(" ");
                    }
                    this.getView().showErrorNotification(sb.toString());
                } else {
                    scheme.set("enable", (Object)true);
                    scheme = BusinessDataServiceHelper.loadSingle((Object)scheme.get("id"), (String)"bcm_isscheme", (String)"id, enable,model.name,name");
                    scheme.set("enable", (Object)true);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
                    String modelName = scheme.getString("model.name");
                    String schemeNumber = scheme.getString("number");
                    String result = String.format(ResManager.loadKDString((String)"model:%1$s, scheme:%2$s,\u786e\u8ba4\u6210\u529f\u3002", (String)"ISDimMappingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelName, schemeNumber);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u786e\u8ba4", "ISDimMappingPlugin_14", "fi-bcm-formplugin", "confirmation"), new OPDescMultiLangEnumBridge("model:%1$s, scheme:%2$s,\u786e\u8ba4\u6210\u529f\u3002", "ISDimMappingPlugin_10", "fi-bcm-formplugin", new String[]{modelName, schemeNumber}));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f\u3002", (String)"ISDimMappingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("checkDimCompletion error", (Throwable)e);
                if (e instanceof KDBizException) {
                    throw e;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\u3002", (String)"ISDimMappingPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void savePubSetting() {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObject[] dimMap = entry.getEntryData().getDataEntitys();
        HashSet<Long> pubmappingidSet = new HashSet<Long>(16);
        for (DynamicObject dim : dimMap) {
            if (!"1".equals(dim.get("mappedtype"))) continue;
            Long fid = Long.parseLong(dim.getString("dimmappingid"));
            DynamicObject saveDim = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"bcm_isdimmap");
            String pubmappingid = dim.getString("pubmappingid");
            Long pubmappingidL = 0L;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pubmappingid) && !pubmappingidSet.add(pubmappingidL = Long.valueOf(Long.parseLong(pubmappingid)))) {
                DynamicObject mappingSet = this.getMappingSetByItemId(pubmappingidL);
                DynamicObject mappingSetItem = this.getMappingSetItemById(mappingSet, pubmappingidL);
                String mark = "";
                if (mappingSetItem != null) {
                    mark = mappingSetItem.getString("cusname");
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u6807\u8bc6\u8bbe\u7f6e\u91cd\u590d\uff1a%s\u3002", (String)"ISDimMappingPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), mark));
            }
            saveDim.set("pubmappingid", (Object)pubmappingidL);
            SaveServiceHelper.update((DynamicObject)saveDim);
        }
    }

    private DynamicObject getMappingSetByItemId(long selectId) {
        QFilter filters = new QFilter("entryentity.id", "=", (Object)selectId);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
    }

    private DynamicObject getMappingSetItemById(DynamicObject dyn, long selectId) {
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject obj : entryentity) {
            if (obj.getLong("id") != selectId) continue;
            return obj;
        }
        return null;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (action_delete.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IDataModel model = this.getModel();
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows != null && selectRows.length > 0 && (this.getPageCache().get(CACHE_FLAGE) == null || Boolean.parseBoolean(this.getPageCache().get(CACHE_FLAGE)))) {
                HashSet<Long> deleteIds = new HashSet<Long>();
                HashSet<Long> deletetagIds = new HashSet<Long>();
                HashSet<Long> deletesrcIds = new HashSet<Long>();
                for (int index : selectRows) {
                    if (model.getValue("tagdimdefvalue", index) != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((String)model.getValue("tagdimdefvalue", index)))) {
                        deletetagIds.add((Long)model.getValue("dimmappingid", index));
                        continue;
                    }
                    if (model.getValue("srcdimdefvalue", index) != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((String)model.getValue("srcdimdefvalue", index)))) {
                        deletesrcIds.add((Long)model.getValue("dimmappingid", index));
                        continue;
                    }
                    deleteIds.add((Long)model.getValue("dimmappingid", index));
                }
                try (TXHandle tx2 = TX.requiresNew();){
                    try {
                        if (deletetagIds.size() > 0) {
                            this.deleteDefMapping(deleteIds, deletetagIds, "isdimmaptargentry");
                        }
                        if (deletesrcIds.size() > 0) {
                            this.deleteDefMapping(deleteIds, deletesrcIds, "isdimmapsrcentry");
                        }
                        if (deleteIds.size() > 0) {
                            DeleteServiceHelper.delete((String)"bcm_isdimmap", (QFilter[])new QFilter("id", "in", deleteIds).toArray());
                            DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])new QFilter("dimmapid", "in", deleteIds).toArray());
                            DeleteServiceHelper.delete((String)"bcm_isgroupmap", (QFilter[])new QFilter("dimmapid", "in", deleteIds).toArray());
                        }
                    }
                    catch (Exception e) {
                        tx2.markRollback();
                    }
                }
                catch (Exception tx2) {
                    // empty catch block
                }
                model.deleteEntryRows(ENTRYENTITY, selectRows);
                model.updateCache();
                Object schemeId = this.getView().getFormShowParameter().getCustomParam(SCHEME);
                if (Objects.nonNull(schemeId)) {
                    DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"model.number,model.name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", schemeId)});
                    String modelName = scheme.getString("model.name");
                    String schemeNumber = scheme.getString("number");
                    String result = "model: " + modelName + ", scheme: " + schemeNumber;
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "ISDimMappingPlugin_5", "fi-bcm-formplugin", "Delete"), new OPDescMultiLangEnumBridge("%s\u5220\u9664\u6210\u529f\u3002", "ISDimMappingPlugin_10", "fi-bcm-formplugin", new String[]{result}));
                }
            }
        }
    }

    private void deleteDefMapping(Set<Long> deleteIds, Set<Long> deletetagIds, String entry) {
        DynamicObject[] loads;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_isdimmap");
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isdimmap", (QFilter[])new QFilter(entry + ".id", "in", deletetagIds).toArray(), null, (int)-1);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)dataEntityType)) {
            DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection(entry);
            Iterator iterator = dynamicObjectCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (!deletetagIds.contains(next.getLong("id"))) continue;
                iterator.remove();
            }
            if (dynamicObjectCollection.size() > 0) continue;
            deleteIds.add(load.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])loads);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object schemeId = formShowParameter.getCustomParam(SCHEME);
        if (schemeId != null) {
            this.getModel().setValue(SCHEME, schemeId);
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            if (scheme == null) {
                scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
            }
            String srcNumber = scheme.getString("issrc.number");
            if (!(!scheme.getBoolean("enable") || "JQ".equals(srcNumber) || "JQONLINE".equals(srcNumber) || "EXCEL".equals(srcNumber) || "XEXTEND".equals(srcNumber))) {
                MappingService service = new MappingService(scheme);
                service.checkEnableDimAndAdd();
            }
            this.schemeChanged(scheme);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme", (String)"versionnumber");
            this.getModel().setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(dy.getBigDecimal("versionnumber").floatValue())));
        }
        BasedataEdit baseEdit = (BasedataEdit)this.getControl(SCHEME);
        DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL);
        if (value != null) {
            this.getPageCache().put("KEY_MODEL_ID", value.getString("id"));
            baseEdit.setQFilter(QFilter.of((String)"model = ?", (Object[])new Object[]{value.getLong("id")}));
        }
        this.getModel().updateCache();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (SCHEME.equals(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.schemeChanged(newValue);
        }
    }

    protected void schemeChanged(DynamicObject scheme) {
        if (scheme != null) {
            boolean isCanAddPubMapping;
            DynamicObject model = scheme.getDynamicObject(MODEL);
            if (model != null) {
                this.getModel().setValue(MODEL, model.get("id"));
            }
            String isSrc = scheme.getString("issrc.number");
            boolean bl = isCanAddPubMapping = IntegrateProductEnum.MIDLIBProduct.getNumber().equals(isSrc) || IntegrateProductEnum.NGACCProduct.getNumber().equals(isSrc);
            if (!isCanAddPubMapping) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pubmappingid"});
            } else {
                this.initPubMapping();
            }
            BigDecimal versionnumber = scheme.getBigDecimal("versionnumber");
            this.getModel().setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(versionnumber.floatValue())));
            this.fillMappingData(scheme);
            boolean isExtendsTable = IntegrateProductEnum.XExtendProduct.getNumber().equals(isSrc);
            if (!isExtendsTable) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inheritancescheme", "datafiltercondition", "filtervalue", "reservedfield"});
            }
        } else {
            this.getModel().setValue(MODEL, (Object)"");
        }
    }

    private void initPubMapping() {
        QFilter filters = new QFilter(MODEL, "=", (Object)this.getModelId());
        filters.and(new QFilter("status", "=", (Object)"1"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
        if (dynamicObject == null) {
            return;
        }
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        ArrayList<ComboItem> robotComboItems = new ArrayList<ComboItem>(16);
        for (DynamicObject obj : entryentity) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(obj.getString("cusname")));
            comboItem.setValue(String.valueOf(obj.getLong("id")));
            robotComboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("pubmappingid");
        comboEdit.setComboItems(robotComboItems);
    }

    private void fillMappingData(DynamicObject scheme) {
        QFilter[] filters = null;
        filters = new QFilter[]{new QFilter(SCHEME, "=", scheme.getPkValue())};
        String isSrc = scheme.getString("issrc.number");
        boolean isExtendsTable = IntegrateProductEnum.XExtendProduct.getNumber().equals(isSrc);
        boolean isCanAddPubMapping = IntegrateProductEnum.MIDLIBProduct.getNumber().equals(isSrc) || IntegrateProductEnum.NGACCProduct.getNumber().equals(isSrc);
        DynamicObject[] dimmappings = isExtendsTable ? MappingService.queryDimMappingExtendsTable((QFilter[])filters) : MappingService.queryDimmapping((QFilter[])filters);
        if (MappingService.isDimNotEmpty((DynamicObject[])dimmappings)) {
            this.doFillMappingData(dimmappings, isExtendsTable, isCanAddPubMapping);
        } else {
            MappingService service = new MappingService(scheme, true);
            dimmappings = service.insertDimPreData();
            if (MappingService.isDimNotEmpty((DynamicObject[])dimmappings)) {
                dimmappings = MappingService.queryDimmapping((QFilter[])filters);
                this.doFillMappingData(dimmappings, isExtendsTable, isCanAddPubMapping);
            }
        }
    }

    private void doFillMappingData(DynamicObject[] dimmappings, boolean isExtendsTable, boolean isCanAddPubMapping) {
        IDataModel model = this.getModel();
        ArrayList datas = new ArrayList();
        MappingService service = new MappingService();
        for (DynamicObject dimmapping : dimmappings) {
            String dimType = dimmapping.getString("mappedtype");
            datas.addAll(service.generateVO(dimmapping, dimType, Boolean.valueOf(isExtendsTable)));
        }
        int size = datas.size();
        DynamicObjectCollection entryEntity2 = model.getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        entryEntity2.clear();
        for (int i = 0; i < size; ++i) {
            DynamicObject addNew = entryEntity2.addNew();
            DefaultMappingVO dvo = (DefaultMappingVO)datas.get(i);
            addNew.set("tagdim", (Object)dvo.getTargetName());
            addNew.set("tagdimdefvalue", (Object)dvo.getTargetDef());
            addNew.set("srcdim", (Object)dvo.getSourceName());
            addNew.set("srcdimdefvalue", (Object)dvo.getSourceDef());
            addNew.set("dimmappingid", (Object)dvo.getMappingid());
            if (isExtendsTable) {
                if (dvo.getInheritanceScheme() == null || dvo.getInheritanceScheme() == 0L) {
                    addNew.set("inheritancescheme", null);
                } else {
                    addNew.set("inheritancescheme", (Object)this.getSchemeById(dvo.getInheritanceScheme()));
                }
                if (dvo.getDataFilterCondition() == null || dvo.getDataFilterCondition() == 0L) {
                    addNew.set("datafiltercondition", null);
                } else {
                    addNew.set("datafiltercondition", (Object)this.getDataFilterConditionById(dvo.getDataFilterCondition()));
                }
                addNew.set("filtervalue", (Object)dvo.getFilterValue());
                addNew.set("reservedfield", (Object)dvo.getReservedField());
                if (StringUtils.isEmpty((String)dvo.getDatatype()) && StringUtils.isEmpty((String)dvo.getTargetDef()) && StringUtils.isEmpty((String)dvo.getSourceDef())) {
                    addNew.set("canadd", (Object)Boolean.TRUE);
                }
                if (StringUtils.isEmpty((String)dvo.getDatatype())) {
                    addNew.set("isreservedfield", (Object)Boolean.TRUE);
                }
            }
            if (isCanAddPubMapping) {
                if (dvo.getPubmappingid() == null || "0".equals(dvo.getPubmappingid())) {
                    addNew.set("pubmappingid", null);
                } else {
                    addNew.set("pubmappingid", (Object)dvo.getPubmappingid());
                }
            }
            addNew.set("mappedtype", (Object)dvo.getMappedtype());
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private DynamicObject getSchemeById(Long schemeId) {
        return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
    }

    private DynamicObject getDataFilterConditionById(Long fid) {
        return BusinessDataServiceHelper.loadSingle((Object)fid, (String)"bcm_filtercondition");
    }

    private void openAddNewWindow() {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("bcm_isdimmap");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848", (String)"ISDimMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        formShowParameter.setCustomParam(SCHEME, (Object)scheme.getLong("id"));
        formShowParameter.setCustomParam("sequence", (Object)this.getModel().getEntryRowCount(ENTRYENTITY));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_NEW_CALLBACK));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u65b0\u589e", (String)"ISDimMappingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (MODIFY_CALLBACK.equals(actionId)) {
            this.fillReturnEntityData(closedCallBackEvent, true);
        } else if (ADD_NEW_CALLBACK.equals(actionId)) {
            this.fillReturnEntityData(closedCallBackEvent, false);
        }
    }

    protected void fillReturnEntityData(ClosedCallBackEvent closedCallBackEvent, boolean modify) {
        this.refreshEntity();
    }
}

