/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.RpaIniFileEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.intergration.export.DimMappingExportFactory;
import kd.fi.bcm.formplugin.intergration.export.IDimMapMemberExport;
import kd.fi.bcm.formplugin.intergration.imports.handle.DimMappingMemImportHandle;
import kd.fi.bcm.formplugin.intergration.membermap.handel.AbstractMemMapSheetHandel;
import kd.fi.bcm.formplugin.intergration.membermap.handel.MapViewManager;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.model.StatusBarModel;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ISDimMemberAndComSettingPlugin
extends SpreadBasePlugin
implements TreeNodeClickListener,
ISpreadModelSupplier {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ISDimMemberAndComSettingPlugin.class);
    private static final String SCHEME = "scheme";
    private static final String TREEVIEW = "treeviewap";
    private static final String TREEVIEW1 = "treeviewap1";
    private static final String COMMEM_SPREAD = "commemspread";
    private static final String TAIL = "fomula";
    private static final String btn_filltarget = "btn_filltarget";
    private static final String CACHE_LASTTAB = "CACHE_LASTTAB";
    private static final String CACHE_LASTTREE = "CACHE_LASTTREE";
    private static final String CACHE_SELECTNODE = "CACHE_SELECTNODE";
    private static final String CACHE_SELECTNODEFORMULA = "CACHE_SELECTNODEFORMULA";
    private static final String CACHE_LASTNODE = "CACHE_LASTNODE";
    private static final String CACHE_MEMANDCOMVO = "cache_memandcomvo";
    private static final String NAMERULE = "nameRule";
    private SpreadManager spreadManager;
    private MemAndComVO memandcomvo;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        DynamicObject scheme = (DynamicObject)this.getView().getModel().getValue(SCHEME);
        if (scheme == null) {
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            if (parentView != null) {
                parentView.showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u5220\u9664", (String)"ISDimMemberAndComSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                view.sendFormAction(parentView);
            }
            view.close();
            return;
        }
        this.addItemClickListeners("toolbarap", "groupbar");
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ISDimMemberAndComSettingPlugin.this.treeNodeClickDo(evt);
            }
        });
        TreeView tree1 = (TreeView)this.getControl(TREEVIEW1);
        tree1.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ISDimMemberAndComSettingPlugin.this.treeNodeClickDo(evt);
            }
        });
        Tab subTab = (Tab)this.getControl("tabap");
        subTab.addTabSelectListener(arg0 -> {
            DynamicObject schemeDyn = (DynamicObject)this.getModel().getValue(SCHEME);
            this.initTree(schemeDyn);
        });
        this.initSpreadListener();
    }

    private void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            Cell cell = this.getSpreadManager().getBook().getSheet(0).getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
            StatusBarModel statusBarModel = new StatusBarModel();
            if (cell.getValue() != null) {
                statusBarModel.setCellNameStr(cell.getValue() + "");
            } else {
                statusBarModel.setCellNameStr("");
            }
            SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), this.getSpreadKey(), statusBarModel);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsPreInsert(excuteinfo)) {
                return;
            }
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> this.getHahdel().beforeUpdateMulValue(e));
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> this.getHahdel().afterUpdataValue((EventObject)e));
    }

    private boolean checkIsPreInsert(AskExcuteInfo excuteinfo) {
        Integer[] preRow = new Integer[]{0, 1};
        if (excuteinfo.getOperationdata().contains(preRow[0]) || excuteinfo.getOperationdata().contains(preRow[1])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u884c\u5217\u4e0d\u80fd\u5220\u9664\u3002", (String)"ISDimMemberAndComSettingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public String getSpreadKey() {
        return COMMEM_SPREAD;
    }

    public void treeNodeClickDo(TreeNodeEvent evt) {
        String lastNode = this.getPageCache().get(CACHE_LASTNODE);
        String nodeId = (String)evt.getNodeId();
        if (!nodeId.equals(lastNode)) {
            if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("change", (IFormPlugin)this));
                this.getPageCache().put("nodeId", nodeId);
            } else {
                this.changeNode(nodeId);
            }
        }
    }

    private void changeNode(String nodeId) {
        long selectId;
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85", (String)"ISDimMemberAndComSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        boolean isFomula = nodeId.contains(TAIL);
        if (isFomula) {
            selectId = Long.parseLong(nodeId.substring(0, nodeId.length() - TAIL.length()));
            this.getView().setVisible(Boolean.valueOf(this.isFromEASACC()), new String[]{"btn_formulasetting"});
        } else {
            selectId = Long.parseLong(nodeId);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_formulasetting"});
        }
        if (selectId != 0L) {
            log.startWatch();
            this.memandcomvo = this.geneMemVO(selectId, isFomula);
            log.warn("dimMemberAndCom: create memandcomvo");
            if (this.memandcomvo != null && this.memandcomvo.getType() == MemAndComVO.VOEnum.M) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_matchtmp", "groupbar"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_automatchng", "btn_automatchnumber"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_matchtmp", "groupbar"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchng", "btn_automatchnumber"});
            }
            if (this.supportFuzzyMatch()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchng", "btn_automatchnumber", "btn_import", "btn_export", btn_filltarget, "btn_matchtmp"});
            }
            if (this.isFromJQ()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_import", "btn_export", "btn_automatchng", "btn_automatchnumber"});
            }
            if (this.isFromNGBGModel()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchng", "btn_automatchnumber", "btn_import", "btn_export", "btn_namerule", "btn_matchtmp", "btn_formulasetting"});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_import", "btn_export"});
            this.getHahdel().buildSpread();
            log.warn("dimMemberAndCom: buildSpread");
        }
        if (!this.isFormulaTab()) {
            this.getPageCache().put(CACHE_SELECTNODE, nodeId);
        } else {
            this.getPageCache().put(CACHE_SELECTNODEFORMULA, nodeId);
        }
        this.getPageCache().put(CACHE_LASTTAB, this.isFormulaTab() ? "tabpageap1" : "tabpageap");
        this.getPageCache().put(CACHE_LASTTREE, this.getCurrentTree().getKey());
        this.getPageCache().put(CACHE_LASTNODE, nodeId);
        this.getView().hideLoading();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "change": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    Tab subTab = (Tab)this.getControl("tabap");
                    subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                    TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    break;
                }
                if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.changeNode(this.getPageCache().get("nodeId"));
                    break;
                }
                Tab subTab = (Tab)this.getControl("tabap");
                subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                break;
            }
            case "close": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getSpreadManager().getBook().getSheet(0).getUserObject().remove("change");
                this.getView().close();
                break;
            }
            case "refreshSpreadData": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                String nodeid = this.getPageCache().get("nodeid");
                this.changeNode(nodeid);
                break;
            }
        }
    }

    private MemAndComVO geneMemVO(Long selectId, boolean isFomula) {
        MemAndComVO generateMemAndComVO = MappingService.generateMemAndComVO((Long)selectId);
        if (generateMemAndComVO != null && generateMemAndComVO.getType() != MemAndComVO.VOEnum.M) {
            if (isFomula) {
                generateMemAndComVO.setType(MemAndComVO.VOEnum.C3);
            } else {
                MappingContext context = this.getMappingContext();
                if (context != null && context.isSrcNg()) {
                    generateMemAndComVO.setType(MemAndComVO.VOEnum.C2);
                }
            }
        }
        this.getPageCache().put(CACHE_MEMANDCOMVO, this.toByteSerialized(generateMemAndComVO));
        return generateMemAndComVO;
    }

    private MappingContext getMappingContext() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        MappingContext context = null;
        if (scheme != null) {
            context = new MappingContext(scheme);
        }
        return context;
    }

    public MemAndComVO getMemAndComVO() {
        if (this.memandcomvo != null) {
            return this.memandcomvo;
        }
        String serial = this.getPageCache().get(CACHE_MEMANDCOMVO);
        if (!StringUtils.isNotEmpty((String)serial)) {
            return null;
        }
        this.memandcomvo = (MemAndComVO)this.deSerializedBytes(serial);
        return this.memandcomvo;
    }

    public boolean supportFuzzyMatch() {
        return this.isFromSrc("MIDLIB") || this.isFromSrc("NGACC") || this.isFromSrc("NGBGMODEL") || this.isFromSrc("NGCMMODEL") || this.isFromSrc("NGFRMODEL") || this.isFromSrc("XEXTEND") || this.isFromSrc("EASACC") || this.isFromSrc(IntegrateProductEnum.DIProduct.getNumber()) || this.isFromSrc("NGACC-C");
    }

    private boolean isFromJQ() {
        return this.isFromSrc("JQ") || this.isFromSrc("JQONLINE");
    }

    private boolean isFromNGBGModel() {
        return this.isFromSrc("NGBGMODEL");
    }

    private boolean isFromEASACC() {
        return this.isFromSrc("EASACC");
    }

    public boolean isFromSrc(String srcNum) {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return srcNum.equals(issrc.getString("number"));
    }

    public DynamicObject getScheme() {
        return (DynamicObject)this.getModel().getValue(SCHEME);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object schemeId = formShowParameter.getCustomParam(SCHEME);
        if (schemeId != null) {
            this.getModel().setValue(SCHEME, schemeId);
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            this.schemeChanged(scheme);
            this.getModel().setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(scheme.getBigDecimal("versionnumber").floatValue())));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_namerule"});
            if (this.supportFuzzyMatch()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchng"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchnumber"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_matchtmp"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_addrow"});
            } else if (this.isFromJQ()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchng"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_automatchnumber"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{btn_filltarget});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_formulasetting"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_import", "btn_export"});
        }
        this.registSpreadShortcutKey();
    }

    private void schemeChanged(DynamicObject scheme) {
        if (scheme != null) {
            DynamicObject model = scheme.getDynamicObject("model");
            if (model != null) {
                this.getModel().setValue("model", model.get("id"));
            }
            this.initTree(scheme);
        } else {
            this.getModel().setValue("model", (Object)"");
        }
    }

    private void initTree(DynamicObject scheme) {
        TreeNode focusNode;
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04", (String)"ISDimMemberAndComSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        ArrayList<TreeNode> children = root.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>();
            root.setChildren(children);
        }
        MappingContext context = new MappingContext(scheme);
        MappingService service = new MappingService(context);
        DynamicObject[] dimMappings = service.querySimpleDimmapping();
        String groupId = null;
        String groupName = null;
        for (DynamicObject dim : dimMappings) {
            String dimType = dim.getString("mappedtype");
            if (!"1".equals(dimType) && !"4".equals(dimType)) continue;
            TreeNode temp = new TreeNode();
            temp.setId(dim.getString("id"));
            String text = dim.getString("name").replaceFirst("-", "<-");
            temp.setText(text);
            temp.setParentid(root.getId());
            if (!this.isFormulaTab()) {
                children.add(temp);
            }
            if (!"4".equals(dimType)) continue;
            groupId = dim.getString("id");
            groupName = dim.getString("name");
        }
        if (context.getSource().hasExpr() && this.isFormulaTab() && groupId != null && groupName != null) {
            TreeNode formula = new TreeNode();
            formula.setId(groupId + TAIL);
            formula.setText(String.format(ResManager.loadKDString((String)"%s\uff08\u53d6\u6570\u516c\u5f0f\uff09", (String)"ISDimMemberAndComSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName));
            formula.setParentid(root.getId());
            children.add(formula);
        }
        if (!context.getSource().hasExpr()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap1"});
        }
        TreeView tree = this.getCurrentTree();
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.setRootVisible(false);
        TreeNode treeNode = focusNode = children.size() > 0 ? (TreeNode)children.get(0) : root;
        if (!this.isFormulaTab() && this.getPageCache().get(CACHE_SELECTNODE) != null) {
            focusNode = new TreeNode(root.getId(), this.getPageCache().get(CACHE_SELECTNODE), "");
        }
        tree.focusNode(focusNode);
        this.treeNodeClickDo(new TreeNodeEvent((Object)tree, (Object)focusNode.getParentid(), (Object)focusNode.getId()));
    }

    public SpreadManager getSpreadManager() {
        if (this.spreadManager == null) {
            String serial = this.getPageCache().get("KEY_SPREAD_MODEL");
            if (StringUtils.isNotEmpty((String)serial)) {
                this.spreadManager = JsonSerializerUtil.toSpreadManager((String)serial);
            } else {
                this.spreadManager = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"ISDimMemberAndComSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSeria(this.spreadManager));
            }
        }
        return this.spreadManager;
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.spreadManager = spread;
        this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSeria(spread));
    }

    public String getSpreadModelSeria(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_import": {
                DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
                String status = scheme.getString("status");
                if ("0".equals(status)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ISDimMemberAndComSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "btn_refresh": {
                TreeView tree = (TreeView)this.getControl(TREEVIEW);
                List selectedNodeId = tree.getTreeState().getSelectedNodeId();
                this.getPageCache().put("nodeid", (String)selectedNodeId.get(0));
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "transformdebug": {
                this.transformdebug();
                break;
            }
            case "bar_save": {
                this.doSave();
                break;
            }
            case "btn_automatchng": {
                this.autoMatchNG();
                break;
            }
            case "btn_automatchnumber": {
                this.autoMatchNumber();
                break;
            }
            case "btn_filltarget": {
                this.fillTargetMember();
                break;
            }
            case "btn_matchtmp": {
                this.showTmp();
                break;
            }
            case "btn_formulasetting": {
                this.showFormulaSettingPage();
                break;
            }
            case "btn_import": {
                if (this.isDetailedDimMapping()) {
                    if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\u3002", (String)"ISDimMemberAndComSettingPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.importDimMemberSetting();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5177\u4f53\u7684\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"ISDimMemberAndComSettingPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_export": {
                if (this.isDetailedDimMapping()) {
                    this.exportDimMemberSetting();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5177\u4f53\u7684\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"ISDimMemberAndComSettingPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_refresh": {
                this.checkChange();
                break;
            }
            case "btn_namerule": {
                this.openNameRule();
                break;
            }
            default: {
                this.getHahdel().itemClick(itemKey);
            }
        }
    }

    private void checkChange() {
        List<Object> need2Save = new ArrayList<DynamicObject>(10);
        try {
            need2Save = this.getHahdel().collectDynamicObjects();
        }
        catch (KDBizException e) {
            need2Save.add(new DynamicObject());
        }
        if (need2Save.size() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4fee\u6539\uff0c\u8981\u653e\u5f03\u4fee\u6539\u7684\u5185\u5bb9\u76f4\u63a5\u5237\u65b0\u5417\uff1f", (String)"RptAdjustOffsetPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("refreshSpreadData", (IFormPlugin)this));
        } else {
            String nodeId = this.getPageCache().get(CACHE_LASTNODE);
            this.changeNode(nodeId);
        }
    }

    private void openNameRule() {
        FormShowParameter fp = new FormShowParameter();
        fp.setFormId("bcm_isinienamerule");
        fp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, NAMERULE);
        fp.setCloseCallBack(closeCallBack);
        HashMap params = new HashMap(16);
        LinkedList<String> selectList = new LinkedList<String>();
        Long schemeid = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        QFilter pf = new QFilter(SCHEME, "=", (Object)schemeid);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_iniruledata", (String)"value", (QFilter[])new QFilter[]{pf}, (String)"ordernum asc");
        if (load.length > 0) {
            for (int i = 0; i < load.length; ++i) {
                DynamicObject dynamicObject = load[i];
                selectList.add(dynamicObject.getString("value"));
            }
        } else {
            selectList.add(RpaIniFileEnum.ENTERPRISECODE.getCode());
            selectList.add(RpaIniFileEnum.REPORTTYPECODE.getCode());
        }
        params.put("defaultruleselect", selectList);
        fp.setCaption(ResManager.loadKDString((String)"\u4e45\u5176\u7ec4\u7ec7\u7f16\u7801\u89c4\u5219", (String)"ISDimMemberAndComSettingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        fp.setCustomParams(params);
        this.getView().showForm(fp);
    }

    private boolean isDetailedDimMapping() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        return !"0".equals(focusNodeId);
    }

    private void exportDimMemberSetting() {
        String focusNodeId;
        Long schemeId = (Long)((DynamicObject)this.getModel().getValue(SCHEME)).getPkValue();
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        String dimMappingId = focusNodeId = tree.getTreeState().getFocusNodeId();
        String selectField = "id,name,number,seq,mappedtype,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmapsrcentry.srcdimension,isdimmapsrcentry.srcdimtype";
        if (dimMappingId.endsWith(TAIL)) {
            dimMappingId = dimMappingId.replace(TAIL, "");
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(dimMappingId));
        DynamicObject dimMapping = BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)selectField, (QFilter[])qFilter.toArray());
        IDimMapMemberExport exportInstance = DimMappingExportFactory.getDimMappingExportInstance(dimMapping.getString("mappedtype"), focusNodeId);
        XSSFWorkbook workBook = new XSSFWorkbook();
        String sheetName = exportInstance.getSheetName(dimMapping);
        XSSFSheet sheet = workBook.createSheet(sheetName);
        exportInstance.buildSheetHead(workBook, sheet, dimMapping);
        exportInstance.writeData(schemeId, Long.valueOf(dimMappingId), sheet);
        exportInstance.setAutoSizeColumn(sheet);
        exportInstance.export(workBook, this.getClientViewProxy());
    }

    private void importDimMemberSetting() {
        String focusNodeId;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        boolean supportImport = DimMappingMemImportHandle.isSupportImport(scheme);
        if (!supportImport) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u6e90\u548c\u96c6\u6210\u76ee\u6807\u7684\u65b9\u6848\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"ISDimMemberAndComSettingPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        String dimMappingId = focusNodeId = tree.getTreeState().getFocusNodeId();
        String selectField = "id,name,number,seq,mappedtype,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmapsrcentry.srcdimension,isdimmapsrcentry.srcdimtype";
        if (dimMappingId.endsWith(TAIL)) {
            dimMappingId = dimMappingId.replace(TAIL, "");
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(dimMappingId));
        DynamicObject dimMapping = BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)selectField, (QFilter[])qFilter.toArray());
        Long schemeId = scheme.getLong("id");
        Long modelId = ((DynamicObject)this.getValue("model")).getLong("id");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_dimmemberimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53ca\u7ec4\u5408\u8bbe\u7f6e", (String)"ISDimMemberAndComSettingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("dimMapping", (Object)this.toByteSerialized(dimMapping));
        showParameter.setCustomParam(SCHEME, (Object)this.toByteSerialized(scheme));
        showParameter.setCustomParam("focusNodeId", (Object)focusNodeId);
        this.getView().showForm(showParameter);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close", (IFormPlugin)this));
        }
    }

    private void showFormulaSettingPage() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId("bcm_isformulasetting");
        DynamicObject setting = QueryServiceHelper.queryOne((String)"bcm_isformulasetting", (String)"id", (QFilter[])QFilter.of((String)"scheme = ?", (Object[])new Object[]{scheme.getPkValue()}).toArray());
        if (setting != null) {
            bsp.setPkId((Object)setting.getLong("id"));
        } else {
            bsp.setCustomParam(SCHEME, scheme.getPkValue());
        }
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void showTmp() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bcm_templatef7", (boolean)false);
        lsp.getListFilterParameter().setFilter(new QFilter("model", "=", (Object)this.getModelId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "automatchtmp");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void autoMatchNumber() {
        MemAndComVO memAndComVO = this.getMemAndComVO();
        if (memAndComVO == null) {
            return;
        }
        MappingContext mappingContext = this.getMappingContext();
        this.getHahdel().autoMatchNumber(memAndComVO, mappingContext);
    }

    private void autoMatchNG() {
        MemAndComVO memAndComVO = this.getMemAndComVO();
        if (memAndComVO == null) {
            return;
        }
        MappingContext mappingContext = this.getMappingContext();
        this.getHahdel().autoMatchNG(memAndComVO, mappingContext);
    }

    private void autoMatchTmp(Object tmpid) {
        MemAndComVO memAndComVO = this.getMemAndComVO();
        if (memAndComVO == null) {
            return;
        }
        MappingContext mappingContext = this.getMappingContext();
        this.getHahdel().autoMatchTMP(memAndComVO, mappingContext, tmpid);
    }

    private void fillTargetMember() {
        MemAndComVO memAndComVO = this.getMemAndComVO();
        if (memAndComVO == null) {
            return;
        }
        MappingContext mappingContext = this.getMappingContext();
        this.getHahdel().fillTargetMember(memAndComVO, mappingContext);
    }

    private void doSave() {
        boolean enable = ((DynamicObject)this.getModel().getValue(SCHEME)).getBoolean("enable");
        if (!enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"ISDimMemberAndComSettingPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long schemeid = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeid)});
        if (schemeDyn.getBoolean("status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ISDimMemberAndComSettingPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getHahdel().checkAndUpdate();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), COMMEM_SPREAD, params);
    }

    public void actionSave(String spreadJson) {
        this.getHahdel().actionSave(spreadJson);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject(SCHEME);
        scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, modifier, modifytime", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{scheme.getLong("id")}).toArray());
        scheme.set("modifier", (Object)RequestContext.get().getUserId());
        scheme.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
    }

    private AbstractMemMapSheetHandel getHahdel() {
        return MapViewManager.getViewHandel(this, COMMEM_SPREAD);
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("cellf7callback".equals(key)) {
            this.getHahdel().closedCallBack(closedCallBackEvent);
        } else if ("automatchtmp".equals(key)) {
            if (closedCallBackEvent.getReturnData() != null) {
                Object tmpId = ((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).get(0).getPrimaryKeyValue();
                this.autoMatchTmp(tmpId);
            }
        } else if (NAMERULE.equals(key)) {
            Long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
            this.saveIniRule(closedCallBackEvent.getReturnData(), schemeId);
        }
    }

    private void saveIniRule(Object returnData, long schemeId) {
        if (returnData == null) {
            return;
        }
        QFilter qf = new QFilter(SCHEME, "=", (Object)schemeId);
        try (TXHandle tx = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bcm_iniruledata", (QFilter[])new QFilter[]{qf});
                DynamicObject saveData = null;
                List dataList = (List)returnData;
                DynamicObject[] doArr = new DynamicObject[dataList.size()];
                long userId = Long.parseLong(RequestContext.get().getUserId());
                Date date = new Date();
                for (int i = 0; i < dataList.size(); ++i) {
                    saveData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_iniruledata");
                    saveData.set(SCHEME, (Object)schemeId);
                    saveData.set("type", (Object)"1");
                    saveData.set("value", dataList.get(i));
                    saveData.set("ordernum", (Object)i);
                    saveData.set("creater", (Object)userId);
                    saveData.set("createdate", (Object)date);
                    saveData.set("modifier", (Object)userId);
                    saveData.set("modifydate", (Object)date);
                    doArr[i] = saveData;
                }
                SaveServiceHelper.save((DynamicObject[])doArr);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    @Override
    public void spreadF7Click(int row, int col) {
        super.spreadF7Click(row, col);
        this.getHahdel().spreadF7Click(row, col);
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        this.getHahdel().spreadF7LookUpData(args);
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        this.getHahdel().setSpreadF7Item(arg);
    }

    @Override
    public SpreadManager getSpreadModel() {
        return this.getSpreadManager();
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc\u3002", (String)"ISDimMemberAndComSettingPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void transformdebug() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bcm_transformdebug");
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean isFormulaTab() {
        Tab subTab = (Tab)this.getControl("tabap");
        return "tabpageap1".equals(subTab.getCurrentTab());
    }

    private TreeView getCurrentTree() {
        String control = "";
        control = this.isFormulaTab() ? TREEVIEW1 : TREEVIEW;
        return (TreeView)this.getControl(control);
    }

    protected void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "checkParamValue", "V", true, true, true);
    }

    public void checkParamValue() {
        int startCol = this.getSpreadSelector().getStartCol();
        int startRow = this.getSpreadSelector().getStartRow();
        Object value = this.getSpreadModel().getBook().getSheet(0).getCell(startRow, startCol).getValue();
        if (value == null) {
            return;
        }
        String[] split = value.toString().split(";");
        if (split.length < 2) {
            return;
        }
        Object res = "";
        if ("1".equals(split[0])) {
            res = ConfigServiceHelper.getStringParamNoModel((String)split[1]);
        } else if ("2".equals(split[0])) {
            res = ConfigServiceHelper.getGlobalBoolParam((String)split[1]);
        } else if ("3".equals(split[0])) {
            res = ConfigServiceHelper.getBoolParam((Long)Long.parseLong(split[2]), (String)split[1]);
        } else if ("4".equals(split[0])) {
            res = ConfigServiceHelper.getStringParam((Long)Long.parseLong(split[2]), (String)split[1]);
        }
        this.getView().showSuccessNotification(value.toString() + ":" + res);
    }
}

