/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.report.export.FloatAreaInfo;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import org.apache.commons.lang3.tuple.Triple;

public class ISGroupSetting4ExportPlugin
extends AbstractBaseFormPlugin {
    private static final String GROUPSCOPE = "groupscope";
    private static final String GROUPBY = "groupby";
    private static final String GROUPBYNAME = "groupbyname";
    private static final String GROUPFIELDS = "groupfields";
    private static final String GROUPFIELDSNUM = "groupfieldsnum";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTN_OK = "btnok";
    private String[] datatype;

    public ISGroupSetting4ExportPlugin() {
        this.datatype = new String[]{DataTypeEnum.TXT.index, DataTypeEnum.ENUMTP.index};
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        entry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                if (cellClickEvent.getFieldKey().equals(ISGroupSetting4ExportPlugin.GROUPFIELDS)) {
                    ISGroupSetting4ExportPlugin.this.setGroupFields(cellClickEvent.getRow());
                } else if (cellClickEvent.getFieldKey().equals(ISGroupSetting4ExportPlugin.GROUPBYNAME)) {
                    ISGroupSetting4ExportPlugin.this.setGroupby(cellClickEvent.getRow());
                }
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
                if (cellClickEvent.getFieldKey().equals(ISGroupSetting4ExportPlugin.GROUPFIELDS)) {
                    ISGroupSetting4ExportPlugin.this.setGroupFields(cellClickEvent.getRow());
                } else if (cellClickEvent.getFieldKey().equals(ISGroupSetting4ExportPlugin.GROUPBYNAME)) {
                    ISGroupSetting4ExportPlugin.this.setGroupby(cellClickEvent.getRow());
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf((Long)this.getFormCustomParam("modelId")));
        this.initData();
    }

    private void initData() {
        this.buildGroupScopeCombItem();
        this.buildRows();
    }

    private void buildRows() {
        List groupSetting;
        if (this.getFormCustomParam("groupSetting") != null && !ObjectUtils.isEmpty((Object)(groupSetting = (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("groupSetting")))))) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, groupSetting.size());
            this.getModel().getEntryEntity(ENTRYENTITY).remove(groupSetting.size());
            this.getModel().beginInit();
            for (int i = 0; i < groupSetting.size(); ++i) {
                this.getModel().setValue(GROUPSCOPE, ((Triple)groupSetting.get(i)).getLeft(), i);
                this.getModel().setValue(GROUPBY, ((Triple)groupSetting.get(i)).getMiddle(), i);
                this.getModel().setValue(GROUPFIELDS, ((Pair)((Triple)groupSetting.get((int)i)).getRight()).p2, i);
                this.getModel().setValue(GROUPFIELDSNUM, ((Pair)((Triple)groupSetting.get((int)i)).getRight()).p1, i);
                this.getModel().setValue(GROUPBYNAME, (Object)this.getGroupByItems(i).get(((Triple)groupSetting.get(i)).getMiddle()), i);
            }
            this.getModel().endInit();
        }
    }

    private void setGroupby(int row) {
        Object scope = this.getModel().getValue(GROUPSCOPE, row);
        if (ObjectUtils.isEmpty((Object)scope)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\u8303\u56f4\u3002", (String)"ISGroupSetting4ExportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            Map<String, String> groupByItems = this.getGroupByItems(row);
            this.getPageCache().put("currentRow", String.valueOf(row));
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_isgroupsettinggroupby");
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_isgroupsettinggroupby"));
            param.setCustomParam("modelId", (Object)this.getModelId());
            param.setCustomParam("ExtModelNumber", (Object)this.getExtModelNumberByGroupScope(scope.toString()));
            param.setCustomParam(GROUPSCOPE, scope);
            param.setCustomParam(GROUPBY, (Object)ObjectSerialUtil.toByteSerialized(groupByItems));
            param.setCustomParam("sm", (Object)this.getPageCache().get("sm"));
            this.getView().showForm(param);
        }
    }

    private String getExtModelNumberByGroupScope(String scope) {
        SpreadManager spreadManager = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("sm"));
        Set positionInfos = spreadManager.getAreaManager().getPostionInfoSet();
        for (PositionInfo position : positionInfos) {
            ExtendInfo extendInfo = position.getExtendInfo();
            if (extendInfo == null || !scope.equals(position.getAreaRange())) continue;
            return extendInfo.getExtModelNumber();
        }
        return null;
    }

    private void setGroupFields(int row) {
        if (this.getModel().getValue(GROUPBY, row) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\u4f9d\u636e\u3002", (String)"ISGroupSetting4ExportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("currentRow", String.valueOf(row));
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_isgroupsettingfeilds");
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_isgroupsettingfeilds"));
            param.setCustomParam("modelId", (Object)this.getModelId());
            param.setCustomParam(GROUPSCOPE, this.getModel().getValue(GROUPSCOPE, row));
            param.setCustomParam(GROUPBY, this.getModel().getValue(GROUPBY, row));
            param.setCustomParam("sm", (Object)this.getPageCache().get("sm"));
            if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(GROUPFIELDSNUM, row)) && !ObjectUtils.isEmpty((Object)this.getModel().getValue(GROUPFIELDS, row))) {
                param.setCustomParam("oneGroupSetting", (Object)ObjectSerialUtil.toByteSerialized((Object)Pair.onePair((Object)this.getModel().getValue(GROUPFIELDSNUM, row), (Object)this.getModel().getValue(GROUPFIELDS, row))));
            }
            this.getView().showForm(param);
        }
    }

    private void buildGroupScopeCombItem() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getFormCustomParam("template_id")))) {
            this.getPageCache().put("template_id", (String)this.getFormCustomParam("template_id"));
            Long templateId = LongUtil.toLong((Object)this.getFormCustomParam("template_id"));
            DynamicObject temp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,rptdata,model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
            ArrayList tempComboIts = new ArrayList(16);
            SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)temp.getString("rptdata"));
            Set postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
            this.getPageCache().put("sm", ObjectSerialUtil.toByteSerialized((Object)spreadManager));
            ArrayList<FloatAreaInfo> floatAreaInfos = new ArrayList<FloatAreaInfo>(10);
            for (PositionInfo position : postionInfoSet) {
                for (BasePointInfo basePointInfo : position.getBasePoints()) {
                    floatAreaInfos.add(new FloatAreaInfo(basePointInfo.getDynaRange(), basePointInfo.getOriginalDynaRange()));
                }
                ExtendInfo extendInfo = position.getExtendInfo();
                if (extendInfo == null) continue;
                floatAreaInfos.add(new FloatAreaInfo(position.getAreaRange(), position.getOriginalAreaRange()));
            }
            Collections.sort(floatAreaInfos);
            floatAreaInfos.forEach(f -> {
                ComboItem tempComboIt = new ComboItem();
                tempComboIt.setCaption(new LocaleString(f.getDynRange()));
                tempComboIt.setValue(f.getDynRange());
                tempComboIts.add(tempComboIt);
            });
            ComboEdit tempComboEdit = (ComboEdit)this.getControl(GROUPSCOPE);
            tempComboEdit.setComboItems(new ArrayList(tempComboIts));
        }
    }

    private Map<String, String> getGroupByItems(int row) {
        HashMap<String, String> byItems = new HashMap<String, String>(16);
        String scope = this.getModel().getValue(GROUPSCOPE, row).toString();
        SpreadManager spreadManager = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("sm"));
        Set positionInfos = spreadManager.getAreaManager().getPostionInfoSet();
        block0: for (PositionInfo position : positionInfos) {
            for (BasePointInfo basePointInfo : position.getBasePoints()) {
                if (!scope.equals(basePointInfo.getDynaRange())) continue;
                basePointInfo.getBasePointInnerLineInfo().forEach(l -> byItems.put(l.getDimension().getNumber(), l.getDimension().getName()));
                break block0;
            }
            ExtendInfo extendInfo = position.getExtendInfo();
            if (extendInfo == null || !scope.equals(position.getAreaRange())) continue;
            this.setExtItems(extendInfo, byItems);
            break;
        }
        return byItems;
    }

    private void setExtItems(ExtendInfo extendInfo, Map<String, String> byItems) {
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter extQf = new QFilter("level", "=", (Object)3).and("parent.number", "=", (Object)extendInfo.getExtGroup()).and("datatype", "in", (Object)this.datatype);
        if (!CollectionUtils.isEmpty((Collection)extendInfo.getCols())) {
            extQf.and("number", "in", (Object)extendInfo.getCols());
            DynamicObject[] extFields = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"id,number,name,datatype", (QFilter[])new QFilter[]{modelQf, extQf});
            Arrays.stream(extFields).forEach(f -> byItems.put(f.getString("number"), f.getString("name")));
        }
        if (extendInfo.getFloatdims().size() > 0) {
            extendInfo.getFloatdims().forEach(d -> byItems.put(d.getDimension().getNumber(), d.getDimension().getName()));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            ArrayList<Triple> returnData = new ArrayList<Triple>(10);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<String> validateGroupBy = new ArrayList<String>(entryentity.size() + 1);
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject rowData = (DynamicObject)entryentity.get(i);
                if (StringUtils.isEmpty((CharSequence)rowData.getString(GROUPBY))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4f9d\u636e\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISGroupSetting4ExportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (validateGroupBy.contains(rowData.getString(GROUPSCOPE))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u8303\u56f4\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ISGroupSetting4ExportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                validateGroupBy.add(rowData.getString(GROUPSCOPE));
                returnData.add(Triple.of((Object)rowData.getString(GROUPSCOPE), (Object)rowData.getString(GROUPBY), (Object)Pair.onePair((Object)rowData.getString(GROUPFIELDSNUM), (Object)rowData.getString(GROUPFIELDS))));
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (GROUPSCOPE.equals(key)) {
            if (this.groupscopeExist(rowIndex, e.getChangeSet()[0].getNewValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u8303\u56f4\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ISGroupSetting4ExportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue(GROUPBY, null, rowIndex);
            this.getModel().setValue(GROUPBYNAME, null, rowIndex);
            this.getModel().setValue(GROUPFIELDSNUM, null, rowIndex);
            this.getModel().setValue(GROUPFIELDS, null, rowIndex);
        } else if (GROUPBYNAME.equals(key)) {
            this.getModel().setValue(GROUPFIELDSNUM, null, rowIndex);
            this.getModel().setValue(GROUPFIELDS, null, rowIndex);
            if (ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getNewValue())) {
                this.getModel().setValue(GROUPBY, null, rowIndex);
            }
        } else if (GROUPFIELDS.equals(key) && ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getNewValue())) {
            this.getModel().setValue(GROUPFIELDSNUM, null, rowIndex);
            this.getModel().setValue(GROUPFIELDS, null, rowIndex);
        }
    }

    private boolean groupscopeExist(int rowIndex, Object newValue) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryentity.size(); ++i) {
            if (rowIndex == i || newValue == null || !newValue.equals(((DynamicObject)entryentity.get(i)).getString(GROUPSCOPE))) continue;
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Pair returnData;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if ("bcm_isgroupsettingfeilds".equals(action) && closedCallBackEvent.getReturnData() != null) {
            returnData = (Pair)closedCallBackEvent.getReturnData();
            this.getPageCache().put("returnData", returnData.toString());
            this.getModel().setValue(GROUPFIELDS, returnData.p2, Integer.parseInt(this.getPageCache().get("currentRow")));
            this.getModel().setValue(GROUPFIELDSNUM, returnData.p1, Integer.parseInt(this.getPageCache().get("currentRow")));
        }
        if ("bcm_isgroupsettinggroupby".equals(action) && closedCallBackEvent.getReturnData() != null) {
            returnData = (Pair)closedCallBackEvent.getReturnData();
            this.getPageCache().put("returnData", returnData.toString());
            this.getModel().setValue(GROUPBY, returnData.p1, Integer.parseInt(this.getPageCache().get("currentRow")));
            this.getModel().setValue(GROUPBYNAME, returnData.p2, Integer.parseInt(this.getPageCache().get("currentRow")));
        }
    }
}

