/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.SpreadMulItemClassEdit;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import org.apache.commons.lang3.ObjectUtils;

public class ISGroupSettingFieldsPlugin
extends AbstractBaseFormPlugin {
    private static final String GROUPSCOPE = "groupscope";
    private static final String GROUPBY = "groupby";
    private static final String GROUPFIELDS = "groupfields";
    private static final String GROUPFIELDSVALUE = "fieldsvalue";
    private static final String VALUENUMBER = "valuenumber";
    private static final String DIMNAME = "dimname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTN_OK = "btnok";
    private static final String F7 = "f7";
    private static final String CURRENTROW = "currentRow";
    private static final String CURRENTDIM = "currentDim";
    private static final String dimNum2NameMap = "dimNum2NameMap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
        ItemClassEdit f7 = (ItemClassEdit)this.getControl(F7);
        f7.addAfterF7SelectListener(this::afterSelectValues);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        entry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                if (cellClickEvent.getFieldKey().equals(ISGroupSettingFieldsPlugin.GROUPFIELDSVALUE)) {
                    ISGroupSettingFieldsPlugin.this.fieldValueCLick(cellClickEvent.getRow());
                }
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
                if (cellClickEvent.getFieldKey().equals(ISGroupSettingFieldsPlugin.GROUPFIELDSVALUE)) {
                    ISGroupSettingFieldsPlugin.this.fieldValueCLick(cellClickEvent.getRow());
                }
            }
        });
    }

    private void afterSelectValues(AfterF7SelectEvent evt) {
        ListSelectedRowCollection returnData = evt.getListSelectedRowCollection();
        int row = Integer.parseInt(this.getPageCache().get(CURRENTROW));
        if (returnData == null) {
            this.getModel().setValue(GROUPFIELDSVALUE, null, row);
        } else {
            StringBuilder sbName = new StringBuilder();
            StringBuilder sbNum = new StringBuilder();
            String groupField = (String)this.getModel().getValue(GROUPFIELDS, row);
            Map dimNum2Namemap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(dimNum2NameMap));
            sbNum.append(this.getModel().getValue(GROUPFIELDS, row)).append("!");
            if (ObjectUtils.isEmpty((Object)dimNum2Namemap) || dimNum2Namemap.get(groupField) == null) {
                returnData.forEach(d -> {
                    sbName.append(d.getName()).append(",");
                    sbNum.append(d.getPrimaryKeyValue()).append(",");
                });
            } else {
                returnData.forEach(d -> {
                    sbName.append(d.getName()).append(",");
                    sbNum.append(d.getNumber()).append(",");
                });
            }
            this.getModel().setValue(GROUPFIELDSVALUE, (Object)sbName.substring(0, sbName.length() - 1), row);
            this.getModel().setValue(VALUENUMBER, (Object)sbNum.substring(0, sbNum.length() - 1), row);
        }
    }

    private void fieldValueCLick(int row) {
        if (this.getModel().getValue(GROUPFIELDS, row) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u5206\u7ec4\u5b57\u6bb5\u3002", (String)"ISGroupSettingFieldsPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CURRENTROW, String.valueOf(row));
        this.getPageCache().put(CURRENTDIM, (String)this.getModel().getValue(GROUPFIELDS, row));
        this.handleFieldValueClick(row);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModelInfo();
        this.initData();
    }

    private void initModelInfo() {
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf((Long)this.getFormCustomParam("modelId")));
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)((Long)this.getFormCustomParam("modelId")))};
        DynamicObject[] dims = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"number,name", (QFilter[])filters);
        this.getPageCache().put(dimNum2NameMap, ObjectSerialUtil.toByteSerialized(Arrays.stream(dims).collect(Collectors.toMap(d -> d.getString("number"), d -> d.getString("name")))));
    }

    private void initData() {
        this.buildGroupFieldCombItem();
        this.buildRows();
    }

    private void buildRows() {
        if (this.getFormCustomParam("oneGroupSetting") != null) {
            Pair oneGroupSetting = (Pair)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("oneGroupSetting")));
            String[] fieldsNum = ((String)oneGroupSetting.p1).split(";");
            if (fieldsNum.length > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, fieldsNum.length);
                this.getModel().getEntryEntity(ENTRYENTITY).remove(fieldsNum.length);
            }
            String[] fieldsName = ((String)oneGroupSetting.p2).split(";");
            this.getModel().beginInit();
            for (int i = 0; i < fieldsNum.length; ++i) {
                String[] nums = fieldsNum[i].split("!");
                String[] names = fieldsName[i].split("!");
                this.getModel().setValue(GROUPFIELDS, (Object)nums[0], i);
                this.getModel().setValue(GROUPFIELDSVALUE, (Object)names[1], i);
                this.getModel().setValue(VALUENUMBER, (Object)fieldsNum[i], i);
                this.getModel().setValue(DIMNAME, (Object)names[0], i);
            }
            this.getModel().endInit();
        }
    }

    private void buildGroupFieldCombItem() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getFormCustomParam(GROUPSCOPE)))) {
            HashSet comboItems = new HashSet(16);
            String scope = (String)this.getFormCustomParam(GROUPSCOPE);
            String groupBy = (String)this.getFormCustomParam(GROUPBY);
            SpreadManager spreadManager = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("sm")));
            Set positionInfos = spreadManager.getAreaManager().getPostionInfoSet();
            block0: for (PositionInfo position : positionInfos) {
                for (BasePointInfo basePointInfo : position.getBasePoints()) {
                    if (!scope.equals(basePointInfo.getDynaRange())) continue;
                    basePointInfo.getBasePointInnerLineInfo().forEach(l -> {
                        if (!groupBy.equals(l.getDimension().getNumber())) {
                            ComboItem tempComboIt = new ComboItem();
                            tempComboIt.setCaption(new LocaleString(l.getDimension().getName()));
                            tempComboIt.setValue(l.getDimension().getNumber());
                            comboItems.add(tempComboIt);
                        }
                    });
                    break block0;
                }
                ExtendInfo extendInfo = position.getExtendInfo();
                if (extendInfo == null || !scope.equals(position.getAreaRange())) continue;
                QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
                QFilter extQf = new QFilter("level", "=", (Object)3).and("parent.number", "=", (Object)extendInfo.getExtGroup()).and("datatype", "=", (Object)DataTypeEnum.ENUMTP.index);
                if (!CollectionUtils.isEmpty((Collection)extendInfo.getCols())) {
                    extQf.and("number", "in", (Object)extendInfo.getCols());
                    DynamicObject[] extFields = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"id,number,name,datatype,enumitem", (QFilter[])new QFilter[]{modelQf, extQf});
                    Arrays.stream(extFields).forEach(f -> {
                        if (!groupBy.equals(f.getString("number"))) {
                            ComboItem tempComboIt = new ComboItem();
                            tempComboIt.setCaption(new LocaleString(f.getString("name")));
                            tempComboIt.setValue(f.getString("number"));
                            comboItems.add(tempComboIt);
                            this.getPageCache().put(f.getString("number"), f.getString("name"));
                        }
                    });
                }
                if (extendInfo.getFloatdims().size() <= 0) break;
                extendInfo.getFloatdims().forEach(d -> {
                    if (!groupBy.equals(d.getDimension().getNumber())) {
                        ComboItem tempComboIt = new ComboItem();
                        tempComboIt.setCaption(new LocaleString(d.getDimension().getName()));
                        tempComboIt.setValue(d.getDimension().getNumber());
                        comboItems.add(tempComboIt);
                    }
                });
                break;
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(GROUPFIELDS);
            comboEdit.setComboItems(new ArrayList(comboItems));
        }
    }

    private void handleFieldValueClick(int row) {
        String groupByFields = (String)this.getModel().getValue(GROUPFIELDS, row);
        DynamicObject dimObj = this.getDimInfo(groupByFields);
        this.getModel().setValue("f7type", dimObj == null ? "bcm_enumvalue" : dimObj.get("membermodel"));
        ItemClassEdit bsEdit0 = (ItemClassEdit)this.getControl(F7);
        SpreadMulItemClassEdit bsEdit = new SpreadMulItemClassEdit(bsEdit0);
        bsEdit.setQFilter(this.getQFilterInfo(row));
        bsEdit.addBeforeF7SelectListener(this);
        bsEdit.setF7MultipleSelect(true);
        bsEdit.click();
    }

    private DynamicObject getDimInfo(String dimNumber) {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter numberFilter = new QFilter("number", "=", (Object)dimNumber);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{modelFilter, numberFilter});
    }

    private QFilter getQFilter(long modelid, long dimensionId, List<DynaMembScopeInfo> scope, String dimNumber) {
        return TemplateFloatUtil.getFloatQFilter(modelid, dimensionId, scope, dimNumber);
    }

    private QFilter getExtendQFilter(long modelid, String colNumber, String extGroup) {
        QFilter modelQf = new QFilter("model", "=", (Object)modelid);
        QFilter colQf = new QFilter("number", "=", (Object)colNumber);
        QFilter extQf = new QFilter("level", "=", (Object)3).and("parent.number", "=", (Object)extGroup);
        DynamicObject extFields = BusinessDataServiceHelper.loadSingle((String)"bcm_structofextend", (String)"id,number,name,datatype,enumitem", (QFilter[])new QFilter[]{modelQf, colQf, extQf});
        return modelQf.and("enumitemid", "=", (Object)extFields.getLong("enumitem.id"));
    }

    private QFilter getQFilterInfo(int rowIndex) {
        String scope = (String)this.getFormCustomParam(GROUPSCOPE);
        String groupByFields = (String)this.getModel().getValue(GROUPFIELDS, rowIndex);
        SpreadManager spreadManager = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("sm")));
        Set positionInfos = spreadManager.getAreaManager().getPostionInfoSet();
        for (PositionInfo position : positionInfos) {
            for (BasePointInfo basePointInfo : position.getBasePoints()) {
                List innerInfo;
                if (!scope.equals(basePointInfo.getDynaRange()) || (innerInfo = basePointInfo.getBasePointInnerLineInfo().stream().filter(l -> l.getDimension().getNumber().equals(groupByFields)).collect(Collectors.toList())).size() != 1) continue;
                BasePointInnerLineInfo line = (BasePointInnerLineInfo)innerInfo.get(0);
                return this.getQFilter(this.getModelId(), this.getDimInfo(groupByFields).getLong("id"), line.getDynaMembScopes(), groupByFields);
            }
            ExtendInfo extendInfo = position.getExtendInfo();
            if (extendInfo == null || !scope.equals(position.getAreaRange())) continue;
            if (extendInfo.getFloatDimNums().contains(groupByFields)) {
                return this.getQFilter(this.getModelId(), this.getDimInfo(groupByFields).getLong("id"), extendInfo.getFloatMemberScope(groupByFields), groupByFields);
            }
            if (!extendInfo.getCols().contains(groupByFields)) continue;
            return this.getExtendQFilter(this.getModelId(), groupByFields, extendInfo.getExtGroup());
        }
        return null;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (F7.equals(key)) {
            int rowIndex = Integer.parseInt(this.getPageCache().get(CURRENTROW));
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            String valueNumber = (String)this.getModel().getValue(VALUENUMBER, rowIndex);
            if (StringUtils.isNotEmpty((CharSequence)valueNumber)) {
                QFilter numFilter;
                String groupField = (String)this.getModel().getValue(GROUPFIELDS, rowIndex);
                DynamicObject dimObj = this.getDimInfo(groupField);
                boolean isDimemsion = dimObj != null;
                QFilter filter = this.getQFilterInfo(rowIndex);
                String[] values = valueNumber.split("!")[1].split(",");
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)(isDimemsion ? dimObj.getString("membermodel") : "bcm_enumvalue"), (String)(isDimemsion ? "id,number" : "id"), (QFilter[])new QFilter[]{filter, numFilter = isDimemsion ? new QFilter("number", "in", (Object)values) : new QFilter("id", "in", (Object)LongUtil.toLongList(Arrays.asList(values)))});
                if (ObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return;
                }
                ListSelectedRowCollection listSelectedRowCollection = parameter.getListSelectedRowCollection();
                listSelectedRowCollection.clear();
                for (String value : values) {
                    DynamicObject object;
                    Long id = isDimemsion ? Long.valueOf((object = (DynamicObject)Arrays.stream(dynamicObjects).filter(dyn -> value.equals(dyn.getString("number"))).findFirst().orElse(null)) == null ? 0L : object.getLong("id")) : LongUtil.toLong((Object)value);
                    ListSelectedRow listSelectedRow = new ListSelectedRow((Object)id, Boolean.valueOf(false));
                    listSelectedRowCollection.add((Object)listSelectedRow);
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            StringBuilder num = new StringBuilder();
            StringBuilder name = new StringBuilder();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<String> validateGroupBy = new ArrayList<String>(entryentity.size() + 1);
            for (DynamicObject dyn : entryentity) {
                if (StringUtils.isEmpty((CharSequence)dyn.getString(VALUENUMBER))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u7ec4\u5b57\u6bb5\u503c\u672a\u586b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISGroupSettingFieldsPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (validateGroupBy.contains(dyn.getString(GROUPFIELDS))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ISGroupSettingFieldsPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                validateGroupBy.add(dyn.getString(GROUPFIELDS));
                name.append(dyn.getString(DIMNAME)).append("!").append(dyn.getString(GROUPFIELDSVALUE)).append(";");
                num.append(dyn.getString(VALUENUMBER)).append(";");
            }
            String returnNum = num.length() > 0 ? num.substring(0, num.length() - 1) : num.toString();
            String returnName = name.length() > 0 ? name.substring(0, name.length() - 1) : name.toString();
            this.getView().returnDataToParent((Object)Pair.onePair((Object)returnNum, (Object)returnName));
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (GROUPFIELDS.equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(GROUPFIELDSVALUE, null, rowIndex);
            this.getModel().setValue(VALUENUMBER, null, rowIndex);
            String dimName = (String)((Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(dimNum2NameMap))).get(e.getChangeSet()[0].getNewValue());
            if (StringUtils.isEmpty((CharSequence)dimName)) {
                dimName = this.getPageCache().get((String)e.getChangeSet()[0].getNewValue());
            }
            this.getModel().setValue(DIMNAME, (Object)dimName, rowIndex);
        }
    }
}

