/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ISImpModeSetPlugin
extends AbstractBaseFormPlugin {
    private static final String OTHERDIM = "otherdim";
    private static final String CLEARDATACONFIG = "clearDataConfig";
    private static final String PREDIMENSIONSCOPE = "preDimensionScope";
    private static final String CACHECLEARCONFIG = "cacheClearConfig";
    private static final String CHANGEDIMENSION = "changeDimension";
    private static final String OLD_DIMENSION_VALUE = "old_dimension_value";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DIMENSION = "dimension";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
        dimension.addBeforeF7SelectListener(this::beforeF7Select);
        this.addClickListeners(OTHERDIM);
        this.addClickListeners("btn_ok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (Objects.isNull(parameter.getPkId())) {
            this.getModel().setValue("scheme", parameter.getCustomParam("schemeId"));
            this.getModel().setValue("model", parameter.getCustomParam("KEY_MODEL_ID"));
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{OTHERDIM});
    }

    private void setFromDiVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{NUMBER, NAME});
        this.getModel().setValue(NUMBER, (Object)(NUMBER + System.currentTimeMillis()));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String importmode = (String)this.getModel().getValue("importmode");
        if (ISImpModeEnum.REPLACEIMPORT.getCode().equals(importmode)) {
            BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
            dimension.setMustInput(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{OTHERDIM});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{OTHERDIM});
        }
        this.setClearDataDisAndCache();
        this.setFromDiVisible();
        this.setClearDataText();
        if (this.isXExtendProduct().booleanValue()) {
            this.setExtView();
        }
    }

    private void setExtView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{DIMENSION, "flexpanelap6"});
        Label label = (Label)this.getView().getControl("labelap2");
        label.setText(ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u6839\u636e\u62d3\u5c55\u6a21\u578b\u552f\u4e00\u6027\u5b57\u6bb5\u4fdd\u7559\u7ef4\u5ea6\u6620\u5c04\u4e2d\u8bbe\u7f6e\u7684\u4fdd\u7559\u5b57\u6bb5\u6570\u636e\u3002", (String)"ISImpModeSetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (DIMENSION.equals(key)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Long modelId = (Long)showParameter.getCustomParam("KEY_MODEL_ID");
            Long schemeId = (Long)showParameter.getCustomParam("schemeId");
            QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
            qFilter.and("mappedtype", "=", (Object)DimMappTypeEnum.TARGET_DEFAULT.getCode());
            DynamicObjectCollection tarLackDimMaps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"isdimmaptargentry,isdimmaptargentry.tagdimension.number,isdimmaptargentry.tagdimtype", (QFilter[])qFilter.toArray());
            ArrayList dimNums = new ArrayList(16);
            tarLackDimMaps.forEach(t -> dimNums.add(t.getString("isdimmaptargentry.tagdimension.number")));
            ArrayList filterDimNum = Lists.newArrayList((Object[])new String[]{DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.YEAR.getNumber(), DimEntityNumEnum.PERIOD.getNumber(), DimEntityNumEnum.ENTITY.getNumber(), DimEntityNumEnum.CURRENCY.getNumber(), DimEntityNumEnum.PROCESS.getNumber()});
            dimNums.removeAll(filterDimNum);
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            qf.and(NUMBER, "in", dimNums);
            beforeF7SelectEvent.addCustomQFilter(qf);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CHANGEDIMENSION.equals(callBackId)) {
            if ("No".equals(messageBoxClosedEvent.getResultValue())) {
                String oldValue = this.getPageCache().get(OLD_DIMENSION_VALUE);
                this.getModel().setValue(DIMENSION, (Object)Long.valueOf(oldValue));
            } else {
                this.getModel().setValue(OTHERDIM, null);
                this.getPageCache().put(PREDIMENSIONSCOPE, null);
                this.getPageCache().put(CACHECLEARCONFIG, null);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("importmode".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
            if (ISImpModeEnum.MERGEIMPORT.getCode().equals(newValue)) {
                ThreadCache.put((Object)"importmode", (Object)true);
                this.getModel().setValue(DIMENSION, null);
                this.setClearNull();
                dimension.setMustInput(false);
            } else {
                dimension.setMustInput(true);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{OTHERDIM});
                if (this.isXExtendProduct().booleanValue()) {
                    this.setImportModel();
                    this.setExtView();
                }
            }
        } else if (DIMENSION.equals(name)) {
            if (ThreadCache.get((Object)"importmode") != null) {
                ThreadCache.clear();
                return;
            }
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue == null && oldValue != null || newValue != null && oldValue != null && oldValue.getLong("id") != newValue.getLong("id") && !String.valueOf(newValue.getLong("id")).equals(this.getPageCache().get(OLD_DIMENSION_VALUE))) {
                this.getPageCache().put(OLD_DIMENSION_VALUE, "" + oldValue.getLong("id"));
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGEDIMENSION);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u6e05\u9664\u201c\u6307\u5b9a\u5176\u5b83\u66ff\u6362\u7ef4\u5ea6\u201d\u7684\u6240\u6709\u8bbe\u7f6e\uff0c\u4ecd\u8981\u8fdb\u884c\uff1f", (String)"ModelOlapOperationPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
    }

    private void setImportModel() {
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)parameter.getCustomParam("schemeId"), (String)"bcm_isscheme");
        QFilter atQf = new QFilter("model", "=", (Object)scheme.getLong("model_id"));
        atQf.and(NUMBER, "=", (Object)"AuditTrail");
        DynamicObject atDimension = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id", (QFilter[])atQf.toArray());
        this.getModel().setValue(DIMENSION, (Object)atDimension);
    }

    private Boolean isXExtendProduct() {
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)parameter.getCustomParam("schemeId"), (String)"bcm_isscheme", (String)"issrc.number");
        if (scheme != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setClearNull() {
        this.getModel().setValue(OTHERDIM, null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{OTHERDIM});
        this.getPageCache().put(PREDIMENSIONSCOPE, null);
        this.getPageCache().put(CACHECLEARCONFIG, null);
    }

    @Override
    public void click(EventObject evt) {
        TextEdit button;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && OTHERDIM.equals(key = (button = (TextEdit)source).getKey())) {
            this.openClearDataPage();
        }
    }

    private void openClearDataPage() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u66ff\u6362\u7ef4\u5ea6", (String)"ModelOlapOperationPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        String formid = "bcm_model_olap";
        formShowParameter.setFormId(formid);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u6e05\u9664", (String)"ISSchemeDataCollectPlugin2_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("isShowLog", (Object)Boolean.TRUE);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("operationStatus", (Object)false);
        formShowParameter.setCustomParam("isClearData", (Object)true);
        if (dimension != null) {
            formShowParameter.setCustomParam("replacedimension", (Object)dimension.getString(NUMBER));
        }
        formShowParameter.setCustomParam("isEdit", (Object)true);
        formShowParameter.setCustomParam("paramData", this.getDimensionScope());
        formShowParameter.setCustomParam("pageFrom", (Object)"IsScheme");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLEARDATACONFIG));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && CLEARDATACONFIG.equals(actionId)) {
            this.setClearDataText();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        List pkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
        if ("save".equalsIgnoreCase(operateKey)) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.saveClearDataConfig((Long)pkIds.get(0));
            } else {
                this.getView().showTipNotification(afterDoOperationEventArgs.getOperationResult().getMessage());
            }
        }
    }

    private void saveClearDataConfig(Long id) {
        String returnDataStr = this.getPageCache().get(CACHECLEARCONFIG);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        QFilter qf = new QFilter("isscheme", "=", (Object)scheme.getLong("id"));
        if (StringUtils.isEmpty((String)returnDataStr)) {
            DeleteServiceHelper.delete((String)"bcm_iscleardataconfig", (QFilter[])new QFilter[]{qf});
            return;
        }
        LinkedHashMap cacheMap = (LinkedHashMap)JSONObject.parseObject((String)returnDataStr, LinkedHashMap.class);
        Map innerMap = null;
        JSONArray ja = null;
        JSONObject jo = null;
        DynamicObject clearConfig = null;
        ArrayList<DynamicObject> clearConfigList = new ArrayList<DynamicObject>();
        for (Map.Entry map : cacheMap.entrySet()) {
            innerMap = (Map)map.getValue();
            ja = (JSONArray)innerMap.get("dimList");
            for (Object object : ja) {
                jo = (JSONObject)object;
                clearConfig = BusinessDataServiceHelper.newDynamicObject((String)"bcm_iscleardataconfig");
                clearConfig.set("dimmemberid", (Object)jo.getLong("id"));
                clearConfig.set("dimtype", map.getKey());
                clearConfig.set("membernumber", (Object)jo.getString(NUMBER));
                clearConfig.set("scope", (Object)jo.getString("scope"));
                clearConfig.set("isscheme", (Object)scheme);
                clearConfigList.add(clearConfig);
            }
        }
        DeleteServiceHelper.delete((String)"bcm_iscleardataconfig", (QFilter[])new QFilter[]{qf});
        SaveServiceHelper.save((DynamicObject[])clearConfigList.toArray(new DynamicObject[0]));
    }

    private Map<String, Map<Long, Integer>> getDimensionScope() {
        Map<String, Map<Long, Integer>> dataMap = new HashMap<String, Map<Long, Integer>>(16);
        String dimensionScopeStr = this.getPageCache().get(PREDIMENSIONSCOPE);
        if (StringUtils.isNotEmpty((String)dimensionScopeStr)) {
            dataMap = (Map)JSONObject.parseObject((String)dimensionScopeStr, Map.class);
        }
        return dataMap;
    }

    private void setClearDataText() {
        String cacheClearConfigStr = this.getPageCache().get(CACHECLEARCONFIG);
        if (StringUtils.isNotEmpty((String)cacheClearConfigStr)) {
            LinkedHashMap cacheMap = (LinkedHashMap)JSONObject.parseObject((String)cacheClearConfigStr, LinkedHashMap.class);
            Map innerMap = null;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry map : cacheMap.entrySet()) {
                innerMap = (Map)map.getValue();
                sb.append((String)innerMap.get("dimDescription"));
                if (sb.length() < 30) continue;
                this.getView().getModel().setValue(OTHERDIM, (Object)(sb.substring(0, 30) + "..."));
                return;
            }
            this.getView().getModel().setValue(OTHERDIM, (Object)sb.toString());
            this.getModel().setDataChanged(false);
        }
    }

    private void setClearDataDisAndCache() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        QFilter qf = new QFilter("isscheme", "=", (Object)scheme.getLong("id"));
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"bcm_iscleardataconfig", (String)"dimmemberid,dimtype,membernumber,scope", (QFilter[])new QFilter[]{qf});
        HashMap<String, Map> dataMap = new HashMap<String, Map>(16);
        Map dimMembers = null;
        LinkedHashMap<String, Map> cacheMap = new LinkedHashMap<String, Map>();
        Map cacheMapInner = null;
        JSONArray ja = null;
        StringBuilder dimDescription = null;
        String dimtype = null;
        Integer scope = null;
        Long membId = null;
        DynamicObject dimObj = null;
        String dimName = null;
        HashSet<String> dimNameSet = new HashSet<String>(configs.size());
        for (DynamicObject dynamicObject : configs) {
            dimtype = dynamicObject.getString("dimtype");
            dimMembers = dataMap.computeIfAbsent(dimtype, k -> new HashMap());
            membId = dynamicObject.getLong("dimmemberid");
            scope = dynamicObject.getInt("scope");
            dimMembers.put(membId, scope);
            cacheMapInner = cacheMap.computeIfAbsent(dimtype, k -> new HashMap());
            ja = (JSONArray)cacheMapInner.computeIfAbsent("dimList", k -> new JSONArray());
            ja.add((Object)this.getDim(dynamicObject));
            dimDescription = (StringBuilder)cacheMapInner.computeIfAbsent("dimDescription", k -> new StringBuilder());
            dimObj = IntegrationUtil.getDimPair((Long)this.getModelId(), (String)dimtype);
            IDNumberTreeNode member = MemberReader.findMemberById((long)this.getModelId(), (String)dimObj.getString("memberform"), (Long)membId);
            String memberName = "";
            if (member.getId() == null || member.getId() == -1L) {
                ArrayList<Long> membIds = new ArrayList<Long>();
                membIds.add(membId);
                Pair memberMap = IntegrateDispatcher2.getMember((DynamicObject)dimObj, membIds);
                memberName = this.getMemberName((Map)memberMap.p2);
            } else {
                memberName = member.getName();
            }
            dimName = !dimNameSet.add(dimObj.getString(NAME)) ? "" : dimObj.getString(NAME) + "|";
            dimDescription.append(dimName).append(memberName).append(this.getScopeDesc(scope));
        }
        this.getPageCache().put(CACHECLEARCONFIG, JSONObject.toJSONString(cacheMap));
        this.getPageCache().put(PREDIMENSIONSCOPE, JSONObject.toJSONString(dataMap));
    }

    private String getMemberName(Map<Object, DynamicObject> memberMap) {
        Iterator<Map.Entry<Object, DynamicObject>> iterator = memberMap.entrySet().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getValue().getString(NAME);
        }
        return null;
    }

    private String getScopeDesc(Integer scope) {
        if (scope.intValue() == RangeEnum.VALUE_10.getValue()) {
            return ";";
        }
        RangeEnum range = RangeEnum.getRangeByVal((int)scope);
        return range.getName() + ";";
    }

    private JSONObject getDim(DynamicObject dynamicObject) {
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)dynamicObject.getLong("dimmemberid"));
        jo.put(NUMBER, (Object)dynamicObject.getString("membernumber"));
        jo.put("scope", (Object)dynamicObject.getString("scope"));
        return jo;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object dimension;
        super.beforeDoOperation(args);
        String importmode = (String)this.getModel().getValue("importmode");
        if ("2".equals(importmode) && (dimension = this.getModel().getValue(DIMENSION)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\u3002", (String)"GuideMenuInitializePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            args.setCancel(true);
        }
    }
}

