/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.integrationnew.enums.NgModelTypeEnum;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMStringUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferHelper;

public class ISNgModelEditPlugin
extends AbstractBasePlugIn
implements IOperationLog,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ISNgModelEditPlugin.class);
    private static final String PHONENUMBER = "phonenumber";
    private static final String PASSWORD = "password";
    private static final String BTN_CONNECT = "btn_connect";
    private static final String DATASOURCE = "datasource";
    private static final String BTN_SAVE = "btn_save";
    private static final String MODELSOURCETYPE = "modelsourcetype";
    private static final String USERTAG = "usertag";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String APPTYPE = "apptype";
    private static final String RADIO1 = "radio1";
    private static final String RADIO2 = "radio2";
    private static final String MODELSOURCE = "modelsource";
    private static final String MODELSOURCENUM = "modelsourcenum";
    private static final String MODEL = "model";
    private static final String CONNECTTAG = "connecttag";
    private static final String USERURL = "userurl";
    private static final String USERTYPE = "usertype";
    private static final String IS_SAME_DATA_SOURCE = "is_same_data_source";
    private static final String LOGINTOKEN = "loginToken";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String EMPTY = "empty";
    private static final String ISLOAD = "isLoad";
    private static final String TDPDATACENTERID = "tdpdatacenterid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ItemClassEdit f7 = (ItemClassEdit)this.getControl(MODELSOURCE);
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_CONNECT, CONNECTTAG});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PHONENUMBER, BTN_CONNECT, NAME, NUMBER, MODELSOURCENUM, PASSWORD});
        this.setDataCenterValue("1", "1");
        this.getModel().setValue(MODELSOURCETYPE, (Object)"eb_dataset");
        this.getModel().setValue(USERTAG, (Object)RequestContext.get().getTenantId());
        String modelId = this.getView().getParentView().getPageCache().get("modelId");
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getModel().setValue(USERURL, (Object)RequestContext.get().getClientFullContextPath());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{USERURL});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && "1".equals(this.getModel().getValue(USERTYPE))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{USERURL});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String usertype = (String)this.getModel().getValue(USERTYPE);
        String appType = (String)this.getModel().getValue(APPTYPE);
        this.setDataCenterValue("2", usertype);
        this.getPageCache().put(ISLOAD, "true");
        String datasource = (String)this.getModel().getValue(DATASOURCE);
        String accountId = RequestContext.get().getAccountId();
        if ("1".equals(usertype) && accountId.equals(datasource)) {
            this.getPageCache().put(IS_SAME_DATA_SOURCE, "true");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MODELSOURCE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{NUMBER, NAME, PHONENUMBER, BTN_CONNECT, MODELSOURCENUM, PASSWORD});
        } else {
            QFilter qfId;
            QFilter qfModel;
            DynamicObject[] exists;
            Object tdpid = this.getModel().getValue("TDPDATACENTERID");
            if (tdpid instanceof DynamicObject) {
                Long id = ((DynamicObject)tdpid).getLong("id");
                this.getModel().setValue(DATASOURCE, (Object)id);
            }
            KAESEncrypter ken = new KAESEncrypter();
            String passWord = (String)this.getModel().getValue(PASSWORD);
            if (passWord == null || StringUtils.isEmpty((String)passWord.trim())) {
                this.getModel().setValue(PASSWORD, null);
            } else {
                passWord = ken.decode(passWord);
                this.getModel().setValue(PASSWORD, (Object)passWord);
            }
            this.getModel().setDataChanged(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MODELSOURCE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{NUMBER, NAME, PHONENUMBER, BTN_CONNECT, PASSWORD});
            String apptype = (String)this.getModel().getValue(APPTYPE);
            this.getView().setVisible(Boolean.valueOf(apptype.equals(String.valueOf(NgModelTypeEnum.NGBGMODEL.getCode()))), new String[]{MODELSOURCENUM});
            if (this.getModel().getValue(MODEL) != null && (exists = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)NAME, (QFilter[])new QFilter[]{qfModel = new QFilter(MODEL, "=", (Object)((DynamicObject)this.getModel().getValue(MODEL)).getLong("id")), qfId = new QFilter("issrcmodel", "=", (Object)((Long)this.getModel().getValue("id")))})).length > 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, NAME, PHONENUMBER, CONNECTTAG, MODELSOURCENUM, APPTYPE, DATASOURCE, RADIO1, RADIO2, USERURL});
            }
            this.reSetPageText(appType);
        }
    }

    private void reSetPageText(String type) {
        TextEdit number = (TextEdit)this.getControl(NUMBER);
        TextEdit name = (TextEdit)this.getControl(NAME);
        if (NgModelTypeEnum.NGCMMODEL.getCode().toString().equals(type) || NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(type)) {
            number.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u7f16\u7801", (String)"ISNgModelEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            name.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u540d\u79f0", (String)"ISNgModelEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MODELSOURCENUM});
        } else if (NgModelTypeEnum.NGBGMODEL.getCode().toString().equals(type)) {
            number.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u96c6\u7f16\u7801", (String)"ISNgModelEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            name.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u96c6\u540d\u79f0", (String)"ISNgModelEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MODELSOURCENUM});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String alias;
        super.propertyChanged(e);
        switch (alias = e.getProperty().getAlias()) {
            case "fusertype": {
                this.setUserType(e);
                break;
            }
            case "fdatasource": {
                this.checkDataSource(e);
                break;
            }
            case "fapptype": {
                this.setModel(e);
                break;
            }
            case "fmodelsource": {
                this.setConnectTag(e);
                this.setNameNumber(e);
                break;
            }
            case "fnumber": {
                this.setConnectTagDifDataSource();
                break;
            }
            case "fuserurl": {
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.setDataCenterValue("1", "3");
                    break;
                }
                this.setDataCenterValue("1", "2");
                break;
            }
        }
    }

    private void setConnectTagDifDataSource() {
        String modelNumber = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isEmpty((String)modelNumber)) {
            return;
        }
        String appType = (String)this.getModel().getValue(APPTYPE);
        if ("3".equals(appType)) {
            this.getModel().setValue(CONNECTTAG, (Object)(this.getModel().getValue(MODELSOURCENUM) + "_" + modelNumber));
        } else {
            this.getModel().setValue(CONNECTTAG, (Object)modelNumber);
        }
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && BTN_CONNECT.equals(key = (button = (Button)source).getKey())) {
            this.checkConnect();
        }
    }

    private void checkConnect() {
        String userUrl = (String)this.getModel().getValue(USERURL);
        if (StringUtils.isEmpty((String)userUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79df\u6237\u73af\u5883\u5730\u5740\u4e3a\u5fc5\u586b\u3002", (String)"ISNgModelEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String phoneNumber = (String)this.getModel().getValue(PHONENUMBER);
        if (StringUtils.isEmpty((String)phoneNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fdc\u7a0b\u624b\u673a\u53f7\u201d\u3002", (String)"ISNgModelEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String passWord = (String)this.getModel().getValue(PASSWORD);
        if (StringUtils.isEmpty((String)passWord)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bc6\u7801\u201d\u3002", (String)"ISNgModelEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getModel().getValue(TDPDATACENTERID) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u3002", (String)"ISNgModelEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject tdpdatacenter = (DynamicObject)this.getModel().getValue(TDPDATACENTERID);
        tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenter.getLong("id"))});
        String loginToken = DimMappingHelper.getLoginTokenWithPass((String)phoneNumber, (String)passWord, (DynamicObject)tdpdatacenter);
        this.getPageCache().put(LOGINTOKEN, loginToken);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f\u3002", (String)"DataSourceEdit_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void setNameNumber(PropertyChangedArgs e) {
        DynamicObject model = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (model == null) {
            return;
        }
        String name = model.getString(NAME);
        String modelType = model.getDataEntityType().getName();
        String shownumber = "";
        if ("bcm_model".equals(modelType)) {
            shownumber = model.getString("shownumber");
        } else if ("eb_dataset".equals(modelType)) {
            shownumber = model.getString(NUMBER);
        }
        this.getModel().setValue(NAME, (Object)name);
        this.getModel().setValue(NUMBER, (Object)shownumber);
    }

    private void setConnectTag(PropertyChangedArgs e) {
        DynamicObject model = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (model == null) {
            return;
        }
        String modelType = model.getDataEntityType().getName();
        String showNumber = "";
        if ("bcm_model".equals(modelType)) {
            showNumber = model.getString("shownumber");
        } else if ("eb_dataset".equals(modelType)) {
            DynamicObject modelEb = BusinessDataServiceHelper.loadSingle((Object)model.getLong("id"), (String)"eb_dataset");
            String modelEbShowNumber = modelEb.getString("model.shownumber");
            this.getModel().setValue(MODELSOURCENUM, (Object)modelEbShowNumber);
            showNumber = model.getString(NUMBER);
            showNumber = modelEbShowNumber + "_" + showNumber;
        }
        this.getModel().setValue(CONNECTTAG, (Object)showNumber);
    }

    private void setModel(PropertyChangedArgs e) {
        String type = String.valueOf(e.getChangeSet()[0].getNewValue());
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        Object datasource = this.getModel().getValue(DATASOURCE);
        if (datasource == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u3002", (String)"ISNgModelEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(APPTYPE, (Object)"");
            return;
        }
        this.getModel().setValue(MODELSOURCE, null);
        this.getModel().setValue(CONNECTTAG, null);
        this.getModel().setValue(NAME, null);
        this.getModel().setValue(NUMBER, null);
        this.getView().updateView();
        boolean isSameDataSource = this.checkIsSameDataSource();
        if (!isSameDataSource) {
            this.reSetPageText(type);
            return;
        }
        if (NgModelTypeEnum.NGCMMODEL.getCode().toString().equals(type) || NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(type)) {
            this.getModel().setValue(MODELSOURCETYPE, (Object)"bcm_model");
            ItemClassEdit itemclass = (ItemClassEdit)this.getControl(MODELSOURCE);
            QFilter qf = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.index);
            if (NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(type)) {
                qf = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.RPT.index);
            }
            itemclass.setQFilter(qf);
        } else if (NgModelTypeEnum.NGBGMODEL.getCode().toString().equals(type)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SAVE});
            this.getModel().setValue(MODELSOURCETYPE, (Object)"eb_dataset");
            ItemClassEdit itemclass = (ItemClassEdit)this.getControl(MODELSOURCE);
            itemclass.setQFilter(new QFilter("id", "!=", (Object)-1L));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String appType = (String)this.getModel().getValue(APPTYPE);
        if (StringUtils.isEmpty((String)appType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5e94\u7528\u201d\u3002", (String)"ISNgModelEditPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        if (NgModelTypeEnum.NGBGMODEL.getCode().toString().equals(appType)) {
            arg0.getFormShowParameter().setAppId(ApplicationTypeEnum.BGMD.getAppnum());
        } else if (NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(appType)) {
            arg0.getFormShowParameter().setAppId(ApplicationTypeEnum.RPT.getAppnum());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            boolean isHaveModelSource;
            DynamicObject modelsource = (DynamicObject)this.getModel().getValue(MODELSOURCE);
            String accountId = (String)this.getModel().getValue(DATASOURCE);
            String connecttag = (String)this.getModel().getValue(CONNECTTAG);
            String reportType = (String)this.getModel().getValue(APPTYPE);
            boolean mustInputFinish = this.checkMustInput();
            if (mustInputFinish) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u3001\u201c\u5e94\u7528\u201d\u3001\u201c\u6e90\u4f53\u7cfb\u201d\u3001\u201c\u8fde\u63a5\u6807\u8bb0\u201d\u3002", (String)"ISNgModelEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            boolean isSameDataSource = this.checkIsSameDataSource();
            String phoneNumber = (String)this.getModel().getValue(PHONENUMBER);
            String passWord = (String)this.getModel().getValue(PASSWORD);
            if (!isSameDataSource) {
                if (StringUtils.isEmpty((String)phoneNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fdc\u7a0b\u624b\u673a\u53f7\u201d\u3002", (String)"ISNgModelEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (StringUtils.isEmpty((String)passWord)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bc6\u7801\u201d\u3002", (String)"ISNgModelEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
            }
            if (!(isHaveModelSource = this.checkIsHaveModelSource(isSameDataSource, modelsource)) || accountId == null || StringUtils.isEmpty((String)connecttag) || StringUtils.isEmpty((String)reportType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u3001\u201c\u5e94\u7528\u201d\u3001\u201c\u6e90\u4f53\u7cfb\u201d\u3001\u201c\u8fde\u63a5\u6807\u8bb0\u201d\u3002", (String)"ISNgModelEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String modelName = (String)this.getModel().getValue(NAME);
            if (StringUtils.isEmpty((String)modelName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6e90\u4f53\u7cfb\u540d\u79f0\u201d\u3002", (String)"ISNgModelEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            QFilter qfConnect = new QFilter(CONNECTTAG, "=", (Object)connecttag);
            Long curId = (Long)this.getModel().getValue("id");
            curId = curId == null ? Long.valueOf(0L) : curId;
            QFilter qfId = new QFilter("id", "!=", (Object)curId);
            boolean exists = QueryServiceHelper.exists((String)"bcm_isngmodel", (QFilter[])new QFilter[]{qfConnect, qfId});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6807\u8bb0\u5df2\u5b58\u5728\u3002", (String)"ISNgModelEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (isSameDataSource) {
                String name = modelsource.getString(NAME);
                this.getModel().setValue("modelsourcename", (Object)name);
            } else {
                this.getModel().setValue("modelsourcename", this.getModel().getValue(NAME));
            }
            if (!isSameDataSource) {
                String exist = this.checkModelExist();
                if (EMPTY.equals(exist)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u586b\u5199\u7684\u4f53\u7cfb\u5728\u5bf9\u5e94\u73af\u5883\u548c\u6570\u636e\u4e2d\u5fc3\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ISNgModelEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (!SUCCESS.equals(exist)) {
                    e.setCancel(true);
                    return;
                }
                KAESEncrypter ken = new KAESEncrypter();
                passWord = ken.encode(passWord);
                this.getModel().setValue(PASSWORD, (Object)passWord);
            }
            this.getModel().setValue("datasourcename", (Object)this.getPageCache().get(accountId));
        }
    }

    private String checkModelExist() {
        String phoneNumber = (String)this.getModel().getValue(PHONENUMBER);
        String passWord = (String)this.getModel().getValue(PASSWORD);
        String name = (String)this.getModel().getValue(NAME);
        String number = (String)this.getModel().getValue(NUMBER);
        String reportType = (String)this.getModel().getValue(APPTYPE);
        String loginToken = null;
        String userUrl = null;
        try {
            DynamicObject tdpdatacenter = (DynamicObject)this.getModel().getValue(TDPDATACENTERID);
            tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenter.getLong("id"))});
            userUrl = tdpdatacenter.getString("address");
            loginToken = DimMappingHelper.getLoginTokenWithPass((String)phoneNumber, (String)passWord, (DynamicObject)tdpdatacenter);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return FAIL;
        }
        HashMap<String, String> requestHeader = new HashMap<String, String>(4);
        requestHeader.put("accessToken", loginToken);
        HashMap<String, String> params = new HashMap<String, String>();
        String InterfaceUrl = null;
        if ("3".equals(reportType)) {
            String modelNumber = (String)this.getModel().getValue(MODELSOURCENUM);
            params.put("modelNumber", modelNumber);
            params.put("dataSetName", name);
            params.put("dataSetNumber", number);
            InterfaceUrl = "/kapi/app/bgm/modelQuery";
        } else {
            params.put(NAME, name);
            params.put(NUMBER, number);
            params.put("reportType", reportType);
            InterfaceUrl = "/kapi/app/cm/modelInfo";
        }
        try {
            String fullUrl = userUrl + InterfaceUrl;
            String paramStr = JSON.toJSONString(params);
            LOG.info("get modelInfo begin:" + fullUrl + ":" + paramStr);
            String response = HttpClientUtils.get((String)fullUrl, requestHeader, params);
            ApiResult res = (ApiResult)JSON.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                this.getView().showTipNotification(res.getMessage());
                return FAIL;
            }
            if ("3".equals(reportType)) {
                if (this.isNullSetNumber(res)) {
                    this.getView().showTipNotification(res.getMessage());
                    return FAIL;
                }
                return SUCCESS;
            }
            List data = (List)res.getData();
            return data != null && !data.isEmpty() ? SUCCESS : EMPTY;
        }
        catch (Exception e) {
            LOG.error("get modelInfo error", (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[]{"get modelInfo error"});
        }
    }

    private boolean isNullSetNumber(ApiResult res) {
        return res.getData() == null || ((JSONArray)res.getData()).size() == 0 || ((JSONObject)((JSONArray)res.getData()).get(0)).get((Object)"dataSetNumber") == null;
    }

    private boolean checkIsHaveModelSource(boolean isSameDataSource, DynamicObject modelsource) {
        if (isSameDataSource) {
            return modelsource != null;
        }
        return true;
    }

    private boolean checkMustInput() {
        return StringUtils.isEmpty((String)this.getPageCache().get(ISLOAD)) && StringUtils.isEmpty((String)this.getPageCache().get(IS_SAME_DATA_SOURCE));
    }

    private boolean checkIsSameDataSource() {
        return "true".equals(this.getPageCache().get(IS_SAME_DATA_SOURCE));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            String connecttag = (String)this.getModel().getValue(CONNECTTAG);
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISBasedataPlugin_0", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f", "ISNgModelEditPlugin_25", "fi-bcm-formplugin", new String[]{connecttag}));
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjustTemplateSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private long getModelId() {
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(MODEL);
        if (null != modelDy) {
            return modelDy.getLong("id");
        }
        return 0L;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            this.getModel().setValue(USERURL, (Object)RequestContext.get().getClientFullContextPath());
        }
    }

    private void checkDataSource(PropertyChangedArgs e) {
        this.getModel().setValue(APPTYPE, null);
        this.getModel().setValue(MODELSOURCE, null);
        this.getModel().setValue(CONNECTTAG, null);
        this.getModel().setValue(NAME, null);
        this.getModel().setValue(NUMBER, null);
        this.getView().updateView();
        String id = String.valueOf(e.getChangeSet()[0].getNewValue());
        String accountId = RequestContext.get().getAccountId();
        String userType = (String)this.getModel().getValue(USERTYPE);
        if (!accountId.equals(id) || !"1".equals(userType)) {
            this.getPageCache().put(IS_SAME_DATA_SOURCE, "false");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PHONENUMBER, BTN_CONNECT, NAME, NUMBER, PASSWORD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MODELSOURCE});
            if (id != null && !"null".equals(id)) {
                this.getModel().setValue(TDPDATACENTERID, (Object)id);
                if (!"1".equals(userType)) {
                    this.setUserUrl(LongUtil.toLong((Object)id));
                }
            }
        } else {
            this.getPageCache().put(IS_SAME_DATA_SOURCE, "true");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PHONENUMBER, BTN_CONNECT, NAME, NUMBER, PASSWORD, MODELSOURCENUM});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MODELSOURCE});
            this.getModel().setValue(TDPDATACENTERID, null);
        }
    }

    private void setUserType(PropertyChangedArgs e) {
        String type = String.valueOf(e.getChangeSet()[0].getNewValue());
        if ("2".equals(type)) {
            this.getModel().setValue(USERTAG, null);
            this.getModel().setValue(USERURL, null);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PHONENUMBER, BTN_CONNECT, NAME, NUMBER, PASSWORD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MODELSOURCE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{USERURL});
        } else {
            this.getModel().setValue(USERTAG, (Object)RequestContext.get().getTenantId());
            this.getModel().setValue(USERURL, (Object)RequestContext.get().getClientFullContextPath());
            this.setDataCenterValue("1", "1");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PHONENUMBER, BTN_CONNECT, NAME, NUMBER, PASSWORD, MODELSOURCENUM});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MODELSOURCE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SAVE});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{USERURL});
        }
        this.getModel().setValue(MODELSOURCENUM, null);
        this.getModel().setValue(PHONENUMBER, null);
        this.getModel().setValue(PASSWORD, null);
    }

    private void setDataCenterValue(String showType, String userType) {
        if ("1".equals(showType)) {
            this.getModel().setValue(DATASOURCE, null);
            this.getModel().setValue(TDPDATACENTERID, null);
        }
        try {
            String tenantId = RequestContext.get().getTenantId();
            ArrayList<Account> allAccounts = new ArrayList<Account>();
            if ("1".equals(userType)) {
                String accountId = RequestContext.get().getAccountId();
                Account correctAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
                allAccounts.add(correctAccount);
                String userUrl = RequestContext.get().getClientFullContextPath();
                String url = BCMStringUtil.deleteEndsStr((String)userUrl) + "%";
                allAccounts.addAll(this.getAccountFromBCMDataCenter(url));
            } else if ("2".equals(userType) || "3".equals(userType)) {
                String userUrl = (String)this.getModel().getValue(USERURL);
                String url = BCMStringUtil.deleteEndsStr((String)userUrl) + "%";
                allAccounts.addAll(this.getAccountFromBCMDataCenter(url));
            }
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            for (Account account : allAccounts) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(account.getAccountName()));
                comboItem.setValue(account.getAccountId());
                comboItems.add(comboItem);
                this.getPageCache().put(account.getAccountId(), account.getAccountName());
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(DATASOURCE);
            comboEdit.setComboItems(comboItems);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"ISNgModelEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            LOG.error("ISNgModelEditPlugin get data source error", (Throwable)e);
        }
    }

    private List<Account> getAccountFromBCMDataCenter(String url) {
        ArrayList<Account> accountList = new ArrayList<Account>(8);
        try {
            QFilter filter = new QFilter("address", "like", (Object)url);
            DynamicObjectCollection tdp = QueryServiceHelper.query((String)"bcm_tdp_datacenter", (String)"id,name,number,datasource", (QFilter[])filter.toArray());
            for (int i = 0; i < tdp.size(); ++i) {
                Account account = new Account();
                account.setAccountId(((DynamicObject)tdp.get(i)).getString("id"));
                account.setAccountName(((DynamicObject)tdp.get(i)).getString(NAME));
                account.setAccountNumber(((DynamicObject)tdp.get(i)).getString(NUMBER));
                accountList.add(account);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"BcmModelCopyAndTransferPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            LOG.error("ISNgModelEditPlugin get data source error", (Throwable)e);
            return accountList;
        }
        return accountList;
    }

    private List<Account> getAllAccountsByOtherUrl() {
        List<Pair<String, String>> pairs;
        String userurl = (String)this.getModel().getValue(USERURL);
        ArrayList<Account> accounts = new ArrayList<Account>(10);
        try {
            pairs = ModelTransferHelper.listSiteAccounts(userurl);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"BcmModelCopyAndTransferPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            LOG.error("ISNgModelEditPlugin get data source error", (Throwable)e);
            return accounts;
        }
        Account account = null;
        for (Pair<String, String> pair : pairs) {
            account = new Account();
            account.setAccountName(new LocaleString((String)pair.p2).toString());
            account.setAccountId((String)pair.p1);
            accounts.add(account);
        }
        return accounts;
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_isngmodel";
    }

    @Override
    public String getBizAppId() {
        return "";
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        long modelId = this.getModelId();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    private void setUserUrl(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject tdp = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"id,name,number,address", (QFilter[])filter.toArray());
        if (tdp != null && tdp.getString("address") != null) {
            String url = tdp.getString("address");
            this.getModel().beginInit();
            this.getModel().setValue(USERURL, (Object)url);
            this.getModel().endInit();
            this.getView().updateView();
        }
    }
}

