/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.IsRpaSchemeUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.vo.RpaFileModel;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.csv.ReportExportCsvFileTaskService;

public class ISRpaExecuteParamPlugin
extends AbstractBaseFormPlugin {
    protected static final String MODEL = "model";
    protected static final String NUMBER = "number";
    private static final String DOWNLOADED = "downloaded";
    private static final String RPA_SCHEME = "rpaScheme";
    private static final String IS_SCHEME = "ISScheme";
    private static final String RPA_SCHEME_F7 = "rpaschemef7";
    private static final String RPA_SCHEME_ID = "rpaschemeid";
    private static final String fyear = "year";
    private static final String period = "period";
    private static final String entity = "entity";
    private static final String scenario = "scenario";
    private static final String currency = "currency";
    private static final String report = "report";
    private static final String reportdata = "reportdata";
    private static final String ignoresuccessorg = "ignoresuccessorg";
    private static final String entityMulit = "entity";
    private static final String notifyuser = "notifyuser";
    private static final String BTN_OK = "btnok";
    private static final String REPORTPAGE = "reportPage";
    private static final String SELECTENTITY = "selectEntity";
    private static final String SEND_RPA_ENTITY = "SendRpaEntity";
    private static final List<String> f7keys = Lists.newArrayList((Object[])new String[]{"year", "scenario", "period"});
    private List<FYPeriodPair> fyPeriodPairs = new ArrayList<FYPeriodPair>(1);
    private Map<String, DynamicObject> auditMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> processMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> cyNumber2Dy = new HashMap<String, DynamicObject>(16);
    private final List<Long> unExportOrg = new ArrayList<Long>(10);
    private DynamicObject process;
    private DynamicObject audittrial;
    private DynamicObjectCollection tempDoc;
    private DynamicObjectCollection orgDoc;

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(6);
        this.asMapF7toType(f7keys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK, "entity");
        BasedataEdit rpaschemef7 = (BasedataEdit)this.getControl(RPA_SCHEME_F7);
        rpaschemef7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yearf7 = (BasedataEdit)this.getControl(fyear);
        yearf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodf7 = (BasedataEdit)this.getControl(period);
        periodf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
            if (rpaSchemeId != null) {
                this.checkParm();
                if (this.checkReport()) {
                    this.initRpa(rpaSchemeId);
                }
            } else {
                this.startRpa();
            }
        } else if ("entity".equals(key)) {
            String selectEntity = this.getPageCache().get(SELECTENTITY);
            if (selectEntity == null && this.isFormReportList()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"ISRpaExecuteParamPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMulTiF7("entity", "Entity");
        }
    }

    private void initRpa(Long rpaSchemeId) {
        QFilter filter = new QFilter("id", "=", (Object)rpaSchemeId);
        DynamicObject rpaScheme = QueryServiceHelper.queryOne((String)"bcm_isrpascheme", (String)"filetype", (QFilter[])filter.toArray());
        NewReportMultiExportService service = rpaScheme.getString("filetype") != null && "4".equals(rpaScheme.getString("filetype")) ? new ReportExportCsvFileTaskService() : new NewReportMultiExportService();
        this.initFyPeriodPairs();
        this.initAuditMember(this.auditMap);
        this.initProcessMember(this.processMap);
        this.initOrgDoc();
        this.initTempDoc();
        this.initCurrencyDy();
        this.initUnExportOrgs();
        this.buildService(service);
        this.getPageCache().remove(DOWNLOADED);
        this.dispatch(service);
    }

    private void startRpa() {
        String idStr = this.getPageCache().get(RPA_SCHEME_ID);
        if (idStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"ISRpaExecuteParamPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long id = Long.valueOf(idStr);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isrpascheme");
        Pair<Set<String>, Set<Long>> orgs = this.getOrg(scheme.getDynamicObject("scheme").getLong("id"));
        if (((Set)orgs.p1).size() == ((Set)orgs.p2).size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5168\u90e8\u672a\u5206\u914d\u96c6\u6210\u65b9\u6848\u6216\u8005\u672a\u5728\u96c6\u6210\u65b9\u6848\u7ef4\u5ea6\u7ec4\u5408\u6620\u5c04\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaExecuteParamPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (((Set)orgs.p2).size() > 0) {
            this.startRpaConfirm((Set)orgs.p2);
            this.getPageCache().put(SEND_RPA_ENTITY, JSONObject.toJSONString((Object)orgs.p1));
            return;
        }
        this.startProcess(id, JSONObject.toJSONString((Object)orgs.p1));
        this.getView().close();
    }

    private void startRpaConfirm(Set<Long> ids) {
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        StringBuilder msgDetail = new StringBuilder();
        for (DynamicObject dynamicObject : load) {
            msgDetail.append(dynamicObject.getString(NUMBER)).append(":").append(dynamicObject.getString("name")).append("\n");
        }
        String msg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u672a\u5206\u914d\u96c6\u6210\u65b9\u6848\u6216\u8005\u672a\u5728\u96c6\u6210\u65b9\u6848\u7ef4\u5ea6\u7ec4\u5408\u6620\u5c04\u4e2d\u7ef4\u62a4\uff0c\u662f\u5426\u786e\u5b9a\u6267\u884c?", (String)"ISRpaExecuteParamPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, msgDetail.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("StartRpaConfirm", (IFormPlugin)this));
    }

    private void startProcess(Long id, String orgs) {
        DynamicObject year = (DynamicObject)this.getModel().getValue(fyear);
        Long modelId = this.getModelId();
        DynamicObject bcmModel = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
        DynamicObject periodF7 = (DynamicObject)this.getModel().getValue(period);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isrpascheme");
        String proccode = scheme.getString("proccode");
        String runrobot = scheme.getString("runrobot");
        if (StringUtils.isEmpty((String)runrobot)) {
            runrobot = "deptall";
        }
        String name = scheme.getString("name");
        runrobot = runrobot.split(",")[0];
        List isRpaParams = null;
        try {
            log.info("RpaService.getProcessParms: " + proccode);
            isRpaParams = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessParms", (Object[])new Object[]{proccode, null});
        }
        catch (Exception e) {
            log.error("RPA getProcessParms error", (Throwable)e);
        }
        if (isRpaParams != null) {
            for (Map map : isRpaParams) {
                if (fyear.equals(map.get("Name"))) {
                    map.put("Value", year.getString(NUMBER));
                    continue;
                }
                if (period.equals(map.get("Name"))) {
                    map.put("Value", periodF7.getString(NUMBER));
                    continue;
                }
                if ("modelnumber".equals(map.get("Name"))) {
                    map.put("Value", bcmModel.getString("showNumber"));
                    continue;
                }
                if ("orgs".equals(map.get("Name"))) {
                    map.put("Value", orgs);
                    continue;
                }
                if ("pattern".equals(map.get("Name"))) {
                    map.put("Value", "2");
                    continue;
                }
                if ("rpaname".equals(map.get("Name"))) {
                    map.put("Value", name);
                    continue;
                }
                if (ignoresuccessorg.equals(map.get("Name"))) {
                    map.put("Value", String.valueOf(this.getModel().getValue(ignoresuccessorg)));
                    continue;
                }
                if (!notifyuser.equals(map.get("Name"))) continue;
                if (this.isFormReportList() || this.getModel().getValue(notifyuser) == null) {
                    map.put("Value", RequestContext.get().getUserId());
                    continue;
                }
                map.put("Value", String.valueOf(this.getModel().getValue(notifyuser)));
            }
            try {
                log.info("RpaService.addTask: " + proccode + " | " + runrobot + " | " + ObjectSerialUtil.toJson((Object)isRpaParams));
                DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"addTask", (Object[])new Object[]{proccode, runrobot, null, isRpaParams});
            }
            catch (Exception e) {
                log.error("RPA auto add Task error", (Throwable)e);
            }
        }
        this.getView().returnDataToParent((Object)"Start_RPA_OK");
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (Objects.equals(callBackId, "StartRpaConfirm") && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.startProcess(Long.valueOf(this.getPageCache().get(RPA_SCHEME_ID)), this.getPageCache().get(SEND_RPA_ENTITY));
            this.getView().close();
        }
        if ("templateversion_confirm".equals(callBackId) && MessageBoxResult.Yes == mbce.getResult()) {
            Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
            this.initRpa(rpaSchemeId);
        }
    }

    private Pair<Set<String>, Set<Long>> getOrg(Long rpaSchmeId) {
        List list = (List)JSON.parseObject((String)this.getPageCache().get("entity"), List.class);
        HashMap orgMap = new HashMap();
        for (Map map : list) {
            MembRangeItem mri = new MembRangeItem("bcm_entitymembertree", Long.valueOf(Long.parseLong((String)map.get("id"))), (String)map.get(NUMBER), RangeEnum.getRangeByVal((int)Integer.parseInt((String)map.get("scope"))), false, (Object)this.getModelId());
            mri.matchItems(c -> orgMap.put(c.getNumber(), c.getId()));
        }
        Set<Long> orgIds = this.getHavePemOrgs();
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        HashSet<String> orgPemissionNumberSet = new HashSet<String>();
        HashSet<Long> orgPemissionIdSet = new HashSet<Long>();
        for (DynamicObject org : load) {
            String orgNumber = org.getString(NUMBER);
            if (!orgMap.containsKey(orgNumber)) continue;
            orgPemissionNumberSet.add(orgNumber);
            orgPemissionIdSet.add((Long)orgMap.get(orgNumber));
        }
        Set<Long> orgNoPemissionSet = this.getOrgNopemissionSet(orgPemissionIdSet, rpaSchmeId);
        return Pair.onePair(orgPemissionNumberSet, orgNoPemissionSet);
    }

    private Set<Long> getOrgNopemissionSet(Set<Long> orgPemissionSet, Long rpaSchmeId) {
        HashSet<Long> mappingOrgs = new HashSet<Long>(10);
        HashSet<Long> assignIds = new HashSet<Long>(10);
        QueryServiceHelper.query((String)"bcm_issinglemap", (String)"targmembid", (QFilter[])new QFilter[]{new QFilter("schemeid", "=", (Object)rpaSchmeId)}).forEach(dyn -> mappingOrgs.add(dyn.getLong("targmembid")));
        DynamicObjectCollection assignOrgs = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)"entity.id,entity.number,range", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("scheme", "=", (Object)rpaSchmeId)});
        for (DynamicObject dyn2 : assignOrgs) {
            new MembRangeItem("bcm_entitymembertree", Long.valueOf(dyn2.getLong("entity.id")), dyn2.getString("entity.number"), dyn2.getInt("range"), false, (Object)this.getModelId()).matchItems(item -> assignIds.add(LongUtil.toLong((Object)item.id)));
        }
        Set<Long> orgPemissionSetNew = this.getBaseIdSet(orgPemissionSet);
        Set<Long> mappingOrgsNew = this.getBaseIdSet(mappingOrgs);
        Set<Long> assignIdsNew = this.getBaseIdSet(assignIds);
        orgPemissionSetNew.removeIf(id -> mappingOrgsNew.contains(id) && assignIdsNew.contains(id));
        return orgPemissionSetNew;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String idStr;
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (RPA_SCHEME_F7.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            Long pageSceneod = (Long)this.getFormCustomParam("pageSceneod");
            qFilterList.add(new QFilter(scenario, "=", (Object)pageSceneod));
            qFilterList.add(new QFilter("status", "=", (Object)"1"));
            qFilterList.add(new QFilter("scheme.id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId())));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if ((fyear.equals(key) || period.equals(key)) && (idStr = this.getPageCache().get(RPA_SCHEME_ID)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"ISRpaExecuteParamPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Long rpaSchemeId;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (RPA_SCHEME_F7.equals(propertyName) && (rpaSchemeId = Long.valueOf(((DynamicObject)e.getChangeSet()[0].getNewValue()).getLong("id"))) != null) {
            this.initPage(rpaSchemeId);
            this.getPageCache().put(RPA_SCHEME_ID, rpaSchemeId.toString());
        }
    }

    private void showMulTiF7(String key, String number) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getModelId(), (String)number);
        if (dim == null) {
            return;
        }
        if (this.getModel().getValue(key) == null || StringUtils.isEmpty((String)this.getModel().getValue(key).toString())) {
            this.setValue(key, null);
            this.getPageCache().remove(key);
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        params.put("resourceKey", key);
        params.put("sign", key);
        params.put("onlyleaf", true);
        params.put("isHiddenLocalradio", Boolean.TRUE.toString());
        if (this.isFormReportList()) {
            List<Long> selectEntityList = this.getSelectEntityList();
            QFilter customFilter = new QFilter("id", "in", selectEntityList);
            params.put("customFilter", customFilter.toSerializedString());
        }
        params.put("pageFrom", "RPA");
        para.setCustomParams(params);
        para.setCaption(dim.getString("name"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "entity");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private List<Long> getSelectEntityList() {
        String selectEntity = this.getPageCache().get(SELECTENTITY);
        List selectEntityList = JSONArray.parseArray((String)selectEntity, String.class);
        ArrayList<Long> selectEntityLongList = new ArrayList<Long>(10);
        for (String id : selectEntityList) {
            selectEntityLongList.add(Long.parseLong(id));
        }
        return selectEntityLongList;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
        if (rpaSchemeId != null) {
            this.initPage(rpaSchemeId);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RPA_SCHEME_F7});
            TextEdit entityText = (TextEdit)this.getControl("entity");
            entityText.hideTips();
        } else {
            Long pageYear = (Long)this.getView().getFormShowParameter().getCustomParam("pageYear");
            Long pagePeriod = (Long)this.getView().getFormShowParameter().getCustomParam("pagePeriod");
            Long pageSceneod = (Long)this.getView().getFormShowParameter().getCustomParam("pageSceneod");
            this.getModel().setValue(fyear, (Object)(0L == pageYear ? null : pageYear));
            this.getModel().setValue(period, (Object)(0L == pagePeriod ? null : pagePeriod));
            this.getModel().setValue(scenario, (Object)(0L == pageSceneod ? null : pageSceneod));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{scenario, currency, reportdata, report});
        if (this.isFormReportList()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{notifyuser});
        }
    }

    private boolean isFormReportList() {
        return REPORTPAGE.equals(this.getFormCustomParam("actionType")) || "bcm_report_list".equals(this.getView().getParentView().getEntityId());
    }

    private void initPage(Long rpaSchemeId) {
        this.getPageCache().put(RPA_SCHEME_ID, rpaSchemeId.toString());
        String actionType = (String)this.getFormCustomParam("actionType");
        if ("man".equals(actionType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ignoresuccessorg});
        }
        DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingle((Object)rpaSchemeId, (String)"bcm_isrpascheme");
        DynamicObjectCollection multitemplate = rpaScheme.getDynamicObjectCollection("reportentry");
        DynamicObjectCollection template = rpaScheme.getDynamicObjectCollection("multitemplate");
        DynamicObjectType type = template.getDynamicObjectType();
        for (DynamicObject dy : multitemplate) {
            DynamicObject dynamicObject = new DynamicObject(type);
            dynamicObject.set("fbasedataid", dy.get("basedatafield"));
            template.add((Object)dynamicObject);
        }
        this.setValue(report, template);
        this.setValue(scenario, rpaScheme.get(scenario));
        this.setValue(currency, rpaScheme.get(currency));
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection entitys = rpaScheme.getDynamicObjectCollection("entryentity");
        Set<Long> selectEntityNumber = this.getSelectEntityNumber(entitys);
        this.getPageCache().put(SELECTENTITY, JSONObject.toJSONString(selectEntityNumber));
        this.getPageCache().put(IS_SCHEME, rpaScheme.getString("scheme.id"));
    }

    private Set<Long> getHavePemOrgs() {
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter readOrWritePermFilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Entity"), "bcm_entitymembertree", "id");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, readOrWritePermFilter}).stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getSelectEntityNumber(DynamicObjectCollection entitys) {
        HashSet<Long> selectEntityId = new HashSet<Long>();
        Set<Long> orgIds = this.getHavePemOrgs();
        ArrayList list = new ArrayList(10);
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dyn : entitys) {
            String id = dyn.getString("entity.id");
            String scope = dyn.getString("entityscope");
            String number = dyn.getString("entity.number");
            String name = dyn.getString("entity.name");
            MembRangeItem mri = new MembRangeItem("bcm_entitymembertree", Long.valueOf(Long.parseLong(id)), number, RangeEnum.getRangeByVal((int)Integer.parseInt(scope)), false, (Object)this.getModelId());
            HashSet tempIdSet = new HashSet();
            mri.matchItems(c -> {
                if ("110".equals(scope) || "90".equals(scope) || "20".equals(scope) || "40".equals(scope)) {
                    selectEntityId.add(Long.valueOf(id));
                }
                selectEntityId.add((Long)c.getId());
                tempIdSet.add(c.getId());
            });
            if ("90".equals(scope)) {
                mri = new MembRangeItem("bcm_entitymembertree", Long.valueOf(id), number, RangeEnum.VALUE_110, false, (Object)this.getModelId());
                mri.matchItems(c -> selectEntityId.add((Long)c.getId()));
            }
            boolean iscontainsSelect = false;
            for (Long tempId : tempIdSet) {
                if (!orgIds.contains(tempId)) continue;
                iscontainsSelect = true;
                break;
            }
            if (!iscontainsSelect) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", id);
            map.put("scope", scope);
            map.put(NUMBER, number);
            map.put("name", name);
            list.add(map);
            this.buildPageViewShowName(sb, dyn.getString("entity.name"), dyn.getInt("entityscope"));
        }
        String entityShow = sb.toString();
        this.setValue("entity", StringUtils.isEmpty((String)entityShow) ? "" : entityShow.substring(0, entityShow.length() - 1));
        this.getPageCache().put("entity", SerializationUtils.toJsonString(list));
        return selectEntityId;
    }

    public void initAuditMember(Map<String, DynamicObject> map) {
        String number = "ATTotal";
        DynamicObject dy = map.get(number);
        if (dy == null) {
            QFilter filter1 = new QFilter(MODEL, "=", (Object)this.getModelId());
            QFilter filter2 = new QFilter(NUMBER, "=", (Object)number);
            DynamicObject memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_audittrialmembertree", (QFilter[])new QFilter[]{filter1, filter2});
            map.put(number, memDy);
            this.audittrial = memDy;
        } else {
            this.audittrial = dy;
        }
    }

    public void initProcessMember(Map<String, DynamicObject> map) {
        String number = this.getRealProcess();
        DynamicObject dy = map.get(number);
        if (dy == null) {
            QFilter filter1 = new QFilter(MODEL, "=", (Object)this.getModelId());
            QFilter filter2 = new QFilter(NUMBER, "=", (Object)number);
            DynamicObject memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (QFilter[])new QFilter[]{filter1, filter2});
            map.put(number, memDy);
            this.process = memDy;
        } else {
            this.process = dy;
        }
    }

    private String getRealProcess() {
        if (this.getModel().getValue(currency) == null) {
            return "IRpt";
        }
        String cyNum = ((DynamicObject)this.getModel().getValue(currency)).getString(NUMBER);
        String processNumber = "EC".equals(cyNum) ? "EIRpt" : ("DC".equals(cyNum) ? "ERpt" : "IRpt");
        return processNumber;
    }

    private void initFyPeriodPairs() {
        String selectProperties = "id,number,name,dimension.membermodel";
        DynamicObject year = (DynamicObject)this.getModel().getValue(fyear);
        DynamicObject period = (DynamicObject)this.getModel().getValue(period);
        if (year != null && period != null) {
            QFilter filter1 = new QFilter(MODEL, "=", (Object)this.getModelId());
            QFilter filter2 = new QFilter(NUMBER, "=", (Object)year.getString(NUMBER));
            QFilter filter3 = new QFilter(NUMBER, "=", (Object)period.getString(NUMBER));
            DynamicObject queryFy = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter2});
            DynamicObject queryPeriod = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter3});
            FYPeriodPair pair = new FYPeriodPair(year.getString(NUMBER) + "|" + period.getString(NUMBER), queryFy, queryPeriod);
            this.fyPeriodPairs.add(pair);
        }
    }

    private void initOrgDoc() {
        Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
        DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingle((Object)rpaSchemeId, (String)"bcm_isrpascheme");
        DynamicObject exportBaseData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_batchexportplandetail");
        DynamicObjectCollection orgs = exportBaseData.getDynamicObjectCollection("orgentry");
        if (this.getPageCache().get("entity") == null) {
            DynamicObjectCollection entryentity = rpaScheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn2 : entryentity) {
                DynamicObject newobj = orgs.addNew();
                newobj.set("org_number", (Object)dyn2.getDynamicObject("entity"));
                newobj.set("org_number_id", (Object)dyn2.getLong("entity.id"));
                newobj.set("membrange", (Object)dyn2.getLong("entityscope"));
            }
        } else {
            List list = (List)JSON.parseObject((String)this.getPageCache().get("entity"), List.class);
            List ids = list.stream().map(m -> Long.parseLong((String)m.get("id"))).collect(Collectors.toList());
            DynamicObjectCollection entityDyns = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,isleaf,orgcode,simplename,currency.id,currency.name,currency.number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            Map<Long, DynamicObject> org2IdMap = entityDyns.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
            for (Map map : list) {
                DynamicObject newobj = orgs.addNew();
                newobj.set("org_number", (Object)org2IdMap.get(Long.parseLong((String)map.get("id"))));
                newobj.set("org_number_id", map.get("id"));
                newobj.set("membrange", map.get("scope"));
            }
        }
        this.orgDoc = orgs;
    }

    private void initTempDoc() {
        DynamicObjectCollection selectReport = (DynamicObjectCollection)this.getModel().getValue(report);
        String selectProperties = "id,number,name,templatecatalog.number,templatecatalog.name";
        ArrayList<Long> longs = new ArrayList<Long>(16);
        for (DynamicObject dyn : selectReport) {
            longs.add(dyn.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", longs)});
        DynamicObject orgEntry = BusinessDataServiceHelper.newDynamicObject((String)"bcm_batchexportplandetail");
        DynamicObjectCollection temps = orgEntry.getDynamicObjectCollection("reportentry");
        for (DynamicObject temp : templates) {
            DynamicObject newobj = temps.addNew();
            newobj.set("report_number", (Object)temp);
            newobj.set("report_number_id", (Object)temp.getLong("id"));
        }
        this.tempDoc = temps;
    }

    private void initCurrencyDy() {
        String selectProperties = "id,number,name,dimension,dimension.membermodel";
        QFilter f = new QFilter(MODEL, "=", (Object)this.getModelId());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_currencymembertree", (String)selectProperties, (QFilter[])new QFilter[]{f});
        for (DynamicObject value : map.values()) {
            this.cyNumber2Dy.put(value.getString(NUMBER), value);
        }
    }

    private void initUnExportOrgs() {
        boolean ignoreSuccessOrg = (Boolean)this.getModel().getValue(ignoresuccessorg);
        if (ignoreSuccessOrg) {
            Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
            DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingle((Object)rpaSchemeId, (String)"bcm_isrpascheme");
            String execparam = rpaScheme.getString("execparam");
            if (StringUtils.isEmpty((String)execparam)) {
                return;
            }
            String scenarioName = ((DynamicObject)this.getModel().getValue(scenario)).getString("name");
            String yearName = ((DynamicObject)this.getModel().getValue(fyear)).getString("name");
            String periodName = ((DynamicObject)this.getModel().getValue(period)).getString("name");
            if (execparam.contains(scenarioName) && execparam.contains(yearName) && execparam.contains(periodName)) {
                DynamicObjectCollection lastTask = rpaScheme.getDynamicObjectCollection("rpataskid");
                ArrayList orgIds = new ArrayList(10);
                lastTask.forEach(e -> orgIds.add(e.getLong("orgid.id")));
                QFBuilder builder = new QFBuilder("rpascheme", "=", (Object)rpaSchemeId);
                builder.add("entity", "in", orgIds);
                builder.add("status", "in", Arrays.asList("1", "3"));
                DynamicObjectCollection lastTaskLog = QueryServiceHelper.query((String)"bcm_rpaschemetask", (String)"entity,rpataskid,status", (QFilter[])builder.toArray());
                for (DynamicObject obj : lastTaskLog) {
                    this.unExportOrg.add(obj.getLong("entity"));
                }
            }
        }
    }

    private void buildService(NewReportMultiExportService service) {
        Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
        DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingle((Object)rpaSchemeId, (String)"bcm_isrpascheme");
        IDataModel iDataModel = this.getModel();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model", (String)NUMBER);
        service.setAuditMap(this.auditMap);
        service.setAudittrial(this.audittrial);
        service.setCsl(false);
        service.setCube(dynamicObject.getString(NUMBER));
        service.setCyNumber2Dy(this.cyNumber2Dy);
        service.setCyObj_view((DynamicObject)iDataModel.getValue(currency));
        service.setViewDataunit(1);
        service.setDivisor(BigDecimal.ONE);
        service.setExcelfiletype("0");
        String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        Pair<String, String> codeStr = RpaFileModel.getCodeStr(rpaSchemeId);
        service.setFileruleStr((String)codeStr.p1);
        service.setZipFileName(rpaScheme.getString("name") + "_" + ((DynamicObject)this.getModel().getValue(fyear)).getString("name") + "_" + ((DynamicObject)this.getModel().getValue(period)).getString("name") + "_" + timeStr);
        service.setFloat(false);
        service.setFyPeriodPairs(this.fyPeriodPairs);
        service.setModelId(this.getModelId());
        service.setProcess(this.process);
        service.setProcessMap(this.processMap);
        service.setReport(false);
        service.setRptType("2");
        service.setSaveByDim(false);
        service.setScale(-1);
        service.setScaleStr("");
        service.setScene_view((DynamicObject)iDataModel.getValue(scenario));
        DynamicObject scene = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)iDataModel.getValue(scenario)).getLong("id"), (String)"bcm_scenemembertree");
        service.setScene(scene);
        service.setSheetruleStr((String)codeStr.p2);
        String status = rpaScheme.getString("reportstatus");
        ArrayList reportStatus = Lists.newArrayList((Object[])status.split(","));
        boolean inculdeUnWeave = reportStatus.remove("A");
        service.setUnweave(inculdeUnWeave);
        service.setReportStatus(reportStatus);
        ArrayList mcStatus = Lists.newArrayList((Object[])rpaScheme.getString("entityflowstatus").split(","));
        service.setMcStatus(mcStatus);
        service.setStartYear((DynamicObject)iDataModel.getValue(fyear));
        service.setStartPeriod((DynamicObject)iDataModel.getValue(period));
        service.setEndYear((DynamicObject)iDataModel.getValue(fyear));
        service.setEndPeriod((DynamicObject)iDataModel.getValue(period));
        service.setTempDoc(this.tempDoc);
        service.setOrgDoc(this.orgDoc);
        service.setUnExportOrgs(this.unExportOrg);
        service.setPageSourceEnum(ExportPageSourceEnum.RPA);
        service.setSchemeId(0L);
        service.setExcelfiletype("0");
        service.setIsSchemeId(rpaScheme.getLong("scheme.id"));
        service.setJQExport(true);
        service.setFiletype(StringUtils.isEmpty((String)rpaScheme.getString("filetype")) ? "0" : rpaScheme.getString("filetype"));
        String filetype = StringUtils.isEmpty((String)rpaScheme.getString("filetype")) ? "0" : rpaScheme.getString("filetype");
        service.setFiletype(filetype);
        if ("4".equals(filetype)) {
            service.setExportXml(Boolean.TRUE);
            service.setFloatdispay("3");
        } else {
            boolean exportINI = rpaScheme.getBoolean("createinifile");
            service.setExportINI(exportINI);
            boolean mergeINI = rpaScheme.getBoolean("mergeinifile");
            service.setMergeINI(mergeINI);
            String iniRoleCole = this.getIniRuleCode(rpaScheme.getLong("scheme.id"));
            if (iniRoleCole == null) {
                iniRoleCole = "enterpriseCode&reportTypeCode";
            }
            service.setIniRuleCode(iniRoleCole);
        }
        service.setPackDownload(true);
        service.setFileAddress(rpaScheme.getString("fileaddress"));
        DynamicObjectCollection reportDoc = rpaScheme.getDynamicObjectCollection("reportentry");
        service.setrNumbers(reportDoc.stream().map(r -> r.getDynamicObject("basedatafield").getString(NUMBER)).collect(Collectors.toList()));
        HashMap<String, Map<String, String>> jqOrgMappingsingleMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, Set<String>> reportData2OrgMap = new HashMap<String, Set<String>>(16);
        IsRpaSchemeUtil.buildJqExportParamMap((long)rpaScheme.getLong("scheme.id"), jqOrgMappingsingleMap, reportData2OrgMap);
        service.setJqOrgMappingsingleMap(jqOrgMappingsingleMap);
        service.setReportData2OrgMap(reportData2OrgMap);
    }

    private String getIniRuleCode(long id) {
        String joinStr;
        QFilter pf = new QFilter("scheme", "=", (Object)id);
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_iniruledata", (String)"value", (QFilter[])new QFilter[]{pf}, (String)"ordernum asc");
        if (load != null && StringUtil.isNotEmpty((CharSequence)(joinStr = load.stream().map(r -> r.getString("value")).collect(Collectors.joining("&"))))) {
            return joinStr;
        }
        return null;
    }

    private void dispatch(NewReportMultiExportService service) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"ReportMultiExportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.fi.bcm.formplugin.report.ReportMultiExportTask");
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 100);
        params.put("service", this.toByteSerialized(service));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        this.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    public void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "taskcloseback": {
                TaskInfo taskInfo;
                String taskInfoStr;
                Object returnData;
                Map result;
                if (e.getReturnData() == null || !(result = (Map)(returnData = e.getReturnData())).containsKey("taskinfo") || !StringUtils.isNotEmpty((String)(taskInfoStr = (String)result.get("taskinfo"))) || !(taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() || this.getPageCache().get(DOWNLOADED) != null) break;
                String data = taskInfo.getData();
                JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
                JSONArray urls = dataObj.getJSONArray("data");
                String message = (String)dataObj.get((Object)"message");
                this.getPageCache().put(DOWNLOADED, "1");
                if (StringUtils.isNotEmpty((String)message)) {
                    this.getView().showTipNotification(message);
                }
                for (Object o : urls.toArray()) {
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)o.toString());
                }
                HashMap<String, Object> returnParam = new HashMap<String, Object>();
                returnParam.put("fileList", dataObj.get((Object)"fileList"));
                returnParam.put("actionType", this.getView().getFormShowParameter().getCustomParam("actionType"));
                returnParam.put(RPA_SCHEME, this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME));
                returnParam.put("noEffOrgs", dataObj.get((Object)"noEffOrgs"));
                returnParam.put("zipName", dataObj.get((Object)"zipName"));
                returnParam.put("fileNm2OrgMap", dataObj.get((Object)"fileNm2OrgMap"));
                DynamicObject year = (DynamicObject)this.getModel().getValue(fyear);
                DynamicObject period = (DynamicObject)this.getModel().getValue(period);
                returnParam.put(fyear, year == null ? 0L : year.getLong("id"));
                returnParam.put(period, period == null ? 0L : period.getLong("id"));
                List list = (List)JSON.parseObject((String)this.getPageCache().get("entity"), List.class);
                Set entityNumberSet = list.stream().map(m -> (String)m.get(NUMBER)).collect(Collectors.toSet());
                returnParam.put("entityNumberSet", entityNumberSet);
                this.getView().setReturnData(returnParam);
                this.getView().returnDataToParent(returnParam);
                this.getView().close();
                break;
            }
            case "entity": {
                DynamicObjectCollection doc = (DynamicObjectCollection)e.getReturnData();
                if (doc == null) break;
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(10);
                for (DynamicObject dot : doc) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dot.get(4).toString());
                    map.put("scope", dot.get(5).toString());
                    map.put(NUMBER, dot.get(2).toString());
                    map.put("name", dot.get(3).toString());
                    this.buildPageViewShowName(sb, dot.get(3).toString(), dot.getInt(5));
                    list.add(map);
                }
                if (StringUtils.isEmpty((String)sb.toString())) {
                    this.setValue(actionId, sb.toString());
                    this.getPageCache().remove(actionId);
                    break;
                }
                this.setValue(actionId, sb.substring(0, sb.length() - 1));
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
                break;
            }
        }
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"TemplatePageSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(",");
        }
    }

    private void checkParm() {
        if (this.getModel().getValue(fyear) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ISRpaExecuteParamPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue(period) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ISRpaExecuteParamPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("entity") == null || "".equals(this.getModel().getValue("entity"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ISRpaExecuteParamPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String schemeIdStr = this.getPageCache().get(IS_SCHEME);
        if (StringUtils.isEmpty((String)schemeIdStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u673a\u5668\u4eba\u65b9\u6848\u4e2d\u7684\u96c6\u6210\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaExecuteParamPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        long isSchemeId = Long.parseLong(schemeIdStr);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)isSchemeId, (String)"bcm_isscheme");
        if (scheme != null && DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()).contains(isSchemeId)) {
            String error = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7f16\u7801\u4e3a%s\u7684\u96c6\u6210\u65b9\u6848\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u3002", (String)"ISRpaSchemeListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scheme.getString(NUMBER));
            throw new KDBizException(error);
        }
        if (scheme != null && !scheme.getBoolean("status")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u673a\u5668\u4eba\u65b9\u6848\u4e2d\u7684\u96c6\u6210\u65b9\u6848\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaSchemeListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam(RPA_SCHEME);
        DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingle((Object)rpaSchemeId, (String)"bcm_isrpascheme");
        if (rpaScheme != null && !rpaScheme.getBoolean("status")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaSchemeListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashSet<Long> mappingOrgs = new HashSet<Long>(10);
        HashSet<Long> assignIds = new HashSet<Long>(10);
        HashSet<Long> selectOrgs = new HashSet<Long>(10);
        List orgs = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("entity"), HashMap.class);
        QueryServiceHelper.query((String)"bcm_issinglemap", (String)"targmembid", (QFilter[])new QFilter[]{new QFilter("schemeid", "=", (Object)isSchemeId)}).forEach(dyn -> mappingOrgs.add(dyn.getLong("targmembid")));
        DynamicObjectCollection assignOrgs = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)"entity.id,entity.number,range", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("scheme", "=", (Object)isSchemeId)});
        for (DynamicObject dyn2 : assignOrgs) {
            new MembRangeItem("bcm_entitymembertree", Long.valueOf(dyn2.getLong("entity.id")), dyn2.getString("entity.number"), dyn2.getInt("range"), false, (Object)this.getModelId()).matchItems(item -> assignIds.add(LongUtil.toLong((Object)item.id)));
        }
        for (int i = 0; i < orgs.size(); ++i) {
            HashMap org = (HashMap)orgs.get(i);
            new MembRangeItem("bcm_entitymembertree", LongUtil.toLong(org.get("id")), (String)org.get(NUMBER), Integer.parseInt((String)org.get("scope")), false, (Object)this.getModelId()).matchItems(item -> selectOrgs.add(LongUtil.toLong((Object)item.id)));
        }
        Set<Long> newSelectOrgs = this.getBaseIdSet(selectOrgs);
        Set<Long> newMappingOrgs = this.getBaseIdSet(mappingOrgs);
        Set<Long> newAssignIds = this.getBaseIdSet(assignIds);
        newSelectOrgs.removeIf(id -> !newMappingOrgs.contains(id) || !newAssignIds.contains(id));
        if (newSelectOrgs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5168\u90e8\u672a\u5206\u914d\u96c6\u6210\u65b9\u6848\u6216\u8005\u672a\u5728\u96c6\u6210\u65b9\u6848\u7ef4\u5ea6\u7ec4\u5408\u6620\u5c04\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaExecuteParamPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkReport() {
        Boolean canDispatch = true;
        DynamicObject yearDyn = (DynamicObject)this.getModel().getValue(fyear);
        DynamicObject periodDyn = (DynamicObject)this.getModel().getValue(period);
        MulBasedataDynamicObjectCollection reports = (MulBasedataDynamicObjectCollection)this.getModel().getValue(report);
        ArrayList<String> templateNumbers = new ArrayList<String>();
        for (DynamicObject report : reports) {
            templateNumbers.add(((DynamicObject)report.get("fbasedataid")).getString(NUMBER));
        }
        QFilter filter = new QFilter(NUMBER, "in", templateNumbers);
        filter.and(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,versionnumber", (QFilter[])filter.toArray());
        Set templateIds = templates.stream().map(temp -> temp.getLong("id")).collect(Collectors.toSet());
        Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)yearDyn.getLong("id"), (Long)periodDyn.getLong("id"), templateIds);
        Set<String> exportTemplates = templates.stream().map(t -> t.getString(NUMBER)).collect(Collectors.toSet());
        String schemeIdStr = this.getPageCache().get(IS_SCHEME);
        if (StringUtils.isEmpty((String)schemeIdStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u673a\u5668\u4eba\u65b9\u6848\u4e2d\u7684\u96c6\u6210\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaExecuteParamPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        long isSchemeId = LongUtil.toLong((Object)schemeIdStr);
        if (this.isJqOnline(isSchemeId)) {
            return true;
        }
        Pair<Map<String, List<String>>, Map<String, Set<String>>> pair = this.queryMapTemplateVersion(exportTemplates, isSchemeId);
        Map templateVersionMap = (Map)pair.p1;
        Map sheetTemplate = (Map)pair.p2;
        ArrayList<String> templateNums = new ArrayList<String>(10);
        for (DynamicObject temp2 : templates) {
            String number = temp2.getString(NUMBER);
            String versionNum = temp2.getString("versionnumber");
            if (!id2Right.containsValue(temp2.getLong("id"))) {
                sheetTemplate.values().forEach(set -> set.remove(number + versionNum));
                continue;
            }
            List versions = (List)templateVersionMap.get(number);
            if (versions != null && versions.contains(versionNum)) continue;
            templateNums.add(number);
        }
        String message = null;
        if (!templateNums.isEmpty()) {
            message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u62a5\u8868\u6a21\u677f%s\u5bf9\u5e94\u7248\u672c\u672a\u5728\u96c6\u6210\u65b9\u6848\u6620\u5c04\uff0c\u4e0d\u80fd\u5bfc\u51fa\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ReportMultiExportPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", templateNums));
        }
        for (Map.Entry entry : sheetTemplate.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4%s sheet\u9875\u53ef\u80fd\u6620\u5c04\u4e86\u4e0d\u540c\u6a21\u677f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ReportMultiExportPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entry.getKey());
            break;
        }
        if (StringUtils.isNotEmpty(message)) {
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("templateversion_confirm", (IFormPlugin)this));
            canDispatch = false;
        }
        return canDispatch;
    }

    private boolean isJqOnline(long schemeId) {
        boolean flag = false;
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject product = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number", (QFilter[])filter.toArray());
        if (product != null && IntegrateProductEnum.JQONLINEProduct.getNumber().equals(product.getString("issrc.number"))) {
            flag = true;
        }
        return flag;
    }

    private Pair<Map<String, List<String>>, Map<String, Set<String>>> queryMapTemplateVersion(Set<String> exportTemplates, Long isSchemeId) {
        QFilter qf = new QFilter("scheme", "=", (Object)isSchemeId);
        qf.and("mappingstatus", "=", (Object)"1");
        qf.and("effectstatus", "=", (Object)"1");
        DynamicObjectCollection sheetMapping = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,mappingstatus,effectstatus,template.number,template.versionnumber,floatmapping", (QFilter[])new QFilter[]{qf});
        HashMap<String, List> sheetMap = new HashMap<String, List>(sheetMapping.size());
        HashMap<String, Set> sheetTemplate = new HashMap<String, Set>(16);
        for (DynamicObject object : sheetMapping) {
            String templateNum = object.getString("template.number");
            String sheetNum = object.getString("sheetname");
            sheetMap.computeIfAbsent(templateNum, l -> new ArrayList());
            List verions = (List)sheetMap.get(templateNum);
            String versionNum = object.getString("template.versionnumber");
            verions.add(versionNum);
            sheetTemplate.computeIfAbsent(sheetNum, s -> new HashSet());
            Set templates = (Set)sheetTemplate.get(sheetNum);
            if (!exportTemplates.contains(templateNum)) continue;
            templates.add(templateNum + versionNum);
        }
        return Pair.onePair(sheetMap, sheetTemplate);
    }

    private Set<Long> getBaseIdSet(Set<Long> selectOrgs) {
        String modelCube = MemberReader.findModelNumberById((Object)this.getModelId());
        HashSet<Long> newSet = new HashSet<Long>(10);
        if (selectOrgs.size() == 0) {
            return newSet;
        }
        for (Long id : selectOrgs) {
            IDNumberTreeNode entityMemberById = MemberReader.findEntityMemberById((String)modelCube, (Long)id);
            if (entityMemberById.getId() == -1L) continue;
            newSet.add(entityMemberById.getBaseTreeNode().getId());
        }
        return newSet;
    }
}

