/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IsRpaSchemeUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ISRpaSchemeListPlugin
extends AbstractBaseListPlugin {
    private static final String ctl_billlistap = "billlistap";
    private static final String ctl_model = "model";
    private static final String btn_addnew = "btn_addnew1";
    private static final String btn_refresh = "btn_refresh1";
    private static final String btn_delete = "btn_delete1";
    private static final String btn_enable = "btn_enable1";
    private static final String btn_disable = "btn_disable1";
    private static final String btn_startrpa = "btn_startrpa1";
    private static final String btn_exportdata = "btn_exportdata1";
    private static final String btn_download = "btn_download1";
    private static final String btn_restore = "btn_restore1";
    private static final String CLICK_EDIT = "btn_edit";
    private static final String CLICK_LOG = "btn_log";
    private static final String toolbarap = "toolbarap";

    private static String getOperationCreateNew() {
        return ResManager.loadKDString((String)"\u65b0\u589e", (String)"ISRpaSchemeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"ISRpaSchemeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationEnable() {
        return ResManager.loadKDString((String)"\u751f\u6548", (String)"ISRpaSchemeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDisable() {
        return ResManager.loadKDString((String)"\u5931\u6548", (String)"ISRpaSchemeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStartRPA() {
        return ResManager.loadKDString((String)"\u542f\u52a8RPA", (String)"ISRpaSchemeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationExportData() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"ISRpaSchemeListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDownload() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"ISRpaSchemeListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationShowLog() {
        return ResManager.loadKDString((String)"\u67e5\u770b\u65e5\u5fd7", (String)"ISRpaSchemeListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ISSchemeListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap1");
        this.addClickListeners(CLICK_EDIT, CLICK_LOG);
        this.addItemClickListeners(toolbarap);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String modelId = (String)formShowParameter.getCustomParam("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), ctl_model);
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
            billList.getFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            this.getModel().setValue(ctl_model, (Object)modelId);
            this.refresh();
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        String schemeId = billList.getFocusRowPkId().toString();
        switch (key) {
            case "btn_edit": {
                this.openRpaScheme(schemeId);
                break;
            }
            case "btn_log": {
                this.openTaskLogView(schemeId);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validate()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_refresh1": {
                this.refresh();
                break;
            }
            case "btn_delete1": {
                this.actionDelete();
                break;
            }
            case "btn_enable1": 
            case "btn_disable1": {
                this.setUsable(key);
                break;
            }
            case "btn_exportdata1": 
            case "btn_startrpa1": {
                this.openExportCofig(key);
                break;
            }
            case "btn_download1": {
                this.openDownload();
                break;
            }
            case "btn_addnew1": {
                this.openRpaScheme(null);
                break;
            }
            case "btn_restore1": {
                this.restoreStatus();
            }
        }
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISRpaSchemeListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        this.getPageCache().put("schemeID", rows.get(0).getPrimaryKeyValue().toString());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u65b9\u6848\uff1f", (String)"ISRpaSchemeListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
    }

    private void openDownload() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bcm_exporturllist");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(true);
        showParameter.setLookUp(false);
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter(ctl_model, "=", (Object)this.getModelId())});
        showParameter.getListFilterParameter().setQFilters((List)filters);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openRpaScheme(String pkId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pkId", pkId);
        map.put("KEY_MODEL_ID", UserSelectUtil.getF7SelectId(this.getView(), ctl_model));
        if (StringUtils.isEmpty((CharSequence)pkId)) {
            map.put("addNew", "add_new");
        }
        this.openFormView("bcm_isrpascheme", map, pkId, new CloseCallBack((IFormPlugin)this, "addNewClose"));
    }

    private void restoreStatus() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISRpaSchemeListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue(), (String)"bcm_isrpascheme");
        scheme.set("excstatus", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        this.refresh();
    }

    private void setUsable(String key) {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISRpaSchemeListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        if (StringUtil.equals((String)btn_enable, (String)key)) {
            this.updateStatus(true, rows.get(0).getPrimaryKeyValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f\u3002", (String)"ISRpaSchemeListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeOperationLog(this.getOperationEnable(), rows.get(0).getNumber(), rows.get(0).getName(), ISRpaSchemeListPlugin.getOperationStstusSuccess());
        } else if (StringUtil.equals((String)btn_disable, (String)key)) {
            this.updateStatus(false, rows.get(0).getPrimaryKeyValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5931\u6548\u6210\u529f\u3002", (String)"ISRpaSchemeListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeOperationLog(this.getOperationDisable(), rows.get(0).getNumber(), rows.get(0).getName(), ISRpaSchemeListPlugin.getOperationStstusSuccess());
        }
        this.refresh();
    }

    private void updateStatus(boolean isUsable, Object pKValue) {
        QFilter filter = new QFilter("id", "=", pKValue);
        DynamicObject dos = BusinessDataServiceHelper.loadSingle((String)"bcm_isrpascheme", (String)"id, status", (QFilter[])new QFilter[]{filter});
        if (dos != null) {
            dos.set("status", (Object)(isUsable ? "1" : "0"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dos});
        }
    }

    private void openExportCofig(String itemkey) {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection dy = billList.getSelectedRows();
        if (dy == null || dy.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISRpaSchemeListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        Long id = (Long)dy.get(0).getPrimaryKeyValue();
        DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bcm_isrpascheme");
        if (rpaScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u88ab\u5220\u9664\u3002", (String)"ISRpaSchemeListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        if (rpaScheme.get("scheme.id") == null || rpaScheme.get("scheme.id") != null && !QueryServiceHelper.exists((String)"bcm_isscheme", (Object)rpaScheme.getLong("scheme.id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u673a\u5668\u4eba\u65b9\u6848\u4e2d\u7684\u96c6\u6210\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u88ab\u5220\u9664\u3002", (String)"ISRpaSchemeListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!rpaScheme.getBoolean("scheme.status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u673a\u5668\u4eba\u65b9\u6848\u4e2d\u7684\u96c6\u6210\u65b9\u6848\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaSchemeListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (btn_startrpa.equals(itemkey)) {
            if ("3".equals(rpaScheme.getString("excstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6267\u884c\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\uff0c\u4e0d\u53ef\u542f\u52a8RPA\u3002", (String)"ISRpaSchemeListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!rpaScheme.getBoolean("status")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISRpaSchemeListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "executeParam");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId("bcm_isrpaexecuteparam");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("actionType", (Object)(btn_exportdata.equals(itemkey) ? "man" : "rpa"));
        formShowParameter.setCustomParam("rpaScheme", (Object)id);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "delete_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                String schemeID = this.getPageCache().get("schemeID");
                this.delete(schemeID);
                break;
            }
        }
    }

    private void delete(String schemeID) {
        try (TXHandle txHandle = TX.requiresNew();){
            QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(schemeID));
            DynamicObject ratePlan = QueryServiceHelper.queryOne((String)"bcm_isrpascheme", (String)"id, name, number, status", (QFilter[])new QFilter[]{qFilter});
            if (ratePlan.getBoolean("status")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u751f\u6548\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ISRpaSchemeListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                DeleteServiceHelper.delete((String)"bcm_isrpascheme", (QFilter[])new QFilter[]{qFilter});
                QFBuilder qfBuilder = new QFBuilder("rpascheme", "=", (Object)Long.valueOf(schemeID));
                DeleteServiceHelper.delete((String)"bcm_isrpaschemerule", (QFilter[])qfBuilder.toArray());
                this.writeOperationLog(ISRpaSchemeListPlugin.getOperationDel(), ratePlan.getString("number"), ratePlan.getString("name"), ISRpaSchemeListPlugin.getOperationStstusSuccess());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISRpaSchemeListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refresh();
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        var3_3 = actionId = evt.getActionId();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1360686568: {
                if (!var3_3.equals("executeParam")) break;
                var4_4 = 0;
                break;
            }
            case 376959993: {
                if (!var3_3.equals("addNewClose")) break;
                var4_4 = 1;
            }
        }
        switch (var4_4) {
            case 0: {
                returnData = (Map)evt.getReturnData();
                if (returnData == null) break;
                actionType = (String)returnData.get("actionType");
                noEffOrgs = (String)returnData.get("noEffOrgs");
                id = (Long)returnData.get("rpaScheme");
                scheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isrpascheme");
                if (!"rpa".equals(actionType)) ** GOTO lbl117
                fileNm2OrgMap = (JSONObject)returnData.get("fileNm2OrgMap");
                if (fileNm2OrgMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5bfc\u51fa\u6570\u636e\u3002", (String)"ISRpaSchemeListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                newTaskDy = new ArrayList<DynamicObject>(10);
                updateTaskDy = new ArrayList<DynamicObject>(10);
                rpaTaskIds = scheme.getDynamicObjectCollection("rpataskid");
                rpaTaskIds.clear();
                proccode = scheme.getString("proccode");
                unattendedtype = scheme.getString("unattendedtype");
                runrobot = scheme.getString("runrobot");
                runRpa = this.checkNeedRunRpa(proccode, unattendedtype, runrobot);
                if (!runRpa) {
                    this.buildTaskLog(scheme, null, returnData, Long.toString(DBServiceHelper.genGlobalLongId()), null, newTaskDy, updateTaskDy, rpaTaskIds, null, "", "0");
                } else {
                    fileList = (String)returnData.get("fileList");
                    zipName = (String)returnData.get("zipName");
                    if (StringUtil.isEmptyString((String)runrobot)) {
                        runrobot = "deptall";
                    }
                    robots = runrobot.split(",");
                    modelNum = scheme.getString("model.number");
                    robotFileMap = this.getRobotFileMap(modelNum, robots, fileNm2OrgMap, fileList, zipName);
                    fileaddress = scheme.getString("fileaddress");
                    isRpaParams = null;
                    try {
                        ISRpaSchemeListPlugin.log.info("RpaService.getProcessParms: " + proccode);
                        isRpaParams = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessParms", (Object[])new Object[]{proccode, null});
                    }
                    catch (Exception e) {
                        ISRpaSchemeListPlugin.log.error("RPA getProcessParms error", (Throwable)e);
                        notice = ResManager.loadKDString((String)"\u83b7\u53d6RPA\u6d41\u7a0b\u53c2\u6570\u5931\u8d25\u3002", (String)"ISRpaSchemeListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        this.buildTaskLog(scheme, null, returnData, Long.toString(DBServiceHelper.genGlobalLongId()), null, newTaskDy, updateTaskDy, rpaTaskIds, null, notice, "2");
                    }
                    if (isRpaParams != null) {
                        for (Map.Entry<String, Map<String, String>> entry : robotFileMap.entrySet()) {
                            robot = entry.getKey();
                            orgs = entry.getValue().keySet();
                            taskId = Long.toString(DBServiceHelper.genGlobalLongId());
                            notice = "";
                            for (Map map : isRpaParams) {
                                if ("filenames".equals(map.get("Name"))) {
                                    map.put("Value", ObjectSerialUtil.toJson(entry.getValue()));
                                    continue;
                                }
                                if ("save_path".equals(map.get("Name"))) {
                                    map.put("Value", fileaddress);
                                    continue;
                                }
                                if (!"task_id".equals(map.get("Name"))) continue;
                                map.put("Value", taskId);
                            }
                            try {
                                ISRpaSchemeListPlugin.log.info("RpaService.addTask: " + proccode + " | " + robot + " | " + ObjectSerialUtil.toJson((Object)isRpaParams));
                                rpaTaskId = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"addTask", (Object[])new Object[]{proccode, robot, null, isRpaParams});
                                this.buildTaskLog(scheme, orgs, returnData, taskId, rpaTaskId, newTaskDy, updateTaskDy, rpaTaskIds, robot, notice, "3");
                            }
                            catch (Exception e) {
                                ISRpaSchemeListPlugin.log.error("RPA auto add Task error", (Throwable)e);
                                notice = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u53d1\u81f3RPA\u673a\u5668\u4eba\u5931\u8d25\u3002", (String)"ISRpaSchemeListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                                this.buildTaskLog(scheme, orgs, returnData, taskId, null, newTaskDy, updateTaskDy, rpaTaskIds, robot, notice, "2");
                            }
                        }
                    }
                }
                execstatus = this.getExecStatus(newTaskDy, updateTaskDy, runRpa);
                tx = TX.required();
                var20_20 = null;
                try {
                    try {
                        this.updateRpaSchemeStatus(scheme, execstatus, returnData);
                        if (CollectionUtils.isNotEmpty(newTaskDy)) {
                            SaveServiceHelper.save((DynamicObject[])newTaskDy.toArray(new DynamicObject[0]));
                        }
                        if (CollectionUtils.isNotEmpty(updateTaskDy)) {
                            SaveServiceHelper.save((DynamicObject[])updateTaskDy.toArray(new DynamicObject[0]));
                        }
                    }
                    catch (Throwable t) {
                        tx.markRollback();
                        throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
                    }
                }
                catch (Throwable var21_24) {
                    var20_20 = var21_24;
                    throw var21_24;
                }
                finally {
                    if (tx != null) {
                        if (var20_20 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable var21_23) {
                                var20_20.addSuppressed(var21_23);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                if (returnData.get("isUnit") != null) {
                    return;
                }
                this.refresh();
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u542f\u52a8RPA", "ISRpaSchemeListPlugin_4", "fi-bcm-formplugin", "Start RPA"), new OPDescMultiLangEnumBridge("\u201c%s\u201d\u65b9\u6848\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002", "ISRpaSchemeListPlugin_16", "fi-bcm-formplugin", new String[]{scheme.getString("number")}));
                ** GOTO lbl118
lbl117:
                // 1 sources

                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u6570\u636e", "ISRpaSchemeListPlugin_5", "fi-bcm-formplugin", "Export data"), new OPDescMultiLangEnumBridge("\u201c%s\u201d\u65b9\u6848\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002", "ISRpaSchemeListPlugin_16", "fi-bcm-formplugin", new String[]{scheme.getString("number")}));
lbl118:
                // 2 sources

                if (!StringUtils.isNotEmpty((CharSequence)noEffOrgs)) break;
                detail = IsRpaSchemeUtil.getMessageDetail((String)noEffOrgs);
                this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6bd5\uff0c\u90e8\u5206\u7ec4\u7ec7\u201c\u672a\u5206\u914d\u96c6\u6210\u65b9\u6848\u201d\u6216\u8005\u201c\u672a\u5728\u96c6\u6210\u65b9\u6848\u7ef4\u5ea6\u7ec4\u5408\u6620\u5c04\u4e2d\u7ef4\u62a4\u201d\u672a\u5bfc\u51fa\u3002", (String)"ISRpaSchemeListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), detail, MessageTypes.Default);
                break;
            }
            case 1: {
                this.refresh();
            }
        }
    }

    private boolean checkNeedRunRpa(String proccode, String unattendedtype, String runrobot) {
        if (StringUtil.isEmptyString((String)proccode) || StringUtil.isEmptyString((String)unattendedtype)) {
            return false;
        }
        return !"1".equals(unattendedtype) || !StringUtil.isEmptyString((String)runrobot);
    }

    private void buildTaskLog(DynamicObject scheme, Set<String> orgs, Map<String, Object> returnData, String taskId, String rpaTaskId, List<DynamicObject> newTaskDy, List<DynamicObject> updateTaskDy, DynamicObjectCollection rpaTaskIds, String robot, String notice, String status) {
        Long scenario = scheme.getLong("scenario.id");
        Long year = LongUtil.toLong((Object)returnData.get("year"));
        Long period = LongUtil.toLong((Object)returnData.get("period"));
        Long rpascheme = scheme.getLong("id");
        if (orgs == null) {
            orgs = (Set)returnData.get("entityNumberSet");
        }
        if (CollectionUtils.isNotEmpty(orgs)) {
            QFBuilder builder = new QFBuilder("number", "in", (Object)orgs);
            builder.add(ctl_model, "=", (Object)scheme.getLong("model.id"));
            builder.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])builder.toArray());
            HashSet orgIds = new HashSet(16);
            orgCol.forEach(e -> orgIds.add(e.getLong("id")));
            QFBuilder qf = new QFBuilder("taskid", "=", (Object)taskId).and("entity", "in", orgIds);
            DynamicObject[] taskArray = BusinessDataServiceHelper.load((String)"bcm_rpaschemetask", (String)"rpascheme,taskid,entity,status,executiondate,executionrobot,notice,noticedate,modeid,scenario,year,period", (QFilter[])qf.toArray());
            Map<Long, DynamicObject> entityMap = Arrays.stream(taskArray).collect(Collectors.toMap(r -> r.getLong("entity.id"), r -> r));
            Long modeid = LongUtil.toLong((Object)UserSelectUtil.getF7SelectId(this.getView(), ctl_model));
            Date date = TimeServiceHelper.now();
            Iterator iterator = orgIds.iterator();
            while (iterator.hasNext()) {
                long orgId = (Long)iterator.next();
                DynamicObject taskInfo = rpaTaskIds.addNew();
                taskInfo.set("task", (Object)taskId);
                taskInfo.set("robot", (Object)robot);
                taskInfo.set("orgid", (Object)orgId);
                if (MapUtils.isEmpty(entityMap) || !entityMap.containsKey(orgId)) {
                    DynamicObject schemeTask = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rpaschemetask");
                    schemeTask.set("rpascheme", (Object)rpascheme);
                    schemeTask.set("modeid", (Object)modeid);
                    schemeTask.set("taskid", (Object)taskId);
                    schemeTask.set("rpataskid", (Object)rpaTaskId);
                    schemeTask.set("entity", (Object)orgId);
                    schemeTask.set("status", (Object)status);
                    schemeTask.set("executiondate", (Object)date);
                    schemeTask.set("executionrobot", (Object)robot);
                    schemeTask.set("notice", (Object)notice);
                    schemeTask.set("noticedate", (Object)(StringUtil.isEmptyString((String)notice) ? null : date));
                    schemeTask.set("scenario", (Object)scenario);
                    schemeTask.set("year", (Object)year);
                    schemeTask.set("period", (Object)period);
                    schemeTask.set("modeid", (Object)modeid);
                    schemeTask.set("creator", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
                    newTaskDy.add(schemeTask);
                    continue;
                }
                DynamicObject updateTask = entityMap.get(orgId);
                if (updateTask == null) continue;
                updateTask.set("rpascheme", (Object)rpascheme);
                updateTask.set("scenario", (Object)scenario);
                updateTask.set("modeid", (Object)modeid);
                updateTask.set("year", (Object)year);
                updateTask.set("period", (Object)period);
                updateTask.set("executiondate", (Object)date);
                updateTask.set("executionrobot", (Object)robot);
                if (!StringUtil.isEmptyString((String)notice)) {
                    updateTask.set("notice", (Object)notice);
                    updateTask.set("noticedate", (Object)date);
                }
                updateTaskDy.add(updateTask);
            }
        }
    }

    private String reGetTaskId(String taskId) {
        if (Integer.parseInt(taskId) < 0) {
            return Long.toString(DBServiceHelper.genGlobalLongId());
        }
        return taskId;
    }

    private String getRpaStatus(String taskId) {
        switch (taskId) {
            case "-1": {
                return "2";
            }
            case "-2": {
                return "0";
            }
        }
        return "3";
    }

    private String getExecStatus(List<DynamicObject> newTaskDy, List<DynamicObject> updateTaskDy, boolean runRpa) {
        if (!runRpa) {
            return "0";
        }
        for (DynamicObject e : newTaskDy) {
            if ("-1".equals(e.getString("taskid"))) continue;
            return "3";
        }
        for (DynamicObject e : updateTaskDy) {
            if ("-1".equals(e.getString("taskid"))) continue;
            return "3";
        }
        return "2";
    }

    private void updateRpaSchemeStatus(DynamicObject scheme, String execstatus, Map<String, Object> returnData) {
        String modelNum = scheme.getString("model.number");
        Long year = LongUtil.toLong((Object)returnData.get("year"));
        Long period = LongUtil.toLong((Object)returnData.get("period"));
        String yearName = MemberReader.findFyMemberById((String)modelNum, (Long)year).getName();
        String periodName = MemberReader.findPeriodMemberById((String)modelNum, (Long)period).getName();
        String execParam = scheme.getString("scenario.name") + "\u3001" + yearName + "\u3001" + periodName;
        scheme.set("execparam", (Object)execParam);
        scheme.set("excstatus", (Object)execstatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validate()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), ctl_model);
                if (modelId == null) {
                    this.getModel().setValue(ctl_model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.refresh();
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                break;
            }
        }
    }

    private boolean validate() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        return !StringUtils.isEmpty((CharSequence)modelId);
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.refresh();
        billList.clearSelection();
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter(this.getModelSign(), "=", (Object)this.getModelId()));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        this.refresh();
    }

    private void openTaskLogView(String schemeId) {
        this.openForm("bcm_rpaschemetasklist", this.getView(), this.getBizAppId(), schemeId);
    }

    private Map<String, Map<String, String>> getRobotFileMap(String modelNum, String[] robots, JSONObject fileNm2OrgMap, String fileList, String zipName) {
        String[] files = fileList.split(",");
        HashMap org2fileName = new HashMap(16);
        fileNm2OrgMap.forEach((k, v) -> {
            String orgId = k.split("@")[0];
            String orgNum = MemberReader.findEntityMemberById((String)modelNum, (Long)Long.parseLong(orgId)).getNumber();
            org2fileName.put(orgNum, v.toString());
        });
        int orgSize = org2fileName.size();
        int singleRobotOrg = orgSize / robots.length;
        if (singleRobotOrg == 0) {
            singleRobotOrg = 1;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(16);
        for (int i = 0; i < robots.length && org2fileName.size() > 0; ++i) {
            int execSize = singleRobotOrg;
            if (i == robots.length - 1) {
                execSize = org2fileName.size();
            }
            Iterator iterator = org2fileName.entrySet().iterator();
            int num = 0;
            HashMap temp = new HashMap(16);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                temp.put(entry.getKey(), this.getFileName((String)entry.getValue(), files, zipName));
                iterator.remove();
                if (++num != execSize) continue;
                break;
            }
            result.put(robots[i], temp);
        }
        return result;
    }

    private String getFileName(String fileKey, String[] files, String zipName) {
        StringBuilder sb = new StringBuilder();
        for (String file : files) {
            if (!file.startsWith(fileKey + ".") || file.contains(".zip")) continue;
            sb.append(file).append(",");
        }
        sb.append(zipName).append(".zip");
        return sb.toString();
    }

    public void openForm(String formId, IFormView iFormView, String bizAppId, String schemeId) {
        String appId = AppMetadataCache.getAppInfo((String)bizAppId).getAppId();
        IFormView mainView = iFormView.getMainView();
        if (mainView == null) {
            mainView = iFormView;
        }
        String mainViewPageId = mainView.getPageId();
        String mainPageId = appId + mainViewPageId;
        String billPageId = mainViewPageId + schemeId;
        if (null != mainView.getViewNoPlugin(billPageId)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("view", iFormView);
            hashMap.put("formnumber", formId);
            hashMap.put("parametertype", "ListShowParameter");
            ISRpaSchemeListPlugin.activatePage(billPageId, iFormView, hashMap);
        } else {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setFormId(formId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setAppId(appId);
            formShowParameter.setBillFormId(formId.equals("bcm_rpaschemetasklist") ? "bcm_rpaschemetask" : formId);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7", (String)"ISRpaSchemeListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.setParentPageId(mainPageId);
            formShowParameter.setCustomParam("schemeid", (Object)schemeId);
            formShowParameter.setCustomParam(ctl_model, (Object)UserSelectUtil.getF7SelectId(iFormView, ctl_model));
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setPageId(billPageId);
            IFormView view = iFormView.getView(mainPageId);
            if (view == null) {
                iFormView.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55\u3002", (String)"ISRpaSchemeListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            view.showForm((FormShowParameter)formShowParameter);
            iFormView.sendFormAction(view);
        }
    }

    public static void activatePage(String pageId, IFormView view, Map<String, Object> map) {
        IFormView childView = view.getViewNoPlugin(pageId);
        if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
            childView = view.getView(pageId);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                Map customParameters = (Map)map.get("customparameters");
                childView.getFormShowParameter().getCustomParams().remove("messageId");
                childView.getFormShowParameter().getCustomParams().remove("tabType");
                childView.getFormShowParameter().getCustomParams().remove("openPage");
                if (customParameters != null) {
                    if (customParameters.get("messageId") != null) {
                        childView.getFormShowParameter().setCustomParam("messageId", customParameters.get("messageId"));
                    }
                    if (customParameters.get("tabType") != null) {
                        childView.getFormShowParameter().setCustomParam("tabType", customParameters.get("tabType"));
                    }
                    if (customParameters.get("openPage") != null) {
                        childView.getFormShowParameter().setCustomParam("openPage", customParameters.get("openPage"));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55\u3002", (String)"ISRpaSchemeListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void openFormView(String formId, Map<String, Object> paramMap, String pkId, CloseCallBack closeCallBack) {
        IFormView view = this.getView();
        IFormView mainPageView = view.getMainView();
        String pageId = this.getView().getPageId() + this.getBizAppId() + this.getUserId() + "-" + pkId;
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            HashMap<String, String> openParameter = new HashMap<String, String>(2);
            openParameter.put("formId", "bcm_isrpascheme");
            openParameter.put("pkId", pkId);
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addNewClose"));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (StringUtils.isEmpty((CharSequence)pkId)) {
                formShowParameter.setCustomParam("addNew", (Object)"add_new");
            }
            if (closeCallBack != null) {
                formShowParameter.setCloseCallBack(closeCallBack);
            }
            formShowParameter.setPageId(pageId);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)UserSelectUtil.getF7SelectId(this.getView(), ctl_model));
            if (parentView == null) {
                this.getView().showForm(formShowParameter);
            } else {
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            view.sendFormAction(childFormView);
        }
    }
}

