/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.util.ReportListUtil;

public class ISSchemeAssignPlugin
extends AbstractFormPlugin
implements IOperationLog,
TreeNodeCheckListener {
    public static final String ctl_temcatalogtree = "temcatalogtree";
    public static final String ctl_selectorg = "dentity";
    public static final String ctl_billlistap = "billlistap";

    private String getOperationSend() {
        return ResManager.loadKDString((String)"\u5206\u914d", (String)"ISSchemeAssignPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeAssignPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ISSchemeAssignPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners(new String[]{"btn_selectorg", "btn_deleteorg", "btn_unassign", "btn_details"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        EntryGrid orgeg = (EntryGrid)this.getControl(ctl_selectorg);
        orgeg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                ISSchemeAssignPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent evt) {
                List filters = evt.getQFilters();
                QFilter filter1 = ISSchemeAssignPlugin.this.getSchemeQueryFilter("scheme");
                QFilter filter2 = ISSchemeAssignPlugin.this.getOrgQueryFilter(ISSchemeAssignPlugin.ctl_selectorg, "oid", "entity");
                Long modelId = Long.parseLong(ISSchemeAssignPlugin.this.getPageCache().get("KEY_MODEL_ID"));
                List noPermIds = DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId);
                filters.add(new QFilter("scheme.id", "not in", (Object)noPermIds));
                if (filter1 == null && filter2 == null) {
                    filters.add(new QFilter("1", "!=", (Object)1));
                } else if (filter1 == null) {
                    filters.add(new QFilter("scheme.model", "=", (Object)modelId));
                    filters.add(new QFilter("scheme.templatecatalog.type", "=", (Object)"1"));
                    filters.add(filter2);
                } else if (filter2 == null) {
                    filters.add(filter1);
                } else {
                    filters.add(filter1.and(filter2));
                }
            }
        });
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                String viewid = (String)ISSchemeAssignPlugin.this.getModel().getValue("viewcombo");
                if (!viewid.equals("10") && viewid.equals("20")) {
                    Collections.swap(listCol, 0, 1);
                    Collections.swap(listCol, 1, 2);
                }
            }
        });
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        List select = ((TreeView)event.getSource()).getTreeState().getSelectedNodes();
        ArrayList selectId = new ArrayList();
        select.forEach(m -> selectId.add(m.get("id").toString()));
        this.getPageCache().put("templeteids", SerializationUtils.toJsonString(selectId));
        this.refreshBillList();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_distribute": {
                this.actionAssign();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_selectorg": {
                this.actionSelectOrg();
                break;
            }
            case "btn_deleteorg": {
                this.actionDeleteOrg();
                break;
            }
            case "btn_unassign": {
                this.actionUnAssign();
                break;
            }
            case "btn_details": {
                this.actionViewDetail();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                this.refreshBillList();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String catalogType = (String)this.getView().getFormShowParameter().getCustomParam("templatecatalog.type");
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        this.getPageCache().put("catalogType", catalogType);
        if (!StringUtils.isEmpty((CharSequence)modelid)) {
            this.setSchemeData2View(modelid);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(ctl_selectorg);
        switch (actionId) {
            case "ccb_selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
                this.refreshBillList();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete_confirm": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                BillList billList = (BillList)this.getControl(ctl_billlistap);
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Object[] ids = rows.getPrimaryKeyValues();
                QFilter qfilter = new QFilter("id", "in", (Object)ids);
                Pair<String, Boolean> schemeNumbers = this.getSchemeNumbers(qfilter);
                if (!((Boolean)schemeNumbers.p2).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u540e\u518d\u8bd5\u3002", (String)"ISSchemeAssignPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                try (TXHandle tx = TX.required();){
                    try {
                        BusinessDataWriter.delete((String)"bcm_isschemeassignentity", (QFilter[])new QFilter[]{qfilter});
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "RptAdjustdListPlugin_53", "fi-bcm-formplugin", "Delete"), new OPDescMultiLangEnumBridge("%s\u53cd\u5206\u914d\u6210\u529f\u3002", "ISSchemeAssignPlugin_15", "fi-bcm-formplugin", new String[]{(String)schemeNumbers.p1}));
                    }
                    catch (Exception exc) {
                        tx.markRollback();
                        throw new KDBizException(exc.toString());
                    }
                }
                this.refreshBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u6210\u529f\u3002", (String)"ISSchemeAssignPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private Pair<String, Boolean> getSchemeNumbers(QFilter qfilter) {
        StringBuilder sb = new StringBuilder();
        Map schemesMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_isschemeassignentity", (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject dynamicobject : schemesMap.values()) {
            DynamicObject scheme = dynamicobject.getDynamicObject("scheme");
            if (scheme == null) {
                return Pair.onePair((Object)sb.toString(), (Object)false);
            }
            sb.append(scheme.getString("number")).append(";");
        }
        return Pair.onePair((Object)sb.toString(), (Object)true);
    }

    private void setSchemeData2View(String modelid) {
        DynamicObjectCollection temlist = this.getSchemeColls(modelid);
        TreeNode rootview = ReportListUtil.getTemplateTree(this.mergeSchemeCatalogList(modelid), temlist, new ArrayList<TreeNode>(), "0", new TreeNode());
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList orgIds = new ArrayList();
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>();
        for (DynamicObject dd : temlist) {
            if (rows == null || !rows.contains(dd.getLong("id"))) continue;
            TreeNode node = rootview.getTreeNode(dd.getString("id"), 10);
            selNodes.add(node);
        }
        tree.addNode(rootview);
        if (selNodes.size() > 0) {
            tree.checkNodes(selNodes);
            this.getPageCache().put("templeteids", SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getPageCache().put("orgids", SerializationUtils.toJsonString(orgIds));
    }

    private DynamicObjectCollection getSchemeColls(String modelid) {
        QFilter modelFilter = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong((Object)modelid));
        QFilter typeFilter = new QFilter("templatecatalog.type", "=", (Object)this.getPageCache().get("catalogType"));
        Long modelId = Long.parseLong(this.getPageCache().get("KEY_MODEL_ID"));
        List noPermIds = DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId);
        QFilter notInFilter = new QFilter("id", "not in", (Object)noPermIds);
        QFilter[] filters = new QFilter[]{modelFilter, typeFilter, notInFilter};
        String selectFields = "id, name, number,templatecatalog,versionnumber";
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObjectCollection schemeEntityNew = QueryServiceHelper.query((String)"bcm_isscheme", (String)selectFields, (QFilter[])filters);
        result.addAll((Collection)schemeEntityNew);
        return result;
    }

    private List<Map<String, String>> mergeSchemeCatalogList(String modelid) {
        DynamicObjectCollection doc = this.getSchemecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>();
        for (DynamicObject dd : doc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getString("name"));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObjectCollection getSchemecatalogList() {
        QFilter modelFilter = new QFilter("model", "=", (Object)Long.parseLong(this.getPageCache().get("KEY_MODEL_ID")));
        QFilter typeFilter = new QFilter("type", "=", (Object)this.getPageCache().get("catalogType"));
        QFilter[] filters = new QFilter[]{modelFilter, typeFilter};
        String selectFields = "id,parent,name";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_schemecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(ctl_billlistap);
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getSchemeQueryFilter(String columnname) {
        List<String> rows = this.getSchemeResultList();
        QFilter filter = null;
        if (rows.size() > 0) {
            filter = new QFilter(columnname, "in", (Object)LongUtil.toLongList(rows));
        }
        return filter;
    }

    private List<String> getSchemeResultList() {
        String cache = this.getPageCache().get("templeteids");
        List<String> tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList();
        DynamicObjectCollection doc = this.getSchemecatalogList();
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString("id"));
        }
        tids.removeAll(clist);
        return tids;
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        String modelIdStr = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelIdStr == null) {
            return;
        }
        long modelId = Long.parseLong(modelIdStr);
        if (modelId == 0L) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    private QFilter getOrgQueryFilter(String entityid, String idname, String columnname) {
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(entityid);
        LinkedList<Long> mrows = new LinkedList<Long>();
        LinkedList<Long> lrows = new LinkedList<Long>();
        for (DynamicObject org : orglist) {
            if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                mrows.add(org.getLong(idname));
                continue;
            }
            lrows.add(org.getLong(idname));
        }
        QFilter filter = null;
        if (mrows.size() > 0) {
            filter = new QFilter(columnname, "in", (Object)mrows.toArray());
        }
        if (lrows.size() > 0) {
            QFilter filter2 = new QFilter("propertyvalue", "in", (Object)lrows.toArray());
            filter = filter == null ? filter2 : filter.or(filter2);
        }
        return filter;
    }

    private List<DynamicObject> getOrgSelectedAndResultList(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        int[] rows = eg.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityid, row);
            if (dd == null) continue;
            list.add(dd);
        }
        return list;
    }

    private void actionAssign() {
        List<String> schemelist = this.getSchemeResultList();
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(ctl_selectorg);
        if (schemelist.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u65b9\u6848\u3002", (String)"ISSchemeAssignPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (orglist.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"ISSchemeAssignPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> schemelistLong = this.getLongIds(schemelist);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", schemelistLong)});
        if (schemelist.size() > query.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u540e\u518d\u8bd5\u3002", (String)"ISSchemeAssignPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String error = this.checkPerm(schemelist);
        if (!Objects.equals(error, "")) {
            this.getView().showTipNotification(error);
            return;
        }
        String msg = this.removeOrgMenberScheme(schemelist);
        if (schemelist.size() < 1) {
            return;
        }
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        this.saveDistributeRecord(this.mergeResult(orglist, schemelist, modelid), msg);
    }

    private List<Long> getLongIds(List<String> schemelist) {
        ArrayList<Long> ids = new ArrayList<Long>(schemelist.size());
        schemelist.forEach(e -> ids.add(Long.parseLong(e)));
        return ids;
    }

    private String checkPerm(List<String> schemelist) {
        Long modelId = Long.parseLong(this.getPageCache().get("KEY_MODEL_ID"));
        List readPermIds = DIIntegrationUtil.getCurrentUserReadPermScheme((Long)modelId);
        List readPermStringIds = readPermIds.stream().map(Object::toString).collect(Collectors.toList());
        List readPermSchemeIds = schemelist.stream().filter(readPermStringIds::contains).collect(Collectors.toList());
        if (readPermSchemeIds.size() > 0) {
            List ids = readPermSchemeIds.stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            Set schemeName = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number", (QFilter[])filter.toArray()).stream().map(scheme -> scheme.getString("number")).collect(Collectors.toSet());
            String msg = String.join((CharSequence)" ", schemeName);
            String notice = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u9009\u7684\u65b9\u6848%s\u53ea\u80fd\u67e5\u770b\uff0c\u6ca1\u6709\u4fee\u6539\u6743\u9650\u3002", (String)"ISSchemeAssignPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg);
            return notice;
        }
        return "";
    }

    private void actionSelectOrg() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"ISSchemeAssignPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ccb_selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void actionDeleteOrg() {
        EntryGrid eg = (EntryGrid)this.getControl(ctl_selectorg);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"ISSchemeAssignPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ctl_selectorg, row);
        this.refreshBillList();
    }

    private void actionUnAssign() {
        BillList billlist = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"ISSchemeAssignPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"ISSchemeAssignPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
    }

    private void actionViewDetail() {
        BillList billlist = (BillList)this.getControl(ctl_billlistap);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_isschemeassigndetail");
        param.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u914d\u8be6\u60c5", (String)"ISSchemeAssignPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        Object[] ids = null;
        ids = billlist.getSelectedRows().getPrimaryKeyValues().length < 1 ? billlist.getCurrentListAllRowCollection().getPrimaryKeyValues() : billlist.getSelectedRows().getPrimaryKeyValues();
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(ctl_selectorg);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get("mid1").equals(oldone.get("oid")) || !newone.get("filltypevalue1").equals(oldone.get("rangevalue"))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(ctl_selectorg);
            model.setValue("entity", newone.get(3), index);
            model.setValue("rangevalue", newone.get(5), index);
            model.setValue("applytype", (Object)"1", index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private String removeOrgMenberScheme(List<String> tlist) {
        List temids;
        String oo = this.getPageCache().get("orgids");
        if (!StringUtils.isEmpty((CharSequence)oo) && tlist.removeAll(temids = (List)SerializationUtils.fromJsonString((String)oo, List.class))) {
            String msg = String.format(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u7ec4\u7ec7\u7ef4\u5ea6\u540d\u79f0\uff08%s\uff09\u5728\u89c6\u70b9\u7ef4\u7684\u62a5\u8868\u65b9\u6848\u3002", (String)"ISSchemeAssignPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getEntityName().getString("name"));
            return msg;
        }
        return "";
    }

    private DynamicObject getEntityName() {
        QFilter filter1 = new QFilter("model", "=", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name", (QFilter[])filters);
    }

    private List<DynamicObject> mergeResult(List<DynamicObject> orglist, List<String> schemelist, String modelid) {
        ArrayList<DynamicObject> dlist = new ArrayList<DynamicObject>();
        for (String scheme : schemelist) {
            for (DynamicObject org : orglist) {
                DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeassignentity");
                if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                    distribute.set("entity", org.get("oid"));
                } else {
                    distribute.set("property", org.get("pid"));
                    distribute.set("propertyvalue", org.get("oid"));
                }
                distribute.set("range", org.get("rangevalue"));
                distribute.set("scheme", (Object)scheme);
                distribute.set("model", (Object)modelid);
                distribute.set("applytype", (Object)org.getString("applytype"));
                distribute.set("textname", org.get("entity"));
                dlist.add(distribute);
            }
        }
        return dlist;
    }

    private void saveDistributeRecord(List<DynamicObject> dlist, String msg) {
        Long modelid = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,entity,scheme,range,propertyvalue ";
        DynamicObjectCollection oldoc = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)selectFields, (QFilter[])filters);
        int index = 0;
        block11: for (DynamicObject tem : oldoc) {
            index = 0;
            for (DynamicObject dd : dlist) {
                String cloname;
                Object entityid = dd.get("entity");
                String string = cloname = !ObjectUtils.isEmpty((Object)entityid) ? "entity" : "propertyvalue";
                if (tem.getLong("scheme") == dd.getLong("scheme") && tem.get("range").equals(dd.get("range")) && tem.getLong(cloname) == dd.getLong(cloname)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u65b9\u6848\u4e0d\u5efa\u8bae\u5206\u914d\u5230\u540c\u4e00\u4e2a\u7ec4\u7ec7\u7684\u591a\u4e2a\u8303\u56f4\u4e0a\u3002", (String)"ISSchemeAssignPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    dlist.remove(index);
                    continue block11;
                }
                ++index;
            }
        }
        if (dlist.size() < 1) {
            return;
        }
        List<String> schemelist = this.getSchemeResultList();
        this.removeOrgMenberScheme(schemelist);
        QFilter qcf = new QFilter("id", "in", (Object)LongUtil.toLongList(schemelist));
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_isscheme", (String)"name,number", (QFilter[])new QFilter[]{qcf});
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject[] newdoc = dlist.toArray(new DynamicObject[dlist.size()]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newdoc);
                if (oo.length > 0) {
                    for (int i = 0; i < data.size(); ++i) {
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5206\u914d", "ISSchemeAssignPlugin_0", "fi-bcm-formplugin", "Distribution"), new OPDescMultiLangEnumBridge("\u5206\u914d\u6210\u529f\u3002%s\u3002", "ISSchemeAssignPlugin_14", "fi-bcm-formplugin", new String[]{((DynamicObject)data.get(i)).getString("number") + " " + ((DynamicObject)data.get(i)).getString("name")}));
                    }
                    if (kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)msg)) {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"MemberPermEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg));
                    } else {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002%s\u3002", (String)"ISSchemeAssignPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg));
                    }
                }
            }
            catch (Exception e) {
                for (int i = 0; i < data.size(); ++i) {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5206\u914d", "ISSchemeAssignPlugin_0", "fi-bcm-formplugin", "Distribution"), new OPDescMultiLangEnumBridge("\u5206\u914d\u5931\u8d25\u3002%s\u3002", "ISSchemeAssignPlugin_19", "fi-bcm-formplugin", new String[]{((DynamicObject)data.get(i)).getString("number") + " " + ((DynamicObject)data.get(i)).getString("name")}));
                }
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
        this.refreshBillList();
    }
}

