/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class ISSchemeBizRuleSettingPlugin
extends AbstractBaseListPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ISSchemeBizRuleSettingPlugin.class);
    private static final String billlistap = "billlistap";
    private static final String toentryentity = "toentryentity";

    @Override
    public void initialize() {
        super.initialize();
        BillList bl = (BillList)this.getControl(billlistap);
        bl.addSetFilterListener(this::setFilter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_go", "btn_back", "btn_save", "btn_execute");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getFormCustomParam("KEY_MODEL_ID"));
        this.refreshBillList();
        this.refreshToEntryEntity();
    }

    private void refreshToEntryEntity() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject[] bizrules = BusinessDataServiceHelper.load((String)"bcm_isbizrule", (String)"id,bizrule", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model.getLong("id"))});
        if (bizrules.length > 0) {
            this.getModel().deleteEntryData(toentryentity);
            this.getModel().batchCreateNewEntryRow(toentryentity, bizrules.length);
            int index = 0;
            for (DynamicObject bizrule : bizrules) {
                DynamicObject entityRow = this.getModel().getEntryRowEntity(toentryentity, index);
                entityRow.set("tobizrule", bizrule.get("bizrule"));
                ++index;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.getPageCache().get("ruleSet") == null) {
            this.getPageCache().put("ruleSet", ObjectSerialUtil.toByteSerialized(new HashSet()));
        }
        Set ruleSet = (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("ruleSet"));
        switch (key) {
            case "btn_go": {
                this.actionGo(ruleSet);
                break;
            }
            case "btn_back": {
                this.actionBack(ruleSet);
                break;
            }
            case "btn_save": {
                this.actionSave();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ISSchemeBizRuleSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_execute": {
                this.actionExecute();
                break;
            }
        }
    }

    private void actionGo(Set<Object> ruleSet) {
        BillList billLsit = (BillList)this.getControl(billlistap);
        int selectSize = this.getModel().getEntryEntity(toentryentity).size();
        ListSelectedRowCollection selectRows = billLsit.getSelectedRows();
        int r = 0;
        for (int i = 0; i < selectRows.size(); ++i) {
            Object primaryKey = selectRows.get(i).getPrimaryKeyValue();
            if (ruleSet.contains(primaryKey)) continue;
            ruleSet.add(primaryKey);
            this.getModel().createNewEntryRow(toentryentity);
            this.getModel().setValue("tobizrule", primaryKey, selectSize + r);
            ++r;
        }
        this.getPageCache().put("ruleSet", ObjectSerialUtil.toByteSerialized(ruleSet));
    }

    private void actionBack(Set<Object> ruleSet) {
        EntryGrid sEntryGrid = (EntryGrid)this.getView().getControl(toentryentity);
        int[] selects = sEntryGrid.getSelectRows();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(toentryentity);
        for (int select : selects) {
            ruleSet.remove(((DynamicObject)doc.get(select)).getDynamicObject("tobizrule").getLong("id"));
        }
        this.getPageCache().put("ruleSet", ObjectSerialUtil.toByteSerialized(ruleSet));
        this.getModel().deleteEntryRows(toentryentity, selects);
    }

    private void actionSave() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        this.doDelete(model.getLong("id"));
        DynamicObjectCollection doc = this.getModel().getEntryEntity(toentryentity);
        ArrayList bizRuleDynaObj = new ArrayList();
        doc.forEach(d -> {
            DynamicObject bizrule = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbizrule");
            bizrule.set("model", (Object)model);
            bizrule.set("bizrule", (Object)d.getDynamicObject("tobizrule"));
            bizRuleDynaObj.add(bizrule);
        });
        if (bizRuleDynaObj.size() > 0) {
            DynamicObject rec = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbizrule");
            SaveServiceHelper.save((IDataEntityType)rec.getDynamicObjectType(), (Object[])bizRuleDynaObj.toArray(new Object[0]));
        }
    }

    private void doDelete(Long model) {
        BusinessDataWriter.delete((String)"bcm_isbizrule", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model)});
    }

    private void actionExecute() {
        this.actionSave();
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        JSONObject yearObj = (JSONObject)this.getFormCustomParam(DimTypesEnum.YEAR.getNumber());
        JSONObject periodObj = (JSONObject)this.getFormCustomParam(DimTypesEnum.PERIOD.getNumber());
        JSONObject sceneObj = (JSONObject)this.getFormCustomParam(DimTypesEnum.SCENARIO.getNumber());
        JSONObject currencyObj = (JSONObject)this.getFormCustomParam(DimTypesEnum.CURRENCY.getNumber());
        JSONArray orgIds = (JSONArray)this.getFormCustomParam("orgIds");
        JSONArray orgNums = (JSONArray)this.getFormCustomParam("orgNums");
        Object[] orgids = orgIds.toArray();
        String[] orgnums = (String[])orgNums.toArray((Object[])new String[0]);
        List<Long> bizRuleIds = this.getBizRuleIds(periodObj.getLong("id"));
        String modelNum = model.getString("number");
        if (CurrencyEnum.EC.getNumber().equals(currencyObj.getString("number"))) {
            QFBuilder currencyBuilder = new QFBuilder();
            currencyBuilder.add("id", "in", (Object)orgids);
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,currency.number", (QFilter[])currencyBuilder.toArray());
            Map<String, Long> currencyMap = this.getCurrencyNum2IdMap(model.getLong("id"));
            for (DynamicObject org : orgs) {
                BizRuleExecParam target = new BizRuleExecParam(modelNum);
                target.addCommonParamPair(PresetConstant.ENTITY_DIM, Long.valueOf(org.getLong("id")), org.getString("number"));
                target.addCommonParamPair(PresetConstant.CURRENCY_DIM, currencyMap.get(org.getString("currency.number")), org.getString("currency.number"));
                this.setCommonParams(target, yearObj, periodObj, sceneObj);
                target.addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findProcessMemberByNum((String)modelNum, (String)"IRpt").getId(), "IRpt");
                BizRuleExecStarter.execBizRule(bizRuleIds, (BizRuleExecParam)target, (boolean)false);
            }
        } else {
            for (int i = 0; i < orgnums.length; ++i) {
                BizRuleExecParam param = new BizRuleExecParam(model.getString("number"));
                param.getCommonParam().addCommonParamPair(DimTypesEnum.ENTITY.getNumber(), Long.valueOf(orgids[i].toString()), orgnums[i]);
                param.getCommonParam().addCommonParamPair(DimTypesEnum.CURRENCY.getNumber(), currencyObj.getLong("id"), currencyObj.getString("number"));
                this.setCommonParams(param, yearObj, periodObj, sceneObj);
                param.addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findProcessMemberByNum((String)modelNum, (String)"IRpt").getId(), "IRpt");
                BizRuleExecStarter.execBizRule(bizRuleIds, (BizRuleExecParam)param, (boolean)false);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u63d0\u4ea4\u5b8c\u6210\uff0c\u8fdb\u5165\u4e1a\u52a1\u89c4\u5219\u5217\u8868\u67e5\u770b\u6267\u884c\u60c5\u51b5\u3002", (String)"ISSchemeBizRuleSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object logMessageMap = formShowParameter.getCustomParam("logMessageMap");
        try {
            Map map = (Map)JSONUtils.cast((String)logMessageMap.toString(), Map.class);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                ArrayList value = (ArrayList)iterator.next().getValue();
                String orgName = (String)value.get(0);
                String number = (String)value.get(1);
                String schemeNumber = (String)value.get(2);
                String schemeName = (String)value.get(3);
                OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c", (String)"ISSchemeBizRuleSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s,\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u6210\u529f\u3002", (String)"ISSchemeBizRuleSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName, number, schemeNumber, schemeName), (Long)this.getModelId());
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private List<Long> getBizRuleIds(Long period) {
        ArrayList<Long> bizRuleIds = new ArrayList<Long>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(toentryentity);
        doc.forEach(d -> {
            DynamicObject bizrule = d.getDynamicObject("tobizrule");
            if (this.isEffective(bizrule, period)) {
                bizRuleIds.add(bizrule.getLong("id"));
            }
        });
        return bizRuleIds;
    }

    private Map<String, Long> getCurrencyNum2IdMap(Long modelid) {
        DynamicObject[] currency = BusinessDataServiceHelper.load((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelid)});
        HashMap<String, Long> map = new HashMap<String, Long>(currency.length);
        for (DynamicObject cur : currency) {
            map.put(cur.getString("number"), cur.getLong("id"));
        }
        return map;
    }

    private void setCommonParams(BizRuleExecParam param, JSONObject yearObj, JSONObject periodObj, JSONObject sceneObj) {
        param.getCommonParam().addCommonParamPair(DimTypesEnum.YEAR.getNumber(), yearObj.getLong("id"), yearObj.getString("number"));
        param.getCommonParam().addCommonParamPair(DimTypesEnum.PERIOD.getNumber(), periodObj.getLong("id"), periodObj.getString("number"));
        param.getCommonParam().addCommonParamPair(DimTypesEnum.SCENARIO.getNumber(), sceneObj.getLong("id"), sceneObj.getString("number"));
    }

    private boolean isEffective(DynamicObject bizrule, Long periodId) {
        long periodDimensionId = BizRuleUtil.getPeriodDimensionId((Object)this.getModelId());
        QFilter filter = new QFilter("bizrule", "=", (Object)bizrule.getLong("id"));
        filter.and("dimension", "=", (Object)periodDimensionId);
        DynamicObjectCollection scopeColl = QueryServiceHelper.query((String)"bcm_bizrulescope", (String)"member", (QFilter[])new QFilter[]{filter});
        if (scopeColl != null && !scopeColl.isEmpty()) {
            for (DynamicObject scope : scopeColl) {
                if (periodId.longValue() != scope.getLong("member")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(billlistap);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        e.getQFilters().add(new QFilter("deletestatus", "=", (Object)false));
    }
}

