/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import kd.fi.bcm.formplugin.intergration.util.SchemeDimHelper;
import kd.fi.bcm.formplugin.intergration.util.TurnSystem26Util;
import kd.fi.bcm.formplugin.intergration.vo.CellPointModel;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.xmlbeans.impl.common.Levenshtein;

public class ISSchemeCellMapppingPlugin
extends AbstractTemplateBasePlugin
implements ISpreadModelSupplier,
MainPage {
    private static String BCMREPORT = "bcmreport";
    private static String BCM_CACHE_DATA = "bcm_cache_data";
    private static String FLOAT_AREA = "float_area";
    private static String FIXED_AREA = "fixed_area";
    private static String ALL_AREA = "all_area";
    private static String BCMREPORT_CELLDATA = "bcmreport_data";
    private static String JQREPORT_CELLDATA = "jqreport_data";
    private static String SHEET_MAPPING_ID = "sheetmappingid";
    private static String SCHEME_ID = "scheme";
    private static String HASMODIFY = "hasModify";
    private static String TRUE_STR = "true";
    private static String FALSE_STR = "false";
    private static String JQREPORT_CELLDATA_1 = "jqreport_data_1";
    private static String JQREPORT_CELLLIGHT_1 = "jqreport_light_1";
    private static String KEY_SPLIT = "#";
    private static String JQSHEETNAME = "jqsheetname";
    private static String JQLIGHT_ROWS = "jqlight_rows";
    private static String JQLIGHT_COLS = "jqlight_cols";
    private static String SRCNUMBER = "srcNumber";
    private static String KEY_SEMICOLON = ";";
    private static String AI_CACHE_DATA = "ai_cache_data";
    private static String AREA_MARK = "area_mark";
    private SpreadManager spread;
    Comparator<CellPointModel> customComparator = (model1, model2) -> {
        if (!Objects.equals(model1.getPoint(), model2.getPoint())) {
            Double point = model1.getPoint() - model2.getPoint();
            if (point > 0.0) {
                return 1;
            }
            if (point < 0.0) {
                return -1;
            }
            return 0;
        }
        return model1.getInsertIndex() - model2.getInsertIndex();
    };
    Comparator<PositionInfo> infoComparator = (info1, info2) -> {
        if (info1.getAreaRange() != null && info2.getAreaRange() != null) {
            RangeModel rangeModel1 = new RangeModel(info1.getAreaRange());
            int fromRow1 = rangeModel1.getY_start();
            int fromCol1 = rangeModel1.getX_start();
            RangeModel rangeModel2 = new RangeModel(info2.getAreaRange());
            int fromRow2 = rangeModel2.getY_start();
            int fromCol2 = rangeModel2.getX_start();
            if (fromRow1 > fromRow2) {
                return 1;
            }
            if (fromRow1 == fromRow2) {
                return fromCol1 - fromCol2;
            }
            return -1;
        }
        return 0;
    };

    public static String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ISSchemeEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBtnGroupSetting();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sheetmappingbase"});
        this.initBcmSpread();
        this.initJqIfame();
    }

    private void initBtnGroupSetting() {
        Long schemeId = LongUtil.toLong((Object)this.getFormCustomParam("scheme"));
        this.getView().setVisible(Boolean.valueOf(CellMappingHandle.getXmlAttachment(schemeId) != null), new String[]{"btn_groupsetting"});
    }

    private Map<String, Object> getDataCacheMap() {
        HashMap<String, Object> dataCacheMap = new HashMap();
        String dataStr = this.getPageCache().get(BCM_CACHE_DATA);
        if (dataStr == null) {
            String id = this.getPageCache().get(SHEET_MAPPING_ID);
            QFilter filter = new QFilter("sheetmappingid", "=", (Object)Long.valueOf(id));
            DynamicObject[] data = BusinessDataServiceHelper.load((String)"bcm_iscellmappingdata", (String)"mappingjson", (QFilter[])new QFilter[]{filter});
            if (data.length > 0) {
                dataStr = data[0].getString("mappingjson");
                if (StringUtils.isEmpty((String)dataStr)) {
                    return dataCacheMap;
                }
                Map dataMap = (Map)JSONObject.parseObject((String)dataStr, HashMap.class);
                if ("EXCEL".equals(this.getPageCache().get(SRCNUMBER)) && dataMap.get("extendMark") != null) {
                    JSONArray areaMark = (JSONArray)dataMap.get("areaMark");
                    areaMark.addAll((Collection)((JSONArray)dataMap.get("extendMark")));
                }
                List dataList = (List)dataMap.get("data");
                Map map = null;
                List listLInner = null;
                for (int i = 0; i < dataList.size(); ++i) {
                    map = (Map)dataList.get(i);
                    for (Map.Entry mapIndex : map.entrySet()) {
                        listLInner = (List)mapIndex.getValue();
                        for (Map mapInner : listLInner) {
                            dataCacheMap.putAll(mapInner);
                        }
                    }
                }
                this.getPageCache().put(BCM_CACHE_DATA, JSONObject.toJSONString(dataCacheMap));
                if (dataMap.get("groupSetting") != null) {
                    List groupSetting = (List)dataMap.get("groupSetting");
                    ArrayList<Triple> returnData = new ArrayList<Triple>(10);
                    for (Map o : groupSetting) {
                        Map pair = (Map)o.get("right");
                        returnData.add(Triple.of((Object)((String)o.get("left")), (Object)((String)o.get("middle")), (Object)Pair.onePair(pair.get("p1"), pair.get("p2"))));
                    }
                    this.getPageCache().put("groupSetting", ObjectSerialUtil.toByteSerialized(returnData));
                }
                this.loadAreaMark(dataMap);
                return dataCacheMap;
            }
        } else {
            dataCacheMap = (Map)JSONObject.parseObject((String)dataStr, HashMap.class);
            return dataCacheMap;
        }
        return dataCacheMap;
    }

    private void loadAreaMark(Map<String, Object> dataMap) {
        if (dataMap.get("areaMark") != null) {
            List areaMark = (List)dataMap.get("areaMark");
            HashMap areaMarkMap = new HashMap(16);
            if (areaMark != null) {
                for (Map o : areaMark) {
                    areaMarkMap.put(o.get("area"), o.get("mark"));
                }
            }
            this.getPageCache().put(AREA_MARK, JSONObject.toJSONString(areaMarkMap));
        }
    }

    private void saveDataCacheMap(Map<String, Object> dataCacheMap) {
        this.getPageCache().put(BCM_CACHE_DATA, JSONObject.toJSONString(dataCacheMap));
        this.getPageCache().put(HASMODIFY, TRUE_STR);
    }

    private void initJqIfame() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_iscellmappingspread");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap2");
        String pageId = this.getPageIdAndCache(this.getPageCache(), "bcm_iscellmappingspread");
        showParameter.setPageId(pageId);
        showParameter.setCustomParam("sheetmappingid", (Object)this.getView().getPageCache().get("sheetmappingid"));
        showParameter.setCustomParam("floatArea", (Object)this.getView().getPageCache().get(FLOAT_AREA));
        this.getPageCache().put("spreadPageId", pageId);
        this.getView().showForm(showParameter);
    }

    @Override
    public void dealMsg(CommandParam com) {
        MainPage.super.dealMsg(com);
        String operation = com.getOperation();
        if ("hideBtn".equals(operation)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_mapping", "btn_excelmapping", "btn_delete"});
        } else if ("lightCell".equals(operation)) {
            this.handCellLight(com);
        } else if ("saveAreaMark".equals(operation)) {
            this.getPageCache().put(AREA_MARK, (String)com.getParam().get(0));
        }
    }

    private void handCellLight(CommandParam command) {
        this.blackPreLight();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        List<Object> param = command.getParam();
        List selRows = (List)param.get(0);
        List selCols = (List)param.get(1);
        ArrayList<Integer> newSelRows = new ArrayList<Integer>();
        ArrayList<Integer> newSelCols = new ArrayList<Integer>();
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        Map<String, String> dataStrCacheMap = this.turnDataCacheMap(dataCacheMap);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put("bkc", "#00ff00");
        String key = null;
        for (int i = 0; i < selRows.size(); ++i) {
            for (int j = 0; j < selCols.size(); ++j) {
                key = selRows.get(i) + KEY_SPLIT + selCols.get(j);
                if (!dataStrCacheMap.containsKey(key)) continue;
                String locationStr = dataStrCacheMap.get(key);
                String[] split = locationStr.split(KEY_SPLIT);
                Integer newSelRow = Integer.valueOf(split[0]);
                newSelRows.add(newSelRow);
                Integer newSelCol = Integer.valueOf(split[1]);
                newSelCols.add(newSelCol);
                invoker.setStyle(newSelRow, newSelCol, 1, 1, styleMap);
            }
        }
        invoker.startToInvoke();
        this.getPageCache().put(JQLIGHT_ROWS, JSONObject.toJSONString(newSelRows));
        this.getPageCache().put(JQLIGHT_COLS, JSONObject.toJSONString(newSelCols));
    }

    private Map<String, String> turnDataCacheMap(Map<String, Object> dataCacheMap) {
        HashMap<String, String> turnDataCacheMap = new HashMap<String, String>(dataCacheMap.size());
        String key = null;
        List objList = null;
        for (Map.Entry<String, Object> map : dataCacheMap.entrySet()) {
            key = map.getKey();
            objList = (List)map.getValue();
            String locationStr = (String)objList.get(0);
            turnDataCacheMap.put(locationStr, key);
        }
        return turnDataCacheMap;
    }

    private void initBcmSpread() {
        DynamicObject sheetMapping;
        boolean exists;
        String schemeId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String sheetmappingidStr = this.getPageCache().get(SHEET_MAPPING_ID);
        if (StringUtils.isEmpty((String)sheetmappingidStr)) {
            sheetmappingidStr = formShowParameter.getCustomParam(SHEET_MAPPING_ID).toString();
            this.getPageCache().put(SHEET_MAPPING_ID, sheetmappingidStr);
        }
        if (StringUtils.isEmpty((String)(schemeId = this.getPageCache().get(SCHEME_ID)))) {
            schemeId = (String)formShowParameter.getCustomParam(SCHEME_ID);
            this.getPageCache().put(SCHEME_ID, schemeId);
        }
        if (!(exists = QueryServiceHelper.exists((String)"bcm_templateentity", (Object)(sheetMapping = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sheetmappingidStr), (String)"bcm_issheetmapping")).getLong("template_id")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u3002", (String)"TplVersionEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("template_id", String.valueOf(sheetMapping.getLong("template_id")));
        TemplateModel templateModel = ModelDataProvider.getTemplateModel(sheetMapping.getLong("template_id"));
        this.getPageCache().put("isSaveByDim", String.valueOf(templateModel.isSaveByDim()));
        this.setUnableBtn(sheetMapping, schemeId, templateModel);
        String spreadjsonBcm = templateModel.getRptSpreadJson();
        String data = templateModel.getRptData();
        this.buildSpread(data);
        this.cacheFloatArea();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), BCMREPORT, spreadjsonBcm);
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), BCMREPORT, Collections.singletonList(this.getSpreadModel().getBook().getSheet(0).getSheetName()));
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), BCMREPORT);
        this.setToolbarLock();
        this.setItemHide();
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        if (dataCacheMap.isEmpty()) {
            this.cacheSpreadModel(this.spread);
            return;
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        String[] keyArr = null;
        String[] value = null;
        Object cellValue = null;
        for (Map.Entry<String, Object> map : dataCacheMap.entrySet()) {
            keyArr = map.getKey().split(KEY_SPLIT);
            value = ((String)((List)map.getValue()).get(0)).split(KEY_SPLIT);
            cellValue = this.getNewValue(Integer.valueOf(value[0]), Integer.valueOf(value[1]));
            invoker.updataValue(Integer.parseInt(keyArr[0]), Integer.parseInt(keyArr[1]), cellValue);
        }
        invoker.startToInvoke();
        this.cacheSpreadModel(this.spread);
    }

    private void setUnableBtn(DynamicObject sheetMapping, String schemeId, TemplateModel templateModel) {
        int effectstatus = sheetMapping.getInt("effectstatus");
        if (1 == effectstatus) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_mapping", "btn_excelmapping", "btn_delete", "btn_groupsetting", "btn_aimapping", "btn_removeaimapping", "btn_areamark"});
            return;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(schemeId), (String)"bcm_isscheme");
        String srcNumber = scheme.getString("issrc.number");
        this.getPageCache().put(SRCNUMBER, srcNumber);
        if ("1".equals(scheme.getString("status"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_mapping", "btn_excelmapping", "btn_delete", "btn_groupsetting", "btn_aimapping", "btn_removeaimapping", "btn_areamark"});
            return;
        }
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)templateModel.getRptData());
        Set postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
        boolean isContainsExtendInfo = postionInfoSet.stream().anyMatch(p -> p.getExtendInfo() != null);
        if (TemplateTypeEnum.DYNA.getType() == templateModel.getTemplateType().intValue() || isContainsExtendInfo) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_groupsetting"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_groupsetting"});
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_save", "btn_mapping", "btn_excelmapping", "btn_delete", "btn_areamark"});
        if (!templateModel.isSaveByDim()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_excelmapping"});
        }
        if ("JQ".equals(srcNumber)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_areamark"});
        }
    }

    private void setToolbarLock() {
        ArrayList<Map> toolbarItems = new ArrayList<Map>();
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.UploadFile, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.MergeCells, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        SpreadClientInvoker.invokeLockToolbarItems(this.getClientViewProxy(), BCMREPORT, toolbarItems);
    }

    private void setItemHide() {
        Map[] paramsHide = new Map[1];
        HashMap<String, Object> pa = new HashMap<String, Object>(16);
        pa.put("name", "clearContents");
        pa.put("isHide", true);
        paramsHide[0] = pa;
        SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "hideContextMenuItems", BCMREPORT, paramsHide);
    }

    private void cacheFloatArea() {
        Map<String, List<String>> areaMap = CellMappingHandle.getFloatArea(this.getSpreadModel(), false);
        List<String> areaRangeList = areaMap.get("float");
        this.getPageCache().put(FLOAT_AREA, JSONObject.toJSONString(areaRangeList));
        List<String> areaFixedList = areaMap.get("fixed");
        this.getPageCache().put(FIXED_AREA, JSONObject.toJSONString(areaFixedList));
        List<String> areaAllList = areaMap.get("all");
        this.getPageCache().put(ALL_AREA, JSONObject.toJSONString(areaAllList));
    }

    private List<String> getNeedArea(String type) {
        String floatAreaStr = this.getPageCache().get(type);
        List<String> areaRangeList = new LinkedList<String>();
        if (floatAreaStr == null) {
            return areaRangeList;
        }
        areaRangeList = (List)JSONObject.parseObject((String)floatAreaStr, LinkedList.class);
        return areaRangeList;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BasedataEdit sheetmappingbase = (BasedataEdit)this.getControl("sheetmappingbase");
        sheetmappingbase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.initSpreadListener();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_mapping": {
                this.mappingCell();
                break;
            }
            case "btn_save": {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                this.saveMappingCell();
                this.refreshSpread();
                this.getView().hideLoading();
                break;
            }
            case "btn_delete": {
                this.getView().showLoading(ResManager.getLocaleString((String)"\u6e05\u9664\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ExtendsDataDumpPlugin_31", (String)"fi-bcm-formplugin"));
                this.deleteMappingCell();
                this.getView().hideLoading();
                break;
            }
            case "btn_excelmapping": {
                this.excelMappingCell();
                break;
            }
            case "btn_changesheet": {
                this.changeSheetMapping();
                break;
            }
            case "btn_groupsetting": {
                this.groupSetting4Export();
                break;
            }
            case "btn_refresh": {
                this.refreshSpread();
                break;
            }
            case "btn_exit": {
                this.exitPage();
                break;
            }
            case "btn_aimapping": {
                this.aiMappingCell();
                break;
            }
            case "btn_removeaimapping": {
                this.removeAiMappingCell();
                break;
            }
            case "btn_areamark": {
                this.areaMark();
                break;
            }
        }
    }

    private void areaMark() {
        int j;
        String bcmDataStr = this.getPageCache().get(BCMREPORT_CELLDATA);
        if (bcmDataStr == null) {
            return;
        }
        JSONObject bcmObject = JSONObject.parseObject((String)bcmDataStr);
        JSONArray bcmSelRows = bcmObject.getJSONArray("selRows");
        JSONArray bcmSelCols = bcmObject.getJSONArray("selCols");
        if (bcmSelRows.size() != 1 || bcmSelCols.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\u3002", (String)"ISSchemeCellMapppingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Integer[]> floatAreaInt = this.getAreaInt(1);
        int i = (Integer)bcmSelRows.get(0);
        Integer[] area = CellMappingHandle.getInFloatArea(i, j = ((Integer)bcmSelCols.get(0)).intValue(), floatAreaInt);
        if (area == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6d6e\u52a8\u533a\u57df\u6682\u4e0d\u652f\u6301\u533a\u57df\u6807\u8bc6\u3002", (String)"ISSchemeCellMapppingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String realArea = CellMappingHandle.getRealArea(area);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_cellmappingareamark");
        param.setCaption(String.format(ResManager.loadKDString((String)"\u533a\u57df\u6807\u8bc6-%s", (String)"ISSchemeCellMapppingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), realArea));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_cellmappingareamark"));
        param.setCustomParam("realArea", (Object)realArea);
        Map<String, String> areaMarkMap = this.getAreaMarkFromCache();
        String areaMarkStr = areaMarkMap.get(realArea);
        param.setCustomParam("areaMarkStr", (Object)areaMarkStr);
        this.getView().showForm(param);
    }

    private Map<String, String> getAreaMarkFromCache() {
        String markStr = this.getPageCache().get(AREA_MARK);
        if (markStr == null) {
            return new HashMap<String, String>(16);
        }
        return (Map)JSONObject.parseObject((String)markStr, HashMap.class);
    }

    private void removeAiMappingCell() {
        String aiDataStr = this.getPageCache().get(AI_CACHE_DATA);
        if (aiDataStr == null) {
            return;
        }
        Map aiDataCacheMap = (Map)JSONObject.parseObject((String)aiDataStr, HashMap.class);
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        aiDataCacheMap.forEach((k, v) -> {
            if (dataCacheMap.containsKey(k)) {
                dataCacheMap.remove(k);
            }
        });
        SpreadManager spreadBcm = this.getSpreadModel();
        MultiAreaPositionsManager pm = spreadBcm.getAreaManager();
        Set positionInfoSet = pm.getPostionInfoSet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        for (PositionInfo positionInfo : positionInfoSet) {
            this.removeLeftReportDataByPosition(positionInfo, aiDataCacheMap, invoker);
        }
        invoker.startToInvoke();
        this.saveDataCacheMap(dataCacheMap);
        this.getPageCache().remove(AI_CACHE_DATA);
    }

    private void removeLeftReportDataByPosition(PositionInfo pi, Map<String, Object> aiDataCacheMap, SpreadEasyInvoker invoker) {
        if (pi != null && pi.getAreaRange() != null) {
            RangeModel rangeModel = new RangeModel(pi.getAreaRange());
            int fromRow = rangeModel.getY_start();
            int endRow = rangeModel.getY_end();
            int fromCol = rangeModel.getX_start();
            int endCol = rangeModel.getX_end();
            for (int r = fromRow; r <= endRow; ++r) {
                for (int c = fromCol; c <= endCol; ++c) {
                    if (!aiDataCacheMap.containsKey(r + KEY_SPLIT + c)) continue;
                    invoker.updataValue(r, c, null);
                }
            }
        }
    }

    private void groupSetting4Export() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_isgroupsetting4export");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_isgroupsetting4export"));
        param.setCustomParam("modelId", (Object)this.getModelId());
        param.setCustomParam("template_id", (Object)this.getPageCache().get("template_id"));
        param.setCustomParam("groupSetting", (Object)this.getPageCache().get("groupSetting"));
        this.getView().showForm(param);
    }

    private void exitPage() {
        String hasModify = this.getPageCache().get(HASMODIFY);
        if (TRUE_STR.equals(hasModify)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u5143\u683c\u6620\u5c04\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"SheetMappingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitPage", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    private void refreshSpread() {
        String hasModify = this.getPageCache().get(HASMODIFY);
        if (TRUE_STR.equals(hasModify)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u672a\u4fdd\u5b58\u4f1a\u5bfc\u81f4\u6570\u636e\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"DimMemberMapping_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("refreshSpread", (IFormPlugin)this));
            return;
        }
        this.getPageCache().put(BCM_CACHE_DATA, null);
        this.initBcmSpread();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_aimapping"});
    }

    private void changeSheetMapping() {
        String hasModify = this.getPageCache().get(HASMODIFY);
        if (TRUE_STR.equals(hasModify)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u6539\u53d8\uff0c\u672a\u4fdd\u5b58\u7684\u6570\u636e\u5c06\u4f1a\u4e22\u5931\uff0c\u786e\u5b9a\u9000\u51fa\u4e48\uff1f", (String)"AdjustExchangeSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close_save_confirm", (IFormPlugin)this));
            return;
        }
        String schemeId = this.getPageCache().get(SCHEME_ID);
        QFilter schemef = new QFilter("scheme", "=", (Object)Long.valueOf(schemeId));
        schemef.and("template", "!=", (Object)0L);
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bcm_issheetmapping", (boolean)false);
        lsp.getListFilterParameter().setFilter(schemef);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sheetmappingbase");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "sheetmappingbase": {
                this.changeSheetMappingRebuild((ListSelectedRowCollection)evt.getReturnData());
                break;
            }
            case "bcm_isgroupsetting4export": {
                if (evt.getReturnData() == null) break;
                List returnData = (List)evt.getReturnData();
                this.getPageCache().put("groupSetting", ObjectSerialUtil.toByteSerialized((Object)returnData));
                this.saveMappingCell();
                break;
            }
            case "bcm_cellmappingareamark": {
                if (evt.getReturnData() == null) break;
                Map resMap = (Map)evt.getReturnData();
                Map<String, String> areaMark = this.getAreaMarkFromCache();
                areaMark.put((String)resMap.get("realArea"), (String)resMap.get("areaMarkStr"));
                this.getPageCache().put(AREA_MARK, JSONObject.toJSONString(areaMark));
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (MessageBoxResult.No.equals((Object)mbce.getResult()) && "exitPage".equals(callBackId)) {
            this.getView().close();
            return;
        }
        if (MessageBoxResult.No.equals((Object)mbce.getResult())) {
            return;
        }
        switch (callBackId) {
            case "close_save_confirm": {
                this.getPageCache().put(HASMODIFY, FALSE_STR);
                this.changeSheetMapping();
                break;
            }
            case "refreshSpread": {
                this.getPageCache().put(HASMODIFY, FALSE_STR);
                this.refreshSpread();
                break;
            }
            case "exitPage": {
                this.saveMappingCell();
                this.getView().close();
                break;
            }
        }
    }

    private void changeSheetMappingRebuild(ListSelectedRowCollection returnData) {
        if (returnData == null) {
            return;
        }
        Long sheetmappingid = (Long)returnData.getBillListSelectedRowCollection().get(0).getPrimaryKeyValue();
        this.getPageCache().put(SHEET_MAPPING_ID, sheetmappingid.toString());
        DynamicObject sheetMapping = BusinessDataServiceHelper.loadSingle((Object)sheetmappingid, (String)"bcm_issheetmapping");
        Long scheme_id = sheetMapping.getLong("scheme_id");
        this.getPageCache().put(SCHEME_ID, scheme_id.toString());
        this.getPageCache().put(BCM_CACHE_DATA, null);
        this.getPageCache().put(FLOAT_AREA, null);
        this.getPageCache().put(JQREPORT_CELLDATA_1, null);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_save", "btn_mapping", "btn_excelmapping", "btn_delete", "btn_aimapping", "btn_removeaimapping"});
        this.initBcmSpread();
        this.initJqIfame();
    }

    private void aiMappingCell() {
        SpreadManager spreadBcm = this.getSpreadModel();
        Sheet sheet = spreadBcm.getBook().getSheet(0);
        MultiAreaPositionsManager pm = spreadBcm.getAreaManager();
        Set positionInfoSet = pm.getPostionInfoSet();
        boolean DynaAndExtendTable = positionInfoSet.stream().anyMatch(d -> d.getExtendInfo() != null || CollectionUtils.isNotEmpty((Collection)d.getBasePoints()));
        if (DynaAndExtendTable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u62a5\u8868\u6216\u62d3\u5c55\u6a21\u578b\u62a5\u8868\u6682\u4e0d\u652f\u6301\u667a\u80fd\u6620\u5c04\u3002", (String)"ISSchemeCellMapppingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        String pageId = this.getPageCache().get("spreadPageId");
        IFormView childFormView = this.getView().getView(pageId);
        SpreadManager spreadChild = this.getChildSpreads(childFormView);
        String jsonStr = childFormView.getPageCache().get("rightCellList");
        Map rightCellMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        Set keys = rightCellMap.keySet();
        ArrayList positionInfoList = new ArrayList(positionInfoSet);
        Collections.sort(positionInfoList, this.infoComparator);
        LinkedHashMap<String, Map<String, Object>> leftCellMap = new LinkedHashMap<String, Map<String, Object>>(keys.size());
        positionInfoList.forEach(pi -> this.setData((PositionInfo)pi, dataCacheMap, sheet, (Map<String, Map<String, Object>>)leftCellMap, rightCellMap));
        leftCellMap.forEach((key, innerMap) -> {
            List rightCellPointModelList = (List)innerMap.get("CellPointModelList");
            if (rightCellPointModelList != null) {
                Collections.sort(rightCellPointModelList, this.customComparator);
            }
        });
        rightCellMap.forEach((key, innerMap) -> {
            List rightCellPointModelList = (List)innerMap.get("CellPointModelList");
            if (rightCellPointModelList != null) {
                Collections.sort(rightCellPointModelList, this.customComparator);
            }
        });
        HashMap<String, String> aiFixValue = new HashMap<String, String>(16);
        HashSet<String> hasMatchCell = new HashSet<String>();
        log.info("leftCellMap:" + JSONObject.toJSONString(leftCellMap));
        log.info("rightCellMap:" + JSONObject.toJSONString((Object)rightCellMap));
        CellMappingHandle cellMappingHandle = new CellMappingHandle();
        cellMappingHandle.getCouple(leftCellMap, null, rightCellMap, aiFixValue, hasMatchCell, 1);
        this.fillLeftReportData(aiFixValue);
        this.insertToDataCacheMap(aiFixValue, spreadChild);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_aimapping"});
    }

    private int getDistancePoint(Long schemeId) {
        QFilter schemeQFilter = new QFilter("scheme", "=", (Object)Long.parseLong(schemeId.toString()));
        QFilter distanceQFilter = new QFilter("optionid", "=", (Object)SchemeDimHelper.getMappingOptionId("bcm_distance"));
        DynamicObject point = QueryServiceHelper.queryOne((String)"bcm_aimappingsetting", (String)"value", (QFilter[])new QFilter[]{schemeQFilter, distanceQFilter});
        if (Objects.isNull(point)) {
            return 7;
        }
        return Integer.parseInt(point.getString("value"));
    }

    private void setData(PositionInfo pi, Map<String, Object> dataCacheMap, Sheet sheet, Map<String, Map<String, Object>> leftCellMap, Map<String, Map<String, Object>> rightCellMap) {
        if (pi != null && pi.getAreaRange() != null) {
            RangeModel rangeModel = new RangeModel(pi.getAreaRange());
            int fromRow = rangeModel.getY_start();
            int endRow = rangeModel.getY_end();
            int fromCol = rangeModel.getX_start();
            int endCol = rangeModel.getX_end();
            Long SchemeId = Long.parseLong(this.getPageCache().get("scheme"));
            int distancePoint = this.getDistancePoint(SchemeId);
            Double distance = 1.0 - (double)distancePoint / 10.0;
            for (int r = fromRow; r <= endRow; ++r) {
                for (int c = fromCol; c <= endCol; ++c) {
                    if (dataCacheMap.containsKey(r + KEY_SPLIT + c)) continue;
                    List<Integer> rowHeaderList = this.findRowHeaderList(sheet, r - 1, c, false);
                    List<Integer> columnHeaderList = this.findColumnHeaderList(sheet, r, c - 1, false);
                    if (rowHeaderList.size() == 0 || columnHeaderList.size() == 0) continue;
                    String rowHeaderName = this.getRowHeadName(sheet, rowHeaderList, c);
                    String columnHeaderName = this.getColumnHeaderName(sheet, r, columnHeaderList);
                    String leftRowColHeader = columnHeaderName + ";" + rowHeaderName;
                    int finalR = r;
                    int finalC = c;
                    HashMap<String, Object> leftCell = new HashMap<String, Object>(4);
                    ArrayList leftCellPointModelList = new ArrayList(8);
                    AtomicInteger insertIndex = new AtomicInteger(1);
                    rightCellMap.forEach((key, innerMap) -> {
                        Double pointD = this.getPiont(leftRowColHeader, (String)innerMap.get("RowColHeader"));
                        Double score = pointD / Double.parseDouble(Math.max(leftRowColHeader.length(), ((String)innerMap.get("RowColHeader")).length()) + "");
                        if (score <= distance) {
                            int currentIndex = insertIndex.getAndIncrement();
                            String[] RowCol = key.split(";");
                            CellPointModel leftcpm = new CellPointModel(score, RowCol[0] + KEY_SEMICOLON + RowCol[1], currentIndex);
                            leftCellPointModelList.add(leftcpm);
                            if (innerMap.get("CellPointModelList") == null) {
                                CellPointModel rightcpm = new CellPointModel(score, finalR + KEY_SEMICOLON + finalC, 1);
                                ArrayList<CellPointModel> rightCellPointModelList = new ArrayList<CellPointModel>(8);
                                rightCellPointModelList.add(rightcpm);
                                innerMap.put("CellPointModelList", rightCellPointModelList);
                            } else {
                                List rightCellPointModelList = (List)innerMap.get("CellPointModelList");
                                CellPointModel rightcpm = new CellPointModel(score, finalR + KEY_SEMICOLON + finalC, rightCellPointModelList.size() + 1);
                                rightCellPointModelList.add(rightcpm);
                                innerMap.put("CellPointModelList", rightCellPointModelList);
                            }
                        }
                    });
                    leftCell.put("RowColHeader", leftRowColHeader);
                    leftCell.put("CellPointModelList", leftCellPointModelList);
                    leftCellMap.put(r + ";" + c, leftCell);
                }
            }
        }
    }

    private Double getPiont(String leftRowColHeader, String rightRowColHeader) {
        int pointI = Levenshtein.distance((String)leftRowColHeader, (String)rightRowColHeader);
        if (pointI == 0) {
            return 0.0;
        }
        String[] splitLeft = leftRowColHeader.split(";");
        String[] splitRight = rightRowColHeader.split(";");
        Double pointD1 = this.getPointContains(splitLeft[0], splitRight[0]);
        Double pointD2 = 0.0;
        if (splitLeft.length > 1 && splitRight.length > 1) {
            pointD2 = this.getPointContains(splitLeft[1], splitRight[1]);
        } else if (splitLeft.length > 1 && splitRight.length == 1) {
            pointD2 = Double.parseDouble(splitLeft[1].length() + "");
        } else if (splitLeft.length == 1 && splitRight.length > 1) {
            pointD2 = Double.parseDouble(splitRight[1].length() + "");
        }
        return pointD1 + pointD2;
    }

    private Double getPointContains(String left, String right) {
        if (left.contains(right) || right.contains(left)) {
            return this.getPointDouble(left, right);
        }
        if ((left = ISSchemeCellMapppingPlugin.removePunctuation(left)).contains(right = ISSchemeCellMapppingPlugin.removePunctuation(right)) || right.contains(left)) {
            return 0.1 + this.getPointDouble(left, right);
        }
        int pointI = Levenshtein.distance((String)left, (String)right);
        return Double.parseDouble(pointI + "");
    }

    private Double getPointDouble(String left, String right) {
        int minLength = Math.min(left.length(), right.length());
        int maxLength = Math.max(left.length(), right.length());
        return 1.0 - Double.parseDouble(minLength + "") / Double.parseDouble(maxLength + "");
    }

    public static String removePunctuation(String input) {
        String pattern = "\\p{Punct}+";
        String result = input.replaceAll(pattern, "").replaceAll(" ", "").replaceAll("\u3000", "");
        return result;
    }

    private String getColumnHeaderName(Sheet sheet, int r, List<Integer> columnHeaderList) {
        StringBuilder name = new StringBuilder();
        for (Integer c : columnHeaderList) {
            name.append(sheet.getCell(r, c.intValue()).getValue().toString().trim());
        }
        return name.toString();
    }

    private String getRowHeadName(Sheet sheet, List rowHeaderList, int c) {
        StringBuilder name = new StringBuilder();
        for (Object r : rowHeaderList) {
            name.append(sheet.getCell(((Integer)r).intValue(), c).getValue().toString().trim());
        }
        return name.toString();
    }

    private void insertToDataCacheMap(Map<String, String> aiFixValue, SpreadManager spreadChild) {
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        HashMap aiDataCacheMap = new HashMap();
        aiFixValue.forEach((k, v) -> {
            String[] bcmCoo = k.split(";");
            String[] jqCoo = v.split(";");
            if (spreadChild != null) {
                Cell jqCell = spreadChild.getBook().getSheet(0).getCell(Integer.parseInt(jqCoo[0]), Integer.parseInt(jqCoo[1]));
                String fixValue = this.getFixValue(jqCell.valueToString(), spreadChild.getBook().getSheet(0), Integer.parseInt(jqCoo[0]));
                this.caCheAiBcmData(bcmCoo, jqCoo, fixValue, dataCacheMap, aiDataCacheMap);
            }
        });
        this.getPageCache().put(AI_CACHE_DATA, JSONObject.toJSONString(aiDataCacheMap));
        this.saveDataCacheMap(dataCacheMap);
    }

    private void caCheAiBcmData(String[] bcmCoo, String[] jqCoo, String cellValue, Map<String, Object> dataCacheMap, Map<String, Object> aiDataCacheMap) {
        String key = bcmCoo[0] + KEY_SPLIT + bcmCoo[1];
        LinkedList<String> value = new LinkedList<String>();
        value.add(jqCoo[0] + KEY_SPLIT + jqCoo[1]);
        value.add(cellValue);
        if (!dataCacheMap.containsKey(key)) {
            dataCacheMap.put(key, value);
            aiDataCacheMap.put(key, value);
        }
    }

    private void fillLeftReportData(Map<String, String> aiFixValue) {
        SpreadManager spreadBcm = this.getSpreadModel();
        Sheet sheet = spreadBcm.getBook().getSheet(0);
        MultiAreaPositionsManager pm = spreadBcm.getAreaManager();
        Set positionInfoSet = pm.getPostionInfoSet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        positionInfoSet.forEach(positionInfo -> this.fillLeftReportDataByPosition((PositionInfo)positionInfo, sheet, aiFixValue, invoker));
        invoker.startToInvoke();
    }

    private void fillLeftReportDataByPosition(PositionInfo pi, Sheet sheet, Map<String, String> aiFixValue, SpreadEasyInvoker invoker) {
        if (pi != null && pi.getAreaRange() != null) {
            RangeModel rangeModel = new RangeModel(pi.getAreaRange());
            int fromRow = rangeModel.getY_start();
            int endRow = rangeModel.getY_end();
            int fromCol = rangeModel.getX_start();
            int endCol = rangeModel.getX_end();
            for (int r = fromRow; r <= endRow; ++r) {
                for (int c = fromCol; c <= endCol; ++c) {
                    if (sheet.getCell(r, c).getValue() != null || aiFixValue.get(r + ";" + c) == null) continue;
                    String[] rightCoordinates = aiFixValue.get(r + ";" + c).split(";");
                    Object cellValue = this.getNewValue(Integer.parseInt(rightCoordinates[0]), Integer.parseInt(rightCoordinates[1]));
                    invoker.updataValue(r, c, cellValue);
                    this.SetCellColor(r, c);
                }
            }
        }
    }

    private void SetCellColor(int r, int c) {
        HashMap<String, Integer> rangeMap2 = new HashMap<String, Integer>(1);
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.CC.k(), 1);
        ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>();
        rangeList.add(rangeMap2);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORECOLOR.k(), "#0000ff");
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), BCMREPORT, Lists.newArrayList((Object[])new Map[]{features}));
    }

    private List<Integer> findRowHeaderList(Sheet sheet, int r, int c, boolean isExhaustion) {
        LinkedList<Integer> resList = new LinkedList<Integer>();
        while (r >= 0) {
            Cell cell = sheet.getCell(r, c);
            if (this.isrightCell(cell)) {
                resList.add(r);
                if (!isExhaustion) {
                    return resList;
                }
            } else if (resList.size() > 0) {
                return resList;
            }
            --r;
            if (resList.size() < 5) continue;
            return resList;
        }
        return resList;
    }

    private boolean isrightCell(Cell cell) {
        boolean isNull;
        boolean bl = isNull = cell == null || cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString());
        if (isNull) {
            return false;
        }
        Object value = cell.getValue();
        String input = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : value.toString();
        boolean isNumber = this.checkIsNumber(input);
        return !isNull && !isNumber;
    }

    private boolean checkIsNumber(String input) {
        String regex = "^[+-]?\\d+(\\.\\d+)?$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private List<Integer> findColumnHeaderList(Sheet sheet, int r, int c, boolean isExhaustion) {
        LinkedList<Integer> resList = new LinkedList<Integer>();
        while (c >= 0) {
            Cell cell = sheet.getCell(r, c);
            if (this.isrightCell(cell)) {
                resList.add(c);
                if (!isExhaustion) {
                    return resList;
                }
            } else if (resList.size() > 0) {
                return resList;
            }
            --c;
            if (resList.size() < 5) continue;
            return resList;
        }
        return resList;
    }

    private void excelMappingCell() {
        SpreadManager spreadBcm = this.getSpreadModel();
        Sheet sheet = spreadBcm.getBook().getSheet(0);
        int maxRowCount = sheet.getMaxRowCount();
        int maxColumnCount = sheet.getMaxColumnCount();
        String pageId = this.getPageCache().get("spreadPageId");
        IFormView childFormView = this.getView().getView(pageId);
        SpreadManager spreadChild = this.getChildSpreads(childFormView);
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        Object newValue = null;
        String fixValue = null;
        List<Integer[]> floatAreaInt = this.getAreaInt(1);
        List<Integer[]> fixedAreaInt = this.getAreaInt(2);
        List<Integer[]> allAreaInt = this.getAreaInt(3);
        int isInFloatArea = 0;
        int isInFixedArea = 0;
        boolean hasMapping = false;
        int jqI = 0;
        for (int i = 0; i <= maxRowCount; ++i) {
            for (int j = 0; j <= maxColumnCount; ++j) {
                isInFloatArea = CellMappingHandle.isInFloatArea(i, j, floatAreaInt, allAreaInt);
                isInFixedArea = CellMappingHandle.isInFloatArea(i, j, fixedAreaInt, allAreaInt);
                if (spreadChild == null || isInFixedArea != 1 && isInFixedArea != 2 && isInFloatArea != 1 && isInFloatArea != 3) continue;
                jqI = CellMappingHandle.getTrueJqJ(i, floatAreaInt);
                Cell jqCell = spreadChild.getBook().getSheet(0).getCell(jqI, j);
                if ("JQ".equals(this.getPageCache().get(SRCNUMBER)) && !this.checkNotStandardContent(jqCell) && !this.hasXmlAttachment()) continue;
                newValue = this.getNewValue(jqI, j);
                invoker.updataValue(i, j, newValue);
                fixValue = this.getFixValue(jqCell.valueToString(), spreadChild.getBook().getSheet(0), jqI);
                this.caCheBcmData(i, j, jqI, j, fixValue, dataCacheMap);
                hasMapping = true;
            }
        }
        invoker.startToInvoke();
        this.saveDataCacheMap(dataCacheMap);
        if (!hasMapping) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6620\u5c04\u7684\u5355\u5143\u683c\u3002", (String)"SheetMappingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Integer[]> getAreaInt(int type) {
        List<Object> areaList = new LinkedList();
        if (type == 1) {
            areaList = this.getNeedArea(FLOAT_AREA);
        } else if (type == 2) {
            areaList = this.getNeedArea(FIXED_AREA);
        } else if (type == 3) {
            areaList = this.getNeedArea(ALL_AREA);
        }
        return CellMappingHandle.getFloatAreaInt(areaList);
    }

    private void deleteMappingCell() {
        String bcmDataStr = this.getPageCache().get(BCMREPORT_CELLDATA);
        if (bcmDataStr == null) {
            return;
        }
        JSONObject bcmObject = JSONObject.parseObject((String)bcmDataStr);
        JSONArray bcmSelRows = bcmObject.getJSONArray("selRows");
        JSONArray bcmSelCols = bcmObject.getJSONArray("selCols");
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        Integer bcmSelRowInt = null;
        Integer bcmSelColInt = null;
        for (int i = 0; i < bcmSelRows.size(); ++i) {
            for (int j = 0; j < bcmSelCols.size(); ++j) {
                bcmSelRowInt = (Integer)bcmSelRows.get(i);
                bcmSelColInt = (Integer)bcmSelCols.get(j);
                if (!dataCacheMap.containsKey(bcmSelRowInt + KEY_SPLIT + bcmSelColInt)) continue;
                invoker.updataValue(bcmSelRowInt, bcmSelColInt, null);
                dataCacheMap.remove(bcmSelRowInt + KEY_SPLIT + bcmSelColInt);
            }
        }
        invoker.startToInvoke();
        this.cacheSpreadModel(this.getSpreadModel());
        this.saveDataCacheMap(dataCacheMap);
        String id = this.getPageCache().get(SHEET_MAPPING_ID);
        QFilter idFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)id));
        DynamicObject sheetMapping = QueryServiceHelper.queryOne((String)"bcm_issheetmapping", (String)"sheetname,scheme.number", (QFilter[])new QFilter[]{idFilter});
        StringBuilder sb = new StringBuilder();
        if (sheetMapping != null && sheetMapping.getString("scheme.number") != null) {
            sb.append(sheetMapping.getString("scheme.number")).append(" ");
        }
        if (sheetMapping != null && sheetMapping.getString("sheetname") != null) {
            sb.append(sheetMapping.getString("sheetname")).append(" ");
        }
        String opName = ResManager.loadKDString((String)"\u6e05\u9664\u6620\u5c04", (String)"ISSchemeCellMapppingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDesc = ResManager.loadKDString((String)"\u6267\u884c\u6e05\u9664\u6620\u5c04", (String)"ISSchemeCellMapppingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6e05\u9664\u6620\u5c04", "ISSchemeCellMapppingPlugin_9", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("\u6267\u884c\u6e05\u9664\u6620\u5c04", "ISSchemeCellMapppingPlugin_10", "fi-bcm-formplugin", null));
    }

    private void saveMappingCell() {
        String pageId = this.getPageCache().get("spreadPageId");
        IFormView childFormView = this.getView().getView(pageId);
        String sheetName = childFormView.getPageCache().get(JQSHEETNAME);
        try {
            Map<String, Object> dataCacheMap = this.getDataCacheMap();
            String id = this.getPageCache().get(SHEET_MAPPING_ID);
            String schemeId = this.getPageCache().get(SCHEME_ID);
            SpreadManager spread = this.getSpreadModel();
            List<String> floatArea = this.getNeedArea(FLOAT_AREA);
            List groupSetting = this.getPageCache().get("groupSetting") == null ? null : (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("groupSetting"));
            Map areaMark = this.getPageCache().get(AREA_MARK) == null ? null : (Map)JSONObject.parseObject((String)this.getPageCache().get(AREA_MARK), Map.class);
            CellMappingHandle.saveMappingCell(dataCacheMap, Long.valueOf(id), Long.valueOf(schemeId), spread, floatArea, groupSetting, areaMark);
            this.getPageCache().put(HASMODIFY, FALSE_STR);
            this.getPageCache().remove(AI_CACHE_DATA);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ISSchemeCellMapppingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISSchemeEditPlugin_0", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f", "ISSchemeCellMapppingPlugin_0", "fi-bcm-formplugin", new String[]{sheetName}));
        }
        catch (Exception e) {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISSchemeEditPlugin_0", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u5931\u8d25", "ISSchemeCellMapppingPlugin_1", "fi-bcm-formplugin", new String[]{sheetName}));
            throw e;
        }
    }

    private void initSpreadListener() {
        this.registerBeforeEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            SpreadPostDataInfo dataInfo = (SpreadPostDataInfo)e.getSource();
            this.setBcmCacheData(dataInfo);
            this.lightCell(dataInfo);
        });
    }

    private void lightCell(SpreadPostDataInfo dataInfo) {
        Boolean isNotDimReport;
        String first = this.getPageCache().get(JQREPORT_CELLLIGHT_1);
        if (first == null) {
            this.getPageCache().put(JQREPORT_CELLLIGHT_1, "");
            return;
        }
        this.blackPreLight();
        List selRows = dataInfo.getSelRows();
        List selCols = dataInfo.getSelCols();
        if (this.getPageCache().get("isSaveByDim") != null && (isNotDimReport = Boolean.valueOf(!Boolean.parseBoolean(this.getPageCache().get("isSaveByDim")))).booleanValue() && dataInfo.getSelRows().size() * dataInfo.getSelCols().size() > 200) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u8d85\u8fc7200\uff0c\u5c06\u4e0d\u4f1a\u9ad8\u4eae\u663e\u793a\u3002", (String)"ISSchemeCellMapppingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        CommandParam com = new CommandParam("bcm_iscellmapping", "bcm_iscellmappingspread", "lightCell", selRows, selCols, dataCacheMap);
        this.sendMsg(this.getView(), com);
    }

    private void blackPreLight() {
        String lightRow = this.getPageCache().get(JQLIGHT_ROWS);
        String lightCol = this.getPageCache().get(JQLIGHT_COLS);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put("bkc", "#ffffff");
        if (lightRow != null && lightCol != null) {
            List selRows = (List)JSONObject.parseObject((String)lightRow, List.class);
            List selCols = (List)JSONObject.parseObject((String)lightCol, List.class);
            for (int i = 0; i < selRows.size(); ++i) {
                for (int j = 0; j < selCols.size(); ++j) {
                    invoker.setStyle((Integer)selRows.get(i), (Integer)selCols.get(j), 1, 1, styleMap);
                }
            }
        }
        invoker.startToInvoke();
    }

    private void setBcmCacheData(SpreadPostDataInfo dataInfo) {
        String first = this.getPageCache().get(JQREPORT_CELLDATA_1);
        if (first == null) {
            this.getPageCache().put(JQREPORT_CELLDATA_1, "");
            return;
        }
        HashMap<String, List> dataMap = new HashMap<String, List>();
        dataMap.put("selRows", dataInfo.getSelRows());
        dataMap.put("selCols", dataInfo.getSelCols());
        this.getPageCache().put(BCMREPORT_CELLDATA, JSONObject.toJSONString(dataMap));
    }

    private void mappingCell() {
        JSONArray bcmSelCols;
        boolean isStandardContent;
        String pageId = this.getPageCache().get("spreadPageId");
        IFormView childFormView = this.getView().getView(pageId);
        String jqDataStr = childFormView.getPageCache().get(JQREPORT_CELLDATA);
        if (jqDataStr == null) {
            return;
        }
        JSONObject jqObject = JSONObject.parseObject((String)jqDataStr);
        JSONArray jqSelRows = jqObject.getJSONArray("selRows");
        JSONArray jqSelCols = jqObject.getJSONArray("selCols");
        SpreadManager spreadChild = this.getChildSpreads(childFormView);
        if ("JQ".equals(this.getPageCache().get(SRCNUMBER)) && spreadChild != null && !this.hasXmlAttachment() && !(isStandardContent = this.checkNotStandardContent((List<Object>)jqSelRows, (List<Object>)jqSelCols, spreadChild))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e45\u5176\u5355\u5143\u683c\u9700\u4e3a\uff1a[,]\u3001[]\uff1b\u4f8b\u5982\uff1a[36,1]\u3001[MX4]", (String)"SheetMappingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Cell cell = null;
        String bcmDataStr = this.getPageCache().get(BCMREPORT_CELLDATA);
        if (bcmDataStr == null) {
            return;
        }
        JSONObject bcmObject = JSONObject.parseObject((String)bcmDataStr);
        JSONArray bcmSelRows = bcmObject.getJSONArray("selRows");
        boolean floatInFirst = this.checkFloatInFirst((List<Object>)bcmSelRows, (List<Object>)(bcmSelCols = bcmObject.getJSONArray("selCols")));
        if (!floatInFirst) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u533a\u57df\u53ea\u80fd\u6620\u5c04\u5728\u7b2c\u4e00\u884c\u3002", (String)"SheetMappingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> dataCacheMap = this.getDataCacheMap();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), BCMREPORT);
        invoker.setBatch(true);
        Integer jqSelRowInt = null;
        Integer jqSelColInt = null;
        Integer bcmSelRowInt = null;
        Integer bcmSelColInt = null;
        Object newValue = null;
        String fixValue = null;
        for (int i = 0; i < bcmSelRows.size() && jqSelRows.size() >= i + 1; ++i) {
            for (int j = 0; j < bcmSelCols.size() && jqSelCols.size() >= j + 1; ++j) {
                jqSelRowInt = (Integer)jqSelRows.get(i);
                jqSelColInt = (Integer)jqSelCols.get(j);
                if (spreadChild == null) continue;
                cell = spreadChild.getBook().getSheet(0).getCell(jqSelRowInt.intValue(), jqSelColInt.intValue());
                bcmSelRowInt = (Integer)bcmSelRows.get(i);
                bcmSelColInt = (Integer)bcmSelCols.get(j);
                newValue = this.getNewValue(jqSelRowInt, jqSelColInt);
                invoker.updataValue(bcmSelRowInt, bcmSelColInt, newValue);
                fixValue = this.getFixValue(cell.valueToString(), spreadChild.getBook().getSheet(0), jqSelRowInt);
                this.caCheBcmData(bcmSelRowInt, bcmSelColInt, jqSelRowInt, jqSelColInt, fixValue, dataCacheMap);
            }
        }
        invoker.startToInvoke();
        this.getSpreadModel().getBook();
        childFormView.getPageCache().put(JQREPORT_CELLDATA, null);
        this.getPageCache().put(BCMREPORT_CELLDATA, null);
        this.saveDataCacheMap(dataCacheMap);
    }

    private boolean hasXmlAttachment() {
        List<String> urls = CellMappingHandle.getTempUrls(LongUtil.toLong((Object)this.getPageCache().get(SCHEME_ID)), false);
        for (String url : urls) {
            if (!url.toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            return true;
        }
        return false;
    }

    private boolean checkNotStandardContent(List<Object> jqSelRows, List<Object> jqSelCols, SpreadManager spreadChild) {
        Sheet sheet = spreadChild.getBook().getSheet(0);
        Cell cell = null;
        for (int i = 0; i < jqSelRows.size(); ++i) {
            for (int j = 0; j < jqSelCols.size(); ++j) {
                cell = sheet.getCell(((Integer)jqSelRows.get(i)).intValue(), ((Integer)jqSelCols.get(j)).intValue());
                if (this.checkNotStandardContent(cell)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkNotStandardContent(Cell cell) {
        if (cell == null) {
            return false;
        }
        String valueToString = cell.valueToString();
        if (valueToString == null) {
            return false;
        }
        return valueToString.startsWith("[") && valueToString.endsWith("]");
    }

    private boolean checkFloatInFirst(List<Object> bcmSelRows, List<Object> bcmSelCols) {
        List<Integer[]> floatAreaInt = this.getAreaInt(1);
        List<Integer[]> allAreaInt = this.getAreaInt(3);
        int isInFloatArea = 0;
        int row = 0;
        int col = 0;
        for (int i = 0; i < bcmSelRows.size(); ++i) {
            for (int j = 0; j < bcmSelCols.size(); ++j) {
                row = (Integer)bcmSelRows.get(i);
                isInFloatArea = CellMappingHandle.isInFloatArea(row, col = ((Integer)bcmSelCols.get(j)).intValue(), floatAreaInt, allAreaInt);
                if (isInFloatArea != 2) continue;
                return false;
            }
        }
        return true;
    }

    private String getFixValue(String value, Sheet sheet, Integer row) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            if (value.contains(",")) {
                return value;
            }
            value = value.split("\\[")[1].split("\\]")[0];
        }
        int maxColumnCount = sheet.getMaxColumnCount();
        Cell cell = null;
        String valueToString = null;
        String realRow = null;
        for (int i = 0; i < maxColumnCount; ++i) {
            cell = sheet.getCell(row.intValue(), i);
            if (cell == null || StringUtils.isEmpty((String)(valueToString = cell.valueToString())) || !valueToString.startsWith("[") || !valueToString.endsWith("]") || !valueToString.contains(",")) continue;
            realRow = valueToString.split(",")[0].substring(1);
            return "[" + realRow + "," + value + "]";
        }
        return "[-1," + value + "]";
    }

    private Object getNewValue(Integer jqSelRowInt, Integer jqSelColInt) {
        return "[" + TurnSystem26Util.ToNumberSystem26(jqSelColInt + 1) + "," + (jqSelRowInt + 1) + "]";
    }

    private void caCheBcmData(Integer bcmSelRowInt, Integer bcmSelColInt, Integer jqSelRowInt, Integer jqSelColInt, Object cellValue, Map<String, Object> dataCacheMap) {
        String key = bcmSelRowInt + KEY_SPLIT + bcmSelColInt;
        LinkedList<Object> value = new LinkedList<Object>();
        value.add(jqSelRowInt + KEY_SPLIT + jqSelColInt);
        value.add(cellValue);
        dataCacheMap.put(key, value);
    }

    private SpreadManager getChildSpreads(IFormView childFormView) {
        SpreadManager spreadChild = null;
        String schema = childFormView.getPageCache().get("KEY_SPREAD_MODEL");
        if (StringUtils.isNotEmpty((String)schema)) {
            spreadChild = JsonSerializerUtil.toSpreadManager((String)schema);
        }
        return spreadChild;
    }

    @Override
    public SpreadManager getSpreadModel() {
        String schema;
        if (this.spread == null && StringUtils.isNotEmpty((String)(schema = this.getPageCache().get("KEY_SPREAD_MODEL")))) {
            this.spread = JsonSerializerUtil.toSpreadManager((String)schema);
        }
        return this.spread;
    }

    private void buildSpread(String data) {
        this.spread = JsonSerializerUtil.toSpreadManager((String)data);
        this.cacheSpreadModel(this.spread);
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        this.getPageCache().put("KEY_SPREAD_MODEL", JsonSerializerUtil.toJson((SpreadManager)sm));
    }
}

