/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ISSchemeCellMapppingSpreadPlugin
extends AbstractTemplateBasePlugin
implements ISpreadModelSupplier,
SubPage {
    private static String ROWSPAN = "rowSpan";
    private static String COLSPAN = "colSpan";
    private static String JQREPORT = "jqreport";
    private static String JQSHEETNAME = "jqsheetname";
    private static String JQREPORT_SPREAD = "jqreport_sp";
    private static String JQREPORT_CELLDATA = "jqreport_data";
    private static String JQREPORT_CELLDATA_1 = "jqreport_data_1";
    private static String JQLIGHT_ROWS = "jqlight_rows";
    private static String JQLIGHT_COLS = "jqlight_cols";
    private static String KEY_SPLIT = "#";
    private static String JQREPORT_CELLLIGHT_1 = "jqreport_light_1";
    private static String MARK_LEFTTOP = "markLefttop";
    private static String MARK_RIGHTTOP = "markRighttop";
    private static String MARK_LEFTDOWN = "markLeftdown";
    private static String MARK_RIGHTDOWN = "markRightdown";
    private static String AREA_MARK = "area_mark";
    private static String SRCNUMBER = "srcNumber";
    private int rowNum = 500;
    private int colNum = 200;
    private SpreadManager spread;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildSpreadjsonJq();
        this.setMenu();
    }

    private void setMenu() {
        String float_area = (String)this.getFormCustomParam("floatArea");
        if (float_area == null) {
            return;
        }
        ArrayList<Map<String, Object>> subMenuItems = new ArrayList<Map<String, Object>>(16);
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), JQREPORT);
        SpreadEasyInvoker.addContextSubMenuItem(MARK_LEFTTOP, ResManager.loadKDString((String)"\u5de6\u4e0a\u89d2", (String)"ISSchemeCellMapppingSpreadPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport", "colHeader", "rowHeader", "slicer"}, subMenuItems);
        SpreadEasyInvoker.addContextSubMenuItem(MARK_RIGHTTOP, ResManager.loadKDString((String)"\u53f3\u4e0a\u89d2", (String)"ISSchemeCellMapppingSpreadPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport", "colHeader", "rowHeader", "slicer"}, subMenuItems);
        SpreadEasyInvoker.addContextSubMenuItem(MARK_LEFTDOWN, ResManager.loadKDString((String)"\u5de6\u4e0b\u89d2", (String)"ISSchemeCellMapppingSpreadPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport", "colHeader", "rowHeader", "slicer"}, subMenuItems);
        SpreadEasyInvoker.addContextSubMenuItem(MARK_RIGHTDOWN, ResManager.loadKDString((String)"\u53f3\u4e0b\u89d2", (String)"ISSchemeCellMapppingSpreadPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport", "colHeader", "rowHeader", "slicer"}, subMenuItems);
        if (!"JQ".equals(this.getPageCache().get(SRCNUMBER))) {
            spreadEasyInvoker.addContextMenuItemAndSubMenu("mark_area", ResManager.loadKDString((String)"\u533a\u57df\u6807\u8bc6", (String)"ISSchemeCellMapppingSpreadPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport", "colHeader", "rowHeader", "slicer"}, subMenuItems);
        }
    }

    public void markLefttop() {
        this.openAreaListPage(MARK_LEFTTOP);
    }

    public void markRighttop() {
        this.openAreaListPage(MARK_RIGHTTOP);
    }

    public void markLeftdown() {
        this.openAreaListPage(MARK_LEFTDOWN);
    }

    public void markRightdown() {
        this.openAreaListPage(MARK_RIGHTDOWN);
    }

    private void openAreaListPage(String mark) {
        String selectAreaStr = this.getPageCache().get(JQREPORT_CELLDATA);
        if (selectAreaStr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\u3002", (String)"ISSchemeCellMapppingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject jqObject = JSONObject.parseObject((String)selectAreaStr);
        JSONArray jqSelRows = jqObject.getJSONArray("selRows");
        JSONArray jqSelCols = jqObject.getJSONArray("selCols");
        String selectArea = this.getSpreadModel().getBook().getSheet(0).getCell(((Integer)jqSelRows.get(0)).intValue(), ((Integer)jqSelCols.get(0)).intValue()).getValue().toString();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_cellmappingarealist");
        param.setCaption(ResManager.loadKDString((String)"\u6d6e\u52a8\u533a\u57df", (String)"RpaDataImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_cellmappingarealist"));
        String floatArea = (String)this.getFormCustomParam("floatArea");
        param.setCustomParam("floatArea", (Object)floatArea);
        param.setCustomParam("selectArea", (Object)selectArea);
        param.setCustomParam("mark", (Object)mark);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "bcm_cellmappingarealist": {
                this.saveAreaMark(evt);
                break;
            }
        }
    }

    private void saveAreaMark(ClosedCallBackEvent evt) {
        Map resMap = (Map)evt.getReturnData();
        if (resMap == null) {
            return;
        }
        Map<String, String> areaMark = this.getAreaMarkFromCache();
        String realArea = (String)resMap.get("floatarea");
        String areaMarkStr = areaMark.get(realArea);
        CharSequence[] areaMarkArr = new String[]{"", "", "", ""};
        if (areaMarkStr != null) {
            String[] areaMarkArrTemp = areaMarkStr.split(";");
            System.arraycopy(areaMarkArrTemp, 0, areaMarkArr, 0, areaMarkArrTemp.length);
        }
        String mark = (String)resMap.get("mark");
        String selectArea = (String)resMap.get("selectArea");
        try {
            Map selectAreaMap = (Map)ObjectSerialUtil.parseObject((String)selectArea, Map.class);
            selectArea = ((JSONObject)((JSONArray)selectAreaMap.get("richText")).get(0)).getString("text");
        }
        catch (Exception selectAreaMap) {
            // empty catch block
        }
        if (MARK_LEFTTOP.equals(mark)) {
            areaMarkArr[0] = selectArea;
        } else if (MARK_RIGHTTOP.equals(mark)) {
            areaMarkArr[1] = selectArea;
        } else if (MARK_LEFTDOWN.equals(mark)) {
            areaMarkArr[2] = selectArea;
        } else if (MARK_RIGHTDOWN.equals(mark)) {
            areaMarkArr[3] = selectArea;
        }
        areaMark.put(realArea, String.join((CharSequence)";", areaMarkArr));
        CommandParam com = new CommandParam("bcm_iscellmappingspread", "bcm_iscellmapping", "saveAreaMark", new Object[0]);
        ArrayList<Object> areaMarkList = new ArrayList<Object>(16);
        areaMarkList.add(JSONObject.toJSONString(areaMark));
        com.setParam(areaMarkList);
        this.sendMsg(this.getView(), com);
    }

    private Map<String, String> getAreaMarkFromCache() {
        String markStr = this.getView().getParentView().getPageCache().get(AREA_MARK);
        if (markStr == null) {
            return new HashMap<String, String>(16);
        }
        return (Map)JSONObject.parseObject((String)markStr, HashMap.class);
    }

    private void setToolbarLock() {
        ArrayList<Map> toolbarItems = new ArrayList<Map>();
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.UploadFile, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.MergeCells, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        SpreadClientInvoker.invokeLockToolbarItems(this.getClientViewProxy(), JQREPORT, toolbarItems);
    }

    private void setItemHide() {
        Map[] paramsHide = new Map[1];
        HashMap<String, Object> pa = new HashMap<String, Object>(16);
        pa.put("name", "clearContents");
        pa.put("isHide", true);
        paramsHide[0] = pa;
        SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "hideContextMenuItems", JQREPORT, paramsHide);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initSpreadListener();
    }

    private void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            SpreadPostDataInfo dataInfo = (SpreadPostDataInfo)e.getSource();
            this.setJqCacheData(dataInfo);
            this.lightCell(dataInfo);
        });
    }

    private void lightCell(SpreadPostDataInfo dataInfo) {
        this.blackPreLight();
        String first = this.getPageCache().get(JQREPORT_CELLLIGHT_1);
        if (first == null) {
            this.getPageCache().put(JQREPORT_CELLLIGHT_1, "");
            return;
        }
        List selRows = dataInfo.getSelRows();
        List selCols = dataInfo.getSelCols();
        CommandParam com = new CommandParam("bcm_iscellmappingspread", "bcm_iscellmapping", "lightCell", selRows, selCols);
        this.sendMsg(this.getView(), com);
    }

    private void blackPreLight() {
        String lightRow = this.getPageCache().get(JQLIGHT_ROWS);
        String lightCol = this.getPageCache().get(JQLIGHT_COLS);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), JQREPORT);
        invoker.setBatch(true);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put("bkc", "#ffffff");
        if (lightRow != null && lightCol != null) {
            List selRows = (List)JSONObject.parseObject((String)lightRow, List.class);
            List selCols = (List)JSONObject.parseObject((String)lightCol, List.class);
            for (int i = 0; i < selRows.size(); ++i) {
                for (int j = 0; j < selCols.size(); ++j) {
                    invoker.setStyle((Integer)selRows.get(i), (Integer)selCols.get(j), 1, 1, styleMap);
                }
            }
        }
        invoker.startToInvoke();
    }

    private void setJqCacheData(SpreadPostDataInfo dataInfo) {
        String first = this.getPageCache().get(JQREPORT_CELLDATA_1);
        if (first == null) {
            this.getPageCache().put(JQREPORT_CELLDATA_1, "");
            return;
        }
        HashMap<String, List> dataMap = new HashMap<String, List>();
        dataMap.put("selRows", dataInfo.getSelRows());
        dataMap.put("selCols", dataInfo.getSelCols());
        this.getPageCache().put(JQREPORT_CELLDATA, JSONObject.toJSONString(dataMap));
    }

    private void buildSpreadjsonJq() {
        FormShowParameter showPara = this.getView().getFormShowParameter();
        String sheetmappingid = (String)showPara.getCustomParam("sheetmappingid");
        DynamicObject sheetMapping = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sheetmappingid), (String)"bcm_issheetmapping");
        String sheetName = sheetMapping.getString("sheetname");
        long scheme_id = sheetMapping.getLong("scheme_id");
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)scheme_id, (String)"bcm_isscheme");
        String srcNumber = scheme.getString("issrc.number");
        this.getPageCache().put(SRCNUMBER, srcNumber);
        List<String> urls = CellMappingHandle.getTempUrls(scheme_id, true);
        Object innerSheetName = null;
        int workbookType = 0;
        Object xwb = null;
        boolean allXlsx = urls.stream().allMatch(file -> file.toLowerCase(Locale.ENGLISH).endsWith(".xlsx"));
        if (allXlsx) {
            block5: {
                try {
                    this.buildSpreadJsonJqXlsx(sheetName, urls);
                }
                catch (Exception e) {
                    if (!(e instanceof IllegalArgumentException)) break block5;
                    try {
                        this.buildPoi(urls, workbookType, sheetName);
                    }
                    catch (Exception ex) {
                        log.error("buildSpreadJsonJqXlsx failed,information:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)30), (Throwable)ex);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790Excel\u6587\u4ef6\u5931\u8d25\u3002\u8bf7\u68c0\u67e5Excel\u6587\u4ef6\u7684\u6837\u5f0f\u6216\u5c5e\u6027\u662f\u5426\u6b63\u786e\u3002", (String)"ISSchemeCellMapppingSpreadPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            return;
        }
        this.buildPoi(urls, workbookType, sheetName);
    }

    private void buildPoi(List<String> urls, int workbookType, String sheetName) {
        Workbook xwb = null;
        String innerSheetName = null;
        for (String url : urls) {
            workbookType = CellMappingHandle.getWorkbookType(url);
            xwb = CellMappingHandle.getWorkbook(url, workbookType);
            int sheetCount = 0;
            sheetCount = workbookType == 1 ? ((HSSFWorkbook)xwb).getNumberOfSheets() : ((XSSFWorkbook)xwb).getNumberOfSheets();
            for (int i = 0; i < sheetCount && !sheetName.equals(innerSheetName = workbookType == 1 ? ((HSSFWorkbook)xwb).getSheetName(i) : ((XSSFWorkbook)xwb).getSheetName(i)); ++i) {
                innerSheetName = null;
            }
            if (innerSheetName == null) continue;
            break;
        }
        if (innerSheetName == null) {
            CommandParam com = new CommandParam("bcm_iscellmappingspread", "bcm_iscellmapping", "hideBtn", new Object[0]);
            this.sendMsg(this.getView(), com);
            return;
        }
        this.getPageCache().put(JQSHEETNAME, innerSheetName);
        Object sheet = null;
        sheet = workbookType == 1 ? ((HSSFWorkbook)xwb).getSheet(innerSheetName) : ((XSSFWorkbook)xwb).getSheet(innerSheetName);
        List mergedRegions = sheet.getMergedRegions();
        int totalRowNum = sheet.getLastRowNum();
        this.rowNum = Math.max(totalRowNum, this.rowNum);
        Row row = null;
        int lastCellNum = 0;
        JSONObject rowColSpan = null;
        this.buildSpread();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), JQREPORT);
        invoker.setBatch(true);
        CellBase cell = null;
        Map<String, Object> styleMap = null;
        HashMap<Integer, List<Integer>> rowHeightMap = new HashMap<Integer, List<Integer>>(16);
        HashMap<Integer, List<Integer>> colWidthMap = new HashMap<Integer, List<Integer>>(16);
        ArrayList<Map<String, Object>> featureList = new ArrayList<Map<String, Object>>(16);
        LinkedHashMap<String, Map<String, Object>> rightCellMap = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i <= totalRowNum; ++i) {
            this.getRowHeight((Sheet)sheet, i, rowHeightMap);
            row = sheet.getRow(i);
            if (row == null) continue;
            lastCellNum = row.getLastCellNum();
            this.colNum = Math.max(lastCellNum, this.colNum);
            for (int j = 0; j <= lastCellNum; ++j) {
                if (i == 0) {
                    this.getColWidth((Sheet)sheet, j, colWidthMap);
                }
                cell = (CellBase)row.getCell(j);
                this.prepareRightCellMap(rightCellMap, (Sheet)sheet, row, i, j);
                if (cell == null) continue;
                rowColSpan = this.getRowColSpan((org.apache.poi.ss.usermodel.Cell)cell, mergedRegions);
                if (rowColSpan != null) {
                    invoker.setSpan(i, j, rowColSpan.getInteger(ROWSPAN), rowColSpan.getInteger(COLSPAN));
                }
                styleMap = this.getCellStyle(cell);
                this.getFeatureList(i, j, styleMap, featureList);
                CellType cellType = cell.getCellType();
                Object newValue = null;
                if (CellType.STRING.equals((Object)cellType)) {
                    newValue = cell.getStringCellValue();
                } else if (CellType.NUMERIC.equals((Object)cellType)) {
                    newValue = this.getNumericCellValue(cell);
                }
                invoker.updataValue(i, j, newValue);
                this.spread.getBook().getSheet(0).getCell(i, j).setValue(newValue);
            }
        }
        this.getPageCache().put("rightCellList", SerializationUtils.toJsonString(rightCellMap));
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), JQREPORT, this.getInitSpreadJson());
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), JQREPORT);
        this.setToolbarLock();
        this.setItemHide();
        this.setRowHeight(rowHeightMap);
        this.setColWidth(colWidthMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), JQREPORT, featureList);
        invoker.startToInvoke();
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), JQREPORT, Collections.singletonList(this.getSpreadModel().getBook().getSheet(0).getSheetName()));
        this.cacheSpreadModel(this.spread);
    }

    private void prepareRightCellMap(Map<String, Map<String, Object>> rightCellMap, Sheet sheet, Row row, int i, int j) {
        if (this.checkNotStandardContentPoi(row.getCell(j))) {
            HashMap<String, String> rightCell = new HashMap<String, String>(4);
            List<Integer> rowHeaderList = this.findRowHeaderPoi(sheet, i - 1, j, false);
            List<Integer> colHeaderList = this.findColumnHeaderPoi(sheet, i, j - 1, false);
            String rowHeaderName = "";
            String colHeaderName = "";
            if (rowHeaderList.size() > 0) {
                rowHeaderName = this.getRowHeaderName(sheet, rowHeaderList, j);
            }
            if (colHeaderList.size() > 0) {
                colHeaderName = this.getColHeaderName(sheet, i, colHeaderList);
            }
            if (rowHeaderList.size() != 0 || colHeaderList.size() != 0) {
                rightCell.put("RowColHeader", colHeaderName + ";" + rowHeaderName);
                rightCellMap.put(i + ";" + j, rightCell);
            }
        }
    }

    private String getColHeaderName(Sheet sheet, int i, List<Integer> colHeaderList) {
        StringBuilder name = new StringBuilder();
        for (Integer integer : colHeaderList) {
            org.apache.poi.ss.usermodel.Cell headerCol = sheet.getRow(i).getCell(integer.intValue());
            CellType cellType = headerCol.getCellType();
            if (CellType.STRING.equals((Object)cellType)) {
                name.append(headerCol.getStringCellValue().trim());
                continue;
            }
            if (!CellType.NUMERIC.equals((Object)cellType)) continue;
            DecimalFormat decimalFormat = new DecimalFormat("#.##########");
            name.append(decimalFormat.format(headerCol.getNumericCellValue()));
        }
        return name.toString();
    }

    private String getRowHeaderName(Sheet sheet, List<Integer> rowHeaderList, int j) {
        StringBuilder name = new StringBuilder();
        for (Integer integer : rowHeaderList) {
            org.apache.poi.ss.usermodel.Cell headerRow = sheet.getRow(integer.intValue()).getCell(j);
            CellType cellType = headerRow.getCellType();
            if (CellType.STRING.equals((Object)cellType)) {
                name.append(headerRow.getStringCellValue().trim());
                continue;
            }
            if (!CellType.NUMERIC.equals((Object)cellType)) continue;
            DecimalFormat decimalFormat = new DecimalFormat("#.##########");
            name.append(decimalFormat.format(headerRow.getNumericCellValue()));
        }
        return name.toString();
    }

    private List<Integer> findRowHeaderPoi(Sheet sheet, int r, int c, boolean isExhaustion) {
        LinkedList<Integer> resList = new LinkedList<Integer>();
        while (r >= 0) {
            Row row = sheet.getRow(r);
            if (row != null) {
                org.apache.poi.ss.usermodel.Cell cell = row.getCell(c);
                if (cell != null) {
                    CellType cellType = cell.getCellType();
                    Object newValue = null;
                    if (CellType.STRING.equals((Object)cellType)) {
                        newValue = cell.getStringCellValue();
                    } else if (CellType.NUMERIC.equals((Object)cellType)) {
                        newValue = cell.getNumericCellValue();
                    }
                    if (this.isrightCellJson(newValue)) {
                        resList.add(r);
                        if (!isExhaustion) {
                            return resList;
                        }
                    } else if (resList.size() > 0) {
                        return resList;
                    }
                }
                if (resList.size() >= 5) {
                    return resList;
                }
            }
            --r;
        }
        return resList;
    }

    private boolean isrightCellJson(Object newValue) {
        boolean isNull;
        boolean bl = isNull = newValue == null;
        if (isNull) {
            return false;
        }
        boolean isJiuqiCell = newValue.toString().startsWith("[") && newValue.toString().endsWith("]");
        boolean isNumber = this.checkIsNumber(newValue.toString());
        return !isNull && !isJiuqiCell && !isNumber;
    }

    private List<Integer> findColumnHeaderPoi(Sheet sheet, int r, int c, boolean isExhaustion) {
        LinkedList<Integer> resList = new LinkedList<Integer>();
        while (c >= 0) {
            org.apache.poi.ss.usermodel.Cell cell = sheet.getRow(r).getCell(c);
            if (cell != null) {
                CellType cellType = cell.getCellType();
                Object newValue = null;
                if (CellType.STRING.equals((Object)cellType)) {
                    newValue = cell.getStringCellValue();
                } else if (CellType.NUMERIC.equals((Object)cellType)) {
                    newValue = cell.getNumericCellValue();
                }
                if (this.isrightCellJson(newValue)) {
                    resList.add(c);
                    if (!isExhaustion) {
                        return resList;
                    }
                } else if (resList.size() > 0) {
                    return resList;
                }
            }
            --c;
            if (resList.size() < 5) continue;
            return resList;
        }
        return resList;
    }

    private boolean checkNotStandardContentPoi(org.apache.poi.ss.usermodel.Cell cell) {
        boolean isJiuQiNumber;
        boolean isNull;
        boolean bl = isNull = cell == null || CellType.BLANK.equals((Object)cell.getCellType());
        if (isNull) {
            return true;
        }
        boolean bl2 = isJiuQiNumber = CellType.STRING.equals((Object)cell.getCellType()) && cell.getStringCellValue().startsWith("[") && cell.getStringCellValue().endsWith("]");
        if (isJiuQiNumber) {
            return true;
        }
        return CellType.NUMERIC.equals((Object)cell.getCellType()) && this.checkIsNumber(cell.getNumericCellValue() + "");
    }

    private boolean checkNotStandardContent(Object value) {
        boolean isJiuQiNumber;
        boolean isNull;
        boolean bl = isNull = value == null;
        if (isNull) {
            return true;
        }
        boolean bl2 = isJiuQiNumber = value.toString().startsWith("[") && value.toString().endsWith("]");
        if (isJiuQiNumber) {
            return true;
        }
        String input = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : value.toString();
        return this.checkIsNumber(input);
    }

    private void buildSpreadJsonJqXlsx(String sheetName, List<String> urls) {
        Boolean notFindSheetByName = Boolean.TRUE;
        for (String url : urls) {
            String stringJson = SpreadUtils.getExcelJson((String)sheetName, (String)url);
            if (Objects.equals(stringJson, "")) continue;
            JSONObject excelJson = JSONObject.parseObject((String)stringJson);
            this.buildSpread();
            this.setSheetValue(excelJson, sheetName);
            byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)stringJson));
            String bbs = new String(bb);
            stringJson = "base64" + bbs;
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), JQREPORT, stringJson);
            notFindSheetByName = Boolean.FALSE;
            break;
        }
        if (notFindSheetByName.booleanValue()) {
            CommandParam com = new CommandParam("bcm_iscellmappingspread", "bcm_iscellmapping", "hideBtn", new Object[0]);
            this.sendMsg(this.getView(), com);
            return;
        }
        this.getPageCache().put(JQSHEETNAME, sheetName);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), JQREPORT);
        this.setToolbarLock();
        this.setItemHide();
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), JQREPORT, Collections.singletonList(this.getSpreadModel().getBook().getSheet(0).getSheetName()));
        this.cacheSpreadModel(this.spread);
    }

    private void setSheetValue(JSONObject excelJson, String sheetName) {
        Object sheetsObj = excelJson.get((Object)"sheets");
        if (sheetsObj == null) {
            return;
        }
        JSONObject sheets = (JSONObject)sheetsObj;
        Object sheetObj = sheets.get((Object)sheetName);
        if (sheetObj != null) {
            JSONObject sheet = (JSONObject)sheetObj;
            Object dataObj = sheet.get((Object)"data");
            if (dataObj == null) {
                return;
            }
            JSONObject data = (JSONObject)dataObj;
            Object dataTableObj = data.get((Object)"dataTable");
            if (dataTableObj == null) {
                return;
            }
            JSONObject dataTable = (JSONObject)dataTableObj;
            LinkedHashMap<String, Map<String, Object>> rightCellMap = new LinkedHashMap<String, Map<String, Object>>();
            for (int i = 0; i < sheet.getInteger("rowCount"); ++i) {
                Object rowDateObj = dataTable.get((Object)i);
                if (rowDateObj == null) continue;
                JSONObject rowDate = (JSONObject)rowDateObj;
                for (int j = 0; j < sheet.getInteger("columnCount"); ++j) {
                    Object rowColDateObj = rowDate.get((Object)j);
                    if (rowColDateObj == null) continue;
                    JSONObject newValue = (JSONObject)rowColDateObj;
                    kd.fi.bcm.spread.domain.view.Sheet rightSheet = this.spread.getBook().getSheet(0);
                    rightSheet.getCell(i, j).setValue(newValue.get((Object)"value"));
                    this.prepareRightCellMapJson(rightCellMap, newValue, rightSheet, i, j);
                }
            }
            this.getPageCache().put("rightCellList", SerializationUtils.toJsonString(rightCellMap));
        }
    }

    private void prepareRightCellMapJson(Map<String, Map<String, Object>> rightCellMap, JSONObject newValue, kd.fi.bcm.spread.domain.view.Sheet rightSheet, int i, int j) {
        if (this.checkNotStandardContent(newValue.get((Object)"value"))) {
            HashMap<String, String> rightCell = new HashMap<String, String>(4);
            List<Integer> rowHeaderList = this.findRowHeaderList(rightSheet, i - 1, j, false);
            List<Integer> colHeaderList = this.findColumnHeaderList(rightSheet, i, j - 1, false);
            if (rowHeaderList.size() == 0 && colHeaderList.size() == 0) {
                return;
            }
            String rowHeaderName = "";
            if (rowHeaderList.size() > 0) {
                rowHeaderName = this.findRowHeaderName(rightSheet, rowHeaderList, j);
            }
            String colHeaderName = "";
            if (colHeaderList.size() > 0) {
                colHeaderName = this.findColHeaderName(rightSheet, i, colHeaderList);
            }
            rightCell.put("RowColHeader", colHeaderName + ";" + rowHeaderName);
            rightCellMap.put(i + ";" + j, rightCell);
        }
    }

    private String findColHeaderName(kd.fi.bcm.spread.domain.view.Sheet rightSheet, int i, List<Integer> colHeaderList) {
        StringBuilder name = new StringBuilder();
        for (Integer integer : colHeaderList) {
            String colHeaderName;
            if (rightSheet.getCell(i, integer.intValue()).getValue() instanceof BigDecimal) {
                colHeaderName = ((BigDecimal)rightSheet.getCell(i, integer.intValue()).getValue()).stripTrailingZeros().toPlainString();
                name.append(colHeaderName);
                continue;
            }
            colHeaderName = rightSheet.getCell(i, integer.intValue()).getValue().toString();
            name.append(colHeaderName);
        }
        return name.toString();
    }

    private String findRowHeaderName(kd.fi.bcm.spread.domain.view.Sheet rightSheet, List<Integer> rowHeaderList, int j) {
        StringBuilder name = new StringBuilder();
        for (Integer integer : rowHeaderList) {
            String rowHeaderName;
            if (rightSheet.getCell(integer.intValue(), j).getValue() instanceof BigDecimal) {
                rowHeaderName = ((BigDecimal)rightSheet.getCell(integer.intValue(), j).getValue()).stripTrailingZeros().toString();
                name.append(rowHeaderName);
                continue;
            }
            rowHeaderName = rightSheet.getCell(integer.intValue(), j).getValue().toString();
            name.append(rowHeaderName);
        }
        return name.toString();
    }

    private List<Integer> findRowHeaderList(kd.fi.bcm.spread.domain.view.Sheet sheet, int r, int c, boolean isExhaustion) {
        LinkedList<Integer> resList = new LinkedList<Integer>();
        while (r >= 0) {
            Cell cell = sheet.getCell(r, c);
            if (this.isrightCell(cell)) {
                resList.add(r);
                if (!isExhaustion) {
                    return resList;
                }
            } else if (resList.size() > 0) {
                return resList;
            }
            --r;
            if (resList.size() < 5) continue;
            return resList;
        }
        return resList;
    }

    private boolean isrightCell(Cell cell) {
        boolean isNull;
        boolean bl = isNull = cell == null || cell.getValue() == null;
        if (isNull) {
            return false;
        }
        Object value = cell.getValue();
        boolean isJiQiCell = value.toString().startsWith("[") && value.toString().endsWith("]");
        String input = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : value.toString();
        boolean isNumber = this.checkIsNumber(input);
        return !isNull && !isJiQiCell && !isNumber;
    }

    private boolean checkIsNumber(String input) {
        String regex = "^[+-]?\\d+(\\.\\d+)?$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private List<Integer> findColumnHeaderList(kd.fi.bcm.spread.domain.view.Sheet sheet, int r, int c, boolean isExhaustion) {
        LinkedList<Integer> resList = new LinkedList<Integer>();
        while (c >= 0) {
            Cell cell = sheet.getCell(r, c);
            if (this.isrightCell(cell)) {
                resList.add(c);
                if (!isExhaustion) {
                    return resList;
                }
            } else if (resList.size() > 0) {
                return resList;
            }
            --c;
            if (resList.size() < 5) continue;
            return resList;
        }
        return resList;
    }

    private void getFeatureList(int i, int j, Map<String, Object> styleMap, List<Map<String, Object>> featureList) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), i);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), j);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), 1);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        featureList.add(features);
    }

    private void setColWidth(Map<Integer, List<Integer>> colWidthMap) {
        HashMap<String, Object> colWidthReal = null;
        for (Map.Entry<Integer, List<Integer>> map : colWidthMap.entrySet()) {
            colWidthReal = new HashMap<String, Object>();
            colWidthReal.put("index", map.getValue().toArray());
            colWidthReal.put("num", map.getKey());
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), JQREPORT, colWidthReal);
        }
    }

    private void setRowHeight(Map<Integer, List<Integer>> rowHeight) {
        HashMap<String, Object> rowHeightReal = null;
        for (Map.Entry<Integer, List<Integer>> map : rowHeight.entrySet()) {
            rowHeightReal = new HashMap<String, Object>();
            rowHeightReal.put("index", map.getValue().toArray());
            rowHeightReal.put("num", map.getKey());
            SpreadClientInvoker.invokeSetRowsHeightMethod(this.getClientViewProxy(), JQREPORT, rowHeightReal);
        }
    }

    private Object getNumericCellValue(CellBase cell) {
        short format = cell.getCellStyle().getDataFormat();
        if (format == 14 || format == 31 || format == 57 || format == 58) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            double value = cell.getNumericCellValue();
            Date date = DateUtil.getJavaDate((double)value);
            String cellValue = sdf.format(date);
            boolean iszh = "zh-CN".equals(RequestContext.get().getLang().getLangTag());
            if (format == 14) {
                return cellValue;
            }
            if (format == 31) {
                String[] split = cellValue.split("-");
                if (split.length >= 3) {
                    if (iszh) {
                        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708%3$s\u65e5", (String)"ReportListPlugin_120", (String)"fi-bcm-formplugin", (Object[])new Object[0]), split[0], split[1], split[2]);
                    }
                    return cellValue;
                }
                return cell.getNumericCellValue();
            }
            if (format == 57) {
                String[] split = cellValue.split("-");
                if (split.length >= 2) {
                    if (iszh) {
                        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"ReportListPlugin_119", (String)"fi-bcm-formplugin", (Object[])new Object[0]), split[0], split[1]);
                    }
                    return cellValue;
                }
                return cell.getNumericCellValue();
            }
            if (format == 58) {
                String[] split = cellValue.split("-");
                if (split.length >= 3) {
                    if (iszh) {
                        return String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u65e5", (String)"ReportListPlugin_118", (String)"fi-bcm-formplugin", (Object[])new Object[0]), split[1], split[2]);
                    }
                    return cellValue;
                }
                return cell.getNumericCellValue();
            }
            return cell.getNumericCellValue();
        }
        return cell.getNumericCellValue();
    }

    @Override
    public void dealMsg(CommandParam command) {
        this.blackPreLight();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), JQREPORT);
        invoker.setBatch(true);
        List<Object> param = command.getParam();
        List selRows = (List)param.get(0);
        List selCols = (List)param.get(1);
        ArrayList<Integer> newSelRows = new ArrayList<Integer>();
        ArrayList<Integer> newSelCols = new ArrayList<Integer>();
        Map dataCacheMap = (Map)param.get(2);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put("bkc", "#00ff00");
        String key = null;
        for (int i = 0; i < selRows.size(); ++i) {
            for (int j = 0; j < selCols.size(); ++j) {
                key = selRows.get(i) + KEY_SPLIT + selCols.get(j);
                if (!dataCacheMap.containsKey(key)) continue;
                List objList = (List)dataCacheMap.get(key);
                String locationStr = (String)objList.get(0);
                String[] split = locationStr.split(KEY_SPLIT);
                Integer newSelRow = Integer.valueOf(split[0]);
                newSelRows.add(newSelRow);
                Integer newSelCol = Integer.valueOf(split[1]);
                newSelCols.add(newSelCol);
                invoker.setStyle(newSelRow, newSelCol, 1, 1, styleMap);
            }
        }
        invoker.startToInvoke();
        this.getPageCache().put(JQLIGHT_ROWS, JSONObject.toJSONString(newSelRows));
        this.getPageCache().put(JQLIGHT_COLS, JSONObject.toJSONString(newSelCols));
    }

    private void getColWidth(Sheet sheet, int j, Map<Integer, List<Integer>> colWidthMap) {
        int columnWidth = sheet.getColumnWidth(j);
        Double colWidthD = (double)columnWidth / 35.0;
        colWidthMap.computeIfAbsent(colWidthD.intValue(), k -> new ArrayList()).add(j);
    }

    private void getRowHeight(Sheet sheet, int i, Map<Integer, List<Integer>> rowHeightMap) {
        Row row = sheet.getRow(i);
        if (row == null) {
            return;
        }
        short height = row.getHeight();
        Double heightReal = (double)height / 10.0 - 5.0;
        rowHeightMap.computeIfAbsent(heightReal.intValue(), list -> new ArrayList()).add(i);
    }

    private Map<String, Object> getCellStyle(CellBase cell) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        CellStyle cellStyle = cell.getCellStyle();
        HorizontalAlignment alignment = cellStyle.getAlignment();
        VerticalAlignment verticalAlignment = cellStyle.getVerticalAlignment();
        styleMap.put("ha", alignment.getCode() - 1);
        styleMap.put("va", verticalAlignment.ordinal());
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        BorderStyle borderTop = cellStyle.getBorderTop();
        BorderStyle borderRight = cellStyle.getBorderRight();
        HashMap<String, ArrayList> bl = new HashMap<String, ArrayList>();
        if (!(BorderStyle.NONE.equals((Object)borderBottom) && BorderStyle.NONE.equals((Object)borderLeft) && BorderStyle.NONE.equals((Object)borderTop) && BorderStyle.NONE.equals((Object)borderRight))) {
            bl.put("blc", Lists.newArrayList((Object[])new String[]{"black"}));
            bl.put("bls", Lists.newArrayList((Object[])new String[]{"thin"}));
            styleMap.put("bl", bl);
        }
        String backgroundColor = null;
        int fontIndex = cellStyle.getFontIndexAsInt();
        if (cell instanceof HSSFCell) {
            HSSFCellStyle hsscellStyle = ((HSSFCell)cell).getCellStyle();
            backgroundColor = hsscellStyle.getFillBackgroundColorColor().getHexString();
            if (backgroundColor == null) {
                backgroundColor = hsscellStyle.getFillForegroundColorColor() == null ? null : hsscellStyle.getFillForegroundColorColor().getHexString();
            }
            fontIndex = Math.min(Math.max(fontIndex, 10), 16);
            styleMap.put("f", fontIndex + "pt Arial");
        } else if (cell instanceof XSSFCell) {
            XSSFCellStyle xsscellStyle = ((XSSFCell)cell).getCellStyle();
            String string = backgroundColor = xsscellStyle.getFillBackgroundColorColor() == null ? null : xsscellStyle.getFillBackgroundColorColor().getARGBHex();
            if (backgroundColor == null) {
                backgroundColor = xsscellStyle.getFillForegroundColorColor() == null ? null : xsscellStyle.getFillForegroundColorColor().getARGBHex();
            }
            fontIndex = xsscellStyle.getFont().getFontHeight() / 20;
            styleMap.put("f", fontIndex + "pt " + xsscellStyle.getFont().getFontName());
        }
        if (!"0:0:0".equals(backgroundColor) && backgroundColor != null && !"FFFFFFFF".equals(backgroundColor)) {
            styleMap.put("bkc", "#BFBFBF");
        }
        return styleMap;
    }

    private JSONObject getRowColSpan(org.apache.poi.ss.usermodel.Cell cell, List<CellRangeAddress> mergedRegions) {
        JSONObject rowColSpan = null;
        for (CellRangeAddress cellRangeAddress : mergedRegions) {
            if (!cellRangeAddress.isInRange(cell)) continue;
            rowColSpan = new JSONObject();
            rowColSpan.put(ROWSPAN, (Object)(cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow() + 1));
            rowColSpan.put(COLSPAN, (Object)(cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1));
            mergedRegions.remove(cellRangeAddress);
            return rowColSpan;
        }
        return rowColSpan;
    }

    private String getInitSpreadJson() {
        return "{\"version\":\"10.0.1\",\"sheetCount\":1,\"sheets\":{\"null\":{\"name\":\"null\",\"rowCount\":\"" + this.rowNum + "\",\"columnCount\":\"" + this.colNum + "\",\"data\": {\"dataTable\": {}}}}}";
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spread == null) {
            String schema = this.getPageCache().get("KEY_SPREAD_MODEL");
            if (StringUtils.isNotEmpty((String)schema)) {
                this.spread = JsonSerializerUtil.toSpreadManager((String)schema);
            } else {
                this.buildSpread();
            }
        }
        return this.spread;
    }

    private void buildSpread() {
        this.spread = new SpreadManager(JQREPORT_SPREAD, null);
        this.cacheSpreadModel(this.spread);
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        this.getPageCache().put("KEY_SPREAD_MODEL", JsonSerializerUtil.toJson((SpreadManager)sm));
    }
}

