/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.Delete;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ExecuteOperationEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.util.BillListHyperLinkClickUtil;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.util.DynamicUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ISSchemeCollectLogPlugin
extends AbstractBaseListPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ISSchemeCollectLogPlugin.class);
    private static final String ctl_billlistap = "billlistap";
    private static final String DOWNLOAD = "download";
    private static final String SELECTID = "selectId";
    private static int i = 0;
    private static final String f7CACHEKEY = "f7Cache";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", "currency"});

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeF7 = (BasedataEdit)this.getControl("scheme");
        schemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, String> f7KeyMap = new HashMap<String, String>();
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            for (String key : dimKeys) {
                String f7id = UserSelectUtil.getF7SelectId(this.getView(), key);
                if (StringUtils.isEmpty((CharSequence)f7id)) continue;
                f7KeyMap.put(key, f7id);
            }
        }
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelid)) {
            this.getPageCache().put("KEY_MODEL_ID", modelid);
        }
        if (!this.isExitModel()) {
            return;
        }
        this.initF7FromParent();
        this.setOrgTemFilter();
        this.controlSetEnable();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key = arg0.getProperty().getName();
        String modelid = UserSelectUtil.getF7SelectId(this.getView(), "model");
        if (key.equals("scheme") && !StringUtils.isEmpty((CharSequence)modelid)) {
            QFilter filter = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong((Object)modelid));
            QFilter idPermfilter = new QFilter("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
            QFilter[] filters = new QFilter[]{filter, idPermfilter};
            String selectFields = "id, name, number,templatecatalog,versionnumber,issrc.number";
            ArrayList result = new ArrayList(10);
            DynamicObjectCollection schemeEntityNew = QueryServiceHelper.query((String)"bcm_isscheme", (String)selectFields, (QFilter[])filters);
            if (this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
                ArrayList srcExcel = new ArrayList(10);
                ArrayList schemeIds = new ArrayList(schemeEntityNew.size());
                schemeEntityNew.forEach(schemeDyn -> {
                    schemeIds.add(schemeDyn.getLong("id"));
                    if (IntegrateProductEnum.EXCELIMPORTProduct.getNumber().equals(schemeDyn.getString("issrc.number"))) {
                        srcExcel.add(schemeDyn.getLong("id"));
                    }
                });
                String scenarioNum = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
                String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
                String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                IntegrationUtil.filterSchemeByScenarioAndDate((long)this.getModelId(), (String)scenarioNum, (String)periodNum, (String)yearNum, schemeIds);
                schemeEntityNew.forEach(scheme -> {
                    if (schemeIds.contains(scheme.getLong("id"))) {
                        result.add(scheme.getLong("id"));
                    }
                });
                result.addAll(srcExcel);
                QFilter f7filter = new QFilter("id", "in", result);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{f7filter}), null));
            }
        }
        if (((BasedataEdit)arg0.getSource()).getKey().equals(this.getModelSign()) && kd.bos.util.StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            ApplicationTypeEnum.getEnumByNumber((String)"cm");
            QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
            QFilter haspermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_bizrulelist", (ApplicationTypeEnum)ApplicationTypeEnum.getEnumByNumber((String)"cm")));
            QFilter perRoleids = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ApplicationTypeEnum.getEnumByNumber((String)"cm"), (String)"bcm_bizrulelist", (String)"47150e89000000ac"));
            qFilterList.add(superid.or(haspermid).or(perRoleids));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public boolean isExitModel() {
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        return !StringUtils.isEmpty((CharSequence)modelid);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        e.setCancel(true);
        Object id = BillListHyperLinkClickUtil.getObjectPkIdFromEvt(e);
        if (this.checkLogTooLong(id)) {
            this.getPageCache().put(SELECTID, String.valueOf(id));
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u91c7\u96c6\u65e5\u5fd7\u4e2d\u5b57\u7b26\u4fe1\u606f\u8f83\u591a\uff0c\u8bf7\u4e0b\u8f7d\u5230\u672c\u5730\u67e5\u770b\u3002", (String)"ISSchemeCollectLogPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DOWNLOAD, (IFormPlugin)this));
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_collectlogeerrorinfo");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setParentFormId(this.getView().getPageId());
            parameter.setCustomParam("id", id);
            this.getView().showForm(parameter);
        }
    }

    private boolean checkLogTooLong(Object id) {
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isschemecollectlog");
        int size = dot.getString("error").length();
        return size > 5000;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (DOWNLOAD.equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.actionDownLoad();
        }
    }

    private void actionDownLoad() {
        Long id = Long.parseLong(this.getPageCache().get(SELECTID));
        DynamicObject dot = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bcm_isschemecollectlog");
        String fileName = dot.getString("scheme.number") + "_" + ((DynamicObject)this.getModel().getValue("scenario")).getString("number") + "_" + dot.getString("org.number") + "_" + dot.getString("fy.number") + "_" + dot.getString("period.number") + "_" + TimeServiceHelper.formatToday() + ".txt";
        String log = dot.getString("error");
        File file = new File(FilenameUtils.getName((String)fileName));
        try (FileWriter fWriter = new FileWriter(file);){
            fWriter.write(log);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        this.downLoadFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downLoadFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = cache.saveAsUrl(file.getName(), (InputStream)inputStream, 5000);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getClientViewProxy().addAction(DOWNLOAD, (Object)url);
            }
        }
        catch (Exception e) {
            log.error("ISSchemeCollectLogPlugin-downLoadFile: " + e.getMessage());
        }
        finally {
            try {
                if (file.exists()) {
                    FileUtils.forceDelete((File)file);
                }
            }
            catch (IOException e) {
                log.error("ISSchemeCollectLogPlugin-deleteFile: " + file.getAbsolutePath() + ", " + e.getMessage());
            }
        }
    }

    private void initF7FromParent() {
        DynamicObjectCollection query;
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")))) {
            return;
        }
        long modelId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        Object yearId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.YEAR.getNumber());
        Object periodId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.PERIOD.getNumber());
        Object sceneId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.SCENARIO.getNumber());
        Object currencyId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.CURRENCY.getNumber());
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", sceneId);
        this.getModel().setValue("year", yearId);
        this.getModel().setValue("period", periodId);
        this.getModel().setValue("currency", currencyId);
        Object exeIdObj = this.getView().getFormShowParameter().getCustomParams().get("exeId");
        if (exeIdObj != null && (query = QueryServiceHelper.query((String)"bcm_isschemecollectlog", (String)"id,scheme.id", (QFilter[])new QFilter[]{new QFilter("executerec", "=", (Object)Long.valueOf(exeIdObj.toString()))}, (String)"collecttime desc", (int)1)).size() > 0) {
            this.getModel().setValue("scheme", (Object)((DynamicObject)query.get(0)).getLong("scheme.id"));
        }
    }

    private void setOrgTemFilter() {
        Map tmap = this.getView().getFormShowParameter().getCustomParams();
        QFilter filter = null;
        if (!ObjectUtils.isEmpty(tmap.get("orgNumbers")) && !ObjectUtils.isEmpty(tmap.get("temNumbers"))) {
            JSONArray json = (JSONArray)tmap.get("orgNumbers");
            if (json.size() > 0) {
                filter = new QFilter("org.number", "in", (Object)json.toArray());
            }
            if ((json = (JSONArray)tmap.get("temNumbers")).size() > 0) {
                if (filter != null) {
                    filter.and(new QFilter("scheme.number", "in", (Object)json.toArray()));
                } else {
                    filter = new QFilter("scheme.number", "in", (Object)json.toArray());
                }
            }
        }
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        if (filter != null) {
            billList.setFilter(filter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Map f7KeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(f7CACHEKEY), Map.class);
        if ("model".equals(key)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null && e.getChangeSet()[0].getOldValue() != null) {
                this.getModel().setValue("scheme", null);
            }
            this.modelChange(f7KeyMap);
        } else if ("scenario".equals(key)) {
            this.getModel().setValue("period", null);
        }
        this.refreshBillList();
    }

    private void modelChange(Map<String, Object> f7KeyMap) {
        this.propertyChangedModelUse(dimKeys);
        f7KeyMap.clear();
        this.refreshCurrency();
    }

    private void refreshCurrency() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            return;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter currencyFilter = new QFilter("number", "=", (Object)CurrencyEnum.EC.getNumber());
        DynamicObject currencyDy = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, currencyFilter});
        if (currencyDy != null) {
            this.getModel().setValue("currency", (Object)currencyDy.getLong("id"));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_membermap": {
                this.actionMemberMapping();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_export": {
                this.actionExport();
                break;
            }
            case "btn_view": {
                if (i != 0) break;
                Map<String, ArrayList<Object>> map = null;
                try {
                    map = this.getlogMessageMap();
                    Iterator<Map.Entry<String, ArrayList<Object>>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        ArrayList<Object> value = iterator.next().getValue();
                        String orgName = (String)value.get(0);
                        String number = (String)value.get(1);
                        String schemeNumber = (String)value.get(2);
                        String schemeName = (String)value.get(3);
                        OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u91c7\u96c6\u65e5\u5fd7", (String)"ISSchemeCollectLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s,\u91c7\u96c6\u65e5\u5fd7\u6210\u529f\u3002", (String)"ISSchemeCollectLogPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName, number, schemeNumber, schemeName), (Long)this.getModelId());
                        ++i;
                    }
                    break;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (e.getSource() instanceof Delete && isSuccess) {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "RptAdjustdListPlugin_53", "fi-bcm-formplugin", "Delete"), new OPDescMultiLangEnumBridge("\u5220\u9664\u6210\u529f", "RptAdjustdListPlugin_54", "fi-bcm-formplugin", null));
        }
    }

    private void actionMemberMapping() {
        if (this.getModel().getValue("year") == null || this.getModel().getValue("period") == null) {
            this.getView().showMessage(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u671f\u95f4\u3002", (String)"ISSchemeCollectLogPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)"ISSchemeCollectLogPlugin_3"));
            return;
        }
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        if (selectRows == null || selectRows.size() == 0) {
            this.getView().showMessage(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ISSchemeCollectLogPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)"ISSchemeCollectLogPlugin_4"));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        selectRows.forEach(row -> ids.add((Long)row.getPrimaryKeyValue()));
        List<Map<String, String>> reportList = this.getReportList(ids);
        this.doShowReport(reportList);
    }

    private List<Map<String, String>> getReportList(List<Long> ids) {
        HashSet<Map<String, String>> reportSet = new HashSet<Map<String, String>>();
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection logDyn = QueryServiceHelper.query((String)"bcm_isschemecollectlog", (String)"error", (QFilter[])filter.toArray());
        for (DynamicObject dc : logDyn) {
            if (!dc.getString("error").contains(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u6620\u5c04\u6210\u5458\uff1areportList:", (String)"ISSchemeCollectLogPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) continue;
            int startInx = dc.getString("error").indexOf("[");
            String str = dc.getString("error").substring(startInx);
            List report = (List)JSONArray.parse((String)str);
            reportSet.addAll(report);
        }
        this.filterExistMap(reportSet);
        return Lists.newArrayList(reportSet);
    }

    private void filterExistMap(Set<Map<String, String>> reportSet) {
        HashSet<String> dimnumber = new HashSet<String>(16);
        HashSet<String> easname = new HashSet<String>(16);
        HashSet<String> tempnumbers = new HashSet<String>(16);
        for (Map<String, String> map : reportSet) {
            dimnumber.add(map.get("dimnumer"));
            easname.add(map.get("easname"));
            tempnumbers.add(map.get("tempnumber"));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.getModelId());
        qfBuilder.add("dimensionnumber", "in", dimnumber);
        qfBuilder.add("easname", "in", easname);
        qfBuilder.add("tmpnumber", "in", tempnumbers);
        DynamicObjectCollection col1 = QueryServiceHelper.query((String)"bcm_easmembermap", (String)"easname,dimensionnumber,membernumber,tmpnumber,parentnumber", (QFilter[])qfBuilder.toArray());
        this.checkMemberIsExist(col1);
        HashSet<String> currentKey = new HashSet<String>(16);
        Map<String, Map<String, String>> parentMap = this.getParentMap(tempnumbers);
        Iterator<Map<String, String>> iterator = reportSet.iterator();
        while (iterator.hasNext()) {
            String key;
            boolean exist;
            Map<String, String> m = iterator.next();
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(m.get("dimnumer")) || DimTypesEnum.MYCOMPANY.getNumber().equals(m.get("dimnumer"))) {
                exist = col1.stream().anyMatch(dyn -> dyn.getString("easname").equals(m.get("easname")) && dyn.getString("dimensionnumber").equals(m.get("dimnumer")));
                key = m.get("easname").concat(m.get("dimnumer"));
            } else {
                if (parentMap.get(m.get("tempnumber") + m.get("floatarea")) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u5fd7\u4e2d\u6a21\u677f%1$s\u5305\u542b\u4e0d\u5339\u914d\u7684\u6d6e\u52a8\u533a\u57df%2$s\uff0c\u5efa\u8bae\u91cd\u65b0\u91c7\u96c6\u3002", (String)"ISSchemeCollectLogPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), m.get("tempnumber"), m.get("floatarea")));
                }
                String parentnumber = parentMap.get(m.get("tempnumber") + m.get("floatarea")).get(m.get("dimnumer"));
                exist = col1.stream().anyMatch(dyn -> dyn.getString("easname").equals(m.get("easname")) && dyn.getString("dimensionnumber").equals(m.get("dimnumer")) && dyn.getString("tmpnumber").equals(m.get("tempnumber")) && (StringUtil.isEmptyString((String)dyn.getString("parentnumber")) || !StringUtil.isEmptyString((String)parentnumber) && dyn.getString("parentnumber").equals(parentnumber)));
                key = m.get("easname").concat(m.get("dimnumer")).concat(m.get("tempnumber")).concat(parentnumber);
            }
            if (exist || currentKey.contains(key)) {
                iterator.remove();
            }
            currentKey.add(key);
        }
    }

    private void checkMemberIsExist(DynamicObjectCollection col1) {
        HashMap members = new HashMap(16);
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model", (String)"number");
        col1.forEach(c -> {
            if (!MemberReader.isExistMember((String)model.getString("number"), (String)c.getString("dimensionnumber"), (String)c.getString("membernumber"))) {
                members.putIfAbsent(c.getString("dimensionnumber"), new HashSet(16));
                ((Set)members.get(c.getString("dimensionnumber"))).add(c.getString("membernumber"));
            }
        });
        if (members.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u4e2d\u4e0b\u5217\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u5bf9\u5e94\u6210\u5458\u6620\u5c04\u91cd\u65b0\u91c7\u96c6\uff1a%s\u3002", (String)"ISSchemeCollectLogPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), JSON.toJSONString(members)), Integer.valueOf(30000));
        }
    }

    private Map<String, Map<String, String>> getParentMap(Set<String> tempnumbers) {
        HashMap<String, Map<String, String>> parentMap = new HashMap<String, Map<String, String>>();
        Long modelId = this.getModelId();
        Long yearId = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
        Long periodId = ((DynamicObject)this.getModel().getValue("period")).getLong("id");
        QFBuilder qfb = new QFBuilder("model", "=", (Object)modelId);
        qfb.add("number", "in", tempnumbers);
        Collection dyncol = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id,number,versionnumber", (QFilter[])qfb.toArray()).values();
        HashSet ids = new HashSet();
        dyncol.forEach(dyn -> ids.add(dyn.getLong("id")));
        Collection tmplids = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, ids).values();
        ArrayList models = new ArrayList();
        tmplids.forEach(e -> models.add(TemplateServiceHelper.getTemplateModelById((Object)e)));
        for (TemplateModel model : models) {
            String tmplNumber = model.getNumber();
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)model.getRptData());
            if (!DynamicUtils.isDynamicReport((SpreadManager)spread)) continue;
            boolean isDirectHoriz = DynamicUtils.isDirectHoriz((SpreadManager)spread);
            for (PositionInfo p : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), isDirectHoriz)) {
                if (!p.isFloatPosition()) continue;
                for (BasePointInfo basePoint : FloatLogicImpl.sortBasePoint(p.getBasePoints())) {
                    String dynaRange = basePoint.getDynaRange();
                    HashMap<String, String> dimMap = new HashMap<String, String>();
                    for (BasePointInnerLineInfo line : basePoint.getBasePointInnerLineInfo()) {
                        if (!line.isFloated()) continue;
                        dimMap.put(line.getDimension().getNumber(), line.getMemberAddOf() == null ? "" : line.getMemberAddOf().getNumber());
                    }
                    parentMap.put(tmplNumber + dynaRange, dimMap);
                }
            }
        }
        return parentMap;
    }

    private void doShowReport(List<Map<String, String>> reportList) {
        if (CollectionUtils.isEmpty(reportList)) {
            this.getView().showMessage(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u884c\u4e0d\u5b58\u5728\u672a\u6620\u5c04\u6210\u5458\u3002", (String)"ISSchemeCollectLogPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)"ISSchemeCollectLogPlugin_6"));
            return;
        }
        IFormView mainPageView = this.getView().getMainView();
        IFormView appPageView = this.getView().getParentView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_easmapsetting");
        parameter.setCustomParam("easmsg", reportList);
        parameter.setCustomParam("year", (Object)((DynamicObject)this.getModel().getValue("year")).getLong("id"));
        parameter.setCustomParam("period", (Object)((DynamicObject)this.getModel().getValue("period")).getLong("id"));
        parameter.setCustomParam("modelid", (Object)((DynamicObject)this.getModel().getValue("model")).getString("id"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.EDIT);
        String pageId = "easmapsetting" + mainPageView.getPageId();
        parameter.setPageId(pageId);
        appPageView.showForm(parameter);
        this.getView().sendFormAction(appPageView);
    }

    private boolean checkParams(boolean showMsg) {
        Object model = this.getModel().getValue("model");
        Object scene = this.getModel().getValue("scenario");
        Object year = this.getModel().getValue("year");
        Object period = this.getModel().getValue("period");
        Object currency = this.getModel().getValue("currency");
        if (model == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f53\u7cfb", (String)"ISSchemeCollectLogPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (scene == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u60c5\u666f", (String)"ISSchemeCollectLogPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (year == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d22\u5e74", (String)"ISSchemeCollectLogPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (period == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u671f\u95f4", (String)"ISSchemeCollectLogPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return currency != null;
    }

    private Map<String, ArrayList<Object>> getlogMessageMap() {
        ArrayList<Object> selectIdList = new ArrayList<Object>(10);
        BillList billlistap = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection cos = billlistap.getSelectedRows();
        for (ListSelectedRow listSelectedRow : cos) {
            selectIdList.add(listSelectedRow.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectIdList.toArray(), (DynamicObjectType)billlistap.getEntityType());
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>(16);
        for (DynamicObject dynamicObject : load) {
            ArrayList<String> list = new ArrayList<String>(10);
            list.add(dynamicObject.getString("org.number"));
            list.add(dynamicObject.getString("org.name"));
            list.add(dynamicObject.getString("scheme.number"));
            list.add(dynamicObject.getString("scheme.name"));
            map.put(dynamicObject.getPkValue().toString(), list);
        }
        return map;
    }

    private void refreshBillList() {
        this.getView().getFormShowParameter().getCustomParams().remove("exeId");
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        billList.clearSelection();
        billList.setOrderBy("collecttime desc");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        DynamicObjectCollection query;
        super.setFilter(e);
        List filterList = e.getQFilters();
        Object exeIdObj = this.getView().getFormShowParameter().getCustomParams().get("exeId");
        if (exeIdObj != null && this.getPageCache().get("exeId") == null && (query = QueryServiceHelper.query((String)"bcm_isschemecollectlog", (String)"id", (QFilter[])new QFilter[]{new QFilter("executerec", "=", (Object)Long.valueOf(exeIdObj.toString()))}, (String)"collecttime desc", (int)1)).size() > 0) {
            filterList.clear();
            filterList.add(new QFilter("id", "=", (Object)((DynamicObject)query.get(0)).getLong("id")));
            this.getPageCache().put("exeId", "");
            return;
        }
        QFilter dimFilter = this.getDimsQilter();
        filterList.add(dimFilter);
        Long modelId = this.getModelId();
        if (modelId != null && modelId != 0L) {
            filterList.add(new QFilter("model", "=", (Object)modelId));
            QFilter orgMeberFilter = this.getNoPermMemberFilter(modelId);
            if (orgMeberFilter != null) {
                filterList.add(orgMeberFilter);
            }
        }
        if (!this.checkParams(false)) {
            filterList.add(new QFilter("1", "=", (Object)0));
        }
    }

    private QFilter getDimsQilter() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        String currencyId = UserSelectUtil.getF7SelectId(this.getView(), "currency");
        String schemeId = UserSelectUtil.getF7SelectId(this.getView(), "scheme");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            filter.and(new QFilter("1", "=", (Object)0));
            return filter;
        }
        filter.and(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
        if (!StringUtils.isEmpty((CharSequence)schemeId)) {
            filter.and(new QFilter("scheme", "=", (Object)LongUtil.toLong((Object)schemeId)));
        }
        if (!StringUtils.isEmpty((CharSequence)scenarioId)) {
            ArrayList<Long> scenarioIds = new ArrayList<Long>(2);
            scenarioIds.add(LongUtil.toLong((Object)scenarioId));
            scenarioIds.add(0L);
            filter.and(new QFilter("scenario", "in", scenarioIds));
        }
        if (!StringUtils.isEmpty((CharSequence)yearId)) {
            filter.and(new QFilter("fy", "=", (Object)LongUtil.toLong((Object)yearId)));
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            filter.and(new QFilter("period", "=", (Object)LongUtil.toLong((Object)periodId)));
        }
        if (!StringUtils.isEmpty((CharSequence)currencyId)) {
            filter.and(new QFilter("currency", "=", (Object)LongUtil.toLong((Object)currencyId)));
        }
        filter.and("scheme", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
        return filter;
    }

    private QFilter getNoPermMemberFilter(Long modelId) {
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        QFilter filter = null;
        if (!modelIds.contains(modelId)) {
            Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
            filter = PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(dimId, "bcm_entitymembertree", "org");
        }
        return filter;
    }

    private void controlSetEnable() {
        if (!ConfigServiceHelper.isHwApp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"batch", "step", "checkstate"});
        }
    }

    private void actionExport() {
        if (!this.checkParams(true)) {
            return;
        }
        String url = this.handleExportData();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            this.downloadFile(url, "bcm_isschemecollectlist2", "1GBESTJ=TNJ0");
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "RptAdjustdListPlugin_21", "fi-bcm-formplugin", "Export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "RptAdjustdListPlugin_22", "fi-bcm-formplugin", null));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleExportData() {
        boolean isHwApp = ConfigServiceHelper.isHwApp();
        String selectFields = this.getSelectProperties(isHwApp);
        QFilter qFilter = this.getDimsQilter();
        DynamicObjectCollection toExportData = QueryServiceHelper.query((String)"bcm_isschemecollectlog", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (toExportData == null) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ISSchemeCollectLogPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (toExportData.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ISSchemeCollectLogPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.handToExportData(toExportData);
        try (SXSSFWorkbook workBook = new SXSSFWorkbook(100);){
            CellStyle style = workBook.createCellStyle();
            DataFormat dataFormat = workBook.createDataFormat();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setDataFormat(dataFormat.getFormat("@"));
            CellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            SXSSFSheet sheet = workBook.createSheet();
            List<String> headerList = this.getColNames(isHwApp);
            int rowNum = 0;
            SXSSFRow headerRow1 = sheet.createRow(rowNum);
            for (int i = 0; i < headerList.size(); ++i) {
                SXSSFCell cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue(headerList.get(i));
                cell.setCellStyle(headerStyle);
            }
            ++rowNum;
            String[] split = selectFields.split(",");
            headerList.clear();
            Collections.addAll(headerList, split);
            Collections.sort(toExportData, (p1, p2) -> p2.getDate("collecttime").compareTo(p1.getDate("collecttime")));
            Object string = toExportData.iterator();
            while (true) {
                SXSSFRow xssfRow;
                ArrayList row;
                if (string.hasNext()) {
                    DynamicObject rowData = (DynamicObject)string.next();
                    row = Lists.newArrayListWithExpectedSize((int)headerList.size());
                    for (int i = 0; i < headerList.size(); ++i) {
                        row.add(rowData.get(headerList.get(i)));
                    }
                    xssfRow = sheet.createRow(rowNum);
                } else {
                    string = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u91c7\u96c6\u65e5\u5fd7", (String)"ISSchemeCollectLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return string;
                }
                for (int j = 0; j < row.size(); ++j) {
                    SXSSFCell cell = xssfRow.createCell(j);
                    Object obj = row.get(j);
                    if (obj != null && !StringUtils.isEmpty((CharSequence)obj.toString())) {
                        CheckStatusEnum anEnum;
                        if ("checkstate".equals(headerList.get(j))) {
                            anEnum = CheckStatusEnum.getEnum((Integer)Integer.valueOf(obj.toString()));
                            if (anEnum != null) {
                                obj = anEnum.getName();
                            }
                        } else if ("collectorstate".equals(headerList.get(j))) {
                            CollectStatusEnum collectStatusEnum = CollectStatusEnum.getEnum((Integer)Integer.valueOf(obj.toString()));
                            if (collectStatusEnum != null) {
                                obj = collectStatusEnum.getName();
                            }
                        } else if ("step".equals(headerList.get(j))) {
                            anEnum = ExecuteOperationEnum.getEnum((String)obj.toString());
                            if (anEnum != null) {
                                obj = anEnum.getName();
                            }
                        } else if ("scheme.versionnumber".equals(headerList.get(j))) {
                            obj = "V" + obj;
                        }
                        cell.setCellValue(obj.toString() != null && obj.toString().length() > 500 ? obj.toString().substring(0, 500) : obj.toString());
                    }
                    cell.setCellStyle(style);
                }
                ++rowNum;
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void handToExportData(DynamicObjectCollection toExportData) {
        for (DynamicObject dynamicObject : toExportData) {
            Object schemeName = dynamicObject.get("scheme.name");
            if (schemeName != null) continue;
            dynamicObject.set("scheme.name", dynamicObject.get("preschemename"));
            dynamicObject.set("preschemename", null);
            dynamicObject.set("scheme.versionnumber", dynamicObject.get("preschemeversion"));
            dynamicObject.set("preschemeversion", null);
        }
    }

    private String getSelectProperties(boolean isHwApp) {
        if (isHwApp) {
            return "org.number,org.name,step,collectorstate,error,spend,collector.name,collecttime,batch,scheme.name,scheme.versionnumber,clearconfig,preschemename,preschemeversion";
        }
        return "org.number,org.name,step,collectorstate,error,spend,collector.name,collecttime,scheme.name,scheme.versionnumber,clearconfig,preschemename,preschemeversion";
    }

    private List<String> getColNames(boolean isHwApp) {
        ArrayList<String> colNames = new ArrayList<String>(10);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        List listFields = billList.getShowListColumns();
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("checkstate");
        ignoreSet.add("clearconfig");
        ignoreSet.add("impmodedimmem");
        ignoreSet.add("preschemenumber");
        ignoreSet.add("preschemename");
        ignoreSet.add("preschemeversion");
        for (IListColumn listField : listFields) {
            if (!isHwApp && listField.getListFieldKey().equals("batch") || ignoreSet.contains(listField.getListFieldKey())) continue;
            colNames.add(listField.getCaption().getLocaleValue());
        }
        return colNames;
    }

    public void packageData(PackageDataEvent e) {
        String key = ((ColumnDesc)e.getSource()).getKey();
        if ("scheme.name".equals(key)) {
            this.setSchemeAttr(e, "preschemename");
        } else if ("scheme.versionnumber".equals(key)) {
            this.setSchemeAttr(e, "preschemeversion");
        } else if ("error".equals(key)) {
            Object formatValue = e.getFormatValue();
            String error = formatValue == null ? " " : formatValue.toString();
            e.setFormatValue((Object)(error.length() > 20 ? error.substring(0, 19) + "..." : error));
        }
    }

    private void setSchemeAttr(PackageDataEvent e, String type) {
        if (e.getFormatValue() != null) {
            return;
        }
        e.setFormatValue((Object)e.getRowData().getString(type));
    }
}

