/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.scheme.handle.AttachmentHandle;

public class ISSchemeCopyPlugin2
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        if ("btn_ok".equals(itemKey)) {
            if (this.validate()) {
                IDataModel model = this.getModel();
                FormShowParameter formShowParameter = view.getFormShowParameter();
                Long schemeId = (Long)formShowParameter.getCustomParam("scheme");
                try {
                    Long newSchmeId = IntegrationUtil.copy((Object)schemeId, (Object)model.getValue("number"), (Object)model.getValue("name"));
                    AttachmentHandle.copyFile2New(schemeId, newSchmeId, (String)model.getValue("number"));
                    view.returnDataToParent((Object)schemeId);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u9519\u8bef\uff1a%s\u3002", (String)"ISSchemeCopyPlugin2_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)));
                }
                view.close();
            }
        } else {
            view.close();
        }
    }

    private boolean validate() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String number = dataEntity.getString("number");
        String name = dataEntity.getString("name");
        if (StringUtils.isEmpty((CharSequence)number)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ISSchemeCopyPlugin2_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.doNumberCheck().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeCopyPlugin2_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u540d\u79f0\u201d\u3002", (String)"ISSchemeCopyPlugin2_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long modelId = (Long)formShowParameter.getCustomParam("modelId");
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number", (QFilter[])qf.toArray());
        if (schemes.stream().anyMatch(scheme -> number.equalsIgnoreCase(scheme.getString("number")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ISSchemeEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        return true;
    }

    private Boolean doNumberCheck() {
        String newNumber = (String)this.getModel().getValue("number");
        String regEx = "^\\w+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(newNumber);
        if (!matcher.matches()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

