/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.business.util.MessageServiceUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.HWModelTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.NoticeStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SearchResult;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.eventcenter.BaseDataImportHelper;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.intergration.util.ISSchemeDataCollectHelper;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class ISSchemeDataCollectPlugin2
extends AbstractBaseListPlugin
implements CountDownListener,
HyperLinkClickListener {
    private static final String ctl_entryentity = "entryentity";
    private static final String entry_scheme = "schemename";
    private static final String entry_org = "org";
    private static final String entry_collectstatus = "collectstatus";
    private static final String entry_step = "step";
    private static final String entry_batch = "batch";
    private static final String entry_checkstatus = "checkstatus";
    private static final String entry_modifier = "modifier";
    private static final String entry_modifydate = "modifydate";
    private static final String entry_optime = "optimestr";
    private static final String entry_enddate = "enddate";
    private static final String entry_exeip = "exeip";
    private static final String entry_exeid = "exeid";
    private static final String IS_SYNBASE = "is_synbase";
    private static final List<String> f7KEYS = Arrays.asList("model", "scenario", "year", "period", "currency");
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period", "currency");
    private static final String treeview_scheme = "treeview_scheme";
    private static final String treeview_entity = "treeview_entity";
    private static final String ROOT_NODE = "rootNode";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String CACHE_ORG_ID = "cache_org_id";
    private static final String CACHE_SCHEME_ID = "cache_scheme_id";
    private static final String ROOT_NODE_ID = "rootNodeid";
    private static final String CACHE_SHOW_ORG_TYPE = "showorgtype";
    private static final String CACHE_SHOW_SCHEDULE_TYPE = "showscheduletype";
    private static final String cache_scheme_ids = "cache_scheme_ids";
    private static final String ALL = "*";
    private static final String EASREP = "EASREP";
    private static final String SELECT_ORG = "selectorg";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ISSchemeDataCollectPlugin2.class);
    private static final String f7CACHEKEY = "f7Cache";
    private static final String[] arr = new String[]{"Entity", "Scenario", "Year", "Period", "AuditTrail", "Process"};

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public boolean isSingleF7() {
        return true;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("imageup", "imagedown", "schemeimageup", "schemeimagedown");
        Search schemesearchap = this.getCurrencySearch();
        schemesearchap.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    ISSchemeDataCollectPlugin2.this.searchTemplate(text.trim());
                } else {
                    ISSchemeDataCollectPlugin2.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        TreeView tree = this.getCurrentTree();
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ISSchemeDataCollectPlugin2.this.refreshEntryEntity();
                IPageCache pageCache = ISSchemeDataCollectPlugin2.this.getPageCache();
                if (ISSchemeDataCollectPlugin2.this.isEntityTab()) {
                    pageCache.put(ISSchemeDataCollectPlugin2.CACHE_ORG_ID, String.valueOf(evt.getNodeId()));
                    UserSelectServiceHelper.setEntity((Long)ISSchemeDataCollectPlugin2.this.getUserId(), (Long)ISSchemeDataCollectPlugin2.this.getModelId(), (Object)String.valueOf(evt.getNodeId()));
                    ISSchemeDataCollectPlugin2.this.cacheSchemeIds(pageCache);
                } else {
                    pageCache.put(ISSchemeDataCollectPlugin2.CACHE_SCHEME_ID, String.valueOf(evt.getNodeId()));
                }
            }
        });
        Tab subTab = (Tab)this.getControl("tabap");
        subTab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent arg0) {
                DynamicObject modelDyn = (DynamicObject)ISSchemeDataCollectPlugin2.this.getModel().getValue("model");
                if (modelDyn == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                ISSchemeDataCollectPlugin2.this.refreshLeftTree(modelDyn.getLong("id"));
                ISSchemeDataCollectPlugin2.this.refreshEntryEntity();
            }
        });
        EntryGrid billList = (EntryGrid)this.getView().getControl(ctl_entryentity);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        ((BasedataEdit)this.getControl("cslscheme")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.addCountDownListener((CountDownListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("cslscheme")) {
            QFilter filter;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilterList = showParameter.getListFilterParameter().getQFilters();
            if (qFilterList == null) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)10);
            }
            if (qFilterList.size() > 1 && (filter = (QFilter)qFilterList.get(1)).getProperty().equals("id")) {
                filter.or(new QFilter("id", "in", (Object)this.getRateCslScheme()));
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private Long getRateCslScheme() {
        QFilter rate = new QFilter("number", "=", (Object)"DefaultRateScheme");
        QFilter model = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObject rateCslScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{rate, model});
        if (rateCslScheme != null) {
            return rateCslScheme.getLong("id");
        }
        return 0L;
    }

    @Override
    protected void setCslValueOfByScene(String key) {
        String formId = this.getView().getFormShowParameter().getFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection properties = entityType.getProperties();
        List propertyScene = properties.stream().filter(x -> x instanceof BasedataProp && "bcm_scenemembertree".equals(((BasedataProp)x).getBaseEntityId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(propertyScene) || !key.equals(((IDataEntityProperty)propertyScene.get(0)).getName())) {
            return;
        }
        List propertyCsl = properties.stream().filter(x -> x instanceof BasedataProp && "bcm_cslscheme".equals(((BasedataProp)x).getBaseEntityId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(propertyCsl)) {
            String name = ((IDataEntityProperty)propertyCsl.get(0)).getName();
            Object csl = this.getModel().getValue(name);
            Object scene = this.getModel().getValue(key);
            if (csl instanceof DynamicObject && scene instanceof DynamicObject) {
                long sceId = ((DynamicObject)scene).getLong("id");
                long modelId = ((DynamicObject)scene).getLong("model.id");
                List cslIds = DimensionServiceHelper.buildCslschemeFilter((long)modelId, (long)sceId);
                cslIds.add(this.getRateCslScheme());
                if (!cslIds.contains(((DynamicObject)csl).getLong("id"))) {
                    this.getModel().setValue(name, null);
                }
            }
        }
    }

    public void onCountDownEnd(CountDownEvent evt) {
        try {
            this.setIngNumber();
            this.setNotice();
            super.onCountDownEnd(evt);
            this.setTimeCount(false);
        }
        catch (Exception e) {
            log.error("onCountDownEnd error", (Throwable)e);
        }
    }

    private void setIngNumber() {
        Long sceneId;
        Long yearId = this.getModel().getValue("year") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("year")).getLong("id"));
        Long periodId = this.getModel().getValue("period") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("period")).getLong("id"));
        Long l2 = sceneId = this.getModel().getValue("scenario") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("scenario")).getLong("id"));
        if (yearId != null && periodId != null) {
            QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
            QFilter fyQf = new QFilter("fy", "=", (Object)yearId);
            QFilter periodQf = new QFilter("period", "=", (Object)periodId);
            QFilter statusQf = new QFilter(entry_collectstatus, "in", (Object)new String[]{"2", "8"});
            QFilter sceneQf = new QFilter("scenario", "=", (Object)sceneId);
            DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_isschemeexecuterec", (String)entry_collectstatus, (QFilter[])new QFilter[]{modelQf, fyQf, periodQf, statusQf, sceneQf});
            Map<String, List<DynamicObject>> collect = load.stream().collect(Collectors.groupingBy(l -> l.getString(entry_collectstatus)));
            Label label1 = (Label)this.getControl("labelap");
            Label label2 = (Label)this.getControl("labelap1");
            label1.setText(String.format(ResManager.loadKDString((String)"\u6392\u961f\u4e2d:%s", (String)"ISSchemeDataCollectPlugin2_53", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get("8") == null ? 0 : collect.get("8").size()));
            label2.setText(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4e2d:%s", (String)"ISSchemeDataCollectPlugin2_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get("2") == null ? 0 : collect.get("2").size()));
        }
    }

    private void setNotice() {
        QFilter userQf = new QFilter("userid", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter statusQf = new QFilter("exestatus", "in", (Object)new String[]{CollectStatusEnum.COMPLETE.getValue() + "", CollectStatusEnum.FAIL.getValue() + ""});
        QFilter noticeStatusQf = new QFilter("noticestatus", "=", (Object)NoticeStatusEnum.NOT_NOTIFIED.getValue());
        String selectField = "id,integrateexeclog.model.shownumber,integrateexeclog.model.name,integrateexeclog.scheme.number,integrateexeclog.scheme.name,integrateexeclog.scheme.onlynoticefailed,integrateexeclog.org.number,integrateexeclog.org.name,integrateexeclog.scenario.number,integrateexeclog.scenario.name,integrateexeclog.fy.number,integrateexeclog.fy.name,integrateexeclog.period.number,integrateexeclog.period.name,integrateexeclog.currency.number,integrateexeclog.currency.name,integrateexeclog.endtime,integratereslog.collectorstate";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_integration_notice", (String)selectField, (QFilter[])new QFilter[]{userQf, statusQf, noticeStatusQf});
        DynamicObjectCollection noNeedNotifyDyn = new DynamicObjectCollection();
        DynamicObjectCollection needNotifyDyn = new DynamicObjectCollection();
        for (DynamicObject dyn : query) {
            if (dyn.getBoolean("integrateexeclog.scheme.onlynoticefailed") && CollectStatusEnum.SUCCESS.getValue() == dyn.getInt("integratereslog.collectorstate")) {
                noNeedNotifyDyn.add((Object)dyn);
                continue;
            }
            needNotifyDyn.add((Object)dyn);
        }
        for (DynamicObject log : noNeedNotifyDyn) {
            DynamicObject notice = BusinessDataServiceHelper.loadSingle((Object)log.getLong("id"), (String)"bcm_integration_notice");
            notice.set("noticestatus", (Object)NoticeStatusEnum.NOT_NEED_NOTIFY.getValue());
            SaveServiceHelper.update((DynamicObject)notice);
        }
        for (DynamicObject log : needNotifyDyn) {
            StringBuilder titleSb = this.getTitleSb(log);
            StringBuilder contentsb = this.getContentsb(log);
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(RequestContext.get().getCurrUserId());
            MessageServiceUtil.sendMessageByNotice((String)String.format(ResManager.loadKDString((String)"\u96c6\u6210\u4efb\u52a1%s\u6267\u884c\u7ed3\u675f", (String)"IntegrateDispatcher2_8", (String)"fi-bcm-business", (Object[])new Object[0]), titleSb), (String)String.format(ResManager.loadKDString((String)"%s\u6267\u884c\u7ed3\u675f;", (String)"IntegrateDispatcher2_9", (String)"fi-bcm-business", (Object[])new Object[0]), contentsb), userIds);
            DynamicObject notice = BusinessDataServiceHelper.loadSingle((Object)log.getLong("id"), (String)"bcm_integration_notice");
            notice.set("noticestatus", (Object)NoticeStatusEnum.NOTIFIED.getValue());
            SaveServiceHelper.update((DynamicObject)notice);
        }
    }

    private StringBuilder getContentsb(DynamicObject log) {
        StringBuilder contentsb = new StringBuilder();
        contentsb.append(log.getString("integrateexeclog.org.number")).append("-").append(log.getString("integrateexeclog.org.name")).append(",");
        contentsb.append(log.getString("integrateexeclog.scheme.number")).append("-").append(log.getString("integrateexeclog.scheme.name")).append(",");
        contentsb.append(log.getString("integrateexeclog.fy.number")).append("-").append(log.getString("integrateexeclog.fy.name")).append(",");
        contentsb.append(log.getString("integrateexeclog.period.number")).append("-").append(log.getString("integrateexeclog.period.name")).append(",");
        contentsb.append(log.getString("integrateexeclog.scenario.number")).append("-").append(log.getString("integrateexeclog.scenario.name")).append(",");
        contentsb.append(log.getString("integrateexeclog.currency.number")).append("-").append(log.getString("integrateexeclog.currency.name")).append(",");
        contentsb.append(log.getString("integrateexeclog.model.shownumber")).append("-").append(log.getString("integrateexeclog.model.name")).append(",");
        contentsb.append(log.getDate("integrateexeclog.endtime")).append(",");
        return contentsb;
    }

    private StringBuilder getTitleSb(DynamicObject log) {
        StringBuilder titleSb = new StringBuilder();
        titleSb.append(log.getString("integrateexeclog.org.number")).append(",");
        titleSb.append(log.getString("integrateexeclog.scheme.number")).append(",");
        titleSb.append(log.getString("integrateexeclog.fy.number")).append(",");
        titleSb.append(log.getString("integrateexeclog.period.number"));
        return titleSb;
    }

    private void cacheSchemeIds(IPageCache pageCache) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ctl_entryentity);
        ArrayList ids = new ArrayList();
        entryEntity.forEach(row -> {
            DynamicObject scheme = row.getDynamicObject(entry_scheme);
            if (scheme != null) {
                ids.add(scheme.getLong("id"));
            }
        });
        pageCache.put(cache_scheme_ids, ObjectSerialUtil.toByteSerialized(ids));
    }

    private Search getCurrencySearch() {
        String control = "entitysearchap";
        if (!this.isEntityTab()) {
            control = "schemesearchap";
        }
        return (Search)this.getControl(control);
    }

    private boolean isEntityTab() {
        Tab subTab = (Tab)this.getControl("tabap");
        return "taborg".equals(subTab.getCurrentTab());
    }

    private void searchTemplate(String search) {
        TreeView tree = this.getCurrentTree();
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>();
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<String> path = new ArrayList<String>();
            this.getTreeNodeListByText(root, hitNode, search, 999, paths, path);
            SearchResult result = null;
            if (hitNode.size() > 0) {
                result = new SearchResult(hitNode);
                result.setPath(paths);
                TreeNode next = result.next(1);
                tree.focusNode(next);
                this.refreshEntryEntity();
                IPageCache pageCache = this.getPageCache();
                if (this.isEntityTab()) {
                    pageCache.put(CACHE_ORG_ID, String.valueOf(next.getId()));
                    this.cacheSchemeIds(pageCache);
                } else {
                    pageCache.put(CACHE_SCHEME_ID, String.valueOf(next.getId()));
                }
                for (String pathId : result.getPath()) {
                    tree.expand(pathId);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u5e76\u91cd\u65b0\u641c\u7d22\u3002", (String)"ISSchemeDataCollectPlugin2_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"BeginYearCarryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private TreeView getCurrentTree() {
        String control = "";
        control = this.isEntityTab() ? treeview_entity : treeview_scheme;
        return (TreeView)this.getControl(control);
    }

    public void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text, int maxLevel, List<String> paths, List<String> path) {
        ArrayList<String> temp = new ArrayList<String>(path);
        temp.add(node.getId());
        if (node.getText().contains(text)) {
            treeNodes.add(node);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            nodes.add(node);
            paths.add(String.join((CharSequence)",", temp));
        }
        if (maxLevel > 0 && node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text, maxLevel - 1, paths, temp);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, false);
        this.initCslschemeValue(String.valueOf(this.getModelId()), false);
        HashMap<String, String> f7KeyMap = new HashMap<String, String>();
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            for (String key : f7KEYS) {
                String f7id = UserSelectUtil.getF7SelectId(this.getView(), key);
                if (StringUtils.isEmpty((CharSequence)f7id)) continue;
                f7KeyMap.put(key, f7id);
            }
        }
        String showOrgType = this.getModel().getValue(CACHE_SHOW_ORG_TYPE).toString();
        String showScheduleType = this.getModel().getValue(CACHE_SHOW_SCHEDULE_TYPE).toString();
        this.getPageCache().put(CACHE_SHOW_ORG_TYPE, showOrgType);
        this.getPageCache().put(CACHE_SHOW_SCHEDULE_TYPE, showScheduleType);
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
        this.refreshCurrency();
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        if (modelDyn != null) {
            this.refreshLeftTree(modelDyn.getLong("id"));
        }
        this.checkGradeOrgScheme();
        this.refreshEntryEntity();
        this.controlSetEnable();
        if (StringUtils.isEmpty((CharSequence)ConfigServiceHelper.getStringParamNoModel((String)"IntegrationReset"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_exeingreset", "btn_linereset"});
        }
        this.setTimeCount(true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"countdownap"});
    }

    private void setTimeCount(boolean start) {
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.setDuration(5);
        if (start) {
            countdown.start();
        }
    }

    private void controlSetEnable() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_scheme"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        this.settingControlIsVisibleByConfigParam();
    }

    private void settingControlIsVisibleByConfigParam() {
        if (!ConfigServiceHelper.isHwApp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_more"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_entryintegrate", "btn_checktable", entry_batch, entry_checkstatus, entry_step});
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "imageup": 
            case "schemeimageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": 
            case "schemeimagedown": {
                this.searchNext(1);
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = this.getCurrentTree();
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ISSchemeDataCollectPlugin2_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ISSchemeDataCollectPlugin2_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                for (String id : result.getPath()) {
                    tree.expand(id);
                }
                tree.focusNode(next);
                this.refreshEntryEntity();
                if (this.isEntityTab()) {
                    pageCache.put(CACHE_ORG_ID, String.valueOf(next.getId()));
                    this.cacheSchemeIds(pageCache);
                } else {
                    pageCache.put(CACHE_SCHEME_ID, String.valueOf(next.getId()));
                }
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"ISSchemeDataCollectPlugin2_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private TreeNode setSchemeData2View(Long modelid) {
        TreeNode rootview = null;
        DynamicObjectCollection temlist = this.getSchemeColls(modelid);
        String showType = this.getPageCache().get(CACHE_SHOW_SCHEDULE_TYPE);
        if (kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)showType)) {
            showType = "1";
        }
        rootview = this.getTemplateTree(this.mergeSchemeCatalogList(modelid), temlist, new ArrayList<TreeNode>(), "0", new TreeNode(), showType);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        return rootview;
    }

    public TreeNode getTemplateTree(List<Map<String, String>> templatecatalogList, DynamicObjectCollection templateColls, List<TreeNode> templateNodeList, String rootid, TreeNode root, String showType) {
        if (templateNodeList.size() != 0) {
            root.setChildren(templateNodeList);
        }
        if (templatecatalogList.size() == 0) {
            return new TreeNode();
        }
        Iterator<Map<String, String>> iter = templatecatalogList.iterator();
        String fieldId = "";
        String fieldName = "";
        String parentid = "";
        while (iter.hasNext()) {
            Map<String, String> map = iter.next();
            fieldId = map.get("id");
            fieldName = map.get("name");
            parentid = map.get("parentid");
            if (!parentid.equals(rootid)) continue;
            if (templateColls != null && templateColls.size() > 0) {
                templateNodeList = new ArrayList<TreeNode>();
                for (DynamicObject templateObject : templateColls) {
                    String versionnumber;
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    String string = versionnumber = templateObject.getDynamicObjectType().getProperty("versionnumber") == null ? "" : String.format("V%.1f", Float.valueOf(templateObject.getBigDecimal("versionnumber").floatValue()));
                    if ("1".equals(showType)) {
                        templateNode.setText(templateObject.get("name").toString());
                    } else if ("2".equals(showType)) {
                        templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString());
                    } else {
                        templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString() + "   " + versionnumber);
                    }
                    templateNode.setData(null);
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)map.get("number"));
            entry = this.getTemplateTree(templatecatalogList, templateColls, templateNodeList, fieldId, entry, showType);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            children.add(entry);
            entry.setIsOpened(true);
        }
        return root;
    }

    private DynamicObjectCollection getSchemeColls(Long modelid) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        QFilter typeFilter = new QFilter("templatecatalog.type", "=", (Object)"1");
        QFilter idPermFilter = new QFilter("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelid));
        QFilter[] filters = new QFilter[]{modelFilter, typeFilter, idPermFilter};
        String selectFields = "id, name, number,templatecatalog,versionnumber";
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObjectCollection schemeEntityNew = QueryServiceHelper.query((String)"bcm_isscheme", (String)selectFields, (QFilter[])filters);
        if (this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
            ArrayList schemeIds = new ArrayList(schemeEntityNew.size());
            schemeEntityNew.forEach(schemeDyn -> schemeIds.add(schemeDyn.getLong("id")));
            String scenarioNum = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
            String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
            IntegrationUtil.filterSchemeByScenarioAndDate((long)this.getModelId(), (String)scenarioNum, (String)periodNum, (String)yearNum, schemeIds);
            schemeEntityNew.forEach(scheme -> {
                if (schemeIds.contains(scheme.getLong("id"))) {
                    result.add(scheme);
                }
            });
        } else {
            result.addAll((Collection)schemeEntityNew);
        }
        return result;
    }

    private List<Map<String, String>> mergeSchemeCatalogList(Long modelid) {
        DynamicObject[] doc = this.getSchemecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>(16);
        for (DynamicObject dd : doc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getLocaleString("name").getLocaleValue());
            map.put("parentid", dd.getString("parent_id") == null ? "0" : dd.getString("parent_id"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObject[] getSchemecatalogList() {
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
        QFilter typeFilter = new QFilter("type", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{modelFilter, typeFilter};
        String selectFields = "id,parent,name";
        String orderBys = "longnumber";
        return BusinessDataServiceHelper.load((String)"bcm_schemecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    private void refreshLeftTree(Long modelId) {
        if (this.isEntityTab()) {
            AbstractTreeNode<Object> root = this.getOrgTree(modelId, this.getPageCache().get(CACHE_SHOW_ORG_TYPE));
            if (root != null) {
                this.initOrgTree(root);
            }
        } else {
            TreeNode root = this.setSchemeData2View(modelId);
            this.initSchemeTree(root);
        }
    }

    @Override
    public CslSchemeServiceHelper.QueryOrgParam buildQueryOrgParam(long modelId, QFBuilder builder) {
        CslSchemeServiceHelper.QueryOrgParam param = super.buildQueryOrgParam(modelId, builder);
        param.setIncludeExchangeRateMembers(true);
        return param;
    }

    private void initSchemeTree(TreeNode root) {
        TreeView tree = this.getCurrentTree();
        tree.deleteAllNodes();
        tree.addNode(root);
        String orgId = this.getPageCache().get(CACHE_SCHEME_ID);
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            TreeNode findCacheNode = this.findCacheNode(root);
            tree.focusNode(findCacheNode);
        }
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)root));
        this.getPageCache().put(ROOT_NODE_ID, root.getId());
    }

    private TreeNode findCacheNode(TreeNode root) {
        String selectnode = null;
        if (this.isEntityTab()) {
            selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
            String selectedNodeId = this.getPageCache().get(CACHE_ORG_ID);
            if (!StringUtils.isEmpty((CharSequence)selectedNodeId)) {
                selectnode = selectedNodeId;
            }
        } else {
            selectnode = this.getPageCache().get(CACHE_SCHEME_ID);
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getText());
        }
        List childPathNodes = root.getChildPathNodes(selectnode);
        childPathNodes.forEach(v -> v.setIsOpened(true));
        if (childPathNodes.size() > 0) {
            return (TreeNode)childPathNodes.get(childPathNodes.size() - 1);
        }
        return new TreeNode("0", root.getId(), root.getText());
    }

    private AbstractTreeNode<Object> getOrgTree(Long modelId, String showOrgType) {
        OrgTreeNode root = super.initOrgTree(modelId, showOrgType, false, false);
        if (root != null) {
            this.getPageCache().put("treeCacheMap", ObjectSerialUtil.toByteSerialized((Object)ThreadCache.get((Object)"orgrealnames")));
        } else {
            root = new OrgTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ISSchemeDataCollectPlugin2_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return root;
    }

    private void initOrgTree(AbstractTreeNode<Object> root) {
        TreeView tree = this.getCurrentTree();
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode troot = treemodel.buildEntryTree(tree);
            if (troot.getChildren() == null) {
                return;
            }
            TreeNode findCacheNode = this.findCacheNode(troot);
            tree.focusNode(findCacheNode);
            this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)troot));
            this.getPageCache().put(ROOT_NODE_ID, troot.getId());
        }
    }

    private DynamicObjectCollection getTreeListORM(Long modelid) {
        DynamicObjectCollection doc = this.getOrgDynamicObjectCollection(modelid);
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("cslscheme");
        if (orgView != null && orgView.getString("number").equals(CslSchemeEnum.DefaultRate.getNumber())) {
            IntegrationUtil.addExchangeRateOrg((DynamicObjectCollection)doc, (Long)modelid);
        }
        OrgUtils.dealNoMergeOrgs(doc, this.getModel(), null);
        this.delOrgMenberPerm(doc, modelid);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_collect": {
                this.actionCollect();
                break;
            }
            case "btn_clean": {
                this.checkPeriodManager4ClearData();
                this.showModelOlapView(null);
                break;
            }
            case "btn_collectasync": {
                this.actionCollectAsync();
                break;
            }
            case "btn_collectlog": {
                this.actionCollectLog(null);
                break;
            }
            case "btn_refresh": {
                this.actionRefresh();
                break;
            }
            case "btn_executebizrule": {
                this.actionExecuteBizrule();
                break;
            }
            case "btn_entryintegrate": {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5904\u7406\u4e2d...", (String)"ISSchemeDataCollectPlugin2_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                try {
                    this.actionCollectAsync(true);
                    break;
                }
                finally {
                    this.getView().hideLoading();
                }
            }
            case "btn_checktable": {
                this.actionCheckTable();
                break;
            }
            case "btn_clear": {
                this.batchClearData();
                break;
            }
            case "btn_scheme": {
                this.actionNewScheme();
                break;
            }
            case "btn_log": {
                this.showModelOlapView(OperationStatus.VIEW);
                break;
            }
            case "btn_exeingreset": {
                this.reset("2");
                break;
            }
            case "btn_linereset": {
                this.reset("8");
                this.actionRefresh();
                break;
            }
        }
    }

    private void reset(String status) {
        int[] selectedRows = this.getSelectedEntry();
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (int row : selectedRows) {
            ids.add(((DynamicObject)dyncol.get(row)).getLong(entry_exeid));
        }
        if (ids.size() > 0) {
            QFilter idQf = new QFilter("id", "in", ids);
            QFilter statusQf = new QFilter(entry_collectstatus, "=", (Object)status);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_schemeexecuterec", (String)"id, collectstatus", (QFilter[])new QFilter[]{idQf, statusQf});
            if (load.length > 0) {
                for (DynamicObject dynamicObject : load) {
                    dynamicObject.set(entry_collectstatus, (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])load);
            }
        }
        if (ConfigServiceHelper.getGlobalBoolParam((String)"isIntegrationResetNum")) {
            this.resetCount();
        }
    }

    private void resetCount() {
        DynamicObjectCollection exes = QueryServiceHelper.query((String)"bcm_schemeexecuterec", (String)"id,scheme,org,scenario,fy,period,currency", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
        HashSet key = new HashSet();
        HashSet ids = new HashSet();
        exes.forEach(e -> {
            if (!key.add("" + e.getLong("scheme") + e.getLong(entry_org) + e.getLong("scenario") + e.getLong("fy") + e.getLong("period") + e.getLong("currency"))) {
                ids.add(e.getLong("id"));
            }
        });
        if (ids.size() > 0) {
            DeleteServiceHelper.delete((String)"bcm_schemeexecuterec", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
    }

    private void checkPeriodManager4ClearData() {
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (periodManage) {
            DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
            DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
            DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue("scenario");
            if (yearDy == null || periodDy == null || scenarioDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u4e3a\u5fc5\u9009\u9879\u3002", (String)"ISSchemeDataCollectPlugin2_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map orgNode = ((TreeView)this.getControl(treeview_entity)).getTreeState().getFocusNode();
            long orgid = orgNode != null ? Long.parseLong(orgNode.get("id").toString()) : 0L;
            DynamicObject orgObject = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, number,longnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "=", (Object)orgid)});
            String orgNumber = orgObject.getString("number");
            String longnumber = orgObject.getString("longnumber");
            ArrayList<Long> orgidset = new ArrayList<Long>();
            HashSet<String> orgnumberset = new HashSet<String>();
            boolean allSub = (Boolean)this.getModel().getValue("allsub");
            orgidset.add(orgid);
            orgnumberset.add(orgNumber);
            if (allSub) {
                QFBuilder qFBuilder = new QFBuilder();
                qFBuilder.add("model", "=", (Object)this.getModelId());
                qFBuilder.add("longnumber", "like", (Object)(longnumber + "!%"));
                DynamicObject[] dynamics = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id, number,longnumber", (QFilter[])qFBuilder.toArray());
                Stream.of(dynamics).forEach(dynamicObject -> {
                    orgidset.add(dynamicObject.getLong("id"));
                    orgnumberset.add(dynamicObject.getString("number"));
                });
            }
            Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)this.getModelId(), orgnumberset, (Long)scenarioDy.getLong("id"), (Long)yearDy.getLong("id"), (Long)periodDy.getLong("id"), (String)"datastatus");
            if (orgnumberset.stream().anyMatch(e -> !periodOpenOrgSet.contains(e))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ec4\u7ec7\u4e2d\u5b58\u5728\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ISSchemeDataCollectPlugin2_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void actionNewScheme() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        TreeView tv = (TreeView)this.getControl(treeview_entity);
        Map orgNode = tv.getTreeState().getFocusNode();
        long orgId = orgNode != null ? Long.parseLong(orgNode.get("id").toString()) : 0L;
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("id", "=", (Object)orgId);
        DynamicObject orgObject = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, number,longnumber", (QFilter[])new QFilter[]{filter});
        String orgNumber = null;
        if (orgObject != null) {
            orgNumber = orgObject.getString("number");
        }
        if (year == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"ISSchemeDataCollectPlugin2_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ISSchemeDataCollectPlugin2_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("Entity".equals(orgNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6811\u5f62\u7684\u975e\u201c\u7ec4\u7ec7\u201d\u7684\u5176\u4ed6\u8282\u70b9\u3002", (String)"ISSchemeDataCollectPlugin2_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_frommiddle");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("yearPkValue", year.getPkValue());
        formShowParameter.setCustomParam("periodPkValue", period.getPkValue());
        formShowParameter.setCustomParam("companycode", (Object)orgNumber);
        formShowParameter.setCustomParam("location", (Object)"all");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskcloseback"));
        this.getView().showForm(formShowParameter);
    }

    private void showModelOlapView(OperationStatus operationStatus) {
        if (!this.validate()) {
            return;
        }
        if (!this.isEntityTab()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u7ec4\u7ec7\u9875\u7b7e\uff0c\u8fdb\u884c\u6e05\u9664\u64cd\u4f5c\u3002", (String)"ISSchemeDataCollectPlugin2_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        FormShowParameter formShowParameter = new FormShowParameter();
        String formid = "bcm_model_olap";
        ShowType showType = ShowType.Modal;
        String caption = ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u6e05\u9664", (String)"ISSchemeDataCollectPlugin2_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (OperationStatus.VIEW == operationStatus) {
            formid = "bcm_modelolap_recordpage";
            showType = ShowType.MainNewTabPage;
            caption = ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u64cd\u4f5c\u65e5\u5fd7", (String)"ISSchemeDataCollectPlugin2_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        IFormView parentView = this.getView().getParentView();
        formShowParameter.setFormId(formid);
        formShowParameter.getOpenStyle().setShowType(showType);
        formShowParameter.setCaption(caption + "-" + model.getString("name"));
        formShowParameter.setCustomParam("isShowLog", (Object)Boolean.TRUE);
        formShowParameter.setCustomParam("model", model.get("id"));
        formShowParameter.setCustomParam("operationStatus", (Object)false);
        formShowParameter.setCustomParam("isdatacollect", (Object)true);
        formShowParameter.setCustomParam("isEdit", (Object)false);
        formShowParameter.setCustomParam("paramData", this.getDimensionScope());
        parentView.showForm(formShowParameter);
        this.getView().sendFormAction(parentView);
    }

    public Map<String, Map<Long, Integer>> getDimensionScope() {
        HashMap<String, Map<Long, Integer>> dataMap = new HashMap<String, Map<Long, Integer>>(16);
        Integer scope = 10;
        String[] dims = this.getAllFilterDim();
        IDataModel dataModel = this.getModel();
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        for (String dim : dims) {
            DynamicObject dyn;
            QFBuilder qFBuilder;
            HashMap<Long, Integer> dimMembers = new HashMap<Long, Integer>();
            if (dim.equals("Entity")) {
                TreeView tree = this.getCurrentTree();
                String focusNodeId = tree.getTreeState().getFocusNodeId();
                boolean allSub = (Boolean)this.getModel().getValue("allsub");
                dimMembers.put(Long.valueOf(focusNodeId), scope);
                if (allSub) {
                    dimMembers.put(Long.valueOf(focusNodeId), 50);
                }
            } else if (dim.equals("AuditTrail")) {
                qFBuilder = new QFBuilder();
                qFBuilder.add("model", "=", (Object)model.getLong("id"));
                qFBuilder.add("number", "=", (Object)"Integration");
                dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_audittrialmembertree", (String)"id, number", (QFilter[])qFBuilder.toArray());
                if (dyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u6210\u5458\u5ba1\u8ba1\u7ebf\u7d22\u3002", (String)"ISSchemeDataCollectPlugin2_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "Integration"));
                }
                dimMembers.put(dyn.getLong("id"), 10);
            } else if (dim.equals("Process")) {
                qFBuilder = new QFBuilder();
                qFBuilder.add("model", "=", (Object)model.getLong("id"));
                qFBuilder.add("number", "=", (Object)"IRpt");
                dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (String)"id, number", (QFilter[])qFBuilder.toArray());
                if (dyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u6210\u5458\u8fc7\u7a0b\u3002", (String)"ISSchemeDataCollectPlugin2_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "IRpt"));
                }
                dimMembers.put(dyn.getLong("id"), 10);
            } else {
                DynamicObject obj = (DynamicObject)dataModel.getValue(dim.toLowerCase(Locale.ENGLISH));
                dimMembers.put(obj.getLong("id"), 10);
            }
            dataMap.put(dim, dimMembers);
        }
        return dataMap;
    }

    private String[] getAllFilterDim() {
        return arr;
    }

    private void actionExecuteBizrule() {
        if (!this.validate()) {
            return;
        }
        int[] selectedRows = this.getSelectedEntry();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u5f85\u6267\u884c\u8bb0\u5f55\uff0c\u518d\u8fdb\u884c\u91c7\u96c6\u3002", (String)"ISSchemeDataCollectPlugin2_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<String> orgNums = new HashSet<String>(16);
        for (int row : selectedRows) {
            orgIds.add(((DynamicObject)dyncol.get(row)).getDynamicObject(entry_org).getLong("id"));
            orgNums.add(((DynamicObject)dyncol.get(row)).getDynamicObject(entry_org).getString("number"));
        }
        DynamicObject sceneObj = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodObj = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        FormShowParameter parameter = new FormShowParameter();
        HashMap<String, Object> fmap = new HashMap<String, Object>();
        this.dealWhileFilterData(fmap);
        parameter.getCustomParams().putAll(fmap);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        parameter.setCustomParam(DimTypesEnum.YEAR.getNumber(), (Object)yearObj);
        parameter.setCustomParam(DimTypesEnum.PERIOD.getNumber(), (Object)periodObj);
        parameter.setCustomParam(DimTypesEnum.SCENARIO.getNumber(), (Object)sceneObj);
        parameter.setCustomParam(DimTypesEnum.CURRENCY.getNumber(), (Object)currencyObj);
        parameter.setCustomParam("orgIds", orgIds);
        parameter.setCustomParam("orgNums", orgNums);
        Map<Integer, List<Object>> map = this.getlogMessageMap();
        parameter.setCustomParam("logMessageMap", map);
        parameter.setFormId("bcm_isbizrulesetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Map f7KeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(f7CACHEKEY), Map.class);
        switch (key) {
            case "model": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (newValue != null) {
                    ThreadCache.put((Object)"getModelId", (Object)newValue.getLong("id"));
                }
                this.modelChange(f7KeyMap);
                break;
            }
            case "period": 
            case "year": 
            case "scenario": 
            case "currency": {
                this.commonChange(e, key, f7KeyMap);
                break;
            }
            case "cslscheme": {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
                this.refreshLeftTree(this.getModelId());
                this.refreshEntryEntity();
                break;
            }
            case "allsub": {
                this.changeAllSub(e.getChangeSet()[0].getNewValue());
                break;
            }
            case "showorgtype": {
                String showType = (String)this.getModel().getValue(CACHE_SHOW_ORG_TYPE);
                this.getPageCache().put(CACHE_SHOW_ORG_TYPE, showType);
                this.refreshLeftTree(this.getModelId());
                this.refreshEntryEntity();
                break;
            }
            case "showscheduletype": {
                String showScheduleType = (String)this.getModel().getValue(CACHE_SHOW_SCHEDULE_TYPE);
                this.getPageCache().put(CACHE_SHOW_SCHEDULE_TYPE, showScheduleType);
                this.refreshLeftTree(this.getModelId());
                this.refreshEntryEntity();
                break;
            }
        }
    }

    private void changeAllSub(Object newValue) {
        this.refreshEntryEntity();
    }

    private void commonChange(PropertyChangedArgs e, String key, Map<String, Object> f7KeyMap) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
            return;
        }
        Boolean isSureReturn = this.propertyChangedDimUse(key, newValue, false, false);
        if (!isSureReturn.booleanValue()) {
            return;
        }
        if (newValue != null) {
            f7KeyMap.put(key, newValue.getLong("id"));
        } else {
            f7KeyMap.remove(key);
        }
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        this.refreshLeftTree(modelDyn.getLong("id"));
        this.refreshEntryEntity();
    }

    private void actionCheckTable() {
        String pageId;
        IFormView childView;
        DynamicObject sceneObj = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodObj = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        IFormView mainPageView = this.getView().getMainView();
        if (mainPageView == null) {
            mainPageView = this.getView();
        }
        if ((childView = mainPageView.getView(pageId = "dismbidata" + mainPageView.getPageId())) == null) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_dismbidatalist");
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            parameter.setCustomParam(DimTypesEnum.YEAR.getNumber(), yearObj == null ? null : Long.valueOf(yearObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.PERIOD.getNumber(), periodObj == null ? null : Long.valueOf(periodObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.SCENARIO.getNumber(), sceneObj == null ? null : Long.valueOf(sceneObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.CURRENCY.getNumber(), currencyObj == null ? null : Long.valueOf(currencyObj.getLong("id")));
            parameter.setPageId(pageId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setStatus(OperationStatus.EDIT);
            IFormView appPageView = this.getView().getParentView();
            if (appPageView == null) {
                appPageView = this.getView();
            }
            appPageView.showForm(parameter);
            this.getView().showForm(parameter);
            this.getView().sendFormAction(appPageView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void modelChange(Map<String, Object> f7KeyMap) {
        this.propertyChangedModelUse(dimKeys);
        this.initCslschemeValue(String.valueOf(this.getModelId()), false);
        f7KeyMap.clear();
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        this.refreshLeftTree(modelDyn.getLong("id"));
        this.refreshCurrency();
    }

    private void refreshCurrency() {
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
        QFilter currencyFilter = new QFilter("number", "=", (Object)CurrencyEnum.EC.getNumber());
        DynamicObject currencyDy = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, currencyFilter});
        if (currencyDy != null) {
            this.getModel().setValue("currency", (Object)currencyDy.getLong("id"));
        }
    }

    private void actionCollect() {
        this.doCollect(false, false, null);
    }

    private void actionCollectAsync() {
        int[] selectedRows = this.getSelectedEntry();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u5f85\u6267\u884c\u8bb0\u5f55\uff0c\u518d\u8fdb\u884c\u91c7\u96c6\u3002", (String)"ISSchemeDataCollectPlugin2_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ConfigServiceHelper.getGlobalBoolParam((String)"P002")) {
            String modelType = HWModelParamUtil.getModelType((long)this.getModelId());
            if (HWModelTypeEnum.FIN.getNumber().equals(modelType) && this.existMiddleScheme()) {
                this.showForm();
            } else {
                this.doCollect(true, false, null);
            }
        } else {
            this.doCollect(true, false, null);
        }
    }

    private void actionCollectAsync(boolean isEntryIntegrate) {
        this.doCollect(true, isEntryIntegrate, null);
    }

    private void doCollect(boolean isSync, boolean isEntryIntegrate, Set<String> batchName) {
        if (!this.validate()) {
            return;
        }
        int[] selectedRows = this.getSelectedEntry();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u5f85\u6267\u884c\u8bb0\u5f55\uff0c\u518d\u8fdb\u884c\u91c7\u96c6\u3002", (String)"ISSchemeDataCollectPlugin2_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObjectCollection col = new DynamicObjectCollection();
        for (int row : selectedRows) {
            col.add(dyncol.get(row));
        }
        boolean synstatus = this.sysnBase(col);
        if (!synstatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5176\u5b83\u91c7\u96c6\u6b63\u5728\u540c\u6b65\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ISSchemeDataCollectPlugin2_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean repeatStatus = this.repeatVerification(col);
        if (repeatStatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u96c6\u6210\u65b9\u6848\u5f85\u6267\u884c\u8bb0\u5f55\u4e2d\u6709\u91c7\u96c6\u72b6\u6001\u4e3a\u2018\u6267\u884c\u4e2d\u2019\u6216\u2018\u6392\u961f\u4e2d\u2019\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ISSchemeDataCollectPlugin2_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set schemeIds = col.stream().map(d -> d.getLong("schemename.id")).collect(Collectors.toSet());
        DynamicObjectCollection integrateimpmodes = QueryServiceHelper.query((String)"bcm_isimportmode", (String)"importmode", (QFilter[])new QFilter("scheme", "in", schemeIds).toArray());
        boolean isReplaceImport = integrateimpmodes.stream().anyMatch(s -> ISImpModeEnum.REPLACEIMPORT.getCode().equals(s.getString("importmode")));
        this.cacheCollectParam(isSync, isEntryIntegrate, batchName, isReplaceImport);
        if (this.checkNeedFilterTemplate()) {
            Set<Long> orgIds = col.stream().map(d -> d.getLong("org.id")).collect(Collectors.toSet());
            this.showTemplateSelectForm(orgIds);
        } else {
            this.showAcquisitionModeForm();
        }
    }

    private boolean repeatVerification(DynamicObjectCollection col) {
        Set status;
        QFilter collectStatusQFilter;
        QFilter currencyQFilter;
        QFilter periodQFilter;
        QFilter yearQFilter;
        QFilter scenarioQFilter;
        long modelId = (Long)((DynamicObject)this.getModel().getValue("model")).get("id");
        long scenarioId = (Long)((DynamicObject)this.getModel().getValue("scenario")).get("id");
        long yearId = (Long)((DynamicObject)this.getModel().getValue("year")).get("id");
        long periodId = (Long)((DynamicObject)this.getModel().getValue("period")).get("id");
        long currencyId = (Long)((DynamicObject)this.getModel().getValue("currency")).get("id");
        HashSet<Pair> orgSchemePairs = new HashSet<Pair>();
        for (DynamicObject dynamicObject : col) {
            Pair orgSchemePair = new Pair(dynamicObject.get("org.id"), dynamicObject.get("schemename.id"));
            orgSchemePairs.add(orgSchemePair);
        }
        String selectFields = "id,org.id,scheme.id,collectstatus";
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{modelQFilter, scenarioQFilter = new QFilter("scenario", "=", (Object)scenarioId), yearQFilter = new QFilter("fy", "=", (Object)yearId), periodQFilter = new QFilter("period", "=", (Object)periodId), currencyQFilter = new QFilter("currency", "=", (Object)currencyId), collectStatusQFilter = new QFilter(entry_collectstatus, "in", status = Stream.of("2", "8").collect(Collectors.toSet()))};
        DynamicObjectCollection executors = QueryServiceHelper.query((String)"bcm_schemeexecuterec", (String)selectFields, (QFilter[])filters);
        if (executors != null && executors.size() > 0) {
            for (DynamicObject executor : executors) {
                for (Pair orgSchemePair : orgSchemePairs) {
                    if (!((Long)orgSchemePair.p1).equals(executor.getLong("org.id")) || !((Long)orgSchemePair.p2).equals(executor.getLong("scheme.id"))) continue;
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sysnBase(DynamicObjectCollection col) {
        block20: {
            boolean needSyn = false;
            for (DynamicObject object : col) {
                if (object.get("schemename.synbase") == null || !object.getBoolean("schemename.synbase")) continue;
                needSyn = true;
                break;
            }
            if (!needSyn) {
                return true;
            }
            try (DLock lock = DLock.create((String)IS_SYNBASE);){
                if (lock.tryLock(3000L)) {
                    try {
                        new BaseDataImportHelper().importBaseData(this.getModelId());
                        break block20;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean checkNeedFilterTemplate() {
        if (!this.isEntityTab()) {
            Map focusNode = this.getCurrentTree().getTreeState().getFocusNode();
            if (((Boolean)focusNode.get("isParent")).booleanValue()) {
                return false;
            }
            String schemeId = this.getCurrentTree().getTreeState().getFocusNodeId();
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(schemeId), (String)"bcm_isscheme");
            return EASREP.equals(scheme.getDynamicObject("issrc").getString("number"));
        }
        return false;
    }

    private void showTemplateSelectForm(Set<Long> orgIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_templateselect");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
        formShowParameter.setCustomParam(SELECT_ORG, (Object)ObjectSerialUtil.toJson(orgIds));
        IDataModel model = this.getModel();
        formShowParameter.setCustomParam("yearId", (Object)((DynamicObject)model.getValue("year")).getString("id"));
        formShowParameter.setCustomParam("periodId", (Object)((DynamicObject)model.getValue("period")).getString("id"));
        formShowParameter.setCustomParam("scenarioId", (Object)((DynamicObject)model.getValue("scenario")).getString("id"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_templateselect"));
        this.getView().showForm(formShowParameter);
    }

    private void showAcquisitionModeForm() {
        boolean isReplaceImport = Boolean.parseBoolean(this.getPageCache().get("isReplaceImport"));
        String caption1 = ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u65b9\u6848\u96c6\u6210\u6a21\u5f0f\u5b58\u5728\u66ff\u6362\u6a21\u5f0f\uff0c\u4f1a\u6e05\u9664\u6570\u636e\u518d\u96c6\u6210\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ISSchemeDataCollectPlugin2_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String caption2 = ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u65b9\u6848\u96c6\u6210\u6a21\u5f0f\u4e3a\u5408\u5e76\u6a21\u5f0f\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ISSchemeDataCollectPlugin2_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (isReplaceImport) {
            caption2 = null;
        } else {
            caption1 = null;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_acquisitionmode");
        formShowParameter.setCustomParam("msg1", (Object)caption1);
        formShowParameter.setCustomParam("msg2", (Object)caption2);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_acquisitionmode"));
        this.getView().showForm(formShowParameter);
    }

    private void cacheCollectParam(boolean isSync, boolean isEntryIntegrate, Set<String> batchName, boolean isReplaceImport) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("isSync", String.valueOf(isSync));
        pageCache.put("isEntryIntegrate", String.valueOf(isEntryIntegrate));
        pageCache.put("isReplaceImport", String.valueOf(isReplaceImport));
        if (batchName != null) {
            pageCache.put("batchName", ObjectSerialUtil.toByteSerialized(batchName));
        }
    }

    private void removeCollectParamCache() {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove("isSync");
        pageCache.remove("isEntryIntegrate");
        pageCache.remove("isReplaceImport");
        pageCache.remove("batchName");
    }

    private void collect(boolean isSync, boolean isEntryIntegrate, Set<String> batchName, List<Long> selectTemplate, DynamicObjectCollection col) {
        IDataModel dataModel = this.getModel();
        DynamicObject modelObj = (DynamicObject)dataModel.getValue("model");
        String modelType = HWModelParamUtil.getModelType((long)modelObj.getLong("id"));
        boolean isLG = modelType.equals(HWModelTypeEnum.LG.getNumber());
        boolean hasShowMessage = false;
        try {
            IntegrateEntity intEntity = new IntegrateEntity();
            DynamicObject sceneObj = (DynamicObject)dataModel.getValue("scenario");
            DynamicObject yearObj = (DynamicObject)dataModel.getValue("year");
            DynamicObject periodObj = (DynamicObject)dataModel.getValue("period");
            DynamicObject currencyObj = (DynamicObject)dataModel.getValue("currency");
            intEntity.setModel(Long.valueOf(modelObj.getLong("id")), modelObj.getString("number"));
            intEntity.setScene(Long.valueOf(sceneObj.getLong("id")), sceneObj.getString("number"));
            intEntity.setYear(Long.valueOf(yearObj.getLong("id")), yearObj.getString("number"));
            intEntity.setPeriod(Long.valueOf(periodObj.getLong("id")), periodObj.getString("number"));
            intEntity.setCurrency(Long.valueOf(currencyObj.getLong("id")), currencyObj.getString("number"));
            intEntity.putCustomParam("isEntryIntegrate", (Object)isEntryIntegrate);
            if (isSync) {
                intEntity.putCustomParam("currentView", (Object)this.getView());
                intEntity.putCustomParam("currentPlugin", (Object)this);
            }
            if (batchName != null) {
                intEntity.putCustomParam("batchname", batchName);
            }
            if (selectTemplate != null && !selectTemplate.isEmpty()) {
                intEntity.putCustomParam("selecttemplate", selectTemplate);
            }
            Set rateOrgIdList = IntegrationUtil.getRateOrgIdSet((Long)((Long)intEntity.getModel().p1));
            HashSet<String> schemeNums = new HashSet<String>(16);
            for (DynamicObject row : col) {
                DynamicObject orgDyn = row.getDynamicObject(entry_org);
                DynamicObject scheme = row.getDynamicObject(entry_scheme);
                if (isEntryIntegrate) {
                    if (isLG) {
                        if (!"PR".equalsIgnoreCase(scheme.getString("location"))) continue;
                        intEntity.addOrgSchemePair(Long.valueOf(orgDyn.getLong("id")), orgDyn.getString("number"), Long.valueOf(scheme.getLong("id")), scheme.getString("number"));
                        continue;
                    }
                    if (schemeNums.contains(scheme.getString("number"))) continue;
                    schemeNums.add(scheme.getString("number"));
                    intEntity.addOrgSchemePair(Long.valueOf(orgDyn.getLong("id")), orgDyn.getString("number"), Long.valueOf(scheme.getLong("id")), scheme.getString("number"));
                    continue;
                }
                if (rateOrgIdList.contains(orgDyn.getLong("id"))) {
                    IntegrationUtil.saveRateSchemeCurrency2IntEntity((IntegrateEntity)intEntity, (long)scheme.getLong("id"), (String)orgDyn.getString("number"));
                    List currency4Rate = intEntity.getCurrency4Rate();
                    for (int i = 0; i < currency4Rate.size(); ++i) {
                        intEntity.addOrgSchemePair(Long.valueOf(orgDyn.getLong("id")), orgDyn.getString("number"), Long.valueOf(scheme.getLong("id")), scheme.getString("number"));
                    }
                    continue;
                }
                intEntity.addOrgSchemePair(Long.valueOf(orgDyn.getLong("id")), orgDyn.getString("number"), Long.valueOf(scheme.getLong("id")), scheme.getString("number"));
            }
            if (intEntity.getOrgSchemePairs().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6cd5\u4eba\u8d22\u62a5\u7684\u5206\u5f55\u96c6\u6210\u529f\u80fd\u4ec5\u652f\u6301location\u4e3aPR\u7684\u96c6\u6210\u65b9\u6848\u3002", (String)"ISSchemeDataCollectPlugin2_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!IntegrateDispatcher2.submitTaskDistribute((IntegrateEntity)intEntity, (boolean)isSync, (boolean)isEntryIntegrate, ctx -> ISSchemeDataCollectHelper.collectRpt(ctx, (AbstractFormPlugin)this))) {
                this.refreshEntryEntity();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u8f83\u957f\uff0c\u5df2\u8fdb\u5165\u540e\u53f0\u6267\u884c\u4e2d\u3002\u8bf7\u67e5\u770b\u5177\u4f53\u65e5\u5fd7\u4ee5\u4e86\u89e3\u6267\u884c\u60c5\u51b5\u3002", (String)"ISSchemeDataCollectPlugin2_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                hasShowMessage = true;
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
            } else {
                logger.error("datacollect error", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u5206\u6790\u65e5\u5fd7\u3002", (String)"ISSchemeDataCollectPlugin2_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.refreshEntryEntity();
            return;
        }
        Map<Integer, List<Object>> map = null;
        try {
            map = this.getlogMessageMap();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        this.refreshEntryEntity();
        if (isSync) {
            if (!hasShowMessage && isEntryIntegrate) {
                if (isLG) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91c7\u96c6\u5b8c\u6210\uff0c\u6cd5\u4eba\u8d22\u62a5\u7684\u5206\u5f55\u96c6\u6210\u529f\u80fd\u4ec5\u652f\u6301location\u4e3aPR\u7684\u96c6\u6210\u65b9\u6848\u3002", (String)"ISSchemeDataCollectPlugin2_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e3a\u96c6\u56e2\u8d22\u62a5\uff0c\u96c6\u56e2\u8d22\u62a5\u53ea\u9700\u9009\u62e9\u4efb\u4e00\u7ec4\u7ec7\u7684\u96c6\u6210\u65b9\u6848\u5373\u53ef\u5c06\u6240\u6709\u7ec4\u7ec7\u7684\u6e90\u65e5\u8bb0\u8d26\u6570\u636e\u96c6\u6210\u751f\u6210\u5206\u5f55\u3002", (String)"ISSchemeDataCollectPlugin2_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            String doName = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6", (String)"ISSchemeDataCollectPlugin2_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String doSuccesss = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6\u5b8c\u6210", (String)"ISSchemeDataCollectPlugin2_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (map != null) {
                this.printLogMessage(doName, map, doSuccesss);
            }
        } else {
            QFilter collectStatusQFilter = new QFilter(entry_collectstatus, "in", (Object)new String[]{"2", "8"});
            DynamicObjectCollection executors = QueryServiceHelper.query((String)"bcm_schemeexecuterec", (String)"id", (QFilter[])new QFilter[]{collectStatusQFilter});
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f02\u6b65\u91c7\u96c6\u4e2d\uff0c\u8bf7\u5237\u65b0\u65e5\u5fd7\u67e5\u770b\u91c7\u96c6\u8fdb\u5ea6\uff0c\u7cfb\u7edf\u5f53\u524d\u8fd8\u6709%s\u4e2a\u4efb\u52a1\u5f85\u6267\u884c\u3002", (String)"ISSchemeDataCollectPlugin2_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), executors.size()));
            String doName = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6", (String)"ISSchemeDataCollectPlugin2_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String doSuccesss = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6\u5b8c\u6210", (String)"ISSchemeDataCollectPlugin2_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (map != null) {
                this.printLogMessage(doName, map, doSuccesss);
            }
        }
    }

    private void printLogMessage(String doName, Map<Integer, List<Object>> map, String doSuccesss) {
        Iterator<Map.Entry<Integer, List<Object>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            List<Object> value = iterator.next().getValue();
            String orgName = (String)value.get(0);
            String number = (String)value.get(1);
            String schemeNumber = (String)value.get(2);
            String schemeName = (String)value.get(3);
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)doName, (String)(orgName + " " + number + " " + schemeNumber + " " + schemeName + "," + doSuccesss), (Long)this.getModelId());
        }
    }

    private Map<Integer, List<Object>> getlogMessageMap() {
        int[] selectRows = this.getSelectedEntry();
        HashMap<Integer, List<Object>> map = new HashMap<Integer, List<Object>>(16);
        ArrayList<String> list = null;
        Integer i = 0;
        for (int selectRow : selectRows) {
            list = new ArrayList<String>(10);
            DynamicObject entryentityData = this.getModel().getEntryRowEntity(ctl_entryentity, selectRow);
            list.add(entryentityData.getString("org.number"));
            list.add(entryentityData.getString("org.name"));
            list.add(entryentityData.getString("schemename.number"));
            list.add(entryentityData.getString("schemename.name"));
            map.put(i, list);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return map;
    }

    private void actionCollectLog(Long exeId) {
        DynamicObject sceneObj = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodObj = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        IFormView mainPageView = this.getView().getMainView();
        if (mainPageView == null) {
            mainPageView = this.getView();
        }
        String pageId = "schemecollectlog" + mainPageView.getPageId();
        IFormView childView = mainPageView.getView(pageId);
        if (exeId != null) {
            pageId = "schemecollectlog" + System.currentTimeMillis();
        }
        if (childView == null || exeId != null) {
            ListShowParameter parameter = new ListShowParameter();
            HashMap<String, Object> fmap = new HashMap<String, Object>();
            this.dealWhileFilterData(fmap);
            parameter.getCustomParams().putAll(fmap);
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            parameter.setCustomParam(DimTypesEnum.YEAR.getNumber(), yearObj == null ? null : Long.valueOf(yearObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.PERIOD.getNumber(), periodObj == null ? null : Long.valueOf(periodObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.SCENARIO.getNumber(), sceneObj == null ? null : Long.valueOf(sceneObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.CURRENCY.getNumber(), currencyObj == null ? null : Long.valueOf(currencyObj.getLong("id")));
            DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
            int[] selectedRows = this.getSelectedEntry();
            if (selectedRows != null && selectedRows.length > 0) {
                DynamicObject schemeObj = ((DynamicObject)dyncol.get(0)).getDynamicObject(entry_scheme);
                parameter.setCustomParam("scheme", schemeObj == null ? null : Long.valueOf(schemeObj.getLong("id")));
            }
            parameter.setBillFormId("bcm_isschemecollectlog");
            parameter.setPageId(pageId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCustomParam("exeId", (Object)exeId);
            IFormView appPageView = this.getView().getParentView();
            if (appPageView == null) {
                appPageView = this.getView();
            }
            appPageView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(appPageView);
        } else {
            childView.activate();
            this.getView().sendFormAction(childView);
        }
    }

    private void actionRefresh() {
        this.refreshLeftTree(this.getModelId());
        this.refreshEntryEntity();
    }

    private void dealWhileFilterData(Map<String, Object> fmap) {
        EntryGrid teg = (EntryGrid)this.getControl(ctl_entryentity);
        int[] sRows = teg.getSelectRows();
        HashSet<String> temNumbers = new HashSet<String>(16);
        for (int i : sRows) {
            temNumbers.add(this.getModel().getEntryRowEntity(ctl_entryentity, i).getString("schemename.number"));
        }
        fmap.put("temNumbers", temNumbers);
    }

    private int[] getSelectedEntry() {
        EntryGrid teg = (EntryGrid)this.getControl(ctl_entryentity);
        return teg.getSelectRows();
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    private QFilter getFilter() {
        QFilter qf = null;
        if (this.getModel().getValue("model") == null) {
            qf = new QFilter("2", "=", (Object)1);
        } else {
            Long modelid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            qf = new QFilter("model", "=", (Object)modelid);
        }
        return qf;
    }

    private QFilter getMembFilter() {
        QFilter qf = null;
        if (this.getModel().getValue("scenario") == null || this.getModel().getValue("year") == null || this.getModel().getValue("period") == null || this.getModel().getValue("currency") == null) {
            qf = new QFilter("2", "=", (Object)1);
        } else {
            Long scenarioid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            qf = new QFilter("model", "=", (Object)scenarioid);
            Long fyid = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
            qf.and(new QFilter("fy", "=", (Object)fyid));
            Long periodid = ((DynamicObject)this.getModel().getValue("period")).getLong("id");
            qf.and(new QFilter("period", "=", (Object)periodid));
            Long currencyid = ((DynamicObject)this.getModel().getValue("currency")).getLong("id");
            qf.and(new QFilter("currency", "=", (Object)currencyid));
            Long scenarioId = ((DynamicObject)this.getModel().getValue("scenario")).getLong("id");
            qf.and(new QFilter("scenario", "=", (Object)scenarioId));
        }
        return qf;
    }

    private void refreshEntryEntity() {
        if (this.getModel().getValue("currency") != null) {
            long runningTime = 0x6DDD00L;
            String runningStatus = Integer.toString(CollectStatusEnum.RUNNING.getValue());
            String errorInfo = ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u5df2\u5173\u95ed\u6216\u505c\u6b62\uff0c\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3002", (String)"ISSchemeDataCollectPlugin2_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.checkAndResetRecStatus(runningTime, runningStatus, errorInfo);
            long lineupTime = 108000000L;
            String collectStatus = Integer.toString(CollectStatusEnum.LINEUP.getValue());
            this.checkAndResetRecStatus(lineupTime, collectStatus, errorInfo);
        }
        this.getModel().deleteEntryData(ctl_entryentity);
        if (!this.validateConditionNoTip() || !this.valicateMembConditionNoTip()) {
            return;
        }
        TreeView tree = this.getCurrentTree();
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        String rootNodeId = this.getPageCache().get(ROOT_NODE_ID);
        if ("0".equals(focusNodeId) || StringUtils.isEmpty((CharSequence)focusNodeId)) {
            return;
        }
        if (focusNodeId.equals(rootNodeId)) {
            return;
        }
        Table<Long, Long, DynamicObject> schemeOrgIdMaps = null;
        Long focusid = LongUtil.toLong((Object)focusNodeId);
        schemeOrgIdMaps = this.isEntityTab() ? this.geneOrgEntity(focusid) : this.geneSchemeEntity(focusid);
        if (this.getModel().getValue("scenario") != null) {
            Object periodDimId;
            ArrayList<Long> schemeIds = new ArrayList<Long>(schemeOrgIdMaps.rowKeySet());
            String scenarioNum = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            if (this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
                final String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
                final String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                IntegrationUtil.filterSchemeByScenarioAndDate((long)this.getModelId(), (String)scenarioNum, (String)periodNum, (String)yearNum, schemeIds);
                Long yearDimId = ((DynamicObject)this.getModel().getValue("year")).getDynamicObject("dimension").getLong("id");
                periodDimId = ((DynamicObject)this.getModel().getValue("period")).getDynamicObject("dimension").getLong("id");
                Pair yearMemberPair = IntegrationUtil.filterSingleMapMems((Long)yearDimId, schemeIds, (List)new ArrayList<String>(){
                    {
                        this.add(yearNum);
                        this.add(ISSchemeDataCollectPlugin2.ALL);
                    }
                });
                HashSet set = new HashSet();
                ((Map)yearMemberPair.p1).values().forEach(set::addAll);
                if (((Map)yearMemberPair.p2).get(yearNum) != null) {
                    set.removeAll((Collection)((Map)yearMemberPair.p2).get(yearNum));
                }
                Pair periodMemberPair = IntegrationUtil.filterSingleMapMems((Long)periodDimId, set, (List)new ArrayList<String>(){
                    {
                        this.add(periodNum);
                        this.add(ISSchemeDataCollectPlugin2.ALL);
                    }
                });
                HashSet set1 = new HashSet();
                ((Map)periodMemberPair.p1).values().forEach(set1::addAll);
                if (((Map)periodMemberPair.p2).get(periodNum) != null) {
                    set1.removeAll((Collection)((Map)periodMemberPair.p2).get(periodNum));
                }
                schemeIds = new ArrayList(set1);
            } else {
                Set scenarioSchemeIds = IntegrationUtil.filterSchemeByScenario((long)this.getModelId(), (String)scenarioNum, schemeIds);
                QFBuilder qFBuilder = new QFBuilder();
                qFBuilder.add("id", "in", (Object)scenarioSchemeIds);
                qFBuilder.add("status", "=", (Object)"1");
                DynamicObjectCollection dynamics = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id, number, effectivedate, expiringdate, versionnumber", (QFilter[])qFBuilder.toArray(), (String)"number asc, versionnumber desc");
                schemeIds.clear();
                periodDimId = dynamics.iterator();
                while (periodDimId.hasNext()) {
                    DynamicObject dynamic = (DynamicObject)periodDimId.next();
                    schemeIds.add(dynamic.getLong("id"));
                }
            }
            Set<Long> sidSet = this.filterByScenario(schemeIds, scenarioNum);
            ArrayList needRemove = Lists.newArrayList();
            for (Object cell : schemeOrgIdMaps.cellSet()) {
                if (sidSet.contains(cell.getRowKey())) continue;
                needRemove.add(Long.toString((Long)cell.getRowKey()) + "_" + Long.toString((Long)cell.getColumnKey()));
            }
            for (String s : needRemove) {
                String[] idArray = s.split("_");
                schemeOrgIdMaps.remove((Object)Long.parseLong(idArray[0]), (Object)Long.parseLong(idArray[1]));
            }
        }
        int count = 0;
        if (schemeOrgIdMaps.isEmpty()) {
            return;
        }
        Map treeCacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("treeCacheMap"));
        if (schemeOrgIdMaps.size() <= 100) {
            if (!schemeOrgIdMaps.isEmpty()) {
                this.getModel().batchCreateNewEntryRow(ctl_entryentity, schemeOrgIdMaps.size());
            }
            DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id, number, name, versionnumber", (QFilter[])new QFilter("id", "in", (Object)schemeOrgIdMaps.rowKeySet()).toArray());
            Map<Long, DynamicObject> schemeIdMap = schemes.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (Object cell : schemeOrgIdMaps.cellSet()) {
                this.getModel().setValue(entry_scheme, cell.getRowKey(), count);
                this.getModel().setValue(entry_org, cell.getColumnKey(), count);
                String number = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)((Long)cell.getColumnKey())).getNumber();
                this.getModel().setValue("orgname", treeCacheMap.get(number), count);
                this.getModel().setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(schemeIdMap.get(cell.getRowKey()).getBigDecimal("versionnumber").floatValue())), count);
                DynamicObject excutor = (DynamicObject)cell.getValue();
                if (excutor != null && excutor.getDataEntityType().getName().equals("bcm_isschemeexecuterec")) {
                    this.getModel().setValue(entry_collectstatus, excutor.get(entry_collectstatus), count);
                    this.getModel().setValue(entry_checkstatus, excutor.get(entry_checkstatus), count);
                    this.getModel().setValue(entry_modifier, excutor.get(entry_modifier), count);
                    this.getModel().setValue(entry_step, excutor.get(entry_step), count);
                    this.getModel().setValue(entry_batch, excutor.get(entry_batch), count);
                    Date startDate = excutor.getDate(entry_modifydate);
                    Date endDate = excutor.getDate("endtime");
                    this.getModel().setValue(entry_optime, (Object)excutor.getDate("optime"), count);
                    this.getModel().setValue(entry_exeip, (Object)excutor.getString(entry_exeip), count);
                    this.getModel().setValue(entry_exeid, (Object)excutor.getLong("id"), count);
                    this.getModel().setValue(entry_modifydate, (Object)startDate, count);
                    this.getModel().setValue(entry_enddate, (Object)endDate, count);
                    if (startDate != null && endDate != null) {
                        Long spend = endDate.getTime() - startDate.getTime();
                        StringBuffer sb = this.calculate(spend);
                        this.getModel().setValue("spend", (Object)sb.toString(), count);
                    }
                } else if (this.valicateMembConditionNoTip()) {
                    this.getModel().setValue(entry_checkstatus, (Object)CheckStatusEnum.READY.getValue(), count);
                    this.getModel().setValue(entry_collectstatus, (Object)1, count);
                }
                ++count;
            }
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ctl_entryentity);
            DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id, number, name, versionnumber", (QFilter[])new QFilter("id", "in", (Object)schemeOrgIdMaps.rowKeySet()).toArray());
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, name", (QFilter[])new QFilter("id", "in", (Object)schemeOrgIdMaps.columnKeySet()).toArray());
            Map<Long, DynamicObject> schemeIdMap = schemes.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            Map<Long, DynamicObject> orgIdMap = orgs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            orgs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
                DynamicObject addNew = dynamicObjectCollection.addNew();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_isscheme");
                DynamicObject schemeName = new DynamicObject((DynamicObjectType)dataEntityType);
                schemeName.set("id", (Object)schemeIdMap.get(cell.getRowKey()).getLong("id"));
                schemeName.set("number", (Object)schemeIdMap.get(cell.getRowKey()).getString("number"));
                schemeName.set("name", (Object)schemeIdMap.get(cell.getRowKey()).getString("name"));
                schemeName.set("versionnumber", (Object)schemeIdMap.get(cell.getRowKey()).getString("versionnumber"));
                addNew.set(entry_scheme, (Object)schemeName);
                String number = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)((Long)cell.getColumnKey())).getNumber();
                addNew.set("orgname", treeCacheMap.get(number));
                DynamicObject orgName = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_entitymembertree"));
                orgName.set("id", (Object)orgIdMap.get(cell.getColumnKey()).getLong("id"));
                orgName.set("number", (Object)orgIdMap.get(cell.getColumnKey()).getString("number"));
                orgName.set("name", (Object)orgIdMap.get(cell.getColumnKey()).getString("name"));
                addNew.set(entry_org, (Object)orgName);
                addNew.set("versionnum", (Object)String.format("V%.1f", Float.valueOf(schemeIdMap.get(cell.getRowKey()).getBigDecimal("versionnumber").floatValue())));
                DynamicObject excutor = (DynamicObject)cell.getValue();
                if (excutor != null && excutor.getDataEntityType().getName().equals("bcm_isschemeexecuterec")) {
                    addNew.set(entry_checkstatus, excutor.get(entry_checkstatus));
                    addNew.set(entry_collectstatus, excutor.get(entry_collectstatus));
                    addNew.set(entry_modifier, excutor.get(entry_modifier));
                    Date startDate = excutor.getDate(entry_modifydate);
                    Date endDate = excutor.getDate("endtime");
                    addNew.set(entry_optime, (Object)excutor.getDate("optime"));
                    addNew.set(entry_exeip, (Object)excutor.getString(entry_exeip));
                    addNew.set(entry_exeid, (Object)excutor.getLong("id"));
                    addNew.set(entry_modifydate, (Object)startDate);
                    addNew.set(entry_enddate, (Object)endDate);
                    addNew.set(entry_step, excutor.get(entry_step));
                    addNew.set(entry_batch, excutor.get(entry_batch));
                    if (startDate == null || endDate == null) continue;
                    Long spend = endDate.getTime() - startDate.getTime();
                    StringBuffer sb = this.calculate(spend);
                    addNew.set("spend", (Object)sb.toString());
                    continue;
                }
                if (!this.valicateMembConditionNoTip()) continue;
                addNew.set(entry_checkstatus, (Object)CheckStatusEnum.READY.getValue());
                addNew.set(entry_collectstatus, (Object)1);
            }
            this.getView().updateView(ctl_entryentity);
        }
        if (this.isEntityTab()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgnumber", entry_org});
        }
    }

    private void checkAndResetRecStatus(long overTime, String collectStatus, String errorInfo) {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter statusFilter = new QFilter(entry_collectstatus, "=", (Object)collectStatus);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, model, fy, period, collectstatus, modifydate, modifier, endtime,scenario", (QFilter[])new QFilter[]{modelFilter, statusFilter});
        ArrayList<DynamicObject> needResetRecs = new ArrayList<DynamicObject>();
        for (DynamicObject dynObj : dynObjs) {
            if (dynObj.getDate(entry_modifydate) == null) continue;
            long startTime = dynObj.getDate(entry_modifydate).getTime();
            long spend = new Date().getTime() - startTime;
            if (overTime > spend) continue;
            needResetRecs.add(dynObj);
        }
        for (DynamicObject dynObj : needResetRecs) {
            dynObj.set(entry_collectstatus, (Object)CollectStatusEnum.FAIL.getValue());
            dynObj.set(entry_modifydate, (Object)(dynObj.getDate(entry_modifydate) == null ? new Date() : dynObj.getDate(entry_modifydate)));
            dynObj.set("endtime", (Object)dynObj.getDate(entry_modifydate));
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.save((DynamicObject[])needResetRecs.toArray(new DynamicObject[0]), (OperateOption)op);
        this.writeExecuteLogs(needResetRecs.toArray(new DynamicObject[0]), errorInfo);
    }

    private void writeExecuteLogs(DynamicObject[] recDyns, String errorMsg) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        for (DynamicObject recDyn : recDyns) {
            DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
            dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyObj.set("model", (Object)recDyn.getDynamicObject("model").getLong("id"));
            dyObj.set("fy", (Object)recDyn.getDynamicObject("fy").getLong("id"));
            dyObj.set("period", (Object)recDyn.getDynamicObject("period").getLong("id"));
            dyObj.set("scenario", (Object)recDyn.getDynamicObject("scenario").getLong("id"));
            dyObj.set("currency", (Object)((DynamicObject)this.getModel().getValue("currency")).getLong("id"));
            dyObj.set(entry_org, (Object)(recDyn.getLong("org_id") == 0L ? recDyn.getLong(entry_org) : recDyn.getLong("org_id")));
            dyObj.set("scheme", (Object)(recDyn.getLong("scheme_id") == 0L ? recDyn.getLong("scheme") : recDyn.getLong("scheme_id")));
            dyObj.set("dimmembers", (Object)" ");
            dyObj.set("datafrom", (Object)" ");
            dyObj.set("error", (Object)errorMsg);
            dyObj.set("result", (Object)" ");
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collectorstate", (Object)CollectStatusEnum.FAIL.getValue());
            dyObj.set("collecttime", (Object)TimeServiceHelper.now());
            dyObj.set("executerec", (Object)recDyn.getLong("id"));
            dyObj.set(entry_step, (Object)"A");
            logs.add(dyObj);
        }
        SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
    }

    private Set<Long> filterByScenario(List<Long> schemeIds, String scenarioNum) {
        HashSet<Long> result = new HashSet<Long>();
        Long dimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.SCENARIO.getNumber());
        Pair dimAndSetPair = IntegrationUtil.getDimAndSetPair(schemeIds, (Long)dimId);
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("dimmapid", "in", dimAndSetPair.p1);
        ArrayList<String> scenarioNumList = new ArrayList<String>();
        scenarioNumList.add(scenarioNum);
        scenarioNumList.add(ALL);
        qfb.add("targmembnumber", "in", scenarioNumList);
        DynamicObjectCollection singMaps = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"schemeid,dimmapid, srcmembnumber,targmembnumber", (QFilter[])qfb.toArray());
        ArrayList loadAll = new ArrayList(16);
        loadAll.addAll(singMaps);
        IntegrationUtil.addPubMapping(loadAll, (Map)((Map)dimAndSetPair.p2), scenarioNumList, (String)DimTypesEnum.SCENARIO.getNumber());
        loadAll.forEach(item -> result.add(item.getLong("schemeid")));
        qfb.clear();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.isdimmaptargdefval.targetmemnum", "=", (Object)scenarioNum);
        DynamicObjectCollection dimMaps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,scheme", (QFilter[])qfb.toArray());
        dimMaps.forEach(item -> result.add(item.getLong("scheme")));
        return result;
    }

    public StringBuffer calculate(Long spend) {
        long mi = spend % 1000L;
        long se = spend / 1000L % 60L;
        long min = spend / 1000L / 60L % 60L;
        long hour = spend / 1000L / 60L / 60L;
        StringBuffer sb = new StringBuffer();
        if (hour > 0L) {
            sb.append(hour).append(ResManager.loadKDString((String)" \u5c0f\u65f6 ", (String)"ISSchemeDataCollectPlugin2_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (min > 0L) {
            sb.append(min).append(ResManager.loadKDString((String)" \u5206\u949f ", (String)"ISSchemeDataCollectPlugin2_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (se > 0L) {
            sb.append(se).append(ResManager.loadKDString((String)" \u79d2 ", (String)"ISSchemeDataCollectPlugin2_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (mi > 0L) {
            sb.append(mi).append(ResManager.loadKDString((String)" \u6beb\u79d2 ", (String)"ISSchemeDataCollectPlugin2_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)sb.toString())) {
            sb.append(ResManager.loadKDString((String)"0 \u79d2", (String)"ISSchemeDataCollectPlugin2_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return sb;
    }

    private Table<Long, Long, DynamicObject> geneOrgEntity(Long focusNodeId) {
        DynamicObject[] excutors;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(this.getFilter());
        qfBuilder.add(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{true}));
        qfBuilder.add(QFilter.of((String)"scheme.templatecatalog.type = ?", (Object[])new Object[]{"1"}));
        qfBuilder.add(new QFilter("scheme.id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId())));
        qfBuilder.add(QFilter.of((String)"scheme.istarg.number = ?", (Object[])new Object[]{"NG"}));
        String selectProperties = "scheme,entity.id,entity.number,property,propertyvalue,propertyvalue.id,propertyvalue.number,range,applytype";
        DynamicObjectCollection schemeAssignEntitys = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray(), (String)"scheme,applytype desc");
        HashBasedTable schemeOrgIdMaps = HashBasedTable.create();
        DynamicObject orgTemp = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,isleaf,dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)focusNodeId)});
        boolean allSub = (Boolean)this.getModel().getValue("allsub");
        HashMap<String, Long> orgRangeId = new HashMap<String, Long>(16);
        HashSet<String> shareOrgs = new HashSet<String>(16);
        if (!orgTemp.getBoolean("isleaf") && allSub) {
            AbstractTreeNode<Object> root = this.getOrgTree(this.getModelId(), this.getPageCache().get(CACHE_SHOW_ORG_TYPE));
            ITreeNode treeNode = root.getTreeNode(Long.toString(focusNodeId), 999);
            this.handleALLNodes((ITreeNode<Object>)treeNode, orgRangeId, shareOrgs);
        }
        orgRangeId.put(orgTemp.getString("number"), orgTemp.getLong("id"));
        if (orgRangeId.size() == 1) {
            shareOrgs.add(orgTemp.getString("number"));
        }
        this.reSetShareOrgs(orgRangeId, shareOrgs);
        ArrayList orgNums = new ArrayList(orgRangeId.keySet());
        orgNums.add(ALL);
        ArrayList schemes = new ArrayList(schemeAssignEntitys.size());
        schemeAssignEntitys.forEach(s -> schemes.add(s.getLong("scheme")));
        Pair orgMember2Pair = IntegrationUtil.filterSingleMapMems((Long)orgTemp.getLong("dimension"), schemes, orgNums);
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            Long entity = schemeAssign.getLong("entity.id");
            Long mId = 0L;
            String mnumber = null;
            boolean isCustom = false;
            if (entity == 0L) {
                isCustom = true;
                Long propertyvalue = schemeAssign.getLong("propertyvalue.id");
                if (propertyvalue == 0L) continue;
                mId = propertyvalue;
                mnumber = schemeAssign.getString("propertyvalue.number");
            } else {
                mId = entity;
                mnumber = schemeAssign.getString("entity.number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", mId, mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)this.getModelId());
            String applytype = schemeAssign.getString("applytype");
            Long schemeid = schemeAssign.getLong("scheme");
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeid)});
            rangItem.matchItems(arg_0 -> ISSchemeDataCollectPlugin2.lambda$geneOrgEntity$25(orgRangeId, schemeid, orgMember2Pair, applytype, (Table)schemeOrgIdMaps, scheme, arg_0));
        }
        selectProperties = "scheme,org,checkstatus,collectstatus,step,batch,modifier,modifydate,endtime,optime,exeip";
        qfBuilder.clear();
        qfBuilder.add(this.getMembFilter());
        qfBuilder.add(new QFilter("scheme", "in", (Object)schemeOrgIdMaps.rowKeySet()));
        qfBuilder.add(new QFilter(entry_org, "in", (Object)schemeOrgIdMaps.columnKeySet()));
        for (DynamicObject excutor : excutors = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)selectProperties, (QFilter[])qfBuilder.toArray())) {
            Long orgId;
            Long schemeId = excutor.getLong("scheme.id");
            if (!schemeOrgIdMaps.contains((Object)schemeId, (Object)(orgId = Long.valueOf(excutor.getLong("org.id"))))) continue;
            schemeOrgIdMaps.put((Object)schemeId, (Object)orgId, (Object)excutor);
        }
        return schemeOrgIdMaps;
    }

    private void reSetShareOrgs(Map<String, Long> orgRangeId, Set<String> shareOrgs) {
        if (shareOrgs.size() > 0) {
            QFBuilder qfBuilder1 = new QFBuilder("model", "=", (Object)this.getModelId());
            qfBuilder1.add("number", "in", shareOrgs);
            qfBuilder1.add("storagetype", "in", (Object)StorageTypeEnum.STORAGE.index);
            DynamicObjectCollection baseOrgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])qfBuilder1.toArray());
            baseOrgs.stream().forEach(d -> orgRangeId.put(d.getString("number"), d.getLong("id")));
        }
    }

    private void handleALLNodes(ITreeNode<Object> node, Map<String, Long> orgRangeId, Set<String> shareOrgs) {
        OrgTreeNode orgNode = (OrgTreeNode)node;
        orgRangeId.put(((OrgTreeNode)node).getNumber(), LongUtil.toLong((Object)node.getId()));
        if (!StorageTypeEnum.STORAGE.index.equals(orgNode.getStoragetype())) {
            shareOrgs.add(orgNode.getNumber());
        }
        if (!node.isLeaf()) {
            node.getChildren().forEach(children -> this.handleALLNodes((ITreeNode<Object>)children, orgRangeId, shareOrgs));
        }
    }

    private Table<Long, Long, DynamicObject> geneSchemeEntity(Long focusNodeId) {
        DynamicObject[] excutors;
        HashBasedTable schemeOrgIdMaps;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(this.getFilter());
        QFilter qf = new QFilter("templatecatalog", "=", (Object)focusNodeId);
        qf.and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{this.getFilter(), qf});
        if (schemes != null && schemes.size() > 0) {
            ArrayList<Long> schemeids = new ArrayList<Long>(schemes.size());
            for (DynamicObject scheme : schemes) {
                schemeids.add(scheme.getLong("id"));
            }
            qfBuilder.add("scheme", "in", schemeids);
        } else {
            qfBuilder.add(QFilter.of((String)"scheme = ?", (Object[])new Object[]{focusNodeId}));
        }
        String selectProperties = "scheme,scheme.number,entity,entity.number,property,propertyvalue,propertyvalue.id,propertyvalue.number,range,applytype";
        DynamicObjectCollection schemeAssignEntitys = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray(), (String)"scheme, applytype desc");
        HashMap<String, Long> orgRangeId = new HashMap<String, Long>();
        HashSet<String> shareOrgs = new HashSet<String>(16);
        AbstractTreeNode<Object> root = this.getOrgTree(this.getModelId(), this.getPageCache().get(CACHE_SHOW_ORG_TYPE));
        this.handleALLNodes((ITreeNode<Object>)root, (Map<String, Long>)orgRangeId, (Set<String>)shareOrgs);
        this.reSetShareOrgs(orgRangeId, shareOrgs);
        HashBasedTable tempSchemeOrgIdMaps = schemeOrgIdMaps = HashBasedTable.create();
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            Long entity = schemeAssign.getLong("entity");
            Long schemeId = schemeAssign.getLong("scheme");
            if (schemeId == 0L) continue;
            Long mId = 0L;
            Object mnumber = null;
            boolean isCustom = false;
            if (entity == 0L) {
                isCustom = true;
                mId = schemeAssign.getLong("propertyvalue.id");
                mnumber = schemeAssign.getString("propertyvalue.number");
            } else {
                mId = entity;
                mnumber = schemeAssign.getString("entity.number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", mId, (String)mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)this.getModelId());
            String applytype = schemeAssign.getString("applytype");
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
            rangItem.matchItems(arg_0 -> ISSchemeDataCollectPlugin2.lambda$geneSchemeEntity$28(orgRangeId, applytype, (Table)tempSchemeOrgIdMaps, schemeId, scheme, arg_0));
        }
        Map<Long, String> shareOrg = orgRangeId.entrySet().stream().filter(arg_0 -> ISSchemeDataCollectPlugin2.lambda$geneSchemeEntity$29((Table)tempSchemeOrgIdMaps, arg_0)).collect(Collectors.toMap(k -> (Long)k.getValue(), v -> (String)v.getKey(), (v1, v2) -> v1));
        ArrayList<String> orgNums = new ArrayList<String>(shareOrg.values());
        orgNums.add(ALL);
        List schemeIds = schemeAssignEntitys.stream().map(s -> s.getLong("scheme")).collect(Collectors.toList());
        Pair orgMember2Pair = IntegrationUtil.filterSingleMapMems((Long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.ENTITY.getNumber()), schemeIds, orgNums);
        HashBasedTable result = HashBasedTable.create();
        for (Table.Cell c : schemeOrgIdMaps.cellSet()) {
            String orgNum = shareOrg.get(c.getColumnKey());
            if ((((Map)orgMember2Pair.p1).get(orgNum) == null || !((List)((Map)orgMember2Pair.p1).get(orgNum)).contains(c.getRowKey())) && (((Map)orgMember2Pair.p1).get(ALL) == null || !((List)((Map)orgMember2Pair.p1).get(ALL)).contains(c.getRowKey())) || ((Map)orgMember2Pair.p2).get(orgNum) != null && ((List)((Map)orgMember2Pair.p2).get(orgNum)).contains(c.getRowKey())) continue;
            result.put(c.getRowKey(), c.getColumnKey(), c.getValue());
        }
        schemeOrgIdMaps = result;
        selectProperties = "org, scheme,checkstatus,collectstatus,step,batch,modifier,modifydate,endtime,optime,exeip";
        qfBuilder.clear();
        qfBuilder.add(this.getMembFilter());
        qfBuilder.add(new QFilter("scheme", "in", (Object)schemeOrgIdMaps.rowKeySet()));
        qfBuilder.add(new QFilter(entry_org, "in", (Object)schemeOrgIdMaps.columnKeySet()));
        for (DynamicObject excutor : excutors = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)selectProperties, (QFilter[])qfBuilder.toArray())) {
            Long orgId;
            Long schemeId = excutor.getLong("scheme.id");
            if (!schemeOrgIdMaps.contains((Object)schemeId, (Object)(orgId = Long.valueOf(excutor.getLong("org.id"))))) continue;
            schemeOrgIdMaps.put((Object)schemeId, (Object)orgId, (Object)excutor);
        }
        return schemeOrgIdMaps;
    }

    private boolean validateConditionNoTip() {
        return this.getModel().getValue("model") != null;
    }

    private boolean valicateMembConditionNoTip() {
        return this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null && this.getModel().getValue("currency") != null;
    }

    private boolean validate() {
        if (this.getModel().getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ISSchemeDataCollectPlugin2_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("scenario") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"ISSchemeDataCollectPlugin2_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("year") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"ISSchemeDataCollectPlugin2_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("period") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ISSchemeDataCollectPlugin2_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("currency") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"ISSchemeDataCollectPlugin2_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setFormId("bcm_batchintegrate");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchconfirm"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.equals("batchconfirm")) {
            if (returnData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6279\u6b21\u4fe1\u606f\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"ISSchemeDataCollectPlugin2_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                HashSet<String> batchName = new HashSet<String>();
                for (String s : ((String)returnData).split(",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                    batchName.add(s);
                }
                this.doCollect(true, false, batchName);
            }
        }
        if (actionId.equals("taskcloseback")) {
            this.refreshLeftTree(this.getModelId());
            this.refreshEntryEntity();
        }
        if (actionId.equals("bcm_acquisitionmode")) {
            if (returnData == Boolean.FALSE || returnData == null) {
                this.getPageCache().remove("template");
                return;
            }
            Boolean isSync = Boolean.TRUE;
            Map dataMap = (Map)returnData;
            Integer modeType = (Integer)dataMap.get("modeType");
            if (modeType == 1) {
                isSync = Boolean.TRUE;
            } else if (modeType == 2) {
                isSync = Boolean.FALSE;
            }
            IPageCache pageCache = this.getPageCache();
            boolean isEntryIntegrate = Boolean.parseBoolean(pageCache.get("isEntryIntegrate"));
            String batchNameStr = pageCache.get("batchName");
            Set batchName = batchNameStr == null ? null : (Set)ObjectSerialUtil.deSerializedBytes((String)batchNameStr);
            this.removeCollectParamCache();
            String template = pageCache.get("template");
            List selectTemplate = template == null ? null : (List)ObjectSerialUtil.deSerializedBytes((String)template);
            pageCache.remove("template");
            DynamicObjectCollection selectRowsData = this.getSelectRowsData();
            this.collect(isSync, isEntryIntegrate, batchName, selectTemplate, selectRowsData);
        }
        if ("bcm_templateselect".equals(actionId) && returnData != null) {
            this.getPageCache().put("template", ObjectSerialUtil.toByteSerialized((Object)returnData));
            this.showAcquisitionModeForm();
        }
        if ("taskcloseback".equals(actionId)) {
            this.taskCloseBack(returnData);
        }
    }

    private void taskCloseBack(Object returnData) {
        Map dataMap;
        Map taskinfoMap;
        String dataMapStr;
        String taskinfoStr;
        Map returnMap = (Map)returnData;
        if (returnMap != null && (taskinfoStr = (String)returnMap.get("taskinfo")) != null && (dataMapStr = (String)(taskinfoMap = (Map)JSONObject.parseObject((String)taskinfoStr, Map.class)).get("data")) != null && (dataMap = (Map)JSONObject.parseObject((String)dataMapStr, Map.class)).get("msg") != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u8f83\u957f\uff0c\u5df2\u8fdb\u5165\u540e\u53f0\u6267\u884c\u4e2d\u3002\u8bf7\u67e5\u770b\u5177\u4f53\u65e5\u5fd7\u4ee5\u4e86\u89e3\u6267\u884c\u60c5\u51b5\u3002", (String)"ISSchemeDataCollectPlugin2_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.refreshEntryEntity();
    }

    private boolean existMiddleScheme() {
        int[] selectedRows = this.getSelectedEntry();
        if (selectedRows == null || selectedRows.length == 0) {
            return false;
        }
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObjectCollection col = new DynamicObjectCollection();
        for (int row : selectedRows) {
            col.add(dyncol.get(row));
        }
        Object object = col.iterator();
        while (object.hasNext()) {
            DynamicObject row = (DynamicObject)object.next();
            DynamicObject scheme = row.getDynamicObject(entry_scheme);
            if (!"MIDLIB".equals(scheme.getString("issrc.number"))) continue;
            return true;
        }
        return false;
    }

    private void batchClearData() {
        if (!this.validate()) {
            return;
        }
        TreeView orgTree = (TreeView)this.getControl(treeview_entity);
        Map node = orgTree.getTreeState().getFocusNode();
        String orgId = node.get("id").toString();
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ISSchemeDataCollectPlugin2_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Set<String>> curr_org = new HashMap<String, Set<String>>(16);
        boolean allChild = (Boolean)this.getModel().getValue("allsub");
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgId), (String)"bcm_entitymembertree");
        if (allChild) {
            DynamicObject[] children;
            QFBuilder builder = new QFBuilder("model", "=", (Object)model.getLong("id"));
            builder.add("cslscheme", "=", (Object)((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id"));
            builder.add("longnumber", "like", (Object)(org.getString("longnumber") + "%"));
            builder.add("isleaf", "=", (Object)true);
            for (DynamicObject dot : children = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,number,currency", (QFilter[])builder.toArray())) {
                this.addEntry2Map(curr_org, dot);
            }
        } else {
            if (!org.getBoolean("isleaf")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u53ef\u6e05\u9664\u5408\u5e76\u8282\u70b9\u7684\u6570\u636e\u3002", (String)"ISSchemeDataCollectPlugin2_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.addEntry2Map(curr_org, org);
        }
        String currency = ((DynamicObject)this.getModel().getValue("currency")).getString("number");
        if (currency.equals("EC")) {
            for (Map.Entry key : curr_org.entrySet()) {
                if (((Set)key.getValue()).isEmpty()) continue;
                this.runClearScript(model.getString("number"), model.getLong("id"), (Set)key.getValue(), (String)key.getKey());
            }
        } else {
            HashSet<String> orgNums = new HashSet<String>(16);
            for (Map.Entry entry : curr_org.entrySet()) {
                orgNums.addAll((Collection)entry.getValue());
            }
            if (!orgNums.isEmpty()) {
                this.runClearScript(model.getString("number"), model.getLong("id"), orgNums, currency);
            }
        }
        if (allChild) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\uff0c\u5408\u5e76\u8282\u70b9\u7684\u6570\u636e\u4e0d\u4f1a\u88ab\u6e05\u9664\u3002", (String)"ISSchemeDataCollectPlugin2_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\u3002", (String)"ISSchemeDataCollectPlugin2_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Set<String>> getResolveParam(Long modelId) {
        HashMap<String, Set<String>> resolveParams = new HashMap<String, Set<String>>(16);
        this.addDimenInfo2ResolveParam(resolveParams, "Process", "IRpt");
        this.addDimenInfo2ResolveParam(resolveParams, "AuditTrail", "EntityInput");
        this.addDimenInfo2ResolveParam(resolveParams, "Scenario", ((DynamicObject)this.getModel().getValue("scenario")).getString("number"));
        this.addDimenInfo2ResolveParam(resolveParams, "Year", ((DynamicObject)this.getModel().getValue("year")).getString("number"));
        this.addDimenInfo2ResolveParam(resolveParams, "Period", ((DynamicObject)this.getModel().getValue("period")).getString("number"));
        return resolveParams;
    }

    private void addScope2RunScript(Map<String, Set<String>> resolveParams, RunScriptBuilder run) {
        Map.Entry<String, Set<String>> scope = resolveParams.entrySet().iterator().next();
        String dimennum = scope.getKey();
        resolveParams.forEach((key, dimmemnums) -> {
            if (!key.equalsIgnoreCase((String)scope.getKey())) {
                run.addDimensionScope(key, dimmemnums.toArray(new String[0]));
            }
        });
        scope.getValue().forEach(dim -> {
            run.appendV(PairList.newWithParam((Object)dimennum, (Object)dim));
            run.appendEqualSign();
            run.appendStr(null);
            run.endRunExpress();
        });
    }

    private void addDimenInfo2ResolveParam(Map<String, Set<String>> resolveParams, String dimenNum, String ... memberNums) {
        HashSet<String> members = new HashSet<String>(Arrays.asList(memberNums));
        resolveParams.put(dimenNum, members);
    }

    private void addEntry2Map(Map<String, Set<String>> curr_org, DynamicObject dot) {
        if (!"Entity".equals(dot.getString("number"))) {
            String currency = dot.getString("currency.number");
            curr_org.computeIfAbsent(currency, k -> new HashSet(16));
            Set<String> orgNums = curr_org.get(currency);
            orgNums.add(dot.getString("number"));
        }
    }

    private void runClearScript(String modelNum, Long modelId, Set<String> orgNums, String currency) {
        RunScriptBuilder run = new RunScriptBuilder(modelNum);
        Map<String, Set<String>> resolveParams = this.getResolveParam(modelId);
        resolveParams.put("Entity", orgNums);
        this.addDimenInfo2ResolveParam(resolveParams, "Currency", currency);
        this.addScope2RunScript(resolveParams, run);
        run.runScript();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ("datacollectconfirm".equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            IPageCache pageCache = this.getPageCache();
            boolean isSync = Boolean.parseBoolean(pageCache.get("isSync"));
            boolean isEntryIntegrate = Boolean.parseBoolean(pageCache.get("isEntryIntegrate"));
            String batchNameStr = pageCache.get("batchName");
            Set batchName = batchNameStr == null ? null : (Set)ObjectSerialUtil.deSerializedBytes((String)batchNameStr);
            this.removeCollectParamCache();
            this.collect(isSync, isEntryIntegrate, batchName, null, this.getSelectRowsData());
        }
    }

    private DynamicObjectCollection getSelectRowsData() {
        int[] selectedRows = this.getSelectedEntry();
        DynamicObjectCollection allDc = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObjectCollection dc = new DynamicObjectCollection();
        for (int row : selectedRows) {
            dc.add(allDc.get(row));
        }
        return dc;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        int rowIndex = arg0.getRowIndex();
        DynamicObjectCollection allDc = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObject dynamicObject = (DynamicObject)allDc.get(rowIndex);
        Long exeid = dynamicObject.getLong(entry_exeid);
        this.actionCollectLog(exeid);
    }

    private static /* synthetic */ boolean lambda$geneSchemeEntity$29(Table tempSchemeOrgIdMaps, Map.Entry o) {
        return tempSchemeOrgIdMaps.columnKeySet().contains(o.getValue());
    }

    private static /* synthetic */ void lambda$geneSchemeEntity$28(Map orgRangeId, String applytype, Table tempSchemeOrgIdMaps, Long schemeId, DynamicObject scheme, SimpleItem c) {
        if (orgRangeId.containsKey(c.number)) {
            if ("0".equals(applytype)) {
                tempSchemeOrgIdMaps.remove((Object)schemeId, orgRangeId.get(c.number));
            } else {
                tempSchemeOrgIdMaps.put((Object)schemeId, orgRangeId.get(c.number), (Object)scheme);
            }
        }
    }

    private static /* synthetic */ void lambda$geneOrgEntity$25(Map orgRangeId, Long schemeid, Pair orgMember2Pair, String applytype, Table schemeOrgIdMaps, DynamicObject scheme, SimpleItem c) {
        if (orgRangeId.containsKey(c.number) && schemeid != 0L && (((Map)orgMember2Pair.p1).get(c.number) != null && ((List)((Map)orgMember2Pair.p1).get(c.number)).contains(schemeid) || ((Map)orgMember2Pair.p1).get(ALL) != null && ((List)((Map)orgMember2Pair.p1).get(ALL)).contains(schemeid)) && (((Map)orgMember2Pair.p2).get(c.number) == null || !((List)((Map)orgMember2Pair.p2).get(c.number)).contains(schemeid))) {
            if ("0".equals(applytype)) {
                schemeOrgIdMaps.remove((Object)schemeid, orgRangeId.get(c.number));
            } else {
                schemeOrgIdMaps.put((Object)schemeid, orgRangeId.get(c.number), (Object)scheme);
            }
        }
    }
}

