/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.IOperationLog;

public class ISSchemeEditPlugin
extends AbstractBasePlugIn
implements UploadListener,
IOperationLog,
BeforeF7SelectListener {
    private static final String IS_SRC = "issrc";
    private static final String IS_TAG = "istarg";
    private static final String MODEL = "model";
    private static final String TEMPLATECATALOG = "templatecatalog";
    private static final String ISSCHEMEID = "isscheme";
    private static final String MIDDLELIB = "middlelib";
    private static final String LOCATION = "location";
    private static final String MULTICURRENCY = "multicurrency";
    private static final String ONLYNOTICEFAILED = "onlynoticefailed";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String ATTACHMENT_SAVE_STATUS = "attachment_save_status";
    private static final String FALSE_STR = "false";
    private static final String JQ = "JQ";
    private static final String ISSRCMODEL = "issrcmodel";
    private static final String SYNBASE = "synbase";
    private static final String CUSTOMSERVICE = "customservice";
    private static final String EXTENDSMODEL = "extendsmodel";
    private static final String EXTENDSTABLE = "extendstable";
    private static final String SERVICEFLOW = "serviceflow";
    private static final String USEDC = "usedc";
    private static final String CALCULATE = "calculate";
    private static final String FORMATENUM = "formatenum";
    private static final String COMASSIST = "comassist";
    private static final String PERM_CLASS = "permclass";

    public static String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ISSchemeEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        BasedataEdit src = (BasedataEdit)this.getControl(IS_SRC);
        BasedataEdit TAG = (BasedataEdit)this.getControl(IS_TAG);
        src.setMustInput(true);
        TAG.setMustInput(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        panel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{"cancel"});
        BasedataEdit issrcmodel = (BasedataEdit)this.getControl(ISSRCMODEL);
        issrcmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit extendsmodel = (BasedataEdit)this.getControl(EXTENDSMODEL);
        extendsmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit issrc = (BasedataEdit)this.getControl(IS_SRC);
        issrc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit permClass = (BasedataEdit)this.getControl(PERM_CLASS);
        if (permClass != null) {
            Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)permClass, (Object)modelId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object id = this.getModel().getValue(ID);
        if (id == null || id.toString().equals("0")) {
            this.getView().close();
        } else {
            boolean isRight = this.checkAttach(null);
            if (!isRight) {
                return;
            }
            String saveStatus = this.getPageCache().get(ATTACHMENT_SAVE_STATUS);
            if (FALSE_STR.equals(saveStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u6709\u4fee\u6539\uff0c\u8bf7\u4fdd\u5b58\u3002", (String)"ISSchemeListPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map == null || !map.containsKey(TEMPLATECATALOG)) {
            return;
        }
        this.getModel().setValue(MODEL, map.get("KEY_MODEL_ID"));
        JSONObject obj = JSONObject.parseObject((String)map.get(TEMPLATECATALOG).toString());
        String catalogId = obj.getString(ID);
        this.getModel().setValue(TEMPLATECATALOG, (Object)catalogId);
        this.getModel().setValue(EFFECTIVEDATE, (Object)EntityVersioningUtil.getModelBeginDate(map.get("KEY_MODEL_ID")));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MIDDLELIB, IS_TAG});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, MIDDLELIB, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, FORMATENUM, COMASSIST});
        if (!ConfigServiceHelper.isHwApp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LOCATION});
        }
        this.getModel().setDataChanged(false);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(map.get("KEY_MODEL_ID")));
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            DynamicObject perm;
            String issrc = ((DynamicObject)this.getModel().getValue(IS_SRC)).getString(NUMBER);
            boolean isExtendSrc = IntegrateProductEnum.XExtendProduct.getNumber().equals(issrc);
            if (JQ.equals(issrc) || "EXCEL".equals(issrc) || "JQONLINE".equals(issrc)) {
                this.getPageCache().put(IS_SRC, JQ);
                if ("JQONLINE".equals(issrc)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP});
                }
                this.getPageCache().put(IS_SRC, issrc);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSCHEMEID, MIDDLELIB, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, COMASSIST, ONLYNOTICEFAILED});
                this.getView().setVisible(Boolean.valueOf(JQ.equals(issrc)), new String[]{FORMATENUM});
                this.getView().setVisible(Boolean.valueOf("EXCEL".equals(issrc)), new String[]{CALCULATE});
                if ("EXCEL".equals(issrc)) {
                    this.getPageCache().put(IS_SRC, "EXCEL");
                }
            } else if (IntegrateProductEnum.NGBGMODELProduct.getNumber().equals(issrc) || IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(issrc) || IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(issrc)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSCHEMEID, MIDDLELIB, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, FORMATENUM, COMASSIST});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ISSRCMODEL});
            } else if (isExtendSrc) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MIDDLELIB, ISSRCMODEL, ATTACHMENTPANELAP, SYNBASE, CUSTOMSERVICE, ISSCHEMEID, MULTICURRENCY, USEDC, FORMATENUM, CALCULATE, COMASSIST});
            } else if (IntegrateProductEnum.EASREPProduct.getNumber().equals(issrc)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MIDDLELIB, MULTICURRENCY, USEDC, FORMATENUM, COMASSIST, ONLYNOTICEFAILED});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID});
            } else if ("EASACC".equals(issrc)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, MIDDLELIB, MULTICURRENCY, FORMATENUM, COMASSIST});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, USEDC, SERVICEFLOW});
            } else if ("NGACC".equals(issrc)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MIDDLELIB, ISSCHEMEID, USEDC, FORMATENUM});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{MULTICURRENCY, COMASSIST});
            } else if ("NGACC-C".equals(issrc)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MIDDLELIB, ISSCHEMEID, USEDC, FORMATENUM, MULTICURRENCY, SYNBASE, COMASSIST});
            } else if ("MIDLIB".equals(issrc)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, USEDC, FORMATENUM, COMASSIST});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, MIDDLELIB, SERVICEFLOW, MULTICURRENCY});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENTPANELAP, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, FORMATENUM, COMASSIST});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, MIDDLELIB});
            }
            String is_tag = ((DynamicObject)this.getModel().getValue(IS_TAG)).getString(NUMBER);
            this.getView().setVisible(Boolean.valueOf(IntegrateProductEnum.NGProduct.getNumber().equals(is_tag) && !isExtendSrc), new String[]{SYNBASE});
            BigDecimal versionnumber = (BigDecimal)this.getModel().getValue("versionnumber");
            IDataModel dataModel = this.getModel();
            dataModel.setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(versionnumber.floatValue())));
            this.getModel().setDataChanged(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, IS_SRC, IS_TAG, ISSCHEMEID, MIDDLELIB});
            if (!ConfigServiceHelper.isHwApp()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LOCATION});
            }
            if ((perm = PermClassEntityHelper.getPermissionClassEntity((String)"bcm_isscheme", (Long)((Long)this.getModel().getValue(ID)), (Object)this.getModel().getValue("model_id"))) != null) {
                this.getModel().setValue(PERM_CLASS, perm.get(PERM_CLASS));
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "issrc": {
                List<String> list = Arrays.asList("MIDLIB", "EASREP", "EASACC", JQ, "JQONLINE", "EXCEL", IntegrateProductEnum.NGBGMODELProduct.getNumber(), IntegrateProductEnum.NGCMMODELProduct.getNumber(), IntegrateProductEnum.NGFRMODELProduct.getNumber(), IntegrateProductEnum.XExtendProduct.getNumber());
                if (newValue != null) {
                    DynamicObject isSrc = (DynamicObject)newValue;
                    String number = isSrc.getString(NUMBER);
                    if (JQ.equals(number) || "EXCEL".equals(number) || "JQONLINE".equals(number)) {
                        boolean isjqOnline = "JQONLINE".equals(number);
                        this.getView().setVisible(Boolean.valueOf(!isjqOnline), new String[]{ATTACHMENTPANELAP});
                        this.getView().setVisible(Boolean.valueOf(!isjqOnline), new String[]{SYNBASE});
                        this.getView().setVisible(Boolean.valueOf("EXCEL".equals(number)), new String[]{CALCULATE});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSCHEMEID, MIDDLELIB, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, COMASSIST, ISSRCMODEL, ONLYNOTICEFAILED});
                    } else if (IntegrateProductEnum.NGBGMODELProduct.getNumber().equals(number) || IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(number) || IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(number)) {
                        this.setControlAttr(number);
                    } else if (IntegrateProductEnum.XExtendProduct.getNumber().equals(number)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{MIDDLELIB, ISSRCMODEL, ATTACHMENTPANELAP, SYNBASE, CUSTOMSERVICE, ISSCHEMEID, MULTICURRENCY, USEDC, CALCULATE, COMASSIST});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, ONLYNOTICEFAILED});
                    } else if ("NGACC".equals(number)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, ISSCHEMEID, USEDC});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{MIDDLELIB, MULTICURRENCY, COMASSIST, CALCULATE, ONLYNOTICEFAILED});
                    } else if ("NGACC-C".equals(number)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, ISSCHEMEID, USEDC, MULTICURRENCY, SYNBASE, COMASSIST});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{MIDDLELIB, CALCULATE, ONLYNOTICEFAILED});
                    } else if ("EASACC".equals(number)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, MULTICURRENCY, COMASSIST});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, MIDDLELIB, USEDC, SERVICEFLOW, CALCULATE, ONLYNOTICEFAILED});
                    } else if ("MIDLIB".equals(number)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, USEDC, COMASSIST});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, MIDDLELIB, SERVICEFLOW, CALCULATE, ONLYNOTICEFAILED, MULTICURRENCY});
                    } else if ("EASREP".equals(number)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, COMASSIST, ONLYNOTICEFAILED});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, MIDDLELIB});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENTPANELAP, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, COMASSIST});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID, MIDDLELIB, ONLYNOTICEFAILED});
                    }
                    this.getView().setVisible(Boolean.valueOf(JQ.equals(number)), new String[]{FORMATENUM});
                    this.getPageCache().put(IS_SRC, number);
                    if (list.contains(number)) {
                        this.getModel().setValue(IS_TAG, (Object)this.getISTarget("NG"));
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{IS_TAG});
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{ISSCHEMEID});
                    } else if ("NGACC".equals(number) || "NGACC-C".equals(number)) {
                        this.getModel().setValue(IS_TAG, (Object)this.getISTarget("NG"));
                        this.getModel().setValue(ISSCHEMEID, null);
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{IS_TAG, ISSCHEMEID});
                    } else if ("NG".equals(number)) {
                        this.getModel().setValue(IS_TAG, (Object)this.getISTarget("EASREP"));
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{IS_TAG});
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{ISSCHEMEID});
                    }
                    this.getView().setVisible(Boolean.valueOf(IntegrateProductEnum.MIDLIBProduct.getNumber().equals(number)), new String[]{MIDDLELIB});
                } else {
                    this.getModel().setValue(IS_TAG, null);
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{IS_TAG});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{ISSCHEMEID});
                }
            }
            case "istarg": {
                OrmLocaleValue lan;
                Object srcDy = this.getModel().getValue(IS_SRC);
                if (srcDy != null && this.getModel().getValue(IS_TAG) != null && ((lan = (OrmLocaleValue)this.getModel().getValue(NAME)) == null || lan.getLocaleValue() == null || "".equals(lan.getLocaleValue().trim()))) {
                    this.getModel().setValue(NAME, (Object)(((DynamicObject)srcDy).getString(NAME) + "-" + ((DynamicObject)this.getModel().getValue(IS_TAG)).getString(NAME)));
                }
                if (srcDy != null && ((DynamicObject)srcDy).getString(NUMBER).equals("MIDLIB")) {
                    this.getModel().setValue(MIDDLELIB, (Object)this.getDefaultDataTable());
                    this.getView().updateView(MIDDLELIB);
                } else {
                    this.getModel().setValue(MIDDLELIB, null);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{MIDDLELIB});
                    this.getView().updateView(MIDDLELIB);
                }
                if (srcDy != null && ((DynamicObject)srcDy).getString(NUMBER).equals(IntegrateProductEnum.XExtendProduct.getNumber())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{SYNBASE});
                    break;
                }
                DynamicObject istarget = (DynamicObject)this.getModel().getValue(IS_TAG);
                this.getModel().setValue(SYNBASE, (Object)false);
                if (istarget != null && IntegrateProductEnum.NGProduct.getNumber().equals(istarget.getString(NUMBER))) {
                    boolean isJQOnline = false;
                    Object jqOnline = this.getModel().getValue(IS_SRC);
                    if (jqOnline != null && IntegrateProductEnum.JQONLINEProduct.getNumber().equals(((DynamicObject)jqOnline).getString(NUMBER))) break;
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SYNBASE});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SYNBASE});
                break;
            }
            case "extendsmodel": {
                DynamicObject extendsModel = (DynamicObject)newValue;
                if (extendsModel == null) break;
                String number = extendsModel.getString(NUMBER);
                number = number.length() > 19 ? "T_DS_".concat(number.substring(0, 19)) : "T_DS_".concat(number);
                this.getModel().setValue(EXTENDSTABLE, (Object)number);
            }
        }
    }

    private void setControlAttr(String number) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSCHEMEID, MIDDLELIB, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW, MULTICURRENCY, USEDC, COMASSIST, ATTACHMENTPANELAP});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSRCMODEL, CALCULATE, ONLYNOTICEFAILED});
        String appType = "3";
        if (IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(number)) {
            appType = "1";
        } else if (IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(number)) {
            appType = "2";
        }
        BasedataEdit itemclass = (BasedataEdit)this.getControl(ISSRCMODEL);
        QFilter qf = new QFilter("apptype", "=", (Object)appType);
        itemclass.setQFilter(qf);
    }

    private long getISTarget(String number) {
        DynamicObject middle = BusinessDataServiceHelper.loadSingle((String)"bcm_isproduct", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        if (middle != null) {
            return middle.getLong(ID);
        }
        return 0L;
    }

    private String getDefaultDataTable() {
        DynamicObject middle = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"bcm_dsmddata")});
        if (middle != null) {
            return middle.getString(ID);
        }
        return null;
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkSavePrem();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (args.getSource() instanceof Save && OperationStatus.ADDNEW.equals((Object)status)) {
            if (!(this.doNumberCheck().booleanValue() && this.checkNumber() && this.checkTargetAndSource() && this.checkIsscheme() && this.checkExtendsTable())) {
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Save && (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status))) {
            if (this.checkEnable()) {
                args.setCancel(true);
                return;
            }
            long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            long schemeId = (Long)this.getModel().getValue(ID);
            if (!DIIntegrationUtil.isWriteSchemePerm((long)schemeId, (long)modelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u53ea\u80fd\u67e5\u770b\uff0c\u6ca1\u6709\u4fee\u6539\u6743\u9650\u3002", (String)"ISSchemeEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                args.setCancel(true);
                return;
            }
        }
        if (this.getModel().getValue(EFFECTIVEDATE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ISSchemeEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            args.setCancel(true);
            return;
        }
        this.checkAttach(args);
        this.checkNgModelPassWord(args);
    }

    private Boolean doNumberCheck() {
        String newNumber = (String)this.getModel().getValue(NUMBER);
        String regEx = "^\\w+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(newNumber);
        if (!matcher.matches()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean checkEnable() {
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged && "1".equals(this.getModel().getValue("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ISSchemeEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return true;
        }
        return false;
    }

    private void checkNgModelPassWord(BeforeDoOperationEventArgs args) {
        block8: {
            String isSrc = this.getPageCache().get(IS_SRC);
            if ("NGCMMODEL".equals(isSrc) || "NGBGMODEL".equals(isSrc) || "NGFRMODEL".equals(isSrc)) {
                DynamicObject nomodel = (DynamicObject)this.getModel().getValue(ISSRCMODEL);
                if (nomodel == null) {
                    return;
                }
                nomodel = BusinessDataServiceHelper.loadSingle((Object)nomodel.getLong(ID), (String)"bcm_isngmodel");
                String accountId = RequestContext.get().getAccountId();
                if ("2".equals(nomodel.getString("usertype")) || !accountId.equals(nomodel.getString("datasource"))) {
                    String passWord = nomodel.getString("password");
                    String phoneNumber = nomodel.getString("phonenumber");
                    KAESEncrypter ken = new KAESEncrypter();
                    passWord = ken.decode(passWord);
                    try {
                        Long tdpdatacenterId = null;
                        Object tdpdatacenterObj = nomodel.get("tdpdatacenterid");
                        if (tdpdatacenterObj instanceof DynamicObject) {
                            tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong(ID);
                        } else if (tdpdatacenterObj instanceof Long) {
                            tdpdatacenterId = (Long)tdpdatacenterObj;
                        }
                        DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)tdpdatacenterId)});
                        DimMappingHelper.getLoginTokenWithPass((String)phoneNumber, (String)passWord, (DynamicObject)tdpdatacenter);
                    }
                    catch (Exception e) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6e90\u4f53\u7cfb\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6b64\u6e90\u4f53\u7cfb\u8d26\u53f7\u5bc6\u7801\u7b49\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"ISSchemeListPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                        if (args == null) break block8;
                        args.setCancel(true);
                    }
                }
            }
        }
    }

    private boolean checkAttach(BeforeDoOperationEventArgs args) {
        String isSrc = this.getPageCache().get(IS_SRC);
        if (JQ.equals(isSrc) || "EXCEL".equals(isSrc)) {
            AttachmentPanel atmp = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
            List attachmentData = atmp.getAttachmentData();
            int xmlAttachCount = 0;
            if (attachmentData.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"ISSchemeListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                if (args != null) {
                    args.setCancel(true);
                }
                return false;
            }
            for (Map attach : attachmentData) {
                if (attach.get(NAME).toString().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                    ++xmlAttachCount;
                }
                if (xmlAttachCount <= 1) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2axml\u6587\u4ef6\u3002", (String)"ISSchemeEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                if (args != null) {
                    args.setCancel(true);
                }
                return false;
            }
        }
        if ((IntegrateProductEnum.NGBGMODELProduct.getNumber().equals(isSrc) || IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(isSrc) || IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(isSrc)) && this.getModel().getValue(ISSRCMODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6e90\u4f53\u7cfb\u3002", (String)"ISSchemeListPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            if (args != null) {
                args.setCancel(true);
            }
            return false;
        }
        return true;
    }

    private boolean checkIsscheme() {
        DynamicObject isscheme = (DynamicObject)this.getModel().getValue(ISSCHEMEID);
        DynamicObject src = (DynamicObject)this.getModel().getValue(IS_SRC);
        if (src == null) {
            return true;
        }
        String srcNumber = src.getString(NUMBER);
        if (srcNumber.equals(IntegrateProductEnum.JQProduct.getNumber()) || srcNumber.equals(IntegrateProductEnum.EXCELIMPORTProduct.getNumber()) || srcNumber.equals(IntegrateProductEnum.NGBGMODELProduct.getNumber()) || srcNumber.equals(IntegrateProductEnum.NGCMMODELProduct.getNumber()) || srcNumber.equals(IntegrateProductEnum.NGFRMODELProduct.getNumber()) || IntegrateProductEnum.JQONLINEProduct.getNumber().equals(srcNumber) || srcNumber.equals(IntegrateProductEnum.XExtendProduct.getNumber())) {
            return true;
        }
        if (!src.getString(NUMBER).equals(IntegrateProductEnum.NGACCProduct.getNumber()) && !src.getString(NUMBER).equals(IntegrateProductEnum.NGACC_CProduct.getNumber()) && isscheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u96c6\u6210\u4e91\u65b9\u6848\u201d\u3002", (String)"ISSchemeEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    private void checkSavePrem() {
        long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int is = BcmBasePluginUtil.checkPermission(userId, modelId, AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId(), "bcm_isschemelist", "4715a0df000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(modelId))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"AbstractBaseFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkTargetAndSource() {
        DynamicObject tar = (DynamicObject)this.getModel().getValue(IS_TAG);
        DynamicObject src = (DynamicObject)this.getModel().getValue(IS_SRC);
        if (tar == null || src == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6216\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ISSchemeEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        if (tar.getString(ID).equals(src.getString(ID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u548c\u6e90\u4e0d\u80fd\u76f8\u540c\u3002", (String)"ISSchemeEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    private boolean checkNumber() {
        String newnumber = (String)this.getModel().getValue(NUMBER);
        QFBuilder qf = new QFBuilder(MODEL, "=", (Object)((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID));
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)NUMBER, (QFilter[])qf.toArray());
        if (schemes.stream().anyMatch(scheme -> newnumber.equalsIgnoreCase(scheme.getString(NUMBER)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ISSchemeEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkExtendsTable() {
        String srcNumber;
        DynamicObject srcDy = (DynamicObject)this.getModel().getValue(IS_SRC);
        if (srcDy != null && srcDy.getString(NUMBER).equals(IntegrateProductEnum.XExtendProduct.getNumber())) {
            if (this.getModel().getValue(EXTENDSMODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d3\u5c55\u6570\u636e\u6a21\u578b\u201d\u3002", (String)"ExtendDataModelSelectionPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return false;
            }
            String tableName = (String)this.getModel().getValue(EXTENDSTABLE);
            if (StringUtils.isBlank((CharSequence)tableName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)" \u8bf7\u586b\u5199\u201c\u6570\u636e\u8868\u201d\u3002", (String)"ISSchemeEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return false;
            }
            String regEx = "^[_A-Za-z0-9]+$";
            Matcher matcher = Pattern.compile(regEx).matcher(tableName);
            if (!matcher.matches()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u7f16\u7801\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"ISSchemeEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return false;
            }
            String realTableName = tableName.toUpperCase(Locale.ENGLISH);
            this.getModel().setValue(EXTENDSTABLE, (Object)realTableName);
            return true;
        }
        this.getModel().beginInit();
        this.getModel().setValue(EXTENDSMODEL, null);
        this.getModel().setValue(EXTENDSTABLE, null);
        String string = srcNumber = null == srcDy ? "" : srcDy.getString(NUMBER);
        if (!srcNumber.equals(IntegrateProductEnum.MIDLIBProduct.getNumber()) && !srcNumber.equals(IntegrateProductEnum.EASACCProduct.getNumber())) {
            this.getModel().setValue(SERVICEFLOW, null);
        }
        this.getModel().endInit();
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String issrc = ((DynamicObject)this.getModel().getValue(IS_SRC)).getString(NUMBER);
            if (JQ.equals(issrc) || "EXCEL".equals(issrc) || "JQONLINE".equals(issrc)) {
                Long schemeId = (Long)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0);
                DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
                scheme.set("enable", (Object)true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
            }
            this.getPageCache().put("modelid", ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID) + "");
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISSchemeEditPlugin_0", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f\u3002", "ISSchemeEditPlugin_25", "fi-bcm-formplugin", new String[]{this.getModel().getValue(NUMBER).toString() + " " + this.getModel().getValue(NAME).toString()}));
            IFormView parentView = this.getView().getParentView();
            if (parentView instanceof ListView) {
                this.getView().close();
            }
        }
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        String modelIdStr = this.getPageCache().get("modelid");
        if (modelIdStr == null) {
            return;
        }
        long modelId = Long.parseLong(modelIdStr);
        if (modelId == 0L) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
        if (EXTENDSMODEL.equals(key)) {
            ArrayList<QFilter> qfList = new ArrayList<QFilter>();
            qfList.add(new QFilter(MODEL, "=", (Object)modelId));
            qfList.add(new QFilter(NUMBER, "!=", (Object)"INTR_CONSOL"));
            qfList.add(new QFilter("enable", "=", (Object)"1"));
            evt.setCustomQFilters(qfList);
        } else if (IS_SRC.equals(key)) {
            ArrayList<QFilter> qfList = new ArrayList<QFilter>();
            qfList.add(new QFilter(NUMBER, "not like", (Object)"DI%"));
            qfList.add(new QFilter("isenable", "=", (Object)"1"));
            evt.setCustomQFilters(qfList);
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.getPageCache().put(ATTACHMENT_SAVE_STATUS, FALSE_STR);
    }

    public void remove(UploadEvent evt) {
        String issrc = ((DynamicObject)this.getModel().getValue(IS_SRC)).getString(NUMBER);
        if ((JQ.equals(issrc) || "EXCEL".equals(issrc)) && "1".equals((String)this.getModel().getValue("status"))) {
            evt.setCancel(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ISDimMappingV2Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(ATTACHMENT_SAVE_STATUS, FALSE_STR);
    }
}

