/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import org.apache.commons.lang3.StringUtils;

public class ISSchemeFloatAreaMappingPlugin
extends AbstractBaseFormPlugin {
    private static final String COMB_TEMP_FLOAT = "tempfloatarea";
    private static final String XML_SUB_CODE = "xmlsubcode";
    private static final String BTN_OK = "btnok";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        String floatMapping = (String)this.getFormCustomParam("floatmapping");
        String[] split = floatMapping.split(";");
        ArrayList<String> temp = new ArrayList<String>(split.length);
        ArrayList<String> xml = new ArrayList<String>(split.length);
        for (String str : split) {
            String[] split1 = str.split("\uff1a");
            temp.add(split1[0]);
            if (split1.length <= 1) continue;
            xml.add(split1[1]);
        }
        this.buildCombItem(this.getFormCustomParam("templateid"));
        if (split.length - 1 > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", split.length - 1);
        }
        this.getModel().beginInit();
        for (int i = 0; i < split.length; ++i) {
            this.getModel().setValue(COMB_TEMP_FLOAT, temp.get(i), i);
            if (xml.size() <= i) continue;
            this.getModel().setValue(XML_SUB_CODE, xml.get(i), i);
        }
        this.getModel().endInit();
    }

    private void buildCombItem(Object tempid) {
        DynamicObject temp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,data", (QFilter[])new QFilter[]{new QFilter("id", "=", tempid)});
        HashSet<ComboItem> tempComboIts = new HashSet<ComboItem>(16);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)temp.getString("data"));
        Set postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
        for (PositionInfo position : postionInfoSet) {
            for (BasePointInfo basePointInfo : position.getBasePoints()) {
                ComboItem tempComboIt = new ComboItem();
                tempComboIt.setCaption(new LocaleString(basePointInfo.getDynaRange()));
                tempComboIt.setValue(basePointInfo.getDynaRange());
                tempComboIts.add(tempComboIt);
            }
            ExtendInfo extendInfo = position.getExtendInfo();
            if (extendInfo == null) continue;
            ComboItem tempComboIt = new ComboItem();
            tempComboIt.setCaption(new LocaleString(position.getAreaRange()));
            tempComboIt.setValue(position.getAreaRange());
            tempComboIts.add(tempComboIt);
        }
        ComboEdit tempComboEdit = (ComboEdit)this.getControl(COMB_TEMP_FLOAT);
        tempComboEdit.setComboItems(new ArrayList(tempComboIts));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> mappings = new ArrayList<String>(entryentity.size());
            boolean chekFlag = true;
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dyn = (DynamicObject)entryentity.get(i);
                if (StringUtils.isEmpty((CharSequence)dyn.getString(COMB_TEMP_FLOAT))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u62a5\u8868\u6d6e\u52a8\u8303\u56f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7b2c%d\u884c\u3002", (String)"ISSchemeFloatAreaMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                }
                if (chekFlag) {
                    for (int j = i + 1; j < entryentity.size(); ++j) {
                        if (StringUtils.isEmpty((CharSequence)dyn.getString(XML_SUB_CODE)) || !dyn.getString(XML_SUB_CODE).equals(((DynamicObject)entryentity.get(j)).get(XML_SUB_CODE))) continue;
                        chekFlag = false;
                        this.getView().getParentView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201cXML\u5b50\u8868\u6807\u8bc6\u201d\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u7b2c%1$d\u884c\u548c\u7b2c%2$d\u884c\u3002", (String)"ISSchemeFloatAreaMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, j + 1));
                        break;
                    }
                }
                mappings.add(dyn.getString(COMB_TEMP_FLOAT) + "\uff1a" + dyn.getString(XML_SUB_CODE));
            }
            this.getView().returnDataToParent((Object)String.join((CharSequence)";", mappings));
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (XML_SUB_CODE.equals(e.getProperty().getName()) && !"".equals(e.getChangeSet()[0].getNewValue().toString())) {
            String newValue = e.getChangeSet()[0].getNewValue().toString();
            ArrayList subTbaleCds = (ArrayList)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("subTableCds")));
            if (subTbaleCds == null || !subTbaleCds.contains(newValue)) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"XML\u6587\u4ef6\u4e2d\u5bf9\u5e94\u7684\u62a5\u8868\u4e0d\u5305\u542b\u8fd9\u4e2a\u5b50\u8868\uff0c\u8bf7\u68c0\u67e5\u586b\u5199\u662f\u5426\u6b63\u786e\u3002", (String)"ISSchemeFloatAreaMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }
}

