/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class ISSchemeListSelfPlugin
extends AbstractBaseListPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object modelid = this.getView().getFormShowParameter().getCustomParam("modelid");
        if (modelid == null && this.getView().getParentView() != null) {
            modelid = this.getView().getParentView().getPageCache().get("KEY_MODEL_ID");
        }
        if (modelid != null) {
            this.getView().getPageCache().put("KEY_MODEL_ID", modelid.toString());
        }
    }

    public void packageData(PackageDataEvent e) {
        String key = ((ColumnDesc)e.getSource()).getKey();
        if ("importmodeid.importmode".equals(key)) {
            Map tarLackDimMember;
            if (Objects.isNull(e.getFormatValue()) || ISImpModeEnum.MERGEIMPORT.getCode().equals(e.getFormatValue())) {
                e.setFormatValue((Object)ISImpModeEnum.MERGEIMPORT.getName());
            } else if (ISImpModeEnum.REPLACEIMPORT.getCode().equals(e.getFormatValue()) && (tarLackDimMember = ISImportModeUtil.getTarLackDimMember((Long)e.getRowData().getLong("id"))) != null) {
                Map.Entry next = tarLackDimMember.entrySet().iterator().next();
                String members = ((Set)next.getValue()).stream().map(p -> (String)p.p2).collect(Collectors.joining("."));
                String showName = (String)((Pair)next.getKey()).p2 + "." + members;
                e.setFormatValue((Object)(ISImpModeEnum.REPLACEIMPORT.getName() + "," + showName));
            }
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection data = super.getData(arg0, arg1);
                boolean isOpenSum = false;
                for (DynamicObject dynamicObject : data) {
                    try {
                        dynamicObject.get("number");
                    }
                    catch (Exception e) {
                        isOpenSum = true;
                        break;
                    }
                }
                if (ISSchemeListSelfPlugin.this.getPageCache().get("showall") == null && !isOpenSum) {
                    TemplateUtil.filterVersionTemplateTree((Collection)data);
                }
                return data;
            }
        });
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (this.getModelId() != 0L) {
            super.billListHyperLinkClick(args);
        }
    }
}

