/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.scheme.handle.AttachmentHandle;

public class ISSchemeNewVersionPlugin
extends AbstractBaseFormPlugin {
    private static final String MODEL = "model";
    private static final String IS_SRC = "issrc";
    private static final String IS_TAG = "istarg";
    private static final String ISSCHEMEID = "isscheme";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String EXPIRINGDATE = "expiringdate";
    private static final String VERSIONNUM = "versionnum";
    private static final String DESCRIPTION = "description";
    private static final String MIDDLELIB = "middlelib";
    private static final String LOCATION = "location";
    private static final String ISSRCMODEL = "issrcmodel";
    private static final String ATTACHMENT = "attachment";
    private static final String SYNBASE = "synbase";
    private static final String EXTENDSMODEL = "extendsmodel";
    private static final String EXTENDSTABLE = "extendstable";
    private static final String SERVICEFLOW = "serviceflow";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("save", "cancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map.containsKey("newversion")) {
            this.setNewVersionData(map.get("newversion"), map.get("maxVersionNumber"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, IS_SRC, IS_TAG, ISSCHEMEID, VERSIONNUM, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            this.getModel().setDataChanged(false);
        }
        this.prepareCheckData();
    }

    private void prepareCheckData() {
        this.getPageCache().put(NAME, this.getModel().getValue(NAME) == null ? "" : ((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue());
        this.getPageCache().put(EFFECTIVEDATE, this.getModel().getValue(EFFECTIVEDATE) == null ? "" : ((Date)this.getModel().getValue(EFFECTIVEDATE)).getTime() + "");
        this.getPageCache().put(EXPIRINGDATE, this.getModel().getValue(EXPIRINGDATE) == null ? "" : ((Date)this.getModel().getValue(EXPIRINGDATE)).getTime() + "");
        this.getPageCache().put(DESCRIPTION, this.getModel().getValue(DESCRIPTION) == null ? "" : (String)this.getModel().getValue(DESCRIPTION));
    }

    private void setNewVersionData(Object oldSchemeId, Object maxVersionNumber) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)oldSchemeId, (String)"bcm_isscheme");
        this.getModel().setValue(MODEL, scheme.get(MODEL));
        this.getModel().setValue(NUMBER, (Object)scheme.getString(NUMBER));
        this.getModel().setValue(NAME, scheme.get(NAME));
        this.getModel().setValue("versionnumber", (Object)((BigDecimal)maxVersionNumber).add(new BigDecimal(1)));
        BigDecimal versionnumber = (BigDecimal)this.getModel().getValue("versionnumber");
        this.getModel().setValue(VERSIONNUM, (Object)String.format("V%.1f", Float.valueOf(versionnumber.floatValue())));
        this.getModel().setValue(IS_SRC, (Object)scheme.getLong("issrc_id"));
        this.getModel().setValue(IS_TAG, (Object)scheme.getLong("istarg_id"));
        this.getModel().setValue(ISSCHEMEID, (Object)scheme.getLong("isscheme_id"));
        this.getModel().setValue(EXTENDSMODEL, (Object)scheme.getLong("extendsmodel_id"));
        this.getModel().setValue(EXTENDSTABLE, (Object)scheme.getString(EXTENDSTABLE));
        this.getModel().setValue(SERVICEFLOW, (Object)scheme.getString("serviceflow_id"));
        if (scheme.getDate(EXPIRINGDATE) != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(scheme.getDate(EXPIRINGDATE));
            c.add(5, 1);
            this.getModel().setValue(EFFECTIVEDATE, (Object)c.getTime());
        }
        this.setVisiAndData(scheme);
    }

    private void setVisiAndData(DynamicObject scheme) {
        String issrc = scheme.getDynamicObject(IS_SRC).getString(NUMBER);
        boolean isExtendSrc = IntegrateProductEnum.XExtendProduct.getNumber().equals(issrc);
        if ("JQ".equals(issrc) || "EXCEL".equals(issrc)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSCHEMEID, MIDDLELIB, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            QFilter qfType = new QFilter("fBillType", "=", (Object)"bcm_isscheme");
            QFilter qfScheme = new QFilter("fInterID", "=", (Object)(scheme.getLong("id") + ""));
            DynamicObjectCollection load = QueryServiceHelper.query((String)"bos_attachment", (String)"fAttachmentName,fAttachmentSize", (QFilter[])new QFilter[]{qfType, qfScheme});
            if (load != null && load.size() > 0) {
                this.getModel().setValue(ATTACHMENT, (Object)((DynamicObject)load.get(0)).getString("fAttachmentName"));
            }
        } else if (IntegrateProductEnum.MIDLIBProduct.getNumber().equals(issrc)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MIDDLELIB, ISSCHEMEID});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSRCMODEL, ATTACHMENT, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            this.getModel().setValue(MIDDLELIB, (Object)scheme.getDynamicObject(MIDDLELIB));
        } else if (IntegrateProductEnum.NGBGMODELProduct.getNumber().equals(issrc) || IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(issrc) || IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(issrc)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSCHEMEID, MIDDLELIB, ATTACHMENT, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            this.getModel().setValue(ISSRCMODEL, (Object)scheme.getDynamicObject(ISSRCMODEL));
        } else if ("NGACC".equals(issrc)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENT, ISSRCMODEL, ISSCHEMEID, MIDDLELIB, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            this.getModel().setValue(MIDDLELIB, null);
            this.getView().updateView(MIDDLELIB);
        } else if ("EASACC".equals(issrc) || IntegrateProductEnum.EASREPProduct.getNumber().equals(issrc)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENT, ISSRCMODEL, MIDDLELIB, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSCHEMEID});
            this.getModel().setValue(MIDDLELIB, null);
            this.getView().updateView(MIDDLELIB);
        } else if (isExtendSrc) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MIDDLELIB, ISSRCMODEL, ATTACHMENT, ISSCHEMEID});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ATTACHMENT, ISSRCMODEL, EXTENDSMODEL, EXTENDSTABLE, SERVICEFLOW});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MIDDLELIB, ISSCHEMEID});
            this.getModel().setValue(MIDDLELIB, null);
            this.getView().updateView(MIDDLELIB);
        }
        String isTag = scheme.getDynamicObject(IS_TAG).getString(NUMBER);
        if (IntegrateProductEnum.NGProduct.getNumber().equals(isTag) && !isExtendSrc) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SYNBASE});
            this.getModel().setValue(SYNBASE, (Object)scheme.getString(SYNBASE));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SYNBASE});
        }
        if (!ConfigServiceHelper.isHwApp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LOCATION});
            this.getModel().setValue(LOCATION, (Object)scheme.getString(LOCATION));
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MIDDLELIB, SYNBASE, ISSRCMODEL, LOCATION, ATTACHMENT});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        IFormView view = this.getView();
        if ("save".equals(c.getKey())) {
            if (this.validate()) {
                IDataModel model = this.getModel();
                FormShowParameter formShowParameter = view.getFormShowParameter();
                Long schemeId = (Long)formShowParameter.getCustomParam("newversion");
                try {
                    Long newSchmeId = IntegrationUtil.newVersion((Long)schemeId, (IDataModel)model);
                    AttachmentHandle.copyFile2New(schemeId, newSchmeId, model.getValue("versionnumber").toString());
                    view.returnDataToParent((Object)schemeId);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u9519\u8bef\uff1a%s\u3002", (String)"ISSchemeNewVersionPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)));
                }
                view.close();
            }
        } else if ("cancel".equals(c.getKey())) {
            this.checkChangeData();
        }
    }

    private void checkChangeData() {
        String description;
        String name = "";
        if (this.getModel().getValue(NAME) != null && ((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue() != null) {
            name = ((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue();
        }
        String effectivedate = this.getModel().getValue(EFFECTIVEDATE) == null ? "" : ((Date)this.getModel().getValue(EFFECTIVEDATE)).getTime() + "";
        String expiringdate = this.getModel().getValue(EXPIRINGDATE) == null ? "" : ((Date)this.getModel().getValue(EXPIRINGDATE)).getTime() + "";
        String string = description = this.getModel().getValue(DESCRIPTION) == null ? "" : (String)this.getModel().getValue(DESCRIPTION);
        if (!(name.equals(this.getPageCache().get(NAME)) && effectivedate.equals(this.getPageCache().get(EFFECTIVEDATE)) && expiringdate.equals(this.getPageCache().get(EXPIRINGDATE)) && description.equals(this.getPageCache().get(DESCRIPTION)))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6570\u636e\u6709\u53d8\u5316\uff0c\u662f\u5426\u786e\u5b9a\u9000\u51fa\uff1f", (String)"ISSchemeNewVersionPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exit_confirm", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "exit_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.getView().close();
                break;
            }
        }
    }

    private boolean validate() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String name = dataEntity.getString(NAME);
        Date effectivedate = dataEntity.getDate(EFFECTIVEDATE);
        if (effectivedate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ISSchemeNewVersionPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"ISSchemeNewVersionPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.getDate(EXPIRINGDATE) != null && effectivedate.after(dataEntity.getDate(EXPIRINGDATE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u586b\u5199\u7684\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u65e9\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ISSchemeNewVersionPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFBuilder qf = new QFBuilder(MODEL, "=", (Object)dataEntity.getLong("model_id"));
        qf.add(NUMBER, "=", (Object)dataEntity.getString(NUMBER));
        qf.add("versionnumber", "=", (Object)dataEntity.getBigDecimal("versionnumber").add(new BigDecimal(-1)));
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, effectivedate, expiringdate, versionnumber", (QFilter[])qf.toArray());
        boolean iscovered = false;
        Calendar time1 = Calendar.getInstance();
        Calendar time2 = Calendar.getInstance();
        if (scheme.getDate(EXPIRINGDATE) == null) {
            if (!dataEntity.getDate(EFFECTIVEDATE).after(scheme.getDate(EFFECTIVEDATE))) {
                iscovered = true;
            } else {
                Calendar c = Calendar.getInstance();
                c.setTime(dataEntity.getDate(EFFECTIVEDATE));
                c.add(5, -1);
                scheme.set(EXPIRINGDATE, (Object)c.getTime());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
            }
        } else {
            time1.setTime(scheme.getDate(EXPIRINGDATE));
            time2.setTime(dataEntity.getDate(EFFECTIVEDATE));
            boolean bl = iscovered = time1.compareTo(time2) >= 0;
        }
        if (iscovered) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u201c\u751f\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u4e00\u7248\u672c\u7684\u201c\u751f\u6548\u65e5\u671f\u201d\u6216\u201c\u5931\u6548\u65e5\u671f\u201d\u3002", (String)"ISSchemeNewVersionPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.format("V%.1f", Float.valueOf(scheme.getBigDecimal("versionnumber").floatValue()))));
            return false;
        }
        return true;
    }
}

