/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import kd.fi.bcm.formplugin.report.export.FloatAreaInfo;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ISSchemeSheetMappingEditPlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String PAGE_DIM = "pagedim";
    private static final String FLOADMAPPING = "floatmapping";
    private static final String SHEETMAPPING = "sheetmapping";
    private static final String DM_VAL_STR = "dm_valstr";
    private static final String TEMPLATE = "template";
    private static final String SHEETNAME = "sheetname";
    private static final String cacheKey_subTableCds = "subTableCds";
    private static String HAS_XML_ATTACHMENT = "hasXmlAttachment";

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeSheetMappingEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private OpNameMultiLangEnumBridge getOperationMapping() {
        return new OpNameMultiLangEnumBridge("\u8868\u683c\u6620\u5c04", "ISSchemeSheetMappingEditPlugin_2", "fi-bcm-formplugin", "Table Mapping");
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getPageCache().put("scheme", (String)this.getView().getFormShowParameter().getCustomParam("scheme"));
        BasedataEdit template = (BasedataEdit)this.getControl(TEMPLATE);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("templatetype", "in", (Object)new String[]{"0", "1"});
        template.setQFilter(qFilter);
        template.setF7MultipleSelect(false);
        template.setF7BatchFill(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK, PAGE_DIM);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SHEETMAPPING);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            DynamicObjectCollection sheetmapping = this.getModel().getEntryEntity(SHEETMAPPING);
            int rowIndex = this.saveMapping(sheetmapping);
            if (rowIndex != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c %s \u884c\u9700\u7ef4\u62a4\u9875\u9762\u7ef4\u3002", (String)"ISSchemeSheetMappingEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[]{rowIndex}));
                return;
            }
            this.getView().returnDataToParent(null);
            this.getView().close();
        } else if (PAGE_DIM.equals(key)) {
            this.showDimSelect();
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        int rowIndex = arg0.getRowIndex();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SHEETMAPPING);
        String floatMapping = ((DynamicObject)entryEntity.get(rowIndex)).getString(FLOADMAPPING);
        FormShowParameter parm = new FormShowParameter();
        parm.setFormId("bcm_isfloatareamapping");
        parm.getOpenStyle().setShowType(ShowType.Modal);
        parm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_isfloatareamapping"));
        parm.setCustomParam(FLOADMAPPING, (Object)floatMapping);
        ArrayList<String> subtableCds = this.getXmlSubTableCds(((DynamicObject)entryEntity.get(rowIndex)).getString(SHEETNAME));
        parm.setCustomParam(cacheKey_subTableCds, (Object)ObjectSerialUtil.toByteSerialized(subtableCds));
        parm.setCustomParam("templateid", ((DynamicObject)entryEntity.get(rowIndex)).getDynamicObject(TEMPLATE).getPkValue());
        this.getView().showForm(parm);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int rowIndex = e.getInsertRow();
        if (rowIndex >= 1) {
            this.getModel().setValue(SHEETNAME, this.getModel().getValue(SHEETNAME, rowIndex - 1), rowIndex);
            this.getModel().setValue("status", this.getModel().getValue("status", rowIndex - 1), rowIndex);
            this.getModel().setValue("isexcelimport", this.getModel().getValue("isexcelimport", rowIndex - 1), rowIndex);
        }
    }

    private void showDimSelect() {
        int currentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject templateDyn = (DynamicObject)model.getValue(TEMPLATE, currentRowIndex = model.getEntryCurrentRowIndex(SHEETMAPPING));
        if (templateDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u3002", (String)"ISSchemeSheetMappingEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String templateId = templateDyn.getString("id");
        HashMap<String, String> openParameter = new HashMap<String, String>();
        openParameter.put("formId", "bcm_isspagememberselect");
        openParameter.put("templateId", templateId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        showParameter.setCustomParam("schemeId", (Object)this.getScheme());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u6210\u5458\u9009\u62e9", (String)"DataCollectedNewPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_isspagememberselect");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void initData() {
        List<DynamicObject> tableMappingList;
        boolean isExcelImport = (Boolean)this.getView().getFormShowParameter().getCustomParam("isExcelImport");
        List sheetNames = (List)this.getView().getFormShowParameter().getCustomParam("sheetNameList");
        List<MappigStatus> dataMaps = this.collectSheetStatus(sheetNames, tableMappingList = this.getNameMapping());
        if (dataMaps.size() - 1 > 0) {
            this.getModel().batchCreateNewEntryRow(SHEETMAPPING, dataMaps.size() - 1);
        }
        int i = 0;
        for (MappigStatus entry : dataMaps) {
            this.getModel().setValue("id", (Object)entry.getMappingId(), i);
            this.getModel().setValue(SHEETNAME, (Object)entry.getSheetName(), i);
            this.getModel().setValue("status", (Object)entry.getStatus(), i);
            this.getModel().setValue(TEMPLATE, (Object)entry.getTemplate(), i);
            this.getModel().setValue("tempversion", (Object)entry.getTempVersion(), i);
            this.getModel().setValue("mappingstatus", (Object)entry.getMappingstatus(), i);
            this.getModel().setValue(PAGE_DIM, (Object)entry.getPagedim(), i);
            this.getModel().setValue("isexcelimport", (Object)isExcelImport, i);
            this.getModel().setValue(FLOADMAPPING, (Object)entry.getFloatmapping(), i);
            ++i;
        }
        if (!isExcelImport) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PAGE_DIM});
        }
    }

    private int saveMapping(DynamicObjectCollection mapping) {
        QFilter[] qFilters = new QFilter[]{this.getFilter()};
        ArrayList<DynamicObject> saveInfos = new ArrayList<DynamicObject>(mapping.size());
        boolean isFirst = !QueryServiceHelper.exists((String)"bcm_issheetmapping", (QFilter[])qFilters);
        Map<Long, Long> mapping2tmpl = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,scheme.name,template.id", (QFilter[])new QFilter[]{new QFilter("id", "in", mapping.stream().map(d -> d.getLong("id")).collect(Collectors.toSet()))}).stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("template.id")));
        HashSet<Long> needDelCellMappings = new HashSet<Long>(16);
        HashSet<Long> tmpids = new HashSet<Long>(10);
        for (int i = 0; i < mapping.size(); ++i) {
            DynamicObject row = (DynamicObject)mapping.get(i);
            boolean isNewRow = row.getLong("id") == 0L;
            DynamicObject sheetMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_issheetmapping");
            if (!isNewRow) {
                sheetMapping.set("id", (Object)row.getLong("id"));
            }
            sheetMapping.set("seqnum", (Object)(i + 1));
            sheetMapping.set("scheme", (Object)this.getScheme());
            sheetMapping.set(SHEETNAME, (Object)row.getString(SHEETNAME));
            boolean saveByDim = false;
            if (row.get(TEMPLATE) != null) {
                DynamicObject template = (DynamicObject)row.get(TEMPLATE);
                saveByDim = template.getBoolean("issavebydim");
                if (tmpids.contains(template.getLong("id"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e00\u4e2a\u62a5\u8868\u6a21\u677f\u53ea\u80fd\u6620\u5c04\u4e00\u4e2a\u8868\u683c\uff0c%1$s-%2$s\u5b58\u5728\u591a\u6b21\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISSchemeSheetMappingEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getString("name"), String.format("V%.1f", template.getBigDecimal("versionnumber"))));
                }
                tmpids.add(template.getLong("id"));
                sheetMapping.set(TEMPLATE, (Object)template);
                sheetMapping.set("isfloat", (Object)("1".equals(((DynamicObject)row.get(TEMPLATE)).getString("templatetype")) ? "1" : "0"));
                sheetMapping.set("mappingstatus", (Object)row.getString("mappingstatus"));
                if (!isNewRow && mapping2tmpl.get(row.getLong("id")).longValue() != template.getLong("id")) {
                    needDelCellMappings.add(row.getLong("id"));
                }
            } else if (!isNewRow) {
                needDelCellMappings.add(row.getLong("id"));
            }
            sheetMapping.set("effectstatus", (Object)"0");
            sheetMapping.set("creator", (Object)RequestContext.get().getUserId());
            sheetMapping.set("createtime", (Object)TimeServiceHelper.now());
            sheetMapping.set("modifier", (Object)RequestContext.get().getUserId());
            sheetMapping.set("modifiedtime", (Object)TimeServiceHelper.now());
            if (saveByDim && (row.getString(PAGE_DIM) == null || row.getString(PAGE_DIM).length() == 0) && row.get(TEMPLATE) != null && row.getBoolean("isexcelimport")) {
                return i + 1;
            }
            sheetMapping.set(PAGE_DIM, (Object)row.getString(PAGE_DIM));
            sheetMapping.set(FLOADMAPPING, (Object)row.getString(FLOADMAPPING));
            if (!isFirst) {
                sheetMapping.set("disablereason", (Object)ResManager.loadKDString((String)"\u201c\u91cd\u65b0\u6620\u5c04\u201d\u5bfc\u81f4\u751f\u6548\u72b6\u6001\u91cd\u7f6e\u3002", (String)"ISSchemeSheetMappingEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            saveInfos.add(sheetMapping);
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!isFirst) {
                    DeleteServiceHelper.delete((String)"bcm_issheetmapping", (QFilter[])qFilters);
                    if (needDelCellMappings.size() > 0) {
                        DeleteServiceHelper.delete((String)"bcm_iscellmappingdata", (QFilter[])new QFilter[]{new QFilter("sheetmappingid", "in", needDelCellMappings)});
                    }
                }
                SaveServiceHelper.save((DynamicObject[])saveInfos.toArray(new DynamicObject[0]));
                for (DynamicObject dyn : saveInfos) {
                    this.writeOperationLog(this.getOperationMapping(), "", String.format(ResManager.loadKDString((String)"\u8868\u683c%1$s \u6620\u5c04\u81f3 \u6a21\u677f%2$s", (String)"ISSchemeSheetMappingEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getString(SHEETNAME), dyn.getString("template.name")), this.getOperationStstusSuccess());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
        return 0;
    }

    private Long getScheme() {
        return Long.parseLong(this.getPageCache().get("scheme"));
    }

    private QFilter getFilter() {
        return new QFilter("scheme", "=", (Object)this.getScheme());
    }

    private List<DynamicObject> getNameMapping() {
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,template,template.versionnumber, mappingstatus, pagedim, floatmapping", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)this.getScheme())}, (String)"seqnum");
        return mappings.stream().collect(Collectors.toList());
    }

    private List<MappigStatus> collectSheetStatus(List<String> newSheetNms, List<DynamicObject> oldSheetTableMappings) {
        ArrayList<MappigStatus> newMap = new ArrayList<MappigStatus>(16);
        ArrayList deletedMap = new ArrayList(16);
        ArrayList oldMap = new ArrayList(16);
        if (oldSheetTableMappings != null && !oldSheetTableMappings.isEmpty()) {
            oldSheetTableMappings.forEach(v -> {
                String sheetName = v.getString(SHEETNAME);
                String version = String.format("V%.1f", Float.valueOf(v.getBigDecimal("template.versionnumber").floatValue()));
                if (version.equals("V0.0")) {
                    version = null;
                }
                if (newSheetNms != null && newSheetNms.size() > 0 && newSheetNms.contains(sheetName)) {
                    oldMap.add(new MappigStatus(v.getLong("id"), "2", sheetName, v.getLong(TEMPLATE), version, v.getString("mappingstatus"), v.getString(PAGE_DIM), v.getString(FLOADMAPPING)));
                } else {
                    deletedMap.add(new MappigStatus(v.getLong("id"), "1", sheetName, v.getLong(TEMPLATE), version, v.getString("mappingstatus"), v.getString(PAGE_DIM), v.getString(FLOADMAPPING)));
                }
            });
        }
        if (newSheetNms != null) {
            List editedSheetNames = oldMap.stream().map(x -> x.getSheetName()).collect(Collectors.toList());
            newSheetNms.stream().filter(x -> !editedSheetNames.contains(x)).forEach(x -> newMap.add(new MappigStatus(null, "0", (String)x, null, null, null, null, null)));
        }
        newMap.addAll(deletedMap);
        newMap.addAll(oldMap);
        return newMap;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("bcm_isspagememberselect".equals(actionId) && evt.getReturnData() != null) {
            String returnData = evt.getReturnData().toString();
            this.getModel().setValue(PAGE_DIM, (Object)returnData);
        } else if ("bcm_isfloatareamapping".equals(actionId) && evt.getReturnData() != null) {
            String returnData = evt.getReturnData().toString();
            this.getModel().setValue(FLOADMAPPING, (Object)returnData);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex(SHEETMAPPING);
        DynamicObject templateDy = (DynamicObject)this.getModel().getValue(TEMPLATE, index);
        if (TEMPLATE.equals(key)) {
            if (templateDy != null) {
                if (this.isColFloatTmp(templateDy)) {
                    this.getModel().setValue(TEMPLATE, null, index);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5217\u6d6e\u52a8\u8868\u683c\u3002", (String)"ISSchemeSheetMappingEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.hasXmlAttachment()) {
                    String floatAreaMapping = this.floatAreaMapping(templateDy, this.getModel().getValue(SHEETNAME, index).toString());
                    this.getModel().setValue(FLOADMAPPING, (Object)floatAreaMapping, index);
                } else {
                    this.getModel().setValue(FLOADMAPPING, null, index);
                }
                long templateId = templateDy.getLong("id");
                QFilter schemeQF = new QFilter("scheme", "=", (Object)this.getScheme());
                QFilter templateQF = new QFilter(TEMPLATE, "=", (Object)templateId);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_issheetmapping", (String)"id, pagedim", (QFilter[])new QFilter[]{schemeQF, templateQF});
                if (dynamicObject != null) {
                    this.getModel().setValue(PAGE_DIM, (Object)dynamicObject.getString(PAGE_DIM), index);
                } else {
                    this.getModel().setValue(PAGE_DIM, null, index);
                }
                String version = String.format("V%.1f", Float.valueOf(templateDy.getBigDecimal("versionnumber").floatValue()));
                this.getModel().setValue("tempversion", (Object)version, index);
            } else if (this.getModel().getValue(FLOADMAPPING) != null) {
                this.getModel().setValue(FLOADMAPPING, null);
            }
        }
    }

    private boolean isColFloatTmp(DynamicObject temp) {
        if (TemplateTypeEnum.DYNA.getType() != temp.getInt("templatetype")) {
            return false;
        }
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"data", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)temp.getLong("id"))});
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)dyn.getString("data"));
        Set postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
        for (PositionInfo position : postionInfoSet) {
            for (BasePointInfo basePointInfo : position.getBasePoints()) {
                if (basePointInfo.getDirect() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlAttachment() {
        List<String> urls = CellMappingHandle.getTempUrls(this.getScheme(), false);
        for (String url : urls) {
            if (!url.toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            return true;
        }
        return false;
    }

    private String floatAreaMapping(DynamicObject temp, String reportCode) {
        ArrayList<String> subtableCds = this.getXmlSubTableCds(reportCode);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"data", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)temp.getLong("id"))});
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)dyn.getString("data"));
        Set postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
        ArrayList<String> floatmappings = new ArrayList<String>(10);
        ArrayList<FloatAreaInfo> floatAreaInfos = new ArrayList<FloatAreaInfo>(10);
        int i = 0;
        for (PositionInfo position : postionInfoSet) {
            for (BasePointInfo basePointInfo : position.getBasePoints()) {
                floatAreaInfos.add(new FloatAreaInfo(basePointInfo.getDynaRange(), basePointInfo.getOriginalDynaRange()));
                ++i;
            }
            ExtendInfo extendInfo = position.getExtendInfo();
            if (extendInfo == null) continue;
            floatAreaInfos.add(new FloatAreaInfo(position.getAreaRange(), position.getOriginalAreaRange()));
            ++i;
        }
        Collections.sort(floatAreaInfos);
        for (int j = 0; j < floatAreaInfos.size(); ++j) {
            floatmappings.add(((FloatAreaInfo)floatAreaInfos.get(j)).getDynRange() + "\uff1a" + (subtableCds == null || subtableCds.size() <= j ? "" : subtableCds.get(j)));
        }
        return String.join((CharSequence)";", floatmappings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, ArrayList<String>> getXmlreportCd2SubTableCds() {
        List<String> fileUrls = CellMappingHandle.getTempUrls(this.getScheme(), false);
        String fileUrl = null;
        for (String url : fileUrls) {
            if (!url.toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            fileUrl = url;
            break;
        }
        if (fileUrl == null) {
            return null;
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        SAXReader reader = new SAXReader();
        try (InputStream in = fs.getInputStream(fileUrl);){
            HashMap<String, ArrayList<String>> report2SubTableMap = new HashMap<String, ArrayList<String>>(16);
            if (fileUrl.toLowerCase(Locale.ENGLISH).endsWith("xml")) {
                Document doc = reader.read(in);
                Element root = doc.getRootElement();
                Iterator reportIterator = root.elementIterator("report");
                while (reportIterator.hasNext()) {
                    Element report = (Element)reportIterator.next();
                    String reportCode = report.attributeValue("code");
                    ArrayList<String> subTableCodes = new ArrayList<String>(4);
                    Iterator subtableIterator = report.elementIterator("subtable");
                    while (subtableIterator.hasNext()) {
                        Element subtable = (Element)subtableIterator.next();
                        subTableCodes.add(subtable.attributeValue("code"));
                    }
                    report2SubTableMap.put(reportCode.toLowerCase(Locale.ENGLISH), subTableCodes);
                }
                Iterator unitcatIterator = root.elementIterator("unitcat");
                while (unitcatIterator.hasNext()) {
                    Element unitcat = (Element)unitcatIterator.next();
                    String unitcatCode = unitcat.attributeValue("code");
                    ArrayList<String> subTableCodes = new ArrayList<String>(4);
                    Iterator subtableIterator = unitcat.elementIterator("subtable");
                    while (subtableIterator.hasNext()) {
                        Element subtable = (Element)subtableIterator.next();
                        subTableCodes.add(subtable.attributeValue("code"));
                    }
                    report2SubTableMap.put(unitcatCode.toLowerCase(Locale.ENGLISH), subTableCodes);
                }
            }
            HashMap<String, ArrayList<String>> hashMap = report2SubTableMap;
            return hashMap;
        }
        catch (Exception e) {
            log.error("SheetMapping XML parse error:", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private ArrayList<String> getXmlSubTableCds(String reportCode) {
        Map<String, ArrayList<String>> xmlreportCd2SubTableCds = this.getXmlreportCd2SubTableCds();
        return xmlreportCd2SubTableCds == null ? null : xmlreportCd2SubTableCds.get(reportCode.toLowerCase(Locale.ENGLISH));
    }

    static class MappigStatus {
        Long mappingId;
        String status;
        Long template;
        String mappingstatus;
        String pagedim;
        String floatmapping;
        String tempVersion;
        String sheetName;

        public MappigStatus(Long mappingId, String status, String sheetName, Long template, String tempVersion, String mappingstatus, String pagedim, String floatmapping) {
            this.mappingId = mappingId;
            this.status = status;
            this.template = template;
            this.mappingstatus = mappingstatus;
            this.pagedim = pagedim;
            this.floatmapping = floatmapping;
            this.tempVersion = tempVersion;
            this.sheetName = sheetName;
        }

        public Long getMappingId() {
            return this.mappingId;
        }

        public void setMappingId(Long mappingId) {
            this.mappingId = mappingId;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Long getTemplate() {
            return this.template;
        }

        public void setTemplate(Long template) {
            this.template = template;
        }

        public String getMappingstatus() {
            return this.mappingstatus;
        }

        public void setMappingstatus(String mappingstatus) {
            this.mappingstatus = mappingstatus;
        }

        public String getPagedim() {
            return this.pagedim;
        }

        public void setPagedim(String pagedim) {
            this.pagedim = pagedim;
        }

        public String getFloatmapping() {
            return this.floatmapping;
        }

        public void setFloatmapping(String floatmapping) {
            this.floatmapping = floatmapping;
        }

        public String getTempVersion() {
            return this.tempVersion;
        }

        public void setTempVersion(String tempVersion) {
            this.tempVersion = tempVersion;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }
    }
}

