/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ISSchemeSheetMappingListPlugin
extends AbstractBaseListPlugin {
    private static final String BTN_MAPPING = "btn_mapping";
    private static final String BTN_UP = "btn_up";
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_CELLMAPPING = "btn_cellmapping";
    private static final String BTN_BATCHMAPPING = "btn_batchmapping";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISENABLE = "btn_disenable";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_DELETE = "btn_delete";
    private static final String SCHEME = "scheme";
    private static final String BATCHMAPPING_DATA = "batchMappingData";
    private static final String DELETE_IDS = "deleteIds";

    private String getOperationEnable() {
        return ResManager.loadKDString((String)"\u751f\u6548", (String)"ISSchemeSheetMappingListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDisable() {
        return ResManager.loadKDString((String)"\u5931\u6548", (String)"ISSchemeSheetMappingListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getAbleNotification() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u6240\u9009\u6620\u5c04\u5df2\u751f\u6548\u3002", (String)"ISSchemeSheetMappingListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getEnableNotification() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u6240\u9009\u6620\u5c04\u5df2\u5931\u6548\u3002", (String)"ISSchemeSheetMappingListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeSheetMappingListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ISSchemeSheetMappingListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationUp() {
        return ResManager.loadKDString((String)"\u4e0a\u79fb", (String)"ISSchemeSheetMappingListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDown() {
        return ResManager.loadKDString((String)"\u4e0b\u79fb", (String)"ISSchemeSheetMappingListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationMapping() {
        return ResManager.loadKDString((String)"\u6253\u5f00\u8868\u683c\u6620\u5c04\u5f39\u7a97", (String)"ISSchemeSheetMappingListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationCellMapping() {
        return ResManager.loadKDString((String)"\u6253\u5f00\u5355\u5143\u683c\u6620\u5c04", (String)"ISSchemeSheetMappingListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationBatchMapping() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u6309Excel\u884c\u5217\u6620\u5c04", (String)"ISSchemeSheetMappingListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDelete() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"ISSchemeSheetMappingListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        Long shcemeId = (Long)this.getView().getFormShowParameter().getCustomParam(SCHEME);
        this.getPageCache().put(SCHEME, String.valueOf(shcemeId));
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                setFilterEvent.getQFilters().add(ISSchemeSheetMappingListPlugin.this.getFilter());
            }
        });
    }

    private QFilter getFilter() {
        Long scheme = (Long)this.getView().getFormShowParameter().getCustomParam(SCHEME);
        QFilter qFilter = new QFilter(SCHEME, "=", (Object)scheme);
        qFilter.and(new QFilter("template", "!=", (Object)0L));
        return qFilter;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection coll = billList.getSelectedRows();
        if (coll.isEmpty() && !BTN_MAPPING.equals(itemKey) && !BTN_REFRESH.equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ISSchemeSheetMappingListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"name,status", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getView().getFormShowParameter().getCustomParam(SCHEME))});
        if ("1".equals(scheme.getString("status")) && !BTN_CELLMAPPING.equals(itemKey) && !BTN_REFRESH.equals(itemKey)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u65b9\u6848\u5df2\u7ecf\u542f\u7528\uff0c\u53ef\u4ee5\u7981\u7528\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSheetMappingListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scheme.getString("name")));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            ListSelectedRow row = coll.get(i);
            ids.add(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())));
        }
        switch (itemKey) {
            case "btn_mapping": {
                this.mapping();
                break;
            }
            case "btn_up": 
            case "btn_down": {
                if (ids.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u6570\u636e\u3002", (String)"ISSchemeSheetMappingListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache(ids.get(0), (String)"bcm_issheetmapping");
                    int rowCount = BusinessDataServiceHelper.loadFromCache((String)"bcm_issheetmapping", (QFilter[])new QFilter[]{this.getFilter()}).size();
                    this.changeSeq(dynObj, itemKey, rowCount);
                }
                this.refreshBillList(this.getFilter());
                break;
            }
            case "btn_cellmapping": {
                if (ids.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u6570\u636e\u3002", (String)"ISSchemeSheetMappingListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject sheetMapping = BusinessDataServiceHelper.loadSingleFromCache(ids.get(0), (String)"bcm_issheetmapping");
                if (sheetMapping.get("template") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u672a\u8bbe\u7f6e\u8868\u683c\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISSchemeSheetMappingListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.cellMapping(Long.parseLong(String.valueOf(ids.get(0))));
                this.writeOperationLog(this.getOperationCellMapping(), "", sheetMapping.getString("sheetname"), this.getOperationStstusSuccess());
                break;
            }
            case "btn_batchmapping": {
                Map dynMap = BusinessDataServiceHelper.loadFromCache((Object[])coll.getPrimaryKeyValues(), (String)"bcm_issheetmapping");
                for (DynamicObject dyn2 : dynMap.values()) {
                    if (dyn2.get("template") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u672a\u8bbe\u7f6e\u8868\u683c\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ISSchemeSheetMappingListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!this.reportNotSaveByDim(dyn2.getLong("template.id"))) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u201c%s\u201d\u4e3a\u65e0\u7ef4\u5ea6\u6a21\u677f\uff0c\u65e0\u6cd5\u6309Excel\u884c\u5217\u6620\u5c04\u3002\u8bf7\u7b5b\u9009\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSheetMappingListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn2.getString("template.number")));
                    return;
                }
                List efficient = dynMap.values().stream().filter(dyn -> "1".equals(dyn.getString("effectstatus"))).map(dyn -> dyn.getString("sheetname")).collect(Collectors.toList());
                if (efficient.isEmpty()) {
                    this.getPageCache().put(BATCHMAPPING_DATA, this.toByteSerialized(ids));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8986\u76d6\u751f\u6210\u6620\u5c04\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ISSchemeSheetMappingListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("batchMapping", (IFormPlugin)this));
                    break;
                }
                List needMappingIds = dynMap.values().stream().filter(dyn -> "0".equals(dyn.getString("effectstatus"))).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.getPageCache().put(BATCHMAPPING_DATA, this.toByteSerialized(needMappingIds));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u8986\u76d6\u751f\u6210\u6620\u5c04\u65f6\uff0c\u53d1\u73b0%d\u6761\u6620\u5c04\u5df2\u751f\u6548\uff0c\u662f\u5426\u5ffd\u7565\u5df2\u751f\u6548\u7ee7\u7eed\uff1f", (String)"ISSchemeSheetMappingListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), efficient.size()), String.join((CharSequence)"\n", efficient), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("batchMapping", (IFormPlugin)this));
                break;
            }
            case "btn_enable": 
            case "btn_disenable": {
                String status = BTN_ENABLE.equals(itemKey) ? "1" : "0";
                this.changeEnable(status, ids);
                this.refreshBillList(this.getFilter());
                break;
            }
            case "btn_refresh": {
                this.refreshBillList(this.getFilter());
                break;
            }
            case "btn_delete": {
                this.getPageCache().put(DELETE_IDS, this.toByteSerialized(ids));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u6240\u9009\u8bb0\u5f55\uff1f", (String)"ISSchemeSheetMappingListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm_del", (IFormPlugin)this));
                break;
            }
        }
    }

    private boolean reportNotSaveByDim(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return !QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"issavebydim", (QFilter[])filter.toArray()).getBoolean("issavebydim");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List<String> fileUrls;
        super.afterCreateNewData(e);
        Long schemeId = Long.parseLong(this.getPageCache().get(SCHEME));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        if ("JQ".equals(dynamicObject.getString("issrc.number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagedim"});
        }
        if ((fileUrls = this.getTempUrl(schemeId)).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u65e0\u9644\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ISSchemeSheetMappingListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void mapping() {
        Long schemeId = Long.parseLong(this.getPageCache().get(SCHEME));
        List<String> fileUrls = this.getTempUrl(schemeId);
        if (fileUrls.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u65e0\u9644\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ISSchemeSheetMappingListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> sheetNames = this.getSheetNameList(fileUrls);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_issheetmappingedit");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId("bcm_issheetmappingedit");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam(SCHEME, (Object)this.getPageCache().get(SCHEME));
        formShowParameter.setCustomParam("sheetNameList", sheetNames);
        formShowParameter.setCustomParam("isExcelImport", this.getView().getFormShowParameter().getCustomParam("isExcelImport"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getView().showForm(formShowParameter);
    }

    private void changeSeq(DynamicObject selectRow, String action, int rowCount) {
        block2: {
            block3: {
                int seqnum = selectRow.getInt("seqnum");
                if (!BTN_UP.equals(action)) break block3;
                DynamicObject[] toOrder = BusinessDataServiceHelper.load((String)"bcm_issheetmapping", (String)"id,seqnum", (QFilter[])new QFilter[]{this.getFilter()}, (String)"seqnum");
                for (int i = 0; i < toOrder.length; ++i) {
                    if (!toOrder[i].getPkValue().equals(selectRow.getPkValue()) || i == 0) continue;
                    int tmpSeq = toOrder[i].getInt("seqnum");
                    toOrder[i].set("seqnum", (Object)toOrder[i - 1].getInt("seqnum"));
                    toOrder[i - 1].set("seqnum", (Object)tmpSeq);
                    DynamicObject[] updateDyns = new DynamicObject[]{toOrder[i], toOrder[i - 1]};
                    SaveServiceHelper.update((DynamicObject[])updateDyns);
                    this.writeOperationLog(this.getOperationUp(), "", selectRow.getString("sheetname"), this.getOperationStstusSuccess());
                    break block2;
                }
                break block2;
            }
            if (!BTN_DOWN.equals(action)) break block2;
            DynamicObject[] toOrder = BusinessDataServiceHelper.load((String)"bcm_issheetmapping", (String)"id,seqnum", (QFilter[])new QFilter[]{this.getFilter()}, (String)"seqnum");
            for (int i = 0; i < toOrder.length; ++i) {
                if (!toOrder[i].getPkValue().equals(selectRow.getPkValue()) || i == toOrder.length - 1) continue;
                int tmpSeq = toOrder[i].getInt("seqnum");
                toOrder[i].set("seqnum", (Object)toOrder[i + 1].getInt("seqnum"));
                toOrder[i + 1].set("seqnum", (Object)tmpSeq);
                DynamicObject[] updateDyns = new DynamicObject[]{toOrder[i], toOrder[i + 1]};
                SaveServiceHelper.update((DynamicObject[])updateDyns);
                this.writeOperationLog(this.getOperationDown(), "", selectRow.getString("sheetname"), this.getOperationStstusSuccess());
                break;
            }
        }
    }

    private void cellMapping(Long id) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_iscellmapping");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId("bcm_iscellmapping");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam(SCHEME, (Object)this.getPageCache().get(SCHEME));
        formShowParameter.setCustomParam("sheetmappingid", (Object)id);
        formShowParameter.setCustomParam("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getView().showForm(formShowParameter);
    }

    private void batchMapping(List<Long> ids) {
        DynamicObjectCollection sheetMappings = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        String sheetnames = sheetMappings.stream().map(dyn -> dyn.getString("sheetname")).collect(Collectors.joining("\uff0c"));
        String bmResult = CellMappingHandle.batchSheetCellMapping(Long.parseLong(this.getPageCache().get(SCHEME)), ids);
        if (StringUtils.isEmpty((String)bmResult)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ISSchemeSheetMappingListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeOperationLog(this.getOperationBatchMapping(), "", sheetnames, this.getOperationStstusSuccess());
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u884c\u5217\u6620\u5c04\u4e3a\u7a7a\u3002", (String)"ISSchemeSheetMappingListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bmResult));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6279\u91cf\u6309Excel\u884c\u5217\u6620\u5c04", "ISSchemeSheetMappingListPlugin_8", "fi-bcm-formplugin", "Batch mapping"), new OPDescMultiLangEnumBridge("\u6279\u91cf\u6620\u5c04\u8868\u683c %1$s;\u5176\u4e2d %2$s \u884c\u5217\u6620\u5c04\u4e3a\u7a7a\u3002", "ISSchemeSheetMappingListPlugin_21", "fi-bcm-formplugin", new String[]{sheetnames, bmResult.substring(0, bmResult.length() - 1)}));
        }
    }

    private void changeEnable(String status, List<Long> ids) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", ids);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_issheetmapping", (String)"sheetname,template.id,mappingstatus,effectstatus,disablereason,modifier,modifiedtime", (QFilter[])qfBuilder.toArray());
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Arrays.asList(dos));
        ArrayList<String> noTempMapping = new ArrayList<String>(10);
        ArrayList noCellMapping = new ArrayList(10);
        Iterator iterator = dynamicObjectList.iterator();
        while (iterator.hasNext()) {
            DynamicObject[] dy = (DynamicObject[])iterator.next();
            if (dy.getLong("template.id") == 0L) {
                noTempMapping.add(dy.getString("sheetname"));
                iterator.remove();
                continue;
            }
            dy.set("effectstatus", (Object)status);
            dy.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dy.set("modifiedtime", (Object)TimeServiceHelper.now());
            if ("0".equals(status)) {
                dy.set("disablereason", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u5931\u6548", (String)"ISSchemeSheetMappingListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                continue;
            }
            dy.set("disablereason", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])dos);
        if (noTempMapping.isEmpty()) {
            for (DynamicObject dy : dos) {
                this.writeOperationLog("0".equals(status) ? this.getOperationDisable() : this.getOperationEnable(), "", dy.getString("sheetname"), this.getOperationStstusSuccess());
            }
            this.getView().showSuccessNotification("0".equals(status) ? this.getEnableNotification() : this.getAbleNotification());
        } else {
            StringBuilder sb = new StringBuilder();
            if (!noTempMapping.isEmpty()) {
                sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u6620\u5c04\u6a21\u677f\uff1a", (String)"ISSchemeSheetMappingListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n").append(String.join((CharSequence)"\n", noTempMapping)).append("\n");
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u90e8\u5206\u6620\u5c04\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ISSchemeSheetMappingListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("message", (IFormPlugin)this));
            for (DynamicObject dy : dynamicObjectList) {
                this.writeOperationLog("0".equals(status) ? this.getOperationDisable() : this.getOperationEnable(), "", dy.getString("sheetname"), this.getOperationStstusSuccess());
            }
            for (String sheetName : noTempMapping) {
                this.writeOperationLog("0".equals(status) ? this.getOperationDisable() : this.getOperationEnable(), "", sheetName, this.getOperationStstusFail());
            }
            for (String sheetName : noCellMapping) {
                this.writeOperationLog("0".equals(status) ? this.getOperationDisable() : this.getOperationEnable(), "", sheetName, this.getOperationStstusFail());
            }
        }
    }

    private void delete(List<Long> ids) {
        ArrayList effectSheetNames = new ArrayList(10);
        DynamicObjectCollection sheetMappings = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,effectstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        sheetMappings.forEach(dyn -> {
            if ("1".equals(dyn.getString("effectstatus"))) {
                effectSheetNames.add(dyn.getString("sheetname"));
            }
        });
        if (!effectSheetNames.isEmpty()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u751f\u6548\u7684\u6620\u5c04\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ISSchemeSheetMappingListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\n", effectSheetNames), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("deleteMessage", (IFormPlugin)this));
            this.writeOperationLog(this.getOperationDelete(), "", String.join((CharSequence)"\uff0c", effectSheetNames), this.getOperationStstusFail());
        } else {
            ArrayList mappingIds = new ArrayList(sheetMappings.size());
            sheetMappings.forEach(dyn -> mappingIds.add(dyn.getLong("id")));
            DeleteServiceHelper.delete((String)"bcm_issheetmapping", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            DeleteServiceHelper.delete((String)"bcm_iscellmappingdata", (QFilter[])new QFilter[]{new QFilter("sheetmappingid", "in", mappingIds)});
            this.writeOperationLog(this.getOperationDelete(), "", sheetMappings.stream().map(dyn -> dyn.getString("sheetname")).collect(Collectors.joining("\uff0c")), this.getOperationStstusSuccess());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeSheetMappingListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getTempUrl(Long schemeId) {
        DynamicObjectCollection dynObj = QueryServiceHelper.query((String)"bos_attachment", (String)"fFileId", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)"bcm_isscheme"), new QFilter("fInterID", "=", (Object)String.valueOf(schemeId))});
        if (dynObj.isEmpty()) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> fFileIds = new ArrayList<String>(dynObj.size());
        dynObj.forEach(dyn -> {
            String fFileId = dyn.getString("fFileId");
            if (!(fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xls") || fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xlsx") || fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xml"))) {
                fFileId = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(fFileId);
            }
            fFileIds.add(fFileId);
        });
        return fFileIds;
    }

    private List<String> getSheetNameList(List<String> fileUrls) {
        ArrayList<String> names = new ArrayList<String>(10);
        fileUrls.forEach(url -> names.addAll(this.getSheetNameList((String)url)));
        return names;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getSheetNameList(String fileUrl) {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = fs.getInputStream(fileUrl);){
            int i;
            HSSFWorkbook wb;
            ArrayList<String> names = new ArrayList<String>(10);
            if (fileUrl.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                wb = new HSSFWorkbook(in);
                for (i = 0; i < wb.getNumberOfSheets(); ++i) {
                    names.add(wb.getSheetAt(i).getSheetName());
                }
            } else if (fileUrl.toLowerCase(Locale.ENGLISH).endsWith(".xlsx")) {
                wb = new XSSFWorkbook(in);
                for (i = 0; i < wb.getNumberOfSheets(); ++i) {
                    names.add(wb.getSheetAt(i).getSheetName());
                }
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (!(e instanceof RecordFormatException)) throw new KDBizException(e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6587\u4ef6\u8d85\u8fc7org.apache.poi\u7684100,000,000\u4e2a\u6570\u7ec4\u9650\u5236,\u8bf7\u66f4\u6362\u4e0a\u4f20\u7684\u6587\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSheetMappingListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void refreshBillList(QFilter filter) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.getFilterParameter().setFilter(filter);
        billList.refresh();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent ccbe) {
        super.closedCallBack(ccbe);
        switch (ccbe.getActionId()) {
            case "bcm_issheetmappingedit": {
                this.refreshBillList(this.getFilter());
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.clearSelection();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int result = mbce.getResult().getValue();
        if ("confirm_del".equals(callBackId) && MessageBoxResult.Yes.getValue() == result) {
            List ids = (List)this.deSerializedBytes(this.getPageCache().get(DELETE_IDS));
            this.delete(ids);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearSelection();
        } else if ("batchMapping".equals(callBackId)) {
            if (MessageBoxResult.Yes.getValue() == result) {
                List ids = (List)this.deSerializedBytes(this.getPageCache().get(BATCHMAPPING_DATA));
                this.batchMapping(ids);
            }
            this.getPageCache().remove(BATCHMAPPING_DATA);
        }
        this.refreshBillList(this.getFilter());
    }
}

