/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.util.ReportListUtil;

public class ISSchemeTemplateSelectPlugin
extends AbstractFormPlugin
implements BCMBaseFunction {
    private static final String treeview = "treeview";
    private static final String btn_confirm = "btn_confirm";
    private static final String btn_close = "btn_close";
    private static final String SELECT_ORG = "selectorg";

    @Override
    public AbstractFormPlugin getPlugin() {
        return null;
    }

    @Override
    public long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_confirm, btn_close});
    }

    public void afterCreateNewData(EventObject e) {
        this.buildLeftTree();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (btn_confirm.equals(key)) {
            this.actionConfirm();
        } else if (btn_close.equals(key)) {
            this.getView().close();
        }
    }

    private void buildLeftTree() {
        AbstractTreeNode<Object> root = this.buildTreeCache();
        if (root != null) {
            this.initTree(root);
        }
    }

    private AbstractTreeNode<Object> buildTreeCache() {
        long modelId = this.getModelId();
        DynamicObjectCollection rootNodecollection = this.getTreeListORM(modelId);
        if (rootNodecollection != null && rootNodecollection.size() != 0) {
            String showType = "2";
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)this.getModelId());
            qfBuilder.add("usage", "=", (Object)"1");
            qfBuilder.add("templatetype", "not in", (Object)new String[]{Integer.toString(TemplateTypeEnum.MSN.getType()), Integer.toString(TemplateTypeEnum.OTHERWP.getType()), Integer.toString(TemplateTypeEnum.DYNAMICREPORT.getType())});
            qfBuilder.add("status", "=", (Object)"1");
            DynamicObjectCollection templateColls = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])qfBuilder.toArray());
            HashSet<Long> havePermIds = new HashSet<Long>(16);
            this.dealHavePermTemplates(templateColls, this.getModelId(), havePermIds);
            if (havePermIds.size() > 0) {
                Map source2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)this.getCommonParam("yearId"), (Long)this.getCommonParam("periodId"), havePermIds);
                havePermIds.clear();
                havePermIds.addAll(source2Right.values());
                Long scenarioId = this.getCommonParam("scenarioId");
                List templateModels = TemplateRangeService.getTemplateModels(havePermIds, (long)modelId, (boolean)false, (boolean)true);
                for (TemplateModel t : templateModels) {
                    if (TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)t, (Object)scenarioId)) continue;
                    havePermIds.remove(t.getId());
                }
            }
            TemplateTreeNode root = new TemplateTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"RptAdjustOffsetTemplatePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            root = TreeBuilder.getTemplateTreeNew((DynamicObjectCollection)rootNodecollection, (TemplateTreeNode)root, () -> new QFilter[]{new QFilter("id", "in", (Object)havePermIds)}, (String)showType, null);
            root.SetIsOpened(true);
            root.setId("0");
            return root;
        }
        TreeView tree = (TreeView)this.getControl(treeview);
        tree.deleteAllNodes();
        return null;
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(treeview);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
        }
    }

    private DynamicObjectCollection getTreeListORM(Long modelid) {
        QFilter filterModel = new QFilter("model", "=", (Object)modelid);
        QFilter filterType = TemplateCatalogTypeEnum.getTemplateCalcog();
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(modelid))) {
            this.getPageCache().remove("permClass");
            PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)"bcm_templatecatalog", (String)String.valueOf(modelid));
            List noPerms = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.NO.getIndex());
            filterType.and("id", "not in", (Object)noPerms);
        }
        DynamicObjectCollection doc = ReportListUtil.getCollection("bcm_templatecatalog", new QFilter[]{filterModel, filterType}, "sequence");
        return doc;
    }

    private void dealHavePermTemplates(DynamicObjectCollection allTemplates, Long modelId, Set<Long> havePermIds) {
        Map distributeMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)modelId);
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        List noPermIds = map.get((Object)"1");
        Set<Long> selectOrgs = this.getSelectOrgs();
        for (DynamicObject template : allTemplates) {
            Set entityIdSet = (Set)distributeMap.get(template.getLong("id"));
            if (entityIdSet == null) continue;
            selectOrgs.forEach(e -> {
                if (entityIdSet.contains(e)) {
                    if (!CollectionUtils.isEmpty((Collection)noPermIds) && noPermIds.contains(template.getLong("id"))) {
                        return;
                    }
                    havePermIds.add(template.getLong("id"));
                }
            });
        }
    }

    private void actionConfirm() {
        TreeView treeView = (TreeView)this.getControl(treeview);
        List selectId = treeView.getTreeState().getSelectedNodeId();
        List ids = selectId.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        this.getView().returnDataToParent(ids);
        this.getView().close();
    }

    private Long getCommonParam(String param) {
        if (this.getView().getFormShowParameter().getCustomParam(param) == null || "0".equals(this.getView().getFormShowParameter().getCustomParam(param).toString())) {
            return 0L;
        }
        return Long.parseLong(this.getView().getFormShowParameter().getCustomParam(param).toString());
    }

    private Set<Long> getSelectOrgs() {
        return (Set)ObjectSerialUtil.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam(SELECT_ORG)), Set.class);
    }
}

