/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.Tips;
import kd.bos.entity.TipsLink;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.IsRpaSchemeUtil;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.integration.RpaIniFileEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.vo.RpaFileModel;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class IsRpaSchemePlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    public static final String SCOPE = "scope";
    public static final String REPORTENTRY = "reportentry";
    public static final String ENTITY = "entity";
    protected static final String NUMBER = "number";
    protected static final String MODEL = "model";
    protected static final String SCHEME = "scheme";
    protected static final String ENTITYACTION = "entity0";
    protected static final String IS_AUTO_CREATE_NUMBER = "isAutoCreateNumber";
    protected static final String IS_USE_CODE_RULE = "isUseCodeRule";
    private static final String IS_ADD_VIEW = "isAddView";
    private static final String IS_MODIFIABLE = "isModifiable";
    private static final String SHOW_NUMBER = "showNumber";
    private static final String MULTITEMPLATE = "multitemplate";
    private static final String FILE_TYPE = "filetype";
    private static final String RPAPROCESS = "rpaprocess";
    private static final String RUNROBOT = "runrobot";
    private static final String FILEADDRESS = "";
    private static final String UNATTENDEDTYPE = "unattendedtype";
    private static final String APPOINT = "1";
    private static final String DISTRIBUTION = "2";
    private static final String FILE_NAME_CLICK = "filenameclick";
    private static final String SHEET_NAME_CLICK = "reportnameclick";
    private static final String INI_CLICK = "iniclick";
    private static final String JOIN_STR = "&";
    private static final String CON_CREATE_INI_FILE = "createinifile";
    private static final String CON_MERGE_INI_FILE = "mergeinifile";
    private static final String CON_FILE_ADDRESS = "fileaddress";
    private static final String CON_INI_ENTITY_CODERULE = "inientitycoderule";
    private static final String CACHE_KEY_FILENAME_MODEL = "CACHE_KEY_FILENAME_MODEL";
    private static final String CACHE_KEY_SHEETNAME_MODEL = "CACHE_KEY_SHEETNAME_MODEL";
    private static final String TYPE_FILE = "1";
    private static final String TYPE_SHEET = "2";
    public static final String STATUS = "status";
    public static final String ENTITYSCOPE = "entityscope";
    public static final String ENTRYENTITY = "entryentity";
    public static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    public static final String VALUE = "value";
    private static final String defalutDataType = "ERpt#ATTotal";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (this.getPage(this.getView()) != null) {
            Element c = this.getPage(this.getView()).findElementBySign(ctrlKey);
            if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else if (c != null) {
                e.setControl(c.getControl(this.getView()));
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scene = (BasedataEdit)this.getControl("scenario");
        BasedataEdit multitemplate = (BasedataEdit)this.getControl(MULTITEMPLATE);
        BasedataEdit scheme = (BasedataEdit)this.getControl(SCHEME);
        scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        multitemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        multitemplate.addAfterF7SelectListener(afterF7SelectEvent -> {
            ListSelectedRowCollection returnData = afterF7SelectEvent.getListSelectedRowCollection();
            if (returnData == null) {
                return;
            }
            IDataModel model = this.getModel();
            model.deleteEntryData(REPORTENTRY);
            for (ListSelectedRow row : returnData) {
                int newEntryRow = model.createNewEntryRow(REPORTENTRY);
                model.setValue("basedatafield", row.getPrimaryKeyValue(), newEntryRow);
            }
        });
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entity = (BasedataEdit)this.getControl(ENTITY);
        entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(FILE_NAME_CLICK, SHEET_NAME_CLICK, INI_CLICK);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "entity0": {
                this.openMultiF7(ENTITYACTION, ENTITY);
                break;
            }
            case "filenameclick": {
                this.openRpaFileRule("1");
                break;
            }
            case "reportnameclick": {
                this.openRpaFileRule("2");
                break;
            }
            case "iniclick": {
                this.openNameRule();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"IsRpaSchemePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        long modelId = this.getModelId();
        qFilterList.add(new QFilter("model.id", "=", (Object)modelId));
        switch (key) {
            case "currency": {
                qFilterList.add(new QFilter(NUMBER, "not in", (Object)new Object[]{"PC", "Currency"}));
                break;
            }
            case "scenario": {
                qFilterList.add(new QFilter(NUMBER, "!=", (Object)"Scenario"));
                break;
            }
            case "multitemplate": {
                qFilterList.add(new QFilter("templatetype", "!=", (Object)(TemplateTypeEnum.MSN.getType() + FILEADDRESS)));
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObjectCollection reportentry = this.getModel().getEntryEntity(REPORTENTRY);
                if (reportentry == null) break;
                ListSelectedRowCollection listSelectedRowCollection = parameter.getListSelectedRowCollection();
                listSelectedRowCollection.clear();
                for (int i = 0; i < reportentry.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)reportentry.get(i);
                    if (dynamicObject == null) continue;
                    ListSelectedRow listSelectedRow = new ListSelectedRow((Object)dynamicObject.getLong("basedatafield.id"), Boolean.valueOf(false));
                    listSelectedRowCollection.add((Object)listSelectedRow);
                }
                break;
            }
            case "scheme": {
                DynamicObjectCollection source = QueryServiceHelper.query((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "in", (Object)new String[]{"JQ", "JQONLINE"})});
                if (source == null) {
                    log.error("bcm_isproduct is null");
                    return;
                }
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)modelId);
                Set ids = source.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
                qFilterList.add(new QFilter("issrc", "in", ids));
                qFilterList.add(new QFilter(STATUS, "=", (Object)"1"));
                qFilterList.add(new QFilter("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId)));
                break;
            }
            case "entity": {
                this.openMultiF7(ENTITYACTION, ENTITY);
                beforeF7SelectEvent.setCancel(true);
                break;
            }
        }
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCodeRuleData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CON_FILE_ADDRESS, MODEL});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{CON_FILE_ADDRESS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTITYACTION});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MULTITEMPLATE});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{RUNROBOT});
    }

    private void initCodeRuleData() {
        CodeRuleInfo codeRuleInfo = CodeRuleUtil.getCodeRuleInfo("bcm_isrpascheme");
        if (null == codeRuleInfo) {
            this.getPageCache().put(IS_USE_CODE_RULE, String.valueOf(false));
            return;
        }
        Boolean isAddView = codeRuleInfo.getIsAddView();
        Boolean isModifiable = codeRuleInfo.getIsModifiable();
        String showNumber = CodeRuleUtil.readCodeRuleNumber("bcm_isrpascheme", null);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)modelId)) {
            while (this.adjustNumberIsExist(LongUtil.toLong((Object)modelId), showNumber)) {
                showNumber = CodeRuleUtil.getCodeRuleNumber("bcm_isrpascheme", null);
            }
        }
        this.getModel().setValue(NUMBER, (Object)showNumber);
        this.getPageCache().put(IS_USE_CODE_RULE, String.valueOf(true));
        this.getPageCache().put(SHOW_NUMBER, showNumber);
        this.getPageCache().put(IS_ADD_VIEW, String.valueOf(isAddView));
        this.getPageCache().put(IS_MODIFIABLE, String.valueOf(isModifiable));
    }

    private void getEntityF7() {
        Page page = this.getPage(this.getView());
        page = page == null ? new Page() : page;
        Area area = new Area("entityflex");
        area.setShowLabel(true);
        TextEditElement f7 = new TextEditElement(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"IsRpaSchemePlugin_31", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), ENTITYACTION, "bcm_entitymembertree");
        area.addElement((Element)f7);
        f7.setWidth(new LocaleString("500px"));
        f7.setFieldTextAlign("left");
        f7.setLabelDirection("v");
        f7.setMustInput(true);
        page.addArea(area);
        page.updatePage(this.getView());
        this.setPage(this.getView(), page);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getEntityF7();
        String addNew = (String)this.getView().getFormShowParameter().getCustomParam("addNew");
        if (StringUtils.isEmpty((String)addNew) || !"add_new".equals(addNew)) {
            Long id;
            DynamicObject rpaScheme;
            String status;
            String string = status = this.getModel().getValue(STATUS) != null ? this.getModel().getValue(STATUS).toString() : FILEADDRESS;
            if ("1".equals(status)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"basicinfor"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"executeparam"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"rpainfo"});
            }
            if ((rpaScheme = BusinessDataServiceHelper.loadSingle((Object)(id = (Long)this.getModel().getValue("id")), (String)"bcm_isrpascheme")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"IsRpaSchemePlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                StringBuilder sb = new StringBuilder();
                DynamicObjectCollection entirys = (DynamicObjectCollection)rpaScheme.get(ENTRYENTITY);
                ArrayList list = new ArrayList(10);
                for (DynamicObject entity : entirys) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String entityStr = entity.getString("entity.id");
                    String nameStr = entity.getString("entity.name");
                    String scopeStr = entity.getString(ENTITYSCOPE);
                    String numberStr = entity.getString("entity.number");
                    map.put("id", entityStr);
                    map.put(SCOPE, scopeStr);
                    map.put(NUMBER, numberStr);
                    map.put("name", nameStr);
                    list.add(map);
                    if (!StringUtils.isNotEmpty((String)entityStr) || !StringUtils.isNotEmpty((String)scopeStr)) continue;
                    int scope = Integer.parseInt(scopeStr);
                    this.buildPageViewShowName(sb, nameStr, scope);
                }
                if (StringUtils.isEmpty((String)sb.toString())) {
                    this.setValue(ENTITYACTION, sb.toString());
                } else {
                    this.setValue(ENTITYACTION, sb.substring(0, sb.length() - 1));
                    this.getPageCache().put(ENTITYACTION, SerializationUtils.toJsonString(list));
                }
                if (this.getModel().getValue(SCHEME) != null) {
                    Long schemeid = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
                    this.setIniLabel(schemeid);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u673a\u5668\u4eba\u65b9\u6848\u4e2d\u7684\u96c6\u6210\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u88ab\u5220\u9664\u3002", (String)"ISRpaSchemeListPlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                this.getView().setVisible(Boolean.valueOf("1".equals(rpaScheme.getString(UNATTENDEDTYPE))), new String[]{RUNROBOT});
            }
        }
        this.loadComboItem();
        this.getRpaRobotItem();
        String agentid = this.getModel().getValue("agentid") != null ? this.getModel().getValue("agentId").toString() : FILEADDRESS;
        String proccode = this.getModel().getValue("proccode") != null ? this.getModel().getValue("proccode").toString() : FILEADDRESS;
        this.setValue(RPAPROCESS, proccode);
        this.setValue(RUNROBOT, agentid);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        Long modelid = null;
        if (StringUtils.isNotEmpty((String)modelId)) {
            modelid = LongUtil.toLong((Object)modelId);
            this.setValue(MODEL, modelid);
        }
        this.getModel().setDataChanged(false);
        this.getModel().updateCache();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTITYACTION});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MULTITEMPLATE});
        this.setFileNameClickLabel("1", "2");
        this.setControlVisible();
    }

    private void loadComboItem() {
        ComboEdit processComboEdit = (ComboEdit)this.getControl(RPAPROCESS);
        HashMap<String, String> processCatch = new HashMap<String, String>(16);
        try {
            List processList = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessList", (Object[])new Object[]{RequestContext.get().getUserId(), null});
            if (CollectionUtils.isNotEmpty((Collection)processList)) {
                ArrayList<ComboItem> processComboItems = new ArrayList<ComboItem>(processList.size());
                for (Map processMap : processList) {
                    ComboItem processComboItem = new ComboItem();
                    String processValue = processMap.get("procCode") + " " + processMap.get("procName");
                    processComboItem.setCaption(new LocaleString(processValue));
                    processComboItem.setValue((String)processMap.get("procCode"));
                    processComboItems.add(processComboItem);
                    processComboEdit.setComboItems(processComboItems);
                    processCatch.put((String)processMap.get("procCode"), processValue + " " + processMap.get("id"));
                }
            }
            this.getPageCache().put("processCatch", SerializationUtils.toJsonString(processCatch));
        }
        catch (Exception e) {
            ComboItem processComboItem = new ComboItem();
            processComboItem.setCaption(new LocaleString("GZW1 GZW1"));
            processComboItem.setValue("GZW1");
            ArrayList<ComboItem> processComboItems = new ArrayList<ComboItem>(1);
            processComboItems.add(processComboItem);
            processComboEdit.setComboItems(processComboItems);
            processCatch.put("GZW1", "GZW1 GZW1 id1111");
            this.getPageCache().put("processCatch", SerializationUtils.toJsonString(processCatch));
            log.error("RPA loadComboItem error", (Throwable)e);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        this.getModel().updateCache();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MODEL});
        String scheme = this.getModel().getValue(SCHEME) == null ? FILEADDRESS : ((DynamicObject)this.getModel().getValue(SCHEME)).getString("issrc.number");
        this.setJQControlShow("JQ".equals(scheme));
        this.getView().setEnable(Boolean.valueOf(true), new String[]{CON_FILE_ADDRESS});
        this.setControlVisible();
        this.getPageCache().put("bcm_isrpascheme", "true");
    }

    private boolean adjustNumberIsExist(Long modelId, String number) {
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u7801\u6548\u9a8c\u3002", (String)"IsRpaSchemePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.and(NUMBER, "=", (Object)number);
        return QueryServiceHelper.exists((String)"bcm_isrpascheme", (QFilter[])qfBuilder.toArray());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_save".equalsIgnoreCase(key)) {
            if (this.actionSave().booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"IsRpaSchemePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if ("btn_close".equalsIgnoreCase(key)) {
            this.closeRpascheme();
        }
    }

    private String setCurrency() {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        qfBuilder.add(NUMBER, "=", (Object)"DC");
        DynamicObject cyDy = BusinessDataServiceHelper.loadSingle((String)"bcm_currencymembertree", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
        if (cyDy == null) {
            qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            qfBuilder.add(NUMBER, "=", (Object)"EC");
            cyDy = BusinessDataServiceHelper.loadSingle((String)"bcm_currencymembertree", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
        }
        return String.valueOf(cyDy.getLong("id"));
    }

    private Boolean actionSave() {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            block50: {
                Object robotMap;
                String[] rpaprocessList;
                String progressValue;
                DynamicObject rpaScheme;
                String currencyStr;
                String scenarioStr;
                String description;
                String schemeStr;
                String number;
                String modelid;
                String cacheScope;
                Long strId;
                String name;
                block51: {
                    name = this.getModel().getValue("name").toString();
                    strId = (Long)this.getModel().getValue("id");
                    try {
                        Object reportdataObj;
                        cacheScope = this.getPageCache().get(ENTITYACTION);
                        if (!StringUtils.isNotEmpty((String)cacheScope)) break block50;
                        modelid = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
                        number = this.getModel().getValue(NUMBER).toString();
                        schemeStr = UserSelectUtil.getF7SelectId(this.getView(), SCHEME);
                        description = this.getModel().getValue("description").toString();
                        scenarioStr = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
                        currencyStr = UserSelectUtil.getF7SelectId(this.getView(), "currency");
                        if (currencyStr == null) {
                            currencyStr = this.setCurrency();
                        }
                        if (this.checkNotEmpty(number, name, scenarioStr, currencyStr, schemeStr, reportdataObj = this.getModel().getValue("reportdata")).booleanValue()) break block51;
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    catch (Exception e) {
                        try {
                            if (null != this.getPageCache().get(IS_AUTO_CREATE_NUMBER) && BooleanUtils.toBoolean((String)this.getPageCache().get(IS_AUTO_CREATE_NUMBER))) {
                                CodeRuleUtil.recycleCodeRuleNumber("bcm_isrpascheme", this.getModel().getValue(NUMBER).toString());
                            }
                            tx.markRollback();
                            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "IsRpaSchemePlugin_16", FI_BCM_FORMPLUGIN, "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u5931\u8d25\u3002", "IsRpaSchemePlugin_33", FI_BCM_FORMPLUGIN, new String[]{name}));
                            throw new KDBizException(ThrowableHelper.toString((Exception)e));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                }
                Long scheme = LongUtil.toLong((Object)schemeStr);
                Long scenario = LongUtil.toLong((Object)scenarioStr);
                Long currency = LongUtil.toLong((Object)currencyStr);
                String taskId = this.getModel().getValue("taskid") != null ? this.getModel().getValue("taskid").toString() : FILEADDRESS;
                String excstatus = "0";
                Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
                if (strId == null || strId == 0L) {
                    if (StringUtils.isNotEmpty((String)modelid) && this.adjustNumberIsExist(LongUtil.toLong((Object)modelid), number)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"IsRpaSchemePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    rpaScheme = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isrpascheme");
                    rpaScheme.set("creator", (Object)userId);
                    rpaScheme.set("excstatus", (Object)excstatus);
                    rpaScheme.set(STATUS, (Object)0);
                    rpaScheme.set("createdate", (Object)TimeServiceHelper.now());
                } else {
                    rpaScheme = BusinessDataServiceHelper.loadSingle((Object)strId, (String)"bcm_isrpascheme");
                    if (rpaScheme != null && rpaScheme.getBoolean(STATUS)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u751f\u6548\u4e0d\u80fd\u4fee\u6539\u3002", (String)"IsRpaSchemePlugin_30", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                }
                if (rpaScheme == null) {
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                String rpaprocess = (String)this.getModel().getValue(RPAPROCESS);
                Map progressMap = (Map)JSON.parseObject((String)this.getPageCache().get("processCatch"), Map.class);
                if (progressMap != null && StringUtils.isNotEmpty((String)(progressValue = (String)progressMap.get(rpaprocess))) && (rpaprocessList = progressValue.split(" ")).length >= 3) {
                    String proccode = rpaprocessList[0];
                    String procname = rpaprocessList[1];
                    String procver = FILEADDRESS;
                    if (rpaScheme != null) {
                        rpaScheme.set(RPAPROCESS, (Object)rpaprocess);
                        rpaScheme.set("procver", (Object)procver);
                        rpaScheme.set("proccode", (Object)proccode);
                        rpaScheme.set("procname", (Object)procname);
                    }
                }
                String runrobot = (String)this.getModel().getValue(RUNROBOT);
                Object value = this.getModel().getValue(UNATTENDEDTYPE);
                if ("1".equals(value)) {
                    robotMap = (Map)JSON.parseObject((String)this.getPageCache().get("robotCatch"), Map.class);
                    StringBuilder agentName = new StringBuilder();
                    if (StringUtils.isNotEmpty((String)runrobot) && robotMap != null) {
                        String[] robots;
                        runrobot = IsRpaSchemeUtil.trimFirstAndLastChar((String)runrobot, (String)",");
                        for (String robot : robots = runrobot.split(",")) {
                            String[] rpaRunrobotList;
                            String robotValue = (String)robotMap.get(robot);
                            if (!StringUtils.isNotEmpty((String)robotValue) || (rpaRunrobotList = robotValue.split(" ")).length != 2) continue;
                            agentName.append(rpaRunrobotList[0]).append(",");
                        }
                    }
                    if (rpaScheme != null) {
                        rpaScheme.set(RUNROBOT, (Object)runrobot);
                        rpaScheme.set("agentid", (Object)runrobot);
                        rpaScheme.set("agentName", (Object)(agentName.length() > 0 ? agentName.substring(0, agentName.length() - 1) : FILEADDRESS));
                    }
                } else if (rpaScheme != null) {
                    rpaScheme.set(RUNROBOT, (Object)FILEADDRESS);
                    rpaScheme.set("agentid", (Object)FILEADDRESS);
                    rpaScheme.set("agentName", (Object)FILEADDRESS);
                }
                if (rpaScheme == null) {
                    robotMap = false;
                    return robotMap;
                }
                rpaScheme.set(UNATTENDEDTYPE, value);
                rpaScheme.set(MODEL, (Object)modelid);
                rpaScheme.set(NUMBER, (Object)number);
                rpaScheme.set("name", (Object)name);
                rpaScheme.set(SCHEME, (Object)scheme);
                String fileaddress = this.getModel().getValue(CON_FILE_ADDRESS).toString();
                rpaScheme.set(CON_FILE_ADDRESS, (Object)fileaddress);
                rpaScheme.set("description", (Object)description);
                rpaScheme.set("scenario", (Object)scenario);
                rpaScheme.set("currency", (Object)currency);
                rpaScheme.set("taskId", (Object)taskId);
                rpaScheme.set("modifier", (Object)userId);
                rpaScheme.set("modifiydate", (Object)TimeServiceHelper.now());
                DynamicObjectCollection entirys = new DynamicObjectCollection();
                Object entity = null;
                List list = (List)JSON.parseObject((String)cacheScope, List.class);
                rpaScheme.set(REPORTENTRY, (Object)this.getModel().getEntryEntity(REPORTENTRY));
                rpaScheme.set(ENTRYENTITY, (Object)this.getModel().getEntryEntity(ENTRYENTITY));
                String entityFlowStatus = this.getModel().getValue("entityflowstatus").toString();
                entityFlowStatus = IsRpaSchemeUtil.trimFirstAndLastChar((String)entityFlowStatus, (String)",");
                rpaScheme.set("entityflowstatus", (Object)entityFlowStatus);
                String reportStatus = this.getModel().getValue("reportstatus").toString();
                reportStatus = IsRpaSchemeUtil.trimFirstAndLastChar((String)reportStatus, (String)",");
                rpaScheme.set("reportstatus", (Object)reportStatus);
                rpaScheme.set(FILE_TYPE, (Object)this.getModel().getValue(FILE_TYPE).toString());
                rpaScheme.set(CON_CREATE_INI_FILE, this.getModel().getValue(CON_CREATE_INI_FILE));
                rpaScheme.set(CON_MERGE_INI_FILE, this.getModel().getValue(CON_MERGE_INI_FILE));
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpaScheme});
                if (strId == null || strId == 0L) {
                    this.getModel().setValue("id", rpaScheme.getPkValue());
                }
                this.saveRpaFileModel(LongUtil.toLong((Object)rpaScheme.getPkValue()));
                this.saveDefaultIni(scheme);
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "IsRpaSchemePlugin_16", FI_BCM_FORMPLUGIN, "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f\u3002", "IsRpaSchemePlugin_32", FI_BCM_FORMPLUGIN, new String[]{name}));
                this.removeCache(IS_AUTO_CREATE_NUMBER);
                this.getModel().setDataChanged(false);
                this.getModel().updateCache();
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"IsRpaSchemePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            Boolean bl = Boolean.FALSE;
            return bl;
        }
    }

    private void saveDefaultIni(Long schemeId) {
        QFilter pf = new QFilter(SCHEME, "=", (Object)schemeId);
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_iniruledata", (String)VALUE, (QFilter[])new QFilter[]{pf});
        if (load != null && load.size() == 0) {
            List<String> returnData = Arrays.asList("enterpriseCode", "reportTypeCode");
            IntegrationUtil.saveIniRule(returnData, (Long)schemeId);
        }
    }

    private String getOperationSave(Long strId) {
        if (strId == null || strId == 0L) {
            return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"IsRpaSchemePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4fee\u6539", (String)"IsRpaSchemePlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private Boolean checkNotEmpty(String number, String name, String scenarioStr, String currencyStr, String schemeStr, Object reportdata) {
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7f16\u7801\u3002", (String)"IsRpaSchemePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (StringUtils.isEmpty((String)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u540d\u79f0\u3002", (String)"IsRpaSchemePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (StringUtils.isEmpty((String)scenarioStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"IsRpaSchemePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (StringUtils.isEmpty((String)schemeStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"IsRpaSchemePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"IsRpaSchemePlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(REPORTENTRY))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u3002", (String)"IsRpaSchemePlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        IDataModel model = this.getModel();
        Object entityflowstatus = model.getValue("entityflowstatus");
        if (entityflowstatus == null || StringUtils.isEmpty((String)entityflowstatus.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u7ec4\u7ec7\u6d41\u7a0b\u72b6\u6001\u3002", (String)"IsRpaSchemePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Object reportstatus = model.getValue("reportstatus");
        if (reportstatus == null || StringUtils.isEmpty((String)reportstatus.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62a5\u8868\u7f16\u5236\u72b6\u6001\u3002", (String)"IsRpaSchemePlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (this.getModel().getValue(FILE_TYPE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6587\u4ef6\u7c7b\u578b\u3002", (String)"IsRpaSchemePlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        QFilter qf = new QFilter("id", "=", (Object)LongUtil.toLong((Object)schemeStr));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number", (QFilter[])qf.toArray());
        String source = dynamicObject.getString("issrc.number");
        if (dynamicObject != null && source.equals("JQ")) {
            Object fileAddress = model.getValue(CON_FILE_ADDRESS);
            String fileType = (String)this.getModel().getValue(FILE_TYPE);
            if (!fileType.equals("4")) {
                if (fileAddress == null || StringUtils.isEmpty((String)fileAddress.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4fdd\u5b58\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IsRpaSchemePlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return Boolean.FALSE;
                }
                String pattern = "^[A-z]:(\\\\[^|><?*\":\\/]*)*(?<!\\\\)$";
                if (!fileAddress.toString().matches(pattern)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4fdd\u5b58\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ef\u4ee5\u53c2\u7167\u4f8b\u5b50\uff0c\u4f8b\u5982\uff1a%s\u3002", (String)"ReportMultiExportPlugin_36", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), "D:\\RPA"));
                    return Boolean.FALSE;
                }
            }
        }
        Boolean isAutoCreateNumber = null != this.getPageCache().get(IS_USE_CODE_RULE) && Boolean.parseBoolean(this.getPageCache().get(IS_USE_CODE_RULE)) && this.getPageCache().get(SHOW_NUMBER).equals(number);
        this.getPageCache().put(IS_AUTO_CREATE_NUMBER, isAutoCreateNumber.toString());
        return Boolean.TRUE;
    }

    private void openMultiF7(String key, String dim) {
        FormShowParameter para = new FormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getModel().getValue(key) == null || StringUtils.isEmpty((String)this.getModel().getValue(key).toString())) {
            this.setValue(key, null);
            this.getPageCache().remove(key);
        }
        params.put("dimension", "1");
        params.put("sign", key);
        params.put("isUpDownBtn", true);
        params.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        para.setCustomParams(params);
        if ("InternalCompany".equalsIgnoreCase(dim)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7-\u6210\u5458\u9009\u62e9", (String)"IsRpaSchemePlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList cache = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
            int size = entryentity.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject entity = (DynamicObject)entryentity.get(i);
                if (entity == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(NUMBER, entity.getString("entity.number"));
                map.put(SCOPE, entity.getString(ENTITYSCOPE));
                map.put("name", entity.getString("entity.name"));
                map.put("id", entity.getString("entity.id"));
                map.put("seq", String.valueOf(i + 1));
                cache.add(map);
            }
        }
        this.getPageCache().put(key, SerializationUtils.toJsonString(cache));
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && ENTITYACTION.equals(actionId)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (doc != null) {
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(10);
                for (DynamicObject dot : doc) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dot.get(4).toString());
                    map.put(SCOPE, dot.get(5).toString());
                    map.put(NUMBER, dot.get(2).toString());
                    map.put("name", dot.get(3).toString());
                    map.put("seq", dot.get(1).toString());
                    this.buildPageViewShowName(sb, dot.get(3).toString(), dot.getInt(5));
                    list.add(map);
                }
                if (StringUtils.isEmpty((String)sb.toString())) {
                    this.setValue(actionId, sb.toString());
                    this.getPageCache().remove(actionId);
                } else {
                    this.setValue(actionId, sb.substring(0, sb.length() - 1));
                    this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
                }
                this.setDataEntry(doc, ENTRYENTITY);
            }
        } else if (INI_CLICK.equals(actionId)) {
            List returnData = (List)closedCallBackEvent.getReturnData();
            Long schemeid = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
            IntegrationUtil.saveIniRule((Object)returnData, (Long)schemeid);
            if (returnData != null) {
                String ruleNumbers = returnData.stream().map(r -> RpaIniFileEnum.getNameByCode((String)r)).collect(Collectors.joining(JOIN_STR));
                Label iniclickLabel = (Label)this.getView().getControl(INI_CLICK);
                iniclickLabel.setText(StringUtils.isEmpty((String)ruleNumbers) ? ResManager.loadKDString((String)"\u4e45\u5176\u7ec4\u7ec7\u7f16\u7801\u89c4\u5219", (String)"ISDimMemberAndComSettingPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ruleNumbers);
            }
        } else if ("1".equals(actionId) || "2".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            RpaFileModel rpaFileModel = this.getRpaFileModel(actionId);
            rpaFileModel.setJoinsymbol((String)returnData.get("joiner"));
            rpaFileModel.setCodeList((List)returnData.get("ruleNumbers"));
            rpaFileModel.setTextvalue((String)returnData.get("txt"));
            this.setRpaFileModel(rpaFileModel);
            this.setFileNameClickLabel(actionId);
        }
    }

    private void setDataEntry(DynamicObjectCollection returnData, String dataType) {
        if (returnData == null) {
            return;
        }
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl(dataType);
        int[] selectRows = entryGrid.getSelectRows();
        HashSet<Integer> listRows = new HashSet<Integer>(returnData.size());
        model.deleteEntryData(dataType);
        for (DynamicObject row : returnData) {
            int newEntryRow = model.createNewEntryRow(dataType);
            if (ENTRYENTITY.equals(dataType)) {
                model.setValue(ENTITY, row.get("mid1"), newEntryRow);
                model.setValue(ENTITYSCOPE, row.get("filltypevalue1"), newEntryRow);
            } else {
                model.setValue("basedatafield", row.get("mid1"), newEntryRow);
            }
            listRows.add(newEntryRow);
        }
        this.setDefaultSelectRows(entryGrid, listRows, selectRows);
    }

    private void setDefaultSelectRows(EntryGrid entryGrid, Set<Integer> listRows, int[] selectRows) {
        for (int selectRow : selectRows) {
            listRows.add(selectRow);
        }
        if (listRows.size() == 0) {
            return;
        }
        int[] rows = new int[listRows.size()];
        int index = 0;
        for (Integer row : listRows) {
            rows[index++] = row;
        }
        entryGrid.selectRows(rows, rows[0]);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (args.getSource() instanceof NewEntry) {
            args.setCancel(true);
            if ("newentity".equals(operateKey)) {
                this.openMultiF7(ENTITYACTION, ENTITY);
                args.setCancel(true);
            } else if ("newreport".equals(operateKey)) {
                BasedataEdit multitemplate = (BasedataEdit)this.getView().getControl(MULTITEMPLATE);
                multitemplate.click();
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"IsRpaSchemePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(",");
        }
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    private void closeRpascheme() {
        if (this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u786e\u8ba4\u9000\u51fa\uff1f", (String)"IsRpaSchemePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_rpascheme", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key = e.getCallBackId();
        if (key != null && "close_rpascheme".equals(key) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (SCHEME.equals(key)) {
            boolean isJQ = false;
            String fileaddress = null;
            String schemeStr = UserSelectUtil.getF7SelectId(this.getView(), SCHEME);
            if (StringUtils.isNotEmpty((String)schemeStr)) {
                QFilter qf = new QFilter("id", "=", (Object)LongUtil.toLong((Object)schemeStr));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number", (QFilter[])qf.toArray());
                String source = dynamicObject.getString("issrc.number");
                TextEdit edit = (TextEdit)this.getView().getControl(CON_FILE_ADDRESS);
                if (StringUtils.isNotEmpty((String)source) && source.equals("JQ")) {
                    Tips tips = new Tips();
                    StringBuilder content = new StringBuilder();
                    int index = 0;
                    content.append(ResManager.loadKDString((String)"\u7528\u4e8e\u751f\u6210INI\u53c2\u6570\u6587\u4ef6\uff0c\u5bfc\u5165\u4e45\u5176\u7684\u6570\u636e\u6587\u4ef6\u9700\u8981\u653e\u5165\u8be5\u76ee\u5f55\u4e0b\u3002", (String)"IsRpaSchemePlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    List linkData = Tips.createLinkData((TipsLink)new TipsLink(index, new LocaleString(ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65", (String)"IsRpaSchemePlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), "next"));
                    tips.setType("text");
                    tips.setTitle(new LocaleString(FILEADDRESS));
                    tips.setContent(new LocaleString(content.toString()));
                    tips.setLink(false);
                    tips.setLinkData(linkData);
                    edit.addTips(tips);
                    isJQ = true;
                    fileaddress = FILEADDRESS;
                    this.setIniLabel(LongUtil.toLong((Object)schemeStr));
                } else if (StringUtils.isNotEmpty((String)source) && source.equals("EXCEL")) {
                    edit.hideTips();
                }
            }
            this.setJQControlShow(isJQ);
            this.getModel().setValue(CON_FILE_ADDRESS, fileaddress);
            this.getModel().setValue(CON_CREATE_INI_FILE, (Object)isJQ);
            this.setControlVisible();
        } else if (RPAPROCESS.equals(key)) {
            this.getRpaRobotItem();
        } else if (UNATTENDEDTYPE.equals(key)) {
            String newValue = e.getChangeSet()[0].getNewValue().toString();
            boolean isAppoint = "1".equalsIgnoreCase(newValue);
            this.getView().setVisible(Boolean.valueOf(isAppoint), new String[]{RUNROBOT});
            if (!isAppoint) {
                this.getModel().setValue(RUNROBOT, null);
            }
        } else if ("reportdata".equals(key)) {
            String reportDataType = (String)e.getChangeSet()[0].getNewValue();
            ReportDataSelectScheme rdss = ReportDataSelectScheme.getReportDataSelectScheme(this.getPageCache());
            Map<String, DynamicObject> dimNum2Items = rdss.searchSchemeByNumber(reportDataType);
            if (dimNum2Items.get(DimTypesEnum.CURRENCY.getNumber()) != null) {
                this.getModel().setValue("currency", (Object)dimNum2Items.get(DimTypesEnum.CURRENCY.getNumber()));
            }
            if (dimNum2Items.get(DimTypesEnum.SCENARIO.getNumber()) != null) {
                this.getModel().setValue("scenario", (Object)dimNum2Items.get(DimTypesEnum.SCENARIO.getNumber()));
            }
        } else if (CON_CREATE_INI_FILE.equals(key)) {
            Boolean createIniFileStatus = (Boolean)this.getModel().getValue(CON_CREATE_INI_FILE);
            if (!createIniFileStatus.booleanValue()) {
                this.getModel().setValue(CON_MERGE_INI_FILE, (Object)Boolean.FALSE);
                this.getView().setVisible(Boolean.FALSE, new String[]{CON_MERGE_INI_FILE});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{CON_MERGE_INI_FILE});
            }
        } else if (FILE_TYPE.equals(key)) {
            this.setControlVisible();
        }
    }

    private void setControlVisible() {
        String fileType = (String)this.getModel().getValue(FILE_TYPE);
        if ("4".equals(fileType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CON_INI_ENTITY_CODERULE, INI_CLICK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelapfilename", FILE_NAME_CLICK, "labelapsheet", SHEET_NAME_CLICK, CON_CREATE_INI_FILE, CON_MERGE_INI_FILE, CON_FILE_ADDRESS});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelapfilename", FILE_NAME_CLICK, "labelapsheet", SHEET_NAME_CLICK, CON_CREATE_INI_FILE, CON_MERGE_INI_FILE, CON_INI_ENTITY_CODERULE, INI_CLICK, CON_FILE_ADDRESS});
        }
    }

    private void getRpaRobotItem() {
        Map processMap = (Map)JSON.parseObject((String)this.getPageCache().get("processCatch"), Map.class);
        MulComboEdit robotComboEdit = (MulComboEdit)this.getControl(RUNROBOT);
        HashMap<String, String> robotCatch = new HashMap<String, String>(16);
        try {
            if (processMap != null) {
                String processValue = (String)this.getModel().getValue(RPAPROCESS);
                if (processValue == null) {
                    return;
                }
                String process = (String)processMap.get(processValue);
                String[] processList = process.split(" ");
                if (processList.length == 3) {
                    String processId = processList[2];
                    List robotList = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getRobotList", (Object[])new Object[]{processId});
                    if (CollectionUtils.isNotEmpty((Collection)robotList)) {
                        ArrayList<ComboItem> robotComboItems = new ArrayList<ComboItem>(robotList.size());
                        for (Map robotMap : robotList) {
                            ComboItem robotComboItem = new ComboItem();
                            String robotValue = robotMap.get("agentName") + " " + robotMap.get("id");
                            robotComboItem.setCaption(new LocaleString(robotValue));
                            robotComboItem.setValue(String.valueOf(robotMap.get("id")));
                            robotComboItems.add(robotComboItem);
                            robotComboEdit.setComboItems(robotComboItems);
                            robotCatch.put(String.valueOf(robotMap.get("id")), robotValue);
                        }
                    }
                    this.getPageCache().put("robotCatch", SerializationUtils.toJsonString(robotCatch));
                }
            }
        }
        catch (Exception exception) {
            ComboItem robotComboItem = new ComboItem();
            robotComboItem.setCaption(new LocaleString("abcdefg 110"));
            robotComboItem.setValue("110");
            ComboItem robotComboItem2 = new ComboItem();
            robotComboItem2.setCaption(new LocaleString("xxxxx 111"));
            robotComboItem2.setValue("111");
            ArrayList<ComboItem> robotComboItems = new ArrayList<ComboItem>(1);
            robotComboItems.add(robotComboItem);
            robotComboItems.add(robotComboItem2);
            robotComboEdit.setComboItems(robotComboItems);
            robotCatch.put("110", "abcdefg 110");
            robotCatch.put("111", "xxxxx 111");
            this.getPageCache().put("robotCatch", SerializationUtils.toJsonString(robotCatch));
            log.error("RPA getRpaRobotItem error", (Throwable)exception);
        }
    }

    private void openRpaFileRule(String key) {
        RpaFileModel rpaFileModel = this.getRpaFileModel(key);
        if (rpaFileModel == null) {
            return;
        }
        FormShowParameter fp = new FormShowParameter();
        fp.setFormId("bcm_filesheetnamerule");
        fp.getOpenStyle().setShowType(ShowType.Modal);
        fp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("filestyle", "C");
        params.put("connectstr", rpaFileModel.getJoinsymbol());
        params.put("txt", rpaFileModel.getTextvalue());
        params.put("defaultruleselect", this.toByteSerialized(rpaFileModel.getCodeList()));
        params.put("issheetclick", Boolean.FALSE);
        params.put("isRpaSchemeType", key);
        String captiong = "1".equals(key) ? ResManager.loadKDString((String)"\u6587\u4ef6\u547d\u540d\u89c4\u5219-\u6587\u4ef6\u540d", (String)"ReportMultiExportPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6587\u4ef6\u547d\u540d\u89c4\u5219-\u6587\u4ef6\u5185sheet\u5de5\u4f5c\u8868\u540d", (String)"ReportMultiExportPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        fp.setCaption(captiong);
        fp.setCustomParams(params);
        this.getView().showForm(fp);
    }

    private void openNameRule() {
        if (this.getModel().getValue(SCHEME) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"IsRpaSchemePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        Long schemeid = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        FormShowParameter fp = new FormShowParameter();
        fp.setFormId("bcm_isinienamerule");
        fp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INI_CLICK);
        fp.setCloseCallBack(closeCallBack);
        HashMap params = new HashMap(16);
        LinkedList<String> selectList = new LinkedList<String>();
        QFilter pf = new QFilter(SCHEME, "=", (Object)schemeid);
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_iniruledata", (String)VALUE, (QFilter[])new QFilter[]{pf}, (String)"ordernum asc");
        if (load.size() > 0) {
            for (int i = 0; i < load.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)load.get(i);
                selectList.add(dynamicObject.getString(VALUE));
            }
        } else {
            selectList.add(RpaIniFileEnum.ENTERPRISECODE.getCode());
            selectList.add(RpaIniFileEnum.REPORTTYPECODE.getCode());
        }
        params.put("defaultruleselect", selectList);
        fp.setCaption(ResManager.loadKDString((String)"\u4e45\u5176\u7ec4\u7ec7\u7f16\u7801\u89c4\u5219", (String)"ISDimMemberAndComSettingPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        fp.setCustomParams(params);
        this.getView().showForm(fp);
    }

    private String getIniClickStr(Long schemeid) {
        String joinStr;
        QFilter pf;
        DynamicObjectCollection load;
        String defaultStr = ResManager.loadKDString((String)"\u672c\u4f01\u4e1a\u4ee3\u7801&\u62a5\u8868\u7c7b\u578b\u7801", (String)"SingleMemMapSheetHandel_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        if (schemeid > 0L && (load = QueryServiceHelper.query((String)"bcm_iniruledata", (String)VALUE, (QFilter[])new QFilter[]{pf = new QFilter(SCHEME, "=", (Object)schemeid)}, (String)"ordernum asc")) != null && StringUtil.isNotEmpty((CharSequence)(joinStr = load.stream().map(r -> RpaIniFileEnum.getNameByCode((String)r.getString(VALUE))).collect(Collectors.joining(JOIN_STR))))) {
            return joinStr;
        }
        return defaultStr;
    }

    private void setIniLabel(Long schemeid) {
        Label iniclickLabel = (Label)this.getView().getControl(INI_CLICK);
        iniclickLabel.setText(this.getIniClickStr(schemeid));
    }

    private void setJQControlShow(boolean isJQ) {
        this.getView().setVisible(Boolean.valueOf(isJQ), new String[]{CON_FILE_ADDRESS, CON_CREATE_INI_FILE, CON_INI_ENTITY_CODERULE, INI_CLICK, CON_MERGE_INI_FILE});
    }

    private Map<String, RpaFileModel> initFileRuleData() {
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        HashMap<String, RpaFileModel> result = new HashMap<String, RpaFileModel>();
        RpaFileModel rpaFileModelFile = null;
        RpaFileModel rpaFileModelsheet = null;
        Object rpaFileModel = null;
        if (pkValue != null && LongUtil.toLong((Object)pkValue) > 0L) {
            String selectProperties = "rpascheme,ordernum,type,namecode,fixedvalue,joinsymbol,creater,createdate,modifier,modifydate";
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("rpascheme", "=", pkValue).add("type", "in", (Object)Sets.newHashSet((Object[])new String[]{"1", "2"}));
            DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_isrpaschemerule", (String)selectProperties, (QFilter[])qfBuilder.toArray());
            rpaFileModelFile = RpaFileModel.getModelByDynamicObject(dys, "1");
            rpaFileModelsheet = RpaFileModel.getModelByDynamicObject(dys, "2");
        } else {
            rpaFileModelFile = new RpaFileModel("1");
            rpaFileModelsheet = new RpaFileModel("2");
        }
        this.getPageCache().put(CACHE_KEY_FILENAME_MODEL, this.toByteSerialized(rpaFileModelFile));
        this.getPageCache().put(CACHE_KEY_SHEETNAME_MODEL, this.toByteSerialized(rpaFileModelsheet));
        result.put(CACHE_KEY_FILENAME_MODEL, rpaFileModelFile);
        result.put(CACHE_KEY_SHEETNAME_MODEL, rpaFileModelsheet);
        return result;
    }

    private String getFileRulCacheByType(String type) {
        return "1".equals(type) ? CACHE_KEY_FILENAME_MODEL : CACHE_KEY_SHEETNAME_MODEL;
    }

    private RpaFileModel getRpaFileModel(String type) {
        String cacheKey = this.getFileRulCacheByType(type);
        String cache = this.getPageCache().get(cacheKey);
        if (StringUtil.isNotEmpty((CharSequence)cache)) {
            return (RpaFileModel)this.deSerializedBytes(cache);
        }
        Map<String, RpaFileModel> resultMap = this.initFileRuleData();
        return resultMap.get(cacheKey);
    }

    private void setRpaFileModel(RpaFileModel model) {
        if (model != null) {
            this.getPageCache().put(this.getFileRulCacheByType(model.getType()), this.toByteSerialized(model));
        }
    }

    private void setFileNameClickLabel(String ... types) {
        for (String type : types) {
            RpaFileModel model = this.getRpaFileModel(type);
            if (model == null) continue;
            String control = FILEADDRESS;
            control = "1".equals(type) ? FILE_NAME_CLICK : SHEET_NAME_CLICK;
            Label nameClickLabel = (Label)this.getView().getControl(control);
            nameClickLabel.setText(RpaFileModel.getShowStr(model));
        }
    }

    private void saveRpaFileModel(Long rpaschemeId) {
        RpaFileModel sheetModel;
        RpaFileModel fileModel = this.getRpaFileModel("1");
        ArrayList<RpaFileModel> models = new ArrayList<RpaFileModel>();
        if (fileModel != null) {
            fileModel.setRpascheme(rpaschemeId);
            models.add(fileModel);
        }
        if ((sheetModel = this.getRpaFileModel("2")) != null) {
            sheetModel.setRpascheme(rpaschemeId);
            models.add(sheetModel);
        }
        RpaFileModel.save(rpaschemeId, models);
    }
}

