/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.model.ImportFailData;
import kd.fi.bcm.business.integrationnew.service.PubMemberMapExportImp;
import kd.fi.bcm.business.integrationnew.service.PubMemberMapImportImp;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PubMemberImportStartPlugin
extends ImportStartPlugin
implements BCMBaseFunction {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(PubMemberImportStartPlugin.class);
    private static final String DIMMAPPINGIDS = "dimMappingIds";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile", "btnimgzipdelete", "txttardimmapping"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String titleName = showParam.getCustomParam("title").toString();
        Label title = (Label)this.getControl("title");
        title.setText(titleName);
        this.getModel().setValue("importtype", (Object)ImportStartData.ImportStartTypeEnum.NEW.getType());
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
            case "btnok": {
                String filePath = (String)this.getModel().getValue("filepath");
                if (StringUtils.isBlank((CharSequence)filePath)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"DIMemberImportStartPlugin3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Long modelId = (Long)parameter.getCustomParam("modelId");
                String modelName = MemberReader.findModelSNumberById((Object)modelId);
                PubMemberMapExportImp exportService = new PubMemberMapExportImp();
                XSSFWorkbook workbook = exportService.exportTemplate(modelId);
                try {
                    String url = ImportAndExportUtil.writeFile(workbook, String.format(ResManager.loadKDString((String)"%1$s_\u516c\u5171\u6210\u5458\u6620\u5c04\u5bfc\u51fa\u6a21\u677f", (String)"PubMemberMappingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelName));
                    this.downloadFile(url, null, null);
                    break;
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f\u5931\u8d25", (String)"DIMemberImportStartPlugin2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            case "txttardimmapping": {
                this.showDimMappingF7();
            }
        }
    }

    private void showDimMappingF7() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_pubmappingselect");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long modelId = (Long)parameter.getCustomParam("modelId");
        showParameter.setCustomParam("modelId", (Object)modelId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        showParameter.setShowTitle(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimMapCallBack"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("dimMapCallBack")) {
            List dimMapIds = (List)closedCallBackEvent.getReturnData();
            if (null == dimMapIds) {
                return;
            }
            List<String> names = this.getMappingSetByItemId(dimMapIds);
            String dimMappingNames = String.join((CharSequence)";", names);
            this.getModel().setValue("txttardimmapping", (Object)dimMappingNames);
            this.getPageCache().put(DIMMAPPINGIDS, JSONObject.toJSONString((Object)dimMapIds));
        }
    }

    private List<String> getMappingSetByItemId(List<Long> dimMapIds) {
        QFilter filters = new QFilter("entryentity.id", "in", dimMapIds);
        DynamicObject mappingSet = BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.cusname, entryentity.id", (QFilter[])filters.toArray());
        DynamicObjectCollection entryentity = mappingSet.getDynamicObjectCollection("entryentity");
        ArrayList<String> names = new ArrayList<String>(16);
        for (DynamicObject obj : entryentity) {
            if (!dimMapIds.contains(obj.getLong("id"))) continue;
            names.add(obj.getString("cusname"));
        }
        return names;
    }

    private void importData() {
        String url = (String)this.getModel().getValue("filepath");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long modelId = (Long)parameter.getCustomParam("modelId");
        String impType = this.getModel().getValue("importtype").toString();
        boolean deleteBeforeSave = !ImportStartData.ImportStartTypeEnum.OVERRIDENEW.getType().equals(impType);
        List selectedDimMappingIds = !StringUtils.isEmpty((CharSequence)this.getPageCache().get(DIMMAPPINGIDS)) && !StringUtils.isEmpty((CharSequence)this.getModel().getValue("txttardimmapping").toString()) ? (List)JSONObject.parseObject((String)this.getPageCache().get(DIMMAPPINGIDS), List.class) : this.getDimMapIds(modelId);
        if (CollectionUtil.isEmpty(selectedDimMappingIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u516c\u5171\u6620\u5c04\u3002", (String)"PubMemberMappingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        PubMemberMapImportImp importService = new PubMemberMapImportImp();
        importService.importData(url, selectedDimMappingIds, deleteBeforeSave, modelId);
        this.openTipsPage(importService.getErrorMsgs(), importService.getSuccessCount());
        String modelName = MemberReader.findModelSNumberById((Object)modelId);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u5165\u516c\u5171\u6210\u5458\u6620\u5c04", "AbstractMemMapSheetHandel_19", "fi-bcm-formplugin", "Import public member mapping"), new OPDescMultiLangEnumBridge("%s\u516c\u5171\u6210\u5458\u6620\u5c04\u5bfc\u5165\u6210\u529f", "AbstractMemMapSheetHandel_20", "fi-bcm-formplugin", new String[]{""}));
    }

    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        long modelId = this.getModelId();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)"bcm_pubmemmapping");
        logService.addLog(logInfo);
    }

    private String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u516c\u5171\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected List<Long> getDimMapIds(Long modelId) {
        QFilter filters = new QFilter("model", "in", (Object)modelId);
        DynamicObject mappingSet = BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id", (QFilter[])filters.toArray());
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (mappingSet == null) {
            return ids;
        }
        DynamicObjectCollection entryentity = mappingSet.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryentity) {
            ids.add(obj.getLong("id"));
        }
        return ids;
    }

    private void openTipsPage(List<Object> errorMsgs, Integer successCount) {
        String titleInfo = errorMsgs.size() > 0 ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5c55\u5f00\u8be6\u60c5\u67e5\u770b\u5931\u8d25\u6570\u636e", (String)"DIDeriveRuleStartPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount) : String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%1$s\u884c\u3002", (String)"DIDeriveRuleStartPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount);
        String detailInfo = "";
        detailInfo = errorMsgs.size() > 2000 ? errorMsgs.subList(0, 1999).stream().map(e -> ((ImportFailData)e).toMappingSetString()).collect(Collectors.joining("")) : errorMsgs.stream().map(e -> ((ImportFailData)e).toMappingSetString()).collect(Collectors.joining(""));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("di_membmapimporttip");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)titleInfo);
        showParameter.setCustomParam("isAllSuccess", (Object)(errorMsgs.size() == 0 ? 1 : 0));
        showParameter.setCustomParam("detail", (Object)detailInfo);
        this.getView().showForm(showParameter);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            IFormView view = this.getView();
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf("/") + 1));
            model.setValue("filepath", (Object)url);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }
}

