/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.integrationnew.service.PubMemberMapExportImp;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.formplugin.intergration.membermap.handel.MapViewManager;
import kd.fi.bcm.formplugin.intergration.membermap.handel.PubAbstractMemMapSheetHandel;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.model.StatusBarModel;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PubMemberMappingPlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier {
    private static final String TOOLBARAP = "toolbarap";
    private static final String TAB_SIMPLE = "simpletab";
    private static final String TREE_SIMPLE = "simpletree";
    private static final String SCHEME = "scheme";
    private static final String MODEL = "model";
    private static final String COMMEM_SPREAD = "commemspread";
    private static final String CACHE_SELECTNODE = "CACHE_SELECTNODE";
    private static final String CACHE_LASTNODE = "CACHE_LASTNODE";
    private static final String CACHE_MEMANDCOMVO = "cache_memandcomvo";
    private SpreadManager spreadManager;
    private MemAndComVO memandcomvo;

    @Override
    public String getSpreadKey() {
        return COMMEM_SPREAD;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBARAP);
        TreeView tree = (TreeView)this.getControl(TREE_SIMPLE);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                PubMemberMappingPlugin.this.treeNodeClickDo(evt);
            }
        });
        this.initSpreadListener();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        e.getProperty().getName();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("close", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "change": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    TreeView tree = (TreeView)this.getControl(TREE_SIMPLE);
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    break;
                }
                if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.changeNode(this.getPageCache().get("nodeId"));
                    break;
                }
                TreeView tree = (TreeView)this.getControl(TREE_SIMPLE);
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                break;
            }
            case "close": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    TreeView tree = (TreeView)this.getControl(TREE_SIMPLE);
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getSpreadManager().getBook().getSheet(0).getUserObject().remove("change");
                this.getView().close();
                break;
            }
            case "refreshSpreadData": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                String nodeid = this.getPageCache().get("nodeid");
                this.changeNode(nodeid);
                break;
            }
            case "save": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                TreeView tree = (TreeView)this.getControl(TREE_SIMPLE);
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                this.doSave();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        TreeView tree;
        String selectedNodeId;
        String itemKey = evt.getItemKey();
        if (!"close".equals(itemKey) && StringUtils.isNotEmpty((String)(selectedNodeId = (tree = this.getCurrentTree()).getTreeState().getFocusNodeId()))) {
            this.checkDimMapping(Long.parseLong(selectedNodeId));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.doSave();
                break;
            }
            case "btn_import": {
                if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\u3002", (String)"ISDimMemberAndComSettingPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.importDimMembers();
                break;
            }
            case "btn_export": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_pubmappingselect");
                Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
                showParameter.setCustomParam("modelId", (Object)modelId);
                OpenStyle openStyle = showParameter.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setWidth("960");
                css.setHeight("580");
                openStyle.setInlineStyleCss(css);
                showParameter.setShowTitle(false);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimMapCallBack"));
                this.getView().showForm(showParameter);
                break;
            }
            case "btn_refresh": {
                this.checkChange();
            }
        }
    }

    private void checkChange() {
        if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4fee\u6539\uff0c\u8981\u653e\u5f03\u4fee\u6539\u7684\u5185\u5bb9\u76f4\u63a5\u5237\u65b0\u5417\uff1f", (String)"RptAdjustOffsetPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("refreshSpreadData", (IFormPlugin)this));
        } else {
            String nodeId = this.getPageCache().get("nodeid");
            this.changeNode(nodeId);
        }
    }

    private void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            Cell cell = this.getSpreadManager().getBook().getSheet(0).getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
            StatusBarModel statusBarModel = new StatusBarModel();
            if (cell.getValue() != null) {
                statusBarModel.setCellNameStr(cell.getValue() + "");
            } else {
                statusBarModel.setCellNameStr("");
            }
            SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), this.getSpreadKey(), statusBarModel);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsPreInsert(excuteinfo)) {
                return;
            }
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> this.getHandel().beforeUpdateMulValue(e));
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> this.getHandel().afterUpdataValue((EventObject)e));
    }

    private boolean checkIsPreInsert(AskExcuteInfo excuteinfo) {
        Integer[] preRow = new Integer[]{0, 1};
        if (excuteinfo.getOperationdata().contains(preRow[0]) || excuteinfo.getOperationdata().contains(preRow[1])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u884c\u5217\u4e0d\u80fd\u5220\u9664\u3002", (String)"ISDimMemberAndComSettingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    private void initModel() {
        if (this.getMemAndComVO() != null) {
            this.getHandel().clearSpread();
        }
        SpreadManager sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        this.cacheSpreadModel(sm);
        this.getPageCache().remove(CACHE_SELECTNODE);
        this.getPageCache().remove(CACHE_LASTNODE);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelId == null) {
            return;
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MODEL});
        this.initTree(modelId);
    }

    private void initTree(Long modelId) {
        TreeNode focusNode;
        DynamicObject[] mappingSets;
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb", (String)"PubMemberMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        ArrayList<TreeNode> children = root.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>(10);
            root.setChildren(children);
        }
        if ((mappingSets = BusinessDataServiceHelper.load((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId)})) == null || mappingSets.length == 0) {
            return;
        }
        DynamicObject mappingSet = mappingSets[0];
        DynamicObjectCollection entryentity = mappingSet.getDynamicObjectCollection("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            return;
        }
        for (DynamicObject mapping : entryentity) {
            TreeNode temp = new TreeNode();
            temp.setId(mapping.getString("id"));
            String text = mapping.getString("cusname");
            temp.setText(text);
            temp.setParentid(root.getId());
            children.add(temp);
        }
        TreeView tree = this.getCurrentTree();
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.setRootVisible(false);
        TreeNode treeNode = focusNode = children.size() > 0 ? (TreeNode)children.get(0) : root;
        if (this.getPageCache().get(CACHE_SELECTNODE) != null) {
            focusNode = new TreeNode(root.getId(), this.getPageCache().get(CACHE_SELECTNODE), "");
        }
        tree.focusNode(focusNode);
        this.treeNodeClickDo(new TreeNodeEvent((Object)tree, (Object)focusNode.getParentid(), (Object)focusNode.getId()));
    }

    public void treeNodeClickDo(TreeNodeEvent evt) {
        String lastNode = this.getPageCache().get(CACHE_LASTNODE);
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put("nodeid", nodeId);
        if (!nodeId.equals(lastNode)) {
            if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("change", (IFormPlugin)this));
                this.getPageCache().put("nodeId", nodeId);
            } else {
                this.changeNode(nodeId);
            }
        }
    }

    private void exportDimMembers(List<Long> dimMapIds) {
        String modelName = ((DynamicObject)this.getModel().getValue(MODEL)).getString("name");
        PubMemberMapExportImp exportService = new PubMemberMapExportImp();
        XSSFWorkbook workbook = exportService.exportData(dimMapIds);
        try {
            String url = ImportAndExportUtil.writeFile(workbook, String.format(ResManager.loadKDString((String)"%1$s_\u516c\u5171\u6210\u5458\u6620\u5c04\u5bfc\u51fa", (String)"PubMemberMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelName));
            this.downloadFile(url, "bcm_dimensionmanager", "3E7+2X6S09FC");
            if (exportService.getErrors().size() > 0) {
                String errors = String.join((CharSequence)";", exportService.getErrors());
                this.getView().showTipNotification(errors);
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u516c\u5171\u6210\u5458\u6620\u5c04", "AbstractMemMapSheetHandel_17", "fi-bcm-formplugin", "Export public member mapping"), new OPDescMultiLangEnumBridge("%s\u516c\u5171\u6210\u5458\u6620\u5c04\u5bfc\u51fa\u6210\u529f", "AbstractMemMapSheetHandel_18", "fi-bcm-formplugin", new String[]{modelName}));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"DIMemberMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u516c\u5171\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void importDimMembers() {
        boolean enable = IntegrationUtil.checkMappingSetEnable((long)0L, (long)this.getModelId());
        if (enable) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6620\u5c04\u5173\u7cfb\u5df2\u542f\u7528\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PubMemberMappingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_pubmemberimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04", (String)"DIMemberMappingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importCloseCallBack"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("importCloseCallBack")) {
            this.getHandel().buildSpread();
        } else if (actionId.equals("dimMapCallBack")) {
            List dimMapIds = (List)closedCallBackEvent.getReturnData();
            if (CollectionUtil.isEmpty((Collection)dimMapIds)) {
                return;
            }
            this.exportDimMembers(dimMapIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeNode(String nodeId) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85", (String)"ISDimMemberAndComSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        try {
            long selectId = Long.parseLong(nodeId);
            if (selectId != 0L) {
                this.checkDimMapping(selectId);
                log.startWatch();
                this.memandcomvo = this.geneMemVO(selectId);
                log.warn("dimMemberAndCom: create memandcomvo");
                this.getHandel().buildSpread();
                log.warn("dimMemberAndCom: buildSpread");
            }
            this.getPageCache().put(CACHE_SELECTNODE, nodeId);
            this.getPageCache().put(CACHE_LASTNODE, nodeId);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void checkDimMapping(long selectId) {
        TreeView treeView = this.getCurrentTree();
        Map node = treeView.getTreeState().getFocusNode();
        DynamicObject dyn = this.getMappingSetByItemId(selectId);
        if (dyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PubMemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject obj = this.getMappingSetItemById(dyn, selectId);
        if (obj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PubMemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String name = obj.getString("cusname");
        if (!name.equals(node.get("text"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PubMemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getMappingSetItemById(DynamicObject dyn, long selectId) {
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryentity) {
            if (obj.getLong("id") != selectId) continue;
            return obj;
        }
        return null;
    }

    private DynamicObject getMappingSetByItemId(long selectId) {
        QFilter filters = new QFilter("entryentity.id", "=", (Object)selectId);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
    }

    private void doSave() {
        boolean enable = IntegrationUtil.checkMappingSetEnable((long)0L, (long)this.getModelId());
        if (enable) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6620\u5c04\u5173\u7cfb\u5df2\u542f\u7528\u4e0d\u80fd\u4fee\u6539\u3002", (String)"PubMemberMappingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), COMMEM_SPREAD, params);
    }

    public void actionSave(String spreadJson) {
        this.getHandel().actionSave();
    }

    private MemAndComVO geneMemVO(Long selectId) {
        MemAndComVO generateMemAndComVO = new MemAndComVO(1, 1, MemAndComVO.VOEnum.M);
        generateMemAndComVO.setDimMapId(selectId.longValue());
        DynamicObject dyn = this.getMappingSetByItemId(selectId);
        DynamicObject dynItem = this.getMappingSetItemById(dyn, selectId);
        if (dynItem == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PubMemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject src = dynItem.getDynamicObject("config");
        String srcNumber = src.getString("number");
        String srcName = src.getString("name");
        Long srcId = src.getLong("id");
        generateMemAndComVO.addSource(srcNumber, srcName, "", srcId.longValue());
        DynamicObject tar = dynItem.getDynamicObject("dimension");
        String tarNumber = tar.getString("number");
        String tarName = tar.getString("name");
        Long tarId = tar.getLong("id");
        generateMemAndComVO.addTarget(tarNumber, tarName, "", tarId.longValue());
        this.getPageCache().put(CACHE_MEMANDCOMVO, this.toByteSerialized(generateMemAndComVO));
        return generateMemAndComVO;
    }

    public MemAndComVO getMemAndComVO() {
        if (this.memandcomvo != null) {
            return this.memandcomvo;
        }
        String serial = this.getPageCache().get(CACHE_MEMANDCOMVO);
        if (!StringUtils.isNotEmpty((String)serial)) {
            return null;
        }
        this.memandcomvo = (MemAndComVO)this.deSerializedBytes(serial);
        return this.memandcomvo;
    }

    private PubAbstractMemMapSheetHandel getHandel() {
        return MapViewManager.getPubViewHandel(this);
    }

    public SpreadManager getSpreadManager() {
        if (this.spreadManager == null) {
            String serial = this.getPageCache().get("KEY_SPREAD_MODEL");
            if (StringUtils.isNotEmpty((String)serial)) {
                this.spreadManager = JsonSerializerUtil.toSpreadManager((String)serial);
            } else {
                this.spreadManager = new SpreadManager(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5c04", (String)"DIMemberMappingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSerial(this.spreadManager));
            }
        }
        return this.spreadManager;
    }

    @Override
    public SpreadManager getSpreadModel() {
        return this.getSpreadManager();
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.spreadManager = spread;
        this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSerial(spread));
    }

    public String getSpreadModelSerial(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    private String getCurrentTab() {
        Tab subTab = (Tab)this.getControl("tabap");
        return subTab.getCurrentTab();
    }

    private TreeView getCurrentTree() {
        return (TreeView)this.getControl(TREE_SIMPLE);
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        this.getHandel().setSpreadF7Item(arg);
    }
}

