/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.fi.bcm.common.enums.integration.RpaIniFileEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class RpaIniFileRulePlugin
extends AbstractBaseFormPlugin {
    private static Map<Character, List<FileNameStyle>> rihtSelects = Maps.newHashMap();
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String SELECTED_OBJ = "selectedobj";
    private static final String TO_SELECT_ENTRY_ENTITY = "toselectentryentity";
    private static final String SELECT_ENTRY_ENTITY = "selectentryentity";
    private static final String TOBE_SELECT_OBJ = "tobeselectobj";
    private static final String TOBE_SELECT_NUMBER = "tobeselectnumber";
    private static final String SELECTED_NUMBER = "selectednumber";
    private static final String IS_SELECT = "isselect";

    private void initMap() {
        ArrayList ls1 = Lists.newArrayList();
        FileNameStyle fns01 = new FileNameStyle('1', RpaIniFileEnum.ENTERPRISECODE.getCode(), RpaIniFileEnum.ENTERPRISECODE.getName());
        FileNameStyle fns02 = new FileNameStyle('1', RpaIniFileEnum.YEAR.getCode(), RpaIniFileEnum.YEAR.getName());
        FileNameStyle fns03 = new FileNameStyle('1', RpaIniFileEnum.PERIOD.getCode(), RpaIniFileEnum.PERIOD.getName());
        FileNameStyle fns04 = new FileNameStyle('1', RpaIniFileEnum.REPORTTYPECODE.getCode(), RpaIniFileEnum.REPORTTYPECODE.getName());
        ls1.add(fns01);
        ls1.add(fns02);
        ls1.add(fns03);
        ls1.add(fns04);
        rihtSelects.put(Character.valueOf('1'), ls1);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btngo", "btnback", "bar_confirm");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initMap();
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData(TO_SELECT_ENTRY_ENTITY);
        this.getModel().deleteEntryData(SELECT_ENTRY_ENTITY);
        List list = (List)this.getView().getFormShowParameter().getCustomParam("defaultruleselect");
        int fsize = 0;
        this.getModel().beginInit();
        for (Map.Entry<Character, List<FileNameStyle>> entry : rihtSelects.entrySet()) {
            List<FileNameStyle> ls = entry.getValue();
            this.getModel().batchCreateNewEntryRow(TO_SELECT_ENTRY_ENTITY, ls.size());
            if (fsize == 0) {
                this.getModel().batchCreateNewEntryRow(SELECT_ENTRY_ENTITY, list.size());
            }
            int j = 0;
            for (int i = 0; i < ls.size(); ++i) {
                if (!list.contains(ls.get(i).number)) {
                    this.getModel().setValue(TOBE_SELECT_OBJ, (Object)ls.get(i).name, fsize + j);
                    this.getModel().setValue(TOBE_SELECT_NUMBER, (Object)ls.get(i).number, fsize + j);
                    ++j;
                    continue;
                }
                this.getModel().setValue(SELECTED_OBJ, (Object)ls.get(i).name, list.indexOf(ls.get(i).number));
                this.getModel().setValue(SELECTED_NUMBER, (Object)ls.get(i).number, list.indexOf(ls.get(i).number));
                this.getModel().deleteEntryRow(TO_SELECT_ENTRY_ENTITY, fsize + j);
            }
            fsize = this.getModel().getEntryEntity(TO_SELECT_ENTRY_ENTITY).size();
        }
        this.getModel().endInit();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btngo": {
                EntryGrid toEntryGrid = (EntryGrid)this.getView().getControl(TO_SELECT_ENTRY_ENTITY);
                int selectSize = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY).size();
                int[] selectRows = toEntryGrid.getSelectRows();
                int r = 0;
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject toSelectEntryobj = this.getModel().getEntryRowEntity(TO_SELECT_ENTRY_ENTITY, selectRows[i]);
                    if (toSelectEntryobj.getBoolean(IS_SELECT)) continue;
                    this.getModel().createNewEntryRow(SELECT_ENTRY_ENTITY);
                    this.getModel().setValue(SELECTED_OBJ, toSelectEntryobj.get(TOBE_SELECT_OBJ), selectSize + r);
                    this.getModel().setValue(SELECTED_NUMBER, toSelectEntryobj.get(TOBE_SELECT_NUMBER), selectSize + r);
                    this.getModel().setValue(IS_SELECT, (Object)Boolean.TRUE, selectRows[i]);
                    this.getModel().deleteEntryRow(TO_SELECT_ENTRY_ENTITY, selectRows[i]);
                    ++r;
                }
                break;
            }
            case "btnback": {
                EntryGrid sEntryGrid = (EntryGrid)this.getView().getControl(SELECT_ENTRY_ENTITY);
                DynamicObjectCollection toSDoc = this.getModel().getEntryEntity(TO_SELECT_ENTRY_ENTITY);
                DynamicObjectCollection sDoc = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY);
                int size = toSDoc.size();
                int[] selects = sEntryGrid.getSelectRows();
                for (int i = 0; i < selects.length; ++i) {
                    this.getModel().createNewEntryRow(TO_SELECT_ENTRY_ENTITY);
                    this.getModel().setValue(TOBE_SELECT_OBJ, ((DynamicObject)sDoc.get(selects[i])).get(SELECTED_OBJ), size + i);
                    this.getModel().setValue(TOBE_SELECT_NUMBER, ((DynamicObject)sDoc.get(selects[i])).get(SELECTED_NUMBER), size + i);
                    this.getModel().setValue(IS_SELECT, (Object)Boolean.FALSE, size + i);
                }
                this.getModel().deleteEntryRows(SELECT_ENTRY_ENTITY, selects);
                break;
            }
            case "bar_confirm": {
                if (!this.checkData()) {
                    return;
                }
                DynamicObjectCollection doc = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY);
                ArrayList ruleNumbers = Lists.newArrayListWithExpectedSize((int)doc.size());
                for (int i = 0; i < doc.size(); ++i) {
                    String selectednumber = ((DynamicObject)doc.get(i)).getString(SELECTED_NUMBER);
                    ruleNumbers.add(selectednumber);
                }
                this.getView().returnDataToParent((Object)ruleNumbers);
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection selectEntryEntity = model.getEntryEntity(SELECT_ENTRY_ENTITY);
        int size = selectEntryEntity.size();
        if (size == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"MultiExportFileRulePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        HashSet<String> selectNumbers = new HashSet<String>(10);
        for (int i = 0; i < selectEntryEntity.size(); ++i) {
            selectNumbers.add(((DynamicObject)selectEntryEntity.get(i)).getString(SELECTED_NUMBER));
        }
        if (!selectNumbers.contains("enterpriseCode") || !selectNumbers.contains("reportTypeCode")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u4f01\u4e1a\u4ee3\u7801\u548c\u62a5\u8868\u7c7b\u578b\u7801\u5fc5\u9009\u3002", (String)"RpaIniFileRulePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static class FileNameStyle {
        private char fileStyle;
        private String number;
        private String name;

        public FileNameStyle(char fileStyle, String number, String name) {
            this.fileStyle = fileStyle;
            this.number = number;
            this.name = name;
        }

        public char getFileStyle() {
            return this.fileStyle;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }
    }
}

