/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class RpaschemetasklistPlugin
extends AbstractBaseListPlugin {
    private static final String BILLLISTTAP = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeid");
        QFilter qf = null;
        if (this.getView().getFormShowParameter().getCustomParam("model") != null) {
            long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
            this.getModel().setValue("model", (Object)modelId);
            qf = new QFilter("modeid", "=", (Object)modelId);
        }
        if (schemeId != null) {
            this.getModel().setValue("rpaschemeid", (Object)LongUtil.toLong((Object)schemeId));
        }
        BillList billList = (BillList)this.getControl(BILLLISTTAP);
        if (Objects.nonNull(qf)) {
            billList.setFilter(qf);
        }
        billList.refresh();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("rpaschemeid");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign())) {
            if (StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
                ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp(this.getView());
                QFilter haspermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_isrptschemelist", (ApplicationTypeEnum)applicationTypeEnum));
                QFilter hasReportPermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_report_list", (ApplicationTypeEnum)applicationTypeEnum));
                QFilter perRoleids = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)applicationTypeEnum, (String)"bcm_isrptschemelist", (String)"47150e89000000ac"));
                QFilter perReportRoleids = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)applicationTypeEnum, (String)"bcm_report_list", (String)"47150e89000000ac"));
                qFilterList.add(superid.or(haspermid).or(hasReportPermid).or(perRoleids).or(perReportRoleids));
                qFilterList.add(ModelUtil.getModelQfilterByApp(this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        } else {
            super.beforeF7Select(beforeF7SelectEvent);
        }
        if ("rpaschemeid".equalsIgnoreCase(key = beforeF7SelectEvent.getProperty().getName())) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refresh();
                break;
            }
            case "btn_showlog": {
                this.showLog();
                break;
            }
        }
    }

    private void showLog() {
        String taskId;
        BillList billList = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRowCollection dy = billList.getSelectedRows();
        if (dy == null || dy.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u6761\u6570\u636e\u518d\u64cd\u4f5c\u3002", (String)"RpaschemetasklistPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        Long id = (Long)dy.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_rpaschemetask");
        if (dynamicObject != null && StringUtils.isNotEmpty((String)(taskId = dynamicObject.getString("rpataskid")))) {
            try {
                String url = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getTaskLogUrl", (Object[])new Object[]{taskId});
                this.getView().openUrl(url);
                this.writeOperationLog(ResManager.loadKDString((String)"\u5931\u6548", (String)"ISRpaSchemeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.get(0).getNumber(), dy.get(0).getName(), ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error("RPA get log url error", (Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6682\u65e0\u65e5\u5fd7\u3002", (String)"ISRpaSchemeListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            }
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6682\u65e0\u65e5\u5fd7\u3002", (String)"ISRpaSchemeListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "model": {
                this.setValue("rpaschemeid", "");
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.setValue("model", e.getChangeSet()[0].getOldValue());
                    break;
                }
                this.refresh();
                this.saveUserSelect(e);
                break;
            }
            case "rpaschemeid": {
                this.refresh();
                break;
            }
        }
    }

    private void saveUserSelect(PropertyChangedArgs e) {
        UserSelectModel user = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM);
        DynamicObject dobj = (DynamicObject)e.getChangeSet()[0].getNewValue();
        String modelId = dobj.getString("id");
        if (user == null) {
            ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
            UserSelectModel userSelectModel = new UserSelectModel();
            userSelectModel.setModifier(RequestContext.get().getUserId());
            userSelectModel.setApplication(application);
            userSelectModel.setModel(modelId);
            userSelectModel.setOnlyModel(false);
            UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
        } else {
            user.setModel(modelId);
            UserSelectServiceHelper.saveUserSelect((UserSelectModel)user);
        }
    }

    private void refresh() {
        if (this.checkModelIsNull()) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        billList.refresh();
        billList.clearSelection();
    }

    private boolean checkModelIsNull() {
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"IntellScheduleListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qf;
        long modelId = this.getModelId();
        if (modelId == 0L) {
            qf = new QFilter("1", "=", (Object)0);
        } else {
            qf = new QFilter("modeid", "=", (Object)modelId);
            Object rpaschemeid = this.getModel().getValue("rpaschemeid");
            if (rpaschemeid != null) {
                long id = ((DynamicObject)rpaschemeid).getLong("id");
                qf.and(new QFilter("rpascheme.id", "=", (Object)LongUtil.toLong((Object)id)));
            }
        }
        e.getQFilters().add(qf);
    }
}

