/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme.handle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.olap.util.ByteArrayInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AttachmentHandle {
    private static final Log logger = LogFactory.getLog(AttachmentHandle.class);

    public static void copyFile2New(Long oldschemeid, long schemeId, String versionnumber) {
        DynamicObject isscheme = BusinessDataServiceHelper.loadSingle((Object)oldschemeid, (String)"bcm_isscheme");
        String srcNumber = isscheme.getString("issrc.number");
        if (!"JQ".equals(srcNumber) && !"EXCEL".equals(srcNumber)) {
            return;
        }
        DynamicObjectCollection oldFiles = AttachmentHandle.getTempUrl(oldschemeid);
        for (DynamicObject oldFile : oldFiles) {
            String[] split = oldFile.getString("fAttachmentName").split("\\.");
            String tempName = split[0] + "_" + versionnumber.split("\\.")[0] + "." + split[1];
            String fileType = oldFile.getString("fExtName");
            String id = oldFile.getString("id");
            String originalUid = oldFile.getString("fnumber");
            AttachmentDto attachmentInfo = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)id);
            String resourcePath = attachmentInfo.getResourcePath();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileServiceFactory.getAttachmentFileService().download(resourcePath, (OutputStream)out, null);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Map<String, Object> url = AttachmentHandle.newContractModelTempFile(tempName, fileType, (InputStream)in, originalUid);
            String tempurl = (String)url.get("url");
            String urlstr = AttachmentServiceHelper.saveTempToFileService((String)tempurl, (String)"bcm", (String)"bcm_isscheme", (Object)schemeId, (String)tempName, (boolean)false, (boolean)true);
            DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            dynObj.set("fBillType", (Object)"bcm_isscheme");
            dynObj.set("fnumber", url.get("uid"));
            dynObj.set("fInterID", (Object)schemeId);
            dynObj.set("fFileId", (Object)urlstr);
            dynObj.set("fAttachmentName", url.get("name"));
            dynObj.set("fExtName", url.get("type"));
            dynObj.set("fAttachmentSize", url.get("size"));
            dynObj.set("FBillStatus", (Object)"A");
            dynObj.set("fCreateMen_Id", url.get("creator"));
            dynObj.set("fCreateTime", url.get("createdate"));
            dynObj.set("fModifyMen_Id", url.get("creator"));
            dynObj.set("fModifyTime", url.get("lastModified"));
            dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
        }
    }

    private static Map<String, Object> newContractModelTempFile(String fileName, String fileType, InputStream in, String originalUid) {
        HashMap<String, Object> contractMap = new HashMap<String, Object>();
        contractMap.put("entityNum", "bcm_isscheme");
        long time = System.currentTimeMillis();
        contractMap.put("createdate", time);
        contractMap.put("lastModified", time);
        String userId = RequestContext.get().getUserId();
        contractMap.put("creator", userId);
        contractMap.put("name", fileName);
        try {
            contractMap.put("size", in.available());
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9644\u4ef6\u5927\u5c0f\u5931\u8d25\u3002", (String)"ISSchemeNewVersionPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        contractMap.put("status", "success");
        contractMap.put("type", fileType);
        StringBuilder uid = new StringBuilder();
        uid.append("rc-upload-");
        uid.append(time);
        uid.append("-");
        String numberIndex = null;
        int index = originalUid.lastIndexOf("-");
        if (index != -1) {
            numberIndex = originalUid.substring(index + 1);
        }
        uid.append(numberIndex);
        contractMap.put("uid", uid.toString());
        StringBuilder newUrl = new StringBuilder();
        newUrl.append(RequestContext.get().getClientFullContextPath());
        if (!newUrl.toString().endsWith("/")) {
            newUrl.append("/");
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = tempFileCache.saveAsUrl(fileName, in, 7200);
        newUrl.append(tempUrl);
        contractMap.put("url", newUrl.toString());
        return contractMap;
    }

    private static DynamicObjectCollection getTempUrl(Long schemeId) {
        return QueryServiceHelper.query((String)"bos_attachment", (String)"id,fAttachmentName,fExtName,fnumber", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)"bcm_isscheme"), new QFilter("fInterID", "=", (Object)String.valueOf(schemeId))});
    }
}

