/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme.handle;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.intergration.util.TurnSystem26Util;
import kd.fi.bcm.formplugin.intergration.vo.CellPointModel;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CellMappingHandle {
    private static String KEY_SPLIT = "#";
    private static String G_PRE = "g_";
    private static String F_PRE = "f_";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(CellMappingHandle.class);
    private transient int maxCellSize = 0;

    public static Integer[] getInFloatArea(int i, int j, List<Integer[]> floatAreaInt) {
        for (Integer[] area : floatAreaInt) {
            if (area[0] > i || area[1] > j || area[2] < i || area[3] < j) continue;
            return area;
        }
        return null;
    }

    public static String getRealArea(Integer[] area) {
        return TurnSystem26Util.ToNumberSystem26(area[1] + 1) + (area[0] + 1) + ":" + TurnSystem26Util.ToNumberSystem26(area[3] + 1) + (area[2] + 1);
    }

    public void initMaxSize() {
        this.maxCellSize = (Integer)ThreadCache.get((Object)"MatchCount.getMaxSize", () -> {
            try {
                String size = ConfigServiceHelper.getStringParamNoModel((String)"maxMatchCountLimit");
                return Integer.parseInt(size);
            }
            catch (Exception e) {
                return 10000000;
            }
        });
    }

    public static String batchSheetCellMapping(Long schemeId, List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] sheetMappings = BusinessDataServiceHelper.load((String)"bcm_issheetmapping", (String)"id,sheetname,template", (QFilter[])new QFilter[]{idFilter});
        HashMap<String, Long> sheetTemplateMap = new HashMap<String, Long>();
        HashMap<String, Long> sheetMappingMap = new HashMap<String, Long>();
        List<Long> templateIds = CellMappingHandle.getTemplateIdsAndMap(sheetMappings, sheetTemplateMap, sheetMappingMap);
        QFilter templateIdsFilter = new QFilter("id", "in", templateIds);
        DynamicObject[] templates = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"rptdata,id", (QFilter[])new QFilter[]{templateIdsFilter});
        Map<Long, String> templateIdDataMap = CellMappingHandle.getTemplateIdDataMap(templates);
        boolean isFromJq = CellMappingHandle.isFromJq(schemeId);
        List<String> urls = CellMappingHandle.getTempUrls(schemeId, false);
        StringBuilder sb = new StringBuilder();
        boolean hasXmlAttachment = CellMappingHandle.hasXmlAttachment(urls);
        for (String string : urls) {
            if (string.toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            int workbookType = CellMappingHandle.getWorkbookType(string);
            Workbook xwb = CellMappingHandle.getWorkbook(string, workbookType);
            int sheetCount = xwb.getNumberOfSheets();
            String innerSheetName = null;
            Long templateId = null;
            Long sheetMappingId = null;
            String rptData = null;
            SpreadManager spread = null;
            HashMap<String, Object> dataCacheMap = null;
            int isInFloatArea = 0;
            int isInFixedArea = 0;
            boolean hasMapping = false;
            for (int k = 0; k < sheetCount; ++k) {
                innerSheetName = workbookType == 1 ? ((HSSFWorkbook)xwb).getSheetName(k) : ((XSSFWorkbook)xwb).getSheetName(k);
                if (!sheetTemplateMap.containsKey(innerSheetName)) continue;
                templateId = (Long)sheetTemplateMap.get(innerSheetName);
                sheetMappingId = (Long)sheetMappingMap.get(innerSheetName);
                rptData = templateIdDataMap.get(templateId);
                spread = JsonSerializerUtil.toSpreadManager((String)rptData);
                kd.fi.bcm.spread.domain.view.Sheet bcmSheet = spread.getBook().getSheet(0);
                Object jqSheet = null;
                jqSheet = workbookType == 1 ? ((HSSFWorkbook)xwb).getSheet(innerSheetName) : ((XSSFWorkbook)xwb).getSheet(innerSheetName);
                int maxRowCount = bcmSheet.getMaxRowCount();
                int maxColumnCount = bcmSheet.getMaxColumnCount();
                dataCacheMap = new HashMap<String, Object>();
                String fixValue = null;
                Map<String, List<String>> areaMap = CellMappingHandle.getFloatArea(spread, false);
                List<String> floatArea = areaMap.get("float");
                List<String> fixedArea = areaMap.get("fixed");
                List<String> allArea = areaMap.get("all");
                List<Integer[]> floatAreaInt = CellMappingHandle.getFloatAreaInt(floatArea);
                List<Integer[]> fixedAreaInt = CellMappingHandle.getFloatAreaInt(fixedArea);
                List<Integer[]> allAreaInt = CellMappingHandle.getFloatAreaInt(allArea);
                Row row = null;
                int jqI = 0;
                for (int i = 0; i <= maxRowCount; ++i) {
                    for (int j = 0; j <= maxColumnCount; ++j) {
                        isInFloatArea = CellMappingHandle.isInFloatArea(i, j, floatAreaInt, allAreaInt);
                        isInFixedArea = CellMappingHandle.isInFloatArea(i, j, fixedAreaInt, allAreaInt);
                        if (isInFixedArea != 1 && isInFixedArea != 2 && isInFloatArea != 1 && isInFloatArea != 3) continue;
                        jqI = CellMappingHandle.getTrueJqJ(i, floatAreaInt);
                        row = jqSheet.getRow(jqI);
                        if (row == null) {
                            CellMappingHandle.caCheBcmData(i, j, jqI, j, "", dataCacheMap);
                            continue;
                        }
                        Cell jqCell = row.getCell(j);
                        if (jqCell == null || isFromJq && !hasXmlAttachment && !CellMappingHandle.checkNotStandardContent(jqCell)) continue;
                        fixValue = CellMappingHandle.getFixValue(jqCell, (Sheet)jqSheet, jqI);
                        CellMappingHandle.caCheBcmData(i, j, jqI, j, fixValue, dataCacheMap);
                    }
                }
                hasMapping = CellMappingHandle.saveMappingCell(dataCacheMap, sheetMappingId, schemeId, spread, floatArea, null, null);
                if (!hasMapping) {
                    sb.append(innerSheetName).append(";");
                }
                sheetTemplateMap.remove(innerSheetName);
            }
        }
        for (Map.Entry entry : sheetTemplateMap.entrySet()) {
            sb.append((String)entry.getKey()).append(";");
        }
        return sb.toString();
    }

    private static boolean checkNotStandardContent(Cell jqCell) {
        String jqCellValue = CellMappingHandle.getJqCellValue(jqCell);
        if (jqCellValue == null) {
            return false;
        }
        return jqCellValue.startsWith("[") && jqCellValue.endsWith("]");
    }

    private static boolean isFromJq(Long schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        String srcNumber = scheme.getString("issrc.number");
        return "JQ".equals(srcNumber) || "JQONLINE".equals(srcNumber);
    }

    public static boolean isFromExcel(Long schemeId) {
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number", (QFilter[])filter.toArray());
        String srcNumber = scheme.getString("issrc.number");
        return "EXCEL".equals(srcNumber);
    }

    private static boolean hasXmlAttachment(List<String> urls) {
        for (String url : urls) {
            if (!url.toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            return true;
        }
        return false;
    }

    public static int isInFloatArea(int i, int j, List<Integer[]> floatAreaInt, List<Integer[]> allAreaInt) {
        for (Integer[] area : floatAreaInt) {
            if (area[0] > i || area[1] > j || area[2] < i || area[3] < j) continue;
            if (area[0] == i) {
                return 1;
            }
            return 2;
        }
        for (Integer[] area : allAreaInt) {
            if (area[0] > i || area[1] > j || area[2] < i || area[3] < j) continue;
            return 3;
        }
        return 4;
    }

    public static Map<String, List<String>> getFloatArea(SpreadManager spread, boolean isImport) {
        HashMap<String, List<String>> areaMap = new HashMap<String, List<String>>();
        List<Object> areaRangeList = new LinkedList();
        List<Object> areaExtRangeList = new LinkedList();
        LinkedList<String> areaFixedList = new LinkedList<String>();
        LinkedList<String> areaAllList = new LinkedList<String>();
        areaMap.put("float", areaRangeList);
        areaMap.put("fixed", areaFixedList);
        areaMap.put("all", areaAllList);
        areaMap.put("extFloat", areaExtRangeList);
        Set postionInfoSet = spread.getAreaManager().getPostionInfoSet();
        if (postionInfoSet == null || postionInfoSet.size() == 0) {
            return areaMap;
        }
        Pattern p = Pattern.compile("[A-Z]+");
        String needCol = null;
        HashMap<Integer, String> floatMap = new HashMap<Integer, String>();
        HashMap<Integer, String> extFloatMap = new HashMap<Integer, String>();
        LinkedList<Integer> floatIndexList = new LinkedList<Integer>();
        LinkedList<Integer> extFloatIndexList = new LinkedList<Integer>();
        for (PositionInfo positionInfo : postionInfoSet) {
            String areaRangeOut = positionInfo.getAreaRange();
            if (areaRangeOut == null) continue;
            areaAllList.add(areaRangeOut);
            Matcher matcher = p.matcher(areaRangeOut.split(":")[1]);
            if (matcher.find()) {
                needCol = matcher.group();
            }
            if (positionInfo.getExtendInfo() != null) {
                if (isImport) {
                    CellMappingHandle.addFloatRange2Map(positionInfo.getAreaRange(), needCol, extFloatMap, extFloatIndexList);
                    continue;
                }
                CellMappingHandle.addFloatRange2Map(positionInfo.getAreaRange(), needCol, floatMap, floatIndexList);
                continue;
            }
            List basePoints = positionInfo.getBasePoints();
            if (basePoints == null || basePoints.size() == 0) {
                areaFixedList.add(areaRangeOut);
                continue;
            }
            for (BasePointInfo basePointInfo : basePoints) {
                String areaRangeInner = basePointInfo.getDynaRange();
                CellMappingHandle.addFloatRange2Map(areaRangeInner, needCol, floatMap, floatIndexList);
            }
        }
        if (floatIndexList.size() > 0) {
            areaRangeList = CellMappingHandle.sortAreaRangeList(floatIndexList, floatMap);
            areaMap.put("float", areaRangeList);
        }
        if (extFloatIndexList.size() > 0) {
            areaExtRangeList = CellMappingHandle.sortAreaRangeList(extFloatIndexList, extFloatMap);
            areaMap.put("extFloat", areaExtRangeList);
        }
        return areaMap;
    }

    private static void addFloatRange2Map(String areaRange, String needCol, Map<Integer, String> floatMap, List<Integer> floatIndexList) {
        Pattern p = Pattern.compile("[A-Z]+");
        if (!StringUtils.isEmpty((String)areaRange)) {
            String[] split = areaRange.split(":");
            String needPre = split[0];
            Matcher matcher = p.matcher(split[1]);
            if (!matcher.find()) {
                return;
            }
            String needRow = split[1].replace(matcher.group(), "");
            Integer needRowInt = Integer.valueOf(needRow);
            floatMap.put(needRowInt, needPre + ":" + needCol + needRow);
            floatIndexList.add(needRowInt);
        }
    }

    private static List<String> sortAreaRangeList(List<Integer> areaRangeList, Map<Integer, String> floatMap) {
        Collections.sort(areaRangeList);
        LinkedList<String> newList = new LinkedList<String>();
        for (int i = 0; i < areaRangeList.size(); ++i) {
            newList.add(floatMap.get(areaRangeList.get(i)));
        }
        return newList;
    }

    public static boolean saveMappingCell(Map<String, Object> dataCacheMap, Long id, Long schemeId, SpreadManager spread, List<String> floatArea, List<Triple<String, String, Pair<String, String>>> groupSetting, Map<String, String> areaMark) {
        boolean hasMapping = false;
        QFilter filter = new QFilter("sheetmappingid", "=", (Object)id);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bcm_iscellmappingdata", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObject saveData = null;
        HashMap<String, Object> mappingdata = new HashMap<String, Object>();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (data.length == 0) {
            saveData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_iscellmappingdata");
            saveData.set("scheme", (Object)schemeId);
            saveData.set("sheetmappingid", (Object)id);
            saveData.set("creater", (Object)userId);
        } else {
            saveData = BusinessDataServiceHelper.loadSingle((Object)data[0].get("id"), (String)"bcm_iscellmappingdata");
        }
        List<Map<String, Object>> orderData = CellMappingHandle.getOrderData(dataCacheMap, spread, floatArea);
        CellMappingHandle.saveExtDataHandle(schemeId, spread, orderData, floatArea, mappingdata);
        if (!ObjectUtils.isEmpty(groupSetting)) {
            mappingdata.put("groupSetting", groupSetting);
        }
        if (!ObjectUtils.isEmpty(areaMark)) {
            List<Map<String, String>> areaMarkList = CellMappingHandle.getAreaMarkList(areaMark);
            CellMappingHandle.saveAreaMarkHandle(schemeId, spread, areaMarkList, mappingdata);
            mappingdata.put("areaMark", areaMarkList);
        }
        mappingdata.put("data", orderData);
        mappingdata.put("floatArea", floatArea);
        saveData.set("mappingjson", (Object)JSONObject.toJSONString(mappingdata));
        saveData.set("modifydate", (Object)new Date());
        saveData.set("modifier", (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveData});
        DynamicObject sheetMapping = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_issheetmapping");
        if (orderData.size() == 0) {
            sheetMapping.set("mappingstatus", (Object)0);
        } else {
            hasMapping = true;
            sheetMapping.set("mappingstatus", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sheetMapping});
        return hasMapping;
    }

    private static void saveAreaMarkHandle(Long schemeId, SpreadManager spread, List<Map<String, String>> areaMarkList, Map<String, Object> mappingdata) {
        Map<String, List<String>> areaMap;
        List<String> extAreaRangeList;
        Boolean isFromExcel = CellMappingHandle.isFromExcel(schemeId);
        if (isFromExcel.booleanValue() && (extAreaRangeList = (areaMap = CellMappingHandle.getFloatArea(spread, true)).get("extFloat")).size() > 0) {
            List<Map<String, String>> extAreaMarkList = CellMappingHandle.extAreaHandle(extAreaRangeList, areaMarkList);
            mappingdata.put("extendMark", extAreaMarkList);
        }
    }

    private static void saveExtDataHandle(Long schemeId, SpreadManager spread, List<Map<String, Object>> orderData, List<String> floatArea, Map<String, Object> mappingdata) {
        Boolean isFromExcel = CellMappingHandle.isFromExcel(schemeId);
        if (isFromExcel.booleanValue()) {
            Map<String, List<String>> areaMap = CellMappingHandle.getFloatArea(spread, true);
            List<String> extAreaRangeList = areaMap.get("extFloat");
            if (CellMappingHandle.isFromExcel(schemeId) && extAreaRangeList.size() > 0) {
                CellMappingHandle.extDataHandle(orderData, extAreaRangeList);
                floatArea.removeAll(extAreaRangeList);
                mappingdata.put("extendArea", extAreaRangeList);
            }
        }
    }

    private static List<Map<String, String>> extAreaHandle(List<String> extAreaRangeList, List<Map<String, String>> areaMarkList) {
        ArrayList<Map<String, String>> extAreaMarkList = new ArrayList<Map<String, String>>();
        Iterator<Map<String, String>> iterator = areaMarkList.iterator();
        while (iterator.hasNext()) {
            Map<String, String> map = iterator.next();
            String area = map.get("area");
            if (!extAreaRangeList.contains(area)) continue;
            extAreaMarkList.add(map);
            iterator.remove();
        }
        return extAreaMarkList;
    }

    private static void extDataHandle(List<Map<String, Object>> orderData, List<String> extAreaRangeList) {
        String key;
        HashMap<String, String> f2t = new HashMap<String, String>(8);
        for (Map<String, Object> orderDatum : orderData) {
            List value;
            String point;
            int result;
            key = (String)orderDatum.keySet().stream().findFirst().get();
            if (!key.startsWith("f") || (result = CellMappingHandle.getCellInRange(extAreaRangeList, point = (String)((HashMap)(value = (List)orderDatum.get(key)).get(0)).keySet().stream().findFirst().get())) == -1) continue;
            f2t.put(key, "t_" + (result + 1));
        }
        if (f2t.size() > 0) {
            for (Map<String, Object> orderDatum : orderData) {
                key = (String)orderDatum.keySet().stream().findFirst().get();
                if (!f2t.containsKey(key)) continue;
                orderDatum.put((String)f2t.get(key), orderDatum.remove(key));
            }
            int index = 1;
            for (Map<String, Object> orderDatum : orderData) {
                String key2 = (String)orderDatum.keySet().stream().findFirst().get();
                if (!key2.startsWith("f")) continue;
                String indexStr = "f_" + index;
                if (!indexStr.equals(key2)) {
                    orderDatum.put("f_" + index, orderDatum.remove(key2));
                }
                ++index;
            }
        }
    }

    public static int getCellInRange(List<String> rangeList, String cellCoordinate) {
        String[] cellParts = cellCoordinate.split("#");
        int cellRow = Integer.parseInt(cellParts[0]);
        int cellColumn = Integer.parseInt(cellParts[1]);
        for (int i = 0; i < rangeList.size(); ++i) {
            String range = rangeList.get(i);
            RangeModel rm = new RangeModel(range);
            int startRow = rm.getY_start();
            int startColumn = rm.getX_start();
            int endRow = rm.getY_end();
            int endColumn = rm.getX_end();
            if (cellRow < startRow || cellRow > endRow || cellColumn < startColumn || cellColumn > endColumn) continue;
            return i;
        }
        return -1;
    }

    public static List<Map<String, String>> getAreaMarkList(List<Map<String, String>> res) {
        Collections.sort(res, (e1, e2) -> {
            String area1 = (String)e1.get("area");
            String area2 = (String)e2.get("area");
            ArrayList<String> areaList = new ArrayList<String>();
            areaList.add(area1);
            areaList.add(area2);
            List<Integer[]> areaInt = CellMappingHandle.getFloatAreaInt(areaList);
            return areaInt.get(0)[0] - areaInt.get(1)[0];
        });
        return res;
    }

    private static List<Map<String, String>> getAreaMarkList(Map<String, String> areaMark) {
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(16);
        HashMap<String, String> tempMap = null;
        for (Map.Entry<String, String> map : areaMark.entrySet()) {
            tempMap = new HashMap<String, String>(16);
            tempMap.put("area", map.getKey());
            tempMap.put("mark", map.getValue());
            res.add(tempMap);
        }
        return CellMappingHandle.getAreaMarkList(res);
    }

    private static void caCheBcmData(Integer bcmSelRowInt, Integer bcmSelColInt, Integer jqSelRowInt, Integer jqSelColInt, Object cellValue, Map<String, Object> dataCacheMap) {
        String key = bcmSelRowInt + KEY_SPLIT + bcmSelColInt;
        LinkedList<Object> value = new LinkedList<Object>();
        value.add(jqSelRowInt + KEY_SPLIT + jqSelColInt);
        value.add(cellValue);
        dataCacheMap.put(key, value);
    }

    private static List<Map<String, Object>> getOrderData(Map<String, Object> dataCacheMap, SpreadManager spreadModel, List<String> floatArea) {
        kd.fi.bcm.spread.domain.view.Sheet sheet = spreadModel.getBook().getSheet(0);
        int maxRowCount = sheet.getMaxRowCount();
        int maxColumnCount = sheet.getMaxColumnCount();
        LinkedList<Map<String, Object>> orderList = new LinkedList<Map<String, Object>>();
        HashMap<String, Object> tempValue = null;
        if (maxRowCount == 0 && maxColumnCount == 0) {
            boolean isFirst = true;
            String currentLocation = G_PRE + "1";
            for (Map.Entry<String, Object> map : dataCacheMap.entrySet()) {
                tempValue = new HashMap<String, Object>();
                tempValue.put(map.getKey(), (List)map.getValue());
                if (isFirst) {
                    CellMappingHandle.setOrderValue(orderList, currentLocation, tempValue);
                    isFirst = false;
                    continue;
                }
                CellMappingHandle.setOrderValueAsPre(orderList, currentLocation, tempValue);
            }
            return orderList;
        }
        String key = null;
        List value = null;
        List<Integer[]> floatAreaInt = CellMappingHandle.getFloatAreaInt(floatArea);
        int fixedCurrent = 0;
        int floatCurrent = 0;
        boolean typeCurren = false;
        for (int i = 0; i <= maxRowCount; ++i) {
            for (int j = 0; j <= maxColumnCount; ++j) {
                key = i + KEY_SPLIT + j;
                value = (List)dataCacheMap.get(key);
                if (value == null) continue;
                tempValue = new HashMap();
                tempValue.put(key, value);
                floatCurrent = CellMappingHandle.getFloatIndex(i, j, floatAreaInt);
                if (floatCurrent == 0) {
                    if (fixedCurrent == 0 && floatCurrent == 0) {
                        typeCurren = false;
                        CellMappingHandle.setOrderValue(orderList, G_PRE + ++fixedCurrent, tempValue);
                        continue;
                    }
                    if (!typeCurren) {
                        CellMappingHandle.setOrderValueAsPre(orderList, G_PRE + fixedCurrent, tempValue);
                        continue;
                    }
                    if (!typeCurren) continue;
                    typeCurren = false;
                    CellMappingHandle.setOrderValue(orderList, G_PRE + ++fixedCurrent, tempValue);
                    continue;
                }
                typeCurren = true;
                CellMappingHandle.setOrderValueFloat(orderList, F_PRE + floatCurrent, tempValue);
            }
        }
        return orderList;
    }

    private static void setOrderValueAsPre(List<Map<String, Object>> orderList, String indexKey, Map<String, Object> value) {
        Map<String, Object> indexMap = null;
        LinkedList mapList = null;
        for (int i = 0; i < orderList.size(); ++i) {
            indexMap = orderList.get(i);
            if (!indexMap.containsKey(indexKey)) continue;
            mapList = (LinkedList)indexMap.get(indexKey);
            mapList.add(value);
        }
    }

    private static void setOrderValue(List<Map<String, Object>> orderList, String indexKey, Map<String, Object> value) {
        HashMap indexMap = new HashMap();
        orderList.add(indexMap);
        LinkedList<Map<String, Object>> mapList = new LinkedList<Map<String, Object>>();
        indexMap.put(indexKey, mapList);
        mapList.add(value);
    }

    private static void setOrderValueFloat(List<Map<String, Object>> orderList, String indexKey, Map<String, Object> value) {
        Map<String, Object> indexMap = null;
        LinkedList<Map<String, Object>> mapList = null;
        boolean isSave = false;
        for (int i = 0; i < orderList.size(); ++i) {
            indexMap = orderList.get(i);
            if (!indexMap.containsKey(indexKey)) continue;
            mapList = (LinkedList<Map<String, Object>>)indexMap.get(indexKey);
            mapList.add(value);
            isSave = true;
        }
        if (!isSave) {
            indexMap = new HashMap<String, Object>();
            orderList.add(indexMap);
            mapList = new LinkedList<Map<String, Object>>();
            indexMap.put(indexKey, mapList);
            mapList.add(value);
        }
    }

    private static int getFloatIndex(int i, int j, List<Integer[]> floatAreaInt) {
        Integer[] areaArr = null;
        for (int k = 0; k < floatAreaInt.size(); ++k) {
            areaArr = floatAreaInt.get(k);
            if (areaArr == null || areaArr[0] > i || areaArr[2] < i || areaArr[1] > j || areaArr[3] < j) continue;
            return k + 1;
        }
        return 0;
    }

    public static List<Integer[]> getFloatAreaInt(List<String> floatArea) {
        Pattern p = Pattern.compile("[A-Z]+");
        Matcher matcher = null;
        String areaStr = null;
        String[] areaArr = null;
        String startCol = null;
        String endCol = null;
        String startRow = null;
        String endRow = null;
        LinkedList<Integer[]> floatAreaIntList = new LinkedList<Integer[]>();
        Integer[] areaIntArr = null;
        for (int i = 0; i < floatArea.size(); ++i) {
            areaStr = floatArea.get(i);
            areaArr = areaStr.split(":");
            matcher = p.matcher(areaArr[0]);
            if (matcher.find()) {
                startCol = matcher.group();
                startRow = areaArr[0].replace(startCol, "");
            }
            if ((matcher = p.matcher(areaArr[1])).find()) {
                endCol = matcher.group();
                endRow = areaArr[1].replace(endCol, "");
            }
            areaIntArr = new Integer[]{Integer.parseInt(startRow) - 1, TurnSystem26Util.FromNumberSystem26(startCol) - 1, Integer.parseInt(endRow) - 1, TurnSystem26Util.FromNumberSystem26(endCol) - 1};
            floatAreaIntList.add(areaIntArr);
        }
        return floatAreaIntList;
    }

    private static String getFixValue(Cell jqCell, Sheet jqSheet, Integer row) {
        CellType cellType = jqCell.getCellType();
        String jqCellValue = CellMappingHandle.getJqCellValue(jqCell);
        if (jqCellValue == null || jqCellValue.trim().equals("")) {
            return "";
        }
        if (jqCellValue.startsWith("[") && jqCellValue.endsWith("]")) {
            if (jqCellValue.contains(",")) {
                return jqCellValue;
            }
            jqCellValue = jqCellValue.split("\\[")[1].split("\\]")[0];
        }
        int maxColumnCount = Integer.parseInt("" + jqSheet.getRow(row.intValue()).getLastCellNum());
        Cell cell = null;
        String valueToString = null;
        String realRow = null;
        for (int i = 0; i < maxColumnCount; ++i) {
            cell = jqSheet.getRow(row.intValue()).getCell(i);
            if (cell == null) continue;
            cellType = cell.getCellType();
            if (CellType.NUMERIC.equals((Object)cellType)) {
                valueToString = String.valueOf(cell.getNumericCellValue());
            } else if (CellType.BOOLEAN.equals((Object)cellType)) {
                valueToString = String.valueOf(cell.getBooleanCellValue());
            } else if (CellType.STRING.equals((Object)cellType)) {
                valueToString = cell.getStringCellValue();
            }
            if (StringUtils.isEmpty((String)valueToString) || valueToString == null || !valueToString.startsWith("[") || !valueToString.endsWith("]") || !valueToString.contains(",")) continue;
            realRow = valueToString.split(",")[0].substring(1);
            return "[" + realRow + "," + jqCellValue + "]";
        }
        return "[-1," + jqCellValue + "]";
    }

    private static String getJqCellValue(Cell jqCell) {
        CellType cellType = jqCell.getCellType();
        String jqCellValue = null;
        if (CellType.NUMERIC.equals((Object)cellType)) {
            jqCellValue = String.valueOf(jqCell.getNumericCellValue());
        } else if (CellType.BOOLEAN.equals((Object)cellType)) {
            jqCellValue = String.valueOf(jqCell.getBooleanCellValue());
        } else if (CellType.STRING.equals((Object)cellType)) {
            jqCellValue = jqCell.getStringCellValue();
        }
        return jqCellValue;
    }

    public static int getWorkbookType(String url) {
        if (url.toLowerCase(Locale.ENGLISH).endsWith("xls")) {
            return 1;
        }
        if (url.toLowerCase(Locale.ENGLISH).endsWith("xlsx")) {
            return 2;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"SheetMappingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public static Workbook getWorkbook(String url, int type) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        InputStream ins = fileService.getInputStream(url);
        HSSFWorkbook xwb = null;
        try {
            if (type == 1) {
                xwb = new HSSFWorkbook(ins);
            } else if (type == 2) {
                xwb = new XSSFWorkbook(ins);
            }
        }
        catch (IOException e1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"SheetMappingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (xwb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"SheetMappingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return xwb;
    }

    public static List<String> getTempUrls(Long schemeId, boolean onlyExcel) {
        DynamicObjectCollection dynObj = QueryServiceHelper.query((String)"bos_attachment", (String)"fFileId", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)"bcm_isscheme"), new QFilter("fInterID", "=", (Object)String.valueOf(schemeId))});
        if (dynObj.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u65e0\u9644\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SheetMappingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), schemeId));
        }
        ArrayList<String> urls = new ArrayList<String>(dynObj.size());
        for (DynamicObject dyn : dynObj) {
            String fFileId = dyn.getString("fFileId");
            if (!fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xls") && !fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xlsx")) {
                fFileId = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(fFileId);
            }
            if (!fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xls") && !fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xlsx") && onlyExcel) continue;
            urls.add(fFileId);
        }
        return urls;
    }

    public static String getXmlAttachment(Long schemeId) {
        List<String> urls = CellMappingHandle.getTempUrls(schemeId, false);
        for (String url : urls) {
            if (!url.toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            return url;
        }
        return null;
    }

    private static Map<Long, String> getTemplateIdDataMap(DynamicObject[] templates) {
        String rptdata = null;
        Long id = null;
        HashMap<Long, String> templateIdDataMap = new HashMap<Long, String>(templates.length);
        for (DynamicObject dynamicObject : templates) {
            rptdata = dynamicObject.getString("rptdata");
            id = dynamicObject.getLong("id");
            templateIdDataMap.put(id, rptdata);
        }
        return templateIdDataMap;
    }

    private static List<Long> getTemplateIdsAndMap(DynamicObject[] sheetMappings, Map<String, Long> sheetTemplateMap, Map<String, Long> sheetMappingMap) {
        String sheetname = null;
        Long templateId = null;
        Long id = null;
        ArrayList<Long> templateIds = new ArrayList<Long>(sheetMappings.length);
        for (DynamicObject dynamicObject : sheetMappings) {
            sheetname = dynamicObject.getString("sheetname");
            templateId = dynamicObject.getLong("template.id");
            id = dynamicObject.getLong("id");
            sheetTemplateMap.put(sheetname, templateId);
            templateIds.add(templateId);
            sheetMappingMap.put(sheetname, id);
        }
        return templateIds;
    }

    public static int getTrueJqJ(int j, List<Integer[]> floatAreaInt) {
        Integer[] integers = null;
        int diff = 0;
        for (int i = 0; i < floatAreaInt.size() && j > (integers = floatAreaInt.get(i))[2]; ++i) {
            diff += integers[2] - integers[0];
        }
        return j - diff;
    }

    public void getCouple(Map<String, Map<String, Object>> leftCellMap, Pair<String, Map<String, Object>> leftMap, Map<String, Map<String, Object>> rightCellMap, Map<String, String> resMap, Set<String> hasMatchCell, int count) {
        if (this.maxCellSize == 0) {
            this.initMaxSize();
        }
        if (leftCellMap == null || leftCellMap.size() == 0 || count > this.maxCellSize) {
            return;
        }
        if (leftMap == null) {
            leftMap = CellMappingHandle.getLeftMap(leftCellMap);
        }
        if (leftMap == null) {
            return;
        }
        String leftKey = (String)leftMap.p1;
        Map leftValue = (Map)leftMap.p2;
        List leftCellPoint = (List)leftValue.get("CellPointModelList");
        Pair<String, Map<String, Object>> rightMap = CellMappingHandle.getRightMap(leftCellPoint, rightCellMap);
        if (rightMap == null) {
            leftCellMap.remove(leftKey);
            this.startNewMatch(leftCellMap, rightCellMap, resMap, hasMatchCell, count);
            return;
        }
        String rightKey = (String)rightMap.p1;
        if (hasMatchCell.contains(leftKey)) {
            resMap.put(leftKey, rightKey);
            leftCellMap.remove(leftKey);
            rightCellMap.remove(rightKey);
            this.startNewMatch(leftCellMap, rightCellMap, resMap, hasMatchCell, count);
            return;
        }
        Map rightValue = (Map)rightMap.p2;
        List rightCellPoint = (List)rightValue.get("CellPointModelList");
        Pair<String, Map<String, Object>> rightCoupleMap = CellMappingHandle.getRightMap(rightCellPoint, leftCellMap);
        if (rightCoupleMap == null) {
            leftCellMap.remove(leftKey);
            this.startNewMatch(leftCellMap, rightCellMap, resMap, hasMatchCell, count);
            log.error("data error");
            return;
        }
        String rightCoupleKey = (String)rightCoupleMap.p1;
        if (leftKey.equals(rightCoupleKey)) {
            resMap.put(leftKey, rightKey);
            leftCellMap.remove(leftKey);
            rightCellMap.remove(rightKey);
            this.startNewMatch(leftCellMap, rightCellMap, resMap, hasMatchCell, count);
        } else {
            this.startContinueMatch(leftCellMap, rightCoupleMap, rightCellMap, resMap, hasMatchCell, count, leftKey);
        }
    }

    private void startContinueMatch(Map<String, Map<String, Object>> leftCellMap, Pair<String, Map<String, Object>> leftMap, Map<String, Map<String, Object>> rightCellMap, Map<String, String> resMap, Set<String> hasMatchCell, int count, String leftKey) {
        hasMatchCell.add(leftKey);
        this.getCouple(leftCellMap, leftMap, rightCellMap, resMap, hasMatchCell, ++count);
    }

    private void startNewMatch(Map<String, Map<String, Object>> leftCellMap, Map<String, Map<String, Object>> rightCellMap, Map<String, String> resMap, Set<String> hasMatchCell, int count) {
        hasMatchCell.clear();
        this.getCouple(leftCellMap, null, rightCellMap, resMap, hasMatchCell, ++count);
    }

    private static Pair<String, Map<String, Object>> getRightMap(List<CellPointModel> leftCellPoint, Map<String, Map<String, Object>> rightCellMap) {
        for (CellPointModel leftCell : leftCellPoint) {
            String leftMyCouple = leftCell.getCoordinates();
            Map<String, Object> rightValue = rightCellMap.get(leftMyCouple);
            if (rightValue == null) continue;
            return Pair.onePair((Object)leftMyCouple, rightValue);
        }
        return null;
    }

    private static Pair<String, Map<String, Object>> getLeftMap(Map<String, Map<String, Object>> leftCell) {
        for (Map.Entry<String, Map<String, Object>> map : leftCell.entrySet()) {
            if (map == null) continue;
            return Pair.onePair((Object)map.getKey(), map.getValue());
        }
        return null;
    }
}

