/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DISchemeUtil {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DISchemeUtil.class);
    private static final List<String> fixedDimension = Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail");

    public static Set<String> getSchemeTextMetric(Long schemeId) {
        HashSet<String> textMetricList = new HashSet<String>(2);
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"singlemetric,textfield", (QFilter[])filter.toArray());
        String singlemetric = dyn.getString("singlemetric");
        String textfield = dyn.getString("textfield");
        if (StringUtils.isNotEmpty((String)singlemetric)) {
            textMetricList.add(singlemetric);
        }
        if (StringUtils.isNotEmpty((String)textfield)) {
            textMetricList.add(textfield);
        }
        return textMetricList;
    }

    public static void deleteDefMapping(Set<Long> dimMapId) {
        DynamicObject[] loads;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_isdimmap");
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((Object[])dimMapId.toArray(), (DynamicObjectType)dataEntityType)) {
            DISchemeUtil.removeEntry(load.getDynamicObjectCollection("isdimmaptargentry"));
            DISchemeUtil.removeEntry(load.getDynamicObjectCollection("isdimmapsrcentry"));
        }
        SaveServiceHelper.save((DynamicObject[])loads);
    }

    private static void removeEntry(DynamicObjectCollection dyns) {
        Iterator iterator = dyns.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static void deleteMemberMap(Set<Long> mapIds) {
        try {
            DeleteServiceHelper.delete((String)"bcm_isgroupmap", (QFilter[])new QFilter[]{new QFilter("dimmapid", "in", mapIds)});
        }
        catch (Exception e) {
            log.error("deleteMemberMap failed,information:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5bf9\u5e94\u7684\u6210\u5458\u6620\u5c04\u5220\u9664\u5931\u8d25\u3002", (String)"DIDimMapListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public static String getDimName(DynamicObjectCollection srcDynCollection, String columnName, String delimiter) {
        String srcname = "";
        int size = srcDynCollection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject src = (DynamicObject)srcDynCollection.get(i);
            DynamicObject dynamicObject = src.getDynamicObject(columnName);
            if (dynamicObject == null) continue;
            String name = dynamicObject.getString("name");
            srcname = i == 0 ? name : srcname + delimiter + name;
        }
        return srcname;
    }

    public static String getSrcNumber(List<DynamicObject> members) {
        int scope = members.get(0).getInt("scope");
        switch (MapScopeEnum.getEnumByindex((int)scope)) {
            case EQUALS: {
                return members.get(0).getString("srcmembnumber");
            }
            case RANGE: {
                return "between(" + members.get(0).getString("srcmembnumber") + "," + members.get(1).getString("srcmembnumber") + ")";
            }
            case LIKE: {
                return "like(" + members.get(0).getString("srcmembnumber") + ")";
            }
            case INCLUDE: {
                StringBuilder sb = new StringBuilder();
                sb.append("in(");
                members.forEach(m -> sb.append(m.getString("srcmembnumber")).append(","));
                return sb.substring(0, sb.length() - 1) + ")";
            }
            case NOT_EQUALS: {
                return "notequal(" + members.get(0).getString("srcmembnumber") + ")";
            }
            case NOT_RANGE: {
                return "notbetween(" + members.get(0).getString("srcmembnumber") + "," + members.get(1).getString("srcmembnumber") + ")";
            }
            case NOT_LIKE: {
                return "notlike(" + members.get(0).getString("srcmembnumber") + ")";
            }
            case NOT_INCLUDE: {
                StringBuilder temp = new StringBuilder();
                temp.append("notin(");
                members.forEach(m -> temp.append(m.getString("srcmembnumber")).append(","));
                return temp.substring(0, temp.length() - 1) + ")";
            }
        }
        return "";
    }

    public static DynamicObject getStructOfExtendById(Long id) {
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"name,number", (QFilter[])qfBuilder.toArray());
    }

    public static void enableScheme(Long schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        scheme.set("enable", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
    }

    public static Map<String, String> getDimNumber2Name(Long extendsModelId) {
        HashMap<String, String> dimMap = new HashMap<String, String>(8);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodeldim", (String)"id,dimension.number,dimension.name", (QFilter[])new QFilter("extmodelid", "=", (Object)extendsModelId).toArray(), (String)"sequence").values().forEach(f -> dimMap.put(f.getString("dimension.number"), f.getString("dimension.name")));
        return dimMap;
    }

    public static Map<String, Tuple<String, String, Long>> getFieldNumber2NameDTID(Long extendsModelId) {
        LinkedHashMap<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = new LinkedHashMap<String, Tuple<String, String, Long>>();
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"id,extfield.number,extfield.name,extfield.datatype, extfield.id", (QFilter[])new QFilter("extmodelid", "=", (Object)extendsModelId).toArray(), (String)"sequence").values().forEach(f -> fieldNumber2Name_DT_ID.put(f.getString("extfield.number"), Tuple.create((Object)f.getString("extfield.name"), (Object)f.getString("extfield.datatype"), (Object)f.getLong("extfield.id"))));
        ArrayList<Object> enumFields = new ArrayList<Object>(4);
        for (Tuple entry : fieldNumber2Name_DT_ID.values()) {
            if (!((String)entry.p2).equals(DataTypeEnum.ENUMTP.getOIndex())) continue;
            enumFields.add(entry.p3);
        }
        if (!enumFields.isEmpty()) {
            BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"number, enumitem", (QFilter[])new QFilter("id", "in", enumFields).toArray()).values().forEach(e -> {
                DynamicObject enumitem = e.getDynamicObject("enumitem");
                String field = e.getString("number");
                Tuple tuple = (Tuple)fieldNumber2Name_DT_ID.get(field);
                if (enumitem != null) {
                    fieldNumber2Name_DT_ID.put(field, Tuple.create((Object)tuple.p1, (Object)enumitem.getString("datatype"), (Object)tuple.p3));
                } else {
                    fieldNumber2Name_DT_ID.put(field, Tuple.create((Object)tuple.p1, (Object)DataTypeEnum.TXT.getOIndex(), (Object)tuple.p3));
                }
            });
        }
        return fieldNumber2Name_DT_ID;
    }

    public static long getExtendsModelId(String srcExtModel, Long modelId) {
        QFilter fModel = new QFilter("model", "=", (Object)modelId);
        QFilter fNumber = new QFilter("number", "=", (Object)srcExtModel);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{fModel, fNumber});
        return dynamicObject.getLong("id");
    }

    public static Map<String, String> getFixedDim(Long modelId) {
        QFilter fModel = new QFilter("model", "=", (Object)modelId);
        QFilter fNumber = new QFilter("number", "in", fixedDimension);
        return QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name", (QFilter[])new QFilter[]{fNumber, fModel}).stream().collect(Collectors.toMap(f -> f.getString("number"), f -> f.getString("name")));
    }

    public static DynamicObject getSchemeById(Long schemeId) {
        return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
    }
}

