/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EADataPushUtil {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(EADataPushUtil.class);
    private static final String COMMEN_ENTRY = "commembentry";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_SCOPE = "scope";
    private static final String FMONEY = "FMONEY";
    private static final List<String> sortDims = Arrays.asList("entity", "account", "scenario", "year", "period", "process", "changetype", "audittrail", "internalcompany", "currency", "multigaap", "mycompany", "datasort");

    public static Map<String, List<Map<String, String>>> buildDefaultF7Data(DynamicObject scheDy, long modelId) {
        LOG.info("param is " + scheDy);
        HashMap<String, List<Map<String, String>>> f7datas = new HashMap<String, List<Map<String, String>>>(16);
        DynamicObjectCollection entryDys = scheDy.getDynamicObjectCollection(COMMEN_ENTRY);
        for (DynamicObject entry : entryDys) {
            DynamicObject dimension = entry.getDynamicObject("comdimension");
            String dimNumber = dimension.getString(FIELD_NUMBER);
            String memberModel = dimension.getString("membermodel");
            long pid = entry.getLong("pid");
            Long mid = entry.getLong("commembid");
            int range = entry.getInt("range");
            DynamicObject memOrPro = EADataPushUtil.queryMemberById(memberModel, mid, pid, modelId);
            if (memOrPro == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u7684\u201c%s\u201d\u7ef4\u5ea6\u6709\u6210\u5458\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65b9\u6848\u3002", (String)"EADataPushBillPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNumber));
            }
            EADataPushUtil.buildF7SaveData(dimNumber.toLowerCase(Locale.ENGLISH), memOrPro, f7datas, String.valueOf(range), pid);
        }
        LOG.info("return data is " + String.join((CharSequence)",", f7datas.keySet()));
        return f7datas;
    }

    private static void buildF7SaveData(String key, DynamicObject member, Map<String, List<Map<String, String>>> f7datas, String range, long pid) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("id", member.getString("id"));
        map.put(FIELD_SCOPE, range);
        map.put(FIELD_NUMBER, member.getString(FIELD_NUMBER));
        map.put("name", member.getString("name"));
        map.put("pid", pid == 0L ? "" : String.valueOf(pid));
        map.put("dimKey", key);
        List<Map<String, String>> datas = f7datas.get(key);
        if (datas == null) {
            datas = new ArrayList<Map<String, String>>(10);
            datas.add(map);
            f7datas.put(key, datas);
        } else {
            datas.add(map);
        }
    }

    public static DynamicObject queryMemberById(String entityName, Object id, long pid, long modelId) {
        if (pid == 0L) {
            return EADataPushUtil.getMemberByCache(entityName, id, modelId);
        }
        QFilter filter = new QFilter("id", "=", id);
        return QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject getMemberByCache(String entityName, Object id, long modelId) {
        IDNumberTreeNode memberById = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)Long.parseLong(String.valueOf(id)));
        DynamicObject memDy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        memDy.set("id", (Object)memberById.getId());
        memDy.set(FIELD_NUMBER, (Object)memberById.getNumber());
        memDy.set("name", (Object)memberById.getName());
        return memDy;
    }

    public static List<DynamicObject> sortDims(DynamicObjectCollection dyObject) {
        List undifineDims = dyObject.stream().filter(x -> (Boolean)x.get("issysdimension") == false).collect(Collectors.toList());
        List presetDims = dyObject.stream().filter(x -> (Boolean)x.get("issysdimension")).collect(Collectors.toList());
        ArrayList<DynamicObject> sortedDims = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < sortDims.size(); ++i) {
            for (int j = 0; j < presetDims.size(); ++j) {
                String number = (String)((DynamicObject)presetDims.get(j)).get(FIELD_NUMBER);
                if (!number.toLowerCase(Locale.ENGLISH).equals(sortDims.get(i))) continue;
                sortedDims.add((DynamicObject)presetDims.get(j));
            }
        }
        List sortedUndifineDims = undifineDims.stream().sorted((dim1, dim2) -> dim1.get("shortnumber").toString().compareToIgnoreCase(dim2.get("shortnumber").toString())).collect(Collectors.toList());
        sortedDims.addAll(sortedUndifineDims);
        return sortedDims;
    }

    public static List<String> queryDataByDime(SQLBuilder sql, long modelId, String dime, String memberTree) {
        List<Object> numberList = new ArrayList(16);
        List pairs = sql.getFilters().stream().filter(pair -> dime.equalsIgnoreCase((String)pair.p1)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pairs)) {
            DynamicObject[] list;
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            for (DynamicObject entity : list = BusinessDataServiceHelper.load((String)memberTree, (String)FIELD_NUMBER, (QFilter[])new QFilter[]{filter})) {
                numberList.add(entity.getString(FIELD_NUMBER));
            }
        } else {
            numberList = Arrays.asList((Object[])((Pair)pairs.get((int)0)).p2);
        }
        return numberList.stream().distinct().collect(Collectors.toList());
    }

    public static Map<String, Set<String>> getDCCurrency(long modelId, List<Long> entityIdList, List<String> processNumNodeList) {
        HashMap<String, Set<String>> DCDataMap = new HashMap<String, Set<String>>();
        entityIdList.forEach(orgId -> {
            IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)orgId);
            HashSet<Object> DCSet = new HashSet<Object>(16);
            for (String bpNum : processNumNodeList) {
                Pair DCPair = TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)numberTreeNode, (long)modelId, (String)bpNum, (String)"DC");
                DCSet.add(DCPair.p2);
            }
            DCDataMap.put(numberTreeNode.getNumber(), DCSet);
        });
        return DCDataMap;
    }

    public static Map<String, String> addNodeCurrency(String cubecatalog, List<Long> entityIdList) {
        HashMap<String, String> nodeCurrMap = new HashMap<String, String>(16);
        for (Long orgId : entityIdList) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((String)cubecatalog, (Long)orgId);
            nodeCurrMap.put(node.getNumber(), node.getCurrency());
        }
        return nodeCurrMap;
    }

    public static void dropTable(String table) {
        boolean flag = DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)table);
        if (flag) {
            String dropSql = "drop table " + table;
            DB.execute((DBRoute)new DBRoute("bcm"), (String)dropSql);
            LOG.info("\u5168\u91cf\u6570\u636e\u6e05\u9664\u8868\u6210\u529f! DBRoute:bcm table:" + table);
        }
    }

    public static boolean createTable(List<String> tableFieIdList, String table) {
        String cont = "VARCHAR(50) DEFAULT '' NOT NULL";
        String fMoneyCont = "VARCHAR(2048) DEFAULT '' NOT NULL";
        StringBuilder sbDDL = new StringBuilder();
        sbDDL.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(table).append("')    CREATE TABLE ").append(table).append(" (");
        sbDDL.append("fid bigint default 0 not null,");
        int count = tableFieIdList.size();
        for (int i = 0; i < count; ++i) {
            String fileId = tableFieIdList.get(i);
            String fileIdCont = FMONEY.equalsIgnoreCase(fileId) ? fMoneyCont : cont;
            String commaCont = i == count - 1 ? "" : ",";
            sbDDL.append(fileId).append(" ").append(fileIdCont).append(commaCont);
        }
        sbDDL.append(");");
        boolean result = DB.execute((DBRoute)new DBRoute("bcm"), (String)sbDDL.toString());
        DB.execute((DBRoute)new DBRoute("bcm"), (String)("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'PK_" + table + "') ALTER  TABLE " + table + " ADD CONSTRAINT PK_" + table + " PRIMARY KEY( FID );"));
        return result;
    }

    public static List<String> addFToFieId(List<String> fieIdList) {
        ArrayList<String> list = new ArrayList<String>(10);
        fieIdList.forEach(fieId -> {
            String str = FMONEY.equals(fieId) ? fieId : "f" + fieId;
            list.add(str.toUpperCase(Locale.ENGLISH));
        });
        return list;
    }

    public static Map<String, String> dealWithDataByProcess(SQLBuilder sql, Long modelId) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        List<Object> processList = new ArrayList(16);
        List processPairs = sql.getFilters().stream().filter(pair -> "Process".equalsIgnoreCase((String)pair.p1)).collect(Collectors.toList());
        if (processPairs == null || processPairs.size() == 0) {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection entityList = QueryServiceHelper.query((String)"bcm_processmembertree", (String)FIELD_NUMBER, (QFilter[])new QFilter[]{filter});
            for (DynamicObject entity : entityList) {
                processList.add(entity.getString(FIELD_NUMBER));
            }
        } else {
            processList = Arrays.asList((Object[])((Pair)processPairs.get((int)0)).p2);
        }
        if ((processList = processList.stream().distinct().collect(Collectors.toList())).contains("EIRpt")) {
            dataMap.put("isContainsEIRpt", "1");
            Collections.replaceAll(processList, "EIRpt", "IRpt");
        }
        if (processList.contains("ERAdj")) {
            dataMap.put("isContainsERAdj", "1");
            Collections.replaceAll(processList, "ERAdj", "RAdj");
        }
        if (processPairs != null && processPairs.size() > 0) {
            processList = processList.stream().distinct().collect(Collectors.toList());
            sql.getFilters().removeIf(pair -> "Process".equalsIgnoreCase((String)pair.p1));
            sql.getFilters().add(new Pair((Object)"Process", (Object)processList.toArray(new String[0])));
        }
        LOG.info("queryDataByProcess\u8f93\u51fadataMap:" + ((Object)dataMap).toString());
        return dataMap;
    }

    public static void transformSqlByECOrDC(SQLBuilder sql, Map<String, List<String>> DCCurrencyMap, Map<String, String> nodeCurrMap, String entity) {
        List currencyPairs = sql.getFilters().stream().filter(pair -> "Currency".equalsIgnoreCase((String)pair.p1)).collect(Collectors.toList());
        List<Object> currencyData = currencyPairs.size() == 0 ? new ArrayList() : Arrays.asList((Object[])((Pair)currencyPairs.get((int)0)).p2);
        ArrayList<String> currencyList = new ArrayList<String>(currencyData);
        if (currencyList.size() == 0 || !currencyList.contains("EC") && !currencyList.contains("DC")) {
            return;
        }
        if (currencyList.contains("EC")) {
            currencyList.add(nodeCurrMap.get(entity));
            LOG.info("\u7ec4\u7ec7:" + entity + "\u89e3\u6790\u51faEC:" + nodeCurrMap.get(entity));
        }
        if (currencyList.contains("DC")) {
            List<String> setDCData = DCCurrencyMap.get(entity);
            currencyList.addAll(setDCData);
            LOG.info("\u7ec4\u7ec7:" + entity + "\u89e3\u6790\u51faDC:" + setDCData);
        }
        List<String> dupCyList = currencyList.stream().distinct().collect(Collectors.toList());
        sql.getFilters().removeIf(pair -> "Currency".equalsIgnoreCase((String)pair.p1));
        sql.getFilters().add(new Pair((Object)"Currency", (Object)dupCyList.toArray(new String[0])));
    }

    public static int getSelectFieldIndex(List<String> selectFieldList, String field) {
        int index = 0;
        for (int i = 0; i < selectFieldList.size(); ++i) {
            String value = selectFieldList.get(i);
            if (!field.equalsIgnoreCase(value)) continue;
            index = i;
        }
        return index;
    }

    public static void insertData(List<Object[]> obParams, List<String> selectFieldList, String table) {
        selectFieldList.add(0, "fid");
        String sbInsertFile = StringUtils.join((Object[])selectFieldList.toArray(), (String)",");
        StringBuilder sbInsertValueIndex = new StringBuilder();
        int size = selectFieldList.size();
        for (int i = 0; i < size; ++i) {
            String commaCont = i == size - 1 ? "" : ",";
            sbInsertValueIndex.append("?").append(commaCont);
        }
        String insertSql = "insert into " + table + "(" + sbInsertFile + ") values (" + sbInsertValueIndex + ")";
        DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, obParams);
    }

    public static int pollAndInsertData(List<Object[]> resultList, int totalCount, List<String> selectFieldList, String table) {
        if (resultList.size() > 0) {
            EADataPushUtil.insertData(resultList, selectFieldList, table);
            totalCount += resultList.size();
            resultList.clear();
        }
        return totalCount;
    }

    public static String buildLogOfDimension(Map<String, List<Map<String, String>>> f7data, String modelNum) {
        Map<String, String> dimNum2Names = MemberReader.getDimensionNumber2nameMap((String)modelNum).values().stream().map(x -> x.split(";")).collect(Collectors.toMap(k -> k[0].toLowerCase(Locale.ENGLISH), v -> v[1], (v1, v2) -> v1));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Map<String, String>>> next : f7data.entrySet()) {
            String dimName;
            String key = next.getKey();
            List<Map<String, String>> value = next.getValue();
            if (value.size() == 0 || StringUtils.isEmpty((String)(dimName = dimNum2Names.get(key.toLowerCase(Locale.ENGLISH))))) continue;
            sb.append(key).append(" ").append(dimName).append('\uff1a');
            for (int i = 0; i < value.size(); ++i) {
                Map<String, String> data = value.get(i);
                if (i == value.size() - 1) {
                    sb.append(data.get(FIELD_NUMBER)).append(" ").append(data.get("name"));
                    continue;
                }
                sb.append(data.get(FIELD_NUMBER)).append(" ").append(data.get("name")).append(",");
            }
            if (sb.length() >= 490) {
                return sb.append("...").toString();
            }
            sb.append(";").append(" ");
        }
        return sb.toString();
    }
}

