/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.provider.formula.ws.WebServiceClient;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.olap.verify.VerifyResult;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.template.model.BaseEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.SeqLogicImpl;
import kd.fi.bcm.formplugin.report.util.ReportDataUtil;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.util.DynamicUtils;

public class ISSchemeDataCollectHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(ISSchemeDataCollectHelper.class);
    private static final String SELECT_TEMPLATE = "selecttemplate";
    private static final boolean is_include_adjust_lastperiod = false;
    private static final String LOCK_DIM = "lockDim";

    public static Map<String, Object> collectRpt(IIntegrateContext ctx, AbstractFormPlugin plugin) {
        log.startWatch();
        ISSchemeDataCollectHelper.setLockDim(ctx);
        Map<String, Object> data = ISSchemeDataCollectHelper.doLoadData(ctx);
        WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"EAS\u63a5\u53e3\u8c03\u7528\u8017\u65f6-->", (String)"ISSchemeDataCollectHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        Map<String, Object> result = ISSchemeDataCollectHelper.doOutput(ctx, plugin.getPageCache(), data);
        WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"\u82cd\u7a79\u89e3\u6790\u8017\u65f6-->", (String)"ISSchemeDataCollectHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ISSchemeDataCollectHelper.doShowReport(ctx, plugin, result);
        WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"\u5f39\u51fa\u62a5\u544a-->", (String)"ISSchemeDataCollectHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        WatchLoggerUtil.debugEnd((WatchLogger)log, (String)ResManager.loadKDString((String)"\u603b\u8017\u65f6-->", (String)"ISSchemeDataCollectHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return result;
    }

    private static void setLockDim(IIntegrateContext ctx) {
        ctx.putCustomParam(LOCK_DIM, (Object)IntegrationUtil.getLockDim((Long)((Long)ctx.getModel().p1)));
    }

    public static Map<String, Object> collectRpt(IIntegrateContext ctx, IPageCache pageCache) {
        log.startWatch();
        Map<String, Object> data = ISSchemeDataCollectHelper.doLoadData(ctx);
        WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"EAS\u63a5\u53e3\u8c03\u7528\u8017\u65f6-->", (String)"ISSchemeDataCollectHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        Map<String, Object> result = ISSchemeDataCollectHelper.doOutput(ctx, pageCache, data);
        WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"\u82cd\u7a79\u89e3\u6790\u8017\u65f6-->", (String)"ISSchemeDataCollectHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        WatchLoggerUtil.debugEnd((WatchLogger)log, (String)ResManager.loadKDString((String)"\u603b\u8017\u65f6-->", (String)"ISSchemeDataCollectHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return result;
    }

    private static void doShowReport(IIntegrateContext ctx, AbstractFormPlugin plugin, Map<String, Object> result) {
        List reportList = (List)result.get("reportList");
        if (CollectionUtils.isEmpty((Collection)reportList)) {
            return;
        }
        ISSchemeDataCollectHelper.setCollectStatusFail((DynamicObject)ctx.getCustomParam("log"));
        IFormView mainPageView = plugin.getView().getMainView();
        String pageId = "easmapsetting" + mainPageView.getPageId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_easmapsetting");
        parameter.setCustomParam("easmsg", (Object)reportList);
        parameter.setCustomParam("year", ctx.getFy().p1);
        parameter.setCustomParam("period", ctx.getPeriod().p1);
        parameter.setCustomParam("modelid", (Object)((Long)ctx.getModel().p1).toString());
        parameter.setPageId(pageId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.EDIT);
        IFormView appPageView = plugin.getView().getParentView();
        appPageView.showForm(parameter);
        plugin.getView().sendFormAction(appPageView);
    }

    private static void setCollectStatusFail(DynamicObject existCol) {
        if (existCol != null) {
            existCol.set("modifier", (Object)RequestContext.get().getUserId());
            existCol.set("collectstatus", (Object)CollectStatusEnum.FAIL.getValue());
            existCol.set("modifydate", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            existCol.set("endtime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existCol});
        }
    }

    public static Map<String, Object> doLoadData(IIntegrateContext ctx) {
        Map result = null;
        try {
            HashMap<String, Object> filter = new HashMap<String, Object>();
            ArrayList<Object> orgs = new ArrayList<Object>();
            orgs.add(ctx.getOrg().p2);
            HashMap<String, String> mappedOrg = new HashMap<String, String>(16);
            ctx.putCustomParam("mappedOrg", mappedOrg);
            ArrayList<String> orgEASs = new ArrayList<String>(10);
            for (String string : orgs) {
                String orgEAS = ISSchemeDataCollectHelper.getEASDimNum(ctx, "bcm_entitymembertree", string);
                orgEASs.add(orgEAS);
                mappedOrg.put(orgEAS, string);
            }
            filter.put("ons", orgEASs);
            List<TemplateModel> models = ISSchemeDataCollectHelper.getDispTemplateModels(ctx);
            if (models.isEmpty()) {
                return null;
            }
            ctx.putCustomParam("models", models);
            filter.put("tns", models.stream().map(e -> e.getNumber()).collect(Collectors.toList()));
            filter.put("y", ISSchemeDataCollectHelper.getEASDimNum(ctx, "bcm_fymembertree", (String)ctx.getFy().p2));
            filter.put("p", ISSchemeDataCollectHelper.getEASDimNum(ctx, "bcm_periodmembertree", (String)ctx.getPeriod().p2));
            filter.put("cn", ISSchemeDataCollectHelper.getEASDimNum(ctx, "bcm_currencymembertree", (String)ctx.getCurrency().p2));
            filter.put("tvm", models.stream().map(model -> {
                if (model.getVersionNumber() != null) {
                    return new DecimalFormat("V.0").format(model.getVersionNumber());
                }
                return "V1.0";
            }).collect(Collectors.toList()));
            boolean bl = ISSchemeDataCollectHelper.isReplaceImportMode((Long)ctx.getSchema().p1);
            if (ctx.getCustomParam(SELECT_TEMPLATE) != null && bl) {
                ISSchemeDataCollectHelper.clearReportData(ctx, models);
            }
            WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - Filter:\n%s", JSON.toJSONString(filter)));
            result = ctx.getModel() != null && ctx.getModel().p2 != null && ((String)ctx.getModel().p2).contains("930UnitTest12") ? IntegrationUtil.getGLReportReturnData() : (Map)WebServiceClient.getInstance().getRptDataList((Long)ctx.getSchema().p1, filter);
            WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - Result:\n%s", JSON.toJSONString((Object)result)));
            if (ISSchemeDataCollectHelper.isDebug()) {
                String msg = (String)ctx.getCustomParam("msg");
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    ctx.putCustomParam("msg", (Object)String.format("%s\n------------\n%s", msg, JSON.toJSONString((Object)result)));
                } else {
                    ctx.putCustomParam("msg", (Object)JSON.toJSONString((Object)result));
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof KDBizException) {
                throw new KDBizException(e2.getMessage());
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e2, (int)30));
        }
        if (result != null && result.get("dt") != null) {
            return (Map)result.get("dt");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"EAS\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u9519\u8bef\uff1a%s\u3002", (String)"ISSchemeDataCollectHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), result));
    }

    private static void clearReportData(IIntegrateContext ctx, List<TemplateModel> models) {
        HashMap<Pair, Map> filterViews = new HashMap<Pair, Map>(models.size());
        boolean isLeaf = TreeStructureServiceHelper.isLeafMembNode((String)"bcm_entitymembertree", (String)((String)ctx.getOrg().p2), (Object)ctx.getModel().p1);
        for (TemplateModel model : models) {
            filterViews.put(Pair.onePair((Object)model.getId(), (Object)model.getName()), ISSchemeDataCollectHelper.getFilterView(ctx, model, (String)ctx.getOrg().p2, isLeaf));
        }
        Map<String, Pair<Long, String>> rptParams = ISSchemeDataCollectHelper.getRptParam(ctx);
        HashMap cleanedRpts = new HashMap(filterViews.size());
        List<String> atDefVals = ISSchemeDataCollectHelper.getATDefVals(ctx);
        filterViews.forEach((k, v) -> {
            try {
                VerifyResult vr = ReportDataUtil.cleanAllData((Long)k.p1, rptParams, v, OlapSourceEnum.I1);
                if (vr != null && !vr.isEmpty()) {
                    throw new KDBizException(vr.toString());
                }
                cleanedRpts.put(k.p2, v);
                if (atDefVals.size() > 1) {
                    for (int i = 1; i < atDefVals.size(); ++i) {
                        v.put(DimTypesEnum.AUDITTRIAL.getNumber(), atDefVals.get(i));
                        vr = ReportDataUtil.cleanAllData((Long)k.p1, rptParams, v, OlapSourceEnum.I1);
                        if (vr != null && !vr.isEmpty()) {
                            throw new KDBizException(vr.toString());
                        }
                        cleanedRpts.put(k.p2, v);
                    }
                }
            }
            catch (KDBizException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e05\u6570\u5931\u8d25\u7684\u62a5\u8868\u4e3a\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%2$s\uff0c\u4e0d\u518d\u6267\u884c\u53d6\u6570\u3002\u6e05\u6570\u6210\u529f\u7684\u62a5\u8868\u53ca\u5176\u6e05\u6570\u8303\u56f4\uff1a%3$s\u3002", (String)"ISSchemeDataCollectHelper_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), k.p2, e.getMessage(), JSON.toJSONString((Object)cleanedRpts)));
            }
        });
        List cleanedRptParams = rptParams.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)((Pair)e.getValue()).p2).collect(Collectors.toList());
        ctx.putCustomParam("cleanedRptParams", (Object)String.format(ResManager.loadKDString((String)"\u53d6\u6570\u524d\u5df2\u8fdb\u884c\u6e05\u6570\uff0c\u6e05\u6570\u62a5\u8868\u4f4d\u4e8e\uff1a%s\u3002", (String)"ISSchemeDataCollectHelper_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), JSON.toJSONString(cleanedRptParams)));
        ctx.putCustomParam("cleanedRptScopes", (Object)String.format(ResManager.loadKDString((String)"\u6267\u884c\u6e05\u6570\u7684\u62a5\u8868\u53ca\u5176\u6e05\u6570\u89c6\u70b9\u9875\u9762\u7ef4\u5206\u522b\u5982\u4e0b\uff1a%s\u3002", (String)"ISSchemeDataCollectHelper_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), JSON.toJSONString(cleanedRpts)));
    }

    private static Map<String, Pair<Long, String>> getRptParam(IIntegrateContext ctx) {
        HashMap<String, Pair<Long, String>> rptParams = new HashMap<String, Pair<Long, String>>(10);
        rptParams.put(DimTypesEnum.ENTITY.getNumber(), ctx.getOrg());
        rptParams.put(DimTypesEnum.SCENARIO.getNumber(), (Pair<Long, String>)ctx.getCustomParam("scene"));
        rptParams.put(DimTypesEnum.YEAR.getNumber(), ctx.getFy());
        rptParams.put(DimTypesEnum.PERIOD.getNumber(), ctx.getPeriod());
        rptParams.put(DimTypesEnum.CURRENCY.getNumber(), ctx.getCurrency());
        return rptParams;
    }

    private static boolean isReplaceImportMode(Long schemeId) {
        QFilter qfScheme = new QFilter("scheme", "=", (Object)schemeId);
        QFilter qFilterMode = new QFilter("importmode", "=", (Object)ISImpModeEnum.REPLACEIMPORT.getCode());
        return QueryServiceHelper.exists((String)"bcm_isimportmode", (QFilter[])new QFilter[]{qfScheme, qFilterMode});
    }

    private static List<TemplateModel> getDispTemplateModels(IIntegrateContext ctx) {
        HashSet ids;
        if (!CollectionUtils.isEmpty((Collection)ctx.getTemplateIds())) {
            ids = ctx.getTemplateIds();
        } else {
            ids = new HashSet(16);
            List templateIds = (List)ctx.getCustomParam(SELECT_TEMPLATE);
            RightVersionTemplateParams params = new RightVersionTemplateParams(((Long)ctx.getModel().p1).longValue(), ((Long)ctx.getOrg().p1).longValue(), ((Long)((Pair)ctx.getCustomParam((String)"scene")).p1).longValue(), ((Long)ctx.getFy().p1).longValue(), ((Long)ctx.getPeriod().p1).longValue(), ((Long)ctx.getCurrency().p1).longValue(), RequestContext.get().getCurrUserId(), (Set)(CollectionUtil.isEmpty((Collection)templateIds) ? null : Sets.newHashSet((Iterable)templateIds)), false);
            List rightVersionTemplateForOrg = (List)TemplateUtil.getRightVersionTemplateForOrgs((RightVersionTemplateParams)params).get(MemberReader.change2BaseMember((String)((String)ctx.getModel().p2), (Long)((Long)ctx.getOrg().p1)));
            ids.addAll(rightVersionTemplateForOrg);
        }
        boolean isNotUserMemLimit = ConfigServiceHelper.getGlobalBoolParam((String)"pushEasIsNotUserMemLimit");
        if (isNotUserMemLimit) {
            ArrayList<TemplateModel> models = new ArrayList<TemplateModel>();
            ids.forEach(e -> models.add(TemplateServiceHelper.getTemplateModelById((Object)e)));
            return models;
        }
        return TemplateRangeService.getTemplateModels(ids, (long)((Long)ctx.getModel().p1), (boolean)false, (boolean)false);
    }

    private static List<String> getATDefVals(IIntegrateContext ctx) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", ctx.getModel().p1);
        qf.add("number", "=", (Object)PresetConstant.AUDITTRIAL_DIM);
        Long atId = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])qf.toArray()).getLong("id");
        DimMappedRelation.DimAndDefValRela defValRela = (DimMappedRelation.DimAndDefValRela)ctx.getTargetDefaultValsMap().get(atId);
        if (defValRela != null && defValRela.getDefVals() != null) {
            return defValRela.getDefVals().stream().map(e -> e.getNumber()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static Map<String, Object> doOutput(final IIntegrateContext ctx, IPageCache pageCache, Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (data == null) {
            return result;
        }
        List models = (List)ctx.getCustomParam("models");
        List allDim = DimensionServiceHelper.getAllDim((Long)((Long)ctx.getModel().p1));
        int indexOfAt = allDim.indexOf(PresetConstant.AUDITTRIAL_DIM);
        int indexOfBp = allDim.indexOf(PresetConstant.PROCESS_DIM);
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{measure});
        OlapCommandUtil.addSourceMeasure((String)((String)ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
        info.setDimensions(allDim.toArray(new String[0]));
        CellSet cellSets = new CellSet(allDim.toArray(new String[0]), new String[]{measure});
        List<String> atDefVals = ISSchemeDataCollectHelper.getATDefVals(ctx);
        QFilter modelQFilter = new QFilter("model", "=", ctx.getModel().p1);
        boolean isNewModel = QueryServiceHelper.exists((String)"bcm_currencymembertree", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)CurrencyEnum.DC.getNumber())});
        Map mappedOrg = (Map)ctx.getCustomParam("mappedOrg");
        for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
            String easorg = dataEntry.getKey();
            String org = (String)mappedOrg.get(easorg);
            Map dataOrg = (Map)dataEntry.getValue();
            boolean isLeaf = TreeStructureServiceHelper.isLeafMembNode((String)"bcm_entitymembertree", (String)org, (Object)ctx.getModel().p1);
            block3: for (TemplateModel model : models) {
                Map dataTmp = (Map)dataOrg.get(model.getNumber());
                if (CollectionUtils.isEmpty((Map)dataTmp)) continue;
                if (model.getRptData() == null) {
                    DynamicObject rptdataObj = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"rptdata", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)model.getId())});
                    model.setRptData(rptdataObj.getString("rptdata"));
                }
                final SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)model.getRptData());
                Map<String, String> filterView = ISSchemeDataCollectHelper.getFilterView(ctx, model, org, isLeaf);
                Object dataAll = dataTmp.get("dl");
                if (ObjectUtils.isEmpty(dataAll)) continue;
                BigDecimal dataRate = new BigDecimal(dataTmp.get("rt").toString());
                if (!DynamicUtils.isDynamicReport((SpreadManager)spread)) {
                    if (!(dataAll instanceof Map)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79%1$s\u6a21\u677f\u4e3a\u56fa\u5b9a\u8868\uff0c\u8bf7\u68c0\u67e5EAS\u7684%2$s\u6a21\u677f\u662f\u5426\u4e3a\u56fa\u5b9a\u8868\u3002", (String)"ISSchemeDataCollectHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getNumber(), model.getNumber()));
                    }
                    Map dataAxis = (Map)dataAll;
                    if (CollectionUtils.isEmpty((Map)dataAxis)) continue;
                    spread.getBook().getSheet(0).iteratorCells(c -> {
                        if (c.isMdDataDomain() && c.getMemberFromUserObject() != null && !c.getMemberFromUserObject().isEmpty()) {
                            HashMap crossMap = new HashMap();
                            c.getMemberFromUserObject().stream().forEach(m -> {
                                String dim = m.getDimension().getNumber();
                                String member = m.getNumber();
                                if (PresetConstant.PERIOD_DIM.equals(dim)) {
                                    if ("CurrentPeriod".equals(member)) {
                                        member = (String)ctx.getPeriod().p2;
                                    } else if ("LastPeriod".equals(member)) {
                                        member = (String)ThreadCache.get((Object)("lastperiod_of_" + (String)ctx.getPeriod().p2), () -> PeriodUtils.getLastPeriodElseThrowException((String)((String)ctx.getModel().p2), (String)((String)ctx.getFy().p2), (boolean)false));
                                    }
                                } else if (PresetConstant.FY_DIM.equals(dim)) {
                                    if ("CurrentYear".equals(member)) {
                                        member = (String)ctx.getFy().p2;
                                    } else if ("LastYear".equals(member)) {
                                        member = (String)ThreadCache.get((Object)("lastyear_of_" + (String)ctx.getFy().p2), () -> PeriodUtils.getLastYearElseThrowException((String)((String)ctx.getModel().p2), (String)((String)ctx.getFy().p2)));
                                    }
                                }
                                crossMap.put(dim, member);
                            });
                            Map cell = (Map)dataAxis.get(c.getExcelAxis());
                            Object value = null;
                            if (cell == null) {
                                value = null;
                            } else {
                                String t = (String)cell.get("t");
                                String v = (String)cell.get("v");
                                value = t != null ? t : (v != null ? dataRate.multiply(new BigDecimal(v)) : null);
                            }
                            if (value == null) {
                                return;
                            }
                            ArrayList<Object> members = new ArrayList<Object>(10);
                            for (String dim : allDim) {
                                members.add(filterView.getOrDefault(dim, (String)crossMap.get(dim)));
                            }
                            String lockDim = (String)ctx.getCustomParam(LOCK_DIM);
                            Map warnRpt = IntegrationUtil.getWarnRptFromCtx((IIntegrateContext)ctx);
                            boolean islock = IntegrationUtil.checkLock((SaveCommandInfo)info, (List)allDim, (String[])members.toArray(new String[0]), (String)lockDim, (Map)warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getFy().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
                            if (!islock) {
                                cellSets.set(members.toArray(new String[0]), measure, value);
                            }
                            if (atDefVals.size() > 1) {
                                for (int i = 1; i < atDefVals.size(); ++i) {
                                    members.set(indexOfAt, atDefVals.get(i));
                                    islock = IntegrationUtil.checkLock((SaveCommandInfo)info, (List)allDim, (String[])members.toArray(new String[0]), (String)lockDim, (Map)warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getFy().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
                                    if (islock) continue;
                                    cellSets.set(members.toArray(new String[0]), measure, value);
                                }
                            }
                        }
                    });
                    continue;
                }
                Object[] dataBPList = null;
                if (dataAll instanceof List) {
                    dataBPList = ((List)dataAll).toArray();
                } else if (dataAll instanceof Object[]) {
                    dataBPList = (Object[])dataAll;
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79%1$s\u6a21\u677f\u4e3a\u6d6e\u52a8\u8868\uff0c\u8bf7\u68c0\u67e5EAS\u7684%2$s\u6a21\u677f\u662f\u5426\u4e3a\u6d6e\u52a8\u8868\u3002", (String)"ISSchemeDataCollectHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getNumber(), model.getNumber()));
                }
                final boolean isDirectHoriz = DynamicUtils.isDirectHoriz((SpreadManager)spread);
                int rowOfBP = 0;
                HashMap seqMap = new HashMap();
                for (PositionInfo p : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), isDirectHoriz)) {
                    if (p.isFloatPosition()) {
                        for (BasePointInfo basePoint : FloatLogicImpl.sortBasePoint(p.getBasePoints())) {
                            if (dataBPList.length <= rowOfBP) continue block3;
                            Object[] dataRowList = null;
                            dataRowList = dataBPList[rowOfBP] instanceof List ? ((List)dataBPList[rowOfBP++]).toArray() : (Object[])dataBPList[rowOfBP++];
                            String dynaRange = basePoint.getDynaRange();
                            String[] range = dynaRange.split(":");
                            int[] startXY = ExcelUtils.pos2Point((String)range[0]).toArray();
                            HashMap<Integer, String> dynColMap = new HashMap<Integer, String>();
                            HashMap<String, String> fixFloatMap = new HashMap<String, String>();
                            HashMap<String, List<DynaMembScopeInfo>> scopeMap = new HashMap<String, List<DynaMembScopeInfo>>();
                            boolean hasSeq = false;
                            String seqDim = null;
                            for (Object[] line : basePoint.getBasePointInnerLineInfo()) {
                                if (line.isSeq()) {
                                    hasSeq = true;
                                    seqDim = ((DynaMembScopeInfo)line.getDynaMembScopes().get(0)).getMember().getDimension().getNumber();
                                    continue;
                                }
                                if (line.isFloated()) {
                                    dynColMap.put(startXY[0] + line.getOffset(), line.getDimension().getNumber());
                                    scopeMap.put(line.getDimension().getNumber(), line.getDynaMembScopes());
                                    continue;
                                }
                                fixFloatMap.put(((DynaMembScopeInfo)line.getDynaMembScopes().get(0)).getMember().getDimension().getNumber(), ((DynaMembScopeInfo)line.getDynaMembScopes().get(0)).getMember().getNumber());
                            }
                            HashMap<String, Set<String>> allFloatMembers = new HashMap<String, Set<String>>(16);
                            for (Object object : dataRowList) {
                                Map dataRow = (Map)object;
                                dataRow.forEach((axis, vMap) -> {
                                    int col = ExcelUtils.pos2X((String)axis);
                                    String dim = (String)dynColMap.get(col);
                                    if (!StringUtils.isEmpty((CharSequence)dim)) {
                                        HashSet<String> members = (HashSet<String>)allFloatMembers.get(dim);
                                        if (members == null) {
                                            members = new HashSet<String>(16);
                                            allFloatMembers.put(dim, members);
                                        }
                                        for (String value : ((Map)vMap).values()) {
                                            members.add(value.trim());
                                        }
                                    }
                                });
                            }
                            boolean isCheckPass = true;
                            Pair<List<Map<String, String>>, Map<String, Map<String, String>>> mappedMember = ISSchemeDataCollectHelper.checkAndReplaceMembers(ctx, allFloatMembers, scopeMap, model, dynaRange);
                            if (!CollectionUtils.isEmpty((Collection)((Collection)mappedMember.p1))) {
                                if (isCheckPass) {
                                    // empty if block
                                }
                                isCheckPass = false;
                                List reportList = (List)result.get("reportList");
                                if (reportList == null) {
                                    result.put("reportList", mappedMember.p1);
                                } else {
                                    reportList.addAll((Collection)mappedMember.p1);
                                }
                            }
                            if (!isCheckPass) continue;
                            HashMap rowMap = new HashMap();
                            for (Object dr : dataRowList) {
                                Map dataRow = (Map)dr;
                                dataRow.forEach((axis, vMap) -> {
                                    int[] rc = ExcelUtils.pos2Point((String)axis).toArray();
                                    int row = rc[1];
                                    int col = rc[0];
                                    String dim = (String)dynColMap.get(col);
                                    if (!StringUtils.isEmpty((CharSequence)dim)) {
                                        ((Map)vMap).forEach((tv, v) -> {
                                            String trimedV = v.trim();
                                            HashMap<String, String> dimMap = (HashMap<String, String>)rowMap.get(row);
                                            if (dimMap == null) {
                                                dimMap = new HashMap<String, String>();
                                                rowMap.put(row, dimMap);
                                            }
                                            if (((Map)mappedMember.p2).get(dim) != null) {
                                                dimMap.put(dim, ((Map)((Map)mappedMember.p2).get(dim)).getOrDefault(trimedV, trimedV));
                                            } else {
                                                dimMap.put(dim, trimedV);
                                            }
                                        });
                                    }
                                });
                            }
                            if (hasSeq && rowMap.size() > 0) {
                                List list = (List)ThreadCache.get((Object)"seqNumbers", (CacheLoader)new CacheLoader<List<String>>(){

                                    public List<String> load() {
                                        return new SeqLogicImpl(spread, (Long)ctx.getModel().p1, isDirectHoriz).getSeqnumbers();
                                    }
                                });
                                HashMap<String, Integer> counterMap = new HashMap<String, Integer>(rowMap.size());
                                for (Map.Entry entry : rowMap.entrySet()) {
                                    StringBuilder key = new StringBuilder();
                                    for (String dim : dynColMap.values()) {
                                        key.append((String)((Map)entry.getValue()).get(dim)).append('_');
                                    }
                                    Integer count = (Integer)counterMap.get(key.toString());
                                    if (count == null) {
                                        count = 1;
                                    } else {
                                        Integer n = count;
                                        Integer n2 = count = Integer.valueOf(count + 1);
                                    }
                                    counterMap.put(key.toString(), count);
                                    seqMap.put(entry.getKey(), list.get(count - 1));
                                }
                            }
                            HashMap hashMap = new HashMap(16);
                            basePoint.getFixMemberPosition().forEach((col, dims) -> {
                                Integer key = startXY[0] + dynColMap.size() + col;
                                HashMap<String, String> dimMap = (HashMap<String, String>)colMap.get(key);
                                if (dimMap == null) {
                                    dimMap = new HashMap<String, String>(16);
                                    colMap.put(key, dimMap);
                                }
                                for (IDimMember dim : dims) {
                                    dimMap.put(dim.getDimension().getNumber(), dim.getNumber());
                                }
                            });
                            for (Object dr : dataRowList) {
                                Map dataRow = (Map)dr;
                                for (Map.Entry dataRowEntry : dataRow.entrySet()) {
                                    String a = (String)dataRowEntry.getKey();
                                    int[] rc = ExcelUtils.pos2Point((String)a).toArray();
                                    int row = rc[1];
                                    int col2 = rc[0];
                                    if (dynColMap.containsKey(col2)) continue;
                                    Map axis2 = (Map)dataRowEntry.getValue();
                                    for (Map.Entry axisEntry : axis2.entrySet()) {
                                        String tv = (String)axisEntry.getKey();
                                        String v = (String)axisEntry.getValue();
                                        HashMap dimMap = new HashMap();
                                        if (rowMap.get(row) == null) {
                                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u62a5\u8868\u8fd4\u56de\u884c\u4e2d\u7684\u5355\u5143\u683c\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5EAS\u6620\u5c04\u5173\u7cfb\u3002dataRow\uff1a%2$s\u3002", (String)"ISSchemeDataCollectHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getNumber(), JSON.toJSONString((Object)dataRow)));
                                        }
                                        if (hashMap.get(col2) == null) {
                                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7b2c%2$s\u5217\u65e0\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002dataRow\uff1a%3$s\u3002", (String)"ISSchemeDataCollectHelper_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getNumber(), col2, JSON.toJSONString((Object)dataRow)));
                                        }
                                        ((Map)rowMap.get(row)).forEach((d, ms) -> dimMap.put((String)d, ms));
                                        ((Map)hashMap.get(col2)).forEach((d, ms) -> dimMap.put((String)d, ms));
                                        fixFloatMap.forEach((d, ms) -> dimMap.put((String)d, ms));
                                        filterView.forEach((d, ms) -> dimMap.put((String)d, ms));
                                        if (hasSeq) {
                                            dimMap.put(seqDim, seqMap.get(row));
                                        }
                                        ArrayList<String> members = new ArrayList<String>(10);
                                        for (String dim : allDim) {
                                            String m = (String)dimMap.get(dim);
                                            if (StringUtils.isEmpty((CharSequence)m)) {
                                                if (PresetConstant.MYCOMPANY_DIM.equals(dim)) {
                                                    m = (String)ctx.getOrg().p2;
                                                } else {
                                                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79%1$s\u6a21\u677f%2$s\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5EAS\u8fd4\u56de\u6570\u636e\u3002\ndataRow:\n%3$s", (String)"ISSchemeDataCollectHelper_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getNumber(), dim, JSON.toJSONString((Object)dr)));
                                                }
                                            }
                                            members.add(m);
                                        }
                                        DataTypeEnum dt = CellDataTypeUtil.getCellDataType((Long)((Long)ctx.getModel().p1), (IPageCache)pageCache, dimMap, null);
                                        Object value = null;
                                        value = "v".equals(tv) ? dataRate.multiply(new BigDecimal(v)) : ("t".equals(tv) ? (DataTypeEnum.DEFAULT == dt || DataTypeEnum.UNCURRENCY == dt ? (StringUtils.isEmpty((CharSequence)v) ? null : (ISSchemeDataCollectHelper.isNumeric(v) ? v : null)) : v) : null);
                                        String lockDim = (String)ctx.getCustomParam(LOCK_DIM);
                                        Map warnRpt = IntegrationUtil.getWarnRptFromCtx((IIntegrateContext)ctx);
                                        boolean islock = IntegrationUtil.checkLock((SaveCommandInfo)info, (List)allDim, (String[])members.toArray(new String[0]), (String)lockDim, (Map)warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getFy().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
                                        if (!islock) {
                                            cellSets.set(members.toArray(new String[0]), measure, value);
                                        }
                                        if (atDefVals.size() <= 1) continue;
                                        for (int i = 1; i < atDefVals.size(); ++i) {
                                            members.set(indexOfAt, atDefVals.get(i));
                                            islock = IntegrationUtil.checkLock((SaveCommandInfo)info, (List)allDim, (String[])members.toArray(new String[0]), (String)lockDim, (Map)warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getFy().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
                                            if (islock) continue;
                                            cellSets.set(members.toArray(new String[0]), measure, value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    seqMap.clear();
                }
            }
        }
        int insertOlapCount = 0;
        try {
            insertOlapCount = cellSets.getCount();
            OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)((String)ctx.getModel().p2));
            WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - cellSets:\n%s", cellSets));
            ctx.putCustomParam("InsertOlapCount", (Object)insertOlapCount);
        }
        catch (Throwable t) {
            log.error(String.format("\u4fdd\u5b58OLAP\u662f\u51fa\u9519\uff01 --- CellSets\uff1a\n%s", cellSets.toString()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58OLAP\u65f6\u51fa\u9519\u3002\u5177\u4f53\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ISSchemeDataCollectHelper_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.toString((Throwable)t)));
        }
        if (!ObjectUtils.isEmpty(result.get("reportList"))) {
            ISSchemeDataCollectHelper.distinctICAndMC(result);
            ctx.putCustomParam("reportList", result.get("reportList"));
            WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - reportList:\n%s", result.get("reportList")));
        }
        return result;
    }

    private static void distinctICAndMC(Map<String, Object> result) {
        List reportlist = (List)result.get("reportList");
        HashMap tempICAndMCMap = new HashMap(16);
        Iterator iterator = reportlist.iterator();
        while (iterator.hasNext()) {
            Map temp = (Map)iterator.next();
            if (!((String)temp.get("dimnumer")).equals(DimTypesEnum.INTERCOMPANY.getNumber()) && !((String)temp.get("dimnumer")).equals(DimTypesEnum.MYCOMPANY.getNumber())) continue;
            if (tempICAndMCMap.get(temp.get("easname")) != null && ((String)tempICAndMCMap.get(temp.get("easname"))).equals(temp.get("dimnumer"))) {
                iterator.remove();
                continue;
            }
            tempICAndMCMap.put(temp.get("easname"), temp.get("dimnumer"));
        }
    }

    private static boolean isNumeric(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i)) || cs.charAt(i) == '.' || cs.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static Pair<List<Map<String, String>>, Map<String, Map<String, String>>> checkAndReplaceMembers(IIntegrateContext ctx, Map<String, Set<String>> allFloatMembers, Map<String, List<DynaMembScopeInfo>> scopeMap, TemplateModel model, String dynaRange) {
        ArrayList unMappedMember = new ArrayList();
        HashMap mappedMember = new HashMap(16);
        QFBuilder qfBuilder = new QFBuilder();
        HashSet numbers = new HashSet();
        for (Map.Entry<String, Set<String>> entry : allFloatMembers.entrySet()) {
            Object d2;
            String dim = entry.getKey();
            List<DynaMembScopeInfo> scopeList = scopeMap.get(dim);
            numbers.clear();
            for (DynaMembScopeInfo scinfo : scopeList) {
                if (scinfo.isCustom()) {
                    numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)scinfo.getMember().getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                    continue;
                }
                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)((DimMember)scinfo.getMember()).getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            Set<String> members = entry.getValue();
            qfBuilder.add("model", "=", ctx.getModel().p1);
            qfBuilder.add("dimensionnumber", "=", (Object)dim);
            qfBuilder.add("easname", "in", members);
            if (!dim.equals(PresetConstant.INTERNALCOMPANY_DIM) && !dim.equals(PresetConstant.MYCOMPANY_DIM)) {
                qfBuilder.add("tmpnumber", "=", (Object)model.getNumber());
            }
            DynamicObjectCollection col1 = QueryServiceHelper.query((String)"bcm_easmembermap", (String)"easname,membernumber", (QFilter[])qfBuilder.toArray());
            qfBuilder.clear();
            HashMap<String, String> mappedMemb = new HashMap<String, String>(16);
            mappedMember.put(dim, mappedMemb);
            for (Object d2 : col1) {
                if (!numbers.contains(d2.getString("membernumber"))) continue;
                mappedMemb.put(d2.getString("easname"), d2.getString("membernumber"));
            }
            HashSet<String> otherMembers = new HashSet<String>(10);
            d2 = members.iterator();
            while (d2.hasNext()) {
                String member = (String)d2.next();
                if (mappedMemb.containsKey(member)) continue;
                otherMembers.add(member);
            }
            if (otherMembers.size() > 0) {
                String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dim);
                qfBuilder.add("model", "=", ctx.getModel().p1);
                qfBuilder.add("dimension.number", "=", (Object)dim);
                qfBuilder.add("name", "in", otherMembers);
                DynamicObjectCollection col2 = QueryServiceHelper.query((String)entity, (String)"name, number", (QFilter[])qfBuilder.toArray());
                qfBuilder.clear();
                HashSet<String> repeatMembers = new HashSet<String>(10);
                for (DynamicObject d3 : col2) {
                    if (!numbers.contains(d3.getString("number"))) continue;
                    String easname = d3.getString("name");
                    if (mappedMemb.containsKey(easname) || repeatMembers.contains(easname)) {
                        repeatMembers.add(easname);
                        mappedMemb.remove(easname);
                        continue;
                    }
                    mappedMemb.put(easname, d3.getString("number"));
                }
            }
            for (String member : members) {
                if (mappedMemb.containsKey(member)) continue;
                HashMap<String, Object> names = new HashMap<String, Object>();
                names.put("easname", member);
                names.put("dimnumer", dim);
                names.put("tempnumber", model.getNumber());
                names.put("floatarea", dynaRange);
                names.put("org", ctx.getOrg().p2);
                unMappedMember.add(names);
            }
        }
        return Pair.onePair(unMappedMember, mappedMember);
    }

    public static String getEASDimNum(IIntegrateContext ctx, String entityNum, String member) {
        Pair pair = IntegrationUtil.getCommonSingleMappedMembInfo((IIntegrateContext)ctx, (String)entityNum, (String)member);
        if (pair == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5355\u4e00\u7ef4\u5ea6\u6620\u5c04\uff1a%s\u3002", (String)"ISSchemeDataCollectHelper_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), member));
        }
        return (String)pair.p2;
    }

    public static Map<String, String> getFilterView(IIntegrateContext ctx, TemplateModel template, String org, boolean isLeaf) {
        HashMap<String, String> filterView = new HashMap<String, String>(16);
        for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
            filterView.put(v.getDimension().getNumber(), ISSchemeDataCollectHelper.getTargetMember(ctx, (BaseEntry)v, v.getMember().getNumber()));
        }
        PageDimDomain pageDim = (PageDimDomain)ctx.getCustomParam("pageDomain");
        for (PageDimensionEntry v : template.getPageDimensionEntries()) {
            filterView.put(v.getDimension().getNumber(), ISSchemeDataCollectHelper.getPageDimMember(ctx, (BaseEntry)v, isLeaf, pageDim, template.getNumber()));
        }
        for (PageDimensionEntry v : template.getPagePropEntries()) {
            filterView.put(v.getDimension().getNumber(), ISSchemeDataCollectHelper.getPageDimMember(ctx, (BaseEntry)v, isLeaf, pageDim, template.getNumber()));
        }
        return filterView;
    }

    private static String getPageDimMember(IIntegrateContext ctx, BaseEntry dimensionEntry, boolean isLeaf, PageDimDomain pageDim, String tmplNum) {
        String dim = dimensionEntry.getDimension().getNumber();
        String member = PresetConstant.SCENE_DIM.equals(dim) ? (String)((Pair)ctx.getCustomParam((String)"scene")).p2 : (PresetConstant.FY_DIM.equals(dim) ? (String)ctx.getFy().p2 : (PresetConstant.PERIOD_DIM.equals(dim) ? (String)ctx.getPeriod().p2 : (PresetConstant.CURRENCY_DIM.equals(dim) ? (String)ctx.getCurrency().p2 : (PresetConstant.ENTITY_DIM.equals(dim) ? (String)ctx.getOrg().p2 : (PresetConstant.PROCESS_DIM.equals(dim) ? (isLeaf ? "IRpt" : "CSTE") : (PresetConstant.AUDITTRIAL_DIM.equals(dim) ? "EntityInput" : (pageDim == null ? null : pageDim.getAllMembers().stream().filter(e -> e.getDimension().getNumber().equals(dim)).findAny().get().getNumber())))))));
        if ((member = ISSchemeDataCollectHelper.getTargetMember(ctx, dimensionEntry, member)) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79%1$s\u6a21\u677f\u7684\u9875\u9762\u7ef4\u5305\u542b%2$s\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u6620\u5c04\u672a\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u76ee\u6807\u7f3a\u7701\u503c\u3002", (String)"ISSchemeDataCollectHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tmplNum, dim, dim));
        }
        return member;
    }

    private static String getTargetMember(IIntegrateContext ctx, BaseEntry v, String memberInRpt) {
        DimMappedRelation.DimAndDefValRela dimDefVals = (DimMappedRelation.DimAndDefValRela)ctx.getTargetDefaultValsMap().get(v.getDimension().getId());
        if (dimDefVals != null && dimDefVals.getDefVals() != null && dimDefVals.getDefVals().size() > 0) {
            String defMember = ((MappedDefaultVal)dimDefVals.getDefVals().get(0)).getNumber();
            if (!v.getDimension().getNumber().equals(defMember)) {
                return defMember;
            }
        }
        return memberInRpt;
    }

    private static boolean isDebug() {
        return DebugServiceHelper.isDebugModel();
    }
}

