/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class LinkExtDataUtil {
    public static final String DIM_SPLIT = ",";
    public static final String MEM_SPLIT = ".";
    public static final String MEM_SPLIT_REG = "\\.";
    public static final List<String> processByAdj = Lists.newArrayList((Object[])new String[]{"ADJ", "CADJ", "CCADJ", "EJE"});

    public static String getTotalDimStr(Map<String, String> targetDimMap, Long modelId) {
        StringBuilder sb = new StringBuilder();
        Set dims = MemberReader.getDimNumberMapNameById((long)modelId).keySet();
        int i = 0;
        String bpNum = targetDimMap.get(DimTypesEnum.PROCESS.getNumber());
        String currencyNum = targetDimMap.get(DimTypesEnum.CURRENCY.getNumber());
        if ("EIRpt".equalsIgnoreCase(bpNum) || "ERAdj".equalsIgnoreCase(bpNum)) {
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)currencyNum);
            if (currencyNum.equalsIgnoreCase((String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)entityNode, (long)modelId.longValue(), (String)bpNum, (String)currencyNum).p2)) {
                targetDimMap.put(DimTypesEnum.PROCESS.getNumber(), bpNum.substring(1));
            }
        }
        for (String dim : dims) {
            String memberNum = targetDimMap.get(dim);
            sb.append(dim).append(MEM_SPLIT).append(memberNum);
            if (i != dims.size() - 1) {
                sb.append(DIM_SPLIT);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean existExtData(String dimStr, Long modelID) {
        return LinkExtDataUtil.existExtData(dimStr, modelID, false);
    }

    public static boolean existExtData(String dimStr, Long modelID, boolean ignoreSource) {
        String modelNum = MemberReader.findModelNumberById((Object)modelID);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelID));
        qfBuilder.add(new QFilter("dimstr", "=", (Object)dimStr));
        boolean exist = QueryServiceHelper.exists((String)"bcm_extendsynlog", (QFilter[])qfBuilder.toArray());
        if (exist && !ignoreSource && OlapCommandUtil.checkMeasure((String)modelNum, (String)FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
            String[] splits;
            SQLBuilder sql = new SQLBuilder(modelNum);
            sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_SOURCE.getField()});
            sql.addSelectField(MemberReader.getDimNumberMapNameById((long)modelID).keySet().toArray(new String[0]));
            for (String split : splits = dimStr.split(DIM_SPLIT)) {
                String[] dimAndMem = split.split(MEM_SPLIT_REG);
                if (dimAndMem.length != 2) continue;
                sql.addFilter(dimAndMem[0], new String[]{dimAndMem[1]});
            }
            MDResultSet olapData = OlapServiceHelper.queryData((SQLBuilder)sql);
            boolean flag = false;
            while (olapData.next()) {
                int mark = olapData.getInt(FacTabFieldDefEnum.FIELD_SOURCE.getField());
                if (OlapSourceEnum.X1 != OlapSourceEnum.getSourceEnumByType((int)mark)) continue;
                flag = true;
            }
            if (!flag) {
                exist = flag;
            }
        }
        return exist;
    }

    public static FormShowParameter getLinkExtDataParameter(Long modelD, Map<String, String> dimNumber, String dimStr) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_linkqueryextdimdata");
        parameter.setCustomParam("modelD", (Object)modelD);
        parameter.setCustomParam("dimNumber", dimNumber);
        parameter.setCustomParam("dimStr", (Object)dimStr);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String name = ResManager.loadKDString((String)"\u8054\u67e5\u62d3\u5c55\u6570\u636e", (String)"LinkExtDataUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        parameter.setCaption(name);
        return parameter;
    }

    public static String parent2ChildEntity(Long modelID, Long memberID) {
        IDNumberTreeNode member = MemberReader.findMemberById((long)modelID, (String)"bcm_entitymembertree", (Long)memberID);
        return member.getParent().getNumber() + "_" + member.getNumber();
    }
}

