/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;

public class ShowFormulaUtil {
    public static final String FORMULAFILTER = "filter";
    public static final String VTICKETER = "vticketer";
    public static final String CONTAINSBN = "containsbn";

    public static void selectGuidePage(Formula formula, FormShowParameter parameter, long modelId) {
        if (StringUtils.isNotEmpty((CharSequence)formula.getGuidepage())) {
            parameter.setFormId(formula.getGuidepage());
            if ("bcm_vformula".equals(formula.getGuidepage())) {
                FormulaTicketer ticketer = new FormulaTicketer();
                if (formula.getParam().size() > 0) {
                    DimensionMsgCache dim = new DimensionMsgCache(modelId);
                    HashMap dims = new HashMap();
                    dim.getAllDimensionMsg().forEach(d -> dims.put(d.getNumber().toLowerCase(Locale.ENGLISH), d.getName()));
                    IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
                    for (Map map : formula.getParam()) {
                        IValidate v = null;
                        boolean mustinput = false;
                        if ("true".equals(String.valueOf(map.get("mustinput")))) {
                            v = notnull;
                            mustinput = true;
                        }
                        FTicket ti = new FTicket(String.valueOf(map.get("value")), String.valueOf(map.get("name")), v, true, true, mustinput);
                        if (map.get(FORMULAFILTER) != null) {
                            Map filter = (Map)map.get(FORMULAFILTER);
                            String sql = (String)filter.get("sql");
                            sql = "model = " + modelId + " and " + sql;
                            ti.setFilterString(sql);
                        }
                        ticketer.addTicket(String.valueOf(map.get("value")), ti);
                        dims.remove(String.valueOf(map.get("number")));
                    }
                    for (Map.Entry entry : dims.entrySet()) {
                        String number = (String)entry.getKey();
                        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)number);
                        ticketer.addTicket(BcmBasePluginUtil.sugarF7Key(entity, number), new FTicket(entity, (String)entry.getValue(), null, false, false));
                    }
                    parameter.setCustomParam("FormulaTicketer", (Object)ObjectSerialUtil.toByteSerialized(ticketer));
                } else {
                    String ti = (String)parameter.getCustomParam(VTICKETER);
                    if (StringUtils.isNotEmpty((CharSequence)ti)) {
                        parameter.setCustomParam("FormulaTicketer", (Object)ti);
                    } else {
                        parameter.setCustomParam("FormulaTicketer", (Object)ObjectSerialUtil.toByteSerialized(ticketer));
                    }
                }
                parameter.setCustomParam("formulanumber", (Object)formula.getNumber());
                parameter.setCustomParam("displayProp", (Object)"name");
            }
        } else if (kd.bos.util.StringUtils.isEmpty((String)formula.getGuidepage())) {
            if (formula.getParam().size() > 0) {
                parameter.setFormId("bcm_formulaparam_wide");
            } else {
                parameter.setFormId("bcm_formulaparam");
            }
        }
    }

    public static String formula2LowerCase(String formulaStr) {
        int firstIndex = formulaStr.indexOf(40);
        formulaStr = formulaStr.substring(0, firstIndex).toLowerCase(Locale.ENGLISH) + formulaStr.substring(firstIndex);
        return formulaStr;
    }

    public static void setVTicketer(FormShowParameter parameter, FormulaTicketer<DynamicObject> ticketer) {
        parameter.setCustomParam(VTICKETER, (Object)ObjectSerialUtil.toByteSerialized(ticketer));
    }
}

