/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.intergration.util.SchemeDimHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class UpdateMapJsonUtil {
    public static void updateMapJsonForSingle(List<DynamicObject> dimMaps, Long mappingId, DynamicObject[] result) {
        DynamicObject mapjson = BusinessDataServiceHelper.loadSingle((String)"bcm_ismapjson", (String)"id,spreadjson,data", (QFilter[])new QFilter[]{new QFilter("dimmapid", "=", (Object)mappingId)});
        if (mapjson != null && StringUtils.isNotEmpty((CharSequence)mapjson.getString("data"))) {
            SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)mapjson.getString("data"));
            JSONObject object = JSONObjectUtil.parseObjectOrder((String)new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str((String)mapjson.getString("spreadjson"))))));
            Sheet data = spreadManager.getBook().getSheet(0);
            int maxRowCount = data.getMaxRowCount();
            int startIdx = 2;
            for (int i = maxRowCount - 1; i >= 2; --i) {
                if (data.getCell(i, 0).getValue() == null) continue;
                startIdx = i + 1;
                break;
            }
            JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)object, (String)data.getSheetName());
            for (int i = 0; i < dimMaps.size(); ++i) {
                data.addRow();
                UpdateMapJsonUtil.addColumsForData(data, 4);
                UpdateMapJsonUtil.getNewColum(data, startIdx, 0, 4).setValue((Object)dimMaps.get(i).getString("targmembnumber"));
                ((Cell)data.getRow(startIdx).get(0)).setUserObject("id", (Object)result[i].getLong("id"));
                UpdateMapJsonUtil.getNewColum(data, startIdx, 1, 4).setValue((Object)dimMaps.get(i).getString("targmembname"));
                UpdateMapJsonUtil.getNewColum(data, startIdx, 2, 4).setValue((Object)dimMaps.get(i).getString("srcmembnumber"));
                UpdateMapJsonUtil.getNewColum(data, startIdx, 3, 4).setValue((Object)dimMaps.get(i).getString("srcmembname"));
                UpdateMapJsonUtil.insertDataToSpreadjson(dataTable, startIdx + "", "0", dimMaps.get(i).getString("targmembnumber"));
                UpdateMapJsonUtil.insertDataToSpreadjson(dataTable, startIdx + "", "1", dimMaps.get(i).getString("targmembname"));
                UpdateMapJsonUtil.insertDataToSpreadjson(dataTable, startIdx + "", "2", dimMaps.get(i).getString("srcmembnumber"));
                UpdateMapJsonUtil.insertDataToSpreadjson(dataTable, startIdx + "", "3", dimMaps.get(i).getString("srcmembname"));
                ++startIdx;
            }
            JSONObject sheetInfo = DataAndJsonTranslator.getSheetInfo((JSONObject)object);
            if (sheetInfo.containsKey((Object)"rowCount")) {
                sheetInfo.put("rowCount", (Object)dataTable.size());
            }
            mapjson.set("data", (Object)ObjectSerialUtil.toByteSerialized((Object)spreadManager));
            byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
            String bbs = new String(bb);
            mapjson.set("spreadjson", (Object)("base64" + bbs));
            SaveServiceHelper.update((DynamicObject)mapjson);
        }
    }

    public static void updateMapJsonForGroup(XSSFSheet sheet, Map<String, List<Integer>> typeAndPassRow, Long dimMapId, int groupDseq, int formulaDseq, DynamicObject[] result) {
        int i;
        DynamicObject[] mapJsons = BusinessDataServiceHelper.load((String)"bcm_ismapjson", (String)"type,spreadjson,data", (QFilter[])new QFilter[]{new QFilter("dimmapid", "=", (Object)dimMapId)});
        Sheet data = null;
        JSONObject object = null;
        int startIdx = 2;
        DynamicObject ismapjson = null;
        List<Integer> passRow = null;
        SpreadManager spreadManager = null;
        int dseq = 0;
        int lastCellNum = sheet.getRow(1).getLastCellNum();
        int tarDimEndCol = SchemeDimHelper.getTarDimEndCol(sheet, lastCellNum);
        String dimNumber = sheet.getRow(1).getCell(lastCellNum - 1).getStringCellValue();
        if ("expressions".equals(dimNumber)) {
            passRow = typeAndPassRow.get("2");
            for (DynamicObject mapJson : mapJsons) {
                if (!"2".equals(mapJson.getString("type"))) continue;
                ismapjson = mapJson;
                dseq = formulaDseq;
                break;
            }
        } else {
            passRow = typeAndPassRow.get("1");
            for (DynamicObject mapJson : mapJsons) {
                if (!"1".equals(mapJson.getString("type"))) continue;
                ismapjson = mapJson;
                dseq = groupDseq;
                break;
            }
        }
        if (ismapjson == null || StringUtil.isEmpty((CharSequence)ismapjson.getString("data"))) {
            return;
        }
        spreadManager = JsonSerializerUtil.toSpreadManager((String)ismapjson.getString("data"));
        data = spreadManager.getBook().getSheet(0);
        object = JSONObjectUtil.parseObjectOrder((String)new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str((String)ismapjson.getString("spreadjson"))))));
        JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)object, (String)data.getSheetName());
        int maxRowCount = data.getMaxRowCount();
        for (i = maxRowCount - 1; i >= 2; --i) {
            if (data.getCell(i, 0).getValue() == null) continue;
            startIdx = i + 1;
            break;
        }
        for (i = 0; i < passRow.size(); ++i) {
            data.addRow();
            for (int j = 0; j < lastCellNum; ++j) {
                String value = j == 0 ? dseq + "" : SchemeDimHelper.getCellValueByCell(sheet.getRow(passRow.get(i).intValue()).getCell(j));
                String dataValue = value;
                if (!"expressions".equals(dimNumber) && j >= 1 && j <= tarDimEndCol || j >= tarDimEndCol + 3 && j < lastCellNum) {
                    dataValue = dataValue.split("\\|")[0];
                } else if ("expressions".equals(dimNumber) && j >= 1 && j < lastCellNum - 1) {
                    dataValue = dataValue.split("\\|")[0];
                }
                ((Cell)data.getRow(startIdx, true).get(j)).setValue((Object)dataValue);
                if (j == 0) {
                    ((Cell)data.getRow(startIdx, true).get(j)).setUserObject("id", (Object)result[i].getLong("id"));
                }
                UpdateMapJsonUtil.insertDataToSpreadjson(dataTable, startIdx + "", j + "", value);
            }
            ++startIdx;
            ++dseq;
        }
        ismapjson.set("data", (Object)ObjectSerialUtil.toByteSerialized((Object)spreadManager));
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
        String bbs = new String(bb);
        ismapjson.set("spreadjson", (Object)("base64" + bbs));
        SaveServiceHelper.update((DynamicObject)ismapjson);
    }

    private static JSONObject createRowForSpreadjson(JSONObject dataTable, String key) {
        if (dataTable.get((Object)key) != null) {
            return dataTable.getJSONObject(key);
        }
        JSONObject row = new JSONObject();
        dataTable.put(key, (Object)row);
        return row;
    }

    private static JSONObject createColForSpreadjson(JSONObject row, String key) {
        if (row.get((Object)key) != null) {
            return row.getJSONObject(key);
        }
        JSONObject col = new JSONObject();
        row.put(key, (Object)col);
        return col;
    }

    public static void insertDataToSpreadjson(JSONObject dataTable, String rowIdx, String colIdx, Object value) {
        JSONObject row = UpdateMapJsonUtil.createRowForSpreadjson(dataTable, rowIdx);
        JSONObject col = UpdateMapJsonUtil.createColForSpreadjson(row, colIdx);
        col.put("value", value);
    }

    public static void addColumsForData(Sheet sheet, int needColums) {
        int colSize = ((List)sheet.getTable().get(0)).size();
        if (needColums > colSize) {
            sheet.addColumns(needColums - colSize);
        }
    }

    public static Cell getNewColum(Sheet sheet, int rowIdx, int colIdx, int needColums) {
        int colSize = sheet.getRow(rowIdx, true).size();
        if (colSize == 0) {
            UpdateMapJsonUtil.addColumsForData(sheet, needColums);
        }
        Cell cell = (Cell)sheet.getRow(rowIdx, true).get(colIdx);
        return cell;
    }
}

