/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WriteExcelUtil {
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void writeExcel(IFormView view, List<List<String>> dataList, String name) {
        try {
            HSSFWorkbook workBook = null;
            if (StringUtils.substringAfterLast((String)name, (String)".").equals(EXCEL_XLS)) {
                workBook = new HSSFWorkbook();
            }
            if (StringUtils.substringAfterLast((String)name, (String)".").equals(EXCEL_XLSX)) {
                workBook = new XSSFWorkbook();
            }
            if (workBook == null) {
                return;
            }
            workBook.createSheet();
            workBook.setSheetName(0, "Sheet1");
            Sheet sheet = workBook.getSheetAt(0);
            for (int j = 0; j < dataList.size(); ++j) {
                Row row = sheet.createRow(j);
                List<String> data = dataList.get(j);
                for (int k = 0; k < data.size(); ++k) {
                    Cell first = row.createCell(k);
                    if (data.get(k) == null) continue;
                    first.setCellValue(data.get(k));
                }
            }
            String url = WriteExcelUtil.writeFile((Workbook)workBook, name);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(Workbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

