/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.vo;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.ExportFileRuleEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class RpaFileModel
implements Serializable {
    public static final String TYPE_FILE = "1";
    public static final String TYPE_SHEET = "2";
    private Long rpascheme;
    private String type;
    private String joinsymbol;
    private String textvalue;
    private Long creater;
    private Date createTime;
    private Long modifier;
    private Date modifyDate;
    private List<String> codeList;
    private static final List<String> fileDefaultRuleNumbers = Lists.newArrayList((Object[])new String[]{ExportFileRuleEnum.ORG_NAME.getCode(), ExportFileRuleEnum.REPORTDATATYPE.getCode()});
    private static final List<String> sheetDefaultRuleNumbers = Lists.newArrayList((Object[])new String[]{ExportFileRuleEnum.REPORT_NAME.getCode()});

    public RpaFileModel(String type) {
        this(0L, type, "_", "", RpaFileModel.getDefaultCodeList(type));
    }

    public static List<String> getDefaultCodeList(String type) {
        return TYPE_FILE.equals(type) ? fileDefaultRuleNumbers : sheetDefaultRuleNumbers;
    }

    public RpaFileModel(Long rpascheme, String type, String joinsymbol, String textvalue, List<String> codeList) {
        this.rpascheme = rpascheme;
        this.type = type;
        this.joinsymbol = joinsymbol;
        this.textvalue = textvalue;
        this.codeList = codeList;
    }

    public static RpaFileModel getModelByDynamicObject(DynamicObject[] businessData, String type) {
        if (StringUtil.isEmptyString((String)type)) {
            return null;
        }
        if (businessData != null && businessData.length > 0) {
            DynamicObject data;
            Optional<DynamicObject> optional = Arrays.stream(businessData).filter(r -> type.equals(r.getString("type"))).findFirst();
            DynamicObject dynamicObject = data = optional.isPresent() ? optional.get() : null;
            if (data != null) {
                List<String> codeList = Arrays.stream(businessData).filter(r -> type.equals(r.getString("type"))).sorted(Comparator.comparing(r -> r.getInt("ordernum"))).map(r -> r.getString("namecode")).collect(Collectors.toList());
                return new RpaFileModel(data.getLong("rpascheme.id"), type, data.getString("joinsymbol"), data.getString("fixedvalue"), codeList);
            }
        } else {
            return new RpaFileModel(type);
        }
        return null;
    }

    public static RpaFileModel getModelByDynamicObject(Long rpaschemeId, String type) {
        DynamicObject[] businessData = RpaFileModel.getModelByDynamicObject(rpaschemeId);
        return RpaFileModel.getModelByDynamicObject(businessData, type);
    }

    public static DynamicObject[] getModelByDynamicObject(Long rpaschemeId) {
        if (rpaschemeId != null && LongUtil.toLong((Object)rpaschemeId) > 0L) {
            String selectProperties = "rpascheme,ordernum,type,namecode,fixedvalue,joinsymbol,creater,createdate,modifier,modifydate";
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("rpascheme", "=", (Object)rpaschemeId).add("type", "in", (Object)Sets.newHashSet((Object[])new String[]{TYPE_FILE, TYPE_SHEET}));
            return BusinessDataServiceHelper.load((String)"bcm_isrpaschemerule", (String)selectProperties, (QFilter[])qfBuilder.toArray());
        }
        return null;
    }

    public static String getShowStr(RpaFileModel model) {
        if (model != null && CollectionUtils.isNotEmpty(model.getCodeList())) {
            List<String> codeList = model.getCodeList();
            return codeList.stream().map(r -> ExportFileRuleEnum.TXT.getCode().equals(r) ? model.getTextvalue() : ExportFileRuleEnum.getNameByCode((String)r)).collect(Collectors.joining(model.getJoinsymbol()));
        }
        return "";
    }

    public static String getCodeStr(RpaFileModel model) {
        if (model != null && CollectionUtils.isNotEmpty(model.getCodeList())) {
            List<String> codeList = model.getCodeList();
            return codeList.stream().map(r -> ExportFileRuleEnum.TXT.getCode().equals(r) ? model.getTextvalue() : r).collect(Collectors.joining(model.getJoinsymbol()));
        }
        return "";
    }

    public static Pair<String, String> getCodeStr(Long rpaschemeId) {
        DynamicObject[] businessData = RpaFileModel.getModelByDynamicObject(rpaschemeId);
        RpaFileModel fileModel = RpaFileModel.getModelByDynamicObject(businessData, TYPE_FILE);
        RpaFileModel sheetModel = RpaFileModel.getModelByDynamicObject(businessData, TYPE_SHEET);
        String fileStr = "";
        String sheetStr = "";
        if (fileModel != null) {
            String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            String codeStr = RpaFileModel.getCodeStr(fileModel);
            String string = fileStr = StringUtil.isEmptyString((String)codeStr) ? "orgname_" + timeStr : codeStr;
        }
        if (sheetModel != null) {
            String codeStr = RpaFileModel.getCodeStr(sheetModel);
            sheetStr = StringUtil.isEmptyString((String)codeStr) ? "reportname" : codeStr;
        }
        return new Pair((Object)fileStr, (Object)sheetStr);
    }

    public static void save(Long rpascheme, List<RpaFileModel> models) {
        if (CollectionUtils.isEmpty(models)) {
            return;
        }
        if (rpascheme == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u62a5\u8868\u673a\u5668\u4eba\u65b9\u6848\u3002", (String)"RpaFileModel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Optional<Integer> reduce = models.stream().map(r -> r.getCodeList().size()).reduce(Integer::sum);
        Integer size = reduce.isPresent() ? reduce.get() : Integer.valueOf(0);
        Set typeSet = models.stream().map(r -> r.getType()).collect(Collectors.toSet());
        QFilter qf = new QFilter("rpascheme", "=", (Object)rpascheme).and("type", "in", typeSet);
        DynamicObject[] doArr = new DynamicObject[size.intValue()];
        try (TXHandle tx = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bcm_isrpaschemerule", (QFilter[])new QFilter[]{qf});
                DynamicObject saveData = null;
                int index = 0;
                for (RpaFileModel model : models) {
                    List<String> dataList = model.getCodeList();
                    long userId = Long.parseLong(RequestContext.get().getUserId());
                    Date date = new Date();
                    for (int i = 0; i < dataList.size(); ++i) {
                        saveData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isrpaschemerule");
                        saveData.set("rpascheme", (Object)model.getRpascheme());
                        saveData.set("ordernum", (Object)i);
                        saveData.set("type", (Object)model.getType());
                        saveData.set("namecode", (Object)dataList.get(i));
                        saveData.set("fixedvalue", (Object)model.getTextvalue());
                        saveData.set("joinsymbol", (Object)model.getJoinsymbol());
                        saveData.set("creater", (Object)userId);
                        saveData.set("createdate", (Object)date);
                        saveData.set("modifier", (Object)userId);
                        saveData.set("modifydate", (Object)date);
                        doArr[index++] = saveData;
                    }
                }
                SaveServiceHelper.save((DynamicObject[])doArr);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    public Long getRpascheme() {
        return this.rpascheme;
    }

    public void setRpascheme(Long rpascheme) {
        this.rpascheme = rpascheme;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getJoinsymbol() {
        return this.joinsymbol;
    }

    public void setJoinsymbol(String joinsymbol) {
        this.joinsymbol = joinsymbol;
    }

    public String getTextvalue() {
        return this.textvalue;
    }

    public void setTextvalue(String textvalue) {
        this.textvalue = textvalue;
    }

    public Long getCreater() {
        return this.creater;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getModifier() {
        return this.modifier;
    }

    public void setModifier(Long modifier) {
        this.modifier = modifier;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public List<String> getCodeList() {
        return this.codeList;
    }

    public void setCodeList(List<String> codeList) {
        this.codeList = codeList;
    }
}

