/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.util.ApplyEntityHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ApplyEntityPlugin
extends AbstractBaseFormPlugin {
    private static final String SCOPE = "scope";
    public static final String ENTRYENTITY = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_selectentity", "btn_delentity", "btn_cancel", "btn_confirm");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_selectentity".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_mulmemberf7base_dis");
            formShowParameter.setCustomParam("dimension", (Object)"1");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"AdjustPaperTemplateAssignPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectentity_closecallback");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        } else if ("btn_delentity".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"AdjustPaperTemplateAssignPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AdjustPaperTemplateAssignPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
        } else if ("btn_confirm".equals(key)) {
            DynamicObjectCollection settings = this.getModel().getEntryEntity(ENTRYENTITY);
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            ArrayList<Map> items = new ArrayList<Map>(16);
            HashSet<String> configSet = new HashSet<String>(16);
            for (DynamicObject dyn : settings) {
                Long entityId = dyn.getLong("entityid");
                String entitynumber = dyn.getString("entitynumber");
                String pid = dyn.getString("pid");
                String range = dyn.getString("range");
                String isexcept = dyn.getString("isexcept");
                String configStr = range + "_" + isexcept + "_" + entityId;
                if (!configSet.add(configStr)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"TemplateMutiScenceSetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                items.add(MapInitHelper.ofMap((Object)"id", (Object)entityId, (Object)"number", (Object)entitynumber, (Object)"pid", (Object)pid, (Object)SCOPE, (Object)range, (Object)"isexcept", (Object)isexcept));
            }
            result.put("name", ApplyEntityHelper.getApplyEntityScope((Long)this.getModelId(), items).getApplyString());
            result.put("items", items);
            this.returnDataToParent(result);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.contains("delete_comfirm") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] listrows = entryGrid.getSelectRows();
            this.getModel().deleteEntryRows(ENTRYENTITY, listrows);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("selectentity_closecallback".equals(actionId) && event.getReturnData() != null) {
            for (DynamicObject org : (DynamicObjectCollection)event.getReturnData()) {
                int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("entityid", org.get("mid1"), newEntryRow);
                if (StringUtils.isEmpty((CharSequence)org.getString("pid1").trim()) || Objects.equals("0", org.getString("pid1").trim())) {
                    IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)org.getLong("mid1"));
                    this.getModel().setValue("entityname", (Object)node.getName(), newEntryRow);
                    this.getModel().setValue("entitynumber", (Object)node.getNumber(), newEntryRow);
                    this.getModel().setValue("pid", (Object)0, newEntryRow);
                } else {
                    this.getModel().setValue("entityname", org.get("mname1"), newEntryRow);
                    this.getModel().setValue("entitynumber", org.get("mnum1"), newEntryRow);
                    this.getModel().setValue("pid", (Object)org.getLong("pid1"), newEntryRow);
                }
                this.getModel().setValue("range", org.get("filltypevalue1"), newEntryRow);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String selecteditems = (String)formShowParameter.getCustomParam("selecteditems");
        Long model = (Long)formShowParameter.getCustomParam("model");
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(model));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selecteditems)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            List entityList = (List)this.deSerializedBytes(selecteditems);
            if (!CollectionUtils.isEmpty((Collection)entityList)) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entityList.size());
                Map allNodeProperty = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)model);
                DynamicObjectCollection entityProperty = ApplyEntityHelper.getSysProperty((Long)model, (String)"Entity");
                Map<Long, DynamicObject> propertyMap = entityProperty.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
                for (int i = 0; i < entityList.size(); ++i) {
                    Long pid;
                    DynamicObject property;
                    Map entity = (Map)entityList.get(i);
                    this.getModel().setValue("entityid", entity.get("id"), i);
                    this.getModel().setValue("range", entity.get(SCOPE), i);
                    this.getModel().setValue("isexcept", entity.get("isexcept"), i);
                    IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)model, (Long)LongUtil.toLong(entity.get("id")));
                    if (node != IDNumberTreeNode.NotFoundTreeNode) {
                        this.getModel().setValue("entityname", (Object)node.getName(), i);
                        this.getModel().setValue("entitynumber", (Object)node.getNumber(), i);
                        this.getModel().setValue("pid", (Object)0, i);
                        continue;
                    }
                    IDNumberTreeNode cusNode = (IDNumberTreeNode)allNodeProperty.get(LongUtil.toLong(entity.get("id")));
                    if (cusNode == null || (property = propertyMap.get(pid = (Long)cusNode.getProperty("property.id"))) == null) continue;
                    this.getModel().setValue("entityname", (Object)cusNode.getName(), i);
                    this.getModel().setValue("entitynumber", (Object)String.format("%s:%s", property.getString("number"), cusNode.getNumber()), i);
                    this.getModel().setValue("pid", (Object)LongUtil.toLong(entity.get("pid")), i);
                }
            }
        }
    }
}

