/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.enums.invest.InvFetchType;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.invest.EspFunctionSettingPlugin;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class DespFunctionSettingPlugin
extends EspFunctionSettingPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DespFunctionSettingPlugin.class);
    private static final String CHANGE_TYPE = "invchangetype";
    private static final String FETCH_TYPE = "numbertype";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit basedata2 = (BasedataEdit)this.getControl(CHANGE_TYPE);
        if (basedata2 != null) {
            basedata2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        beforeF7SelectEvent.addCustomQFilter(this.getQFilter());
    }

    public QFilter getQFilter() {
        Long modelid = this.getModelId();
        return new QFilter("model", "=", (Object)modelid).and("enable", "=", (Object)"1");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("invholderorg", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"EspFunctionSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("investorg", (Object)ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"EspFunctionSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String curform = this.getView().getFormShowParameter().getParentFormId();
        if (!("bcm_invchangeformula".equals(curform) || "bcm_invsheettemplateedit".equals(curform) || Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("is_draft")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"invholderorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"holderorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"invholderorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"holderorg"});
        }
        this.initParameterValues();
    }

    public void initParameterValues() {
        ArrayList<String> parameters = new ArrayList<String>(10);
        String formula = (String)this.getFormCustomParam("formula");
        if (!StringUtils.isEmpty((CharSequence)formula)) {
            try {
                FunctionExpr expr = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)formula);
                expr.getParameters().forEach(e -> {
                    String param = e.toString().replaceAll("\"", "");
                    parameters.add(param);
                });
                ResultBox resultBox = this.checkAndInitParameters(parameters);
                if (resultBox.isError()) {
                    this.getView().showErrorNotification(resultBox.getMessageText());
                }
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
            }
        }
        this.checkchangetypeMust();
    }

    private void checkchangetypeMust() {
        BasedataEdit basedataEdit;
        String parentFormId = this.getView().getParentView().getFormShowParameter().getFormId();
        if (!"bcm_invsheettemplateedit".equalsIgnoreCase(parentFormId) && !"bcm_formulapicker_invest".equalsIgnoreCase(parentFormId) && (basedataEdit = (BasedataEdit)this.getControl(CHANGE_TYPE)) != null) {
            basedataEdit.setMustInput(Boolean.TRUE.booleanValue());
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("confirm".equals(key)) {
            this.validateData();
            String sNumber = this.getModel().getValue("scenario") == null ? "" : ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            String yNumber = this.getModel().getValue("year") == null ? "" : ((DynamicObject)this.getModel().getValue("year")).getString("number");
            String pNumber = this.getModel().getValue("period") == null ? "" : ((DynamicObject)this.getModel().getValue("period")).getString("number");
            String hNumber = this.getModel().getValue("holderorg") == null ? "" : ((DynamicObject)this.getModel().getValue("holderorg")).getString("number");
            String invchangetype = this.getModel().getValue(CHANGE_TYPE) == null ? "" : ((DynamicObject)this.getModel().getValue(CHANGE_TYPE)).getString("number");
            String numberType = this.getNumbertype();
            String invFormula = "Desp(\"" + invchangetype + "\",\"" + numberType + "\",\"" + sNumber + "\",\"" + yNumber + "\",\"" + pNumber + "\",\"" + hNumber + "\",\"\")";
            HashMap map = Maps.newHashMap();
            map.put("formula", invFormula);
            map.put("name", InvFetchType.getDescByName((String)numberType));
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    private String getNumbertype() {
        String number = (String)this.getModel().getValue(FETCH_TYPE);
        return InvFetchType.getNumberByType((String)number);
    }

    protected ResultBox checkAndInitParameters(List<String> parameters) {
        DynamicObject invest;
        DynamicObject holder;
        ResultBox box = ResultBox.of();
        if (parameters == null) {
            box.addError(ResManager.loadKDString((String)"\u516c\u5f0f\u4e3a\u7a7a\u3002", (String)"VFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return box;
        }
        if (parameters.size() != 7) {
            box.addError(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2a\u6570\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"VFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return box;
        }
        Long modelId = this.getModelId();
        String sharescaletype = parameters.get(0);
        String numberType = parameters.get(1);
        String sNumber = parameters.get(2);
        String yearNumber = parameters.get(3);
        String periodNumber = parameters.get(4);
        String holderNumber = parameters.get(5);
        String investNumber = parameters.get(6);
        DynamicObject scaletype = this.getDyByNumber("bcm_invchangetype", sharescaletype);
        DynamicObject s = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_scenemembertree", (Object)this.getModelId(), (String)sNumber);
        DynamicObject year = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_fymembertree", (Object)this.getModelId(), (String)yearNumber);
        DynamicObject period = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_periodmembertree", (Object)this.getModelId(), (String)periodNumber);
        if (scaletype != null) {
            this.getModel().setValue(CHANGE_TYPE, (Object)scaletype.getLong("id"));
        }
        this.getModel().setValue(FETCH_TYPE, (Object)InvFetchType.getTypeByName((String)numberType));
        if (s != null) {
            this.getModel().setValue("scenario", (Object)s.getLong("id"));
        }
        if (year != null) {
            this.getModel().setValue("year", (Object)year.getLong("id"));
        }
        if (period != null) {
            this.getModel().setValue("period", (Object)period.getLong("id"));
        }
        if (!StringUtils.isEmpty((CharSequence)holderNumber) && (holder = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_icmembertree", (Object)modelId, (String)holderNumber)) != null) {
            this.getModel().setValue("holderorg", (Object)holder.getLong("id"));
            this.getModel().setValue("invholderorg", (Object)holderNumber);
        }
        if (!StringUtils.isEmpty((CharSequence)investNumber) && (invest = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_entitymembertree", (Object)modelId, (String)investNumber)) != null) {
            this.getModel().setValue("investorg", (Object)investNumber);
        }
        return box;
    }

    @Override
    protected void setShareType(String sharescaletype) {
    }

    DynamicObject getDyByNumber(String entityname, String number) {
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)number);
        if ("bcm_invchangetype".equalsIgnoreCase(entityname)) {
            qfBuilder.and(this.getQFilter());
        } else {
            qfBuilder.and("model", "=", (Object)this.getModelId());
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityname, (QFilter[])qfBuilder.toArray());
    }
}

