/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.HolderTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.database.LTreeRListEdit;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.EncoderService;

public class EspFunctionSettingPlugin
extends AbstractBaseFormPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(EspFunctionSettingPlugin.class);
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    protected static final String IS_DRAFT = "is_draft";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.getView().addCustomControls(new String[]{"holderorg"});
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (ctrlKey.equals("holderorg")) {
            LTreeRListEdit bsEdit = new LTreeRListEdit();
            bsEdit.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"EspFunctionSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            bsEdit.setModelId(this.getModelId());
            bsEdit.setEntity("bcm_icmembertree");
            bsEdit.setF7Name("holderorg");
            bsEdit.setKey("holderorg");
            bsEdit.setModel(this.getModel());
            bsEdit.setView(this.getView());
            bsEdit.setDisplayProp("number");
            bsEdit.setFieldKey("holderorg");
            bsEdit.setEditSearchProp("number");
            bsEdit.setQFilter(new QFilter("model", "=", (Object)this.getModelId()));
            bsEdit.getQFilters().add(new QFilter("number", "!=", (Object)"ICNone"));
            e.setControl((Control)bsEdit);
        } else if (this.getDimKeysFromCache().containsKey(ctrlKey)) {
            SingleF7TypeEnum type = this.getDimKeysFromCache().get(ctrlKey);
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)this.getModelId());
            qf.add("number", "=", (Object)QueryDimensionServiceHelper.getDimNumberEgnoreCase((String)ctrlKey, (long)this.getModelId()));
            DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id", (QFilter[])qf.toArray());
            BasedataEditSingleMemberF7 basedataSingleF7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getLong("id"), ctrlKey, null, false, type);
            basedataSingleF7.setDisplayAllFyOrPeriodMemb(true);
            e.setControl((Control)basedataSingleF7);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("confirm");
        BasedataEdit shareholderidEdit = (BasedataEdit)this.getView().getControl("holderorg");
        shareholderidEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sceneEdit = (BasedataEdit)this.getView().getControl("scenario");
        sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yearEdit = (BasedataEdit)this.getView().getControl("year");
        yearEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("period");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("invholderorg", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"EspFunctionSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("investorg", (Object)ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"EspFunctionSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (!"bcm_invchangeformula".equals(this.getView().getFormShowParameter().getParentFormId()) && !Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"invholderorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"holderorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"invholderorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"holderorg"});
        }
        String numberType = null;
        if (this.getFormCustomParam("formula") != null) {
            String formula = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formula, encoder);
                String sharescaletype = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(0)).toString();
                numberType = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(1)).toString();
                String sNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(2)).toString();
                String yearNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(3)).toString();
                String periodNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(4)).toString();
                String holderNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(5)).toString();
                DynamicObject s = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_scenemembertree", (Object)this.getModelId(), (String)sNumber);
                DynamicObject year = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_fymembertree", (Object)this.getModelId(), (String)yearNumber);
                DynamicObject period = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_periodmembertree", (Object)this.getModelId(), (String)periodNumber);
                DynamicObject holder = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_icmembertree", (Object)this.getModelId(), (String)holderNumber);
                if (s != null) {
                    this.getModel().setValue("scenario", (Object)s.getLong("id"));
                }
                if (year != null) {
                    this.getModel().setValue("year", (Object)year.getLong("id"));
                }
                if (period != null) {
                    this.getModel().setValue("period", (Object)period.getLong("id"));
                }
                if (holder != null) {
                    this.getModel().setValue("holderorg", (Object)holder.getLong("id"));
                }
                this.rebuildNumberType(sharescaletype);
                this.setShareType(sharescaletype);
                this.getModel().setValue("numbertype", (Object)numberType);
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        } else {
            this.setShareType((String)this.getFormCustomParam("sharescaletype"));
            this.rebuildNumberType((String)this.getFormCustomParam("sharescaletype"));
        }
        this.initComboItems(this.getModelId());
        if (StringUtils.isNotEmpty(numberType)) {
            this.getModel().setValue("numbertype", numberType);
        }
    }

    protected void setShareType(String sharescaletype) {
        if (this.getControl("sharescaletype") == null) {
            return;
        }
        this.getModel().setValue("sharescaletype", (Object)sharescaletype);
    }

    private void initComboItems(Long modelId) {
        ComboEdit ce = (ComboEdit)this.getControl("sharescaletype");
        if (ce == null) {
            return;
        }
        List items = InvRelationTypeHelper.getComboItems((Long)modelId, qFBuilder -> qFBuilder.add("status", "=", (Object)InvRelationTypeConstant.StatusEnum.ENABLE.getCode()));
        ce.setComboItems(items);
        this.initShareScaleTypeValue(items);
        Object shareScaleType = this.getModel().getValue("sharescaletype");
        if (shareScaleType == null) {
            this.getModel().setValue("numbertype", null);
        } else {
            this.rebuildNumberType((String)shareScaleType);
        }
    }

    private void initShareScaleTypeValue(List<ComboItem> items) {
        Object formCustomParam = this.getFormCustomParam("invrelationtype");
        if (formCustomParam != null) {
            this.getModel().setValue("sharescaletype", null);
            for (ComboItem item : items) {
                String value = item.getValue();
                if (!value.equals(formCustomParam)) continue;
                this.getModel().setValue("sharescaletype", (Object)value);
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("confirm".equals(key)) {
            this.validateData();
            this.mustInputCheck();
            String sNumber = this.getModel().getValue("scenario") == null ? "" : ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            String yNumber = this.getModel().getValue("year") == null ? "" : ((DynamicObject)this.getModel().getValue("year")).getString("number");
            String pNumber = this.getModel().getValue("period") == null ? "" : ((DynamicObject)this.getModel().getValue("period")).getString("number");
            String hNumber = this.getModel().getValue("holderorg") == null ? "" : ((DynamicObject)this.getModel().getValue("holderorg")).getString("number");
            String sharescaletype = (String)this.getModel().getValue("sharescaletype");
            String numberType = (String)this.getModel().getValue("numbertype");
            String invFormula = "Esp(\"" + sharescaletype + "\",\"" + numberType + "\",\"" + sNumber + "\",\"" + yNumber + "\",\"" + pNumber + "\",\"" + hNumber + "\",\"\")";
            HashMap map = Maps.newHashMap();
            map.put("formula", invFormula);
            String name = HolderTypeEnum.getNameByNumber((String)numberType);
            if ("4".equals(sharescaletype) || "5".equals(sharescaletype)) {
                name = HolderTypeEnum.UniteScale.getName();
            }
            map.put("name", name);
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("sharescaletype".equals(key)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            newValue = e.getChangeSet() == null || StringUtils.isEmpty((String)newValue) ? oldValue : newValue;
            this.rebuildNumberType(newValue);
        }
    }

    private void rebuildNumberType(String newValue) {
        if ("1".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.equivalentAdd.getName()), HolderTypeEnum.equivalentAdd.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.littleAdd.getName()), HolderTypeEnum.littleAdd.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.equivalentAdd.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else if ("2".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.direct.getName()), HolderTypeEnum.direct.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.little.getName()), HolderTypeEnum.little.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.direct.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else if ("3".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.equivalentMulti.getName()), HolderTypeEnum.equivalentMulti.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.littleMulti.getName()), HolderTypeEnum.littleMulti.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.equivalentMulti.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else if ("4".equals(newValue) || "5".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.UniteScale.getName()), HolderTypeEnum.little.getNumber());
            comboItems.add(item1);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.little.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.little.getName()), HolderTypeEnum.little.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.DefindScale.getName()), HolderTypeEnum.DefindScale.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.DefindScale.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        }
    }

    protected void validateData() {
        String curform = this.getView().getFormShowParameter().getParentFormId();
        if (!("bcm_invchangeformula".equals(curform) || "bcm_invsheettemplateedit".equals(curform) || Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT)) || this.getModel().getValue("holderorg") != null)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6295\u8d44\u5355\u4f4d\u3002", (String)"EspFunctionSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void mustInputCheck() {
        String shareScaleType = (String)this.getModel().getValue("sharescaletype");
        if (Objects.isNull(shareScaleType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u3002", (String)"EspFunctionSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String numberType = (String)this.getModel().getValue("numbertype");
        if (Objects.isNull(numberType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u6570\u7c7b\u578b\u3002", (String)"EspFunctionSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

