/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustEntryConfig;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.MulTiF7FilterTempleUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.adjust.report.AbjustExportUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class InvAnnualAccountPlugin
extends AbstractBaseFormPlugin {
    protected String ctl_entryentity = "entryentity";
    private static final String CONFIRM_SAVE_THAN_REFRESH = "confirm_save_than_refresh";
    private static final String CONFIRM_SAVE_THAN_CLOSE = "confirm_save_than_close";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(InvAnnualAccountPlugin.class);

    @Override
    public long getModelId() {
        return Long.parseLong(this.getValue("model_id").toString());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        LossCarryScheme.getLossCarryDimCtx((Long)this.getModelId()).getDimensions().forEach(p -> this.addClickListeners(p.getFieldmapped(), p.getFieldmapped().concat("after")));
        this.addClickListeners("btn_save", "applyentity", "applyscene");
        this.addItemClickListeners("advcontoolbarap", "toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
        this.updateNoSeqData();
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ctl_entryentity);
        this.getView().setVisible(Boolean.FALSE, (String[])entryGrid.getFieldEdits().stream().map(FieldEdit::getFieldKey).toArray(String[]::new));
        this.getView().setVisible(Boolean.TRUE, new String[]{"isopen", "applyentity", "applyscene"});
        for (Dimension dim : LossCarryScheme.getDimensions((Long)this.getModelId())) {
            entryGrid.setColumnProperty(dim.getFieldmapped(), "header", (Object)new LocaleString(dim.getName()));
            entryGrid.setColumnProperty(dim.getFieldmapped() + "after", "header", (Object)new LocaleString(dim.getName()));
            this.getView().setVisible(Boolean.TRUE, new String[]{dim.getFieldmapped(), dim.getFieldmapped() + "after"});
        }
        this.refresh();
        this.getModel().setDataChanged(false);
        this.getModel().updateCache();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\u4fee\u6539\uff1f", (String)"InvAnnualAccountPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_SAVE_THAN_CLOSE, (IFormPlugin)this));
        }
    }

    private void updateNoSeqData() {
        QFilter model = new QFilter("model", "=", (Object)this.getModelId());
        QFilter noseq = new QFilter("dseq", "=", (Object)1);
        QFilter noseq2 = new QFilter("dseq", "=", (Object)0);
        DynamicObject count = QueryServiceHelper.queryOne((String)"bcm_annualaccount", (String)"count(*) as count", (QFilter[])new QFilter[]{model, noseq});
        if (count.getInt("count") > 1 || QueryServiceHelper.exists((String)"bcm_annualaccount", (QFilter[])new QFilter[]{model, noseq2})) {
            DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_annualaccount", (String)"dseq", (QFilter[])new QFilter[]{model});
            int seq = 1;
            for (DynamicObject dy : dys) {
                dy.set("dseq", (Object)seq++);
            }
            SaveServiceHelper.update((DynamicObject[])dys);
            AdjustEntryConfig.get().clearLossCarrySchemeCache(Long.valueOf(this.getModelId()));
        }
    }

    protected void refresh() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(this.ctl_entryentity);
        dynamicObjects.clear();
        List lossCarrySchemes = AdjustmentServiceHelper.getOverYearCopyConfig((long)this.getModelId());
        if (lossCarrySchemes == null || lossCarrySchemes.size() == 0) {
            return;
        }
        for (LossCarryScheme lossCarryScheme : lossCarrySchemes) {
            DynamicObject currentRow = dynamicObjects.addNew();
            currentRow.set("isopen", (Object)lossCarryScheme.isOpen());
            lossCarryScheme.getSchemeDetails().forEach((dim, dimscope) -> {
                Dimension dimension = (Dimension)dim;
                DimensionScope dimensionScope = (DimensionScope)dimscope;
                if (dimscope != null) {
                    currentRow.set(dimension.getFieldmapped(), (Object)dimensionScope.toString());
                }
            });
            Map afterDimInfo = lossCarryScheme.getAfterDimenSopeInfo();
            for (Map.Entry dim2 : afterDimInfo.entrySet()) {
                String context = null;
                DynamicObject dy = (DynamicObject)dim2.getValue();
                if (dy != null) {
                    context = String.format("%s_%s", dy.getString("number"), dy.getString("name"));
                }
                currentRow.set(((Dimension)dim2.getKey()).getFieldmapped() + "after", context);
            }
            if (lossCarryScheme.getApplyEntityScope() != null) {
                currentRow.set("applyentity", (Object)lossCarryScheme.getApplyEntityScope().getApplyString());
            }
            if (lossCarryScheme.getApplySceneScope() != null) {
                currentRow.set("applyscene", (Object)lossCarryScheme.getApplySceneScope().getApplyString());
            }
            currentRow.set("scheme", (Object)ObjectSerialUtil.toByteSerialized((Object)lossCarryScheme));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.click(evt.getItemKey());
    }

    public void click(String key) {
        if ("btn_save".equals(key)) {
            this.saveData();
        } else if ("btn_import".equals(key)) {
            this.invokeOperation("bcm_annaccount_import", "kd.fi.bcm.formplugin.adjust.report.InvAnnualAccountImportPlugin", ResManager.loadKDString((String)"\u635f\u76ca\u7ed3\u8f6c\u8bbe\u7f6e", (String)"InvAnnualAccountPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "IMPORT_ANNUALACCOUNT");
        } else if ("btn_export".equals(key)) {
            if (this.getModel().getDataChanged()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u8bf7\u4fdd\u5b58\u540e\u91cd\u8bd5", (String)"InvAnnualAccountPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid billList = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = billList.getSelectRows();
            try {
                String url = AbjustExportUtil.exportAnnualAccSetting(this.getBizAppId(), this.getModelId(), this.selectRow2Seq(selectRows));
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    this.downloadFile(url, "bcm_rptadjust_list", "4338LG5=MJ10");
                    this.writeMultiLangLog(OpItemEnum.EXPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "RptAdjustdListPlugin_22", "fi-bcm-formplugin", null));
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        } else if ("btn_refresh".equals(key)) {
            if (this.getModel().getDataChanged()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\u4fee\u6539\uff1f", (String)"InvAnnualAccountPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_SAVE_THAN_REFRESH, (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("refresh");
            }
        } else if (key.endsWith("after")) {
            Dimension dimension = this.getDimensionByNumber(key.substring(0, key.lastIndexOf("after")));
            if (dimension == null) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.ctl_entryentity);
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)dimension.getEntity(), (boolean)false);
            lsp.getListFilterParameter().setOrderBy("number");
            QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
            if (!dimension.isIssys()) {
                modelFilter.and("dimension.id", "=", (Object)dimension.getId());
            } else if ("accountafter".equals(key)) {
                modelFilter.and("islosscarry", "=", (Object)true);
            }
            if ("audittrailafter".equals(key)) {
                modelFilter.and("datasource", "=", (Object)DataSourceEnum.ENTRYADJUSTMENT.getOIndex());
            }
            modelFilter.and("isleaf", "=", (Object)"1");
            lsp.getListFilterParameter().setQFilters(Collections.singletonList(modelFilter));
            lsp.setCaption(dimension.getName());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, String.format("AfterF7|%s|%s", dimension.getFieldmapped(), entryGrid.getSelectRows()[0]));
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        } else if (LossCarryScheme.getLossCarryDimCtx((Long)this.getModelId()).getFieldMap().containsKey(key)) {
            Dimension dimension = this.getDimensionByNumber(key);
            String number = dimension.getNumber();
            int currentRow = ((EntryGrid)this.getControl(this.ctl_entryentity)).getSelectRows()[0];
            DynamicObject currentRowData = (DynamicObject)this.getModel().getEntryEntity(this.ctl_entryentity).get(currentRow);
            FormShowParameter para = MulTiF7FilterTempleUtils.createMulTiF7ShowParameter((IPageCache)this.getPageCache(), (long)this.getModelId(), (String)number, null);
            DimensionScope dimensionScope = this.getDimenScope(currentRowData, key);
            if (dimensionScope != null) {
                this.getPageCache().put(number, SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()));
            }
            if (para != null) {
                para.setCustomParam("sign", (Object)number);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, String.format("%s|%s|%s|%s", "MulTiF7", currentRow, key, number));
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
            }
        } else if (key.startsWith("apply")) {
            int currentRow = ((EntryGrid)this.getControl(this.ctl_entryentity)).getSelectRows()[0];
            DynamicObject currentRowData = (DynamicObject)this.getModel().getEntryEntity(this.ctl_entryentity).get(currentRow);
            DimensionScope dimensionScope = this.getDimenScope(currentRowData, key);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("applyscene".equals(key) ? "bcm_templatemutiscenceset" : "bcm_applyentity_f7");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            ArrayList items = new ArrayList(16);
            if (dimensionScope != null) {
                dimensionScope.getDimensionMembers().forEach(memberScop -> items.add(MapInitHelper.ofMap((Object)"id", (Object)memberScop.getId(), (Object)"scope", (Object)memberScop.getScope(), (Object)"isexcept", (Object)(memberScop.getApplyType() + ""))));
            }
            formShowParameter.setCustomParam("selecteditems", (Object)this.toByteSerialized(items));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, String.format("%s|%s|%s|%s", "apply", currentRow, key, "applyscene".equals(key) ? "Scenario" : "Entity")));
            this.getView().showForm(formShowParameter);
        }
    }

    private int[] selectRow2Seq(int[] selectRows) {
        if (selectRows.length > 0) {
            return Arrays.stream(selectRows).map(a -> a + 1).toArray();
        }
        return selectRows;
    }

    protected void saveData() {
        this.deleteBlankRows();
        if (this.checkRepeatDimComb()) {
            DynamicObjectCollection dys = this.getModel().getEntryEntity(this.ctl_entryentity);
            DeleteServiceHelper.delete((String)"bcm_annualaccount", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
            ArrayList<DynamicObject> annaccounts = new ArrayList<DynamicObject>(16);
            for (int i = 0; i < dys.size(); ++i) {
                LossCarryScheme loss = this.getLossCarryScheme(i);
                loss.setSeq(i + 1);
                loss.setOpen(((Boolean)this.getModel().getValue("isopen", i)).booleanValue());
                annaccounts.add(loss.toDy());
            }
            SaveServiceHelper.save((DynamicObject[])annaccounts.toArray(new DynamicObject[0]));
            AdjustEntryConfig.get().clearLossCarrySchemeCache(Long.valueOf(this.getModelId()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvAnnualAccountPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u7ed3\u8f6c", "InvAnnualAccountPlugin_3", "fi-bcm-formplugin", "carry-over"), new OPDescMultiLangEnumBridge("\u7ed3\u8f6c\u6210\u529f", "InvAnnualAccountPlugin_4", "fi-bcm-formplugin", null));
        }
    }

    protected boolean checkRepeatDimComb() {
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(this.ctl_entryentity);
        for (int i = 0; i < dcs.size(); ++i) {
            for (int k = 0; k < dcs.size() - 1 - i; ++k) {
                DynamicObject rowData2;
                DynamicObject rowData1 = (DynamicObject)dcs.get(i);
                if (!this.checkRowDataEqual(rowData1, rowData2 = (DynamicObject)dcs.get(i + 1 + k))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u5b58\u5728\u76f8\u540c\u7684\u5206\u5f55\u7ed3\u8f6c\u524d\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"InvAnnualAccountPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, i + 1 + k + 1));
                return false;
            }
        }
        return true;
    }

    protected boolean checkRowDataEqual(DynamicObject rowData1, DynamicObject rowData2) {
        if (rowData1.getBoolean("isopen") && rowData2.getBoolean("isopen")) {
            boolean isSameApplyEntity = DimensionScope.isDimensionScopeEqual((DimensionScope)this.getDimenScope(rowData1, "applyentity"), (DimensionScope)this.getDimenScope(rowData2, "applyentity"));
            boolean isSameApplyScene = DimensionScope.isDimensionScopeEqual((DimensionScope)this.getDimenScope(rowData1, "applyscene"), (DimensionScope)this.getDimenScope(rowData2, "applyscene"));
            return isSameApplyEntity && isSameApplyScene && LossCarryScheme.getLossCarryDimCtx((Long)this.getModelId()).getDimensions().stream().allMatch(dim -> DimensionScope.isDimensionScopeEqual((DimensionScope)this.getDimenScope(rowData1, dim.getFieldmapped()), (DimensionScope)this.getDimenScope(rowData2, dim.getFieldmapped())));
        }
        return false;
    }

    private void deleteBlankRows() {
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(this.ctl_entryentity);
        if (dcs.isEmpty()) {
            return;
        }
        List<String> noCheckColmun = Arrays.asList("isopen", "id", "seq", "scheme");
        DataEntityPropertyCollection properties = ((DynamicObject)dcs.get(0)).getDataEntityType().getProperties();
        ArrayList<Integer> nullRow = new ArrayList<Integer>(10);
        for (int rowIndex = 0; rowIndex < dcs.size(); ++rowIndex) {
            int finalRowIndex = rowIndex;
            if (properties.stream().filter(property -> !noCheckColmun.contains(property.getName())).anyMatch(property -> {
                Object value = this.getModel().getValue(property.getName(), finalRowIndex);
                return !ObjectUtils.isEmpty((Object)value) && !StringUtil.isEmptyString((String)value.toString());
            })) continue;
            nullRow.add(rowIndex);
        }
        if (nullRow.size() > 0) {
            int[] rowIndexs = new int[nullRow.size()];
            for (int i = 0; i < nullRow.size(); ++i) {
                rowIndexs[i] = (Integer)nullRow.get(i);
            }
            this.getModel().deleteEntryRows(this.ctl_entryentity, rowIndexs);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        this.click(((Control)evt.getSource()).getKey());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        Object returndata = closedCallBackEvent.getReturnData();
        if (action.startsWith("MulTiF7") && returndata != null) {
            String[] actions = action.split("\\|");
            int row = Integer.parseInt(actions[1]);
            String keyNum = actions[2];
            String dimNum = actions[3];
            this.getPageCache().remove(dimNum);
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)returndata;
            DimensionScope dimensionScope = null;
            String dimensionstr = null;
            Dimension dim = this.getDimensionByNumber(keyNum);
            if (!dynamicObjects.isEmpty()) {
                dimensionScope = new DimensionScope(Long.toString(this.getModelId()), dim, dynamicObjects);
                dimensionstr = dimensionScope.toString();
            }
            this.getModel().setValue(keyNum, dimensionstr, row);
            this.changeLossCarryScheme(keyNum, dimensionScope, row);
        } else if (action.startsWith("AfterF7")) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String[] actions = action.split("\\|");
            String keyNum = actions[1];
            String row = actions[2];
            if (selectedRows != null) {
                ListSelectedRow selectedRow = selectedRows.get(0);
                Object pkid = selectedRow.getPrimaryKeyValue();
                this.changeLossCarryScheme(keyNum + "after", pkid, Integer.parseInt(row));
                this.getModel().setValue(keyNum + "after", (Object)String.format("%s_%s", selectedRow.getNumber(), selectedRow.getName()), Integer.parseInt(row));
            }
        } else if ("IMPORT_ANNUALACCOUNT".equals(action)) {
            this.refresh();
        } else if (action.startsWith("apply") && closedCallBackEvent.getReturnData() != null) {
            List datas;
            String[] actions = action.split("\\|");
            int row = Integer.parseInt(actions[1]);
            String keyNum = actions[2];
            String dimNum = actions[3];
            Dimension dim = this.getDimensionByNumber(dimNum.toLowerCase());
            DimensionScope dimensionScope = new DimensionScope(Long.toString(this.getModelId()), dim);
            Map returnMap = (Map)this.deSerializedBytes(String.valueOf(closedCallBackEvent.getReturnData()));
            Object items = returnMap.get("items");
            if (items instanceof List && (datas = (List)items).size() > 0) {
                for (Map m : datas) {
                    dimensionScope.addDimeMemRange(LongUtil.toLong(m.get("id")).longValue(), Integer.parseInt(m.get("scope").toString()), Integer.parseInt(m.get("isexcept").toString()));
                }
            }
            LossCarryScheme lossCarryScheme = this.getLossCarryScheme(row);
            if (keyNum.equals("applyscene")) {
                lossCarryScheme.setApplySceneScope(dimensionScope);
            } else {
                lossCarryScheme.setApplyEntityScope(dimensionScope);
            }
            this.getModel().setValue(keyNum, (Object)dimensionScope.getApplyString(), row);
            this.getModel().setValue("scheme", (Object)ObjectSerialUtil.toByteSerialized((Object)lossCarryScheme), row);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "confirm_save_than_refresh": {
                if (result == MessageBoxResult.Yes) {
                    this.saveData();
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "confirm_save_than_close": {
                if (result == MessageBoxResult.Yes) {
                    this.saveData();
                }
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newvalue = e.getChangeSet()[0].getNewValue();
        int row = e.getChangeSet()[0].getRowIndex();
        if (ObjectUtils.isEmpty((Object)newvalue)) {
            this.changeLossCarryScheme(key, null, row);
        }
    }

    private LossCarryScheme getLossCarryScheme(int index) {
        Object lcs = this.getModel().getValue("scheme", index);
        if (ObjectUtils.isEmpty((Object)lcs)) {
            return new LossCarryScheme(this.getModelId());
        }
        return (LossCarryScheme)ObjectSerialUtil.deSerializedBytes((String)lcs.toString());
    }

    private DimensionScope getDimenScope(DynamicObject dy, String keynumber) {
        String ds = dy.getString("scheme");
        if (StringUtils.isNotEmpty((CharSequence)ds)) {
            LossCarryScheme lossCarryScheme = (LossCarryScheme)ObjectSerialUtil.deSerializedBytes((String)ds);
            if ("applyentity".equals(keynumber)) {
                return lossCarryScheme.getApplyEntityScope();
            }
            if ("applyscene".equals(keynumber)) {
                return lossCarryScheme.getApplySceneScope();
            }
            return (DimensionScope)lossCarryScheme.getSchemeDetails().get(this.getDimensionByNumber(keynumber));
        }
        return null;
    }

    protected Dimension getDimensionByNumber(String keyNumber) {
        return LossCarryScheme.getLossCarryDimCtx((Long)this.getModelId()).getDimensionByField(keyNumber);
    }

    private void changeLossCarryScheme(String key, Object value, int index) {
        LossCarryScheme lossCarryScheme = this.getLossCarryScheme(index);
        if (key.endsWith("after")) {
            Dimension dimension = this.getDimensionByNumber(key.substring(0, key.lastIndexOf("after")));
            if (value != null) {
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)dimension.getEntity());
                dy.set("id", value);
                lossCarryScheme.getAfterDimenSopeInfo().put(dimension, dy);
            } else {
                lossCarryScheme.getAfterDimenSopeInfo().put(dimension, null);
            }
        } else if ("applyscene".equals(key)) {
            lossCarryScheme.setApplySceneScope(null);
        } else if ("applyentity".equals(key)) {
            lossCarryScheme.setApplyEntityScope(null);
        } else {
            Dimension dimension = this.getDimensionByNumber(key);
            lossCarryScheme.getSchemeDetails().put(dimension, value);
        }
        this.getModel().setValue("scheme", (Object)ObjectSerialUtil.toByteSerialized((Object)lossCarryScheme), index);
    }
}

