/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.invest.api.helper.InvRelationSearchHelper;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangeEnum;
import kd.fi.bcm.common.enums.YesOrNoEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.jetbrains.annotations.NotNull;

public class InvChangeAcctExportPlugin
extends AbstractBaseFormPlugin {
    public String export(String routeAppId, String formId, Long modelId, QFilter[] filterParams, Long template, String entityName, String orgnum) throws IOException {
        if (filterParams == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6295\u8d44\u516c\u53f8/\u88ab\u6295\u8d44\u516c\u53f8\u3002", (String)"InvChangeAcctExportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map<String, Map> adjustMap = this.buildAdjustMap();
        QFBuilder qfBuilder = new QFBuilder();
        Arrays.stream(filterParams).forEach(filterParam -> qfBuilder.add(filterParam));
        Object[] arrDimMapping = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])qfBuilder.toArray()).values().toArray(new DynamicObject[0]);
        HashMap<String, String> localeStringMap = new HashMap<String, String>(16);
        if (arrDimMapping.length != 0) {
            Map orgNameByFYAndPeriod = new HashMap();
            DynamicObject cslscheme = null;
            if (formId.equalsIgnoreCase("bcm_invrelation")) {
                cslscheme = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(orgnum), (String)"bcm_cslscheme");
                ArrayList orgnumbers = new ArrayList();
                Arrays.stream(arrDimMapping).forEach(e -> {
                    if (e.get("shareholder") != null && e.get("investeecompany") != null && e.get("orgunit") != null) {
                        orgnumbers.add(((DynamicObject)e.get("shareholder")).getString("number"));
                        orgnumbers.add(((DynamicObject)e.get("investeecompany")).getString("number"));
                        orgnumbers.add(((DynamicObject)e.get("orgunit")).getString("number"));
                    }
                });
                String modelNumber = MemberReader.findModelNumberById((Object)modelId);
                String yearnum = ((DynamicObject)arrDimMapping[0].get("year")).getString("number");
                String periodnum = ((DynamicObject)arrDimMapping[0].get("period")).getString("number");
                long scenarioId = ((DynamicObject)arrDimMapping[0].get("scenario")).getLong("id");
                orgNameByFYAndPeriod = EntityVersioningUtil.getOrgNameByFYAndPeriod((String)modelNumber, orgnumbers, (String)yearnum, (String)periodnum, (Long)scenarioId);
                this.changeRelationTypeCombo(modelId, adjustMap);
            }
            if (formId.equalsIgnoreCase("bcm_invrelation") || formId.equalsIgnoreCase("bcm_dynamicstockratio")) {
                Map temId2Dy = InvRelationSearchHelper.getNewTempId2Dy((Collection)Lists.newArrayList((Object[])arrDimMapping));
                for (Object arr : arrDimMapping) {
                    Pair pair = InvRelationSearchHelper.getTempAndTempNewPair((DynamicObject)arr, (Map)temId2Dy, (arg_0, arg_1) -> InvChangeAcctExportPlugin.lambda$export$2((DynamicObject)arr, modelId, arg_0, arg_1));
                    InvRelationSearchHelper.buildShowTxtAndConfig((Collection)((Collection)pair.p1), (arg_0, arg_1, arg_2) -> InvChangeAcctExportPlugin.lambda$export$3((DynamicObject)arr, arg_0, arg_1, arg_2));
                    InvRelationSearchHelper.buildShowTxtAndConfigNew((Collection)((Collection)pair.p2), (arg_0, arg_1, arg_2) -> InvChangeAcctExportPlugin.lambda$export$4((DynamicObject)arr, arg_0, arg_1, arg_2));
                    if (!formId.equalsIgnoreCase("bcm_invrelation")) continue;
                    String shareholdernumber = arr.getString("shareholder.number");
                    String investeecompanynumber = arr.getString("investeecompany.number");
                    String orgunitnumber = arr.getString("orgunit.number");
                    String shareholderName = (String)orgNameByFYAndPeriod.get(shareholdernumber);
                    String investeecompanyName = (String)orgNameByFYAndPeriod.get(investeecompanynumber);
                    shareholderName = !StringUtils.isBlank((CharSequence)shareholderName) ? shareholderName : arr.getString("shareholder.name");
                    investeecompanyName = !StringUtils.isBlank((CharSequence)investeecompanyName) ? investeecompanyName : arr.getString("investeecompany.name");
                    arr.set("shareholder.name", (Object)shareholderName);
                    arr.set("investeecompany.name", (Object)investeecompanyName);
                    arr.set("orgunit.name", orgNameByFYAndPeriod.get(orgunitnumber));
                    arr.set("cslscheme", (Object)cslscheme);
                    arr.set("invorglnumber", arr.get("orgunit.longnumber"));
                    arr.set("investeelnumber", arr.get("investeecompany.longnumber"));
                    if (!InvRelaTypeEnum.MinRelaType.getType().equals(arr.getString("invrelatype")) && !InvRelaTypeEnum.SameLevelRelaType.getType().equals(arr.getString("invrelatype"))) continue;
                    arr.set("confirmscale", (Object)arr.getBigDecimal("minconfirmscale"));
                }
            }
        }
        if (formId.equalsIgnoreCase("bcm_invrelation")) {
            orgnum = null;
        }
        return this.export((DynamicObject[])arrDimMapping, template, routeAppId, formId, this.genFileName(template, formId, "", orgnum), adjustMap, localeStringMap);
    }

    @NotNull
    private Map<String, Map> buildAdjustMap() {
        HashMap<String, Map> adjustfleds = new HashMap<String, Map>();
        HashMap<String, String> format = new HashMap<String, String>();
        format.put("InputType", "varchar");
        format.put("InputDesc", ResManager.loadKDString((String)"\u6587\u672c", (String)"InvChangeAcctExportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        adjustfleds.put("confirmscale", format);
        adjustfleds.put("equvscale", format);
        adjustfleds.put("minconfirmscale", format);
        adjustfleds.put("sharescale", format);
        return adjustfleds;
    }

    private void changeRelationTypeCombo(Long modelId, Map<String, Map> adjustMap) {
        HashMap<String, JSONArray> objectObjectHashMap = new HashMap<String, JSONArray>();
        JSONArray array = new JSONArray();
        String split = " # ";
        InvRelationTypeHelper.consumeStaticRelationsType((long)modelId, (number, name, isUse) -> array.add((Object)String.join((CharSequence)split, name.getLocaleValue(), number)));
        objectObjectHashMap.put("InputType", array);
        adjustMap.put("invrelatype", objectObjectHashMap);
    }

    @NotNull
    private String export(DynamicObject[] arrDimMapping, Object template, String routeAppId, String formId, String fileName, Map<String, Map> adjustfleds, Map<String, String> localeStringMap) throws IOException {
        String json = SerializationUtils.toJsonString((Object)arrDimMapping);
        JSONArray billArr = JSON.parseArray((String)json);
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject jsonObject = billArr.getJSONObject(i);
            if ("bcm_invsharerela_report".equals(formId)) {
                jsonObject.put("investdategroup", (Object)jsonObject.getString("investdategroup").substring(0, 7));
                boolean isSame = jsonObject.getBoolean("issamemon");
                if (!isSame) {
                    jsonObject.put("invchangetype", null);
                }
                if (jsonObject.get((Object)"invchangetype") != null) {
                    JSONObject tempObject = jsonObject.getJSONObject("invchangetype");
                    String change = tempObject.getString("change");
                    if (ChangeEnum.NoChange.getIndex().equals(change)) {
                        tempObject.put("change", (Object)ChangeEnum.NoChange.getName());
                    } else if (ChangeEnum.Increase.getIndex().equals(change)) {
                        tempObject.put("change", (Object)ChangeEnum.Increase.getName());
                    } else if (ChangeEnum.Decrease.getIndex().equals(change)) {
                        tempObject.put("change", (Object)ChangeEnum.Decrease.getName());
                    } else if (ChangeEnum.Disable.getIndex().equals(change)) {
                        tempObject.put("change", (Object)ChangeEnum.Disable.getName());
                    }
                    jsonObject.put("invchangetype", (Object)tempObject);
                }
                String iscontrol = jsonObject.getString("iscontrol");
                jsonObject.put("iscontrol", (Object)(YesOrNoEnum.Yes.getIndex().equals(iscontrol) ? YesOrNoEnum.Yes.getName() : YesOrNoEnum.No.getName()));
            }
            String names = jsonObject.getString("invelimtemplatenames");
            String numbers = jsonObject.getString("invelimtemplatenumbers");
            if (kd.bos.util.StringUtils.isEmpty((String)names)) continue;
            JSONArray templateObject = jsonObject.getJSONArray("invelimtemplate");
            templateObject.clear();
            String[] numberArr = numbers.split(",");
            String[] nameArr = names.split(",");
            if (numberArr.length != nameArr.length) continue;
            for (int j = 0; j < numberArr.length; ++j) {
                JSONObject row = new JSONObject();
                row.put("number", (Object)numberArr[j]);
                row.put("name", (Object)nameArr[j]);
                row.put("fbasedataid", (Object)row);
                templateObject.add((Object)row);
            }
        }
        return ExportUtil.export((JSONArray)billArr, (Object)template, (String)routeAppId, (String)formId, (String)fileName, adjustfleds);
    }

    public String export(String routeAppId, String formId, Long modelId, QFilter[] filterParams, Long template, String entityName) throws IOException {
        return this.export(routeAppId, formId, modelId, filterParams, template, entityName, null);
    }

    private String genFileName(Long template, String billFormId, String fileNamePrefix, String orgnum) {
        String fileName = fileNamePrefix;
        DynamicObject templateData = null;
        if (template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        }
        if (templateData != null) {
            fileName = fileName + templateData.get("name");
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            fileName = fileName + listEntityType.getDisplayName();
        }
        String orgnumber = orgnum == null ? "" : "_" + orgnum;
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("%s_%02d%02d", orgnumber, now.getMonthValue(), now.getDayOfMonth()) + ".xlsx";
        return fileName;
    }

    private static /* synthetic */ void lambda$export$4(DynamicObject arr, String showTxt, String config, String configNumber) {
        arr.set("effectnewtempnumbers", (Object)configNumber);
        arr.set("effectnewtempnames", (Object)showTxt);
    }

    private static /* synthetic */ void lambda$export$3(DynamicObject arr, String showTxt, String config, String configNumber) {
        arr.set("invelimtemplatenumbers", (Object)configNumber);
        arr.set("invelimtemplatenames", (Object)showTxt);
    }

    private static /* synthetic */ DynamicObject lambda$export$2(DynamicObject arr, Long modelId, Long groupId, String tempNumber) {
        DynamicObject year = (DynamicObject)arr.get("year");
        DynamicObject period = (DynamicObject)arr.get("year");
        if (year == null || period == null) {
            return null;
        }
        long yearId = year.getLong("id");
        long periodId = period.getLong("id");
        return InvSheetTemplateService.queryPeriodUseTempDyByGroupIdAndNumber((Long)groupId, (String)tempNumber, (long)modelId, (long)yearId, (long)periodId);
    }
}

