/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.LongUtil;

public class InvChangeAcctImportPlugin
extends AbstractFormPlugin
implements IImportPlugin {
    private static final String MODEL = "model";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private String modelId;
    private boolean existChangeType;
    private DynamicObject investeecompany;
    private List<Pair<String, Double>> cvtcurrenyid = new ArrayList<Pair<String, Double>>(10);
    private DynamicObject account;
    private DynamicObject changeType;
    private Date changeDate;

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"InvChangeAcctImportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"InvChangeAcctImportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationImport() {
        return ResManager.loadKDString((String)"\u5bfc\u5165", (String)"InvChangeAcctImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        if (!(this.setModel(data, importlogs) && this.setImportInvesteeCompany(data, importlogs) && this.setInvestDate(data, importlogs) && this.setAccountModel(data, importlogs) && (!this.existChangeType || this.setChangeTypeModel(data, importlogs)) && this.setCvtCurrenyid(data, importlogs) && this.setChangeAmount(data, importlogs))) {
            return false;
        }
        return this.invalidate(importlogs);
    }

    private boolean setModel(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        JSONObject modelJson = (JSONObject)data.get(MODEL);
        if (modelJson == null) {
            String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvChangeAcctImportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        String number = (String)modelJson.get((Object)"shownumber");
        QFilter numberFilter = null;
        numberFilter = number != null ? new QFilter("shownumber", "=", (Object)number) : new QFilter("shownumber", "=", modelJson.get((Object)NUMBER));
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        if (model != null) {
            this.modelId = model.getString("id");
            this.existChangeType = MemberReader.isExistChangeTypeDimension((long)Long.parseLong(this.modelId));
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u4f53\u7cfb\u662f\u5426\u8f93\u5165\u6b63\u786e", (String)"InvChangeAcctImportPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        importlogs.add(new ImportLogger.ImportLog(msg));
        return false;
    }

    private Long getModelId() {
        return LongUtil.toLong((Object)this.modelId);
    }

    protected boolean setImportInvesteeCompany(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        this.investeecompany = this.checkBaseData(data, importlogs, "investeecompany", "bcm_entitymembertree");
        if (this.investeecompany != null) {
            if (!this.investeecompany.getBoolean("isindependentorg")) {
                Object number = ((JSONObject)data.get("investeecompany")).get((Object)NUMBER);
                String msg = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u516c\u53f8[%s]\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8", (String)"InvChangeAcctImportPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(String.format(msg, number)));
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean setInvestDate(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        Object cDate = data.get("changedate");
        if (cDate == null) {
            String msg = ResManager.loadKDString((String)"\u53d8\u52a8\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvChangeAcctImportPlugin_31", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        List<String> dateFomats = Arrays.asList("yyyy-MM-dd", ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"InvChangeAcctImportPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), "yyyy/MM/dd", "yy-MM-dd", "yy/MM/dd", ResManager.loadKDString((String)"yy\u5e74MM\u6708dd\u65e5", (String)"InvChangeAcctImportPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        for (String dateFomat : dateFomats) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFomat);
                this.changeDate = sdf.parse((String)data.get("changedate"));
                return true;
            }
            catch (ParseException e) {
                this.changeDate = null;
            }
        }
        String msg = ResManager.loadKDString((String)"\u53d8\u52a8\u65e5\u671f\u4e0d\u6ee1\u8db3\u683c\u5f0f\u8981\u6c42", (String)"InvChangeAcctImportPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        importlogs.add(new ImportLogger.ImportLog(msg));
        return false;
    }

    private boolean setChangeAmount(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        Object changeamount = data.get("changeamount");
        if (data.get("changeamount") == null) {
            String msg = ResManager.loadKDString((String)"\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvChangeAcctImportPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        if (!InvestUtils.checkAmountOutOfRange((BigDecimal)InvestUtils.convertToBigDecimal((Object)changeamount))) {
            importlogs.add(new ImportLogger.ImportLog("\u53d8\u52a8\u91d1\u989d\u6570\u503c\u8d8a\u754c,\u7cbe\u5ea6\u5e94\u4e3a[19,6]"));
            return false;
        }
        return true;
    }

    private boolean setAccountModel(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        JSONObject modelJson = (JSONObject)data.get("account");
        String number = (String)modelJson.get((Object)NUMBER);
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter offsetFilter = new QFilter("accountpart.isaccountoffset", "=", (Object)true);
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        try {
            DynamicObject dimmembMapping = BusinessDataServiceHelper.loadSingle((String)"bcm_accountmembertree", (String)"id,model", (QFilter[])new QFilter[]{modelFilter, numberFilter, offsetFilter});
            DynamicObjectCollection accountNumbers = QueryServiceHelper.query((String)"bcm_invchangeacct", (String)"id", (QFilter[])new QFilter[]{new QFilter("account", "=", dimmembMapping.get("id"))});
            if (accountNumbers.isEmpty()) {
                this.account = this.getDimmembMappingDynamicObject("bcm_invchangeacct");
                this.account.set("account", dimmembMapping.get("id"));
                this.account.set(MODEL, dimmembMapping.get(MODEL));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.account});
            }
            this.account = dimmembMapping;
        }
        catch (NullPointerException e) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6743\u76ca\u79d1\u76ee\u662f\u5426\u6b63\u786e\u3002", (String)"InvChangeAcctImportPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        return true;
    }

    private boolean setChangeTypeModel(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        this.changeType = this.checkBaseData(data, importlogs, "changetype", "bcm_changetypemembertree");
        return this.changeType != null;
    }

    private boolean setCvtCurrenyid(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        HashMap<String, String> markSet = new HashMap<String, String>(16){
            {
                this.put("cvt1currenyid", ResManager.loadKDString((String)"\u6298\u7b97\u5e011", (String)"InvChangeAcctImportPlugin_11", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.put("cvt2currenyid", ResManager.loadKDString((String)"\u6298\u7b97\u5e012", (String)"InvChangeAcctImportPlugin_12", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.put("cvt3currenyid", ResManager.loadKDString((String)"\u6298\u7b97\u5e013", (String)"InvChangeAcctImportPlugin_13", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.put("cvt4currenyid", ResManager.loadKDString((String)"\u6298\u7b97\u5e014", (String)"InvChangeAcctImportPlugin_14", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.put("cvt5currenyid", ResManager.loadKDString((String)"\u6298\u7b97\u5e015", (String)"InvChangeAcctImportPlugin_15", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        };
        ArrayList<String> currency = new ArrayList<String>(10);
        for (int i = 1; i <= 5; ++i) {
            String identity = String.format("cvt%scurrenyid", i);
            try {
                JSONObject currencyJson = (JSONObject)data.get(identity);
                Double rateid = InvestUtils.convertToDouble((Object)data.get("rate" + i + "id"));
                Double changeamount = InvestUtils.convertToDouble((Object)data.get("change" + i + "amount"));
                boolean isCurrenyEmpty = currencyJson == null || currencyJson.get((Object)NUMBER) == null && currencyJson.get((Object)"name") == null;
                boolean isRateEmpty = InvestUtils.isNullDouble((Double)rateid);
                boolean ischangeamountEmpty = InvestUtils.isNullDouble((Double)changeamount);
                if (isCurrenyEmpty && isRateEmpty && ischangeamountEmpty) continue;
                if (isCurrenyEmpty || isRateEmpty) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u6298\u7b97\u5e01%s\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"InvChangeAcctImportPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), i);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                    return false;
                }
                if (!InvestUtils.checkAmountOutOfRange((BigDecimal)InvestUtils.convertToBigDecimal((Object)changeamount))) {
                    importlogs.add(new ImportLogger.ImportLog("\u6298\u7b97\u540e\u53d8\u52a8\u91d1\u989d\u6570\u989d\u8d85\u8fc7\u7cbe\u5ea6[17,4]"));
                    return false;
                }
                if (currency.contains(currencyJson.get((Object)NUMBER) + "")) {
                    importlogs.add(new ImportLogger.ImportLog("\u6298\u7b97\u5e01\u4e0d\u80fd\u76f8\u540c"));
                    return false;
                }
                currency.add(currencyJson.get((Object)NUMBER) + "");
                QFilter[] filters = this.getFilters(data, identity);
                DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bcm_currencymembertree", (String)"id,name", (QFilter[])filters);
                if (temp == null) continue;
                this.cvtcurrenyid.add((Pair<String, Double>)Pair.onePair((Object)temp.getString("id"), (Object)rateid));
                continue;
            }
            catch (Exception e) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9%s\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"InvChangeAcctImportPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), markSet.get(identity));
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
        }
        return true;
    }

    protected DynamicObject checkBaseData(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs, String identity, String entityName) {
        HashMap markSet = new HashMap(){
            {
                this.put("investeecompany", ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvChangeAcctImportPlugin_19", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.put("changetype", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"InvChangeAcctImportPlugin_18", (String)InvChangeAcctImportPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        };
        DynamicObject temp = null;
        QFilter[] filters = this.getFilters(data, identity);
        if (filters == null || filters.length == 0) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvChangeAcctImportPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), markSet.get(identity));
            importlogs.add(new ImportLogger.ImportLog(msg));
            return null;
        }
        if (!this.checkData(data, importlogs)) {
            return null;
        }
        try {
            String select = "id,name,number" + ("investeecompany".equals(identity) ? ",isleaf,currency,isindependentorg" : "");
            temp = BusinessDataServiceHelper.loadSingle((String)entityName, (String)select, (QFilter[])filters);
            JSONObject modelJson = (JSONObject)data.get(identity);
            modelJson.put("id", temp.get("id"));
        }
        catch (NullPointerException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u6b64%s\u662f\u5426\u5b58\u5728\u3002", (String)"InvChangeAcctImportPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), markSet.get(identity));
            importlogs.add(new ImportLogger.ImportLog(msg));
            return null;
        }
        return temp;
    }

    protected QFilter[] getFilters(Map<String, Object> data, String identity) {
        JSONObject modelJson = (JSONObject)data.get(identity);
        if (modelJson == null) {
            return null;
        }
        String number = (String)modelJson.get((Object)NUMBER);
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        if ("investeecompany".equals(identity)) {
            QFilter storageType = new QFilter("storagetype", "=", (Object)StorageTypeEnum.STORAGE.getOIndex());
            return new QFilter[]{modelFilter, numberFilter, storageType};
        }
        return new QFilter[]{modelFilter, numberFilter};
    }

    private boolean invalidate(List<ImportLogger.ImportLog> importlogs) {
        if (this.getModelId() == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"InvChangeAcctImportPlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        if (this.investeecompany == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u88ab\u6295\u8d44\u516c\u53f8\u7f16\u7801\u3002", (String)"InvChangeAcctImportPlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        if (this.account == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u6743\u76ca\u53d8\u52a8\u79d1\u76ee\u7f16\u7801\u3002", (String)"InvChangeAcctImportPlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        return true;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String action = (String)option.get("importtype");
        ArrayList<Object> list = new ArrayList(16);
        switch (action) {
            case "overridenew": {
                list = this.overridenew(data, option, importlogs);
                break;
            }
            case "override": {
                list = this.override(data, option, importlogs);
                break;
            }
            case "new": {
                list = this.addNew(data, option, importlogs);
                break;
            }
        }
        this.cvtcurrenyid.clear();
        JSONObject shareholder = (JSONObject)data.get("investeecompany");
        String number = shareholder.get((Object)NUMBER) + "";
        String name = shareholder.get((Object)"name") + "";
        if (importlogs.size() > 0) {
            OperationLogUtil.writeOperationLog((String)this.getOperationImport(), (String)(number + name + this.getOperationImport() + this.getOperationStstusFail()), (Long)Long.parseLong(this.modelId), (String)"bcm_invsharerelalist");
        } else {
            OperationLogUtil.writeOperationLog((String)this.getOperationImport(), (String)(number + name + this.getOperationImport() + this.getOperationStstusSuccess()), (Long)Long.parseLong(this.modelId), (String)"bcm_invsharerelalist");
        }
        return list;
    }

    private List<Object> addNew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>(10);
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)"id", (QFilter[])this.getUniqueFilters());
        try (TXHandle tx = TX.required();){
            if (temp == null || temp.isEmpty()) {
                DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getDimmembMapping(data, option, importlogs)});
                success.add(sucessIds[0].get("id"));
            } else {
                String msg = ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"InvChangeAcctImportPlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
            }
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(e.getMessage()));
        }
        return success;
    }

    private List<Object> override(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>(10);
        try (TXHandle tx = TX.required();){
            if (this.deleteRepeatData() != 0) {
                DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getDimmembMapping(data, option, importlogs)});
                success.add(sucessIds[0].get("id"));
            } else {
                String msg = ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8986\u76d6\u5931\u8d25\u3002", (String)"InvChangeAcctImportPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
            }
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(e.getMessage()));
        }
        return success;
    }

    private List<Object> overridenew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>(10);
        try (TXHandle tx = TX.required();){
            this.deleteRepeatData();
            DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getDimmembMapping(data, option, importlogs)});
            success.add(sucessIds[0].get("id"));
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(e.getMessage()));
        }
        return success;
    }

    private QFilter[] getUniqueFilters() {
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter accountFilter = new QFilter("account", "=", (Object)this.account.getLong("id"));
        QFilter investeeCompanyFilter = new QFilter("investeecompany", "=", (Object)this.investeecompany.getLong("id"));
        QFilter changeDateFilter = new QFilter("changedate", "=", (Object)this.changeDate);
        QFilter changeTypeFilter = new QFilter("changetype", "=", this.changeType.get("id"));
        return new QFilter[]{modelFilter, investeeCompanyFilter, accountFilter, changeDateFilter, changeTypeFilter};
    }

    public int deleteRepeatData() {
        return DeleteServiceHelper.delete((String)"bcm_invchangeentry", (QFilter[])this.getUniqueFilters());
    }

    private DynamicObject getDimmembMapping(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        DynamicObject dimmembMapping = this.getDimmembMappingDynamicObject("bcm_invchangeentry");
        dimmembMapping.set(MODEL, (Object)this.getModelId());
        dimmembMapping.set("investeecompany", this.investeecompany.get("id"));
        dimmembMapping.set("invcompanycurrency", this.investeecompany.get("currency"));
        dimmembMapping.set("changedate", (Object)this.changeDate);
        if (this.existChangeType) {
            dimmembMapping.set("changetype", this.changeType.get("id"));
        }
        dimmembMapping.set("changeamount", data.get("changeamount"));
        dimmembMapping.set("account", this.account.get("id"));
        dimmembMapping.set("remark", data.get("remark"));
        if (this.cvtcurrenyid != null && !this.cvtcurrenyid.isEmpty()) {
            for (int i = 0; i < this.cvtcurrenyid.size(); ++i) {
                Double rateid = InvestUtils.convertToDouble((Object)this.cvtcurrenyid.get((int)i).p2);
                Double changeamount = InvestUtils.convertToDouble((Object)data.get("changeamount"));
                int Num = i + 1;
                if (rateid == null || this.cvtcurrenyid.get((int)i).p1 == null) continue;
                dimmembMapping.set("cvt" + Num + "currenyid", this.cvtcurrenyid.get((int)i).p1);
                dimmembMapping.set("rate" + Num + "id", (Object)rateid);
                dimmembMapping.set("change" + Num + "amount", (Object)BigDecimal.valueOf(rateid).multiply(BigDecimal.valueOf(changeamount)).setScale(4, 4));
            }
        }
        return dimmembMapping;
    }

    private DynamicObject getDimmembMappingDynamicObject(String entityName) {
        return BusinessDataServiceHelper.newDynamicObject((String)entityName);
    }

    private boolean checkData(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        if (null == data.get("account")) {
            String msg = ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvChangeAcctImportPlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        if (this.existChangeType && null == data.get("changetype")) {
            String msg = ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvChangeAcctImportPlugin_30", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        return true;
    }
}

